      program w0 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                            W 0
c
c  program to compute w0 normal potential in GRS80, and optionally
c  transform from zero tide to the tide-free height system
c
c  input:
c 
c  ifile
c  ofile
c  w0ref, lz2mean
c
c  input file must be ellipsoidal heights and quasigeoid
c  w0ref is the reference w0 (u0 = 62636860.85 for GRS80)
c  lz2mean = t will correct from zero tide to mean tide heights
c
c  (c) Rene Forsberg, DTU Space, Jan 2019
c  updated Nov 2022 (gamma change)
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit double precision(a-h,o-z)
      character*36 ifile,ofile
      logical lz2mean
      write(*,2)
2     format(' input: ifile / ofile / w0ref,lz2mean ')
      read(*,3) ifile
      read(*,3) ofile
      read(*,*) w0ref, lz2mean
3     format(a36)
      open(10,file=ifile,status='old')
      open(20,file=ofile,status='unknown')
      radeg = 180/3.1415926536d0
c
c  GRS80 constants
c
      e = 521854.0097d0
      gm = 3986005.0d8
      a = 6378137d0
      b = 6356752.3141d0
      omega = 7292115d-11
      u0 = 62636860.85d0
c          
      write(20,*) '   no       rlat        rlon     h_ell',
     .'    z_GRS80     z_w0   pot_GRS80     pot_W0'  
      k = 0
      sumc = 0
5  	read(10,*,end=50) i,rfi,rla,rh,zeta
c
c  ellipsoidal height transformation
c  see wellenhof-moritz 6-7 and 6-8
c
      call ctg(rfi/radeg,rla/radeg,rh,x,y,z,1,1,.false.,.true.)
      e2 = e**2
      xyze2 = x**2+y**2+z**2-e2
      u2 = xyze2*(1+sqrt(1+4*e2*z**2/xyze2**2))/2
      u = sqrt(u2)
      beta = atan(z*sqrt(u2+e2)/(u*sqrt(x**2+y**2)))
c
      q = ((1+3*u2/e2)*atan(e/u) - 3*u/e)/2
      q0 =((1+3*b**2/e2)*atan(e/b) - 3*b/e)/2  
      upot = gm/e*atan(e/u)+omega**2/2*a**2*q/q0*(sin(beta)**2-1/3.d0)
     .       + omega**2/2*(u2+e**2)*cos(beta)**2
c
c  convert to reference W0 (conventional value 62636853.4) - ref Yan Wang
c            
      gamma = grav80(rfi,rh-zeta)*1.d-5
      w_grs80 = upot + zeta*gamma
      c = -(w0ref-u0)/gamma
      zeta_w0 = zeta + c
      sumc = sumc + c
      w_w0 = upot + zeta_w0*gamma      
c
c  convert to mean tide - ref. J. Makinen, 2008
c
      if (lz2mean) then
        sinfi = sin(rfi/radeg)
        wcoor = (-288.41*sinfi**2-1.95*sinfi**4+97.22)/1000
        w_w0 = w_w0 + wcoor
        zeta_w0 = zeta_w0 - wcoor/gamma
      endif
      write(20,6) i,rfi,rla,rh,zeta,zeta_w0,w_grs80,w_w0
6     format(' ',i6,2f12.5,f9.3,' ',2f9.3,2f13.2)
      k = k+1
      goto 5
c
50    write(*,51) k, w0ref, sumc/k
51    format(' points: ',i5,', w0:',f13.2,', zeta_w0 offset: ',f6.3)
      if (lz2mean) write(*,52) wcoor/gamma
52    format(' - makinen tide-free correction applied (last,m):',f7.3)
      end
c
      subroutine ctg(x1,x2,x3,y1,y2,y3,iell,idatum,ldir,lcheck) 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                           c t g
c
c  Dual autochecking transformation procedure cartesian to
c  geographic coordinates or reverse. The cartesian system
c  is righthanded with z-axis towards the mean pole and
c  x-axis intersecting the Greenwich meridian. The geographic
c  coordinates are latitude (1), longitude (2) and height
c  above the ellipsoid (3).
c  The subroutine may also do a datum transformation, with
c  the geographical coordinates assumed to be in a specified
c  system in either input or output (XYZ always assumed WGS84)
c
c  parameters:
c
c  ldir = true:  cartesian -> geographic
C  ldir = false: geographic -> cartesian
c
c  x1, x2, x3:   input coordinates
c                (ldir = .true.: X, Y, Z in meter,
c                 ldir = .false.: lat, lon in radians, H in m)
c
c  y1, y2, y3:   output coordinates
c
c  iell:         ellipsoid used in transformation  
c                1  grs80  ellipsoid
c                2  hayford ellipsoid
c                3  nad27 ellipsoid
c                4  bessel ellipsoid
c                5  NWL9D ellipsoid
c
c  idatum:       datum transformation 
c                1  none, XYZ and fi,la,H in same system
c                2  XYZ in WGS84, fi,la,H in ED50
c                3       do     , fi,la,H in NAD27
c                4       do     , fi,la,h in Qornoq Greenland datum
c                5  XYZ in NWL9D, fi,la,h in WGS84
c
c  lcheck:       if true check by reverse transformation
c
c  RF, august 1981.
c  Procedure based on older KP procedures 'trctg' and 'trgtc'
c  Datum shift constants from 'setddatcon' algol procedure
c  Fortran version by RF dec 1990
c  (c) Rene Forsberg, Kort- og Matrikelstyrelsen, Denmark
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit double precision(a-h, o-z)
      logical ldir, lcheck
c
c  ellipsoid and datum shift parameters
c   
      dimension aa(5),ff(5),dx(5),dy(5),dz(5),sc(5),rot(5)
c
c       WGS84        Hayford      Clarke      Bessel          NWL9D
      data aa /
     .6378137.0d0, 6378388.0d0, 6378206.4d0, 6377397.155d0, 6378145.0d0/
      data ff / 
     .298.2572236d0, 297.0d0, 294.9786982d0, 299.153d0,     298.25d0/
c
c  datumshifts:
c  2: ED50->WGS84   Ref: Report of an investigation into the use of doppler
c                   satellite positioning to provide coordinates on ED50 in the
c                   area of the North Sea. Prof. Papers new series no 30, 1981.
c                   Followed by DMA NWL9D to WGS84
c  3: NAD27->WGS84  Ref: DMA World Geodetic System 1984 report (CONUS value)
c  4: Qornoq->WGS84 Ref: Anderle 1976, table 7 converted to WGS84, as KMS
c  5: WGS84->NWL9D  Ref: Definition of WGS 84, DMA; Letter from DMA june 1985
c
c               (1)         (2)      (3)     (4)          (5) 
c
      data dx / 0.d0,    -89.5d0,  -8.d0, 163.511d0,      0.d0/  
      data dy / 0.d0,    -93.8d0, 160.d0, 127.553d0,      0.d0/ 
      data dz / 0.d0,   -123.1d0, 176.d0,-159.789d0,    -4.5d0/
      data sc / 0.d0,     1.2d-6,   0.d0,   -0.6d-6,    0.6d-6/
      data rot/ 0.d0,  .75629d-6,   0.d0,-3.9464d-6, 3.9464d-6/
c
      if (iell.lt.1.or.iell.gt.5) stop 'undefined ellipsoid in ctg'
      if (idatum.lt.0.or.idatum.gt.5) stop 'undefined datum in ctg'
      a = aa(iell)
      f = 1/ff(iell)
      f1 = 1-f
      e2 = f*(2-f)  
      em2 = 1.0/f1**2-1 
      c = a/f1
      x1in = x1
      x2in = x2
      x3in = x3  
c
      if (ldir) then
        j = 1
        k = 3
        l = 1
      else
        j = 3  
        k = 1
        l = -1
      endif
      do 50 i = j,k,l
        goto (10,20,30),i
c
c  case 1 - cart->geo 
c
10      if (idatum.gt.1) then
          xx1 = x1in
          x1in = x1in - (dx(idatum)+sc(idatum)*x1in+rot(idatum)*x2in)
          x2in = x2in - (dy(idatum)+sc(idatum)*x2in-rot(idatum)*xx1)       
          x3in = x3in - (dz(idatum)+sc(idatum)*x3in)
        endif  
        p = sqrt(x1in**2+x2in**2)
        rla = atan2(x2in, x1in)
        fi = 0
        w = 0  
        nc = 0
c  repeat loop
12        fi1 = fi  
          fi = atan2(x3in+w, p)
          h = sqrt((x3in+w)**2 + p**2)
          sinfi = sin(fi)
          cos2fi = 1-sinfi**2
          w = c/sqrt(1+em2*cos2fi)*e2*sinfi
          nc = nc+1
          if (abs(fi-fi1).gt.1.0e-9.and.nc.lt.10) goto 12
        x1in = fi
        x2in = rla
        x3in = h - c/sqrt(1+em2*cos2fi)
        goto 50
c 
c  case 2 - dump of result 
c
20      y1 = x1in  
        y2 = x2in  
        y3 = x3in  
        if (.not.lcheck) return
        goto 50
c    
c  case 3 - geo->cart
c
30      cosfi = cos(x1in)        
        sinfi = sin(x1in)
        rn = c/sqrt(1+em2*cosfi**2)
        w = (rn + x3in)*cosfi  
        x1in = w*cos(x2in)  
        x2in = w*sin(x2in)  
        x3in = (rn - rn*e2 + x3in)*sinfi  
        if (idatum.gt.1) then
          xx1 = x1in
          x1in = x1in + (dx(idatum)+sc(idatum)*x1in+rot(idatum)*x2in)
          x2in = x2in + (dy(idatum)+sc(idatum)*x2in-rot(idatum)*xx1)
          x3in = x3in + (dz(idatum)+sc(idatum)*x3in)
        endif  
50    continue   
c
c  tolerance check of results - 2 mm on earth
c
      if (ldir) then
        if (abs(x1-x1in).gt.0.002.or.abs(x2-x2in).gt.0.002.or.
     .  abs(x3-x3in).gt.0.002) write(*,60) x1,x2,x3,
     .  x1-x1in,x2-x2in,x3-x3in
60      format(' *** cart to geo transformation check - error too big:'/
     .  ' X Y Z = ',3f10.1,'  dX dY dZ = ',3f12.3) 
      else
        if (abs(x1-x1in)*6371000.gt.0.002.or.
     .  abs(x2-x2in)*6371000*cosfi.gt.0.002.or.
     .  abs(x3-x3in).gt.0.002) write(*,61) x1*57.29578,x2*57.29578,x3,
     .  (x1-x1in)*6371000,(x2-x2in)*6371000,x3-x3in
61      format(' *** geo to cart transformation check - error too big:'
     .  /' fi la h = ',3f9.4,'  dX dY dZ = ',3f12.3) 
      endif
      return
      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                              g r a v 8 0
c
c     (c) copyright dag solheim, statens kartverk, n-3500 hoenefoss, norway
c     rlat in degrees and height in meters
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      real*8 function grav80 (rlat,height)
      implicit none
      real*8 rlat,h,h1,height,s2
      h=dsin(rlat/57.29577951d0)
      s2=h*h
      h=(7.2651d-8*height+4.38983d-4*s2-0.308779814d0)*height
      h1=(((7.0d-10*s2+1.262d-7)*s2+2.32718d-5)*s2+5.2790414d-3)*s2+1.0
      grav80 = h + 978032.67715d0*h1
      return
      end
