      PROGRAM POINTMASS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C            P O I N T M A S S
C
C  PROGRAM FOR GENERATING A GRID OF POINT MASS GRAVITATIONAL
C  EFFECTS.
C
C  INPUT:
C
C  <OUTPUTFILE>,
C  NP, KIND, IFORM,
C  RFI(1), RLA(1), D(1), G(1),
C  RFI(2), RLA(2), D(2), G(2),
C  ........
C  RFI1, RFI2, RLA1, RLA2, DFI, DLA (GRADER), H
C
C  WHERE NP IS THE NUMBER OF POINT MASSES, EACH SPECIFIED BY
C  RFI, RLA: LATITUDE AND LONGITUDE IN DEGREES,
c  H: height of computation in km
C  D: DEPTH IN KM, G: PEAK ANOMALY IN MGAL AT SURFACE FROM MASS.
C  KIND: 1 GEOID, 2 GRAVITY, 3 KSI, 4 ETA
C  IFORMAT: 1 GRID FORMAT, 2 DATALINE FORMAT (ON OUTPUT)
C  LAST INPUT LINE SPECIFIES WANTED GRID.
C
C  RF, JUNE 1986, MODIFIED FOR NORSK DATA OCT 87
c  modified aug 2006, rf
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION D(100),G(100),PFI(100),PLA(100),RES(1000)
      CHARACTER ONAME*36
C
      READ(*,1) ONAME
1     format(a36)
      OPEN (30,FILE=ONAME,STATUS='UNKNOWN')
C
      RADEG = 57.29578
      DEGKM = 111.2
C
      READ(*,*) NP,KIND,IFORM
      DO 10 I = 1, NP
10    READ(*,*) PFI(I), PLA(I), D(I), G(I)
      READ(*,*) RFI1, RFI2, RLA1, RLA2, DFI, DLA, H
C
C  OUTPUT GRID LABEL
C
      NN = (RFI2-RFI1)/DFI + 1.5
      NE = (RLA2-RLA1)/DLA + 1.5
      RFI2 = RFI1 + (NN-1)*DFI
      RLA2 = RLA1 + (NE-1)*DLA
      IF (IFORM.EQ.1) WRITE(30,20) RFI1,RFI2,RLA1,RLA2,DFI,DLA
20    FORMAT(' ',4F12.6,2F12.7,/)
C
      COSFI = COS((RFI1+RFI2)/2/RADEG)
      WRITE(*,30) NP, NN, NE
30    FORMAT(' --- P O I N T M A S S ---',
     */' NUMBER OF MASSES:',I4,', WANTED GRID POINTS:',2I6)
      GOTO (31,33,36,37),KIND
31    WRITE(*,41)
      GOTO 39
33    WRITE(*,43)
      GOTO 39
36    WRITE(*,46)
      GOTO 39
37    WRITE(*,47)
39    CONTINUE
41    FORMAT(' GEOID COMPUTATION - UNIT: METER')
43    FORMAT(' GRAVITY COMPUTATION - MGAL')
46    FORMAT(' N-S DEFLECTION - ARCSEC')
47    FORMAT(' E-W DEFLECTION - ARCSEC')
C
C  SCAN THROUGH ALL POINTS IN GRID
C  -------------------------------
C
      RMAX = -99999.9
      RMIN = 99999.9
      II = 0
      DO 80 I = NN, 1, -1
      DO 70 J = 1, NE
        RFI = (I-1)*DFI + RFI1
        RLA = (J-1)*DLA + RLA1
        II = II+1
        SUM = 0
        DO 60 K = 1, NP
          Y = (RFI-PFI(K))*DEGKM
          X = (RLA-PLA(K))*DEGKM*COSFI
          F = G(K)*D(K)**2
          z = d(k)+h
          R = SQRT(X**2 + Y**2 + z**2)
          IF (KIND.EQ.1) GOTO 53
          IF (KIND.EQ.3) GOTO 56
          IF (KIND.EQ.4) GOTO 57
C
C  GRAVITY, MGAL
C
          SUM = SUM + F*z/R**3
          GOTO 58
C
C  GEOID, METER
C
53        SUM = SUM + .00102*F/R
          GOTO 58
C
C  N-S DEFLECTION, ARCSEC
C
56        SUM = SUM + F*Y/R**3/4.85
          GOTO 58
C
C  E-W DEFLECTION, ARCSEC
C
57        SUM = SUM + F*X/R**3/4.85
58        CONTINUE
60      CONTINUE
        IF (IFORM.EQ.2) WRITE(30,62) II,RFI,RLA,SUM
62      FORMAT(' ', I6, 2F12.6, '   0.0 ',F9.2)
        RES(J) = SUM
        IF (SUM.LT.RMIN) RMIN = SUM
        IF (SUM.GT.RMAX) RMAX = SUM
70    CONTINUE
      IF (IFORM.EQ.1) WRITE(30,75) (RES(J),J=1,NE)
75    FORMAT(/,30(1X,7F10.4,/))
80    CONTINUE
C
      WRITE(*,90) RMIN, RMAX
90    FORMAT(' MINIMAL AND MAXIMAL EFFECTS: ',2F12.6)
C
      END
