      program harmexp
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                         h a r m e x p
c
c  program for computing grid of geoid, gravity and deflections from
c  a high degree and order spherical harmonic expansion, using 'gpotdr'.
c  output will be in three files (geoid, gravity and ksi/eta) in units
c  of m, mgal, and arcsec, respectively, in standard grid format.
c  "gravity" is either gravity anomaly or gravity disturbace (grace grid only)
c
c  input:
c
c  coefficient file name,
c  ifmt, irefsys, nmax, lgrid
c
c  ifmt format of coefficients
c       1  binary (from potbin)
c       2  text, free format
c       3  text, grace format
c       4  text, grace multiple files (coefficient file name is list of files)
c
c  irefsys determines a and gm coefficients:
c      -1  only sum from J2 (set J2 to zero)
c       0  only sum from J2 (use J2-wgs84 J2)
c       1  egm2008 with wgs84 normal field 
c       2  eigen-6c4 with wgs84 normal field
c       3  utexas grace with wgs84 normal field
c
c  * additional input, lgrid = true (grid computation):
c
c  geoidfile,
c  gravityfile,
c  deflectionfile,
c  fi1, fi2, la1, la2, dfi, dla (degrees), h (m)
c
c  file name 'dummy' or '0' ensures no data of that kind is written.
c  grace special: if ifmt=3 or 4 then the gravity grid is gravity disturbance
c
c  * lgrid false (point computation):
c
c  pointfile
c  outputfile
c  kind, omode
c
c  where kind =  1: geoid
c                2: gravity
c                3: deflections
c
c        omode = 0: list computed values
c                1: list difference (pointfile - ref.field.)
c                2: list sum (pointfile + ref.field.)
c
c  modification of program from d. arabelos, university of thessaloniki,
c  nov 88, rf. original subroutines from tscherning and goad.
c  modified and updated, university of new south wales vax, feb 89
c  modified nov 2002,rf  (gnu fortran, last binary coeff must be nmax,nmax)
c           dec 2003,rf  (normal gravity field error update)
c           june 2004,rf (grace coefficients)
c           oct 2007, rf (multiple grace files and grace disturbance)
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
      character*72  oname1,oname2,oname3,sname,sname1
      dimension ar1(6000), ar2(6000), ar3(6000)
      dimension sr1(4),sr2(4),sq1(4),sq2(4),sd1(4),sd2(4)
      logical lgrid,lun,ldg,ldfv
      logical init
      logical first
      integer oldord
      real*4 c,c0
      common/gpotcm/oldt,oldr,iz,first,oldord,i1,i2,i3,i4,
     *i5,i6,i7,i8,i9,nmaxsv
      common/pot1cm/su(3610),djn(20),gm,flat,ae,omega,init,iorder,
     *nmax,negn,gm80,ae80
      common/pidtr/pi,dtr
      common/trancm/tol,maxit
      common/cm/c20in,g1(3),g2(3,3),cm3,cm2,cm1,c0,c(130320)
c
      read(*,111) sname
      read(*,*) ifmt,irefsys,nmax,lgrid
      read(*,111) oname1
      read(*,111) oname2
      if (ifmt.eq.4) open(9,file=sname)
c      	
      if (.not.lgrid) read(*,*) kind, iomode
      if (.not.lgrid) goto 500
c
      read(*,111) oname3
 111  format(a72)
c
      lun = .true.
      ldg = .true.
      ldfv = .true.
      if (oname1.eq.'dummy'.or.oname1.eq.'0') lun = .false.
      if (oname2.eq.'dummy'.or.oname2.eq.'0') ldg = .false.
      if (oname3.eq.'dummy'.or.oname3.eq.'0') ldfv = .false.
c
      read(*,*) phi1,phi2,dla1,dla2,dphi,ddla,ht
      if (lun) open(20,file=oname1,status='unknown')
      if (ldg) open(21,file=oname2,status='unknown')
      if (ldfv) open(22,file=oname3,status='unknown')
      if (ldfv) open(23,status='scratch',form='unformatted')
c
      nn = (phi2-phi1)/dphi + 1.5
      ne = (dla2-dla1)/ddla + 1.5
      if (ne.gt.6000) stop '** increase ar array **'
      phi2 = phi1 + (nn-1)*dphi
      dla2 = dla1 + (ne-1)*ddla
c
c  multiple file loop - init values (block data)
c  ---------------------------------------------
c
10    init = .true.
      iz = 0
      first = .false.
      oldt = 0.d0
      oldr = 0.d0
      oldord = 0
      i1 = 0
      i2 = 0
      i3 = 0
      i4 = 0
      i5 = 0
      i6 = 0
      i7 = 0
      i8 = 0
      i9 = 0
      nmaxsv = 0
      iorder = 1
c
      if (ifmt.eq.4) then
        read(9,111,end=999) sname1
        write(*,*)
      else
        sname1 = sname
      endif
c
      write(*,50) nmax,irefsys,sname1
50    format(' --- HARMEXP, spherical harmonic grid computation ---',/,
     .' max degree: ',i3,', irefsys:',i2/' coefficient file: ',a72)
      write(*,51) phi1,phi2,dla1,dla2,dphi,ddla,ht,nn,ne,nn*ne
51    format(' grid: ',6f10.4,', h: ',f9.0,/,
     .' points north:',i4,', east:',i4,', total:',i7)
c
c  output labels on grids
c
      if (lun) write(20,100) phi1,phi2,dla1,dla2,dphi,ddla
      if (ldg) write(21,100) phi1,phi2,dla1,dla2,dphi,ddla
      if (ldfv) write(22,100) phi1,phi2,dla1,dla2,dphi,ddla
100   format(/' ',4f12.5,2f12.8,/)
c
      call stini(n,sd1)
      call stini(n,sd2)
      call stini(n,sr1)
      call stini(n,sr2)
c
      do 1 i = nn, 1, -1
        phi = phi1+(i-1)*dphi
        do 2 j = 1, ne
          dla = dla1+(j-1)*ddla
          call pot1(phi,dla,ht,un,xi,eta,dist,dgp,sname1,irefsys,ifmt)
          call stadd(un,sd1)
c  grace 
          if (ifmt.ge.3) dgp = dist
          call stadd(dgp,sd2)
          call stadd(xi,sr1)
          call stadd(eta,sr2)
          ar1(j) = un
          ar2(j) = dgp
          ar3(j) = xi
          if (ldfv) write(23) eta
2       continue
        if (lun) write(20,114) (ar1(j),j=1,ne)
        if (ldg) write(21,114) (ar2(j),j=1,ne)
        if (ldfv) write(22,114) (ar3(j),j=1,ne)
114     format(/,60(' ',7f10.4,/))
1     continue
c
c  output eta results after ksi from scratch file unit 23
c
      if (.not.ldfv) goto 250
      rewind(23)
      write(22,100) phi1,phi2,dla1,dla2,dphi,ddla
      do 200 i = nn,1,-1
        do 201 j = 1,ne
201     read(23) ar3(j)
        write(22,114) (ar3(j),j=1,ne)
200   continue
c
250   n = nn*ne
      call stsig(n,sd1)
      call stsig(n,sd2)
      call stsig(n,sr1)
      call stsig(n,sr2)
      if (ifmt.le.2) then
        write(*,300) (sd1(j),j=1,4),(sd2(j),j=1,4),
     .  (sr1(j),j=1,4),(sr2(j),j=1,4)
      else
        write(*,301) (sd1(j),j=1,4),(sd2(j),j=1,4),
     .  (sr1(j),j=1,4),(sr2(j),j=1,4)
      endif
300   format(/' mean, std.dev., min, max of computed values: '/,
     .' geoid:   ',4f9.2,/' gravity: ',4f9.2,/,
     .' ksi:     ',4f9.2,/' eta:     ',4f9.2)
301   format(/' mean, std.dev., min, max of computed values: '/,
     .' geoid:   ',4f9.2,/' gdistur: ',4f9.2,/,
     .' ksi:     ',4f9.2,/' eta:     ',4f9.2)
      goto 998
c
c  point values
c
500   write(*,501) nmax,sname1
501   format(' --- harmexp, spherical harmonic point computation ---',/,
     .' max degree: ',i3/' coefficient file: ',a72)
502   write(*,503) oname1, oname2
503   format(' computation points from file: ',a36,
     ./' output to file: ',a36)
      if (kind.eq.1) write(*,504)
      if (kind.eq.2) write(*,505)
      ldfv = (kind.eq.3)
      if (ldfv) write(*,506)
504   format(' - geoid undulations in grs80 -')
505   format(' - gravity anomalies grs80 -')
506   format(' - deflections in grs80 -')
      if (iomode.eq.1) write(*,507)
507   format(' - difference observed minus ref output -')
      if (iomode.eq.2) write(*,508)
508   format(' - sum observed plus ref output -')
c
      open(20,file=oname1,status='old')
      open(21,file=oname2,status='unknown')
c
      call stini(np,sr1)
      if (ldfv) call stini(np,sr2)
      call stini(np,sq1)
      if (ldfv) call stini(np,sq2)
      call stini(np,sd1)
      if (ldfv) call stini(np,sd2)
c
550   if (iomode.eq.0) then
        read(20,*,end=590) istat,rfi,rla,rh
        d1 = 0
        if (ldfv) d2 = 0
      elseif (.not.ldfv) then
        read(20,*,end=590) istat,rfi,rla,rh,d1
      else
        read(20,*,end=590) istat,rfi,rla,rh,d1,d2
      endif
      if (abs(rfi).gt.91.or.abs(rla).gt.361) stop 'coor error'
c
      call pot1(rfi,rla,rh,un,xi,eta,dist,dgp,sname,irefsys,ifmt)
c
      if (kind.eq.1) r1 = un
      if (kind.eq.2) r1 = dgp
      if (ldfv) r1 = xi
      if (ldfv) r2 = eta
      goto (520,521,522),iomode+1
520   q1 = r1
      if (ldfv) q2 = r2
      goto 523
521   q1 = d1 - r1
      if (ldfv) q2 = d2 - r2
      goto 523
522   q1 = d1 + r1
      if (ldfv) q2 = d2 + r2
523   np = np+1
      call stadd(d1,sd1)
      call stadd(r1,sr1)
      call stadd(q1,sq1)
      if (ldfv) call stadd(d2,sd2)
      if (ldfv) call stadd(r2,sr2)
      if (ldfv) call stadd(q2,sq2)
c
      if (.not.ldfv) write(21,555) istat,rfi,rla,rh,q1
      if (ldfv) write(21,555) istat,rfi,rla,rh,q1,q2
555   format(' ',i6,2f11.5,f9.2,2f9.2)
      goto 550
c
590   call stsig(np,sd1)
      call stsig(np,sr1)
      call stsig(np,sq1)
      if (ldfv) call stsig(np,sd2)
      if (ldfv) call stsig(np,sr2)
      if (ldfv) call stsig(np,sq2)
      write(*,591) np,(sd1(j),j=1,4),(sr1(j),j=1,4),(sq1(j),j=1,4)
591   format(/' number of computed points: ',i6,
     ./' orig data mean std.dev. min max = ',4f9.2,
     ./' ref field mean std.dev. min max = ',4f9.2,
     ./' output    mean std.dev. min max = ',4f9.2)
      if (.not.ldfv) goto 998
      write(*,592) (sd2(j),j=1,4),(sr2(j),j=1,4),(sq2(j),j=1,4)
592   format(/' second component (eta): ',
     ./' orig data mean std.dev. min max = ',4f9.2,
     ./' ref field mean std.dev. min max = ',4f9.2,
     ./' output    mean std.dev. min max = ',4f9.2)
998   continue
c
      if (ifmt.eq.4) goto 10
999   continue
      end
c
c  block data
c  -----------
c
      block data
      implicit real*8(a-h,o-z)
      logical first,init
      integer oldord
      real*4 c,c0
      common/gpotcm/oldt,oldr,iz,first,oldord,i1,i2,i3,i4,
     *i5,i6,i7,i8,i9,nmaxsv
      common/pot1cm/su(3610),djn(20),gm,flat,ae,omega,init,iorder,
     *nmax,negn,gm80,ae80
      common/pidtr/pi,dtr
      common/trancm/tol,maxit
      common/cm/c20in,g1(3),g2(3,3),cm3,cm2,cm1,c0,c(130320)  
      data djn/20*0.d0/
      data pi/3.141592653589793d0/
      data dtr /.1745329251994330d-1/
      data tol/1.d-14/,maxit/10/
      end
c
c  statistics subroutines:
c  stini: initialization
c  stadd: update with new obs
c  stsig: convert to mean and std.dev. in s(1) and s(2)
c
      subroutine stadd(r, s)
      implicit real*8(a-h,o-z)
      dimension s(4)
      s(1) = s(1) + r
      s(2) = s(2) + r**2
      if (r.lt.s(3)) s(3) = r
      if (r.gt.s(4)) s(4) = r
      return
      end
c
      subroutine stini(n, s)
      implicit real*8(a-h,o-z)
      dimension s(4)
      n = 0
      s(1) = 0.0
      s(2) = 0.0
      s(3) = 9999.99
      s(4) = -9999.99
      return
      end
c
      subroutine stsig(n, s)
      implicit real*8(a-h,o-z)
      dimension s(4)
      if (n.le.1) s(2) = -1.0
      if (n.gt.1) s(2) = sqrt((s(2) - s(1)**2/n)/(n-1))
      if (n.gt.0) s(1) = s(1)/n
      return
      end
c
      subroutine 
     .pot1(phi,dlon,ht,un,xi,eta,dist,dgp,sname,irefsys,ifmt)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                             p o t 1
c
c     this subroutine calls gpotdr to obtain height anomaly,
c     deflections of the vertical,and gravity disturbance
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h,o-z)
      real*4 c,c0
      logical init
      character*72 sname
      dimension p(6)
      common/pidtr/pi,dtr
      common/pot1cm/su(3610),djn(20),gm,flat,ae,omega,init,iorder,
     *nmax,negn,gm80,ae80
      common/cm/c20in,g1(3),g2(3,3),cm3,cm2,cm1,c0,c(130320)
c
c     input
c
c     phi latitude (geodetic) in degrees
c     dlon longitude in degrees
c     ht height in meters
c
c     output
c
c     un height anomaly in meters
c     xi n-s deflection in sec of arc
c     eta e-w deflection in seconds of arc
c     dist gravity disturbance in mgals
c
c     first time initialize
      if(.not.init) go to 500
      init=.false.
c     pass negative of nmax since this program uses quasi-normalized
c     coefficients - see subroutines setcm and gpotdr
      negn=-nmax
c
c     set constants (grs80)
c     ---------------------
c
      djn(2)=0.00108263d0
      omega=7.292115d-5
c 
      ae80=6378137.d0
      gm80=3.986005d+14
c 
      if (irefsys.le.0) then
        ae = ae80
        gm = gm80
      elseif (irefsys.eq.1) then
c  egm96/2008
        ae = 6378136.3d0
        gm = 3.986004415d+14
      elseif (irefsys.eq.2) then
c  champ/eigen-6c4
        ae = 6378136.46d0
        gm = 3.986004415d+14
      elseif (irefsys.eq.3) then
c  grace utexas
        ae = 6378136.3d0
        gm = 3.986004415d+14
      else
        write(*,*) irefsys
        stop '*** irefsys wrong value ***'
      endif
c
c     obtain flattening of reference ellipsoid to be used later when
c     transforming from geodetic lat,lon,ht,to ecg x,y,z
      call refval(ae80,gm80,djn(2),omega,flati)
      flat=1.d0/flati
c
      capesq=ae80**2*(2.d0-flat)*flat
      esq=capesq/ae80**2
c     compute normal even zonals from 4 to 20
c     see 'physical geodesy',heiskanen and moritz,page 73
      do 200 n2=4,20,2
      n=n2/2
      djn(n2)=(-1.d0)**(n+1)*3.d0/(n2+1.d0)*esq**n/(n2+3.d0)*
     *(1.d0-(1.d0-5.d0*djn(2)/esq)*n)
  200 continue
c
      cm3=gm
      cm2=ae
      cm1=0.d0
      c0=0.e0
      do 300 i=1,32760
      c(i)=0.e0
  300 continue
      call loadcs(nmax,sname,ifmt)
c
c     compute delc20 in double precision before storing in single
c     precision rather than storing in single precision and then
c     differencing
      delc20=c20in+djn(2)/dsqrt(5.d0)
      if (irefsys.eq.-1) delc20 = 0
      call storc(2,0,delc20,0.d0)
      call storc(1,0,0.d0,0.d0)
      call storc(1,1,0.d0,0.d0)
c
      write(*,20) ae,gm,-c20in*dsqrt(5.d0)
   20 format(/' reference values of coef ellipsoid a gm j2 '/,
     *1x,f12.2,2g17.9)
c
c     now subtract off grs80 even zonal harmonics (j2 already done)
c     to get anomalous potential for height anomaly and
c     derivative computations
      do 400 n=4,20,2
c     normalize zonals of normal potential before subtracting
      dnj=djn(n)/dsqrt(n+n+1.d0)
      call modc(n,0,dnj,0.d0)
  400 continue
      call setcm(nmax)
c
c     convert from geodetic to earth-centered-fixed x,y,z coordinates
  500 call tranf(1,phi,dlon,ht,x,y,z,ae80,flat)
c
c     set up input array to gpotdr
c
      p(1)=dsqrt(x**2+y**2)
      p(2)=dsqrt(x**2+y**2+z**2)
      p(3)=z/p(2)
      p(4)=p(1)/p(2)
      p(5)=y/p(1)
      p(6)=x/p(1)
c
      tp=gpotdr(p,negn,iorder,su)
      call normal (gm80,djn,ae80,omega,x,y,z,up,gamma,grad)
c
      rr = ae80+ht 
c     height anomaly in meters
      un=tp/gamma + (gm-gm80)/rr/gamma
c
c     deflections of the vertical in sec of arc
c     n-s
      xi=-g1(1)*206264.8d0/gamma
c     e-w
      eta=-g1(2)*206264.8d0/gamma
c
c     gravity disturbance in milligals
      dist= (-g1(3) + (gm-gm80)/rr**2)*1.d+05
c     gravity anomaly in milligal
      dgp = dist - 2.d+05*tp/p(2) - (ae-ae80)*0.3086d0 
      return
      end
c
      function gpotdr (po,nmax,order,su)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                        g p o t d r
c
c     gi reg.no.81013author-c.c.tscherning,danish geodetic institute
c                                      july 1981 in algol ref.(2)
c                          -c,c.goad,noaa/nos/national geodetic survey
c                                    may 1982 translated to fortran
c     refereces
c     (1) tschrning, c.c. on the chain-rule method for computing
c     potential derivatives. manuscripta geodaetica, vol.1,
c     pp. 125-141, 1976
c
c     (2) tscherning,c.c., and poder, k.  some applications of clenshaw
c     summation,presented at viii symposium on mathematical geodesy,
c     como, italy, sept 7-9, 1981
c
c     the procedure computes the value and up to the second-order
c     derivatives of the potential of the earth (w) or of its
c     corresponding anomalous potential(t).
c
c     the potential is represented by a series of solid spherical
c     harmonics,with un-normalcapnized or quasi-normalized coefficients.
c     the chain-rule is used along with the clenshaw algorithm.
c     the array c must hold the coefficients c(1)=c(1,0),c(2)=c(1,1),
c     c(3)=s(1,1),etc.up to c((n+1)**2-1=s(n,n). c(0,0)is stored in c0
c     which implicitly acts as c(0) (see the common block cm).
c
c
c     parameters
c
c     (a) input values
c
c     nmax
c     the absolute value of nmax is equal to the maximal degree and
c     order of the series. negative nmax indicates that the coefficients
c     are quasi-normalized.
c
c     order
c     order of derivatives
c     0 for potential only
c     1 for potential and first derivatives
c     2 for potential, first derivatives, and second derivatives
c
c     po
c     array holding position information. po(6)
c     po(1)=p, the distance from the z (rotation) axis,
c     po(2)=r, the distance from the origin,
c     po(3)=po(4) cos and sin of the geocentric polar angle(colatitude),
c     po(5)=po(6)sin and cos of the longitude.
c
c     c
c     c((abs(nmax)+1)**2-1)   array of c's and s's described above
c     cm3=gm
c     cm2=a the semi-major axis of the reference ellipsoid
c     cm1=the angular velocity (=0, when dealing with t)
c     root(k)=sqrt(k), 0.le.k.le.2(abs(n)+1)-1 whennmax.lt.0
c
c
c     (b)return values
c
c     g1 and g2
c     the result is stored in g1 and g2 as follows
c
c     g1(1)=dw/dx,g1(2)=dw/dy,g1(3)=dw/dz
c     g2(1,1)=ddw/dxx, g2(1,2)=g2(2,1)=ddw/dxdy,
c     g2(1,3)=g2(3,1)=ddw/dxdz, g2(2,2)=ddw/dyy,
c     g2(2,3)=g2(3,2)=ddw/dydz and g2(3,3)=ddw/dzz
c     where w may be interchanged with t and
c     variables x,y,z are the cartesian coordinates
c     in a local (fixed) frame with origin in the point
c     of evaluation, positive north, y positive east,
c     and z positive in the direction of the radius
c     vector, (cf. ref.(1),eq (4) and (5)).
c     the values of w or t will be returned in gpotdr.
c
c     (c) passed and returned values
c
c     su
c     array of dimension k*(n+1), where k=2 for no derivatives,
c     =6 for 0-th and first derivatives, =10 for 0-th,first and
c     second derivatives. here are stored the partial sums, cf.
c     ref.(2), eq. (29),of p(n,m)*(a/r)**(n+1-m)/p(m,m)*(c(n,m) or
c     s(n,m))  from n=m to n=n, and the derivatives of these sums.
c     this makes it unnecessary to recalculate these quantities,if
c     the procedure is called subsequently with the same value of t
c     and r, and the same order.
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h,o-z)
      integer capn,order,capn21,oldord
      logical quasi,deriv1,deriv2,pole
      logical first,new,old,npole
      real*4 c,c0
      real*8 m21,m21t,m21u,m21u0
      dimension sml(361),cml(361),smlp1(362),cmlp1(362),po(6)
      dimension su(3610)
      common/sqroot/dzero,root(722)
      common/gpotcm/oldt,oldr,iz,first,oldord,i1,i2,i3,i4,
     *i5,i6,i7,i8,i9,nmaxsv
      common/cm/c20in,g1(3),g2(3,3),cm3,cm2,cm1,c0,c(130320)
      equivalence(sml(1),smlp1(2)),(cml(1),cmlp1(2))
      if(nmaxsv.ne.nmax)first=.false.
      nmaxsv=nmax
      if(first) go to 100
      first=.true.
      oldt=2.d0
      j=iabs(nmax)
      i=j+1
      i1=i+1
      i2 = i1+i
      i3=i2+i
      i4=i3+i
      i5=i4+i
      i6=i5+i
      i7=i6+i
      i8=i7+i
      i9=i8+i
  100 capn=nmax
c     distance from rotation axis
      p=po(1)
c     distance from origin
      r=po(2)
c     cosine of colatitude
      t=po(3)
c     sine of colatitude
      u=po(4)
c     sine of longitude
      sl=po(5)
c     cosine of longitude
      cl=po(6)
      t2=t+t
      pole=dabs(u).le.1.d-9
      new=dabs(oldr-r).gt.1.d-3 .or.dabs(oldt-t).gt.1.d-9.or.
     *oldord.ne.order.or.pole
      old=.not.new
      npole=.not.pole
      if(old) go to 200
      oldr=r
      oldt=t
      oldord=order
  200 quasi=.false.
      if(capn.lt.0)quasi=.true.
      if(quasi)capn=-capn
c     compute ae/r
      s=cm2/r
      s2=s**2
      cmlp1(1)=1.d0
c     cml(0)=1.d0
      smlp1(1)=0.d0
c     sml(0)=0.d0
      deriv1=.false.
      if(order.gt.0)deriv1=.true.
      deriv2=.false.
      if(order.gt.1) deriv2=.true.
c
c     sml(m) and cml(m) are the sine and cosine of m*longitude
c
      sml(1)= sl
      cml(1)=cl
c
      m1=1
      do 300 m=2,capn
      sml(m)=sml(m1)*cl+cml(m1)*sl
      cml(m) = cl*cml(m1)-sl*sml(m1)
  300 m1=m
c
      capn21=capn+capn+1
      vm=0.d0
      vxm=0.d0
      vym=0.d0
      vzm=0.d0
      sqnm1=1.d0
      sqnpm1=1.d0
      if(.not.deriv2) go to 400
      vxxm=0.d0
      vyym=0.d0
      vzzm=0.d0
      vxym=0.d0
      vxzm=0.d0
      vyzm=0.d0
  400 km=(capn+1)**2
      max2=capn21
c
c     we now use the clenshaw algorithm, cf. ref.(2),eq(8-13),
c     modified in an obvious way following ref.(1).
c
      itwo=2
      do 1700 im=iz,capn
      m=capn-im
      mplus1=m+1
      if(m.eq.0)itwo=1
      km=km-itwo
      k=km
      n21=capn21
      vs=0.d0
      vc=0.d0
      vs1=0.d0
      vc1=0.d0
      vxs1=0.d0
      vxc1=0.d0
      vzs=0.d0
      vzc=0.d0
      vzs1=0.d0
      vzc1=0.d0
      vxc=0.d0
      vxs=0.d0
      if(.not.deriv2) go to 500
      vxxc=0.d0
      vxxs=0.d0
      vxxc1=0.d0
      vxxs1=0.d0
      vzzc=0.d0
      vzzs=0.d0
      vzzc1=0.d0
      vzzs1=0.d0
      vxzc=0.d0
      vxzs=0.d0
      vxzs1=0.d0
      vxzc1 = 0.0d0
  500 cm=cmlp1(mplus1)
      sm=smlp1(mplus1)
      nm1=capn-m+2
      n1=capn+1
      npm1=capn+m+2
      if(deriv2)m2=m*m
      if(old) go to 1300
      n=capn+1
c
      do 1000 in=m,capn
      n=n-1
      nm2=nm1
      nm1=nm1-1
      npm1=npm1-1
c     ref.(2) eq.(40)
      if(.not.quasi) go to 600
c     ref.(2) eq(30b)
      sqnm2=sqnm1
      sqnm1=root(nm1)
      sqnpm2=sqnpm1
      sqnpm1=root(npm1)
      sq1=sqnm1*sqnpm1
      a1=s*n21/sq1
      b2=-s2*sq1/(sqnm2*sqnpm2)
      go to 700
c     ref.(2), eq.(30)
  600 a1=(s*n21)/nm1
      b2=-(s2*npm1)/nm2
  700 a1t=a1*t
      a1u=a1*u
      n21=n21-2
c  correction by rf, dec 88
      if (k.eq.0) ck=c0
      if (k.gt.0) ck=c(k)
      ck1=c(k+1)
      k=k-n21
c     ref.(2), eq(33)
      v2=vc1
      vc1=vc
      vc=vc1*a1t+v2*b2+ck
      v2=vs1
      vs1=vs
      vs=vs1*a1t+v2*b2+ck1
      if(.not.deriv1) go to 1000
      ckz=ck*n1
      ck1z=ck1*n1
c     ref.(2), eq(10)
      v2=vxc1
      vxc1=vxc
      vxc=vxc1*a1t+vc1*a1u+v2*b2
      v2=vxs1
      vxs1=vxs
      vxs=vxs1*a1t+vs1*a1u+v2*b2
      v2=vzc1
      vzc1 = vzc
      vzc=vzc1*a1t+v2*b2-ckz
      v2=vzs1
      vzs1=vzs
      vzs=vzs1*a1t+v2*b2-ck1z
      n1=n
      if(.not.deriv2) go to 1000
      n2=n+2
c     ref.(2), eq(41)
      v2=vzzc1
      vzzc1=vzzc
      vzzc=vzzc1*a1t+v2*b2+n2*ckz
            v2=vzzs1
      vzzs1=vzzs
      vzzs=vzzs1*a1t+v2*b2+n2*ck1z
      if(npole) go to 800
c     ref.(2), eq(12)      second-order derivative wrt latitude
      v2=vxxc1
      vxxc1=vxxc
      vxxc=a1t*(vxxc1-vc1)+(a1u+a1u)*vxc1+v2*b2
      v2=vxxs1
      vxxs1=vxxs
      vxxs=a1t*(vxxs1-vs1)+(a1u+a1u)*vxs1+v2*b2
c     ref.(2) eq(10,40) derivative wrt r and latitude
  800 v2=vxzc1
      vxzc1=vxzc
      vxzc=vxzc1*a1t+vzc1*a1u+v2*b2
      v2=vxzs1
      vxzs1=vxzs
      vxzs=vxzs1*a1t+vzs1*a1u+v2*b2
 1000 continue
      su(m+1)=vc
      su(m+i1)=vs
      if(.not.deriv1) go to 1500
      su(m+i2)=vxc
      su(m+i3)=vxs
      su(m+i4)=vzc
      su(m+i5)=vzs
      if(.not.deriv2) go to 1500
      su(m+i6)=vzzc
      su(m+i7)=vzzs
      su(m+i8)=vxzc
      su(m+i9)=vxzs
      go to 1500
 1300 vc=su(m+1)
      vs=su(m+i1)
      if(.not.quasi) go to 1400
      sqnpm1=root(max2)
      sqnpm2=root(max2+1)
 1400 npm1=max2
      max2=max2-2
      if(.not.deriv1) go to 1500
      vxc=su(m+i2)
      vxs=su(m+i3)
      vzc = su(m+i4)
      vzs=su(m+i5)
      if(.not.deriv2) go to 1500
      vzzc=su(m+i6)
      vzzs=su(m+i7)
      vxzc=su(m+i8)
      vxzs=su(m+i9)
c
c     the computation of derivatives in direction of pos longitude,y,
c     involves the division by u=cos(latitude). this division is
c     performed implicitly, by stoping the clenshaw summation at m=1.
c     this is done by putting u0=1.0. this trick permits the use of the
c     procedure at poles,except for the second-order derivative wrt
c     longitude. but here we use the validity of the laplace equation
c     and compute the second-order derivatives wrt x and z
c
 1500 u0=u
      if(m.eq.0)u0=1.d0
c     ref.(2) eq.(35)
      aux=npm1
      if(quasi)aux=sqnpm1/sqnpm2
      m21=s*aux
      m21u=m21*u
      if(.not.deriv1) go to 1700
      m21t=m21*t
      m21u0 = m21*u0
      if(.not.deriv2) go to 1600
      vzzm=vzzc*cm+vzzs*sm+m21u*vzzm
      if(m.gt.0)vxym=m*(vxs*cm-vxc*sm)+m21u*vxym-m21t*vym
      vxzm=vxzc*cm+vxzs*sm-m21t*vzm+m21u*vxzm
      vyzm=(vzs*cm-vzc*sm)*m+m21u0*vyzm
      if(pole) vxxm=vxxc*cm+vxxs*sm+m21*(u*(vxxm-vm)-t2*vxm)
      if(npole)vyym=-(vc*cm+vs*sm)*m2+m21u0*vyym
 1600 vxm=vxc*cm+vxs*sm-m21t*vm+m21u*vxm
      vym=m*(vs*cm-vc*sm)+m21u0*vym
      vzm=vzc*cm+vzs*sm+m21u*vzm
 1700 vm=vc*cm+vs*sm+m21u*vm
c
c     now the contributions from the rotational potential are added
c
c     compute omega**2
      om2=cm1**2
c     compute gm/r
      s=cm3/r
      gpotdr=s*vm+om2*p**2*.5d0
      if(.not.deriv1) return
c     compute gm/r**2
      s=s/r
      g1(1)=s*vxm-t*p*om2
      g1(2)=s*vym
      g1(3)=vzm*s+u**2*om2*r
      if(.not.deriv2) return
c     compute gm/r**3
      s=s/r
      if(npole) go to 1900
      vxxm=vxxm+vzm
      vyym=-(vxxm+vzzm)
      go to 2000
 1900 vyym=vzm+(vyym-t*vxm)/u
      vxxm=-(vzzm+vyym)
 2000 g2(1,1)=vxxm*s+om2*t**2
      g2(1,2)=s*vxym*m21
      g2(2,1)=g2(1,2)
      g2(1,3)=s*(vxzm-vxm)-u*t*om2
      g2(3,1)=g2(1,3)
      g2(2,2)=vyym*s+om2
      g2(2,3)=s*(vyzm-vym)
      g2(3,2)=g2(2,3)
      g2(3,3)=s*vzzm+u**2*om2
      return
      end
c
      subroutine normal (gm,djn,ae,omega,x,y,z,u,gamma,grad)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                            n o r m a l
c
c     compute normal potential (u),magnitude of normal gravity (gamma),
c     and gravity gradient(grad) at point (x,y,z) ecf coordinates
c
c
c     input (all must be in common system- ex. mks)
c
c     gm  universal gravitational constant times mass of earth
c
c     djn  array of even zonals of normal ellipsoid
c     (ex. djn(2)=j2)
c
c     ae  normal ellipsoid semimajor axis
c
c     omega rotation rate of earth
c
c     x,y,z ecf coordinates of point in space
c
c     output (all values in system used by input variables)
c
c     u  normal potential at (x,y,z)
c
c     gamma magnitude of normal gravity at (x,y,z)
c
c     grad magnitude of gravity gradient at (x,y,z)
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h,o-z)
      dimension djn(20)
      psq=x**2+y**2
      rsq=psq+z**2
      r=dsqrt(rsq)
      gmor=gm/r
      aor=ae/r
      sine=z/r
      pnl1=sine
      pn=1.5d0*sine**2-0.5d0
c     u=gm/r*f+0.5d0*omega**2*cos(lat)**2*r**2
c     where lat is geocentric latitude
      f=1.d0
      fp=0.d0
      fpp=0.d0
      aorn=1.d0
      aor2=aor**2
c  correction by rf dec 88
      do 10 n=2,12,2
      aorn=aorn*aor2
      term=-djn(n)*aorn*pn
      f=f+term
      fp=fp-n*term/r
      fpp=fpp+n*(n+1)*term/rsq
      save=(n+n+1.d0)/(n+1.d0)*sine*pn-n/(n+1.d0)*pnl1
      pnl1=pn
      pn=save
      save=(n+n+3.d0)/(n+2.d0)*sine*pn-(n+1.d0)/(n+2.d0)*pnl1
      pnl1=pn
   10 continue
      u=gmor*f
      gamma=gmor*fp-u/r
      omega2=omega**2
      grad=(u+u)/rsq-2.d0*gmor*fp/r+gmor*fpp+omega2*psq/rsq
      grad=dabs(grad)
      u=u+0.5d0*omega2*psq
      gamma=dabs(gamma+psq/r*omega2)
      return
      end
      subroutine refval(a,gm,j2,omega,flati)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                       r e f v a l
c
c     given reference ellipsoid values a,j2,gm,omega
c     return inverse of flattening (flati)
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h,o-z)
      real*8 j2
      pwr=(omega*a)**2*a/gm
      esqsv=3.d0*j2+pwr
      esq=esqsv
      itime=0
    5 itime=itime+1
      ep2=esq/(1.d0-esq)
      fact=1.d0/(1.d0-esq)**1.5d0
      ds=1.d0
      twoqp=0.d0
c     this loop computes 2*q/e**3
      do 10 n=1,12
      twoqp=twoqp+ds*4.d0*n/((n+n+1.d0)*(n+n+3.d0))*fact
      ds=-ds
      fact=fact*ep2
   10 continue
      esq=esqsv+pwr*(4.d0/15.d0/twoqp-1.d0)
      flati=1.d0/(1.d0-dsqrt(1.d0-esq))
      test=dabs(flati-298.257d0)
      if(test.gt.1.d0) go to 100
      if(itime.lt.10) go to 5
      write(*,20)a,gm,j2,omega
   20 format(/' reference values of normal ellipsoid a gm j2 omega'/,
     *1x,f12.2,3g17.9)
      write(*,30)flati
   30 format(' computed value of flattening inverse ',g20.12)
      return
  100 write(*,110)
  110 format(' something wrong in refval flattening not converging')
      stop
      end
      subroutine tranf(iswich,glat,elon,ht,x,y,z,ae,flat)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                            t r a n f
c
c     c.goad
c
c     iswich .le. 1
c     transformation from geodetic lat,e.lon,height to x,y,z
c     given semi-major axis and flattening - earth fixed coordinates
c     iswich .ge. 2
c     transformation from x,y,z to geodetic lat., e. lon, ht
c     glat and elon are in degrees - ht,x,y,z, and ae should agree
c     as far as units of length are concerned
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
      common/pidtr/pi,dtr
      common/trancm/tol,maxit
      flatfn=(2.d0-flat)*flat
      funsq=(1.d0-flat)**2
      if(iswich.gt.1) go to 1000
c     p. 27 - 29 of escobal,methods of orbit determination
c     1965,wiley  sons, inc.
      sphi=dsin(glat*dtr)
      g1=ae/dsqrt(1.d0-flatfn*sphi**2)
      g2=g1*funsq+ht
      g1=g1+ht
      x=g1*dcos(glat*dtr)
      y=x*dsin(elon*dtr)
      x=x*dcos(elon*dtr)
      z=g2*sphi
      return
c
c     use first order taylor series to solve for geodetic latitude and h
c
c     starting values are geocentric latitude and difference between
c     distance from origin and distance to ellipse from origin
c
 1000 rsq=x**2+y**2
      r=dsqrt(rsq)
      e=datan2(y,x)
      if(e.lt.0.d0) e=e+pi+pi
      elon=e/dtr
      rho=dsqrt(z**2+rsq)
      sphi=z/rho
      glatr=dasin(sphi)
      ht=rho-ae*(1.d0-flat*sphi**2)
      iter=0
c
c     iterate
c
 1100 sphi=dsin(glatr)
      cphi=dcos(glatr)
      g1=ae/dsqrt(1.d0-flatfn*sphi**2)
      g2=g1*funsq+ht
      g1=g1+ht
      dr=r-g1*cphi
      dz=z-g2*sphi
      dht=dr*cphi+dz*sphi
      ht=ht+dht
      dlatr=(dz*cphi-dr*sphi)/(ae+ht)
      iter=iter+1
      if(iter.gt.maxit) go to 1200
      if(dabs(dlatr).gt.tol) go to 1100
      if(dabs(dht)/(ae+ht).gt.tol) go to 1100
 1200 glat=glatr/dtr
      return
      end
c
      subroutine loadcs(nmax,sname,ifmt)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                           l o a d c s
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
      character*72 sname,drec
      character*6 ch6
      real*4 c,c0
      integer*2 nn,mm
      common/cm/c20in,g1(3),g2(3,3),cm3,cm2,cm1,c0,c(130320)
      logical last
c
      if (ifmt.eq.1) then
        write(*,*) '- binary coefficients -'
        open(12,file=sname,form='unformatted',access='direct',
     .  recl=20,status='old')
      else
        open(12,file=sname,status='old')
      endif
      ii = 0
      last = .false.
c
c  read coefficients 
c 
  100 ii = ii+1
      if (ifmt.ge.2) then
        if (ifmt.eq.2) then 
          read(12,*,end=200) n,m,cnm,snm
        else
          read(12,101,end=200) drec
          if (drec(1:6).ne.'GRCOF2') goto 100
          read(drec,102) ch6,n,m,cnm,snm
          if (n.le.3.or.n.eq.60.and.m.gt.56) 
     .    write(*,1021) ch6,n,m,cnm,snm
101       format(a72)
102       format(a6,2i5,2e19.12)
1021      format(' ',a6,2i5,2e19.12)
        endif
      else
c  gnu fortran modifications
        if (last) goto 200
        read(12,rec=ii) nn,mm,cnm,snm
        n = nn
        m = mm
        if (n.eq.nmax.and.m.eq.nmax) last = .true.
      endif
      if (n.le.3.and.ifmt.lt.3) write(*,103) n,m,cnm,snm
103   format(2i5,2e20.12)
c
c     store c20 in double precision for later use
      if(n.eq.2.and.m.eq.0)c20in=cnm
      if(n.gt.nmax.or.m.gt.nmax) go to 100
      if (n.le.1) goto 100
      call storc(n,m,cnm,snm)
      if (n.eq.nmax.and.m.eq.nmax) goto 200
      go to 100
  200 continue
      close (12)
      return
      end
c
      subroutine modc(n,m,cnm,snm)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                         m o d c
c
c     modify individual c and s terms
c
c     normally used to subtract off even zonals of normal ellipsoid
c     to get anomalous potential coefficients
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h,o-z)
      real*4 c,c0
      common/cm/c20in,g1(3),g2(3,3),cm3,cm2,cm1,c0,c(130320)
c
c     sum of the previous number of terms
c
      j=(n-1)*(n+1)
      if(m.eq.0) go to 10
      k=m+m
      c(j+k)=c(j+k)+cnm
      c(j+k+1)=c(j+k+1)+snm
      return
   10 c(j+1)=c(j+1)+cnm
      return
      end
c
      subroutine setcm(capn)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                       s e t c m
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
      integer capn
      real*4 c,c0
      common/sqroot/dzero,root(722)
      common/cm/c20in,g1(3),g2(3,3),cm3,cm2,cm1,c0,c(130320)
c
c     this routine sets the square root table in common
c     sqroot and creates quasi-normalized coefficients from normalized
      dzero=0.d0
      do 50 i=1,722
   50 root(i)=dsqrt(dble(real(i)))
      g1(1)=0.d0
      g1(2)=0.d0
      g1(3)=0.d0
      smallc=1.d0
      if(c0.ne.0.d0) smallc=1.d0/c0
      sq2=dsqrt(2.d0)
      do 200 n=1,capn
      n2=n+n
      s21=dsqrt(n2+1.d0)
      k=n**2
c     d is the quasi-normalization factor for zonal terms
      d=smallc*s21
      c(k)=c(k)*d
c     gg is the quasi-normalization factor for non-zonal terms
      gg=d*sq2
      do 100 j=1,n
      kj2=j+j+k
      c(kj2-1)=c(kj2-1)*gg
      c(kj2)=c(kj2)*gg
  100 continue
  200 continue
      return
      end
c
      subroutine storc(n,m,cnm,snm)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                           s t o r c
c
c     this subroutine inserts the values of cnm and snm into array c
c     in common cm
c
c
c     store individual c and s terms
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8 (a-h,o-z)
      real*4 c,c0
      common/cm/c20in,g1(3),g2(3,3),cm3,cm2,cm1,c0,c(130320)
c
c     sum of the previous number of terms
c
      j=(n-1)*(n+1)
      if(m.eq.0) go to 10
      k=m+m
      c(j+k)=cnm
      c(j+k+1)=snm
      return
   10 c(j+1)=cnm
      return
      end
