      program gfilt
      implicit double precision(a-h,o-z)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                          g f i l t
c
c  program for simple filtering of a grid by a space-domain filter
c  (low-pass or band-pass)
c
c  input:
c
c  gridfile
c  outfile
c  mode, rdeg1, rdeg2, lint
c
c  mode = 1: circular sharp cut-off
c         2: gaussian
c
c  filtering parameters (full-width resolution)
c  rdeg1: lower band cut-off (e.g. rdeg1 = 5 corresponds to sph harm 36)
c  rdeg2: upper band cut-off (e.g. rdeg2 = 1 corresponds to shp harm 180)
c  lint: true for integer output
c
c  rdeg1 must be > rdeg2 
c  rdeg1 = 0 mean low-pass filter only
c
c  (c) Rene Forsberg, March 1996
c  min/max and 9999 update june 2004, rf
c  northpole modification oct 2006
c  -180 meridian update oct 08
c  bandpass and spherical distance update march 2011 
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      character*72 ifile,ofile
      logical lint,l360,lband
      dimension f(1500,2200),g(1500,2200),
     .cosfi(1500),sinfi(1500),cosla(2200),sinla(2200)
      nndim = 1500
      nedim = 2200
      radeg = 180/3.1415926535d0
c
      write(*,3)
3     format(/
     .' ************************************************************',
     .'********'/
     .' *     GFILT - GRAVSOFT grid filter - vers. MAR11 (c) R',
     .'F/DTU-Space  *'/
     .' ************************************************************',
     .'********')
      write(*,1)  
1     format(' input file names - ifile/ofile: ')
      read(*,2) ifile 
      read(*,2) ofile
2     format(a72)
c
      write(*,4)
4     format(' input: mode (1:sharp,2:exp), rdeg1, rdeg2, lint')
 
      read(*,*) mode, rdeg1, rdeg2, lint
      if (rdeg1.eq.0) then
        rdeg = rdeg2
        lband = .false.
      else
        if (rdeg1.le.rdeg2) stop '*** rdeg2 must be less than rdeg1' 
        rdeg = rdeg1
        lband = .true.
      endif
c
      open(10,file=ifile,status='old')
      open(20,file=ofile,status='unknown')
c
      read(10,*) rfi1,rfi2,rla1,rla2,dfi,dla
      nn = (rfi2-rfi1)/dfi + 1.5
      ne = (rla2-rla1)/dla + 1.5
      if (nn.gt.nndim.or.ne.gt.nedim) then  
        write(*,*) nn,ne 
        stop '*** grid too large, increase nndim or nedim ***'
      endif
      l360 = .false.
      if (rla1.le.-179.5.and.rla2.ge.179.5) l360 = .true.
      if (l360) write(*,*) '- longitude assumed to be -180 to 180'
c
c  set arrays storing cosine and sine of latitude and longitude
c
      do 8 i = 1, nn
        rfi = rfi1 + (i-1)*dfi
        cosfi(i) = cos(rfi/radeg)
        sinfi(i) = sin(rfi/radeg)
8     continue
      do 9 j = 1, ne
        rla = rla1 + (j-1)*dla
        cosla(j) = cos(rla/radeg)
        sinla(j) = sin(rla/radeg)
9     continue
c
      rdeg2h = rdeg2/2
      cdeg2h = cos(rdeg2h/radeg)
      rdeg1h = rdeg1/2
      cdeg1h = cos(rdeg1h/radeg)
c
c  size of moving window in latitude
c
      ii = rdeg/2/dfi + 0.5
      if (ii.gt.nn/2) ii = nn/2
      if (mode.eq.2) ii = ii*2
c
      write(*,20) nn,ne,rdeg1,rdeg2,-ii,ii
20    format(/' ---  G F I L T  ---',/,
     .' number of points in grid,  north:',i7,', east:',i7/
     .' filter par (deg): ,',2f6.1,', latitude window range:',2i5)
      if (lband) write(*,201) nint(180/rdeg1),nint(180/rdeg2)
201   format(' spherical harmonic equivalent band:',2i7) 
      rmin = 9.d9
      rmax = -9.d9
      nr = 0
      rsum = 0
      rsum2 = 0
      n9999 = 0
c
      do 21 i = nn,1,-1
21    read(10,*) (f(i,j),j=1,ne)
c
c  point loop
c  ----------
c 
      do 30 i = nn,1,-1
c
c  longitude operator length - double due to meridian convergence
c
      jj = rdeg/2/(dla*cosfi(i)+1.d-6)*2
      if (jj.gt.ne/2) jj = ne/2
      if (i.eq.nn.or.i.eq.nn/2.or.i.eq.1) write(*,*) 
     .'- row',i,' longitude window range: ',-jj,jj
      do 30 j = 1, ne
	  wsum = 0
	  gsum = 0
        w1sum = 0
        g1sum = 0
        if (f(i,j).ge.9999) goto 26
c
c  window loop
c
        do 25 ip = -ii,ii
        do 25 jp = -jj,jj
          ik = i+ip 
	    if (ik.lt.1.or.ik.gt.nn) goto 25
	    jk = j+jp
          jjk = j - jk 
          if (.not.l360) then
            if (jk.lt.1.or.jk.gt.ne) goto 25
          else
            jjk = j-jk
            if (jk.lt.1) jk = jk + ne
            if (jk.gt.ne) jk = jk - ne
          endif
          ff = f(ik,jk)
          if (ff.ge.9999) goto 25
c   
          cosdla = cosla(j)*cosla(jk) + sinla(j)*sinla(jk)
          cospsi = sinfi(i)*sinfi(ik) + cosfi(i)*cosfi(ik)*cosdla
c
          if (mode.eq.1) then
            w = cosfi(ik)
            if (cospsi.gt.cdeg2h) then
	        wsum = wsum + w
	        gsum = gsum + ff*w
            endif
            if (lband) then
              if (cospsi.gt.cdeg1h) then
                w1sum = w1sum + w
                g1sum = g1sum + ff*w
              endif
            endif          
	    else
c  fejl?
            if (cospsi.ge.1) cospsi = 1-1.0d-10
            psi = acos(cospsi)*radeg
            w = exp(-psi/rdeg2h)*cosfi(ik)
            wsum = wsum + w
            gsum = gsum + ff*w
            if (lband) then
              w1 = exp(-psi/rdeg1h)*cosfi(ik)
              w1sum = w1sum + w1
              g1sum = g1sum + ff*w1
            endif 
          endif
25      continue
c
26      if (wsum.eq.0) then
          gg = 9999.99
        else
          gg = gsum/wsum  
        endif
c
        if (lband) then
          if (w1sum.gt.0.and.wsum.gt.0) then
            gg1 = g1sum/w1sum
            gg = gg - gg1
          endif
        endif
c
        if (gg.ge.9999) then
          n9999 = n9999+1
        else
          nr = nr+1
          rsum = rsum + gg
          rsum2 = rsum2 + gg**2
          if (gg.gt.rmax) rmax = gg
          if (gg.lt.rmin) rmin = gg
        endif
        g(i,j) = gg
30    continue
c
      write(20,32) rfi1,rfi2,rla1,rla2,dfi,dla
32    format(' ',4f12.6,2f12.7)
c       
      do 50 i = nn,1,-1
        if (lint) write(20,51) (nint(g(i,j)),j=1,ne)
51      format(30(/,12i6))
        if (.not.lint) write(20,52) (g(i,j),j=1,ne)
52      format(30(/,8f9.3))
50    continue
c
      close(20)
      sdev = 0.0
      if (nr.gt.1) sdev = sqrt((rsum2 - rsum**2/nr)/(nr-1))
      if (nr.gt.0) rsum = rsum/nr

      write(*,60) nn*ne,n9999,rsum,sdev,rmin,rmax
60    format(' number of points in output grid:',i6,', unknown:',i6,
     ./' mean,stddev,min,max: ',4f9.2) 
      end
