      program gfilt
      implicit double precision(a-h,o-z)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c                          g f i l t
c
c  program for simple filtering of a grid by a space-domain filter
c
c  input:
c
c  gridfile
c  outfile
c  mode, rdeg, lint
c
c  mode = 1: circular sharp cut-off
c         2: gaussian
c
c  where rdeg is the filtering parameter (full-width resolution)
c  lint: true for integer output
c
c  (c) Rene Forsberg, March 1996
c  min/max and 9999 update june 2004, rf
c  northpole modification oct 2006
c  -180 meridian update oct 08
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      character*72 ifile,ofile
      logical lint,l360
      dimension f(1500,2200),g(1500,2200)
      nndim = 1500
      nedim = 2200
c
      write(*,3)
3     format(/
     .' ************************************************************',
     .'**'/
     .' *     GFILT - GRAVSOFT grid filter - vers. OCT08 (c) R',
     .'F/NSI  *'/
     .' ************************************************************',
     .'**')
      write(*,1)
1     format(' input file names - ifile/ofile: ')
      read(*,2) ifile 
      read(*,2) ofile
2     format(a72)
c
      write(*,4)
4     format(' input: mode (1:sharp,2:exp),rdeg, lint')
      read(*,*) mode, rdeg, lint
c
      open(10,file=ifile,status='old')
      open(20,file=ofile,status='unknown')
c
      read(10,*) rfi1,rfi2,rla1,rla2,dfi,dla
      nn = (rfi2-rfi1)/dfi + 1.5
      ne = (rla2-rla1)/dla + 1.5
      write(*,*) nn,ne 
      if (nn.gt.nndim.or.ne.gt.nedim) 
     .stop '*** grid too large, increase nndim or nedim ***'
      l360 = .false.
      if (rla1.le.-179.999.and.rla2.ge.179.999) l360 = .true.
      if (l360) write(*,*) '- longitude assumed to be -180 to 180'
c
      rdegh = rdeg/2
      rdegh2 = rdegh**2
      ii = 2*rdegh/dfi + 0.5
      if (rfi2.gt.89.9) then
        jj = nn/2
        write(*,*) '*** check northpole,jj set to half max'
      else
        jj = 2*rdegh/(dla*cos(rfi2/57.29578d0)) + 0.5
      endif
      write(*,20) nn,ne,rdeg,-ii,ii,-jj,jj
 20   format(/' ---  G F I L T  ---',/,
     .' number of points in grid,  north:',i7,', east:',i7/
     .' filter par (degrees): ,',f6.1,', operator lengths: ',4i5)
      rmin = 9.d9
      rmax = -9.d9
      nr = 0
      rsum = 0
      rsum2 = 0
      n9999 = 0
c
      do 21 i = nn,1,-1
21    read(10,*) (f(i,j),j=1,ne)
c
      do 30 i = nn,1,-1
      do 30 j = 1, ne
	wsum = 0
	gsum = 0
      if (f(i,j).ge.9999) goto 26
	cosfi = cos((rfi1+(i-1)*dfi)/57.29578d0)
        do 25 ip = -ii,ii
        do 25 jp = -jj,jj
          ik = i+ip 
	    if (ik.lt.1.or.ik.gt.nn) goto 25
	    jk = j+jp
          jjk = j - jk 
          if (.not.l360) then
            if (jk.lt.1.or.jk.gt.ne) goto 25
          else
            jjk = j-jk
            if (jk.lt.1) jk = jk + ne
            if (jk.gt.ne) jk = jk - ne
          endif   
	    r2 = ((i-ik)*dfi)**2 + ((jjk)*(dla*cosfi))**2
c
          if (mode.eq.1) then
            if (r2.le.rdegh2) then
              ff = f(ik,jk)
              if (ff.lt.9999) then
	          wsum = wsum + 1
	          gsum = gsum + ff
              endif
            endif
	    else
            w = exp(-r2/rdegh2)
            ff = f(ik,jk)
            if (ff.lt.9999) then
              wsum = wsum + w
              gsum = gsum + ff*w
            endif
          endif
c
25      continue
26      if (wsum.eq.0) then
          g(i,j) = 9999.99
        else
          g(i,j) = gsum/wsum  
        endif
        if (g(i,j).ge.9999) then
          n9999 = n9999+1
        else
          nr = nr+1
          rsum = rsum + g(i,j)
          rsum2 = rsum2 + g(i,j)**2
          if (g(i,j).gt.rmax) rmax = g(i,j)
          if (g(i,j).lt.rmin) rmin = g(i,j)
        endif
30    continue
c
      write(20,32) rfi1,rfi2,rla1,rla2,dfi,dla
32    format(' ',4f12.6,2f12.7)
c       
      do 50 i = nn,1,-1
        if (lint) write(20,51) (nint(g(i,j)),j=1,ne)
51      format(30(/,12i6))
        if (.not.lint) write(20,52) (g(i,j),j=1,ne)
52      format(30(/,7f10.3))
50    continue
c
      close(20)
      sdev = 0.0
      if (nr.gt.1) sdev = sqrt((rsum2 - rsum**2/nr)/(nr-1))
      if (nr.gt.0) rsum = rsum/nr

      write(*,60) nn*ne,n9999,rsum,sdev,rmin,rmax
60    format(' number of points in output grid:',i6,', unknown:',i6,
     ./' mean,stddev,min,max: ',4f9.2) 
      end
