      PROGRAM GEOCOL17
C $Id: geocol17.for 259 2008-12-27 15:16:41Z cct $
C PROGRAMMED BY C.C.TSCHERNING, DEPARTMENT OF GEOPHYSICS, UNIVERSITY
C OF COPENHAGEN, DENMARK.
C LAST UPDATE: 2008-12-28 BY CCT.  UNIX VERSION. 
C THE PROGRAM IS COPYRIGHT BY THE AUTHOR  FIRST TIME 1975, 
C AND LATEST 2005. IT MAY BE COPIED AND TRANSFERRED TO
C NON-COMMERCIAL USERS ON THE CONDITION THAT THE AUTHOR IS NOTIFIED.
C THIS WILL ASSURE THAT USERS ARE INFORMED IF FATAL ERRORS ARE FOUND.
C COMMERCIAL USERS MUST OBTAIN A LICENCE FROM THE COPYRIGHT OWNER
C BEFORE USING THE PROGRAM OR PARTS OF THE PROGRAM.
C A FILE HTTP://CCT/GFY.KU.DK/GEOCOL17.LOG CONTAINS A RECORD OF SUSPECTED
C AND CORRECTED ERRORS, UPDATES AND PLANNED UPDATES.
C
C THE PRIMARY FUNCTION OF THE PROGRAM IS TO COMPUTE AN APPROXIMATION TO
C THE ANOMALOUS POTENTIAL OF THE EARTH USING STEPWISE LEAST SQUARES 
C COLLOCATION, CF. REF (B) AND THE DETERMINATION OF RELATED PARAMETERS
C SUCH AS DATUM-SHIFTS, SEE REF. (E). 
C WHEN THE APPROXIMATION HAS BEEN DETERMINED, IT MAY BE USED TO PREDICT
C VARIOUS QUANTITIES AND ESTIMATE ERROR AND ERROR CORRELATIONS, SEE TABLE 1.
C SECONDARY FUNCTIONS ARE (A) THE REMOVAL OR SUBTRACTION OF THE
C CONTRIBUTION FROM A SPHERICAL HARMONIC EXPANSION (SHE) AND (B)
C THE COMPUTATION OF EFFECTS OF A DATUM SHIFT.
C THE COLLOCATION METHOD REQUIRES THE SPECIFICATION OF
C (1) ONE OR TWO (AND IN A SPECIAL CASE) THREE SETS OF OBSERVED
C QUANTITIES WITH KNOWN STANDARD DEVIATIONS AND
C (2) ONE OR TWO COVARIANCE FUNCTIONS, CF. REF (A).
C
C THE COVARIANCE FUNCTIONS USED ARE ISOTROPIC. THEY ARE SPECIFIED
C BY A SET OF EMPIRICAL ANOMALY DEGREE-VARIANCES OF DEGREE LESS
C THAN AN INTEGER VARIABLE IMAX, AND BY AN ANOMALY DEGREE-VARIANCE
C MODEL FOR THE DEGREE-VARIANCES OF DEGREE GREATHER THAN IMAX.
C
C THE OBSERVATIONS MAY BE POTENTIAL COEFFICIENTS, MEAN OR POINT
C GRAVITY ANOMALIES, HEIGHT ANOMALIES, VALUES OF THE ANOMALOUS 
C POTENTIAL, DEFLECTIONS OF THE VERTICAL, GRAVITY GRADIENTS AND
c DENSITY CONTRASTS. THE ABSOLUTE QUANTITIES, I.E. THE SAME ASSOCIATED
C FUNCTIONALS APPIED ON THE FULL POTENTIAL (V OR W) MAY ALSO
C BE USED IN CERTAIN CIRCUMSTANCES.  A FILTERING TAKES
C PLACE SIMULTANEOUSLY WITH THE DETERMINATION OF THE ANOMALOUS
C POTENTIAL.
C
C THE OBSERVATIONS MAY BE GIVEN IN A LOCAL (E.G. INSTRUMENTAL) FRAME
C IN WHICH CASE ATTITUDE INFORMATION MUST BE INPUT. THEY MAY ALSO
C HAVE CORRELATED ERRORS, IN WHICH CASE THE ERROR-COVARIANCE FUNCTION
C MUST BE DEFINED.
C
C THE DETERMINATION IS MADE IN A NUMBER OF STEPS EQUAL TO THE NUMBER OF
C SETS OF OBSERVATIONS. WHEN POTENTIAL COEFFICIENTS ARE USED, WILL THE-
C ESE FORM A SEPARATE SET. CONTRIBUTIONS FROM A TERRAIN POTENTIAL MAY
C NOT BE COMPUTED BY THIS VERSION, BUT MAY BE INPUT AND WILL THEN BE
C ADDED TO OR SUBTRACTED FROM THE VARIOUS QUANTITIES.
C EACH DATASET (EACH STEP) WILL DETERMINE A HARMONIC FUNCTION, AND THE
C ANOMALOUS POTENTIAL WILL BE EQUAL TO THE SUM OF THEESE (MAXIMALLY
C FOUR) FUNCTIONS.
C
C POTENTIAL COEFFICIENTS WILL DETERMINE A FUNCTION EQUAL TO THE COEFFI-
C CIENTS MULTIPLIED BY THE CORRESPONDING SOLID SPHERICAL HARMONICS. THE
C UP TO TWO SETS OF DATA DIFFERENT FROM POTENTIAL COEFFICIENTS WILL
C EACH BE USED TO DETERMINE CONSTANTS B(I). THE CORRESPONDING HARMONIC
C FUNCTIONS ARE THEN EQUAL TO THEESE CONSTANTS MULTIPLIED BY THE COVA-
C RIANCE BETWEEN THE OBSERVATIONS AND THE VALUE OF THE ANOMALOUS POT-
C ENTIAL IN A POINT, P.
C
C THE PROGRAM  WILL COMPUTE, THE CONSTANTS B(I) AND PREDICT QUANTITIES
C ZETA, KSI, ETA, DELTA G, GRAVITY GRADIENTS, DENSITY CONTRASTS IN POINTS Q,
C AND THE ERRORS OF PREDICTION.
C
C CORRECTIONS TO A SET OF SPHERICAL HARMONICS MAY ALSO BE COMPUTED,
C CF. REF (H).
C
C DATUM-SHIFT PARAMETERS MAY ALSO BE DETERMINED BY THE PROGRAM IN THE
C FORM OF THE CHANGE IN THE LONGITUDE AND LATITUDE COMPONENTS OF THE DE-
C DEFLECTION OF THE VERTICAL AND OF THE HEIGHT-ANOMALY IN A POINT WITH
C GIVEN LATITUDE AND LONGITUDE, CF. REF(E), OR ONE ORE MORE OF THE
C PARAMETERS OF A 7-PARAMETER DATUM SHIFT. IN THIS CASE OBSERVATIONS
C OF THE DIFFERENCE BETWEEN GEOCENTRIC AND LOCAL GEODETIC COORDINATES
C MAY BE USED.
C
C BIAS, TILT AND SCALE-FACTOR PARAMETERS MAY ALSO BE DETERMINED.
C
C THE DATA USED TO CREATE ONE SOLUTION MAY BE PRESERVED AND USED IN
C ORDER TO REESTABLISH THE SOLUTION OR AS A BUILDING STONE FOR A
C NEW SOLUTION. IN THE FIRST CASE A LOGICAL VARIABLE LWRSOL MUST BE
C TRUE AND IN THE SECOND CASE MUST THE VARIABLE LRESOL BE TRUE.
C ------------------------------------------------------------------------
C   TABLE 1. DATA-KIND CODES AND UNITS USED IN THIS VERSION:
C    DATA-KIND                                CODES:     UNITS:
C  HEIGHT-ANOMALY OR GEOID UNDULATION (ZETA)   1  11     METERS
C  (USE 11 FOR SATELLITE ALTIMETRY)
C  ANOMALOUS POTENTIAL (T)                    51         M**2/S**2
C  GRAVITY DISTURBANCE (-DT/DR)= G-GAMMA          12     MGAL
C  AND DT/DR                                      52     MGAL
C  GRAVITY ANOMALY                             2  13     MGAL
C                                             43  53
C  VERTICAL GRAVITY ANOMALY GRADIENT              14     E.U.
C  VERTICAL GRAVITY DISTURBANCE GRADIENT, TZZ 55  15     E.U.
C  DEFLECTION OF THE VERTICAL, MERIDIAN COM.   3  16     ARCSEC
C                                             43  56
C       -     -   -     -    , PRIME VERTI.    4  17     ARCSEC
C                                             44  57
C  GRAVITY ANOMALY GRADIENT, MERIDIAN COMP.       18     E.U.
C      -      -       -    , PRIME VERT. CO.      19     E.U.
C  GRAVITY DISTURBANCE GRADIENT, MERIDIAN CO-
C  PONENT, TYZ.                                60  20     E.U.
C     -         -         -    , PRIME VERT.
C  COMPONENt, TXZ                             61  21     E.U.
C  SECOND ORDER DERIVATIVE IN NORTHERN DIRECTION
C  TYY                                        62  22     E.U. 
C  2*MIXED SECOND ORDER DERIVATIVE OF T,2TXY  63  23     E.U.
C  SECOND ORDER DERIVATIVE IN EASTERN DIRECTION
C  TXX                                        64  24     E.U. 
C  DIFFERENCE BETWEEN SECOND ORDER DERIVATIVES 
C  IN PRIME VERTICAL AND MERIDIAN PLANES,TXX-TYY  25     E.U.
C  PAIR OF DEFLECTIONS OF THE VERTICAL      5  26 96 ARCSEC
C                                             45  66
C  PAIR OF HORIZONTAL GRAVITY ANOMALY GRAD.       28 68  E.U.
C  PAIR OF HORIZONTAL GRAVITY DISTURB. GRAD.      30 70  E.U.
C  PAIR OF KIND (25,23)                           35 75  E.U.
C  SECOND ORDER DERIVATIVES (15, 30, 35), ONLY
C  PERMITTED WHEN COLLOCATION IS NOT USED         37    E.U.
C  FULLY NORMALIZED SPHERICAL HARMONIC COEFF.     27
C  ELLIPSOIDAL HEIGHT DIFFERENCE OLD MINUS
C  NEW DATUM VALUES                                6     METERS
C  LATITUDE AND COS(LATITUDE)*LONGITUDE DIFFE-
C  RENCE, NEW MINUS OLD DATUM VALUES.              7     ARCSEC
C  SATELLITE ALTIMETRY CROSS-OVER DIFFERENCE       9     METERS.
C  ANOMALOUS POTENTIAL                             8     M**2/S**2
C  DENSITY CONTRASTS                              10     G/CM**3*
C                                                        SCALE FACTOR
C ------------------------------------------------------------------------
C IF CODE 13 IS USED FOR GRAVITY, SPHERICAL APPROXIMATION IS USED,
C AND IF CODE 2 IS USED, THE POTENTIAL COEFFICIENT SET APPROXIMATION
C IS USED. CODE 13 IS RECOMMENDED IN GENERAL.
C CODES .GT. 40 INDICATE THAT A QUANTITY IS GIVEN IN A LOCAL REFERENCE
C SYSTEM, EAST/NORTH/UP. A LOGICAL VARIABLE LSATP IS PUT TRUE AND AN
C INTEGER ISAT IS INPUT EQUAL TO 1 IF  A ROTATION IN THE HORIZONTAL PLANE
C IS NEEDED, (THEN AZIMUTM MUST BE GIVEN), EQUAL TO 2, 3 OR  4 IF A 3D
C ROTATION IS NEEDE. IF ISAT = 1 THE AZIMUTH MUST BE INPUT. 
C IF ISAT = 2 THE AZIMUTH, TILT AND ROLL ANGLES MUST BE INPUT,
C IF ISAT = 3 NO ROTATION IS MADE, AND IF ISAT = 4, THE FULL 
C ROTATION MATRIX MUST BE INPUT. 
C
C NOTE, THAT IT IS OF ADVANTAGE TO USE OR COMPUTE PAIRS OF QUANTITIES
C BECAUSE COVARIANCES OR CONTRIBUTIONS FROM SPHERICAL HARMONIC EXPAN-
C SIONS MAY BE COMPUTED SIMULTANEOUSLY FOR THESE QUANTITIES.
C
C ------------------------------------------------------------------------
C TABLE 2:  FILES NEEDED FOR RUNNING THE PROGRAM:
C UNIT NUMBER  USED FOR                          TEMPORARY/PERMANENT
C  5, 6  STANDARD INPUT AND OUTPUT FILES              YES
C  X     DIRECT ACCESS FOR NORMAL EQUATIONS                 YES IF
C        NUMBER OF FILES AND UNITS SPECIFIED AT INPUT      NEEDED LATER
C INPUT OF ATTITUDE MATRIX ....
C 13     ROTATION MATRIX INPUT FILE                   YES
C 14     DIRECT ACCESS TO STORE ROTATION ELEMENTS     YES
C 16     DIRECT ACCESS, USED TO STORE OBSERVATION
C        COORDINATES AND THE SOLUTION                 YES 
C 17     FORMATTED, USED FOR RESTART FILE OR                 YES
C        RESULT OUTPUT (LWRSOL OR LPUNCH TRUE).
C 18     BINARY, USED FOR STORAGE OF COVARIANCE              YES
C        FUNCTION PARAMETERS ON BINARY FORM.
C 19     BINARY, USED FOR STORAGE OF SOLUTION.             YES
c        OR FOR STORAGE OF COVARIANCES.
C 20     STORAGE OF PREDICTION POINT COORDINATES WHEN
C        ERROR COVARIANCES ARE COMPUTED, ADDED
C        2005-08-09.                                       YES
C 21     INPUT OF SHC NEEDED FOR COMPARISON WITH 
C        PREDICTED.                                  YES
C 39     USED FOR SHE INPUT IN LOADCS                 YES
C 11     FORMATTED USED FOR OUTPUT OF ERROR IN GRID          YES 
C  9     INPUT UNIT FOR POTENTIAL COEFFICIENTS        YES       
C        FORMATTED OR BINARY DEPENDING ON "LBIN".
C        USED IN SUBROUTINE LOADCS, AND INPUT UNIT FOR
C        ERROR-DEGREE VARIANCES IN SUBROUTINE INCOV.
C  7     USED TO STORE ERROR COVARIANCES.             YES
C  3     TEMPORARY STORAGE OF POTENTIAL COEFFICIENTS         YES
C        IF DENSITY ANOMALIES ARE USED OR COMPUTED,
C        AND PERMANENT IF LBIPOT IS SET TRUE                  YES
C  2     TEMPORARY STORAGE OF CONTRIBUTIONS FROM      YES
C        DATA ONLY ASSOCIATED WITH PARAMETERS.
C  4 OR DIFFERENT FROM OTHER UNIT NUMBERS, INPUT OF
C        DATA IF LIN4 IS TRUE                         YES
C 12     FILE WITH DETECTED GROSS-ERRORS (LERR,
C        LCOMP, LSTAT MUST BE TRUE).                           YES 
C  1     FILE TO HOLD PREDICTED SPHERICAL HARMONIC
C        COEFFICIENT CORRECTIONS NAMED PCOEFF                  YES
C INZ    UNIT FOR DATA INPUT, USE 22-38                        YES
C NEQFI  SEVERAL UNITS TO HOLD NORMAL-EQUATIONS,               YES
C        USE NUMBERS LARGER THAN 20.
C ------------------------------------------------------------------------
C
C BRIEF SUMMARY OF INPUT SPECIFICATIONS. DETAILS ARE FOUND BELOW
C IN THE MAIN PROGRAM, WITH REFERENCE BACK TO THIS SUMMARY THROUGH
C THE NUMBERS (1), (2),.. ETC.
C
C (0) INPUT OF LOGICAL VARIABLE (LINTER), TRUE IF INTERACTIVE INPUT.
C     IF FALSE, ALL INPUT INSTRUCTIONS MUST BE STORED IN AN INPUT-FILE.
C (1) INPUT OF LOGICAL VARIABLES DETERMINING THE EXECUTION, AND
C     CONTINGENTLY NAMES OF FILES HOLDING RESTART-FILE, AND OF
C     NORMAL EQUATION FILES.
C     MOST IMPORTANT ARE:
C     LSPHER - THE COMPUTATIONS ARE MADE IN SPHERICAL APPROXIMATION.
C     LTRAN - DATA MAY HAVE TO BE TRANSFORMED FROM A LOCAL DATUM TO
C       GEOCENTRIC SYSTEM NOT ALREADY DEFINED IN SUBROUTINE ICOSYS.
C     LPOT  - FIRST OBSERVATION SET IS POTENTIAL COEFFICIENTS.
C     LPARAM- DATUM OR BIAS PARAMETERS TO DE DETERMINED.
C     LNCOL - NO COLLOCATION SOLUTIONS ARE WANTED.
C     LIOSOL- ESTABLISH OR USE RESTART FILES ON CHARACTER OR BINARY
C       FORM (UNITS 17, 18 AND 19).
C     IF LIOSOL IS TRUE, INPUT OF 5 LOGICAL PARAMETERS:
C     LWRSOL- WRITE RESTART FILE ON UNIT 17.
C     LBIPOT- WRITE BINARY FILE WITH POTENTIAL COEFFICIENTS ON UNIT 3.
C     LBICOV- OUTPUT COVARIANCE FUNCTION PARAMETERS ON BINARY FORM,
C     LBISOL- OUTPUT SOLUTION ON BINARY FORM,
C     LINSOL- INPUT CATALOGUE OF COVARIANCE FUNCTION PARAMETERS,
C       SOLUTIONS AND BOUNDARIES FOR VALIDITY OF SOLUTION ON BINARY
C       FORM. (1986.10.20 ONLY IMPLEMENTED ON RC8000).
C (2) INPUT OF PARAMETERS FOR GEOCENTRIC SYSTEM, (IF SYSTEM DEFINITION
C     NOT ALREAD GIVEN IN SUBROUTINE ICOSYS).
C (3) IF LTRAN IS TRUE INPUT OF PARAMETERS FOR SYSTEM IN WHICH DATA
C     CONTINGENTLY ARE GIVEN, AND PARAMETERS FOR TRANSFORMATION TO
C     GEOCENTRIC SYSTEM. THE SYSTEM IDENTIFICATION CODE IS 0 FOR THIS
C     SYSTEM.
C IF LINSOL IS TRUE, JUMP TO (9).
C (4) IF LPOT IS TRUE INPUT OF SPECIFICATIONS FOR POTENTIAL COEFFI-
C     CIENTS, INCLUDING A PARAMETER LFM, WHICH IS TRUE WHEN THE
C     COEFFICIENTS ARE IN THE STANDARD INPUT FILE (UNIT 5) AND
C     FALSE, IF THEY ARE INPUT THROUGH UNIT 9.
C (5) IF LFM IS TRUE INPUT OF COEFFICIENTS.
C IF LNCOL IS TRUE, JUMP TO (15)
C (6) GENERAL SPECIFICATION OF COVARIANCE FUNCTION TYPE. (SUBR. INCOV).
C (7) DETAILS CONCERNING COVARIANCE FUNCTION, AND CONTINGENTLY
C     CONCERNING TABLES USED FOR FAST INTERPOLATION OF VALUES.
C (8) IF LPARM IS TRUE SPECIFICATION OF PARAMETERS TO BE DETERMINED,
C     AND OF A SCRATCH FILE TO BE USED.
C (9) INPUT OF SPECIFICATION (FORMAT AND SEQUENCE OF ELEMENTS) OF
C     DATA SET, INCLUDING VALUE OF LIN4, TRUE IF THE OBSERVATIONS
C     ARE INPUT FROM UNIT INZ (NORMALLY EQUAL TO 4). (SUBR. DEFDAT
C     AND INHEAD).
C (10) IF LIN4 IS FALSE, THEN INPUT OF OBSERVATION RECORDS FROM
C     UNIT 5 ELSE FROM INZ. (SUBR. INP10).
C WHEN LAST RECORD IS ENCOUNTERED:
C (11) INPUT OF LSTOP, TRUE IF THE DATA SET IS THE FINAL ONE CONTRI-
C     BUTING TO THE CURRENT COLLOCATION STEP, AND OF LRESOL, TRUE
C     IF THE SOLUTIONS OR THE REDUCED NORMAL EQUATION MATRIX ARE
C     TO BE INPUT OR RE-USED, RESPECTIVELY.
C IF LSTOP IS FALSE, JUMP TO (9)
C (12) IF LRESOL IS TRUE, INPUT OF LSANEQ AND IFC. LSANEQ IS TRUE
C     IF THE IFC FIRST REDUCED COLUMS OF THE NORMAL EQUATIONS ARE
C     STORE.
C (13) IF IFC IS EQUAL TO THE TOTAL NUMBER OF OBSERVATIONS AND LRESOL
C     IS TRUE, INPUT OF THE SOLUTIONS. (OTHERWISE, THE LAST COLUMNS
C     WILL BE ESTABLISHED, REDUCED, AND THE EQUATIONS SOLVED).
C IF THE FIRST COLLOCATION STEP NOW IS TERMINATED, INPUT OF VARIABLES
C TELLING WHETHER A SECOND STEP SHOULD BE MADE, OTHERWISE JUMP TO (15).
C (14) INPUT OF LCREF, TRUE IF A SECOND STEP IS TO BE MADE AND OF
C     LPARM, TRUE IF PARAMETERS ARE TO BE DETERMINED IN A SECOND STEP.
C IF LCREF IS TRUE, THEN JUMP BACK TO (7).
C (15) INPUT OF LGRID, TRUE IF PREDICTIONS ARE TO BE MADE IN A GRID,
C     LERNO, TRUE IF ERRORS OF PREDICTION ARE TO BE COMPUTED OR RE-
C     PRODUCED IN OUTPUT (LNCOL TRUE), LCOMP, TRUE IF OBSERVED
C     AND COMPUTED QUANTITIES ARE TO BE COMPARED (DIFFERENCED) AND
C     LSPHAR, TRUE IF CORRECTIONS TO SPHERICAL HARMONIC COEFFICIENTS
C     ARE TO BE DETERMINED.
C IF LSPHAR OR LGRID ARE FALSE, THEN INPUT (9) AND (10), THEN JUMP TO (18).
C (16) INPUT OF GRID SPECIFICATIONS (START POINT, STEPS ETC.).
C (17) IF LCOMP IS TRUE, INPUT OF OBSERVATIONS IN THE GRID POINTS.
C (18) INPUT OF LSTOP. IF IT IS FALSE, JUMP TO (15), OTHERWISE
C     THE PROGRAM WILL TERMINATE.
C
C REFERENCES:
C
C  REF(A): TSCHERNING,C.C: COVARIANCE EXPRESSIONS FOR SECOND AND LOWER
C          ORDER DERIVATIVES OF THE ANOMALOUS POTENTIAL. REPORTS OF
C          THE DEPARTMENT OF GEODETIC SCIENCE NO. 225, THE OHIO STATE
C          UNIVERSITY, COLUMBUS, 1976.
C  REF(B): TSCHERNING,C.C.: A FORTRAN IV PROGRAM FOR THE DETERMINATION
C          OF THE ANOMALOUS POTENTIAL USING STEPWISE LEAST SQUARES
C          COLLOCATION, DEPARTMENT OF GEODETIC SCIENCE, THE OHIO STATE
C          UNIVERSITY, REPORT NO. 212, 1974.
C  REF(C): HEISKANEN W.A. AND H.MORITZ: PHYSICAL GEODESY, 1967.
C  REF(D): TSCHERNING,C.C.: COMPUTATION OF THE SECOND-ORDER
C          DERIVATIVES OF THE NORMAL POTENTIAL BASED ON THE
C          REPRESENTATION BY A LEGENDRE-SERIES. MANUSCRIPTA
C          GEODAETICA, VOL.1, PP. 71-92, 1976.
C  REF(E): TSCHERNING,C.C.: DETERMINATION OF DATUM-SHIFT PARAMETERS
C          USING LEAST SQUARES COLLOCATION, BOLL.GEODESIA SC. AFF.,
C          ANN. XXXV, NO. 2, 1976.
C  REF(F): TSCHERNING,C.C: IMPLEMENTATION OF ALGOL-PROCEDURES FOR
C          COVARIANCE COMPUTATION ON THE RC 4000-COMPUTER. THE
C          DANISH GEODETIC INSTITUTE INTERNAL REPORT NO. 12, 1976.
C  REF(G): SANSO, F. AND W.-D. SCHUH: FINITE COVARIANCE FUNCTIONS. 
C          BULLETIN GEODESIQUE, VOL. 61, PP. 331-347, 1987.
C  REF(H): TSCHERNING, C.C.: PREDICTION OF SPHERICAL HARMONIC
C          COEFFICIENTS USING LEAST-SQUARES COLLOCATION. JOG, 2001. 
C  REF(I): TSCHERNING, C.C.: LOCAL GRAVITY FIELD APPROXIMATION,
C          PROC. BEIJING INT. SUMMER SCHOOL, PP. 277-261, 1984.
C
      IMPLICIT NONE
      INTEGER MAXO,NSAT,MXPAR,MAXCX,NCTA,NMAP,NIPT,NIPCAT,INBLP,
     *MAXOD,NSPHAR,NDIMC,NISIZE,NCRW,NNBL,NCOEFF,NROOT,NIICC,NNSU,
     *NEQFIM,NFILTE,MAXO6,MAXO9,ICHAR,MAXBNE,NEQFMA,NEQFI,ICSYS0,
     *MODEC0,IDLAT,MLAT,IDLON,MLON,NMAX,N2,IICC,II,ICREL,NREL,
     *MAXPAR,NPARM1,NPARM,NPAOLD,NPOBS,IPA,NCXLAS,NBL2,IPTYPE,IXS,
     *IIDEG,JJORD,IIDEGM,JJORDM,IIDEG2,NII,MII,IHH,KCI,IYX,
     *MAXBLT,NT,IDIMCN,MAXC1,IS,IPX,ISO,JXS,IOBS,N1,IMAX1,
     *MAXC2,IDEG21,IT1,MAXDOU,IHX,IHH2,IHH21,IHJ,NSTEP,NSTEPE,
     *ICSYS,NLO,JIMAX,JI,MP,IPACAT,NOI,IOBS2,IH,MAXCXB,ITO1,IANG,
     *IOBS1,IMAP,NOI1,INO,ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,
     *ILAST,NGR,NGRERR,NFOURI,NFOUR,KP,KPP1,JR,IORDER,ITRAC0,
     *IPC,IB,IA,IC1,IP,ITE,IT,K1,IIE,IIE1,IIP,IIP1,IITE,IITE1,IU,
     *K2,K21,IP1,NO2,INUMR,ITIME,NOX,NPNO,KK,ITIME0,IB1,ITE1,
     *IOBSR,NIR,IMAX1R,IC11,IC,IU1,KL,NREL0,MAXC,
     *IA1,NGRE,IPR,NLAST,NFIRST,JJ,NGRR,IGRR,NWAR,NBOLD,
     *IDIMC,NFILE,IGG,IGP,ITCOUN,INV,INN,NUM,K4,K3,ISIZE,MAXBL,
     *NBL,ISZE,NCAT,JOLD,IIOLD,K2P3,NDQ,NDP,NDX2,NDX1,KSAT,NSTART,
     *NHE,NTABH,NINTH,KEYH,NFU,IOLD,II0,IM6,IM5,IM4,IM3,IM2,IM1,
     *IMX,IZ3,IZ2,IZ1,IS1,ISX,ITX1,ITX,IX,MAXB,NC2,IZ,ICX,NC1,
     *NWRITE,NREAD,MAXSA,MAXSA9,IPAMAX,NERRM,ICODE,IDSAT,NPRED,
     *NPRED1,NRCAT,IRSZE,I61,I62,NPOINT,NCXP,NERCOV 
C NON-ACTIVE INTEGERS.
C     INTEGER I61,NBLP,NBLP(INBLP)   
      LOGICAL LIBM66,LLCOER,LTESTS,LNX,LX,LNOUSE,LINERT
      REAL*8 RCBASE,D0,D1,D2,D3,D4,D5,CPU0,EE0,AX2,GG,GREF,F2,GM2,
     *HCZERO,UREF0,FG,FJ,DSHIF0,AX1,GM1,F1,DX,DY,DZ,E22,UREF,
     *SLAT,SLON,DKSI0,DETA0,DZETA0,RLONG0,SINLA0,COSLA0,COSDLO,SINDLO,
     *W2,W,RN,RM,X,Y,Z,RADSEC,X1,E21,GMP,AX,CM3,CMM2,CM1,OMEGA2,
     *C20IN,DGVAR,SQ2,SUS,SS,SSC,SIGMA0,GMC,RE,SIGD,SSOBS,CPU1,
     *CX,CCII,CCJJ,SII,SSII,SOERR,SUMIJ,TMEAN,TSTDV,TVARI,SSCO,
     *RLONGP,RLATP,RLATP1,SINLOP,COSLOP,HP,CC,S,AAI,PW2,SATROT,ROTSAT,
     *C,OERR,TCOBS,TCOEFF,DIFII,PREDP,TOERR,SI,SSI,SCO,DIFI,BSIZEE,
     *BSIZEN,STEPE,DM,DA,RLAMIN,RLAMAX,RLOMIN,RLOMAX,SLAC,SLOC,
     *GLA,GLO,RP,VG,FILTER,SAZP,CAZP,H,H0,OBS,HPK,WM,
     *CCI,PI,PI4,REJLEV,FOUCOF,VARNO,RDD,SCFACT,PW,
     *COSLAP,SINLAP,COSSTE,SINSTE,STEPN,COSSTN,SINSTN,SHIFTS,
     *COST2P,SINT2P,BSIZEA,DEGRAD,SINB,SINT,COST,RRE,
     *COSB,OBI,RLATS,RLONGS,SINLA,COSLO,COSLA,SINLO,REF,REF1,REFI,REF2,
     *REF3,VREF,COSLA1,REF0,POT,GP,DUDX,DUDY,G1,RG,G2,POT00,
     *DISTO,DIST2,SR,AAR,PRETAP,OB1,B,WOBS,RB,HPP,XY,DLATP,
     *COSLAT,SINLAT,COSLON,SINLON,RLONG,RLAT,HQ,DOBS,OB2,COSAZ,SINAZ,
     *SR11,SR12,SR13,CNR,CCR,BSIZE,SCFRDD,CPU2,PRV,PRVE,
     *SGRE,CPU5,VAR,SYTIME,SU8,SM,OLDB,SR22,
     *SINT2Q,COST2Q,SINSQE,COSSQE,STEQE,SINSQN,COSSQN,STEQN,DL,
     *EPS1,EPS2,EPS3,CFA,OLDR,OLDT,ROOT,DZERO,SCALE,SCALE2,VARI,
     *DXX,XY2,DDC,DDS,GC,GS,V1,VV,YC,YS,CCCIJ,CLOQ,CLOP,SLOP,
     *SIGMAP,CFX,CIX,COVX,SIZEI,TMAX,HTA,RTA,AZ,SZ,CTSF,CTTF,CTA,
     *SLOQ,DC,CCV,HCMAX,SIGMA,GM,SU1,CU,RGRAV,RLAT0,PPS,PPA,
     *SR11A,SR12A,SR13A,SR22A,COSAZA,SINAZA,AZP,BETP,TAUP,SFACT,
     *ERCOV(500),CR,CTIME,PRCOEF,ERCOEF,CLATD,RDI
      REAL*16 SU

C
C ONE OR MORE OF THE FOLLOWING PARAMETERS ARE ALSO FOUND IN THE
C SUBROUTINES GEOCOLH, INCOV, BLKDTA000, PRED, ISPCOV, SPLCOV,
C CTABEL, COVCG, INTABH, TABH. THEY ARE ALSO FOUND IN THE MODULES
C INCOV, ETC. 
      PARAMETER (MAXO=16200,NSAT=16200,MXPAR=2500,MAXCX=28920,NCTA=1600,
     *NMAP=400,NIPT=1500,NIPCAT=100002,INBLP=150,MAXOD=9*MAXO,
     *NSPHAR=180,MAXSA=6*MAXO) 
C MAXOD MUST BE EQUAL TO 9*MAXO. NIPCAT MUST BE EQUAL TO MAXIMAL
C NUMBER OF DATA USED WHEN LPARAM IS TRUE. PAGING OF DATA ITIME WILL BE
C IMPLEMENTED. 2003-04-22.
      PARAMETER (NDIMC=399120,NISIZE=880,NCRW=400000,NNBL=20000)
C     PARAMETER (NDIMC=99986000,NISIZE=14000,NCRW=100000000,NNBL=20000)
C MAXO IS USED IN THE COMMON BLOCKS PR AND CPARM AND IN THE DIMENSION
C STATEMENT. 
C
C PARAMETERS GIVING THE SIZE OF THE ARRAYS HOLDING POTENTIAL
C COEFFICIENTS FOR MAX=(NNSU/10) (REALS), NNSU/5 (INTEGERS). AND 180. 
C THEY ARE ALSO FOUND IN SETCM, LOADCS, GEOCOLH, GPOTDR AND CXPARM.
C
C     PARAMETER (NCOEFF=3243602,NROOT=3602,NIICC=1621801,NNSU=18010)
      PARAMETER (NCOEFF=4844402,NROOT=4402,NIICC=2422201,NNSU=22010)
      PARAMETER (NEQFIM=60)
C
      REAL*4 COFF
C THIS MAY BE CHANGED TO REAL*8 IF NEEDED. 2005-05-25.
      LOGICAL LUSNGS,LCDC,LIBM77,LMAP7,LMAP7E,LTERRC,LNUOUT,LPOTIN,
     *LINTRA,LINT,LDENOL,LADBTE,LK2EQ4,LTERMO,LTERMA,LSTNO,
     *LFOR77,LONECO,LNKSIP,LNETAP,LDEFVP,LGRP,LNGR,
     *LC1,LC2,LCREF,LKM,LNEQ,LT,LPOSDA,LDEFF,LF,LGRID,LERNO,LERCOV,
     *LNDAT,LNEWD,LCOD,LPUNCH,LOUTC,LNERNO,LK30,LCHANG,LIN4,LGIGRS,
     *LFM,LRESOL,LMAP,LMEGR,LMEAN,LSTOP,LE,LTRAN,LNPOT,
     *LBIN,LFORM,LNFORM,LSA,LREPEC,LZETA,LKSIP,LINVDE,LADBPR,LADDBC,
     *LALLP,LEQP,LNEWDA,LFIRST,LSUM,LOCAL,LP,LONEQ,LADDBP,LADBA,
     *LSTAT,LTEB,LTNB,LOE1,LOE2,LWRSOL,LPARAM,LPOT,LNCOL,LCOLLO,
     *LDEN,LMDD,LCOMP,LPOTSD,LLEG,LCOM,LWLONG,LAREA,LPRED,LOPCOF
     *,LK31,LCLU7,LOPEN7,LTABLE,LTABLR,LMENSI,LSIMH,LEQANG
     *,LCO1,LIOSOL,LINSOL,LBICOV,LBISOL,LBIPOT,LNEQ8,LNEWSO,LDPR 
     *,HP9000,LOPEN4,LGRADI,LTABH,LTEST,LTIME,LTCOV,LADMU,LICL,LUNIX 
     *,LSATP,LGRERR,LFOUND,LINTER,LOK,L386,LOBSST,LMEAN1,LFILTE,LSMAL       
     *,LGRERS,LCZERO,LCTIME,LCOERR,LLCOEE,LSKIPL,LSPHAR,LSPOUT,LTSPH 
     *,LSPHER,LFOURI,LFOUR,LFULLO,LNBL1,LSATAC,LSTART,LTILT,LOUTCO,
     *LEROUT,LWAIT
C    *,LOUTS
C
      INTEGER I,J,K,N,ITMODE,ITMOD,ITM0,ITRACK,
     *NO,NO1,ICSYSL,NAI,NLA,INL,IEM,INZOLD,ITRGAP,ITOLD,ITROLD,
     *ICZERO,NCZERO,NI,NR,INDEX,IKP,ISAT,ISATP,NOBLK,N19,N20,ITRACE
C
      CHARACTER*128 DNAME,DNANE,CNANE,SNAME,PNAME,PNA0,OLDN,UDATE,
     *ERNAME,OLDCOV,ROTFIL,PCOEF
C 386 CHARACTER*72 UTIME
      CHARACTER*128 FMT,CCFILE,DCOVA,DERCOV,POSFIL 
C
      COMMON /CON1/OLDN(4)/CON2/GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,
     *ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
C THESE VARIABLES HAVE BEEN PLACED IN COMMON, SO THAT THEY MAY BE
C INITIALIZED BY THE BLOCK DATA MODULE.
C
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
C    *COSAZ(NSAT),SINAZ(NSAT),SINLOP,COSLOP,
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C THE FIRST 9 QUANTITIES ARE PAGED TO  UNIT 16, IF THE NUMBER OF OBS
C EXCEEDS MAXO.
C IN /PR/ IS STORED: 
C B    THE CONSTANTS (SOLUTIONS),
C HQ   THE HEIGHT OF THE OBSERVATION POINT (Q),
C RLAT,SINLAT,COSLAT THE LATITUDE (RADIANS) AND COS AND SIN.
C RLONG,SINLON,COSLON, LONGITUDE (RADIANS), SIN AND COS,
C WOBS THE OBSERVATION ERRORS
C COSAZ, SINAZ: COS AND SIN OF AZIMUTH (E.G. FOR TRACK),
C SINLOP, COSLOP, SIN AND COS OF LONGITUDE OF PREDICTION POINT P,
C BSIZE, BLOCKSIZE, BSIZEN, BSIZEE BLOCK SIZE IN NORTH AND EAST,
C COSLAP, SINLAP COS AND SIN OF LATITUDE OF P,
C RLONGP LONGITUDE OF P (RADIANS),
C RP   THE DISTANCE OF P FROM THE ORIGIN,
C CAZP, SAZP COS AND SIN OF AZIMUTH OF P,
C HP, RLATP HEIGHT AND LATITUDE OF P,
C PRETAP, PREDP PREDICTED VALUE OF 2 COMPONENT (E.G. ETA) AND OF P.
C HCZERO,ICZERO,NCZERO
C NI, NR COUNTERS OF OBS AND OBS POINT (THERE MAY BE TWO OBS
C     PER POINT)
C INDEX  THE CATALOGUE OF THE OBSERVATIONS (INDEX),
C IKP THE OBSERVATION TYPE,
C ISAT   CATALOGUE OF OBSERVATIONS ATTITUDE DEPENDENCE (POINT,
C        HORIZONTAL PLANE ROTATION, 3-D ROTATION).
C ISATP  ATTITUDE DEPENDENCE OF P.
C NOBLK  CURRENT NUMBER OF BLOCK WHERE DATA ARE STORED ON UNIT 16.
C LOBSST TRUE IF DATA ARE STORED ON UNIT 16.
C THE OTHER LOGICAL VARIABLES ARE USED TO DISTINGUISH
C BETWEEN THE DIFFERENT PREDICTION SITUATIONS. THE COMMON BLOCK IS ALSO
C FOUND IN BLOCK DATA, PRED, OUTSOL AND INSOL. 
C
      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),SATROT(3,3) 
C THE COMMON BLOCKS CONTAINS THE ELEMENTS OF THE ROTATION MATRIX
C AND OF THE CURRENT ROTATION MATRIX (SATROT).
      COMMON /ROTA/SR11A(NSAT),SR12A(NSAT),SR13A(NSAT),SR22A(NSAT),
     *COSAZA(NSAT),SINAZA(NSAT) 
C ADDED 2003-10-05 FOR TRANSFER TO PRED WHEN LOBSST=F.
C 
      COMMON /CMCOV/CCI(24),CCR(56),SIGMA0(2200),SIGMA(2200),HCMAX,
     *CCV(2,2),DC(36),KCI(37),NC1,NC2,LOCAL,LSUM
C COMMON VARIABLES USED IN COVAX. SEE THIS SUBROUTINE FOR VARIABLES.
C
      COMMON /TABELC/CTA(NCTA,16,2),CTTF(800),CTSF(20),SZ(30),AZ(18),
     *MAXB(20),IX(8),ICX,ITX,ITX1,ISX,IS1,IZ,IZ1,IZ2,IZ3,IMX,IM1,
     *IM2,IM3,IM4,IM5,IM6,II0,IOLD
C COMMON VARIABLES USED IN CTABEL AND COVCG.
C
      COMMON /CTABH/RTA(1200),HTA(5),TMAX,SIZEI,NFU(5),KEYH(5,5),
     *NINTH,NTABH(15,5,5),NHE,NSTART,LTABH
C COMMON VARIABLES USED IN INTABH AND TABH.
C
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFX,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP,NDQ,NWAR,LX(7,5),LNX(7,5),LTESTS 
C
      COMMON /PDEGV/SIGMAP(2200),SLOP,SLOQ,CLOP,CLOQ,
     *IIDEG,JJORD,LSPOUT
C ARRAYS TO HOLD COVARIANCES OF SPHERICAL HARMONICS, AND THE
C ACCUMULATED SUM ADDED 2000-01-13 BY CCT.
C     COMMON /CON3/SUMIJ(32761),CCCIJ(32761),
C CHANGED 2004-11-08.
      COMMON /CON3/SUMIJ((NSPHAR+1)**2),CCCIJ((NSPHAR+1)**2),
     *SQ2,YS,YC,VV,V1,GS(3),GC(3),DDS(3,3),
     *DDC(3,3),IIOLD,JOLD,LSPHAR,LTSPH
C HOLDS VARIABLES USED IN SPHAR CALC. 1999-05-17.
C
      COMMON/DAT/LNEWD,LRESOL,LGRID
C /DAT/ TRANSFERS LOGICAL VARIABLES TO THE SUBROUTINE ITRAN.
C
      COMMON /EUCL/X,Y,Z,XY,XY2,DISTO,DIST2
C IN /EUCLID/ ARE STORED: THE EUCLIDIAN COORDINATES OF A POINT, THE
C DISTANCE AND THE SQUARE OF THE DISTANCE FROM THE Z-AXIS XY, XY2 AND
C THE DISTANCE AND THE SQUARE OF THE DISTANCE FROM THE ORIGIN DIST0
C AND DIST2.
C
      COMMON /NESOL/C(NDIMC),NCAT(NISIZE),ISZE(NISIZE),NBL(NNBL),
     *MAXBL,ISIZE 
C IN /NESOL/ ARE STORED: THE ARRAY C USED TO TRANSFER THE COEFFICIENTS
C OF THE NORMAL EQUATIONS AND THE SOLUTIONS TO AND FROM DISK-STORAGE,
C NCAT, ISZE AND NBL HOLDS INFORMATION ABOUT THE STORAGE SEQUENCE OF THE
C COLUMNS, MAXBL IS THE NUMBER OF BLOCKS OF SIZE C+NCAT+ISZE USED ON THE
C DISK. 
      COMMON /CRW/CR(NDIMC),NRCAT(NISIZE),IRSZE(NISIZE) 
C
      COMMON/NESOL1/NEQFI(NEQFIM,2),NEQFMA,MAXBNE,LNBL1
C HERE ARE STORED NAMES AND SIZES OF FILES USED TO HOLD THE UPPER-
C TRIANGULAR PART OF THE NORMAL EQUATIONS.
C
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
C IN OUTC ARE STORED SUBSCRIPTS OF VARIABLES TO BE OUTPUT AND LIMITS
C FOR DO-LOOPS IN OUTPUT. NOTE THAT OUTC OCCURS IN SUBROUTINES
C HEAD, COUT, CXPARM AND THE BLOCK DATA MODULE.
C
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
      COMMON /CHEAD1/LC1,LC2,LCREF
C IN /OUTC/ AND /CHEAD/ ARE STORED INFORMATION USED TO HANDLE THE DIF-
C FERENT I/O SITUATIONS.
      COMMON /COM2/DXX,NUM(70),VARI(32),SCALE,SCALE2,INN,INV
C USED BY COMPA, COMPARING OBSERVED AND PREDICTED QUANTITIES.
C
      COMMON/OBSER/OBS(22)
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C COMMON CONSTANTS D0=0.0D0  ETC.
C
      COMMON/SQROOT/DZERO,ROOT(NROOT)
C SQUARE-ROOT TABLE USED IN GPOTDR.
      COMMON /GPOTC0/C20IN,G1(3),G2(3,3),CM3,CMM2,CM1
C C20IN HOLDS C20, G1 THE FIRST DERIVATIVES, G2 THE SECOND DERIVATIVES.
C 
      COMMON /GPOTC3/COFF(NCOEFF)
C QUASI NORMALIZED SPHERICAL HARMONIC COEFFICIENTS, UNITLESS.
      COMMON/GPOTC1/OLDT,OLDR,CFA,IGP(12),LFIRST,HP9000
C COMMON VARIABLES USED IN GPOTDR, SETCM ,LOADCM, PRED AND CXPARM.
C
      COMMON /GRAVCC/FG(30),FJ(30),LP(2),OMEGA2,IORDER
C COMMON VARIABLES USED IN GRAVC AND RGRAV, HOLDING I.E. COEFFICI-
C ENTS OF LEGENDRE SERIES OF NORMAL POTENTIAL AND NORMAL GRAVITY
C FORMULA.
      COMMON /ITRANC/SINLA0,COSLA0,RLONG0,
     *DX,DY,DZ,EPS3,EPS2,EPS1,DL,AX2,E22
C DATUM SHIFT PARAMETERS.
      COMMON /CCOSYS/EE0(3),DSHIF0(7),MODEC0
C
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON/CCTIME/CTIME(NIPCAT),ITRACE(NIPCAT),ITMODE,ITM0,ITMOD,
     *ITRGAP,ITRACK,ITOLD,NERCOV,LCTIME,LCOERR,LLCOER
C SEE SUBROUTINE PARCAT FOR DESCRIPTION OF CPARM. THE COMMON BLOCK
C IS ALSO IN CXPARM, GEOCOLH, WRPAR, BLOCK DATA AND PRED. 
C ADDED 1997-07-15 AND CHANGED 2005-03-20: ITRACE IS USED
C TO IDENTIFY CORRELATED OBSERVATIONS. IF ITRACE(N)=ITACE(M) AND < 0 THEN
C THE OBS N AND M HAVE CORRELATED ERRORS. THE GLOBAL VARIABLE LCOERR MUST
C BE TRUE. 
C
C COMMON ADDED 1997-07-15 TO TRANSFER PARAMETERS FOR ERROR-COV.FCT.
C CHANGE 2002-09-12 AND 2005-03-12. MAY NEED FURTHER CHANGE..
      COMMON /CLPARM/SCFRDD(42),SCFACT,RDD,FOUCOF(0:21),NFOURI(42),
     *NFOUR,LFOURI(42),LLCOEE(42),LFOUR
C
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE  
      COMMON /CMEAQ/STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q 
C STEPSIZES USED WHEN CALCULATING MEAN VALUES.
C
      COMMON /BIPAR/OLDB(4),CNR,GMP,AX,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT
C
      COMMON /BIPARC/OLDCOV(2),S,SR,AAI,AAR,NBOLD,IS,IPX,
     *IMAX1,IMAX1R,LTABLE,LTABLR,LCO1
C DATA USED WHEN STORING SOLUTIONS OR COVARIANCE FUNCTION ON
C BINARY FORM. (CHANGE MADE NOV 1986).
C
      COMMON /COBS/CLATD,RDI,SLAT,SLON,IDLAT,IDLON,MLAT,MLON,NOX,LFORM
C USED WHEN READING ANGULAR INFORMATION.
      COMMON /CCOMP/LUNIX,LIBM66,LIBM77,LICL,LCDC  
C 
      COMMON /CDEFCA/VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,
     *SGRE(10),
     *ROTFIL,ERNAME,DNAME(2),FMT(9),NSTEP,NSTEPE,IDSAT,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,
     *IPAMAX,NGR,NGRE(10),ICSYS,
     *LMEAN,LSA,LADMU,LSTAT,LAREA,LZETA,LGRADI,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LTILT,LINERT
C TRANSFERS VARIABLES FROM DEFDAT.
C
      COMMON /CINHEA/SHIFTS,PW2,BSIZEA,E21,AX1,F1,GM1,GREF,SM(2200),
     *UREF,KP,KPP1,IPC,
     *LSMAL,LADBPR,LADBTE,LNGR
     *,LKSIP,LNCOL,LTNB,LTEB,LOE1,LOE2,LE
C TRANSFER VARIABLES FROM INHEAD.
C
      REAL*8 PREDCO(13),PREDCP(13),COVPQ,CPQ
C VARIABLES USED WHEN CALCULATING ERROR COVARIANCES.
C
      DIMENSION IMAP(NMAP),PNAME(2),CX(MAXCX),
     *DNANE(2,NEQFIM),PRV(10),PRVE(10),PNA0(2),OBI(22),CNANE(2),
     *RG(3,3),VREF(3),DOBS(MAXOD),TOERR(NSPHAR,4)
      DIMENSION SNAME(300),TCOEFF(32761),ROTSAT(MAXSA)
C MUST BE USED IF  IF ISYS0 IS ACTIVATED.
      DIMENSION SU(NNSU),SU8(NNSU)
      DIMENSION CC(NCRW) 
      DIMENSION IICC(NIICC)
      DIMENSION PRCOEF(-NSPHAR:NSPHAR),ERCOEF(-NSPHAR:NSPHAR)
C THE ARRAYS HOLDS PREDICTED COEFFICIENTS AND ERROR-ESTIMATES OF
C THE SAME DEGREE.
      REAL TIMEARRAY(2) 
C     REAL DTIME,TIMEARRAY(2)  - CHANGE 2000-06-23.
C     INTEGER TIME 
C
      EQUIVALENCE (C(1),CC(1)),(COFF(1),IICC(1)),(SR11(1),ROTSAT(1)),
     *(VREF(1),REF1),(VREF(2),REF2),(VREF(3),REF3),
     *(DOBS(1),B(1))
C DOBS COLLECTS SEVERAL ARRAYS IN COMMON BLOCK PR INTO ONE IN ORDER
C TO FACILTATE TRANSFER TO DISC.
C
      RCBASE=D0     
      CPU0=SYTIME(RCBASE,TIMEARRAY) 
      NERRM=0
C
C HEADINGS AND DEFINING CONSTANTS.
C
C LIBM66 IS TRUE IF WE RUN FORTRAN 66 ON AN IBM COMPUTER, LIBM77
C IS TRUE IF RUN USING A FORTRAN 77 COMPILER, LCDC IS TRUE IF WE
C RUN ON A CDC, USING CDC-FORTRAN 5, HP9000 IS TRUE IF WE RUN
C FORTRAN 77 ON A HP9000 AT NOAA/NGS OR VAX AT NORSK HYDRO, BERGEN.
C LICL IS TRUE IF WE USE AN ICL-COMPUTER (UNIV. OF NOTTINGHAM).
      LIBM66=.FALSE.
      LICL=.FALSE.
      LIBM77=.FALSE.
      LCDC=.FALSE.
      HP9000=.FALSE.
      LUNIX=.TRUE. 
      LFOR77=LIBM77.OR.LCDC.OR.HP9000.OR.LICL.OR.LUNIX 
C THE LOGICAL VARIABLE LDPR IS TRUE, WHEN DOUBLE PRECISION IS USED.
C THIS IS USED, TO BREAK SOME LONG INTEGER STATION NUMBERS IN TWO. 
      LDPR=.TRUE. 
      LFILTE=LF 
      NFILTE=5
      LSPHAR=LF
      LTSPH=LF
      LCZERO=LF
      LFULLO=LF
      LNBL1=LF
      LSATAC=LF
C NEXT TWO STATEMENTS ADDED 2004-11-05.
      LGRERR=LF
      LGRERS=LF
      LNOUSE=LF
C FULL PRECISION PI ADDED 2003-06-01.
      PI4=ATAN(1.0D0)
      PI=4.0D0*PI4
      DEGRAD=PI/180.0D0 
C
      WRITE(6,104)
  104 FORMAT(' GEODETIC COLLOCATION, VERSION 2005-02-24 RELEASE',
     *' 17 REV. SVN 259 ')
C *** THE CALL OF ATIME MUST BE DELETED IN A NON UNIX ENVIRONMENT *** 
C APP IF (LUNIX)I=ATIME(UDATE) 
      IF (LUNIX) THEN
       CALL FDATE(UDATE)        
       WRITE(6,*)UDATE 
      END IF 
C 386 CALL DATE(UDATE)
C 386 CALL TIME(UTIME)
C 386 WRITE(6,*)UDATE,UTIME
      WRITE(*,112)
  112 FORMAT(/' NOTE THAT IF SPHERICAL APPROXIMATION IS USED',
     */' MEAN RADIUS = RE = 6371 KM AND MEAN GRAVITY 981 KGAL ',
     *'USED.',/)
      WRITE(6,113)MAXO,MXPAR,NIPCAT,NDIMC,NCOEFF
  113 FORMAT(/,
     *' MAX NUMBER OF OBS PER RECORD =',I5,
     *', MAX NUMBER OF PARAMETERS=',I5,/,
     *' MAX NUMBER OF DATA DEPENDING ON TILT ',
     *' OR SCALE FACTOR-PARAMETERS ',I7,/,
     *' SIZE OF NORMAL EQ. BLOCKS=',I10,', SIZE OF POT.COFF. BLOCK=',I8)
      IF (MAXOD.NE.9*MAXO) WRITE(*,*)' **** WARNING, MAXOD= ',MAXOD 
C
C *************** INPUT (0) **********************************
C
      WRITE(6,*)' INTERACTIVE INPUT (T/F)'
      READ(5,*)LINTER  
      IF (LIBM77) THEN
       IF (LINTER)
     * WRITE(6,*)' ARE BUFFERS COUNTED IN WORDS ? (T/F)'
       READ(5,*)HP9000
       IF (HP9000) LIBM77=LF
      END IF 
      IF (LIBM77.OR.LUNIX) THEN 
       MAXO6=MAXO*6*8
       MAXO9=MAXO*9*8 
       MAXCXB=MAXCX*8 
       MAXSA9=MAXO*6*8
      ELSE
       MAXO6=MAXO*6*2
       MAXO9=MAXO*9*2
       MAXCXB=MAXCX*2 
       MAXSA9=MAXO*6*2
      END IF 
      WRITE(*,*)' BUFFER SIZE MAXO9 = ',MAXO9
C
C *************** INPUT (1) **********************************
C
C INPUT OF 8 LOGICAL VARIABLES:
C LSPHER  = TRUE IF CALCULATIONS ARE DONE IN SPHERICAL APPROXIMATION.
C LTRAN   = INPUT VALUES FOR USER DEFINED DATUM (CODE 0).
C LPOT    = POTENTIAL COEFFICIENTS ARE TO BE USED AS FIRST SET OF
C           OBSERVATIONS.
C LTEST   = TEST OUTPUT NEEDED ACCORDING TO SPECIFICATIONS IN INPUT
C           1D.
C LLEG    = OUTPUT LEGEND OF TABLES ON UNIT 6.
C LPARAM  = PARAMETERS ARE TO BE DETERMINED IN FIRST COLLOCATION
C           STEP.
C LNCOL  = COLLOCATION STEPS WILL NOT BE EXECUTED (I.E. NO INPUT OF
C          OF COVARIANCE FUNCTION PARAMETERS).
C LIOSOL = WRITE INPUT PARAMETERS, OBSERVATIONS AND SOLUTION ON
C          UNIT 17, SO THAT THE SOLUTION MAY BE RETRIEVED, OR WRITE
C          OR READ COVARIANCE FUNCTION AND SOLUTION ON BINARY FORM.
C
C IN ORDER TO BE ABLE TO USE UNIT 17, WE WILL SUPPOSE THAT IT IS A
C NON-PRINTER LIKE DEVICE, WHICH DO NOT USE THE FIRST CHARACTER IN
C AN OUTPUT RECORD AS A CONTROL CHARACTER.
C
C IF LIOSOL IS TRUE, INPUT OF THE FOLLOWING LOGICAL VARIABLES:
C LWRSOL = WRITE SOLUTION ON UNIT 17, (RESTART FILE).
C LBIPOT = WRITE POTENTIAL COEFFICIENTS ON UNIT 3.
C LBICOV = WRITE COVARIANCE FUNCTION PARAMETERS ON UNIT 18, BINARY,
C LBISOL = WRITE SOLUTION PARAMETERS ON UNIT 19, BINARY,
C LINSOL = READ CATALOGUE OF BINARY FILES OF COVARIANCE FUNCTION
C          AND SOLUTION PARAMETERS WITH AREA OF VALIDITY BOUNDARIES,
C          SEE SUBROUTINE INSOL.
C
C FOLLOWING THE INPUT OF THE LOGICAL VARIABLES ARE THE NAMES OF THE
C FILES USED TO STORE VARIOUS TYPES OF DATA:
C LWRSOL= TRUE: NAME OF RESTART FILE,                  (UNIT 17).
C LBIPOT= TRUE: NAME OF FILE TO HOLD POTENTIAL COEFFICIENTS (UNIT 3).
C LBICOV= TRUE: NAME OF FILE TO HOLD COVARIANCE FUNCTION PARAMETERS.
C LBISOL= TRUE: NAME OF FILE TO HOLD SOLUTION PARAMETERS.
C LINSOL= TRUE: NAME OF FILE HOLDING CATALOGUE OF SOLUTIONS.
C LNCOL TRUE, OR LINSOL IS TRUE, BUT SOLUTIONS ARE NOT YET COMPUTED,
C    NAME OF FILE HOLDING NORMAL EQUATIONS (UNIT 8).
C
C --------------- INPUT (1A) ---------------------------------
C
 1100 IF (LINTER) WRITE(6,1101)  
 1101 FORMAT(
     *' INPUT: LSPHER, TRUE IF SPHERICAL APPROXIMATION IS USED.',/
     *'        LTRAN, TRUE IF NON-STANDARD REF. SYSTEM IS USED',/
     *'        LPOT,  TRUE IF SPHERICAL HARMONIC EXPANSION IS USED',/
     *'        LTEST, TRUE IF TEST-OUTPUT IS NEEDED',/
     *'        LLEG,  TRUE IF LEGEND IS TO BE OUTPUT',/
     *'        LPARAM,TRUE IF PARAMETERS ARE TO BE DETERMINED',/
     *'        LNCOL, TRUE IF COLLOCATION IS NOT USED',/
     *'        LIOSOL,TRUE IF SOLUTION IS STORED OR RECOVERED') 
      READ(5,*)LSPHER,LTRAN,LPOT,LTEST,LLEG,LPARAM,LNCOL,LIOSOL
  105 FORMAT(8L2)
      LCOLLO=.NOT.LNCOL
      IF (LSPHER) THEN
       WRITE(*,*)' SPHERICAL APPROXIMATION IN USE. '
      ELSE
       WRITE(*,*)' SPHERICAL APPROXIMATION NOT  IN USE. '
      END IF
C
C --------------- INPUT (1B) ---------------------------------
C
      IF (LIOSOL.AND.LINTER)WRITE(6,1102)
 1102 FORMAT( 
     *' INPUT: LWRSOL, TRUE IF SOLUTION IS OUTPUT ON UNIT 17',
     *'        LBIPOT, LBICOV,LBISOL, TRUE IF POTENTIAL COEFF.',/
     *'        COVARIANCE FCT. TABLE OR SOLUTION IS OUTPUT BINARY',/ 
     *'        LIOSOL, TRUE IF BINARY SOLUTION IS USED') 
      IF (LIOSOL) READ(5,*)LWRSOL,LBIPOT,LBICOV,LBISOL,LINSOL 
      ICHAR=1
C ICHAR IS EQUAL TO THE MAXIMAL NUMBER OF ELEMENTS USED IN DNAME OR
C DNANE.
C
C --------------- INPUT (1C) ---------------------------------
C
C INPUT OF FILE NAMES:
      IF (LWRSOL) THEN       
       IF (LINTER)WRITE(6,*)' INPUT NAME OF FILE TO HOLD SOLUTION' 
       READ(5,2103)DNAME(1)
 2103  FORMAT(A128)
       WRITE(6,162)(DNAME(I),I=1,ICHAR)
  162  FORMAT(' NAME OF RESTART FILE=',2A128)
       OPEN(17,FILE=DNAME(1),STATUS='UNKNOWN',FORM='FORMATTED')
      END IF
C
      IF (LBIPOT) THEN       
C
C INPUT OF NAME OF FILE TO HOLD POTENTIAL COEFFICIENTS ON BINARY
C FORM (UNIT 3).
       IF (LINTER)WRITE(6,*)' INPUT NAME OF FILE TO HOLD COEFF.'
       READ(5,2103)PNA0(1)
      END IF
C
      IF (LBICOV) THEN      
C INPUT OF NAME OF FILE TO HOLD COVARIANCE FUNCTION PARAMETERS ON
C BINARY FORM.
       IF (LINTER) WRITE(6,*)' INPUT NAME OF FILE TO HOLD COVFCT' 
       READ(5,2103)CNANE(1)
      END IF
C
      IF (LBISOL.OR.LINSOL)  THEN
C INPUT OF NAME OF FILE TO HOLD SOLUTION PARAMETERS ON BINARY FORM.
       IF (LINTER) WRITE(6,*)' INPUT NAME OF FILE WITH BINARY SOL.' 
       READ(5,2103)SNAME(1)
C
C      IF (LINSOL) ICSYS0=INITSO(NBLO,NBLP,SNAME,PNAME,BOUNDS)
      END IF
C
      IF (LCOLLO) THEN
C CHANGE 2004-11-08.
       LNEQ=LT
       LE=LT
       MAXBNE=2.0D0**23/NCRW+1
       WRITE(*,*)MAXBNE,' BLOCKS IN EACH FILE NEEDED '
C
C --------------- INPUT (1D) ---------------------------------
C
       IF (LINTER) WRITE(*,*)' INPUT NUMBER OF FILES TO HOLD NEQ '
       READ(*,*)NEQFMA
C ADDED 2004-06-21.
       IF (NEQFMA.GT.NEQFIM) THEN
        WRITE(*,*)' NUMBER TOO LARGE, MAX= ',NEQFIM
        STOP
       END IF
       DO I=1,NEQFMA
C INPUT OF NAME OF FILE HOLDING NORMAL EQUATIONS.
        IF (LINTER)WRITE(6,*)' INPUT NAME OF FILE WITH NORMAL EQ.' 
        READ(5,2103)DNANE(1,I)
        WRITE(6,163)(DNANE(J,I),J=1,ICHAR)
  163   FORMAT(' NAME OF FILE HOLDING NORMAL EQUATIONS=',2A128)
        IF (LINTER) WRITE(*,*)
     *  ' INPUT FORTRAN UNIT NO (> 20) AND SIZE IN  BLOCKS'
        READ(*,*)NEQFI(I,1),NEQFI(I,2)
C CHANGE 2001-07-17.
        IF (NEQFI(I,1).LT.20) THEN
         NEQFI(I,1)=NEQFI(I,1)+20
         WRITE(*,*)' UNIT NUMBER MUST BE LARGER THAN 20, SET TO ',
     *   NEQFI(I,1)
        END IF
        WRITE(*,*)NEQFI(I,1),NEQFI(I,2)
       END DO   
      ELSE
       LNEQ = LF
       LE=LF
      END IF
C
      IF(LWRSOL) THEN
       IF (LUNIX) WRITE(17,805)LSPHER,LTRAN,LPOT,LPARAM
  805  FORMAT('F',/,3L2,' F F',L2,' F F')
       IF (.NOT.LUNIX) WRITE(17,806)HP9000,LTRAN,LPOT,LPARAM
  806  FORMAT('F',/,L2,/,2L2,' F F',L2,' F F')
       WRITE(17,*)NEQFMA
       IF (.NOT.LNCOL) THEN
        DO I=1,NEQFMA
         WRITE(17,2103)(DNANE(J,I),J=1,ICHAR)
         WRITE(17,*)NEQFI(I,1),NEQFI(I,2)
        END DO   
       END IF
      END IF
C
C ------------------------- INPUT (1E) ----------------------------
C
C IF LTEST IS TRUE INPUT OF THE FOLLOWING LOGICAL VARIABLES:
C LONEQ   = OUTPUT OF COEFFICIENTS OF NORMAL EQUATIONS TO UNIT 6.
C LTIME   = OUTPUT OF USED CPU TIME (UNIX).
C LTCOV   = OUTPUT OF TEST-DATA FROM COVARIANCE FUNCTION ROUTINES.
C LCZERO  = TRUE, IF FINITE COVARIANCES ARE TO BE USED, CF. REF(G).
C LCOERR  = TRUE IF ERRORS ARE CORRELATED.
C LFULLO  = TRUE IF ALL COMPONENTS OF GRAVITY VECTOR OR GRAVITY GRADIENT
C           PLUS ROTATION PARAMETERS ARE OUTPUT.
      IF (LINTER.AND.LTEST)WRITE(6,1103)
 1103 FORMAT(' INPUT: LONEQ, TRUE IF COEFFICIENTS ARE OUTPUT,'/
     *'        LTIME: TRUE, IF TIMING IS MADE (ONLY UNIX)'/
     *'        LTCOV: TRUE, IF OUTPUT FROM COV. CALCULATION'/ 
     *'        LCZERO: TRUE, IF  FINITE COVARIANCES ARE USED ',/
     *'                IN NORMAL EQUATIONS.',/
     *'        LCOERR: TRUE, IF DATA ERRORS ARE CORRELATED.',/,
     *'        LFULLO: TRUE, IF V, ALL COM. OF DG OR DDG ARE OUTPUT ')
      IF (LTEST) READ(5,*)LONEQ,LTIME,LTCOV,LCZERO,LCOERR,LFULLO
      IF (LCZERO) THEN
       IF (LINTER) WRITE(*,*)' INPUT DATA TYPE AND HEIGHT '
       READ(*,*)ICZERO,HCZERO
       WRITE(*,*)
     * ' FINITE COVARIANCE FCT. FOR OBS TYPE',ICZERO
       NCZERO=-1
      END IF
C INPUT OF NOISE COV.FCT. PARAMETERS MOVED 1998-03-20.
      LTIME=LTIME.AND.LUNIX
      IF (LINTER) THEN
       WRITE(6,*)' ARE ALL PARAMETERS OK ?'
       READ(5,*)LOK
       IF (.NOT.LOK) THEN
        WRITE(*,*)' REPEAT INPUT PARAMETERS '
        GO TO 1100 
       END IF
      END IF 
C
      LFORM=LF
      LNFORM = LT
      LSMAL=LF
      LNERNO = LF
      LINT=LF
      LPRED = LNCOL
      LNPOT = .NOT.LPOT
C
      IF (LLEG) WRITE(6,114)
  114 FORMAT(/' LEGEND OF TABLES OF OBSERVATIONS AND PREDICTIONS:',/,
     *' OBS = OBSERVED VALUE (WHEN AN OBSERVATION IS A VECTOR ',/,
     *'       QUANTITY, THEN ONE BELOW THE OTHER)',/,
     *' DIF = DIFFERENCE BETWEEN OBSERVED AND PREDICTED VALUE',/,
     *'       WHEN PREDICTION ARE COMPUTED AND ELSE THE RESIDUAL',/,
     *'       OBSERVATION.',/,
     *' ERR = STANDARD DEVIATION OF OBSERVATION OR ESTIMATE OF',/,
     *'       PREDICTION ERROR.',/,
     *' TRA = CONTRIBUTION FROM DATUM TRANSFORMATION.'/,
     *' TERR= CONTRIBUTION FROM TERRAIN',/,
     *' POT = CONTRIBUTION FROM POTENTIAL COEFFICIENTS.',/,
     *' COLL= CONTRIBUTION FROM COLLOCATION DETERMINED PART.',/,
     *' COLL1=CONTRIBUTION FROM FIRST SET OF OBSERVATIONS.',/,
     *' COLL2=CONTRIBUTION FROM SECOND SET OF OBSERVATIONS.',/,
     *' PRED= PREDICTED VALUE IN GEOCENTRIC SYSTEM.',/,
     *' PRED-TRA= PREDICTED VALUE IN SELECTED COORDINATE SYSTEM.')
C
C *************** INPUT (2) **********************************
C
C INPUT OF DATA FOR GEOCENTRIC REFERENCE SYSTEM: (A) FIRST INPUT
C OF CODE FOR SYSTEM DEFINITION, ICSYS, EQUAL TO 0 IF PARAMETERS
C ARE INPUT FROM UNIT 5 AND EQUAL TO 4 FOR GRS1967, 5 FOR GRS1980,
C 7 FOR BEST CURRENT SYSTEM.
C
C ---------------- INPUT (2A) ---------------------------------
      IF ((.NOT.LINSOL).AND.LINTER)WRITE(6,1105)
 1105 FORMAT(
     *' INPUT CODE FOR BASIC REFERENCE SYSTEM:',/
     *' 0: USER DEFINED, 1: ED50 NORTH SEA, 2: ED50/EDOC,'/
     *' 3: NAD1927 /NEW MEXICO, 4: GRS67, 5:  GRS80, 6: NWL9D,'/
     *' 7: BEST CURRENT, 8: BEST CUR. FAROE ISL, 9: ED50 FOR SF,'/
     *' 10: IAG-75, 11: KRASSOWSKY, DDR, 12: GERMAN DHDN, BESS.') 
      IF (.NOT.LINSOL) READ(5,*)ICSYS0
 102  FORMAT(I5) 
      IF (LWRSOL) WRITE(17,102)ICSYS0
C
      WRITE(6,106)
  106 FORMAT(/' REFERENCE SYSTEM:')
C
      IF (ICSYS0.EQ.0) THEN       
C
C ---------------- INPUT (2B) ---------------------------------
C  INPUT OF TEXT DESCRIBING REFERENCE SYSTEM (MAX.128 CHARACTERS).
       IF (LINTER)WRITE(6,*)' INPUT NAME OF USER DEFINED SYSTEM' 
       READ(5,103)FMT(1)
  103  FORMAT(A128)
C IN FORTRAN77 WE SOPPOSE FMT TO BE OF CHARACTER TYPE.
       IF (LWRSOL) WRITE(17,103)FMT(1)
  803  FORMAT(1X,A128)
       WRITE(6,803)FMT(1)
C
C ------------------ INPUT (2C) ----------------------------------
C IF ICSYS=0 INPUT OF PARAMETER MODEC0 SPECIFYING IN WHICH WAY THE
C THE NORMAL POTENTIAL IS DEFINED, AND THEN THE 3 PARAMETERS
C DEFINING THE SYSTEM:
C MODEC0     EE0(1)     EE0(2)    EE0(3)
C   1         GM         AX        J2 (=-C(2,0))
C   2         GM         AX        E2
C   3         GM         AX        1/F
C   4,5     GAMMA        AX        1/F.
C WHERE GM IS THE PRODUCT OF THE MASS AND THE GRAVITY CONSTANT IN
C M**3/S**2, GAMMA THE EQUATORIAL NORMAL GRAVITY IN M/S**2, AX
C THE SEMI-MAJOR AXIS OF THE REFERENCE ELLIPSOID IN M, J2 THE
C THE (NOT NORMALIZED) 2.ORDER ZONAL HARMONIC, E2 THE SECOND
C EXCENTRICITY (AX**2-BX**2)/AX**2), AND F THE FLATTENING (AX-BX)/AX,
C WHERE BX IS THE SEMI-MINOR AXIS. MODEC0=5 GIVES THE INTERNATIONAL
C ELLIPSOID (1928) AND THE CASSINIS GRAVITY FORMULA, AND SUPPOSES A
C POTSDAM CORRECTION OF 13.7 MGAL MUST BE APPLIED TO MEASURED
C GRAVITY VALUES (LPOTSD=.TRUE.).
       IF (LINTER)WRITE(6,1106)
 1106  FORMAT(' INPUT MODECO (1,..,5) AND',/
     * ' FOR 1: GM, SEMI-MAJOR AXIS (M), AND J2',/
     * '     2:  -      -              ,  -  EXCENTRICITY**2',/
     * '     3:  -      -              ,  -  1/FLATTENING',/
     * '     4,5 EQUATORIAL GRAVITY, SEMI-MAJOR AX, 1/FLATTENING',/
     * '     WHERE 5: POTSDAM SYSTEM FOR GRAVITY') 
  120  FORMAT(I2,3E16.9)
       READ(5,*)MODEC0,EE0(1),EE0(2),EE0(3)
       IF (LWRSOL) WRITE(17,120)MODEC0,EE0(1),EE0(2),EE0(3)
      END IF
C
      CALL ICOSYS(ICSYS0,15,GM2,AX2,E22,F2,UREF0,GREF)
C
      GG=GREF*1.0D5
      WRITE(6,122)AX2,F2,GM2,GG,UREF0
  122 FORMAT(/' A   =',F11.2,' M'/,
     *' 1/F =',F12.7/,
     *' GM=',E17.10,/,
     *' REF.GRAVITY AT EQUATOR =',F14.4,' MGAL'/,
     *' POTENTIAL AT REF.ELL.  =',F14.4,' M**2/SEC**2'/)
      IF (LTEST.AND.LNCOL) WRITE(6,9122)(FG(I),I=16,30),(FJ(J),J=16,30)
 9122 FORMAT(' CONTENTS OF FG, FJ',/10(3E17.10/))
C
      IF (LTRAN) THEN      
C
C *************** INPUT (3) **********************************
C
C INPUT OF MODEC0, AND 3 PARAMETERS DEFINING THE NORMAL POTENTIAL
C AS FOR THE GEOCENTRIC DATUM, FOLLOWED BY 7 DATUM SHIFT PARAMETERS,
C DX,DY,DZ,EPS3,EPS2,EPS1,DL AND THE VALUE OF A LOGICAL
C VARIABLE LCHANG, WHICH IS TRUE, WHEN AN ADDITIONAL DATUM SHIFT IS
C GIVEN AS A CHANGE IN THE DEFLECTIONS OF THE VERTICAL AND THE HEIGHT
C ANOMALY IN A POINT WITH COORDINATES (LAT0, LONG0). LCHANG MUST BE TRUE
C IN CASE DATUM-SHIFT PARAMETERS OF THIS KIND ARE TO BE ESTIMATED
C BY THE PROGRAM (IE. WHEN LPARAM IS TRUE).
C THE COORDINATES MUST BE INPUT IN DEGREES, MINUTES AND SECONDS, FOL-
C LOWED BY THE TRANSFORMATION ELEMENTS IN KSI, ETA AND ZETA (DKSI0,
C DETA0,DZETA0) IN ARCSEC AND METERS.
C
       IF (LINTER)WRITE(6,1106)
       IF (LINTER)WRITE(6,1107)
 1107  FORMAT(
     * ' INPUT 7 DATUM SHIFT PARAMETERS: DX,DY,DZ,E3,E2,E1,AND',/
     * ' LCHANG, TRUE IF CHANGE IN KSI,ETA,ZETA AT ORIGIN ALSO')
  131  FORMAT(I2,3E16.9/3F8.2,3F6.2,E10.2,L2)
       READ(5,*)MODEC0,EE0(1),EE0(2),EE0(3)
       READ(5,*)(DSHIF0(I),I=1,7),LCHANG
       IF (LWRSOL) WRITE(17,131)MODEC0,EE0(1),EE0(2),EE0(3),
     * (DSHIF0(I),I=1,7),LCHANG
       WRITE(6,136)
  136  FORMAT(' PARAMETERS FOR')
       CALL ICOSYS(0,0,GM1,AX1,E21,F1,UREF,GREF)
       WRITE(6,132)AX1,GM1,F1,DSHIF0(7),DX,DY,DZ,DSHIF0(4),
     * DSHIF0(5),DSHIF0(6)
  132  FORMAT(/'  NEW A      NEW GM         NEW 1/F'/,
     * F10.1,E15.7,F10.5,//
     * '    DL       DX     DY     DZ  ',/,E10.2,3F7.1,//,
     * '  EPS3  EPS2  EPS1',/,3F6.2)
       GG=GREF*1.0D5
       WRITE(6,135)GG,UREF
  135  FORMAT(/'  NEW REF. GRAVITY AT EQUATOR=',F12.2,' MGAL',/
     * '  NEW POTENTIAL AT ELLIPSOID =',F11.1,' M**2/SEC**2',/)
       IF (LCHANG) THEN      
C
        IF (LINTER) WRITE(6,1108)
 1108   FORMAT
     *  (' INPUT LAT.,LON. OF ORIGIN (DD MM SS.S), AND 3 SHIFTS')
  133   FORMAT(2I3,F6.2,2I3,F6.2,3F6.2)
        READ(5,*)IDLAT,MLAT,SLAT,IDLON,MLON,SLON,DKSI0,DETA0,DZETA0
        IF (LWRSOL) WRITE(17,133)IDLAT,MLAT,SLAT,IDLON,MLON,SLON,
     *  DKSI0,DETA0,DZETA0
        WRITE(6,134)IDLAT,MLAT,SLAT,IDLON,MLON,SLON,DKSI0,DETA0,DZETA0
  134   FORMAT(' ADDITIONAL DATUM-SHIFT COMPONENTS OR INITIAL PARAME',
     *  'TERS FOR DATUM SHIFT',/,' DETERMINATION, GIVEN IN:',/,
     *  '   LATITUDE      LONGITUDE BY DKSI  DETA  DZETA',/,
     *  I4,I3,F6.2,I4,I3,F6.2,3F7.2)
        CALL RAD(IDLAT,MLAT,SLAT,RLAT0,1)
        CALL RAD(IDLON,MLON,SLON,RLONG0,1)
        SINLA0 =  SIN(RLAT0)
        COSLA0 =  COS(RLAT0)
        COSDLO =  COS(RLONG0)
        SINDLO =  SIN(RLONG0)
        W2 = D1-E22*SINLA0**2
        W  =  SQRT(W2)
        RN = AX2/W
        RM = AX2*(D1-E22)/(W*W2)
        X = -SINLA0*COSDLO*DKSI0*RM/RADSEC-SINDLO*DETA0*RN/RADSEC
     *      -COSLA0*COSDLO*DZETA0
        Y = -SINLA0*SINDLO*DKSI0*RM/RADSEC+COSDLO*DETA0*RN/RADSEC
     *      -COSLA0*SINDLO*DZETA0
        Z =  COSLA0*RM/RADSEC*DKSI0-SINLA0*DZETA0
        X1 = X*X+Y*Y+Z*Z
        IF (X1.GT.0.1D-2) WRITE(6,700)X,Y,Z
  700   FORMAT(' THE CHANGE OF DEFLECTIONS AND HEIGHT ANOMALY CORRES',
     *  'POND TO A',/,' TRANSLATION VECTOR: (DX,DY,DZ) =(',F7.2,',',
     *  F7.2,',',F7.2,'), (METERS).',/)
        DSHIF0(1)=DX-X
        DSHIF0(2)=DY-Y
        DSHIF0(3)=DZ-Z
       END IF
C
      ELSE
       E21 = E22
       AX1 = AX2
      END IF
C
      IF (LPOT) THEN      
       IF (.NOT.LINSOL) THEN       
C
C *************** INPUT (4) **********************************
C
C INPUT IS DONE IN STEPS (A) - (D):
C --------------- INPUT (4A) ---------------------------------
C INPUT OF TEXT DESCRIBING SOURCE OF THE POTENTIAL COEFFICIENTS (MAX.
C 128 CHARACTERS).
        IF (LINTER)WRITE(6,*)' INPUT NAME OF POT.COEFF. SET'
        READ(5,103)FMT(1) 
        WRITE(6,130)
  130   FORMAT(/' SOURCE OF THE POTENTIAL COEFFICIENTS USED:')
        WRITE(6,803)FMT(1) 
        IF (LWRSOL) WRITE(17,103)FMT(1)
C
C --------------- INPUT (4B) ---------------------------------
C  GM   IN (METERS**3/SEC**2), ASSOCIATED WITH THE COEFFICIENT SET,
C  A    SEMI-MAJOR AXIS (M),      -        -    -       -       - ,
C  COFF(5) THE COEFFICIENT C(2,0) MULTIPLIED BY 1.0D6, IF LFM IS
C       TRUE, SEE BELOW. (THIS IS BECAUSE C(2,0) DOES NOT FIT INTO
C       A STANDARD INPUT FORMAT FOR THE OTHER COEFFICIENTS). IF
C       LFM IS FALSE, A DUMMY VARIABLE MUST BE INPUT.
C  NMAX THE MAXIMAL DEGREE,
C 5 LOGICAL VARIABLES:
C LFM   TRUE IF THE COEFFICIENTS ARE INPUT WITH A FIXED NUMBER ON
C       ON EACH RECORD, IN THE SEQUENCE C(2,1),S(2,1),C(2,2) ETC.
C       THE COEFFICIENTS MUST BE FULLY NORMALIZED, AND MULTIPLIED
C       BY 1.0D6. IF LFM IS FALSE, INPUT OF COEFFICIENTS FROM UNIT
C       9, SEE THE SUBROUTINE LOADCS.
C LBIN  TRUE, IF THE COEFFICIENTS ARE INPUT FROM UNIT 9 ON BINARY
C       FORM.
C LFORM TRUE, IF A RUN-TIME FORMAT FOR THE COEFFICIENTS ARE USED,
C       IN WHICH CASE THE FORMAT IS INPUT BELOW (4C).
C LINT  TRUE, IF THE COEFFICIENTS ARE STORED AS INTEGER VARIABLES
C       IN THE ARRAY IICC. (LFM MUST BE FALSE).
C LSKIPL, TRUE IF DUMMY LINES IN FRONT OF FILE 
C
        IF (LINTER) WRITE(6,1109)
 1109   FORMAT
     *  (' INPUT: GM, SEMI-MAJOR AXIS (M), C(2,0), MAX. DEGREE',/
     *  '  LFM, TRUE IF COEFF. IN INPUT STREEM AND *1.0D6',/
     *  '  LBIN, TRUE IF ON BINARY FORM',/
     *  '  LFORM, TRUE IF FORMAT IS INPUT',/
     *  '  LINT, TRUE IF STORED AS INTEGERS'/
     *  '  LSKIPL, TRUE IF DUMMY LINES IN FRONT OF FILE'/) 
        READ(5,*)GMP,AX,COFF(5),NMAX,LFM,LBIN,LFORM,LINT,LSKIPL
        LNFORM=.NOT.LFORM
C IF LFM IS FALSE, COFF(5) MAY BE OVERRIDDEN BY SETCS.
  137   FORMAT(E15.8,F11.1,F10.4,I4,5L2)
        IF (LWRSOL)
     *  WRITE(17,137)GMP,AX,COFF(5),NMAX,LFM,LBIN,LFORM,LINT,LSKIPL
        IF (LINT) WRITE(6,702)
  702   FORMAT(' COEFFICIENTS ARE/WILL BE STORED AS INTEGERS.')
        WRITE(6,138)GMP,AX,COFF(5),NMAX
  138   FORMAT(/'     GM             A       COFF(5)  MAX.DEGREE',/
     *  E15.8,F11.1,F10.4,I5)
        IF ((NMAX.GT.2200.OR.LINT).AND.(NMAX.GE.500.OR.(.NOT.LINT)))
     *  THEN
         WRITE(6,140)
  140    FORMAT(' NMAX TOO BIG.')
         STOP      
        END IF
C
        N2 = (NMAX+1)**2
        L386=N2.GT.NCOEFF
C
C --------------- INPUT (4C) ---------------------------------
C HERE INPUT OF FORMAT OF COEFF.
        IF (LINTER.AND.LFORM) WRITE(6,*)
     *  ' INPUT FORMAT (2I4,2D18.0) F.EX.' 
        IF (LFORM) READ(5,103)FMT(1) 
        IF (LFORM.AND.LWRSOL) WRITE(17,103)FMT(1) 
        COFF(1)=1.0D6
        IF (.NOT.LFM) COFF(1)=D1
C IF COEFFICIENTS ARE INPUT FROM UNIT 5 THEY ARE SUPPOSED TO BE
C MULTIPLIED BY 1.0D6. IF THEY ARE INPUT FROM UNIT 9, A VALUE OF
C COFF(1) DIFFERENT FROM 1.0D0 IS SUPPOSED TO BE THE SCALE FACTOR.
        IF (.NOT.LFM) THEN       
C
C --------------- INPUT (4D) ---------------------------------
C INPUT OF NAME OF FILE HOLDING COEFFICIENTS.
         IF (LINTER) WRITE(6,*)' INPUT NAME OF FILE HOLDING COEFF.' 
         READ(5,2103)PNAME(1)
         WRITE(6,161)(PNAME(I),I=1,ICHAR)
  161    FORMAT(' NAME OF FILE HOLDING COEFFICIENTS: ',2A128)
         IF (LWRSOL) WRITE(17,2103)(PNAME(J),J=1,ICHAR)
         CALL LOADCS(PNAME,FMT,NMAX,LFORM,LBIN,LINT,LSKIPL)
        ELSE       
C
C *************** INPUT (5) **********************************
C
C INPUT OF POTENTIAL COEFFICIENTS STARTING WITH C(2,1). NOTE THAT
C PROBLEM MAY OCCUR IN FREE-FORMAT INPUT, IF DATA IS LINE NUMBERED.
C IN THIS CASE CHANGE TO FIXED FORMAT INPUT.
         IF (LINTER) WRITE(6,*)' INPUT COEFF. FROM C(2,1)'
         IF (LNFORM.AND.(.NOT.LFOR77)) READ(5,99)(COFF(I), I = 6, N2)
         IF (LNFORM.AND.LFOR77) READ(5,*)(COFF(I),I=6,N2)
   99    FORMAT(9F8.4)
         IF (LFORM) READ(5,FMT)(COFF(I), I = 6, N2)
         IF (LWRSOL) WRITE(17,99)(COFF(I),I = 6,N2)
        END IF
        IF (.NOT.L386) THEN      
         DO I = 1, 3
          IF (LINT) IICC(I+1)=0
          IF (.NOT.LINT) COFF(I+1) = D0 
C THIS ASSURES THAT C(1,0),C(1,1) AND S(1,1) ARE ALL ZERO.
         END DO
        END IF
       ELSE   
C
        CALL LOADCS(PNAME,FMT,NMAX,LF,LT,LINT,LSKIPL)
       END IF 
       N2 = (NMAX+1)**2
       CALL SETCM(NMAX,LINT,LBIN)
C SETCM QUASI-NORMALIZES THE COEFFICIENTS AND SETS TABLE ROOT.
       IF ((.NOT.LINT).AND.(.NOT.L386)) COFF(1)=D1
       CM3=GMP
       CMM2=AX
       CM1=OMEGA2
C
       IF (LBIPOT) THEN      
        OPEN(3,FILE=PNA0(1),STATUS='UNKNOWN',FORM='UNFORMATTED')
C    *  RECL=4) CHANGE 1998.07.04 BY CCT.
C MUST BE 8 IF REAL*8 IS USED:
        IF (LINT) THEN      
         WRITE(*,*)' COEFFICIENTS TO BE STORED ON UNIT 3'
C CHANGE 1998.=/.06 BY CCT. (READING OF 8 FIRST SKIPPED).
C        DO 9002 I=1,N2
C9002    WRITE(3)COFF(I)
C WARNING: OUTPUT SHOULD ONLY BE TO N2. BUT IF COFF IS USED TO
C STORE COEFFICIENTS ON INTEGER FORM, THEN THIS WILL NOT WORK.
C REMARK 2004-12-09.
         WRITE(3)COFF
        ELSE      
C
         WRITE(3) C20IN
         DO I=1,N2
          WRITE(3)IICC(I)
         END DO
C
        END IF
        WRITE(6,174)PNA0
  174   FORMAT(' POTENTIAL COEFFICIENTS OUTPUT TO FILE ',2A128)
        CLOSE(3)
       END IF
C
       IF ((LTEST.AND.LPOT.AND.LNCOL).AND.(.NOT.L386)) THEN      
C COMPUTATION OF DEGREE-VARIANCES ADDED 1989.02.27 BY CCT. 
        II=1 
        DGVAR=D0 
        SQ2=SQRT(D2)
        DO I=2,NMAX+1
         SUS=D0
         SS=D0
         DO J=1,2*I-1
          II=II+1
          SSC=COFF(II) 
          IF (J.EQ.1.AND.I.LT.12) SSC=SSC-FJ(I+15) 
          IF (J.NE.1) THEN
           SUS=SUS+SSC/SQ2
           SS=SS+SSC**2/D2 
          ELSE  
           SUS=SUS+SSC
           SS=SS+SSC**2  
          END IF
         END DO
C
         SIGMA0(I)=(GMC/RE)**2*SS*(I-2)**2/(RE**2*(2*I-1))*1.0D10
         SIGD=((SS-SUS**2/(2*I-1))/(2*I-2))
         WRITE(*,1197)
     *   I-1,SUS/(2*I-1),SQRT((SS-SUS**2/(2*I-1))/(2*I-2))
     *   ,SQRT(SS/(2*I-1)),SIGD,SS/(2*I-1)
 1197    FORMAT(I5,6D11.3)
         DGVAR=DGVAR+SIGMA0(I) 
        END DO
        WRITE(6,728)NMAX,DGVAR 
  728   FORMAT(' DEGREE-VARIANCES FROM DEG. 2 TO ',I5,' IN MGAL**2'
     *   /' WITH GRAVITY VARIANCE SUM = ',F9.2,' MGAL**2')
         WRITE(6,*)(SIGMA0(I),I=3,NMAX+1)  
       END IF
       IF (LNCOL) WRITE(6,173)
  173  FORMAT(2X)
      END IF
C
C *******************************************************************
C COLLOCATION SECTION: INITIALIZATION OF VARIABLES.
C
      N = 0
      ICREL=0
      ISATP=0
      NREL=0
      NERCOV=0
      NOBLK=0
      LOBSST=LF
      LSTART=LT
      LSMAL=LF
C
      IF (LCOLLO) THEN
       WRITE(6,109)
  109  FORMAT(/' START OF COLLOCATION I:')
C
       LNERNO=LF
       LERNO=LT
 1000  CONTINUE
C
C ************************ INPUT (6) AND (7) **************************
C INPUT OF PARAMETERS DEFINING COVARIANCE FUNCTION.	
       IF (.NOT.LINSOL) THEN
        CALL INCOV(LINTER,RB) 
       END IF
       SSOBS = D0
C
       MAXPAR=MXPAR
       LINSOL=LF
       LNDAT=.NOT.LPARAM
       IF (LTIME) THEN
        CPU1=SYTIME(RCBASE,TIMEARRAY) 
        WRITE(6,7470)TIMEARRAY(1),CPU1 
       END IF 
 7470  FORMAT(/' TIME USED=',F12.5,' SEC, ELAPSED TIME =',F12.5,' SEC')
C
       IF (.NOT.LPARAM) THEN
C POSSIBLE ERROR: 2003-04-07. VALUE MAY INFLUENCE SUBROUTINE NES.
        NPARM1=0
       ELSE      
C
C *************** INPUT (8) **********************************
C
C INPUT OF VARIABLES SPECIFYING DETAILS CONCERNING PARAMETERS.
C LALLP   - TRUE IF ALL PARAMETERS ARE DEFINED AT THE BEGINNING
C           OF A COLLOCATION STEP AND FALSE, IF THEY ARE SPECI-
C           FIED IMPLICITLY THROUGH THE DATA. (FOR SATELLITE ALTI-
C           METRY THROUGT THE REVOLUTION NUMBER, FOR EXAMPLE).
C IF LALLP IS TRUE, THEN NUMBER OF PARAMETERS, AND PARAMETER
C IDENTIFICATION CODES MUST BE INPUT SUBSEQUENTLY. SEE THE SUB-
C ROUTINE WRPAR FOR A SURVEY OF CURRENTLY USED CODES.
        IF (LINTER) WRITE(6,*)' INPUT LALLP, TRUE IF PARAMETERS GLOBAL' 
        READ(5,*)LALLP
        NPARM=0
        NPAOLD=-1 
        NPOBS=0 
        IF (LWRSOL) WRITE(17,105)LALLP
        IPA = 0
        IPAMAX=0
C CHANGE 2002-04-14.
C MAXPAR IS THE MAXIMAL NUMBER OF PARAMETERS CURRENTLY PERMITTED.
C
C OPEN SCRATCH FILE HOLDING CONTRIBUTIONS TO NORMAL
C EQUATIONS PROM PARAMETERS, SEE REF (I), EQ. (6.7), DENOTED "A".
        OPEN(2,ACCESS='DIRECT',FORM='UNFORMATTED',
     *  STATUS='SCRATCH',RECL=MAXCXB) 
        NCXLAS = 0 
        NBL2= ((MAXPAR+1)*(MAXPAR+2)/2)/MAXCX+1 
        WRITE(6,*)' NUMBER OF BLOCKS NEEDED FOR CX =',NBL2 
C
        DO I = 1, MAXCX
         CX(I) = D0
        END DO
        DO I = 1, NBL2
         WRITE(2,REC=I)CX 
        END DO
C
        IF (LALLP) THEN       
         IF (LINTER) WRITE(6,*)' INPUT NUMBER OF FIXED PARAMETERS'
         READ(5,*)NPARM
         IF (LWRSOL) WRITE(17,102)NPARM
         IF (NPARM.GT.MAXPAR) THEN       
          WRITE(6,160)
  160     FORMAT('TOO LARGE. CHANGE DIMENSION OF IPTYPE.')
          GO TO 9999
         END IF   
         IF (LINTER) WRITE(6,*)' INPUT PARAMETER CODES' 
         READ(5,*)(IPTYPE(I),I=1,NPARM)
  150    FORMAT(12I6)
         IF (LWRSOL) WRITE(17,150)(IPTYPE(I),I=1,NPARM)
         CALL WRPAR
C THE SUBROUTINE WRPAR LISTS THE PARAMETERS.
        END IF
       END IF
C
C INPUT OF ONE OR MORE SETS OF OBSERVATIONS.
       WRITE(6,225)
  225  FORMAT(/'  OBSERVATIONS:'/)
C
       SSOBS=D0
       NCXP=0
       LSTOP=LF
       LMEAN1=LF 
       LGRERR=LF 
C
       LMAP = LF
       LSTAT= LF
       LMEGR = LF
       LCOD = LF
       LAREA=LF
       LADMU=LF
       LFORM=LF
       LNFORM=LT
       LIN4=LF
       LSIMH=LT
       LMENSI=LF
       LMAP7=LF
       LNUOUT=LF
       LSATP=LF 
       BSIZEE=D0
       BSIZEN=D0
       NSTEP=1
       NSTEPE=1 
C STEPE=D1 TO ASSURE CALL OF COMEAN PUTS LMEAQ1 FALSE. 1996.10.08.
       STEPE=D1
       ISATP=0
       NO1=0
       DM = D1
       DA = D0
C ADDED 2000-07-04 BY CCT.
       LKM=LF
C
C ==================================================================
C RETURN POINT WHEN MORE INPUT DATA SETS ARE NEEDED.
C *************** INPUT (9) ****************************************
 2006  CALL DEFDAT(LCOLLO,LPRED,LPARAM,LFOR77,LE,LINTER,
     * LSMAL,LFORM,LP,ICHAR,NMAX,ITRAC0,RRE)
       NPOINT=0
C
       CALL INHEAD(LCOLLO,LREPEC,PW,LNFORM,LADDBP,LINVDE,
     * LADBA,LADDBC)
C
C *************** INPUT (10) *********************************
C RETURN POINT FOR EACH NEW OBSERVATION RECORD,
 2023  CALL INP10(LINTER,LFOR77,LGRID,LFULLO,LTEST,LNOUSE,
     * NWAR,NO2,ITRAC0,OBI,COSB,SINB,COST,SINT,TAUP,BETP,AZP)
C INPUT OF COORDINATES OF OBSERVATIONS POINTS AND
C THE OBSERVED QUANTITIES AND CONTINGENTLY THEIR STANDARD DEVIATIONS.
C THIS IS FOLLOWED BY INPUT OF PARAMETER IDENTIFICATION CODES IF
C LPARM IS TRUE AND LEQP IS FALSE, AND THE OBSERVATIONS ARE NOT
C SATELLITE ALTIMETRY OR CROSS-OVER DIFFERENCES (IKP = 11 OR 9).
C
C IF AN OBSERVATION IS NOT USED WE MAY STILL HAVE TO READ THE
C ASSOCIATED PARAMETERS OR TRACK IDENTIFIERS.
       IF (LPARAM.AND.(.NOT.LEQP).AND.IKP.NE.9.AND.IKP.NE.11
     * .AND.IKP.NE.13.AND.(.NOT.LGRADI).AND.MP.NE.0) THEN       
        READ(INZ,*)(IPACAT(IPA+I),I=1,MP)
       END IF
       IF (LNOUSE) GO TO 2023
C
C NO LESS THAN 0 SIGNALS END OF FILE.
       IF (NO.GE.0) THEN       
        COSLAP =  COS(RLATP)
        SINLAP =  SIN(RLATP)
        COSLOP = COS(RLONGP)
        SINLOP = SIN(RLONGP)
        IF (LINSOL.AND.LNEWSO) THEN
         PW2=VAR(SM,IS,KP,S,AAI,HP,IMAX1,LMENSI,COSLAP,SINLAP,LSATP,
     *     SATROT)
        END IF
C
        IF (LMENSI.AND.(.NOT.LMEAN1)) THEN
         RLATP=RLATP+STEPN*D2
C SPHERICAL APPROXIMATION 2001-09-21.
         COSLAP =  COS(RLATP)
         SINLAP =  SIN(RLATP)
        END IF
        IF (LMENSI) THEN
         IF (LMEAN1) THEN
          CALL PAZIM(RLATP,RLONGP,COSLAP,SINLAP,COSLOP,SINLOP,
     *    -CAZP,-SAZP,COST2P,SINT2P,LTEST)
         ELSE 
          IF (.NOT.LEQANG)CALL 
     *    ICMEAN(BSIZEN,STEPE,NSTEPE,COSSTE,SINSTE,COSLAP,SINLAP,LF,LF)
          RLONGP=RLONGP-STEPE*D2
         END IF 
        END IF
        COSLOP = COS(RLONGP)
        SINLOP = SIN(RLONGP)
C
        IF (LPARAM.AND.(.NOT.LEQP)) THEN
C
C --------------- INPUT (10A) --------------------------------
C INPUT OF PARAMETER TYPES, IF PARAMETERS ARE GIVEN INDIVIDUALLY
C FOR EACH OBSERVATION. FOR DATA RELATED TO SATELLITE-ALTIMETRY
C WE USE THE REVOLUTION NUMBER(S) WHICH IS IMPLICITLY GIVEN BY THE
C OBSERVATION NUMBER, (CODES IKP=9 FOR CROSS-OVER DIFFERENCES AND
C IKP=11 FOR SEA-SURFACE HEIGHTS TREATED LIKE GEOID UNDULATIONS.)
         CALL INPAR(IKP,NO,ITRACK,IC,N,NOX,NPOBS,NPAOLD,LNOUSE,
     *   LINTER,LIN4,LPRED,LDPR,LWRSOL,LTEST,LONEQ,OBI,IOBS1,NPOINT)
C RETURN TO INPUT (10) IF CROSS-OVER DIFFERENCE COULD NOT BE USED.
         IF (LNOUSE) GO TO 2023
        END IF
C
C LOUTC IS EVALUATED BY THE SUBROUTINE INHEAD, AND IS TRUE IF
C LNEQ AND LCOMP BOTH ARE TRUE.
        IF (LOUTC) THEN
         IF (LOE1.OR.LOE2) OBS(K2) = OBI(IIE)
         IF(LOE2) OBS(K21) = OBI(IIE1)
         IF (K1.EQ.5) OBS(5)=D0
C
         IF (LREPEC.AND.IOBS2.GT.0) OBS(12) = OBI(IOBS2)
         IF (IOBS1.GT.0) OBS(2) = OBI(IOBS1)
        END IF
C
        IF (IH.EQ.0) THEN
         OBS(1) = HP
         H=HP
         IF (LMEAN.AND.LSIMH.AND.(.NOT.LWRSOL)) OBS(1) = D0
        ELSE
         H=OBI(1)
         OBS(1)=H
C CORRECTION 2003-04-08.
         IF (LMEAN.AND.LSIMH) THEN
          OBS(1) = HP
          H=HP
         END IF
        END IF
C
C CORRECTING THE OBSERVATION BY AN ADDITIVE AND MULTIPLICATIVE
C CONSTANT.
        IF (LADMU) OBS(2)=OBS(2)*DM+DA
        IF (LKM) H = H*1.0D3
C CONVERSION FROM KM TO M.
C CORRECTION 2004-01-26.
        IF (IKP.GT.10.AND.IH.NE.0) HP = H
        IF (LMEAN.AND.LSIMH) H = D0
        IF (LDEN) THEN
         HP=RRE**2/(RE-HP) - RE
C CONVERSION OF DEPTH TO ARTIFICIAL HEIGHT FOR DENSITY ANOMALIES.
         RP=RE+HP
        END IF
C
        IF (.NOT.(LNGR.AND.(IORDER.NE.2.OR.LNKSIP).AND.(.NOT.LSATP)
     *  .AND.(.NOT.LMDD))) THEN
C
         RLATS=RLATP
         RLONGS=RLONGP 
         COSLA=COSLAP
         SINLA=SINLAP
         COSLO=COSLOP
         SINLO=SINLOP 
         REF=D0
C COMPUTATION OF MEAN VALUES IF NSTEP IS .GT. 1.
         DO I=1,NSTEP
          CALL EUCLID(COSLA,SINLA,COSLOP,SINLOP,H,E21,AX1)
          REFI = RGRAV(IPC,IKP,REF1,REF2,REF3,SINLA,H,RG,CU,SU1,
     *    LSATP)
          VREF(1)=REF1
          VREF(2)=REF2
          VREF(3)=REF3
C
C CHANGE 1990.10.19 BY CCT CALL OF AXV ADDED . 
          IF (LSATP.AND.(.NOT.LGRADI)) THEN
C CALCULATION F REFERENCE VALUES FOR 1. ORDER DERIVATIVES.
           CALL AXV(SATROT,VREF) 
           IF (LGRP) REFI=VREF(3)
           IF (.NOT.LNKSIP) REFI=VREF(2)
           IF (.NOT.LNETAP) REFI=VREF(1)
          END IF
          IF (LMENSI) THEN      
           IF (LMEAN1) THEN
C FILTER FACTORS INTRODUCED 1992.11.26 BY CCT. 
            REF = REF+REFI*FILTER(I) 
            CALL PAZIM(RLATS,RLONGS,COSLA,SINLA,COSLO,SINLO,CAZP,SAZP,
     *      COSSTN,SINSTN,LTEST)  
           ELSE 
            REF = REF+REFI
            COSLA1=COSLA
            COSLA=COSLA*COSSTN+SINLA*SINSTN
            SINLA=SINLA*COSSTN-COSLA1*SINSTN
           END IF 
          ELSE
           REF = REF+REFI
          END IF 
         END DO  
C
         REF=REF/NSTEP
C COMPUTING THE REFERENCE VALUES.
         IF (LMEGR.AND.(LGRP.OR.(.NOT.LNKSIP).OR.(.NOT.LNETAP))
     *   .AND.(.NOT.LMDD)) THEN
C WE SUPPOSE THE FIRST DERIVATIVES ARE IN MGAL WHEN LMEGR IS TRUE.
          OBS(2) = OBS(2)-REF*1.0D5
         END IF
         IF (LMDD.AND.(.NOT.LSATP)) THEN
          OBS(2) = OBS(2)-REF*1.0D9
          IF (LF) WRITE(*,*)' OB2,REF ',OBS(2),REF
         END IF
         REF0=REF
        END IF
C
        IF (LWLONG.AND.LDEFVP.AND.LREPEC) OBS(12) = - OBS(12)
        IF (LWLONG.AND.LONECO.AND.(.NOT.LNETAP)) OBS(2) = -OBS(2)
C
        OBS(IB) = D0
        POT=D0
        GP=D0 
        DUDX=D0
        DUDY=D0
        IF (LREPEC) OBS(IB1) = D0
        IF (LTERRC) THEN
C
         OBS(ITE)=OBI(IITE)
         IF (LADBTE) OBS(IB)=OBS(ITE)
         IF (LREPEC) THEN        
          OBS(ITE1)=OBI(IITE1)
          IF (LADBTE) OBS(IB1)=OBS(ITE1)
         END IF
        END IF
C
        IF (LTRAN.OR.LPOT) THEN      
         CALL TRAPOT(LNPOT,LREPEC,LSPHER,LADDBP,LFULLO,
     *   POT00,RB,REF,REF0,UREF0,OBI,H,HPP,RRE,SU,SU8,VREF)
        ELSE
C CHANGE 2005-11.12.
         IF (.NOT.LSPHER) THEN
          CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,HP,E22,AX2)
C NO SPHERICAL APPROXIMATION, 2001-09-21.
C CHANGE 2004-08-11.
          IF (.NOT.LSATP.AND.(.NOT.LZETA)) ISATP=3
C THIS ASSIGNMENT INDICATES FULL ROTATION, USING THE UNIT MATRIX.
          IF (DISTO.LT.RB) THEN
           WRITE(*,*)' POINT INSIDE BJERHAMMAR SPHERE, H::= 10000 M '
           WRITE(*,*)HP,DISTO,RB
           HPP=0.0D0
          ELSE
           HPP=DISTO-RE
C CHANGE 2003-06-02.
           IF (IH.NE.0) HP=HPP
          END IF
C
          COSLAP=XY/DISTO
          SINLAP=Z/DISTO
          RLATP1=ATAN2(Z,XY)
C DLATP IS GEOCENTRIC LATITUDE MINUS GEODETIC LATITUDE. MORE CORRECT
C IS THE ANGLE BETWEEN THE NORMAL GRAVITY FIELD VECTOR, SEE RGRAV.
          DLATP=RLATP1-RLATP
          IF (ABS(DLATP).GT.0.1) THEN
           WRITE(*,*)' ERROR, RLATP,P1 = ',RLATP,RLATP1
          ELSE
C CORRECTION 2003-04-06.
           RLATP=RLATP1
          END IF
          SLAT=RLATP*180.0D0/PI
         ELSE
          HPP=HP
         END IF
        END IF
C
        IF ((.NOT.LRESOL).AND.LCREF) THEN
C
         IF (.NOT.LCOD) THEN
C CHANGE 2005-03-29.
          CALL PRED(SR,AAR,0,0,0,2,IOBSR,NIR,IMAX1R,LT,LF,LF,LTABLR,
     *    LTCOV,LSATAC)
         ELSE
          PREDP=D0
          PRETAP=D0
         END IF
C
         OBS(IC1) = PREDP
         IF (LADDBC) OBS(IB) = OBS(IB)+OBS(IC1)
C
         IF (LREPEC) THEN
          OBS(IC11) = PRETAP
          IF (LADDBC) OBS(IB1)= OBS(IB1)+OBS(IC11)
         END IF
        END IF
C
        IF (LTNB) OBS(IU) = OBS(IB)-OBS(IT)
        IF (LTEB) OBS(IU) =-OBS(IT)
        IF (LK30) OBS(3) = OBS(2)-OBS(IU)
        IF (LK30) OB1 = OBS(3)
        IF (.NOT.LK30) OB1 = OBS(2)
C
        IF (.NOT.LCOD) THEN
C STORING COORDINATES AND RIGHT-HAND SIDES OF NORMAL-EQ., N COUNTS
C THE COLUMNS AND IC THE STATIONS.
         N = N+1
         IC = IC+1
         IF (LLCOER) THEN
          ITRACE(IC)=-ITRACK
C ADDED 2005-04-04: USE OF CTIME. TO BE CHANGED IF TIME IN DECIMAL
C SEC.
          CTIME(IC)=NO
         END IF
         ICREL=ICREL+1
         NREL=NREL+1
         B(NREL) = OB1
         IF (LE) THEN
          WOBS(NREL) = OBS(K2)
         ELSE
          WOBS(NREL) = D0
         END IF 
         SSOBS = SSOBS+OB1**2/PW2
C
         COSLAT(ICREL) = COSLAP
         SINLAT(ICREL) = SINLAP
         COSLON(ICREL) = COSLOP
         SINLON(ICREL) = SINLOP
         RLONG(ICREL) = RLONGP
         RLAT(ICREL)   = RLATP
         HQ(ICREL)=HPP
C
         IF (LSATP.OR.LMEAN1) THEN
          IF (ISATP.EQ.1.OR.LMEAN1) THEN 
C ERROR DETECTED (BLOCK MOVED UP) 2003-07-30.
           COSAZ(ICREL)=CAZP
           SINAZ(ICREL)=SAZP 
          ELSE 
           SR11(ICREL)=COSB         
           SR12(ICREL)=SINB  
           SR13(ICREL)=COST
           SR22(ICREL)=SINT
           COSAZ(ICREL)=CAZP        
           SINAZ(ICREL)=SAZP         
          END IF 
         END IF
C
         IF (.NOT.LSPHER.AND.(.NOT.LSATP)) THEN
C WE PREPER FOR A ROTATION EQUAL TO THE ANGLE BETWEEN THE
C RADIUS VECTOR AND THE NORMAL GRAVITY FIELD VECTOR AROUND THE 1. AXIS.
C STILL PROBLEM LEFT FOR MEAN-VALUES.
C CHANGE 2001-09-25.
          SATROT(1,1)=D1
          SATROT(2,1)=D0
          SATROT(3,1)=D0
          SATROT(1,2)=D0
          SATROT(2,2)=COS(DLATP)
C SIGN MAY BE WRONG !!!!!
          SATROT(2,3)=-SIN(DLATP)
          SATROT(3,1)=D0
          SATROT(3,2)=-SATROT(2,3)
          SATROT(3,3)=SATROT(2,2) 
         END IF
         IF (NREL.GE.MAXO) THEN
C  CHECK OF NUMBER OF OBSERVATIONS NOT EXCEEDING ARRAY LIMIT
          IF (NOBLK.EQ.0) THEN
C ESTABLISHING SCRATCH FILE FOR OBSERVATIONS, SOLUTIONS AND
C ERRORS. CHANGE 1992.07.22 BY CCT. 
           WRITE(6,229)
  229      FORMAT(
     *     ' NUMBER OF OBSERVATIONS REQUIRE STORAGE ON UNIT 14 AND 16')
           OPEN(16,ACCESS='DIRECT',FORM='UNFORMATTED',
     *     STATUS='SCRATCH',RECL=MAXO9)
           OPEN(14,ACCESS='DIRECT',FORM='UNFORMATTED',
     *     STATUS='SCRATCH',RECL=MAXO6)
           LOBSST=LT
          END IF 
          NOBLK=NOBLK+1 
          WRITE(16,REC=NOBLK)DOBS
          IF (LSATAC) THEN
           WRITE(14,REC=NOBLK)ROTSAT
           WRITE(*,*)' ROTSATX ',ROTSAT(1),SR11(1)
           WRITE(*,*)' 3 BLOCK ',NOBLK,' WRITTEN, LSATAC= ',LSATAC
          END IF  
C HERE IS TO BE ADDED OUTPUT OF PARTIALS FOR PARAMETERS.
          NREL=0
          ICREL=0
         END IF
        END IF
C
        IF (LREPEC) THEN
C
         IF (LTNB) OBS(IU1) = OBS(IB1)-OBS(IT1)
         IF (LTEB) OBS(IU1) = -OBS(IT1)
         IF (LK30) OBS(13) = OBS(12)-OBS(IU1)
         IF (LK30) OB2 = OBS(13)
         IF (.NOT.LK30) OB2 = OBS(12)
         IF (.NOT.LCOD) THEN
          SSOBS = SSOBS+OB2**2/PW2
          N = N+1
          NREL=NREL+1
          B(NREL) = OB2
          WOBS(NREL)=D0 
          IF (LE) WOBS(NREL) = OBS(K21)
         END IF
C
         IF (NREL.GT.MAXO) THEN
C  CHECK OF NUMBER OF OBSERVATIONS NOT EXCEEDING ARRAY LIMIT
          IF (NOBLK.EQ.0) THEN
           WRITE(6,229)
           OPEN(16,ACCESS='DIRECT',FORM='UNFORMATTED',
     *     STATUS='SCRATCH',RECL=MAXO9)
           OPEN(14,ACCESS='DIRECT',FORM='UNFORMATTED',
     *     STATUS='SCRATCH',RECL=MAXO6)
           LOBSST=LT
          END IF 
          NOBLK=NOBLK+1 
          WRITE(16,REC=NOBLK)DOBS
          IF (LSATAC.AND.LOBSST) WRITE(14,REC=NOBLK)ROTSAT
          NREL=0
          ICREL=0
         END IF
        END IF
C
        CNR =RLATP*IC+CNR
C CNR IS USED AS A KIND OF "CHECKSUM" IN CASE SOLUTIONS ARE
C IN - OR OUTPUT, SECURING THAT THE OBSERVATIONS OCCUR IN THEIR
C PROPER SEQUENCE.
C
C IF OBS ONLY DEPEND ON PARAMETERS, THEIR CONTRIBUTION IS CALCU-
C LATED AND STORED ON UNIT 2 BY CXPARM. 
        IF (LCOD) THEN
         CALL CXPARM(SINLAP,COSLAP,RLONGP,HP,IKP)
         NCXP=NCXP+1
        END IF
C
        IF (LSTAT) CALL COMPA(VG,IKP,LONECO,IU,2)
C
        IF (NO1.EQ.1.AND.LNUOUT) WRITE(6,279)
  279   FORMAT(' ONLY STATION NUMBERS OUTPUT:')
C OUTPUT OF OBSERVATIONS.
        CALL COUT(NO,LONECO,LSMAL,LF,0)
C CHANGE 2002-11-25.
        IF ((LPUNCH.OR.LWRSOL).AND.LSATP.AND.(.NOT.LZETA)
     *  .AND.ISATP.EQ.2)WRITE(17,282)AZP,BETP,TAUP 
  282   FORMAT(3D17.9) 
C
        IF (LPARAM.AND.(.NOT.(LEQP.OR.LCOD))) THEN
         IPA = IPA+MP
        END IF
        IF (IPA.GT.IPAMAX) IPAMAX=IPA
C
C RETURN POINT TO INPUT (10).
        IF(.NOT.LSTOP)GO TO 2023
       END IF  
C
C *************** INPUT (11) *********************************
C
C IN ORDER TO TERMINATE THE INPUT OF SETS OF OBSERVATIONS, LSTOP MUST
C TRUE. IN THIS CASE IT IS POSSIBLE TO READ AN ALREADY COMPUTED SO-
C LUTION (LRESOL=TRUE) AND USE A SET OF ALREADY REDUCED NORMAL EQUA-
C TIONS, (LSANEQ=TRUE).
C
       LNBL1=LF
       IF (LINTER) WRITE(6,*)' INPUT LSTOP, LRESOL _ READ SOLUTION' 
       READ(5,*)LSTOP,LRESOL
       IF (LWRSOL) WRITE(17,215)LSTOP,LT
  215  FORMAT(2L2)
C
       IF (LSTAT) CALL COMPA(VG,IKP,LONECO,IU,3)
C
       IF (LPARAM) THEN
C CHANGE 2005-03-25.
        IF (.NOT.LCOD) THEN
         IPACAT(ILAST) = IC
         IPACAT(ILAST+1)=ABS(MP)
        END IF
        IF (LEQP.AND.(.NOT.LCOD)) IPA = IPA+MP
        IF (IPA.GT.IPAMAX) IPAMAX=IPA
C
        IF (LCOD) THEN       
         IF (NOUSE.GT.0) WRITE(6,221)NOUSE
  221    FORMAT(I4,' OBSERVATIONS NOT USED',/)
         NOUSE=0
        END IF
        IF ((.NOT.LSTOP).OR.(.NOT.LPOT).OR.LBIN) THEN       
         NCXLAS = 0 
        END IF
       END IF
C
       IF (LDEN.AND.LPOT) THEN
C THERE SEEMS TO BE AN INCONSISTENCY HERE. 2004-12-05.
        IF (.NOT.L386) THEN       
         REWIND 3
         IF (.NOT.LINT) THEN
          READ(3)COFF
         ELSE   
          READ(3)C20IN
          DO I=1,N2
           READ(3)IICC(I)
          END DO
         END IF
        END IF
        CM3=GMP
        CMM2=AX
        CM1=OMEGA2
       END IF
C
       IF (.NOT.LCOD) THEN
C ESTABLISHING A CATALOGUE OF THE OBSERVATIONS,MAXIMALLY 9 SETS
C ALLOWED PER COLLOCATION STEP.
C JR IS INITIALIZED TO 2 IN THE BLOCK DATA MODULE.
        INDEX(JR) = IC+1
        ISAT(JR)=ISATP 
        IF ((.NOT.LSIMH).AND.LMEAN)
     *  BSIZE(JR)= BSIZEN
        BSIZE(JR+1)=BSIZEE
C ADDED 1998.03.20 BY CCT.
        IF (LCOERR) THEN
         LLCOEE(JR)=LLCOER             
         IF (LLCOER) THEN
C HERE WE STORE INFORMATION ON THE ERROR-COVARIANCE FUNCTION. IF LFOUR
C IS TRUE IT IS REPRESENTED BY A FOURIER SERIES AND IF LCTIME IT
C DEPENDS ON TIME DIFFERENCE, WITH TIME STORED IN ICTIME.
          LFOURI(JR)=LFOUR 
          LFOURI(JR+1)=LCTIME
          IF (LFOUR) THEN
           NFOURI(JR)=NFOUR
C WE THEN NEED TO STORE THE PSD-VALUES.
           WRITE(*,*)' NOT IMPLEMENTED '
           STOP
          ELSE
C HERE IS MISSING PREPARATION FOR FOURIER SERIES REPR. (PSD).
           SCFRDD(JR)=SCFACT
           SCFRDD(JR+1)=RDD
C CHANGE 2005-03-11.
          END IF
         END IF
        END IF
C
        JR = JR+2
        IF (.NOT.(INDEX(JR-3).NE.IKP.OR.LMEAN)) THEN
C
         JR = JR-2
         INDEX(JR-2) = INDEX(JR)
        END IF
       END IF
C
       IF (LSTOP .AND.LPARAM) THEN
C PREPARING FOR PARAMETER DETERMINATION IN CATALOGUE.
        INDEX(JR+1)=100
        INDEX(JR)=INDEX(JR-2)+NPARM
        JR = JR+2
        IC = IC+NPARM
        KL = MOD((MAXPAR*(MAXPAR+1)/2),MAXCX)
        READ(2,REC=NBL2)CX 
        IF (.FALSE.) THEN
         WRITE(*,*)' BUNIT 2 READ, BLOCK ',NBL2
         WRITE(*,*)(CX(KL+IGG),IGG=1,NPARM)
        END IF
        DO I = 1, NPARM
         NREL=NREL+1
         B(NREL) = CX(KL+I)
C CORRECTION 1999-11-23 BY CCT.
         IF (NREL.GE.MAXO) THEN
C  CHECK OF NUMBER OF OBSERVATIONS NOT EXCEEDING ARRAY LIMIT
          IF (NOBLK.EQ.0) THEN
           WRITE(6,229)
           OPEN(16,ACCESS='DIRECT',FORM='UNFORMATTED',
     *     STATUS='SCRATCH',RECL=MAXO9)
           LOBSST=LT
          END IF 
          NOBLK=NOBLK+1 
          WRITE(16,REC=NOBLK)DOBS
          IF (LSATAC) WRITE(14,REC=NOBLK)ROTSAT
          WRITE(*,*)' 5 BLOCK ',NOBLK,' WRITTEN '
          NREL=0
          ICREL=0
         END IF
        END DO              
C THIS IS IN ORDER TO COMPLETE THE RIGHT HAND SIDE WITH
C CONTINGENT CONTRIBUTIONS FROM COORDINATE DIFFERENCES.
        N = N+NPARM
       END IF
       IF ((JR-II) .GE. 19) THEN
C 
        WRITE(6,298)
  298   FORMAT(' OBSERVATIONS ARRANGED TOO COMPLICATED')
        GO TO 9999
C ADDED 2003-10-03 BY CCT.
       END IF
       IF (LSATAC.AND.(.NOT.LOBSST)) THEN
        DO I=1,NSAT
         SR11A(I)=SR11(I)
         SR12A(I)=SR12(I)
         SR13A(I)=SR13(I)
         SR22A(I)=SR22(I)
         COSAZA(I)=COSAZ(I)
         SINAZA(I)=SINAZ(I)
        END DO
        IF (LF) WRITE(*,*)' ROT TRANSFERRED TO ROTA ',SR11A(1),SR12A(1),
     *  SR12A(1),SR22A(1),COSAZA(1),SINAZA(1)
       END IF
C RETURN TO INPUT (9). =============================================
       IF (.NOT.LSTOP) GO TO 2006
C
       IF (LPARAM.AND.(.NOT.LALLP)) CALL WRPAR
C CHANGE 2005-11-07 TO PERMIT OUTPUT.
C      IF (LPARAM.AND.LONEQ)WRITE(6,296)(IPACAT(I),I=1,IPA)
       IF (LPARAM)WRITE(6,296)(IPACAT(I),I=1,IPA)
  296  FORMAT(/' PARAMETER CATALOGUE:',/,(9I8))
C
C END OF INPUT OF OBSERVATIONS. N = NUMBER OF OBSERVATIONS, IOBS =
C NUMBER OF OBSERVATION POINTS.
C
       IOBS = IC-ISO
       N = N-ISO
       N1 = N+1
       NREL=NREL+1
       NREL0=MOD(N1+ISO,MAXO)
       IF (NREL.NE.NREL0) WRITE(*,*)' WARNING NREL.NE.NREL0',NREL
       B(NREL) = SSOBS
C CHANGE 1992.07.19.
       IF (LOBSST) THEN
        NOBLK=NOBLK+1
        WRITE(16,REC=NOBLK)DOBS
        IF (LSATAC) WRITE(14,REC=NOBLK)ROTSAT
        WRITE(*,*) NOBLK,' BLOCKS STORED '
       END IF
       IF (LTIME) THEN
        CPU2=SYTIME(RCBASE,TIMEARRAY) 
        WRITE(6,7470)TIMEARRAY(1),CPU2
       END IF 
C
C IF LWRESOL IS TRUE OUTPUT OF 'T' AND VALUE OF N1, WHICH SUBSEQUENTLY
C MAY BE USED AS INPUT IF LRESOL IS TRUE. IN CASE THE VALUES ARE NOT
C CHANGED, A SOLUTION MAY BE COMPLETELY RE-ESTABLISHED, AND IT MAY
C BE POSSIBLE TO COMPUTE ESTIMATES OF THE ERROR OF PREDICTION, USING
C THE ALREADY REDUCED NORMAL EQUATIONS. IN CASE IFC IS DIFFERENT FROM
C N1, IT WILL BE SUPPOSED, THAT THE FIRST IFC COLUMNS ARE REDUCED,
C AND THE ELEMENTS OF THE N1-IFC LAST COLUMNS WILL BE COMPUTED AND
C REDUCED SUBSEQUENTLY. THIS MAY BE USED TO CORRECT A SOLUTION, WHERE
C A COLUMN IS DELETED OR ADDED, OR WHERE AN OBSERVATION IS CHANGED.
C
       IF (LWRSOL) WRITE(17,216)LT,N1
  216  FORMAT(L2,I7)
C
C GEOCOLH WILL SET UP NORMAL EQUATIONS AND SOLVE THESE. HERE IS ALSO
C FOUND INPUT 12 AND 13 (INPUT OF SOLUTIONS).
       CALL GEOCOLH(LINTER,DNANE,TIMEARRAY,RCBASE,LNDAT,SSOBS,LSATAC)
       IF (NCXP.NE.0) WRITE(*,*)' CXPARM CALLED ',NCXP,' TIMES '
       IF (NERCOV.NE.0) WRITE(*,*)' ERCOV CALLED ',NERCOV,' TIMES. '
       IF (LCZERO) THEN
        WRITE(*,*)' NUMBER OF COVARIANCES SET TO ZERO = ', NCZERO
        HCZERO=-1.0D5
        LCZERO=LF
       END IF 
C 
       IF (.NOT.LC1) THEN
C
        LC1 = LT
C
C *************** INPUT (14) *********************************
C
C INPUT OF LCREF, WHICH IS TRUE WHEN ONE MORE SET OF OBSERVATIONS
C SHALL BE INPUT AND USED FOR THE ESTIMATION OF ONE MORE HARMONIC
C FUNCTION AND OF LPARAM, WHICH IS TRUE, WHEN PARAMETERS ARE TO BE
C DETERMINED FROM THE FOLLOWING SET OF OBSERVATIONS.
        IF (LINTER) WRITE(6,371)
  371   FORMAT(' INPUT LCREF, TRUE IF ANOTHER COLLOCATION SOLUTION',
     *  ' IS NEEDED',/,
     *  '       LNEWDA, TRUE IF PARAMETERS ARE TO BE DETERMINED ') 
        READ(5,*)LCREF,LNEWDA
        IF (LWRSOL) WRITE(17,215)LCREF,LNEWDA
        IF (LCREF) THEN
C
         IF (LPARAM.AND.LNEWDA) WRITE(6,373)
  373 FORMAT(' *** WARNING ***  THIS MAY NOT WORK.')
         LPARAM = LNEWDA
C
C STORING AWAY THE NECESSARY CONSTANTS FOR COLLOCATION I.
         SR = S
         IOBSR = IOBS
         AAR=AAI
         IMAX1R = IMAX1
         NIR = N1
         LTABLR=LTABLE
C INITIALIZING VARIABLES FOR START OF COLLOCATION II.
         CPU0=CPU2
         IS = IMAX1+2
         II = 22
         JR = 22
C CHANGE 1992.08.21. EARLIER IC=NIR+2.
         IC = NIR
         N = IC
         ISO = IC
         NREL= MOD(ISO,MAXO)
         ICREL=NREL            
         IF (LOBSST) NOBLK=NOBLK-1
         INDEX(21) = IC
         WRITE(6,345)
  345    FORMAT(/' START OF COLLOCATION II:'/)
         GO TO 1000
C RETURN TO COLLOCATION STEP II. ===============================
        END IF
       END IF
C
C INITIALIZING VARIABLES FOR PREDICTION. MAXC1 IS THE SUBSCRIPT OF
C THE FIRST ELEMENT IN THE COLUMN FORMING THE RIGHT-HAND SIDE.
       LPRED = LT
       LLCOER=LF
       LCOERR=LF
       LNEQ = LF
       LE = LF
       LC2 = LCREF
       LRESOL=LF
       MAXC1 = MAXC+1
       IF (LCREF) KK = 40
       IF (.NOT.LCREF) KK = 22
       INDEX(KK+1) = 0
       JR = KK
       IF (LWRSOL) THEN
C
        LWRSOL = LF
        LOPEN7=LF
        LCLU7 = LT
  390   FORMAT(1X,2A3)
        CLOSE(17)
        CLOSE(13)
       END IF
       IPA = 0
C
C      IF (LBICOV) CALL OUTCOV(CNANE,NCBL)
C      IF (LBISOL) CALL OUTSOL(SNAME,NSBL)
       IF (LPARAM.AND.LF)WRITE(*,347)IPAMAX,(IPACAT(I),I=1,IPAMAX)
  347  FORMAT(' IPAMAX = ',I5,', IPACAT: ',/,(500(6I8,/)))
       WRITE(6,344)
  344  FORMAT('  PREDICTIONS: <'/)
C
      END IF
C ================ END LCOLLO=TRUE. ==================================
C
C *************** INPUT (15) *********************************
C
C INPUT OF LOGICALS DEFINING TYPE OF PREDICTION OUT-PUT.
C LGRID - TRUE WHEN PREDICTIONS SHALL BE MADE IN POINTS OF A UNIFORM GRID.
C LERNO - TRUE,WHEN THE ESTIMATED ERROR OF PREDICTION SHALL BE COMPUTED. 
C LCOMP - TRUE, WHEN OBSERVED AND PREDICTED VALUES SHALL BE COMPAIRED.
C LERNO - TRUE IN CASE LNCOL IS TRUE AND AN INPUT FILE CONTAINS
C   ERROR ESTIMATES OF OBSERVATIONS. THEY ARE SIMPLY REPRODUCED IN OUTPUT.
C LSPHAR- TRUE IF COEFFICIENTS OF SPHERICAL HARMONICS ARE
C          TO BE PREDICTED
 2000 IF (LINTER) WRITE(6,1115)
 1115 FORMAT(' INPUT: LGRID - TRUE IF COMPUTATIONS IN A GRID',/
     *'  OR WHEN LSPHAR IS TRUE ALL COEFF. LE THE DEGREE ',/
     *'  LERR - TRUE IF ERROR ESTIMATES ARE TO BE COMPUTED',/
     *'            OR REPRODUCED IN OUTPUT',/ 
     *'  LCOMP- TRUE IF COMPUTED VALUES ARE SUBTRACTED FROM OBSERVED'/
     *'  LSPHAR - TRUE IF COEFFICIENTS OF SPHERICAL HARMONICS ARE',/
     *'            TO BE PREDICTED')
C ADDITION 1999-05-17 BY CCT.
      READ(5,*)LGRID,LERNO,LCOMP,LSPHAR
C
C --------------- INPUT (15A) ---------------------------------
C
      LNERNO=.NOT.LERNO
      NI = MAXC1
      LGRERR=LF
      LWAIT=LF
      NPRED=0
      NPRED1=0
C
C --------------- INPUT (15B) ---------------------------------
C
      IF (LERNO.AND.LCOLLO) THEN
C LERCOV IS TRUE IF ERROR-COVARIANCES ARE COMPUTED .
C ADDED 2005-02-24.
       IF (LINTER) WRITE(*,*)
     * ' COMPUTATION OF ERROR-COVARIANCES (T/F) '
       READ(*,*)LERCOV
       NPRED=0
       NPRED1=0
       IF (LIBM77.OR.LUNIX) THEN 
        N19=(N+1)*8
        N20=13*8
       ELSE
        N19=(N+1)*2
        N20=13*2
       END IF
       IF (LERCOV) THEN
        IF (LINTER) WRITE(*,*)
     *  ' INPUT 3 FILE-NAMES FOR STORAGE OF COV., ERROR-COV, POSIT '
        READ(*,2103)DCOVA
        READ(*,2103)DERCOV
        READ(*,2103)POSFIL 
        WRITE(*,*)' FILES ',DCOVA,DERCOV,POSFIL
C OUTPUT IS ERROR-COVARIANCES FOR EACH PREDICTED QUANTITY WITH
C ALL PREDICTED IN THE SAME GROUP, AND THE DATA VARIANCE.
C DIRECT ACCESS FILE TO HOLD COVARIANCES OF PREDICTIONS.
        OPEN(19,ACCESS='DIRECT',FORM='UNFORMATTED',
     *  FILE=DCOVA,RECL=N19) 
C FILE TO HOLD ERROR COVARIANCES.
        OPEN(7,FILE=DERCOV)
C FILE TO HOLD POSITIONS, ADDED 2005-08-09.
        OPEN(20,ACCESS='DIRECT',FILE=POSFIL,FORM='UNFORMATTED',
     *  RECL=N20)
       END IF
      ELSE
       LERCOV=LF
      END IF
C
      IF (LSPHAR) THEN
C ADDITION 2004-08-10.
       IF (LPARAM) THEN
        LALLP=LT
        MP=0
        IPACAT(3)=0
        IPACAT(2)=MP
        CALL PARCAT(LALLP,NPNO)
       END IF
C
C --------------- INPUT (15C) ---------------------------------
C
C ADDITION 2005-04-25.
       IF (LINTER)
     * WRITE(*,*)' MUST COEFFICIENTS BE OUTPUT TO FILE (T/F) ? '
       READ(*,*)LOUTCO
       IF (LOUTCO) THEN
        IF (LINTER) WRITE(*,*)' INPUT NAME OF OUTPUT FILE '
        READ(*,2103)PCOEF
        WRITE(*,*)' COEFFICIENTS WILL BE OUTPUT TO ',PCOEF
        OPEN(1,FILE=PCOEF)
       END IF
C
       IF (LGRID) THEN
        WRITE(*,*)' INPUT INITIAL DEGREE AND ORDER '
        READ(*,*)IXS,JXS
        WRITE(*,*)' INITIAL DEGREE AND ORDER ',IXS,JXS
        IF (IXS.NE.(-JXS)) JXS=-IXS
        IF (LERNO) THEN
         LWAIT=LF
         IF (.NOT.LERCOV) THEN
C INPUT OF FILE NAME TO STORE COVARIANCES FOR ERROR-ESTIMATION.
          NPRED1=0
          LWAIT=LT
          IF (LINTER) WRITE(*,*)' INPUT NAME OF COVARIANCE FILE '
          READ(*,2103)DCOVA
          OPEN(19,ACCESS='DIRECT',FORM='UNFORMATTED',
     *    FILE=DCOVA,RECL=N19)
C FILE TO HOLD ERROR COVARIANCES.
C NOT IMPLEMENTED.
          WRITE(*,*)
     *    ' WARNING: MULTI-ERROR ESTIMATION NOT IMPLEMENTED, LWAIT=LF'
          LWAIT=LF
C THIS MUST BE CHANGED WHEN FEATURE IS FULLY IMPLEMENTED. 2006-01-16.
         END IF
        END IF
       ELSE
        IXS=2
        JXS=-2
        WRITE(*,*)' PREDICTION STARTS FROM DEGREE=2 '
       END IF 
C
       WRITE(*,*)
     * ' MAXIMAL INPUT DEGREE & ORDER OF COEFF. TO BE PREDICTED '
       READ(*,*)IIDEGM,JJORDM
       IF (IIDEGM.NE.(-JJORDM)) JJORDM=-IIDEGM
       IIDEG2=(IIDEGM+1)**2
C
       WRITE(*,*)' LCOMP - OBS-PRED CALCULATED ',LCOMP
       IF (LCOMP) THEN
        IF (IIDEGM.GE.NSPHAR) THEN
         WRITE(*,*)' STORAGE  EXCEEDED FOR COMPARISON. '
         WRITE(*,*)' MAXIMAL DEGREED REDUCED TO ',NSPHAR
         IIDEGM=NSPHAR
        END IF
C
        WRITE(*,*)' INPUT NAME OF COEFF. FILE FOR COMPARISON '
        READ(*,'(A)')CCFILE
        OPEN(21,FILE=CCFILE)
        WRITE(*,*)' INPUT DATA FORMAT '
        READ(*,103)FMT(1)
        WRITE(*,103)FMT(1)
C
C LOOP READING COEFFICIENTS FOR COMPARISON.
 1996   READ(21,FMT)NII,MII,CCII,CCJJ
C
        IF (MII.EQ.0) THEN
         TCOEFF((NII)**2+1)=CCII
        ELSE
         IF (MII.LE.NII) THEN
          TCOEFF((NII)**2+2*MII)=CCII
          TCOEFF((NII)**2+2*MII+1)=CCJJ
         END IF
        END IF
C
        IF (NII.LE.IIDEGM) GO TO 1996
C END READING LOOP.
        CLOSE(21)
C
        SII=0.0D0
        SSII=SII
        SOERR=D0
C ADDED 2004-08-15
        SSCO=D0
       END IF
C
C PUTTING TO ZERO THE ARRAY WHERE PREDICTIONS ARE ACCUMULATED 2000-01-13.
       DO IHH=1,(NSPHAR+1)**2
        SUMIJ(IHH)=D0
       END DO
C
C NEW FEATURE ADDED 1999.09.08 BY CCT. ALL COEFFICIENTS FROM THE
C INITIAL DEGREE AND ORDER (IXS,JXS)  UP TO
C AND INCLUSIVE DEGREE IIDEG ARE PREDICTED.
C
C NEW FEATURE ADDED 2000-12-01 (START FROM IXS).
C
       LTSPH=LF
       RLONGP=D0
       RLATP=D0
       SINLOP=D0
       COSLOP=D1
       HP=D0
       ISATP=0
       IKP=17
       LNKSIP=LT
       LNETAP=LT
       KCI(6)=17
C
       DO IIDEG=IXS,IIDEGM
C IIDEG IS THE DEGREE.
        SSII=0.0D0
        SSCO=D0
        SII=SSII
        SOERR=D0
        IF (LERNO) THEN
         JJORD=0
         PW2=VAR(SM,IS,17,S,AAI,0.0D0,IMAX1,LMENSI,1.0D0,0.0D0,LF,
     *   SATROT)
C        WRITE(*,*)' MAXBLT, NT, IDIMCN ',MAXBLT,NT,IDIMC
         C(MAXC2) = PW2
         WRITE(*,1173)IIDEG,PW2
 1173    FORMAT(/' DEG=',I4,' COEFF. VAR.= ',D16.6,' (M**2/S**2)**2 ')
         IF (PW2.GT.0.0D0)TOERR(IIDEG,1)= SQRT(PW2)*RE/GMC
         IF (PW2.GT.0.0) WRITE(*,1174) SQRT(PW2)*RE/GMC
 1174    FORMAT('      COEFF. STDV    = ',D16.6,' UNITLESS')
         IF (LCOMP.AND.LERNO) THEN
          WRITE(*,*)
     *' DEG ORD   PRED. COEF     OBSERVED       DIFFERENCE    EST. ERR.'
         END IF
        ELSE
         IF (LCOMP) THEN
          WRITE(*,*)' DEG ORD    PRED. COEF     OBS.COEFF    DIFF. '
         END IF
        END IF
C
        DO JJORD=-IIDEG,IIDEG
C JJORD IS THE ORDER.
C
         IF (LERNO) THEN
          IYX=NREAD(CC,MAXBLT,NT,IDIMCN)
C         WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
C 338     FORMAT(' H ',10I7)
C         WRITE(*,*)' MAXBLT, NT, IDIMCN ',MAXBLT,NT,IDIMC
         END IF
C WHEN LINSOL IS TRUE, WE HAVE TO READ THE LAST BLOCK IN ORDER
C THAT THE CALL OF PRED MAY STORE THE COVARIANCES AT THE RIGHT
C POSITIONS IN THE ARRAY CC.
C      
C        WRITE(*,*)' PRED ',IS,IPX,ISO,II,IOBS,N1,IMAX1
         NI=MAXC1
         CALL PRED(S,AAI,IS,IPX,ISO,II,IOBS,N1,IMAX1,LT,LF,LERNO,
     *   LF,LTCOV,LSATAC)
C
         IF (LERNO) THEN
          C(MAXC2) = PW2
          IF (NPARM.GT.0) C(MAXC2) = -C(MAXC2)
          IF (LF) WRITE(*,*)' C(MAXC2), MAXC2 ',C(MAXC2),MAXC2,PW2,
     *    (C(I61),I61=MAXC2-20,MAXC2)
          NPRED=NPRED+1
          IF (LWAIT) THEN
           NPRED1=NPRED1+1
C STORAGE OF COVARIANCES.
           WRITE(19,REC=NPRED1)(C(I61),I61=MAXC2-N,MAXC2)
          END IF
C STORING THE NEW RIGHT-HAND SIDE, SO THAT THE ERROR OF
C PREDICTION CAN BE COMPUTED.
C         WRITE(*,1661)(C(I61),I61=1,120)
C1661     FORMAT(5D14.7)
          IYX=NWRITE(NFILE,CC,MAXBLT,NT,IDIMCN)
C         WRITE(*,1661)(C(I61),I61=1,120)
C COMPUTATION OF THE ERROR OF PREDICTION. THE CALL OF NES GIVES CSS-
C  CPT*(C**-1)*CP+APT*(C**-1)*A*EXX*AT*(C**-1)*AP.
          IF (LF) WRITE(*,*)' NES,N1,N,NT,IDIMCN',N1,N,NT,IDIMCN
          IF (.NOT.LWAIT)
     *    CALL NES(N1,N,0,N1-NPARM1,.FALSE.,OERR,NT,IDIMCN,LF,NERRM,
     *    NPRED1)
          LNBL1=MAXBL.EQ.1
C CORRECTION 2004-08-17.
          IF (NPARM.GT.0) OERR=-OERR
          IF (OERR.GT.0.0D-20) THEN
           OERR=SQRT(OERR)
C CHANGE 2005-04-27.
           ERCOEF(JJORD)=OERR*RE/GMC
          ELSE
           ERCOEF(JJORD)=D0
          END IF
          SOERR=SOERR+OERR*RE/GMC
C COMPUTATION OF ERROR-COVARIANCES. 2005-03-02.
          IF (LERCOV) THEN
C STORING THE LAST REDUCED COLUMN OF COVARIANCES.
           WRITE(19,REC=NPRED)(C(I61),I61=MAXC2-N,MAXC2)
           DO I62=1,NPRED
C READING OF COVARIANCES.
            READ(19,REC=I62)(CR(I61),I61=1,N)
            ERCOV(I62)=D0
C TO BE CORRECTED FOR PARAMETERS. 2005-10-28.
            if (nparm.gt.0) write(*,*)' warning !! * nparm= ',nparm
            DO I61=1,N
             ERCOV(I62)=ERCOV(I62)+CR(I61)*C(I61+MAXC2-N)
            END DO
           END DO
           WRITE(7,1662)(ERCOV(I62),I62=1,NPRED),PW2
C          WRITE(*,1662)(ERCOV(I62),I62=1,NPRED),PW2
C DEACTIVATED 2005-04-25.
 1662      FORMAT(6D12.5)
          END IF
         END IF
C
         PRCOEF(JJORD)=PREDP*RE/GMC
C CHANGE 2005-04-27.
         IF (LCOMP) THEN
          IF (JJORD.EQ.0) THEN
           IDEG21=IIDEG**2+1
          ELSE
           IF (JJORD.LT.0) THEN
            IDEG21=IIDEG**2-2*JJORD+1
           ELSE
            IDEG21=IIDEG**2+2*JJORD
           END IF
          END IF
          TCOBS=TCOEFF(IDEG21)
          DIFII=PREDP*RE/GMC-TCOBS 
C
          IF (LERNO) THEN
           WRITE(*,1132)IIDEG,JJORD,PREDP*RE/GMC,TCOBS,DIFII,
     *     OERR*RE/GMC
 1132      FORMAT(2I4,4D15.5)
          ELSE
           WRITE(*,1132)IIDEG,JJORD,PREDP*RE/GMC,TCOBS,DIFII
          END IF
          SII=SII+DIFII
          SSII=SSII+DIFII**2
          SSCO=SSCO+TCOBS**2
         END IF
C
        END DO          
C END LOOP FOR JJORD.
C
C HERE OUTPUT OF COEFF. AND ERROR-ESTIMATES. 2005-04-27.
        IF (LOUTCO) THEN
         DO JJORD=0,IIDEG
          IF (LERNO) THEN
           IF (JJORD.EQ.0) THEN
            WRITE(1,1132)
     *      IIDEG,JJORD,PRCOEF(0),D0,ERCOEF(0),D0
           ELSE
            WRITE(1,1132)
     *      IIDEG,JJORD,PRCOEF(JJORD),PRCOEF(-JJORD),ERCOEF(JJORD),
     *      ERCOEF(-JJORD)
           END IF
          ELSE
           IF (JJORD.EQ.0) THEN
            WRITE(1,1132)
     *      IIDEG,JJORD,PRCOEF(0),D0
           ELSE
            WRITE(1,1132)
     *      IIDEG,JJORD,PRCOEF(JJORD),PRCOEF(-JJORD)
           END IF
          END IF
         END DO
        END IF
C
        IF (LGRID) THEN
         TMEAN=SII/(2*IIDEG+1)
         TSTDV=SQRT((SSII-SII**2/(2*IIDEG+1))/(2*IIDEG))
         TVARI=SQRT(SSII/(2*IIDEG+1))
         TOERR(IIDEG,2)=TVARI
         SOERR=SOERR/(2*IIDEG+1)
         TOERR(IIDEG,3)=SOERR
         IF (SSCO.GT.D0) SSCO=SQRT(SSCO/(2*IIDEG-1))
         TOERR(IIDEG,4)=SSCO
         WRITE(*,1176)TMEAN,TSTDV,TVARI,SOERR,SSCO
 1176    FORMAT(' MEAN, STDV, VARI= ',3D16.5,/
     *   ' MEAN COLL ERR= ',D16.5,' COEFF. STDV. ',D16.5/)
        END IF
       END DO
C END LOOP OVER IIDEG.
C
        IF (LGRID) THEN
         WRITE(*,*)
         IF (LERNO) THEN
          WRITE(*,*)
     *    ' DEG,   DEG.STDV.    STDV OBS-PRED    STDV COL.ERR.   SD-C '
         ELSE
          WRITE(*,*)' DEG,     STDV OBS-PRED    STDV-COEFFICIENTS  '
         END IF
C
         DO ITO1=IXS,IIDEGM
          IF (LERNO) THEN
           WRITE(*,1181)ITO1,TOERR(ITO1,1),TOERR(ITO1,2),TOERR(ITO1,3),
     *     TOERR(ITO1,4)
          ELSE
           WRITE(*,1181)ITO1,TOERR(ITO1,2),TOERR(ITO1,4)
          END IF
 1181     FORMAT(I5,4D16.7)
         END DO
        ELSE   
C
        MAXDOU= (IIDEGM+1)**2
        IF (LOUTCO) THEN
         CLOSE(1)
        ELSE  
         WRITE(*,*)' COEFFICIENT PREDICTION RESULTS: '
         WRITE(*,1177)(SUMIJ(IHH)*RE/GMC,IHH=1,MAXDOU)
 1177    FORMAT(5D14.7)
        END IF
C
        IF (LCOMP) THEN
         WRITE(*,*)' DEG.  MEAN   STDV(OBS-PRED)    STDV(PRED) ',IIDEG
         IHX=5
         DO IHH=2,IIDEGM
          IHH2=2*IHH
          IHH21=IHH2+1
          SI=D0
          SSI=D0
          SCO=D0
          SSCO=D0
          DO IHJ=1,IHH21   
           TCOBS=TCOEFF(IHX)
           DIFI=SUMIJ(IHX)*RE/GMC-TCOBS      
           SI=SI+DIFI
           SSI=SSI+DIFI**2
           SCO=SCO+TCOBS
           SSCO=SSCO+TCOBS**2
           IHX=IHX+1
          END DO    
          SSI=SQRT((SSI-SI**2/IHH21)/IHH2)
          SI=SI/IHH21
          SSCO=SQRT((SSCO-SCO**2/IHH21)/IHH2)
C  OUTPUT
          WRITE(*,1181)IHH,SI,SSI,SSCO
         END DO    
         WRITE(*,*)' TOTAL NUMBER OF COEFFICIENTS COMPARED= ',IHX-1
        ELSE
         IF (LERNO) THEN
          WRITE(*,1132)IIDEG,JJORD,PREDP*RE/GMC,OERR*RE/GMC
         ELSE
          WRITE(*,1132)IIDEG,JJORD,PREDP*RE/GMC
         END IF
        END IF
       END IF
C     
      ELSE
       IIDEG=-1
C
       SSOBS=D0
       LSTOP=LF
       LMEAN1=LF 
       LGRERR=LF 
       LGRERS=LF 
       IF (LERNO.AND.LRESOL) THEN       
        LERNO = LF
        WRITE(6,226)
  226   FORMAT(' *** ERROR WILL NOT BE COMPUTED, REQUIRED NEQ NOT ',
     *  'STORED. ***')
       END IF
C
       LNERNO = .NOT.LERNO
       LMAP = LF
       LSTAT= LF
       LMEGR = LF
       LCOD = LF
       LAREA=LF
       LADMU=LF
       LFORM=LF
       LNFORM=LT
       LIN4=LF
       LSIMH=LT
       LMENSI=LF
       LMAP7=LF
       LNUOUT=LF
       LSATP=LF 
       BSIZEE=D0
       BSIZEN=D0
       NSTEP=1
       NSTEPE=1 
C STEPE=D1 TO ASSURE CALL OF COMEAN PUTS LMEAQ1 FALSE. 1996.10.08.
       STEPE=D1
       ISATP=0
       NO1=0
       DM = D1
       DA = D0
C ADDED 2000-07-04 BY CCT.
       LKM=LF
C
       IF (LGRID) THEN      
C
C *************** INPUT (16) *********************************
C
C INPUT OF GRID LABEL: MIN, MAX LATITUDE AND LONGITUDE, AND
C GRID SPACING IN LAT, LONG (ALL DECIMAL DEGREES). 
C THE DATA TYPE (IKP), THE COORDINATE
C SYSTEM (ICSYS) (.LT.0, GEOCENTRIC, BEST), HP = THE HEIGHT OF
C THE MEAN SPHERE ON WHICH THE POINTS OF PREDICTION ARE SI-
C TUATED, THE VALUE OF LMAP, WHICH IS TRUE, WHEN THE PREDICTIONS
C SHALL BE PRINTED AS A PRIMITIVE MAP, THE VALUE OF LPUNCH, WHICH IS
C TRUE WHEN THE PREDICTIONS SHALL BE OUTPUT TO UNIT 17 AND  THE VALUE
C OF LMEAN, TRUE WHEN THE PREDICTED QUANTITIES ARE MEAN VALUES.
C IF LPUNCH AND LMAP ARE TRUE, THEN THE RESULTS WILL ONLY BE OUTPUT
C TO UNIT 17, ON GI STANDARD GRID FORM.
C THIS IS THEN FOLLOWED BY
C (A) IF LPUNCH INPUT OF FILE NAME CONNECTED TO UNIT 17.
C (B) IF LPARM IS TRUE NUMBER OF PARAMETERS AND CODES,
C (C) IF LCOMP IS TRUE, THE SAMPLING INTERVAL MAGNITUDE, VG.
C (D) IF LMEAN IS TRUE, THEN LSIMH, TRUE IF THE MEAN VALUE FUNCTIONAL
C     IS SIMULATED BY MOVING THE HEIGHT UP TO A CERTAIN ALTITUDE,
C     LEQANG, TRUE FOR EQUAL ANGULAR BLOCKS, FOLLOWED BY THE BLOCK-
C     SIZE IN LATITUDE AND IF LEQANG IS TRUE THE BLOCK SIZE IN LON-
C     GITUDE AND THE MIDDLE LATITUDE OF THE AREA IN DECIMAL DEGREES.
C     OTHERWISE TWO ZERO VALUES MUST BE GIVEN.
C IF IKP=10 (DENSITY ANOMALIES), THEN ALSO INPUT 9J MUST BE USED.
C
        IF (LINTER) WRITE(6,1116)
 1116   FORMAT(' INPUT GRID SPECIFICATION',/
     *  '  MIN, MAX LATITUDE, MIN, MAX LONGITUDE, STEP IN LAT AND LONG',/
     *  '  FUNCTIONAL TYPE (CODE), NEG. VALUE THEN SPH.EXP. SUBTRACTED',/
     *  '  COORD.SYSTEM CODE (-1 THEN GLOBAL SYSTEM)',/
     *  '  HEIGHT OF GRID POINTS (M)',/'   LMAP - PRIMITIVE MAP OUTPUT',/
     *  '  LPUNCH- OUTPUT TO UNIT 17',/'  LMEAN - MEAN VALUES OUTPUT',/
     *  '   LMAP&LPUNCH  SIMULTANEOUS TRUE, ONLY MAP OUTPUT TO UNIT 17')
        READ(5,*)RLAMIN,SLAC,SLOC,RLOMAX,GLA,GLO,IKP,ICSYS,HP,LMAP,
     *  LPUNCH,LMEAN
C CHANGE 2008-12-08.
        LRESOL=IKP.LT.0
        IF (LRESOL) IKP = - IKP
        NLO= (RLOMAX-SLOC)/GLO+0.5
        NLA= (SLAC-RLAMIN)/GLA+0.5 
        WRITE(*,*)' GRID CONSIST OF ',NLA+1,' * ',NLO+1,' POINTS' 
        LGIGRS=IKP.GT.40.AND.IKP.LT.90
        IF (LGIGRS) THEN
         IKP=IKP-40
         WRITE(*,*)' DATA IN 3-D FRAME ORIENTATION '
        END IF
        LGRADI=IKP.EQ.15.OR.IKP.EQ.30.OR.IKP.EQ.35.OR.(IKP.GE.20
     *  .AND.IKP.LE.25) 
c change 2007-07-19.
        LSMAL=HP.GT.1.0D4.and.ikp.ne.11
C ADDITION 1999.12.13 BY CCT.
        LSATP=(IKP.EQ.12.OR.IKP.EQ.16.OR.IKP.EQ.17.OR.IKP.EQ.13.OR.
     *  LGRADI.OR.IKP.EQ.11).AND.LGIGRS 
        IF (LSATP) THEN
         ISATP=3
         AZP=90.0D0
         BETP=D0
         TAUP=D0
         SAZP = SIN(AZP*DEGRAD)
         CAZP = COS(AZP*DEGRAD)
         SINB = SIN(BETP*DEGRAD)
         COSB = COS(BETP*DEGRAD)
         SINT = SIN(TAUP*DEGRAD)
         COST = COS(TAUP*DEGRAD) 
         SATROT(1,1) =  SAZP*COSB
         SATROT(1,2) =  CAZP*COST+SINT*SINB*SAZP 
         SATROT(1,3) = -CAZP*SINT+COST*SAZP*SINB
         SATROT(2,1) = -CAZP*COSB
         SATROT(2,2) =  SAZP*COST-SINT*SINB*CAZP 
         SATROT(2,3) = -SAZP*SINT-COST*SINB*CAZP
         SATROT(3,1) = -SINB
         SATROT(3,2) =  SINT*COSB                
         SATROT(3,3) =  COSB*COST
        ELSE
C CORRECTION 2003-03-22.
         ISATP=0
        END IF
        IF (LPUNCH)  THEN
C
C -------------------- INPUT (16A) -----------------------------
         IF (LINTER) WRITE(6,*)' INPUT NAME OF FILE TO HOLD RESULT'
         READ(5,2103)DNAME(1)
         IF (.NOT.(LOPEN7.AND.OLDN(1).EQ.DNAME(1).AND.OLDN(2).EQ.
     *   DNAME(2))) THEN
          IF (LOPEN7) THEN
           WRITE(*,*)' UNIT 17 CLOSED AT LABEL 2085 '
           CLOSE(17)
          END IF   
          OPEN(17,FILE=DNAME(1),STATUS='UNKNOWN',FORM='FORMATTED')
          WRITE(6,290)(DNAME(I),I=1,ICHAR)
  290     FORMAT(/' SIMULTANEOUS OUTPUT TO FILE: ',2A128)
          LOPEN7=LT
          OLDN(1)=DNAME(1)
          OLDN(2)=DNAME(2)
         END IF
        END IF
C
        LMAP7=LMAP.AND.LPUNCH
        LMAP7E=LMAP7.AND.LERNO 
        LWAIT=LMAP7E
C ADDITION 1994.02.04 BY CCT. 
        IF (LMAP7E) THEN
         IF (LINTER) WRITE(6,*)' INPUT NAME OF FILE TO HOLD ERROR'
         READ(5,2103)DNAME(1)
         OPEN(11,FILE=DNAME(1),STATUS='UNKNOWN',FORM='FORMATTED')
         WRITE(6,291)(DNAME(I),I=1,ICHAR)
  291    FORMAT(/' ERROR SIMULTANEOUS OUTPUT TO FILE: ',2A128)
C CHANGE 2005-11-01.
         IF (.NOT.LERCOV) THEN
          WRITE(*,*)' INPUT COVARIANCE FILE NAME '
          READ(*,2103)DCOVA
          OPEN(19,ACCESS='DIRECT',FORM='UNFORMATTED',
     *    FILE=DCOVA,RECL=N19) 
         END IF
C LWAIT INDICATES THAT ERROR-ESTIMATES ARE COMPUTED WHEN THE
C LAST GRID VALUE IS COMPUTED.
        END IF 
        IF (LMAP7)WRITE(17,392)RLAMIN,SLAC,SLOC,RLOMAX,GLA,GLO
        IF (LMAP7E)WRITE(11,392)RLAMIN,SLAC,SLOC,RLOMAX,GLA,GLO
        IF (LMAP7) LMAP=LF
C
        LNEWD=ICSYS.LT.0
        LTRAN=.NOT.LNEWD
        RP= RE+HP
        JIMAX = (NLA+1)*(NLO+1)
        IF (LCOMP.AND.JIMAX.GT.NMAP) JI=NMAP
        LMAP=LMAP.AND.JIMAX.LE.NMAP
        LWLONG=LF
        LSTAT=LCOMP
        LGRP=IKP.EQ.2.OR.IKP.EQ.13.OR.IKP.EQ.12
        LDEN=IKP.EQ.10
        IF (LDEN.AND.L386.AND.LPOT) THEN
         WRITE(6,*)' DENSITY COMPUTATION REQUIRES COEFF. IN CORE'
         STOP
        END IF
        LZETA=IKP.EQ.1.OR.IKP.EQ.11
C
        IF (LPARAM) THEN      
         IPA=2
         LEQP=LT
C
C --------------- INPUT (16B) --------------------------------
C INPUT OF NUMBER OF PARAMETERS AND PARAMETER IDENTIFICATION CODES.
         IF (LINTER) WRITE(6,*)' INPUT NUMBER OF PARAMETERS & CODES '
         READ(5,*)MP,(IPACAT(I+2),I=1,MP)
         IF (MP.GT.0.AND.MP.LT.4) WRITE(6,170)MP,(IPACAT(I+2),I=1,MP)
  170   FORMAT(/' OBSERVATIONS CONTRIBUTE TO/DEPEND ON ',I3,
     *  ' PARAMETERS',3I6)
         IF (MP.GT.3) WRITE(6,171)MP,(IPACAT(I+2),I=1,MP)
  171   FORMAT(/' OBSERVATIONS CONTRIBUTE TO/DEPEND ON ',I3,
     *  ' PARAMETERS',3I6,(/,12I6))
         IPACAT(2)=MP
         CALL PARCAT(LALLP,NPNO)
        END IF
C
        IOBS2 = 0
        IH = 0
C
C --------------- INPUT (16C) --------------------------------
        IF (LINTER.AND.LCOMP) WRITE(6,*)' INPUT HISTOGRAM BIN-WIDTH'
        IF (LCOMP) READ(5,*)VG
C
C --------------- INPUT (16D) ---------------------------------
        IF (LINTER.AND.LMEAN)WRITE(6,1117) 
 1117   FORMAT(' INPUT PARAMETERS DEFINING TYPE AND SIZE OF MEAN VALUE',/
     *  ' LSIMH - TRUE IF WE USE EQUIVALENT HEIGHT REPR. OF MEAN',/
     *  ' LEQANG- TRUE IF EQUAL ANGULAR OR 1-D BLOCK',/
     *  ' BLOCK SIDE LENGTH IN LAT. & LONG. (MIN) OR (LENGTH .0 IF 1D)',/
     *  ' LATITUDE OF TOTAL AREA MEAN') 
  231   FORMAT(2L2,3F10.2)
        IF (LMEAN) READ(5,*)LSIMH,LEQANG,BSIZEN,BSIZEE,
     *  RLATP
        LMENSI=.NOT.LSIMH
C LMEAN1 IS TRUE IF MEAN VALUES ARE 1D, ALONG A SATELLITE OR
C AIRCRAFT TRACK, FOR EXAMPLE BUT IS NOT MEANINGFULL FOR A GRID.  
        LMEAN1=.NOT.LSIMH.AND.(.NOT.LEQANG).AND.ABS(BSIZEE).LT.
     *  1.0D-8 
        IF (LMEAN1)
     *  CALL MEAN1(FILTER,NFILTE,SAZP,CAZP,LFILTE,LGRID,LINTER) 
C
C *************** INPUT (17) *********************************
C
        IF (LINTER.AND.LCOMP)WRITE(6,*)' INPUT OBSERVED GRID VALUES' 
        IF (LCOMP) READ(5,*)(IMAP(I),I=1,JI)
C INPUT OF OBSERVATIONS IN GRID-FORM. FIRST VALUE IN NORTH-WEST
C CORNER. MAXIMALLY NMAP VALUES CAN BE USED.
C
        H = D0
        IF (.NOT.(LMEAN.AND.LSIMH)) H = HP
C MEAN VALUES ARE SUPPOSED TO BE CALCULATED AT HEIGHT ZERO,
C AND COVARIANCES ARE COMPUTED AT HEIGHT H, IF LSIMH IS TRUE.
        LKM = H.GE.1.0D4
        H0 = H
C H0 SAVES THE INITIAL VALUE OF H, WHICH MAY BE CHANGED FOR
C GRAVITY ANOMALIES.
        OBS(1) = H
C
        IF (LKM) THEN
C H IN KM IS STORED FOR OUTPUT.
         OBS(1) = H*1.0D-3
        END IF
C
        LSTOP = LT
        IANG = 3
        NO = 0
        IOBS1 = 5
C
        DO NAI=0,NLA
         SLAT = -NAI*GLA+SLAC
         IF (SLON.GT.360.0) SLON = SLON-360.0
         IF (SLON.LT.(-360.0)) SLON = SLON+360.0
         IF (LCOMP.AND.NO.LE.400) OBS(2) = IMAP(NO)/100.0
         H = H0
C   
C ---------------- INPUT (17A) -------------------------------
C THIS CALL ONLY TAKES PLACE FOR THE FIRST POINT IN THE GRID.
         IF (NAI.EQ.0)  THEN
          IF (LDEN) CALL DENDEF(NMAX,LINTER,LWRSOL,LPARAM,
     *    LPOT,LBIPOT,LBIN,LINSOL,LDENOL,LSKIPL,RRE)
C INPUT OF EXPONENT OF WEIGHT FACTOR ON HARMONIC DENSITY,
C RADIUS OF SPHERE WITHIN WICH MASSES ARE LOCATED IN M. CF. REF(F),
C SECTION 3,SALE FACTOR AND VALUE OF LOGICAL VARIABLE LNPOT
C TRUE, IF NEW SET OF COEFFICIENTS ARE TO BE USED FOR THE DENSITY
C COMPUTATIONS, (DIFFERENCES BETWEEN THE ORIGINAL COEFFICIENTS AND
C COEFFICIENTS OF A TOPOGRAPHIC-ISOSTATIC REDUCTION POTENTIAL).
C IF POTENTIAL COEFFICIENTS NOT ALREADY STORED ON BINARY FORM
C (NOT HP9000) ALSO THE NAME OF THE FILE TO BE CONNECTED TO UNIT 3.
C THIS ONLY APPLIES IF LPOT IS TRUE.
C
C =================================================================
          CALL INHEAD(LCOLLO,LREPEC,PW,LNFORM,LADDBP,LINVDE,
     *    LADBA,LADDBC)
         END IF
C
         DO NOI=0,NLO
          NOI1=NOI
          NO = NO+1
          SLON = NOI*GLO+SLOC
          CALL RAD(IDLAT,MLAT,SLAT,RLATP,3)
          CALL RAD(IDLON,MLON,SLON,RLONGP,3)
C
          COSLAP =  COS(RLATP)
          SINLAP =  SIN(RLATP)
          COSLOP = COS(RLONGP)
          SINLOP = SIN(RLONGP)
          IF (LINSOL.AND.LNEWSO) THEN
          PW2=VAR(SM,IS,KP,S,AAI,HP,IMAX1,LMENSI,COSLAP,SINLAP,LSATP,
     *     SATROT)
          END IF
C
          IF (LMENSI.AND.(.NOT.LMEAN1)) RLATP=RLATP+STEPN*D2
C SPHERICAL APPROXIMATION 2001-09-21.
          COSLAP =  COS(RLATP)
          SINLAP =  SIN(RLATP)
          IF (LMENSI) THEN
           IF (LMEAN1) THEN
            CALL PAZIM(RLATP,RLONGP,COSLAP,SINLAP,COSLOP,SINLOP,
     *      -CAZP,-SAZP,COST2P,SINT2P,LTEST)
           ELSE 
            IF (.NOT.LEQANG)CALL 
     *      ICMEAN(BSIZEN,STEPE,NSTEPE,COSSTE,SINSTE,COSLAP,
     *      SINLAP,LF,LF)
            RLONGP=RLONGP-STEPE*D2
           END IF 
          END IF
          COSLOP = COS(RLONGP)
          SINLOP = SIN(RLONGP)
C
          IF (.NOT.(LNGR.AND.(IORDER.NE.2.OR.LNKSIP).AND.(.NOT.LSATP)
     *    .AND.(.NOT.LMDD))) THEN
           RLATS=RLATP
           RLONGS=RLONGP 
           COSLA=COSLAP
           SINLA=SINLAP
           COSLO=COSLOP
           SINLO=SINLOP 
           REF=D0
           DO I=1,NSTEP
            CALL EUCLID(COSLA,SINLA,COSLOP,SINLOP,H,E21,AX1)
            REFI = RGRAV(IPC,IKP,REF1,REF2,REF3,SINLA,H,RG,CU,SU1,
     *      LSATP)  
            VREF(1)=REF1
            VREF(2)=REF2
            VREF(3)=REF3
C
C CHANGE 1990.10.19 BY CCT CALL OF AXV ADDED . 
            IF (LSATP.AND.(.NOT.LGRADI)) THEN
             CALL AXV(SATROT,VREF) 
             IF (LGRP) REFI=VREF(3)
             IF (.NOT.LNKSIP) REFI=VREF(2)
             IF (.NOT.LNETAP) REFI=VREF(1)
            END IF
            IF (LMENSI) THEN      
             IF (LMEAN1) THEN
C FILTER FACTORS INTRODUCED 1992.11.26 BY CCT. 
              REF = REF+REFI*FILTER(I) 
              CALL PAZIM(RLATS,RLONGS,COSLA,SINLA,COSLO,SINLO,CAZP,SAZP,
     *        COSSTN,SINSTN,LTEST)  
             ELSE 
              REF = REF+REFI
              COSLA1=COSLA
              COSLA=COSLA*COSSTN+SINLA*SINSTN
              SINLA=SINLA*COSSTN-COSLA1*SINSTN
             END IF 
            ELSE
             REF = REF+REFI
            END IF 
           END DO  
           REF=REF/NSTEP
C COMPUTING THE REFERENCE VALUES.
           IF (LMEGR.AND.(LGRP.OR.(.NOT.LNKSIP).OR.(.NOT.LNETAP))
     *     .AND.(.NOT.LMDD)) THEN
C WE SUPPOSE THE FIRST DERIVATIVES ARE IN MGAL WHEN LMEGR IS TRUE.
            OBS(2) = OBS(2)-REF*1.0D5
           END IF
           IF (LMDD.AND.(.NOT.LSATP)) THEN
            OBS(2) = OBS(2)-REF*1.0D9
            IF (LF) WRITE(*,*)' OB2,REF ',OBS(2),REF
           END IF
           REF0=REF
          END IF
C
          IF (LWLONG.AND.LDEFVP.AND.LREPEC) OBS(12) = - OBS(12)
          IF (LWLONG.AND.LONECO.AND.(.NOT.LNETAP)) OBS(2) = -OBS(2)
C
          OBS(IB) = D0
          POT=D0
          GP=D0 
          DUDX=D0
          DUDY=D0
          IF (LREPEC) OBS(IB1) = D0
          IF (LTERRC) THEN
C
           OBS(ITE)=OBI(IITE)
           IF (LADBTE) OBS(IB)=OBS(ITE)
           IF (LREPEC) THEN        
            OBS(ITE1)=OBI(IITE1)
            IF (LADBTE) OBS(IB1)=OBS(ITE1)
           END IF
          END IF
C
          IF (LTRAN.OR.LPOT) THEN      
           CALL TRAPOT(LNPOT,LREPEC,LSPHER,LADDBP,LFULLO,
     *     POT00,RB,REF,REF0,UREF0,OBI,H,HPP,RRE,SU,SU8,VREF)
          ELSE
C CHANGE 2004-07-09.
           IF (.NOT.LSPHER) THEN
            CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,HP,E22,AX2)
C
C NO SPHERICAL APPROXIMATION, 2001-09-21.
C CHANGE 2004-08-11.
            IF (.NOT.LSATP.AND.(.NOT.LZETA)) ISATP=3
C THIS ASSIGNMENT INDICATES FULL ROTATION, USING THE UNIT MATRIX.
            IF (DISTO.LT.RB) THEN
             WRITE(*,*)' POINT INSIDE BJERHAMMAR SPHERE, H::= 10000 M '
             WRITE(*,*)HP,DISTO,RB
             HPP=0.0D0
            ELSE
             HPP=DISTO-RE
C CHANGE 2003-06-02.
             IF (IH.NE.0) HP=HPP
            END IF
C
            COSLAP=XY/DISTO
            SINLAP=Z/DISTO
            RLATP1=ATAN2(Z,XY)
C DLATP IS GEOCENTRIC LATITUDE MINUS GEODETIC LATITUDE. MORE CORRECT
C IS THE ANGLE BETWEEN THE NORMAL GRAVITY FIELD VECTOR, SEE RGRAV.
            DLATP=RLATP1-RLATP
            IF (ABS(DLATP).GT.0.1) THEN
             WRITE(*,*)' ERROR, RLATP,P1 = ',RLATP,RLATP1
            ELSE
C CORRECTION 2003-04-06.
             RLATP=RLATP1
            END IF
            IF (IANG.EQ.6) SLAT=RLATP*180.0D0/PI
           ELSE
            HPP=HP
           END IF
          END IF
C
          IF (LCREF) THEN
           CALL PRED(SR,AAR,0,0,0,2,IOBSR,NIR,IMAX1R,LT,LF,LF,LTABLR,
     *     LTCOV,LSATAC)
C
           OBS(IC1) = PREDP
           IF (LADDBC) OBS(IB) = OBS(IB)+OBS(IC1)
C
           IF (LREPEC) THEN
            OBS(IC11) = PRETAP
            IF (LADDBC) OBS(IB1)= OBS(IB1)+OBS(IC11)
           END IF
          END IF
C
          IF (LTNB) OBS(IU) = OBS(IB)-OBS(IT)
          IF (LTEB) OBS(IU) =-OBS(IT)
          IF (LK30) OBS(3) = OBS(2)-OBS(IU)
          IF (LK30) OB1 = OBS(3)
          IF (.NOT.LK30) OB1 = OBS(2)
C
          IF (LCOLLO) THEN
           NI = MAXC1
           LEROUT=LMAP7E.AND.(NAI.EQ.NLA).AND.NOI.EQ.NLO
           CALL COPRED(PW2,REJLEV,OBI,WM,SM,ERCOV,
     *     KP,NPARM,NFILE,NPARM1,NERRM,NGRE,NGRERR,NO,NPRED,NPRED1,
     *     LERNO,LINSOL,LREPEC,LTCOV,LSATAC,LADBA,LTNB,LTEB,LCOMP,
     *     LFOUND,LCOD,LMENSI,LSATP,LNBL1,LGRERS,LGRERR,LSA,LERCOV,
     *     LEROUT,LWAIT)
          ELSE
           IF (LREPEC) THEN
            OBS(IA1) = PRETAP
            IF (LADBA) OBS(IB1) = OBS(IB1)+OBS(IA1)
            IF (LTNB) OBS(IU1) = OBS(IB1)-OBS(IT1)
            IF (LTEB) OBS(IU1) = -OBS(IT1)
            IF (LCOMP) OBS(13) = OBS(12)-OBS(IU1)
           END IF
C 
           OBS(IA) = PREDP
           IF (LADBA) OBS(IB) = OBS(IB)+OBS(IA)
           IF (LTNB) OBS(IU) = OBS(IB)-OBS(IT)
           IF (LTEB) OBS(IU) =-OBS(IT)
           IF (LCOMP) OBS(3) = OBS(2)-OBS(IU)
          END IF
C
          IF (LSTAT) CALL COMPA(VG,IKP,LONECO,IU,2)
C
          IF (LMAP7) THEN
C CHANGE 2005-10-10 (9 -> 8).
           IPR=MOD(NOI1,8)+1
           PRV(IPR)=OBS(IU)
           IF (LMAP7E.AND.(.NOT.LWAIT))PRVE(IPR)=OBS(K2)  
           IF (IPR.EQ.8.OR.NOI1.EQ.NLO)WRITE(17,253)(PRV(I),I=1,IPR)
           IF (LMAP7E.AND.(IPR.EQ.8.OR.NOI1.EQ.NLO).AND.
     *     (.NOT.LWAIT))WRITE(11,253)(PRVE(I),I=1,IPR)
C FORMAT CHANGED 2005-11-07.
  253      FORMAT(8F10.4)
C ADDED 2005-11-01.
           IF (LEROUT) THEN
            NPRED=0
            DO I=0,NLA   
             DO IPR=0,NLO
              NPRED=NPRED+1
              IF (N1.GT.NIPCAT) THEN
C CR IS HERE ONLY USED AS A TRANSFER ITEM. CHANGE 2005-11-01.
               WRITE(*,*)' N1 EXCEEDS ALLOCATED MEM. ',N1,NIPCAT
               STOP
              END IF
              READ(19,REC=NPRED)(CR(NOI1),NOI1=1,N1)
              IF (NPARM.GT.0) CR(N1)=-CR(N1) 
              N19=MOD(IPR,8)+1
              IF (CR(N1).GT.1.0d-20) THEN
               PRVE(N19)=SQRT(CR(N1))
              ELSE
               PRVE(N19)=CR(N1)
              END IF
              IF (N19.EQ.8.OR.IPR.EQ.NLO)WRITE(11,253)
     *        (PRVE(N20),N20=1,N19)
              IF (LERCOV) THEN
               READ(20,REC=NPRED)PREDCO
               DO I62=1,NPRED
                READ(19,REC=I62)(CR(NOI1+NIPCAT),NOI1=1,N1)
                READ(20,REC=I62)PREDCP
                CPQ=COVPQ(SM,IS,KP,S,AAI,IMAX1,LMENSI,LSATP,PREDCO,
     *          PREDCP)
                ERCOV(I62)=CPQ
                DO I61=1,N
                 IF (NPARM.GT.0.AND.I61.GT.N-NPARM) THEN
                  ERCOV(I62)=ERCOV(I62)+CR(I61)*CR(I61+NIPCAT)
                 ELSE
                  ERCOV(I62)=ERCOV(I62)-CR(I61)*CR(I61+NIPCAT)
                 END IF
                END DO
               END DO
               WRITE(7,1662)(ERCOV(I61),I61=1,NPRED),PW2
               WRITE(*,1662)(ERCOV(I61),I61=1,NPRED),PW2
              END IF
             END DO
            END DO
           END IF
          ELSE   
           CALL COUT(NO,LONECO,LSMAL,LF,0)
C CORRECTION 1995.03.06 BY CCT.
           IF (LMEGR.AND.(.NOT.LMDD)) THEN
            IF (LDEFVP) THEN
             IF (LONECO) THEN
C CORRECTION 2002-04-14.
C DUDY AND DUDX ARE DERIVATIVES OF NORMAL POTENTIAL COMPUTED BY
C TRANS.	
              IF (LKSIP) THEN
C CONVERSION FROM ARCSEC TO M/S**2 AND CHANGE OF SIGN. 
               DUDY=DUDY-OBS(IA)*CCR(10)/RADSEC 
              ELSE
               DUDY=DUDX-OBS(IA)*CCR(10)/RADSEC 
              END IF 
              IF (.NOT.LNUOUT) WRITE(6,281)DUDY
  281         FORMAT(2F14.10)
             ELSE 
              DUDX=DUDX-OBS(IA1)*CCR(10)/RADSEC 
              DUDY=DUDY-OBS(IA)*CCR(10)/RADSEC 
              IF (.NOT.LNUOUT) WRITE(6,1281)DUDX,DUDY
 1281         FORMAT(/,2F14.10)
             END IF 
            ELSE 
             IF (LZETA) THEN
C CONVERSION TO POTENTIAL M**2/S**2.
              IF (.NOT.LNUOUT) WRITE(6,358)POT+OBS(IB)*CCR(10) 
  358         FORMAT(3E19.11)
C DEACTIVATED 2005-03-30.
C             IF (LPUNCH) WRITE(17,358)POT+OBS(IB)*CCR(10) 
             ELSE 
C CONVERSION TO M/S**2. 
              IF (.NOT.LNUOUT) WRITE(6,281)OBS(IB)*1.0D-5+GP
             END IF 
            END IF 
           END IF 
C
           IF (LPUNCH.AND.LSATP.AND.(.NOT.LZETA).AND.ISATP.EQ.2)
     *     WRITE(17,282)AZP,BETP,TAUP 
           IF (LMAP) IMAP(NO) = OBS(IU)*1000
          END IF
         END DO
        END DO
C ==========================================================
C
        IF (LMAP7) THEN
         WRITE(6,*)' GRID OUTPUT TO UNIT 17 WITH LABEL: '
         WRITE(6,392)RLAMIN,SLAC,SLOC,RLOMAX,GLA,GLO
        END IF
        IF (LSTAT) CALL COMPA(VG,IKP,LONECO,IU,3)
        IF (LGRERR.AND.NGRERR.GT.0) WRITE(6,*)' GROSERRORS DETECTED ',
     *  NGRERR 
C CHANGE 2002-10-08.
        IF ((LGRERS.OR.LGRERR).AND.LCOMP) THEN
         DO NGRR=1,8
          SGRE(NGRR)=(D1*NGRE(NGRR))/NGRERR
         END DO
         WRITE(*,3072)(NGRE(IGRR),IGRR=1,8),(SGRE(IGRR),IGRR=1,8)
 3072    FORMAT
     * (' HISTOGRAM RATIO ABS(ERROR)/ERROR ESTIMATE IN 0.5 INTERVALS .'
     *   ,/,8I8,/8F8.4/)
         LGRERS=LF 
        END IF
C 
        IF (LMAP) THEN
         K = NLA+1
         NLAST = 0
         WRITE(6,392)RLAMIN,SLAC,SLOC,RLOMAX,GLA,GLO
  392    FORMAT(6(F11.6,1X))
         DO J = 1, K
          NFIRST = NLAST + 1
          NLAST = NFIRST + NLO
          DO I=NFIRST,NLAST
           IPR=I-NFIRST
           IPR=MOD(IPR,9)+1
           PRV(IPR)=IMAP(I)/1000.0
           IF (IPR.EQ.9.OR.I.EQ.NLAST) WRITE(6,253)(PRV(JJ),JJ=1,IPR)
          END DO
         END DO 
        END IF
C
        IF (LDEN.AND.LPOT) THEN
C INPUT OF COEFFICIENTS, WHICH HAVE BEEN OVERWRITTEN WHEN LDEN IS TRUE.
         REWIND 3
         IF (.NOT.LINT) THEN
          READ(3)COFF
         ELSE        
          READ(3)C20IN
          DO I=1,N2
           READ(3)IICC(I)
          END DO
         END IF
         CM3=GMP
         CMM2=AX
         CM1=OMEGA2
        END IF
       ELSE
C
C POINT OR MEAN VALUE CALCULATION.
C *************** INPUT (9) ****************************************
        CALL DEFDAT(LCOLLO,LPRED,LPARAM,LFOR77,LE,LINTER,
     *  LSMAL,LFORM,LP,ICHAR,NMAX,ITRAC0,RRE)
C
        CALL INHEAD(LCOLLO,LREPEC,PW,LNFORM,LADDBP,LINVDE,
     *  LADBA,LADDBC)
C
C *************** INPUT (10) *********************************
C RETURN POINT FOR EACH NEW OBSERVATION RECORD,
 2027   CALL INP10(LINTER,LFOR77,LGRID,LFULLO,LTEST,LNOUSE,
     *  NWAR,NO2,ITRAC0,OBI,COSB,SINB,COST,SINT,TAUP,BETP,AZP)
        IF (LNOUSE.AND.((.NOT.LPARAM).OR.(LPARAM.AND.MP.EQ.0)))
     *  GO TO 2027
        IF (NO.GE.0) THEN
         COSLAP =  COS(RLATP)
         SINLAP =  SIN(RLATP)
         COSLOP = COS(RLONGP)
         SINLOP = SIN(RLONGP)
         IF (LINSOL.AND.LNEWSO) THEN
         PW2=VAR(SM,IS,KP,S,AAI,HP,IMAX1,LMENSI,COSLAP,SINLAP,LSATP,
     *      SATROT)
         END IF
C
         IF (LMENSI.AND.(.NOT.LMEAN1)) RLATP=RLATP+STEPN*D2
C SPHERICAL APPROXIMATION 2001-09-21.
         COSLAP =  COS(RLATP)
         SINLAP =  SIN(RLATP)
         IF (LMENSI) THEN
          IF (LMEAN1) THEN
           CALL PAZIM(RLATP,RLONGP,COSLAP,SINLAP,COSLOP,SINLOP,
     *     -CAZP,-SAZP,COST2P,SINT2P,LTEST)
          ELSE 
           IF (.NOT.LEQANG)CALL 
     *     ICMEAN(BSIZEN,STEPE,NSTEPE,COSSTE,SINSTE,COSLAP,SINLAP,LF,LF)
           RLONGP=RLONGP-STEPE*D2
          END IF 
         END IF
         COSLOP = COS(RLONGP)
         SINLOP = SIN(RLONGP)
C
         IF (LPARAM.AND.(.NOT.LEQP)) THEN
C
C --------------- INPUT (10A) --------------------------------
C INPUT OF PARAMETER TYPES, IF PARAMETERS ARE GIVEN INDIVIDUALLY
C FOR EACH OBSERVATION. FOR DATA RELATED TO SATELLITE-ALTIMETRY
C WE USE THE REVOLUTION NUMBER(S) WHICH IS IMPLICITLY GIVEN BY THE
C OBSERVATION NUMBER, (CODES IKP=9 FOR CROSS-OVER DIFFERENCES AND
C IKP=11 FOR SEA-SURFACE HEIGHTS TREATED LIKE GEOID UNDULATIONS.)
          CALL INPAR(IKP,NO,ITRACK,IC,N,NOX,NPOBS,NPAOLD,LNOUSE,
     *    LINTER,LIN4,LPRED,LDPR,LWRSOL,LTEST,LONEQ,OBI,IOBS1,NPOINT)
C RETURN TO INPUT (10) IF CROSS-OVER DIFFERENCE COULD NOT BE USED.
          IF (LNOUSE) GO TO 2027
         END IF
C
         IF (LOUTC) THEN
          IF (LOE1.OR.LOE2) OBS(K2) = OBI(IIE)
          IF(LOE2) OBS(K21) = OBI(IIE1)
          IF (K1.EQ.5) OBS(5)=D0
C
          IF (LREPEC.AND.IOBS2.GT.0) OBS(12) = OBI(IOBS2)
          IF (IOBS1.GT.0) OBS(2) = OBI(IOBS1)
         END IF
C
         IF (IH.EQ.0) THEN
          OBS(1) = HP
          H=HP
          IF (LMEAN.AND.LSIMH.AND.(.NOT.LWRSOL)) OBS(1) = D0
         ELSE
          H=OBI(1)
          OBS(1)=H
C CORRECTION 2003-04-08.
          IF (LMEAN.AND.LSIMH) THEN
           OBS(1) = HP
           H=HP
          END IF
         END IF
C
C CORRECTING THE OBSERVATION BY AN ADDITIVE AND MULTIPLICATIVE
C CONSTANT (IS USED ONLY FOR GRAVITY OBSERVATIONS).
         IF (LADMU) OBS(2)=OBS(2)*DM+DA
         IF (LKM) H = H*1.0D3
C CONVERSION FROM KM TO M.
C CORRECTION 2004-01-26.
         IF (IKP.GT.10.AND.IH.NE.0) HP = H
         IF (LMEAN.AND.LSIMH) H = D0
         IF (LDEN) HP=RRE**2/(RE-HP) - RE
C CONVERSION OF DEPTH TO ARTIFICIAL HEIGHT FOR DENSITY ANOMALIES.
         IF (LDEN) RP=RE+HP
C
         IF (.NOT.(LNGR.AND.(IORDER.NE.2.OR.LNKSIP).AND.(.NOT.LSATP)
     *   .AND.(.NOT.LMDD))) THEN
C
          RLATS=RLATP
          RLONGS=RLONGP 
          COSLA=COSLAP
          SINLA=SINLAP
          COSLO=COSLOP
          SINLO=SINLOP 
          REF=D0
          DO I=1,NSTEP
           CALL EUCLID(COSLA,SINLA,COSLOP,SINLOP,H,E21,AX1)
           REFI = RGRAV(IPC,IKP,REF1,REF2,REF3,SINLA,H,RG,CU,SU1,
     *     LSATP)
           VREF(1)=REF1
           VREF(2)=REF2
           VREF(3)=REF3
C
C CHANGE 1990.10.19 BY CCT CALL OF AXV ADDED . 
           IF (LSATP.AND.(.NOT.LGRADI)) THEN
            CALL AXV(SATROT,VREF) 
            IF (LGRP) REFI=VREF(3)
            IF (.NOT.LNKSIP) REFI=VREF(2)
            IF (.NOT.LNETAP) REFI=VREF(1)
           END IF
           IF (LMENSI) THEN      
            IF (LMEAN1) THEN
C FILTER FACTORS INTRODUCED 1992.11.26 BY CCT. 
             REF = REF+REFI*FILTER(I) 
             CALL PAZIM(RLATS,RLONGS,COSLA,SINLA,COSLO,SINLO,CAZP,SAZP,
     *       COSSTN,SINSTN,LTEST)  
            ELSE 
             REF = REF+REFI
             COSLA1=COSLA
             COSLA=COSLA*COSSTN+SINLA*SINSTN
             SINLA=SINLA*COSSTN-COSLA1*SINSTN
            END IF 
           ELSE
            REF = REF+REFI
           END IF 
          END DO  
          REF=REF/NSTEP
C COMPUTING THE REFERENCE VALUES.
          IF (LMEGR.AND.(LGRP.OR.(.NOT.LNKSIP).OR.(.NOT.LNETAP))
     *    .AND.(.NOT.LMDD)) THEN
C WE SUPPOSE THE FIRST DERIVATIVES ARE IN MGAL WHEN LMEGR IS TRUE.
           OBS(2) = OBS(2)-REF*1.0D5
          END IF
          IF (LMDD.AND.(.NOT.LSATP)) THEN
           OBS(2) = OBS(2)-REF*1.0D9
           IF (LF) WRITE(*,*)' OB2,REF ',OBS(2),REF
          END IF
          REF0=REF
         END IF
C
         IF (LWLONG.AND.LDEFVP.AND.LREPEC) OBS(12) = - OBS(12)
         IF (LWLONG.AND.LONECO.AND.(.NOT.LNETAP)) OBS(2) = -OBS(2)
C
         OBS(IB) = D0
         POT=D0
         GP=D0 
         DUDX=D0
         DUDY=D0
         IF (LREPEC) OBS(IB1) = D0
         IF (LTERRC) THEN
C
          OBS(ITE)=OBI(IITE)
          IF (LADBTE) OBS(IB)=OBS(ITE)
          IF (LREPEC) THEN        
           OBS(ITE1)=OBI(IITE1)
           IF (LADBTE) OBS(IB1)=OBS(ITE1)
          END IF
         END IF
C
         IF (LTRAN.OR.LPOT) THEN      
          CALL TRAPOT(LNPOT,LREPEC,LSPHER,LADDBP,LFULLO,
     *    POT00,RB,REF,REF0,UREF0,OBI,H,HPP,RRE,SU,SU8,VREF)
         ELSE
C CHANGE 2004-07-09.
          IF (.NOT.LSPHER) THEN
           CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,HP,E22,AX2)
C NO SPHERICAL APPROXIMATION, 2001-09-21.
C CHANGE 2004-08-11.
           IF (.NOT.LSATP.AND.(.NOT.LZETA)) ISATP=3
C THIS ASSIGNMENT INDICATES FULL ROTATION, USING THE UNIT MATRIX.
           IF (DISTO.LT.RB) THEN
            WRITE(*,*)' POINT INSIDE BJERHAMMAR SPHERE, H::= 10000 M '
            WRITE(*,*)HP,DISTO,RB
            HPP=0.0D0
           ELSE
            HPP=DISTO-RE
C CHANGE 2003-06-02.
            IF (IH.NE.0) HP=HPP
           END IF
C
           COSLAP=XY/DISTO
           SINLAP=Z/DISTO
           RLATP1=ATAN2(Z,XY)
C DLATP IS GEOCENTRIC LATITUDE MINUS GEODETIC LATITUDE. MORE CORRECT
C IS THE ANGLE BETWEEN THE NORMAL GRAVITY FIELD VECTOR, SEE RGRAV.
           DLATP=RLATP1-RLATP
           IF (ABS(DLATP).GT.0.1) THEN
            WRITE(*,*)' ERROR, RLATP,P1 = ',RLATP,RLATP1
           ELSE
C CORRECTION 2003-04-06.
            RLATP=RLATP1
            IF (IANG.EQ.6) SLAT=RLATP*180.0D0/PI
           END IF
          ELSE
           HPP=HP
          END IF
         END IF
C
         IF (LCREF) THEN
          CALL PRED(SR,AAR,0,0,0,2,IOBSR,NIR,IMAX1R,LT,LF,LF,LTABLR,
     *    LTCOV,LSATAC)
C
          OBS(IC1) = PREDP
          IF (LADDBC) OBS(IB) = OBS(IB)+OBS(IC1)
C
          IF (LREPEC) THEN
           OBS(IC11) = PRETAP
           IF (LADDBC) OBS(IB1)= OBS(IB1)+OBS(IC11)
          END IF
C      ELSE
C       LSTOP=LT
         END IF
C
         IF (LTNB) OBS(IU) = OBS(IB)-OBS(IT)
         IF (LTEB) OBS(IU) =-OBS(IT)
         IF (LK30) OBS(3) = OBS(2)-OBS(IU)
         IF (LK30) OB1 = OBS(3)
         IF (.NOT.LK30) OB1 = OBS(2)
C
         IF (LCOLLO) THEN
          NI = MAXC1
          CALL COPRED(PW2,REJLEV,OBI,WM,SM,ERCOV,
     *    KP,NPARM,NFILE,NPARM1,NERRM,NGRE,NGRERR,NO,NPRED,NPRED1,
     *    LERNO,LINSOL,LREPEC,LTCOV,LSATAC,LADBA,LTNB,LTEB,LCOMP,
     *    LFOUND,LCOD,LMENSI,LSATP,LNBL1,LGRERS,LGRERR,LSA,LERCOV,LF,
     *    LF)
         ELSE
          IF (LREPEC) THEN
           OBS(IA1) = PRETAP
           IF (LADBA) OBS(IB1) = OBS(IB1)+OBS(IA1)
           IF (LTNB) OBS(IU1) = OBS(IB1)-OBS(IT1)
           IF (LTEB) OBS(IU1) = -OBS(IT1)
           IF (LCOMP) OBS(13) = OBS(12)-OBS(IU1)
          END IF
C 
          OBS(IA) = PREDP
          IF (LADBA) OBS(IB) = OBS(IB)+OBS(IA)
          IF (LTNB) OBS(IU) = OBS(IB)-OBS(IT)
          IF (LTEB) OBS(IU) =-OBS(IT)
          IF (LCOMP) OBS(3) = OBS(2)-OBS(IU)
         END IF
C
         IF (LSTAT) CALL COMPA(VG,IKP,LONECO,IU,2)
C
         CALL COUT(NO,LONECO,LSMAL,LFULLO.AND.LNCOL.AND.(.NOT.LCOMP),
     *   IORDER)
C CORRECTION 1995.03.06 BY CCT.
         IF (LMEGR.AND.(.NOT.LMDD)) THEN
          IF (LDEFVP) THEN
           IF (LONECO) THEN
C CORRECTION 2002-04-14.
            IF (LKSIP) THEN
C CONVERSION FROM ARCSEC TO M/S**2 AND CHANGE OF SIGN. 
             DUDY=DUDY-OBS(IA)*CCR(10)/RADSEC 
            ELSE
             DUDY=DUDX-OBS(IA)*CCR(10)/RADSEC 
            END IF 
            IF (.NOT.LNUOUT) WRITE(6,281)DUDY
           ELSE 
            DUDX=DUDX-OBS(IA1)*CCR(10)/RADSEC 
            DUDY=DUDY-OBS(IA)*CCR(10)/RADSEC 
            IF (.NOT.LNUOUT) WRITE(6,1281)DUDX,DUDY
           END IF 
          ELSE 
           IF (LZETA) THEN
C CONVERSION TO POTENTIAL M**2/S**2.
            IF (.NOT.LNUOUT) WRITE(6,358)POT+OBS(IB)*CCR(10) 
C DEACTIVATED 2005-03-30.
C           IF (LPUNCH) WRITE(17,358)POT+OBS(IB)*CCR(10) 
           ELSE 
C CONVERSION TO M/S**2. 
            IF (.NOT.LNUOUT) WRITE(6,281)OBS(IB)*1.0D-5+GP
           END IF 
          END IF 
         END IF 
C ADDED 2002-11-25.
         IF (LPUNCH.AND.LSATP.AND.(.NOT.LZETA).AND.ISATP.EQ.2)
     *   WRITE(17,282)AZP,BETP,TAUP 
C
        ELSE
         LSTOP=LT
        END IF
        IF (.NOT.LSTOP) GO TO 2027
        IF (LSTAT) CALL COMPA(VG,IKP,LONECO,IU,3)
        IF (LGRERR.AND.NGRERR.GT.0) WRITE(6,*)' GROSERRORS DETECTED ',
     *  NGRERR 
C CHANGE 2002-10-08.
        IF ((LGRERS.OR.LGRERR).AND.LCOMP) THEN
         DO NGRR=1,8
          SGRE(NGRR)=(D1*NGRE(NGRR))/NGRERR
         END DO
         WRITE(*,3072)(NGRE(IGRR),IGRR=1,8),(SGRE(IGRR),IGRR=1,8)
         LGRERS=LF 
C 
        END IF
       END IF
      END IF
C
C *************** INPUT (18) *********************************
C
      IF (LINTER) WRITE(6,*)' STOP ?' 
      READ(5,*)LSTOP
      IF (LPRED) LRESOL = LF
      IF (LERCOV) THEN
       CLOSE(7)
       CLOSE(19)
       CLOSE(20)
      END IF
      IF (LEROUT) THEN
       CLOSE(19)
       LEROUT=LF
      END IF
      IF (.NOT.LSTOP) GO TO 2000
C IF LSTOP IS TRUE, THE EXECUTION WILL FINISH.
C
      IF (LMAP7E) CLOSE(11) 
      CLOSE(3)
      CLOSE(8)
      CLOSE(13)
      IF (LGRERR) CLOSE(12) 
      IF (LOPEN4) CLOSE(INZ)
      IF (LOPEN7.OR.(LWRSOL.AND. (.NOT.LCLU7))) THEN
       CLOSE(17)
      END IF
C
 9997 CONTINUE
      IF (LTIME) THEN
       CPU5=SYTIME(RCBASE,TIMEARRAY)
       WRITE(6,7470)TIMEARRAY(1),CPU5 
       WRITE(*,7471)RCBASE 
 7471  FORMAT(' TOTAL CPU TIME USED= ',F12.3,' SEC ') 
      END IF 
      IF (NWAR.GT.0) WRITE(*,1391)NWAR
 1391 FORMAT(' NUMBER OF WARNINGS ',I8)
      IF (NERRM.GT.0) WRITE(*,1392)NWAR
 1392 FORMAT(' NUMBER OF ERROR MESSAGES FROM NES ',I8)
      IF (LPARAM.AND.LTEST) WRITE(*,*)' IPAMAX = ',IPAMAX
      WRITE(6,*)' GEOCOL TERMINATED AT:'
      CALL FDATE(UDATE) 
C 386 CALL DATE(UDATE)
C 386 CALL TIME(UTIME)
C 386 WRITE(6,*)UDATE,UTIME
      WRITE(6,*)UDATE
      IF (IPX.LT.0.AND.(.NOT.LTABH)) GO TO 9999
      WRITE(6,391)KCI(37),KCI(36),KCI(35)
  391 FORMAT(/'  COVCG OR TABH CALLED',I7,' TIMES WITH INIT.',/,
     *'  COVCG OR TABH CALLED',I7,' TIMES WITHOUT INIT.',/,
     *'  COVCX CALLED        ',I7,' TIMES.',/)
C
 9999 STOP
C
      END
      SUBROUTINE DEFDAT(LCOLLO,LPRED,LPARAM,LFOR77,LE,LINTER,
     *LSMAL,LFORM,LP,ICHAR,NMAX,ITRAC0,RRE)
C THIS MODULE DEFINES POINT OR MEAN VALUE DATA RECORDS.
C EXTRACTED FROM GEOCOL16 VER. 11, 2004-11-18. LAST CHANGE:
C FOR VARIABLE DESCRIPTIONS SEE MAIN PROGRAM.
      IMPLICIT NONE
      INTEGER MAXO,NSAT,MXPAR,MAXCX,NCTA,NMAP,NIPT,NIPCAT,INBLP,
     *MAXOD,NSPHAR,NDIMC,NISIZE,NCRW,NNBL,NCOEFF,NROOT,NIICC,
     *NFILTE,ICHAR,MAXPAR,NPARM1,NPARM,IPA,NCXLAS,IPTYPE,
     *IT1,NSTEP,NSTEPE,ICSYS,MP,IPACAT,IOBS2,IH,IANG,
     *IOBS1,INO,ILA,ILO,IKPREF,INZ,MKP,IO2,NPOBS0,NOUSE,
     *ILAST,IJ,NGR,NGRERR,NFOURI,NFOUR,NMAX,ICODE,ITIME,ITIME0,
     *IB,IA,IC1,IP,ITE,IT,K1,IIE,IIE1,IIP,IIP1,IITE,IITE1,IU,
     *K2,K21,IP1,INUMR,NPNO,IB1,ITE1,IC11,IU1,IDSAT,NERCOV,
     *IA1,NGRE,ITCOUN,INV,INN,NUM,K4,K3,K2P3,MAXSA,IPAMAX
      LOGICAL LLCOER,LINSOL,LLCOEE,LINERT
      REAL*8 D0,D1,D2,D3,D4,D5,HCZERO,RADSEC,GMC,RE,
     *RLONGP,RLATP,SINLOP,COSLOP,HP,PREDP,BSIZEE,SCFRDD,
     *BSIZEN,STEPE,DM,DA,RLAMIN,RLAMAX,RLOMIN,RLOMAX,
     *RP,VG,FILTER,SAZP,CAZP,OBS,HPK,WM,PI,REJLEV,VARNO,SFACT,
     *COSLAP,SINLAP,COSSTE,SINSTE,STEPN,COSSTN,SINSTN,COST2P,SINT2P,
     *PRETAP,B,WOBS,COSLAT,SINLAT,COSLON,SINLON,RLONG,RLAT,HQ,
     *BSIZE,SGRE,COZERO,SCALE,SCALE2,VARI,DXX,GM,PPS,PPA,FOUCOF,
     *RRE,RDD,SR11,SR12,SR13,SR22,COSAZ,SINAZ,SATROT,SCFACT,CTIME 
C
      PARAMETER (MAXO=16200,NSAT=16200,MXPAR=2500,MAXCX=28920,NCTA=1600,
     *NMAP=400,NIPT=1500,NIPCAT=100002,INBLP=150,MAXOD=9*MAXO,
     *NSPHAR=180,MAXSA=6*MAXO) 
      PARAMETER (NDIMC=399120,NISIZE=880,NCRW=400000,NNBL=20000)
C     PARAMETER (NDIMC=99986000,NISIZE=14000,NCRW=100000000,NNBL=20000)
C     PARAMETER (NCOEFF=3243602,NROOT=3602,NIICC=1621801)
      PARAMETER (NCOEFF=4844402,NROOT=4402,NIICC=2422201)
C
      LOGICAL LUSNGS,LTERRC,LNUOUT,LPOTIN,LFORM,
     *LINTRA,LDENOL,LK2EQ4,LTERMO,LTERMA,LSTNO,
     *LFOR77,LONECO,LNKSIP,LNETAP,LDEFVP,LGRP,
     *LKM,LT,LPOSDA,LDEFF,LF,LGRID,LERNO,
     *LNEWD,LCOD,LPUNCH,LOUTC,LNERNO,LK30,LIN4,LGIGRS,
     *LRESOL,LMEGR,LMEAN,LSTOP,LE,LTRAN,
     *LBIN,LSA,LZETA,LP(2),LALLP,LEQP,LONEQ,
     *LSTAT,LWRSOL,LPARAM,LPOT,LNCOL,LCOLLO,
     *LDEN,LMDD,LCOMP,LPOTSD,LCOM,LWLONG,LAREA,LPRED,LOPCOF
     *,LK31,LCLU7,LOPEN7,LMENSI,LSIMH,LEQANG
     *,LBICOV,LBISOL,LBIPOT,LOPEN4,LGRADI,LTIME,LTCOV,LADMU,
     *LSATP,LGRERR,LINTER,LOK,LOBSST,LMEAN1,LFILTE,LSMAL       
     *,LGRERS,LCTIME,LCOERR,LSKIPL,LFOURI,LFOUR,LSATAC,LSTART,LTILT
C
      INTEGER I,ITMODE,ITMOD,ITM0,ITRAC0,ITRACE,
     *NO,NO1,ICSYSL,NAI,NLA,INL,IEM,INZOLD,ITRGAP,ITRACK,ITOLD,ITROLD,
     *ICZERO,NCZERO,NI,NR,INDEX,IKP,ISAT,ISATP,NOBLK
C
      CHARACTER*128 DNAME,OLDN,
     *ERNAME,ROTFIL
C 386 CHARACTER*72 UTIME
      CHARACTER*128 FMT
C
      COMMON /CON1/OLDN(4)/CON2/GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,
     *ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
C
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
C
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
C
      COMMON /COM2/DXX,NUM(70),VARI(32),SCALE,SCALE2,INN,INV
C
      COMMON/OBSER/OBS(22)
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C
      COMMON/DAT/LNEWD,LRESOL,LGRID
C
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON/CCTIME/CTIME(NIPCAT),ITRACE(NIPCAT),ITMODE,ITM0,ITMOD,
     *ITRGAP,ITRACK,ITOLD,NERCOV,LCTIME,LCOERR,LLCOER
C
      COMMON /CLPARM/SCFRDD(42),SCFACT,RDD,FOUCOF(0:21),NFOURI(42),
     *NFOUR,LFOURI(42),LLCOEE(42),LFOUR
C
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE  
C
      COMMON /CDEFCA/VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,
     *SGRE(10),
     *ROTFIL,ERNAME,DNAME(2),FMT(9),NSTEP,NSTEPE,IDSAT,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,
     *IPAMAX,NGR,NGRE(10),ICSYS,
     *LMEAN,LSA,LADMU,LSTAT,LAREA,LZETA,LGRADI,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LTILT,LINERT
C
      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),SATROT(3,3) 
C
      LNCOL=.NOT.LCOLLO
      LSTOP = LF
      NSTEP=1
      NSTEPE=1 
      NO1=0
      BSIZEN=D0
      LSIMH=LT
      LMENSI=LF
      LMEAN1=LF 
      LTILT=LF
C
C *************** INPUT (9) **********************************
C
C INPUT OF ONE DATA-SET OF OBSERVATIONS OR COORDINATES OF PREDICTION
C POINTS. ALL RECORDS MUST BE PUNCHED IN THE SAME WAY. THERE ARE THE
C FOLLOWING RESTRICTIONS AND OPTIONS: A STATION NUMBER MAY BE USED, BUT
C IT MUST OCCUPY THE FIRST DATAFIELD ON THE RECORD. THE TWO NEXT DATA-
C FIELDS MUST CONTAIN THE GEODETIC LATITUDE AND LONGITUDE ( IN AN ARBI-
C TRARY ORDER). IN CASE THE HEIGHT IS GIVEN, IT MUST BE PUNCHED IN THE
C NEXT DATAFIELD. THE FOLLOWING UP TO EIGHT DATAFIELDS WILL HAVE TO
C CONTAIN THE OBSERVED QUANTITY (OR QUANTITIES WHEN A PAIR OF DEFLECTI-
C ONS ARE OBSERVED) AND CONTINGENTLY THE STANDARD DEVIATIONS (WHEN
C LSA IS FALSE). ALSO PRECOMPUTED POTENTIAL COEFFICIENT AND TERRAIN
C POTENTIAL CONTRIBUTIONS MAY BE INPUT. THE LAST DATAFIELD MAY
C HOLD THE VALUE OF A LOGICAL VARIABLE LSTOP, TRUE FOR THE LAST
C RECORD IN THE FILE AND FALSE (I.E. BLANK ON MOST COMPUTERS) OTHERWISE.
C THIS IS ONLY USED IF NO STATION NUMBER IS INPUT. OR IF FREE-FORMAT
C INPUT IS USED FROM UNIT 5 (LIN4=.FALSE., SEE BELOW).
C IF A STATION NUMBER IS USED, THE END OF THE DATASET IS
C SUPPOSED TO HAVE BEEN REACHED, IF A NEGATIVE STATION NUMBER IS READ.
C
C ----------------------- INPUT (9) -------------------------------
C
C INPUT OF VARIABLES SPECIFYING THE CONTENT OF THE RECORDS. INO = 1,
C WHEN THE STATION NUMBER IS PUNCHED, 0 OTHERWISE, ILA, ILO THE NUMBER
C OF THE DATAFIELDS OCCUPIED BY THE LATITUDE AND THE LONGITUDE RESPEC-
C TIVELY, IANG  SPECIFYING UNITS OF ANGLES (1 FOR DEGREES, MINUTES, ARC-
C SECONDS, 2 FOR DEGREES, MINUTES, 3 FOR DEGREES AND 4 FOR 400-GRADES,
C 5 CARTESIAN COORD.
C IH = THE NUMBER OF THE DATAFIELD HOLDING THE HEIGHT (ZERO WHEN NO
C HEIGHT IS CONTAINED), IOBS1, IOBS2 = THE DATAFIELD NUMBER OF THE FIRST
C AND THE SECOND OBSERVATION, RESPECTIVELY (ZERO WHEN NO FIRST OR SECOND
C OBSERVATION), PLUS 10 TIMES THE RELATIVE POSITION OF A PRECOMPUTED
C POTENTIAL COEFFICIENT CONTRIBUTION, PLUS 100 TIMES THE RELATIVE
C POSITION OF A CONTRIBUTION FROM A TERRAIN POTENTIAL. EXAMPLE:
C SUPPOSE A RECORD CONSIST OF STATION NUMBER, LATITUDE, LONGITUDE,
C HEIGHT, KSI, STDV(KSI), PRECOMPUTED POTENTIAL COEFFICIENT CONTRI-
C BUTION AND PRECOMPUTED TERRAIN CONTRIBUTION, FOLLOWED BY THE
C SAME QUANTITIES FOR ETA. THEN INO=1,ILA=2,ILO=2,IH=4,IOBS1=435,
C IOBS2=438.
C NOTE, THAT IF STANDARD DEVIATIONS ARE PRESENT IN RECORD, THEY MUST
C FOLLOW JUST AFTER THE OBSERVATIONS. IF ONE OBSERVATION COMES RIGHT
C AFTER THE OTHER (IOBS2-IOBS1=1) THEN TWO STANDARD DEVIATIONS
C MUST FOLLOW THE SECOND OBSERVATION.
C IF IOBS1=0 AND PRECOMPUTED POTENTIAL COEFFICIENT OR TERRAIN
C CONTRIBUTIONS MUST BE INPUT, THEN THE POSITIONS OF THESE VALUES
C MUST BE GIVEN RELATIVE TO THE HEIGHT (IF PRESNENT) OR THE
C LONGITUDE/LATITUDE, DEPENDING ON WHICH ONE COMES LAST.
C THEN IKP, SPECIFYING THE KIND OF OBSERVATION, (1 FOR ZETA, 2
C FOR MEASURED GRAVITY, POINT OR MEAN GRAVITY ANOMALIES, 3 FOR KSI, 4
C FOR ETA AND 5 FOR PAIR OF DEFLECTIONS (KSI,ETA) OR (ETA,KSI),(IN THE
C SAME ORDER AS THE LATITUDE AND THE LONGITUDE)). ALSO THE CODES USED
C IN COVAX CAN BE USED, WITH 10 ADDED. IF CODES IKP EQUAL TO
C 26, 28, 30 AND 35 ARE USED, PAIRS OF QUANTITIES (16,17), (18,19),
C (20,21), (25,23) ARE COMPUTED.
C
C IN CASE LPARAM IS TRUE, OBSERVATIONS OF THE DIFFERENCE BETWEEN THE
C LOCAL GEODETIC AND THE GEOCENTRIC ELLIPSOIDAL HEIGHT (IKP = 6),
C OBSERVATIONS OF PAIRS OF DIFFERENCES BETWEEN THE GEOCENTRIC AND
C THE LOCAL GEODETIC LATITUDE AND LONGITUDE*COS(LATITUDE) (IKP = 7)
C CF. REF.(E), EQ.(12) - (14), AND SATELLITE ALTIMETER CROSS-OVER
C DIFFERENCES (IKP = 9) ARE ACCEPTED. IF A NEGATIVE VALUE OF IKP IS
C IS USED, THEN THE INPUT VALUE IS EQUAL TO THE OBSERVATION MINUS
C CONTINGENT CONTRIBUITIONS FROM POTENTIAL COEFFICIENTS, DATUM
C SHIFT OR COLLOCATION STEP 1. THIS IS USED, FOR EXAMPLE WHEN
C A RESTART-FILE IS INPUT.
C
C THEN ICSYS, AN INTEGER DEFINING THE COORDINATE SYSTEM. IF IT IS
C .LT. 0 THEN IT IS THE GEOCENTRIC (BEST) SYSTEM.
C
C THEN HP, THE MEAN HEIGHT OF THE POINTS (USED WHEN NO INDIVIDUAL
C HEIGHTS ARE GIVEN ), THE VALUES OF 10 LOGICAL VARIABLES:
C  LPUNCH  = PRINT OBS. OR PREDICTED VALUE AND CONTINGENTLY THEIR
C     DIFFERENCE, (OUTPUT TO UNIT 17).
C  LWLONG = LONGITUDE (AND ETA) ARE POSITIVE TOWARDS WEST.
C  LMEAN  = THE PREDICTED OR OBSERVED QUANTITY IS A MEAN GRAVITY VALUE.
C  LSA    = ALL OBSERVED QUANTITIES HAVE THE SAME STANDARD DEVIATION.
C     IN THIS CASE MUST THE COMMON VALUE (WM) BE INPUT SUBSEQUENTLY.
C  LKM    = THE HEIGHT IS IN UNITS OF KILOMETERS.
C  LADMU  = THE OBSERVATION HAS TO BE CORRECTED USING AN ADDITIVE
C           AND A MULTIPLICATIVE CONSTANT, AND IS CONTINGENTLY
C           AN ABSOLUTE VALUE (ONLY USABLE FOR GRAVITY AND
C           AND GRAVITY GRADIENTS PRESENTLY).
C  LSTAT  = STATISTICS OF DIFFERENCES BETWEEN OBSERVED AND PREDICTED
C     QUANTITIES ARE TO BE OUTPUT. THIS INCLUDES A PRIMITIVE HISTOGRAM
C    WITH 21 BINS. THE SIZE OF THE SAMPLING INTERVAL (VG) MUST BE INPUT
C    SUBSEQUENTLY.
C  LAREA  = ONLY DATA WITHIN GIVEN AREA ARE TO BE USED. LATITUDE AND
C    LONGITUDE BOUNDARIES MUST BE INPUT SUBSEQUENTLY.
C  LFORM  = VARIABLE FORMAT IS USED FOR DATA. FORMAT MUST BE INPUT
C    SUBSEQUENTLY, E.G. AS (I6,2F8.3,3F7.2,L2).
C  LIN4   = DATA  BE INPUT USING UNIT INZ. THE NAME OF THE FILE MUST
C    BE INPUT SUBSEQUENTLY, WITH THE VALUE OF INZ IF LFOR77 IS TRUE.
C
C SUPPLEMENTAL INFORMATION MUST BE GIVEN IN THE FOLLOWING SEQUENCE:
C (A)  NAME OF FILE CONNECTED TO UNIT INZ (LIN4 TRUE),
C (B)  IF LPUNCH IS TRUE, NAME OF FILE CONNECTED TO UNIT 17.
C (C)  FORMAT OF DATA RECORD (LFORM TRUE)
C (D)  VG, SAMPLING INTERVAL MAGNITUDE (LSTAT TRUE)
C (E)  WHEN LPARM IS TRUE: LEQP, TRUE WHEN ALL OBSERVATIONS DEPEND
C      ON THE SAME MP PARAMETERS. THEN MP AND IF LEQP IS TRUE THE PARA-
C      METER CODES. THEY MUST BE INPUT WITH THE DATA, IF LEQP IS FALSE.
C (F)  WHEN LADMU IS TRUE, AND IKP=2 OR 13 (GRAVITY), OR IKP=1 (HEIGHT
C      ANOMALY) OR IKP=10 (DENSITY ANOMALY), THEN INPUT OF A
C      MULTIPLICATIVE AND AN ADDITIVE CONSTANT AND LMEGR, TRUE IF
C      THE GRAVITY OR GRAVITY GRADIENT QUANTITY IS A MEASURED VALUE.
C      (IN THE CASE IKP=1 ONLY THE ADDITIVE CONSTANT HAS MEANING)
C      USED TO GET THE VALUES IN MGAL OR TO REMOVE BIAS (IKP=1) IF
C      NEEDED.
C (G)  LATITUDE AND LONGITUDE BOUNDARIES IF LAREA IS TRUE.
C (H)  IF LMEAN IS TRUE THEN AS (16C), LSIMH, BSIZEN, BSIZEE.
C (I)  IF LSA IS TRUE, THE  COMMON DATA ERROR, WM. (IT MUST BE FALSE
C      WHEN LERNO IS FALSE AND LNCOL OR LPRED ARE TRUE).
C (J)  IF IKP=10 (DENSITY CONTRAST), INPUT OF EXPONENT OF WEIGHT
C      FACTOR ON HARMONIC DENSITY AND RADIUS OF SPHERE INCLUDING MASSES.
C (K)  WHEN LSTAT, LERNO AND LCOMP ARE TRUE, INFORMATION ON SUSPECTED
C      GROSS-ERRORS MAY BE OUTPUT TO FORTRAN UNIT 24. THIS IS INDI-
C      CATED BY GIVING THE ERROR LEVEL (TYPICALLY 3.0). IF THIS IS
C      LARGER THAN 0.0, THEN THE FILE NAME MUST BE INPUT AS WELL.
C (L)  WHEN A ROTATED REFERENCE FRAME IS USED, IT MUST BE INDICATED
C      WHETHER THE ROTATION ONLY IS IN THE HORIZONTAL PLANE OR A FULL
C      ROTATION.
C
C IF OBSERVATION CODES LARGER THAN 10 ARE USED, HP WILL BE USED ONLY
C WHEN NO HEIGHT IS GIVEN EXPLICITLY FOR EACH POINT (IH = 0). HP IS
C ALSO USED TO COMPUTE THE STANDARD DEVIATION OF THE SIGNAL QUANTITIES
C OCCURRING IN THE HEADING OF THE OUTPUT TABLES.
C
C =================== RETURN POINT IF INPUT PARAMETERS NOT OK ========
 1119 IF (LINTER) WRITE(6,1120)
 1120 FORMAT(' INPUT DATA LINE AND OUTPUT SPECIFICATIONS',/
     *' POSITION OF STATION NUMBER (0: NO NUMBER, -1: NO OUTPUT U6)',/
     *' POSITION OF LATITUDE AND LONGITUDE (E.G. 2 , 3)',/
     *' TYPE OF ANGULAR UNITS USED (1: DD MM SS.S, 2: DD MM.M 3: DD.D)'/
     *' 4: GRADES, 5: X,Y,Z (CTRS) '/
     *' POSITION OF HEIGHT (0: NO HEIGHT)',/
     *' POSITION OF OBSERVATION 1 AND 2 (0 IF NO OBS. 1 OR 2)',/
     *' DATA OR COMPUTATION QUANTITY TYPE CODE (11: GEOID,',/
     *'   13: GRAVITY, 15: TZZ, 26: (KSI,ETA), NEGATIVE: REF.SUBTR.)'/
     *' COORD.SYST. CODE, -1 INDICATE GLOBAL SYSTEM, +100 REVERSE TR.'/
     *' HEIGHT (IN M OR KM), ONLY USED IF NO INPUT HEIGHT',/
     *' (USED AS HEIGHT ABOVE MEAN EARTH SPHERE IF LSPHER IS TRUE !)',/
     *' LPUNCH - TRUE IF OUTPUT OF RESULT TO FILE',/
     *' LWLONG - TRUE IF LONGITUDE POSITIVE EAST',/
     *' LMEAN  - OBS. OR COMPUTED QUANTITY IS A MEAN VALUE',/
     *' LSA    - TRUE IF ALL ERROR ESTIMATES ARE IDENTICAL',/
     *' LKM    - TRUE IF HEIGHT IN KM',/
     *' LADMU  - TRUE IF UNREDUCED OR CONSTANTS * OR +',/
     *' STAT   - TRUE IF STATISTICS OF RESULT WANTED',/
     *' LAREA  - TRUE IF DATA ONLY INSIDE SPECIFIC AREA ARE USED',/
     *' LFORM  - TRUE IF FORMAT OF DATA IS INPUT',/
     *' LIN4   - TRUE IF DATA NOT IN INPUT STREAM (FROM FILE)') 
      READ(5,*,ERR=1119)INO,ILA,ILO,IANG,IH,IOBS1,IOBS2,IKP,
     *ICSYS,HP,LPUNCH,LWLONG,LMEAN,LSA,LKM,LADMU,LSTAT,LAREA,LFORM,LIN4
      LNUOUT=INO.LT.0
      NO=0
      IF (LNUOUT)INO=-INO
      LRESOL=IKP.LT.0
      IF (LRESOL) IKP = - IKP
      LINTRA=ICSYS.GT.100
      IF (LINTRA) ICSYS=ICSYS-100
C THIS INDICATES, THAT THE INVERSE DATUM-SHIFT TRANSFORMATION SHOULD
C BE USED.
      IKPREF=IKP
C LGIGRS IS TRUE IF SPECIAL FORMATS ARE USED.
C LUSNGS IS TRUE IF NGS FORMATS ARE USED. LSTNO IS TRUE IF
C KMS STATION NUMBERS ARE USED.
      LGIGRS=IKP.GT.40.AND.IKP.LT.90
      LUSNGS=IKP.EQ.96
      LSTNO=LGIGRS.AND.INO.EQ.11
      IF (LSTNO) LNUOUT=LF
      LNEWD=ICSYS.LT.0
      LTRAN=.NOT.LNEWD
      LMEGR=LF
      IF (LGIGRS) IKP=IKP-40
      IF (LGIGRS.AND.IKP.EQ.2)IKP=13
      IF (LUSNGS) IKP=5
C ADDED 2004-08-11.
      LZETA=IKP.EQ.1.OR.IKP.EQ.11
      LGRADI=IKP.EQ.15.OR.IKP.EQ.30.OR.IKP.EQ.35.OR.(IKP.GE.20
     *.AND.IKP.LE.25) 
      LSATP=((IKP.EQ.12.OR.IKP.EQ.16.OR.IKP.EQ.17.OR.IKP.EQ.13.OR.
     *LGRADI.OR.IKP.EQ.11).AND.LGIGRS) 
      IF (.NOT.LPRED) LSATAC=(LSATAC.OR.LSATP)
C LSATAC REGISTRES THE STATE THAT DATA IN A SATELLITE FRAME HAS
C BEEN USED AS OBSERVATIONS.
C
      IF (LSATP) THEN
       ISATP=1
       WRITE(6,*)' DATA IN LOCAL FRAME.'
C INITIALIZING SATROT ADDED 2005-03-02.
       SATROT(1,1)=D1
       SATROT(2,2)=D1
       SATROT(3,3)=D1
       SATROT(1,2)=D0
       SATROT(2,1)=D0
       SATROT(1,3)=D0
       SATROT(3,1)=D0
       SATROT(2,3)=D0
       SATROT(3,2)=D0
      END IF 
C
C FOR LSAT=TRUE, WE EXPECT 1. & 2. ORDER DERIVATIVES TO BE GIVEN IN A
C SATELLITE ORIENTED COORDINATE SYSTEM.
C THE AZIMUTH, THE ROLL AND THE PITCH ANGLES MUST BE INPUT AFTER
C EACH OBSERVATION ON A SEPARATE RECORD IN DECIMAL DEGREES OR
C IN THE FORM OF A FULL 3*3 ROTATION MATRIX. 
C MODIFICATION INTRODUCED JULY 1989 BY CCT AND SEPT. 2004.
C 
      LGRERR=LSTAT.AND.LCOMP.AND.LERNO.AND.LPRED.AND.(.NOT.LNCOL)   
      IF (.NOT.LOPEN4) INZ=5
      IF (LIN4) THEN
C
C --------------- INPUT (9A) ---------------------------------
C FIRST INPUT OF DOCUMENT (FILE) NAME. IN FORTRAN 77, UNIT NUMBER
C MUST BE INPUT AS WELL.
       IF (LINTER)WRITE(6,*)' INPUT NAME OF FILE HOLDING DATA' 
       READ(5,2103)DNAME(1)
       INZ=4
       IF (LINTER)WRITE(6,*)' INPUT FORTRAN UNIT NUMBER' 
       IF (LFOR77) THEN
        READ(5,*)INZ
        IF (INZ.LT.22.OR.INZ.GT.28) WRITE(*,*)
     *  ' WARNING: UNIT NUMBER MAY BE IN CONFLICT WITH OTHER '
       END IF
C
       IF (.NOT.(LOPEN4.AND.OLDN(3).EQ.DNAME(1).AND.OLDN(4)
     * .EQ.DNAME(2).AND.INZOLD.EQ.INZ)) THEN       
        IF (LOPEN4) CLOSE(INZ)
        OPEN(UNIT=INZ,FILE=DNAME(1),STATUS='OLD',FORM='FORMATTED')
        WRITE(6,169)INZ,(DNAME(I),I=1,ICHAR)
  169   FORMAT(/' DATA INPUT FROM UNIT',I3,', FILE=',2A128)
        OLDN(3)=DNAME(1)
        OLDN(4)=DNAME(2)
        LOPEN4=LT
        INZOLD=INZ 
       END IF
      END IF
C
C --------------- INPUT (9B) ---------------------------------
C
      IF (LPUNCH) THEN       
       IF (LINTER) 
     * WRITE(6,*)' INPUT NAME OF FILE TO HOLD RESULT' 
       READ(5,2103)DNAME(1)
       IF (.NOT.(LOPEN7.AND.OLDN(1).EQ.DNAME(1).AND.OLDN(2).EQ.
     * DNAME(2))) THEN       
        IF (LOPEN7) THEN       
         END FILE 17
        END IF 
        OPEN(17,FILE=DNAME(1),STATUS='UNKNOWN',FORM='FORMATTED')
        WRITE(6,290)(DNAME(I),I=1,ICHAR)
  290   FORMAT(/' SIMULTANEOUSLY OUTPUT TO FILE ',2A128)
        LOPEN7=LT
        OLDN(1)=DNAME(1)
        OLDN(2)=DNAME(2)
       END IF
      END IF
C
C THE FOLLOWING IS TO ASSURE THAT OUTPUT ON UNIT 17 IS NOT MIXED.
      IF (LWRSOL.AND.(.NOT.LPRED).AND.LPUNCH) LPUNCH = LF
C
C --------------- INPUT (9C) ---------------------------------
      IF (LINTER.AND.LFORM)WRITE(6,*)
     *' INPUT DATA FORMAT (EG. (I3,5F7.2) )' 
      IF (LFORM) READ(5,103)FMT(1) 
  103 FORMAT(A128)
 2103 FORMAT(A128)
C INPUT OF FORMAT OF INPUT RECORD IF VARIABLE FORMAT CAN BE USED.
C
      write(*,*)ikp
      IF ((LKM.OR.HP.GT.1.0D5).AND.IKP.NE.51) THEN
C CHANGE 2007-07-18.
       IF (LKM) HP = HP*1.0D3
C ADDITION 1999.12.13 AND 2005-04-11 BY CCT.
C IF UNITS ARE KM, OR HEIGHT ABOVE 100 KM WE EXPECT
C OBS TO BE SMALL AND USE A 4 DIGIT LAYOUT.
       LSMAL=LT
      ELSE
       LSMAL=LF
      END IF
C
      RP = RE+HP
      IF (LWRSOL) MKP = -IKP
      IO2=MOD(IOBS2,10)
      IF (IO2.NE.0) IO2=6
C CHANGE 2000-10-06.
      IF (LKM) THEN
       HPK=HP*1.0D-3
      ELSE
       HPK=HP
      END IF
      IF (LWRSOL) WRITE(17,902)IANG,IO2,MKP,ICSYS,HPK,LF,LF,
     *LMEAN,LF,LKM,LF,LF,LF,LF,LF
  902 FORMAT(' -1  2  3',I3,'  4  5',3I4,F10.2,10L2)
      LCOD = IKP.GT.5 .AND. IKP .LT. 10
C
C --------------- INPUT (9D) ---------------------------------
C INPUT OF SAMPLING INTERVAL MAGNITUDE.
      IF (LSTAT) THEN
       IF (LINTER)WRITE(6,*)' INPUT SAMPLING INTERVAL SIZE'
       READ(5,*)VG
      END IF
C
      IF (LPARAM) THEN
C
       NCXLAS = 0 
C --------------- INPUT (9E) ---------------------------------
C INPUT OF LOGICAL VARIABLE LEQP, TRUE IF ALL OBSERVATIONS DEPEND
C ON THE SAME PARAMETERS AND NUMBER OF PARAMETERS, MP. IF LEQP IS
C TRUE, THEN INPUT OF PARAMETER IDENTIFICATION CODES. OTHERWISE
C THEY MUST BE EXPLICITLY OR IMPLICITLY GIVEN FOR EACH OBSERVATION
C E.G. BY THE REVOLUTION OR TRACK NUMBER.
       IF (LPRED) IPA = 0
       NPOBS0=0
       NOUSE=0
C CHANGE 2005-03-29.
       IF (.NOT.LCOD) ILAST=IPA+1
       ITROLD=-9999
       IF (LINTER) WRITE(6,1118)
 1118  FORMAT(
     * ' INPUT LEQP, TRUE IF ALL OBS. OR COMPUTED VALUES DEPEND ON',/
     * ' THE SAME PARAMETER (T/F) AND NUMBER OF PARAMETERS ',/
     * ' (IF DATA DOES NOT DEPEND ON ANY PARAMETERS INPUT T  0) ')
  216  FORMAT(' LEQP,MP ',L2,I7)
       READ(5,*)LEQP,MP
       IF (LWRSOL) WRITE(17,216)LEQP,MP
       WRITE(*,216)LEQP,MP
C ADDED 2002-02-18.
       IF ((.NOT.LEQP).AND.(IKP.EQ.11.OR.LGRADI)) THEN
C THIS IS A PRELIMINARY SOLUTION IN ORDER TO IDENTIFY PARAMETER GROUPS.
C CHANGED 2003-04-02.
C IF ALTIMETRY (IKP=11) AND TRACK NUMBER IS USED, INPUT 1.0 0.5.
C IF OBSERVATION TIME IS USED, INPUT START TIME AND TIME OF ONE
C REVOLUTION.
        IF (LINTER) WRITE(*,*)' INPUT TIME INTERVAL AND START TIME '
        READ(*,*)PPA,PPS
        WRITE(*,*)' TIME INTERVAL PER PARAM. AND START TIME '
     *  ,PPA,PPS
        IF (LWRSOL) WRITE(17,*)PPA,PPS    
       END IF
C
       IF ((.NOT.LCOD).OR.LPRED) THEN
        IPA = IPA+2
       END IF
       IF (IPA.GT.IPAMAX) IPAMAX=IPA
       IF (LEQP.AND.(.NOT.LCOD).OR.LPRED) IPACAT(IPA) = MP
       IF (.NOT.(LEQP.OR.(LCOD.AND.(.NOT.LPRED)))) IPACAT(IPA) = -MP
       IF( MP.NE.0) THEN
        IF (LINTER) THEN
         WRITE(6,*)' INPUT PARAMETER CODES' 
        END IF   
        IF (LEQP .AND. MP.NE.0) THEN      
         READ(5,*)(IPACAT(I+IPA),I=1,MP)
         CALL PARCAT(LALLP,NPNO)
         WRITE(6,170)MP,(IPACAT(I+IPA),I=1,MP)
         IF (LWRSOL) WRITE(17,150)(IPACAT(I+IPA),I=1,MP)
  150    FORMAT(12I6)
  170    FORMAT(/' OBSERVATIONS CONTRIBUTE TO/DEPEND ON ',I3,
     *   ' PARAMETERS',3I6)
         IF (MP.GT.3) WRITE(6,171)MP,(IPACAT(I),I=1,MP)
  171    FORMAT(/' OBSERVATIONS CONTRIBUTE TO/DEPEND ON ',I3,
     *   ' PARAMETERS',3I6,(/,12I6))
        ELSE
         IF (MP.GT.10) THEN
          WRITE(*,*)' MP > 10 '
          STOP
         END IF
         IF (.NOT.LCOD)THEN
C ICODE VALUES ARE: BIAS, 1, TILT, 2, SCALE FACTOR, 3.
          READ(*,*)(ICODE(I),I=1,MP)
          IF (MP.LT.3)  THEN
           WRITE(6,170)MP,(ICODE(I),I=1,MP)
          ELSE
           WRITE(6,171)MP,(ICODE(I),I=1,MP)
          END IF
          DO I=1,MP
           LTILT=LTILT.OR.ICODE(I).EQ.2
          END DO
C         IF (LTILT) WRITE(*,*)' LTILT ',LTILT	
         END IF
        END IF
       END IF
      END IF
C
      DM = D1
      DA = D0
      LGRP = IKP.EQ.2.OR.IKP.EQ.13.OR.IKP.EQ.12
      LZETA = IKP.EQ.1.OR.IKP.EQ.11
      LDEN=IKP.EQ.10
      LPOTSD=LGRP.AND.(.NOT.LP(1))
C
C --------------- INPUT (9F) ---------------------------------
      IF (LADMU) THEN
       IF (LINTER) WRITE(6,1121)
 1121  FORMAT(' INPUT MULTIPLICATIVE AND ADDITIVE CONSTANT AND',/
     * ' LMEGR, TRUE IF VALUE INPUT OR COMPUTED IS UNREDUCED') 
       READ(5,*)DM,DA,LMEGR
       WRITE(*,1123)DM,DA,LMEGR
 1123 FORMAT(' DM= ',D16.5,', DA= ',D16.5,', LMEGR= ',L2)
      END IF
C LMEGR IS TRUE, WHEN THE MEASURED GRAVITY VALUE IS INPUT. DM AND DA ARE
C AN ADDITIVE AND A MULTIPLICATIVE CONSTANT, RESPECTIVELY, WHICH CAN BE
C USED TO CONVERT INPUT VALUES TO MGAL OR CORRECT FOR A SYSTEMATICAL
C ERROR. IF LZETA IS TRUE, THEN ONLY BIAS CORRECTION IS POSSIBLE.
C
C --------------- INPUT (9G) ---------------------------------
      IF (LAREA) THEN
       IF (LINTER) WRITE(6,*)
     * ' INPUT MINIMUM AND MAXIMUM LATITUDE AND LONGITUDE (DEG.)'
       READ(5,*)RLAMIN,RLAMAX,RLOMIN,RLOMAX
       WRITE(6,208)RLAMIN,RLAMAX,RLOMIN,RLOMAX
  208  FORMAT(' DATA SELECTED IN AREA BOUNDED BY:'/
     * ' LATITUDE ',2F9.2,' DEG ',/,' LONGITUDE',2F9.2,' DEG'/)
       IF (RLOMIN.GT.RLOMAX) THEN
        WRITE(*,*)' WARNING ',RLOMIN,RLOMAX
        RLOMIN=RLOMIN-360.0D0 
       END IF
       CALL RAD(0,0,RLAMIN,RLAMIN,3)
       CALL RAD(0,0,RLOMIN,RLOMIN,3)
       CALL RAD(0,0,RLAMAX,RLAMAX,3)
       CALL RAD(0,0,RLOMAX,RLOMAX,3)
       IF (RLOMIN.GT.RLOMAX) THEN
        WRITE(*,*)' WARNING ',RLOMIN,RLOMAX
        RLOMIN=RLOMIN-D2*PI    
       END IF
      END IF
C
C --------------- INPUT (9H) ----------------------------------
      IF (LMEAN) THEN 
       IF (LINTER)WRITE(6,1117) 
       READ(5,*)LSIMH,LEQANG,BSIZEN,BSIZEE,RLATP 
       IF (LWRSOL) WRITE(17,231) LSIMH,LEQANG,BSIZEN,BSIZEE,
     * RLATP
 1117   FORMAT(' INPUT PARAMETERS DEFINING TYPE AND SIZE OF MEAN VALUE',/
     *  ' LSIMH - TRUE IF WE USE EQUIVALENT HEIGHT REPR. OF MEAN',/
     *  ' LEQANG- TRUE IF EQUAL ANGULAR OR 1-D BLOCK',/
     *  ' BLOCK SIDE LENGTH IN LAT. & LONG. (MIN) OR (LENGTH .0 IF 1D)',/
     *  ' LATITUDE OF TOTAL AREA MEAN') 
  231   FORMAT(2L2,3F10.2)
C LMEAN1 IS TRUE IF MEAN VALUES ARE 1D, ALONG A SATELLITE OR
C AIRCRAFT TRACK, FOR EXAMPLE 
       LMEAN1=.NOT.LSIMH.AND.(.NOT.LEQANG).AND.ABS(BSIZEE).LT.
     * 1.0D-8 
       IF (LMEAN1.AND.(.NOT.LFILTE)) 
     * CALL MEAN1(FILTER,NFILTE,SAZP,CAZP,LFILTE,LGRID,LINTER) 
      END IF 
C
      IF ((LE.AND.LSA).OR.(LSA.AND.LGRERR)) THEN
C
C ---------------- INPUT (9I) --------------------------------
       IF (LINTER) WRITE(6,*) 
     * ' INPUT COMMON STANDARD DEVIATION OF OBSERVATIONS'
       READ(5,*)WM
       WRITE(*,212)WM
  212  FORMAT(' COMMON ST.DEV. OF OBS = ',F8.4)
      ELSE
       WM=D0
      END IF
C
      IF (LDEN) THEN       
C
C ---------------- INPUT (9J) -------------------------------
       CALL DENDEF(NMAX,LINTER,LWRSOL,LPARAM,
     * LPOT,LBIPOT,LBIN,LINSOL,LDENOL,LSKIPL,RRE)
C INPUT OF EXPONENT OF WEIGHT FACTOR ON HARMONIC DENSITY,
C RADIUS OF SPHERE WITHIN WICH MASSES ARE LOCATED IN M. CF. REF(F),
C SECTION 3,SALE FACTOR AND VALUE OF LOGICAL VARIABLE LNPOT
C TRUE, IF NEW SET OF COEFFICIENTS ARE TO BE USED FOR THE DENSITY
C COMPUTATIONS, (DIFFERENCES BETWEEN THE ORIGINAL COEFFICIENTS AND
C COEFFICIENTS OF A TOPOGRAPHIC-ISOSTATIC REDUCTION POTENTIAL).
C IF POTENTIAL COEFFICIENTS NOT ALREADY STORED ON BINARY FORM
C (NOT HP9000) ALSO THE NAME OF THE FILE TO BE CONNECTED TO UNIT 3.
C THIS ONLY APPLIES IF LPOT IS TRUE.
      END IF
C
      IF (LGRERR) THEN       
C
C ----------------------- INPUT (9K) ----------------------------
C INPUT OF REJECTION LEVEL FOR GROSS-ERRORS. IF LARGER THAN 0.0,
C NAME OF FILE, WHERE SUSPECTED GROSS-ERRORS ARE OUTPUT MUST BE
C GIVEN AS WELL. 
       IF (LINTER) WRITE(6,*)' INPUT REJECTION LEVEL (<0 NO REJ.)' 
       READ(5,*)REJLEV 
       LGRERS=LGRERR
       LGRERR=LGRERR.AND.REJLEV.GT.D0 
       IF (LGRERR) THEN          
        IF (LINTER)WRITE(6,*)' INPUT NAME OF FILE TO HOLD REJECTED OBS.' 
        READ(5,'(A)')ERNAME
        OPEN(12,FILE=ERNAME,FORM='FORMATTED') 
        WRITE(6,*)' OUTLIERS WILL BE OUTPUT TO FILE ',ERNAME 
       END IF
C INITIALIZING ARRAY TO HOLD STATISTICS OF ERRORS.
       DO NGR=1,8
        NGRE(NGR)=0
        SGRE(NGR)=D0  
       END DO
       NGRERR=0 
      END IF
C 
      ISATP=0
      IF (LSATP) THEN
C 
C ---------------------- INPUT (9L) ---------------------------
C INPUT OF INTEGER, ISATP=1 WHEN ROTATION IS ONLY IN HORIZONTAL
C PLANE, =2 WHEN IT IS A FULL ROTATION AND 3 WHEN NO ROTATION IS
C MADE. WHEN ISATP=4 THE FULL ROTATION MATRIX IS FOUND ON A SEPARATE FILE.
       IF (LINTER) THEN
C CHANGE 2004-08-31.
        WRITE(6,*)
     *  ' INPUT 1 FOR HORIZ. ROT, 2 FOR FULL 3D ROTATION (EULER) '
        WRITE(*,*)' 3 FOR NO ROT., 4 FOR ROT MAT FILE, 5 FOR QUART. ' 
       END IF
       READ(*,*)ISATP
       IF (IKP.EQ.11)ISATP=3
       IF (ISATP.EQ.4) THEN
C ROTATION MATRIX FILE MUST HAVE FORMAT: TIME AND 6 MATRIX ELEMENTS
C GIVING ROTATION FROM ENU SYSTEM TO LOCAL SYSTEM.
        WRITE(*,*)' INPUT FILE NAME '
        READ(*,'(A)')ROTFIL
        WRITE(*,*)' ROTATION MATRIX FILE ',ROTFIL
        OPEN(13,FILE=ROTFIL)
       END IF
       IF (ISATP.EQ.5) THEN
C INPUT OF QUARTERNION-FILE NAME. 2005-03-12.
        WRITE(*,*)' WARNING: NOT FULLY IMPLEMENTED **** '
        WRITE(*,*)' INPUT FILE NAME '
        READ(*,'(A)')ROTFIL
        WRITE(*,*)' ROTATION MATRIX FILE ',ROTFIL
        OPEN(13,FILE=ROTFIL)
       END IF
      END IF
C
      ITMODE=0
      IF (LCOERR.AND.(.NOT.LPRED)) THEN
C LCOERR IS TRUE IF CORRELATED ERRORS MAY EXIST, SEE INPUT (1D).
C ---------------------- INPUT (9M) ---------------------------
C INPUT OF LOGICAL VARIABLE SIGNIFYING WHETHER THIS DATA-SET HAS CORRELATED
C ERRORS. (CHANGE 1998-03-20).
       IF (LINTER) WRITE(*,*)
     * ' INPUT T IF DATASET HAS CORRELATED ERRORS, OTHERWISE F.'
       READ(*,*)LLCOER
       IF (LLCOER) THEN
        ITOLD=-999999
        WRITE(*,*) ' DATASET HAS CORRELATED ERRORS '
C THE NOISE COVARIANCE FUNCTION MAY BE SPECIFIED AS A FOURIER SERIES
C OR AS A FINITE COV. FCT.
        IF (LINTER) THEN
         WRITE(*,8701)
 8701    FORMAT(' INPUT T IF NOISE COVARIANCE FUNCTION FOURIER SERIES,',
     *   ' OR F IF FINITE FUNCTION, ',/,
     *   ' FOLLOWED BY TRACK-MODE, = 1 IF TRACK NUMBER INPUT AS ',/,
     *   ' SEPARATE RECORD AFTER EACH OBSERVATION ',/,
     *   ' AND = 2 OR 3 IF IT DEPENDS ON THE "STATION NUMBER"',/,
     *   ' WITH NEGATIVE VALUES IF FUNCTION DEPENDS ON TIME AND ',/
     *   ' NOT SPHERICAL DISTANCE. ')
        END IF
        READ(*,*)LFOUR,ITMODE
        WRITE(*,*)' TRACK INPUT MODE = ',ITMODE
C CHANGE 2005-04-04. 
        LCTIME = ITMODE.LT.0
        IF (LCTIME) ITMODE=-ITMODE
        IF (LFOUR) THEN
         WRITE(*,*)' NOT FULLY IMPLEMENTED *** WARNING *** '
         IF (LINTER) THEN
          WRITE(*,*)' INPUT MAX DEG. OF COEFFICIENTS (<21) '
          WRITE(*,*)' AND COEFFICIENTS (0-MAX) (TWO LINES) '
         END IF
         READ(*,*)NFOUR
         IF (NFOUR.GT.20) THEN
          WRITE(*,*)' LIMIT EXCEEDED FOUCOF, STOP '
          STOP
         END IF
         READ(*,*)(FOUCOF(IJ),IJ=0,NFOUR)
         WRITE(*,*)(FOUCOF(IJ),IJ=1,NFOUR)
        ELSE
         IF (LINTER) WRITE(*,*)
     *   ' INPUT NOISE VARIANCE AND HALF DISTANCE (DEG.)'
         IF (LINTER) WRITE(*,*) ' TO ZERO FOR ERROR COV.FCT.'
         READ(*,*)VARNO,RDD
 8702    FORMAT(' NOISE VAR. AND RDD (DEGREES) = ',2D12.5)    
         WRITE(*,8702) VARNO, RDD
        END IF
        IF (.NOT.LCTIME) RDD=RDD*PI/180.0D0
        SCFACT=VARNO/COZERO(D0,RDD,1)
       END IF
C ADDED 2002-10-09.
       IF (ITMODE.EQ.2) THEN
C THIS IS TO BE USED WHEN STATION NUMBERS (OR TIME) MAY BE
C SEGMENTED IN SLICES EQUALLY LONG (ITMOD).
        IF (LINTER) WRITE(*,*)
     *  ' INPUT START NUMBER, AND NUMBER OF POINTS IN TRACK '
        READ(*,*)ITM0,ITMOD
        WRITE(*,*)' START NO. AND NUMBER OF POINTS ',ITM0,ITMOD
        ITRAC0=0
       END IF
C NEW MODE ADDED 2003-03-19.
       IF (ITMODE.EQ.3) THEN
C THIS IS TO BE USED WHEN A NEW TRACK IS IDENTIFIED BECAUSE THE
C "STATION NUMBERS" CHANGE MORE THAN ITRGAP.
        IF (LINTER) WRITE(*,*)
     *  ' INPUT MINIMUM GAP BETWEEN TRACKS '
        READ(*,*)ITRGAP
        ITOLD=-10
        WRITE(*,*)' MIN: GAP BETWEEN TRACKS ',ITRGAP
       END IF
      ELSE
       LLCOER=LF
      END IF
C 
      IF (LINTER) THEN
       WRITE(6,*)' ALL SPECIFICATIONS OK ?'
       READ(5,*)LOK
       IF (.NOT.LOK) GO TO 1119
      END IF
C 
      RETURN
      END
C
      SUBROUTINE INHEAD(LCOLLO,LREPEC,PW,LNFORM,LADDBP,LINVDE,
     *LADBA,LADDBC)
C THE SUBROUTINE COLLECTS ALL INFORMATION FROM INPUT (9).
C MOVED FROM MAIN-PROGRAM 2004-11-27.
      IMPLICIT NONE
C
      LOGICAL LREPEC,LONECO,LNKSIP,LINVDE,LCOLLO,
     *LNETAP,LDEFVP,LOBSST,LSTART,LFORM,LSMAL,LADBA
     *,LP,LOCAL,LSUM,LF,LT,LNFORM,LTNB,LTEB,LOE1,LOE2,LE,
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
     *,LMEAN,LSA,LADMU,LSTAT,LAREA,LZETA,LGRADI,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,LADDBC,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LTABLE,LTABLR,LCO1,
     *LPOT,LKM,LTERRC,LPOTIN,LC1,LC2,LCREF,
     *LTERMA,LTERMO,LSTNO,LPUNCH,LADBPR,LADBTE,LADDBP,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT,
     *LPRED,LNEQ,LNEQ8,LNEWSO,LINT,LNEWD,LRESOL,LGRID,LNGR
     *,LKSIP,LNCOL,LPARAM,LTILT,LINERT
C
      INTEGER IKP,MAXO,ICZERO,NCZERO,IPC,IKC,
     *NI,NR,INDEX,ISAT,ISATP,NOBLK,
     *IDLAT,IDLON,MLAT,MLON,NOX,KCI,NC1,NC2
     *,ITCOUN,KP,KPP1,IORDER,NSAT
     *,ICSYS,ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,
     *IPAMAX,NGR,NGRE,NSTEP,NSTEPE,NFILTE,NBOLD,IS,IPX,
     *IMAX1,IMAX1R,IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO
     *,INUMR,NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG
     *,NMAX,II,IOBS,IOBSR,N1,NIR,IDSAT,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO
C
      PARAMETER (MAXO=16200,NSAT=16200)
C
      REAL*8 B,HQ,RLAT,SINLAT,COSLAT,
     *RLONG,SINLON,VAR,COSLON,WOBS,
     *SINLOP,COSLOP,SLAT,SLON,PW,
     *BSIZE,BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,
     *CCI,CCR,SIGMA0,SIGMA,HCMAX,
     *CCV,DC,D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC
     *,FG,FJ,OMEGA2
     *,GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,SHIFTS
     *, STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER,S,SR,AAI,AAR,
     *SINLA0,COSLA0,RLONG0,PW2,BSIZEA,F1,GM1,
     *DX,DY,DZ,EPS3,EPS2,EPS1,DL,AX2,E22
     *,OLDB,CNR,GMP,AX,E21,AX1,OBS
     *,VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,SGRE
     *,SR11,SR12,SR13,SR22,
     *COSAZ,SINAZ,SATROT,GREF,SM,UREF,CLATD,RDI
C
      CHARACTER*128 ROTFIL,ERNAME,DNAME,FMT,OLDN,OLDCOV
C
      COMMON /CINHEA/SHIFTS,PW2,BSIZEA,E21,AX1,F1,GM1,GREF,SM(2200),
     *UREF,KP,KPP1,IPC,
     *LSMAL,LADBPR,LADBTE,LNGR
     *,LKSIP,LNCOL,LTNB,LTEB,LOE1,LOE2,LE
C
      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),SATROT(3,3) 
C
      COMMON/OBSER/OBS(22)
      COMMON/DAT/LNEWD,LRESOL,LGRID
C /DAT/ TRANSFERS LOGICAL VARIABLES TO THE SUBROUTINE ITRAN.
C
      COMMON /BIPAR/OLDB(4),CNR,GMP,AX,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT
C
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
C
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
      COMMON /CHEAD1/LC1,LC2,LCREF
C IN /OUTC/ AND /CHEAD/ ARE STORED INFORMATION USED TO HANDLE THE DIF-
C FERENT I/O SITUATIONS.
      COMMON /ITRANC/SINLA0,COSLA0,RLONG0,
     *DX,DY,DZ,EPS3,EPS2,EPS1,DL,AX2,E22
C DATUM SHIFT PARAMETERS.
      COMMON /BIPARC/OLDCOV(2),S,SR,AAI,AAR,NBOLD,IS,IPX,
     *IMAX1,IMAX1R,LTABLE,LTABLR,LCO1
C DATA USED WHEN STORING SOLUTIONS OR COVARIANCE FUNCTION ON
C BINARY FORM. (CHANGE MADE NOV 1986).
C
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE  
C
      COMMON /CDEFCA/VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,
     *SGRE(10),
     *ROTFIL,ERNAME,DNAME(2),FMT(9),NSTEP,NSTEPE,IDSAT,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,
     *IPAMAX,NGR,NGRE(10),ICSYS,
     *LMEAN,LSA,LADMU,LSTAT,LAREA,LZETA,LGRADI,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LTILT,LINERT
C TRANSFERS VARIABLES FROM DEFDAT.
C
      COMMON /CON1/OLDN(4)/CON2/GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,
     *ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
C THESE VARIABLES HAVE BEEN PLACED IN COMMON, SO THAT THEY MAY BE
C INITIALIZED BY THE BLOCK DATA MODULE.
C
      COMMON /GRAVCC/FG(30),FJ(30),LP(2),OMEGA2,IORDER
C COMMON VARIABLES USED IN GRAVC AND RGRAV, HOLDING I.E. COEFFICI-
C ENTS OF LEGENDRE SERIES OF NORMAL POTENTIAL AND NORMAL GRAVITY
C FORMULA.
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C
C COMMON VARIABLES USED IN COVAX. SEE THIS SUBROUTINE FOR VARIABLES.
C
      COMMON /CMCOV/CCI(24),CCR(56),SIGMA0(2200),SIGMA(2200),HCMAX,
     *CCV(2,2),DC(36),KCI(37),NC1,NC2,LOCAL,LSUM
C COMMON VARIABLES USED IN COVAX. SEE THIS SUBROUTINE FOR VARIABLES.
C
      COMMON /COBS/CLATD,RDI,SLAT,SLON,IDLAT,IDLON,MLAT,MLON,NOX,LFORM
C
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C
      LREPEC = IKP.EQ.5.OR.IKP.EQ.7.OR.(IKP.GT.25.AND.IKP.LT.36)
C INITIALIZATION OF VARIABLES IN COMMON BLOCK /PR/.
      LONECO = .NOT.LREPEC
C CORRECTIONS 1992.08.27 TO ADD KODES 22 AND 24 AND LSATP. 
      LNKSIP = LONECO.AND.IKP.NE.3.AND.IKP.NE.16.AND.IKP.NE.18
     *         .AND.IKP.NE.20.AND.IKP.NE.25.AND.IKP.NE.22
      LNETAP = LONECO.AND.IKP.NE.4.AND.IKP.NE.17.AND.IKP.NE.19
     *         .AND.IKP.NE.21.AND.IKP.NE.23.AND.IKP.NE.24 
      LDEFVP = .NOT.LNKSIP.OR.(.NOT.LNETAP).OR.LSATP
      LNGR = .NOT.LGRP
C LREPEC IS TRUE, WHEN TWO COLUMNS CAN BE COMPUTED AT THE SAME TIME.
C LNSKIP, LNETAP IS TRUE, WHEN THE OBSERVATION OR REQUESTED PREDIC-
C TION IN P IS NOT LIKE KSI RESP. ETA.
      LKSIP = .NOT.LNKSIP
      LNFORM=.NOT.LFORM
C OUTPUT ADDED MAY 1994 BY CCT. 
      IF (LADMU.AND.LPRED.AND.(.NOT.LCOMP)) THEN
       WRITE(*,*)' ABSOLUTE VALUES OUTPUT LAST IN SI UNITS.' 
       IF (LZETA) WRITE(*,*)' OUTPUT IS POTENTIAL IN M**2/S**2 '
       IF (LDEFVP) WRITE(*,*)' OUTPUT IS D/DX, D/DY IN M/S**2 ' 
      END IF 
C
      PW = D0
      KP=IKC(IKP)
      KCI(6)=KP
      KPP1=KP+1
      IF (.NOT.(LNCOL.OR.LCOD)) INDEX(JR+1)=IKP
C IORDER IS ORDER OF DIFFERENTIATION ASSOCIATED WITH VARIABLES
C OF TYPE IKP.
      IORDER=2
      IF (KP .GE. 8) GO TO 2012
      GO TO (2010,2010,2011,2011,2012,2012,2011,2011),KPP1
 2010  IORDER = 0
      GO TO 2012
 2011  IORDER = 1
C
 2012 LMDD=LF
      IF (IORDER.EQ.2.AND.LMEGR) LMDD=LT
C IF SECOND ORDER DERIVATIVES, LMDD IS TRUE IF THE VALUES ARE OBSERV.
C
      LINVDE = LONECO.OR.(IOBS2.EQ.0).OR.(IOBS1.LT.IOBS2)
      LOUTC = LNEQ.OR.LCOMP
      IF ((.NOT.LOUTC).AND.LSTAT)WRITE(6,242)
  242 FORMAT(' *** WARNING *** LOUTC IS FALSE, LSTAT IS TRUE')
C BECOMES WRONG IF LOUTC IS NOT TRUE.
C
C OUTPUT OF HEADINGS AND INITIALIZATION OF VARIABLES.
C
      IF (ICSYSL.NE.ICSYS) THEN
       IF (.NOT.LPARAM) WRITE(6,173)
  173  FORMAT(2X)
       ICSYSL=ICSYS
      END IF
C
      IF (ICSYSL.NE.ICSYS.OR.(.NOT.LNEWD)) THEN
C LNEWDA IS FALSE IF BASIC SYSTEM IS NOT USED.
       WRITE(6,240)
  240  FORMAT(' SYSTEM USED:')
       CALL ICOSYS(ICSYS,0,GM1,AX1,E21,F1,UREF,GREF)
       IPC=0
       LPOTSD=.NOT.LP(1)
      ELSE       
C
       WRITE(6,210)
  210  FORMAT(/' SELECTED GEOCENTRIC SYSTEM USED.')
       AX1=AX2
       E21=E22
       IPC=15
       LPOTSD=LF
      END IF
C
      LMENSI=LF
      IF (LMEAN) THEN      
       IF (LSIMH) WRITE(6,205)
  205  FORMAT(/' THE FOLLOWING QUANTITIES ARE MEAN-VALUES, AND ARE',
     * ' REPRESENTED',/,' AS POINT VALUES IN THE HEIGHT H.')
       IF ((.NOT.LSIMH).AND.LEQANG) WRITE(6,232)BSIZEN,BSIZEE
  232  FORMAT(/' THE FOLLOWING QUANTITIES ARE MEAN VALUES, WITH',/,
     * ' BLOCKSIZE=',F10.2,' * ',F10.2,' MINUTES')
       IF ((.NOT.LSIMH).AND.(.NOT.LEQANG).AND.(.NOT.LMEAN1))
     * WRITE(6,233)BSIZEN
  233  FORMAT(/' THE FOLLOWING QUANTITIES ARE EQUAL-AREA MEAN',
     * ' VALUES, WITH BLOCK-SIZE=',F10.2,' MINUTES')
       IF (LMEAN1) WRITE(6,236)BSIZEN 
  236  FORMAT(' THE QUANTITIES ARE 1-D MEANS OVER A ',F9.4,
     * ' ARCMIN TRACK SEGMENT ') 
       LMENSI=.NOT.LSIMH
       IF (.NOT.LSIMH) THEN
        RLATP=RLATP*3600/RADSEC
C SPHERICAL APPROXIMATION.
        COSLAP=COS(RLATP)
        SINLAP=SIN(RLATP) 
        BSIZEN=BSIZEN*60/RADSEC
        IF (.NOT.LEQANG)BSIZEE=D0
        BSIZEE=BSIZEE*60/RADSEC
        IF (LMEAN1) THEN
         NSTEP=NFILTE
        ELSE
         NSTEP=5
        END IF
        NSTEPE=1 
        STEPE=D0 
        COSSTE=D1
        SINSTE=D0 
C THE CALL TO ICMEAN GIVES STEPSIZE AND COS,SIN. 
        CALL ICMEAN(BSIZEN,STEPN,NSTEP,COSSTN,SINSTN,D1,D0,LT,LMEAN1)
        SHIFTS=STEPN*(NSTEP-1)/2 
        COST2P=COS(SHIFTS)   
        SINT2P=SIN(SHIFTS) 
        IF (LMEAN1) THEN
C LMEAN1 INTRODUCED 1992.10.07 BY CCT. 
         BSIZEN=-BSIZEN 
C WE USE THE SWITCH OF SIGN AS AN INDICATOR OF 1D MEAN. 
        ELSE 
         NSTEPE=5 
         IF (LEQANG) THEN 
          CALL ICMEAN(BSIZEN,STEPE,NSTEPE,COSSTE,SINSTE,D1,D0,LT,LF)
         ELSE 
          BSIZEA= COS(RLATP)*BSIZEE
          CALL ICMEAN(BSIZEA,STEPE,NSTEPE,COSSTE,SINSTE,D1,D0,LT,LF)
         END IF 
        END IF 
       END IF
      ELSE
C THIS IS USED TO INDICATE IN COMEAN, THAT MEAN-VALUES ARE
C NOT COMPUTED IN P. CORRECTION NOV. 96 BY CCT. 
       STEPE=D1     
       LEQANG=LF
      END IF
C
      IF ((.NOT.LCOD).AND.LCOLLO) THEN
C
C COMPUTATION OF THE ROOT MEAN SQUARE VARIATION OF THE OBSERVATIONS
C IN THE HEIGHT GIVEN BY HP AND FOR MEAN VALUES OF EQUAL AREA TYPE
C AT LATITUDE RLATP. HP  IS THE HEIGHT ABOVE THE MEAN EARTH SPHERE.
       NI = MAXC1
       IF ((.NOT.LINSOL).OR.LCO1) THEN
        PW2=VAR(SM,IS,KP,S,AAI,HP,IMAX1,LMENSI,COSLAP,SINLAP,LSATP,
     *  SATROT)
        IF (PW2.GT.D0.AND.(.NOT.LINSOL.OR.LINSOL.AND.LCO1)) THEN
         PW = SQRT(PW2)
        ELSE
         IF (PW2.LT.D0) WRITE(*,*)' WARNING ** ',PW2, ' CALL: '
         WRITE(*,*)IS,KP,S,AAI,HP,IMAX1,LMENSI,COSLAP,SINLAP,LSATP
        END IF
       END IF
C
       LSMAL=(PW.LT.0.5D0.OR.LSMAL).AND.IKP.NE.11
C CHANGE 2004-01-27. AND 2007-07-18
       IF (LSMAL) THEN
        WRITE(*,2455)PW
 2455   FORMAT(' 4 DIGIT LAYOUT IN USE ',/,' PW= ',F12.5)
       END IF
C
       IF (LEQANG)
     * CALL ICMEAN(BSIZEE,STEPE,NSTEPE,COSSTE,SINSTE,D1,D0,LT,LF)
      END IF
C
      IF (HP.GT.3.0D5.AND.(LKSIP.OR.LGRP).AND.(LTRAN.OR.LPOT).AND.
     *LPOTSD) WRITE(6,204)
  204 FORMAT(/' ** WARNING: THE HEIGHT MAY BE TOO BIG FOR THE COMPUTA',
     *'TION OF',/,' THE REFERENCE GRAVITY OR THE CHANGE IN LATITUDE **')
C
      CALL HEAD(IKP,LONECO,PW,ISATP.GE.2)
C INITIALIZATION OF LOGICAL VARIABLES USED TO DETERMINE WHICH QUANTITIES
C WE WILL HAVE TO ADD TOGETHER TO FORM THE FINAL OUTPUT OR TO DETERMINE
C WHICH QUANTITIES WILL BE INPUT.
      LADBA = IB.NE.IA
      LADDBC = IB.NE.IC1
      LADDBP = IB.NE.IP
      LADBTE = IB.NE.ITE
      LADBPR = LADDBP.AND.LREPEC
      LTNB = LTRAN.AND.(IT.NE.IB)
      LTEB = LTRAN.AND.(IT.EQ.IB)
      LOE1 = (LE.OR.(LNCOL.AND.LERNO).OR.LGRERR.OR.LGRERS)
     *.AND.(.NOT.LSA).AND.LONECO
      LOE2 = (LE.OR.(LNCOL.AND.LERNO).OR.LGRERR.OR.LGRERS)
     *.AND.(.NOT.LSA).AND.LREPEC
C ERROR 2000-06-19  ????.
C    *.AND.(.NOT.LSA).AND.LREPEC
      IF (LF) WRITE(*,*)'LOE1, LE,LNCOL,LERNO,LSA,LREPEC',
     *LOE1,LE,LNCOL,LERNO,LSA,LREPEC,IIE1,LGRERR,LGRERS
C K1 HS BEEN INITIALIZED BY THE CALL OF 'HEAD'. IT WILL BE EQUAL
C TO THE NUMBER OF QUANTITIES READ IN TO THE ARRAY OBI.
      IF (LOE1) K1 = K1+1
      IF (LOE2) K1 = K1+2
      IF ((.NOT.(LOE1.OR.LOE2)).AND.(.NOT.LSA))IIE=0
C     IF (.NOT.LOE2)IIE1=0
C ERROR 2000-06-19  ????.
      IF ((.NOT.LOE2).AND.(.NOT.LSA))IIE1=0
C     WRITE(*,*)LOE2,IIE,IIE1
      IF (LSA) THEN
       K1=MAX0(K1,IIP,IIP1,IITE,IITE1,IOBS1,IOBS2)
      ELSE
       K1=MAX0(K1,IIP,IIP1,IITE,IITE1,IIE,IIE1,IOBS1,IOBS2)
      END IF
C
      OBS(IT) = D0
      IF (LREPEC) OBS(IT1)= D0
      IF (LSTAT) CALL COMPA(VG,IKP,LONECO,IU,1)
      IF (LSA.AND.K2.NE.1) OBS(K2)=WM
      IF (LSA.AND.K2.NE.1) OBS(K21)=WM
      IF (IP.GT.0)OBS(IP)=D0
      IF (IP1.GT.0.AND.LREPEC)OBS(IP1)=D0
      RETURN
      END
C
      SUBROUTINE INP10(LINTER,LFOR77,LGRID,LFULLO,LTEST,LNOUSE,
     *NWAR,NO2,ITRAC0,OBI,COSB,SINB,COST,SINT,TAUP,BETP,AZP)
C THE SUBROUTINE READS ONE DATA RECORD. MOVED FROM MAIN PROGRAM
C 2004-11-27. LAST UPDATE 2005-03-24.
      IMPLICIT NONE
C
      LOGICAL LPUNCH,LTERMA,LTERMO,LSTNO,LMEAN,LSA,LADMU,LSTAT,
     *LAREA,LZETA,LGRADI,LFOR77,LFORM,LINTER,LGRID,LNOUSE,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LPOT,LKM,LTERRC,LPOTIN,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT,LIN4,LT,LF,
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,LTEST,
     *LDENOL,LMDD,LOPCOF,LCLU7,LOPEN4,LOPEN7,LFULLO,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART,LCTIME,LCOERR,LLCOER,
     *LSMAL,LADBPR,LADBTE,LNGR
     *,LKSIP,LNCOL,LTNB,LTEB,LOE1,LOE2,LE,LTILT,LINERT
C
      INTEGER INUMR,NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,IJ,NSTEP,NSTEPE,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,I,NO,NWAR,
     *IPAMAX,NGR,NGRE,ITMODE,ITM0,ITMOD,ITRGAP,ITOLD,ITROLD,ICODE,
     *ICSYS,IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,NO2,IKP,
     *IDLAT,IDLON,MLAT,MLON,NOX,II,IOBS,IOBSR,N1,NIR,NMAX,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,MAXO,
     *NSAT,ITCOUN,IPTYPE,IPACAT,NPARM,NPARM1,J,ITRACK,
     *MAXPAR,MP,IPA,NCXLAS,NIPT,NIPCAT,ICZERO,NCZERO,
     *NI,NR,INDEX,ISAT,ISATP,NOBLK,NFILTE,ITIME,ITIME0,KP,KPP1,IPC,
     *ICSYSL,NAI,NLA,INL,IEM,INZOLD,ITRAC0,IDSAT,ITRACE,NERCOV
C
      PARAMETER (MAXO=16200,NSAT=16200,NIPT=1500,NIPCAT=100002)

      REAL*8 VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,
     *SGRE,SLAT,SLON,OLDB,CNR,GMP,AX,OBI(22),A0,
     *SR11,SR12,SR13,SR22,COSAZ,SINAZ,SATROT,SFACT, 
     *SR11A,SR12A,SR13A,SR22A,COSAZA,SINAZA, 
     *D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,
     *GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,DEGRAD,
     *STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *B,HQ,RLAT,SINLAT,COSLAT,RLONG,SINLON,COSLON,WOBS,
     *SINLOP,COSLOP,BSIZE,BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,
     *AZP,BETP,TAUP,CAZP,SAZP,HP,RLATP,PRETAP,PREDP,HCZERO,
     *SINB,COSB,SINT,COST,AZCH,TAUCH,BETCH, 
     *COST2P,SINT2P,FILTER,TRTIME,QUAT(4),CLATD,RDI, 
     *SHIFTS,PW2,BSIZEA,E21,AX1,F1,GM1,GREF,SM,UREF,CTIME
C
      CHARACTER*128 ROTFIL,ERNAME,DNAME,FMT,OLDN
C
      COMMON /CINHEA/SHIFTS,PW2,BSIZEA,E21,AX1,F1,GM1,GREF,SM(2200),
     *UREF,KP,KPP1,IPC,
     *LSMAL,LADBPR,LADBTE,LNGR
     *,LKSIP,LNCOL,LTNB,LTEB,LOE1,LOE2,LE
C TRANSFER VARIABLES FROM INHEAD.
C
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON/CCTIME/CTIME(NIPCAT),ITRACE(NIPCAT),ITMODE,ITM0,ITMOD,
     *ITRGAP,ITRACK,ITOLD,NERCOV,LCTIME,LCOERR,LLCOER
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE  
C
      COMMON /CON1/OLDN(4)/CON2/GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,
     *ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
C THESE VARIABLES HAVE BEEN PLACED IN COMMON, SO THAT THEY MAY BE
C INITIALIZED BY THE BLOCK DATA MODULE.
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C COMMON CONSTANTS D0=0.0D0  ETC.
C
      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),SATROT(3,3) 
C THE COMMON BLOCKS CONTAINS THE ELEMENTS OF THE ROTATION MATRIX
C AND OF THE CURRENT ROTATION MATRIX (SATROT).
      COMMON /ROTA/SR11A(NSAT),SR12A(NSAT),SR13A(NSAT),SR22A(NSAT),
     *COSAZA(NSAT),SINAZA(NSAT) 
C ADDED 2003-10-05 FOR TRANSFER TO PRED WHEN LOBSST=F.
C
      COMMON /BIPAR/OLDB(4),CNR,GMP,AX,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT
C
      COMMON /COBS/CLATD,RDI,SLAT,SLON,IDLAT,IDLON,MLAT,MLON,NOX,LFORM
C
      COMMON /CDEFCA/VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,
     *SGRE(10),
     *ROTFIL,ERNAME,DNAME(2),FMT(9),NSTEP,NSTEPE,IDSAT,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,
     *IPAMAX,NGR,NGRE(10),ICSYS,
     *LMEAN,LSA,LADMU,LSTAT,LAREA,LZETA,LGRADI,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LTILT,LINERT
C TRANSFERS VARIABLES FROM DEFDAT.
C
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
C
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
C IN OUTC ARE STORED SUBSCRIPTS OF VARIABLES TO BE OUTPUT AND LIMITS
C FOR DO-LOOPS IN OUTPUT. NOTE THAT OUTC OCCURS IN SUBROUTINES
C HEAD, COUT, CXPARM AND THE BLOCK DATA MODULE.
C
C *************** INPUT (10) *********************************
C
C INPUT OF COORDINATES OF OBSERVATION OR PREDICTION POINTS AND CONTIN-
C GENTLY THE OBSERVED QUANTITIES AND THEIR STANDARD DEVIATIONS.
C THIS IS FOLLOWED BY INPUT OF PARAMETER IDENTIFICATION CODES IF
C LPARM IS TRUE AND LEQP IS FALSE, AND THE OBSERVATIONS ARE NOT
C SATELLITE ALTIMETRY OR CROSS-OVER DIFFERENCES (IKP = 11 OR 9).
C
       DEGRAD=PI/180.0D0 
       LNOUSE=LF
       IJ = IANG*2+INO-1
C      IF (LGIGRS) IJ=8+IANG
C CHANGE 2003-03-05 AND 2004-02-06.
       IF (IANG.GT.4) IJ=13     
C THIS PREPARES FOR X,Y,Z INPUT.
       IF (LUSNGS) IJ=14
CCCCCC MAYBE  NOT CORRECT TO  RETURN TO HERE !
C
       IF (INO.EQ.0) NO=NO+1
       IF (LFOR77.AND.(.NOT.LFORM).AND.IANG.LE.4) THEN
        IF (LINTER.AND.(.NOT.LIN4))WRITE(6,*)' INPUT DATA RECORD, LSTOP'
        GO TO (2331,2332,2333,2333,2333),IANG
 2331    IF (LIN4)
     *   READ(INZ,*,END=2039)NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,
     *   (OBI(I),I=1,K1)
         IF (.NOT.LIN4) READ(5,*)NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,
     *   (OBI(I),I=1,K1),LSTOP
        GO TO 2030
 2332    IF (LIN4)
     *   READ(INZ,*,END=2039)NO,IDLAT,SLAT,IDLON,SLON,(OBI(I),I=1,K1)
         IF (.NOT.LIN4)READ(5,*)NO,IDLAT,SLAT,IDLON,SLON,
     *   (OBI(I),I=1,K1),LSTOP
        GO TO 2030
C INPUT IN DECIMAL DEGREES, GRADES.
 2333    IF (LIN4) THEN 
          READ(INZ,*,END=2039)NO,SLAT,SLON,(OBI(I),I=1,K1)
         ELSE   
          READ(5,*)NO,SLAT,SLON,(OBI(I),I=1,K1),LSTOP
         END IF 
        GO TO 2030
 2039    NO=-1
 2030   CONTINUE
       ELSE
C
C IFORMAT WILL INPUT DATA IN VARIOUS FORMATS. (1991.08.30).
        IF ((.NOT.LOUTC.AND.LNEQ).AND.NWAR.LT.5) THEN
         WRITE(*,*)' WARNING  LOUTC ',LOUTC
         NWAR=NWAR+1
        END IF
        CALL IFORMAT(NO,IJ,IANG,IKP,IKPREF,INZ,OBI,FMT,LMEGR,
     *  LSTOP,LOUTC)
C
       END IF   
C
       IF (LNUOUT.AND.INO.GT.0.AND.NO.LT.0) THEN
C THIS IS TO ASSURE THAT STATION NUMBERS ARE OUTPUT IF END OF FILE
C IS MET IN THE INPUT (LABEL 2039).
        NO2=NO1-1
        NO2=MOD(NO2,6)+1
        WRITE(6,278)(INUMR(I),I=1,NO2)
  278   FORMAT(' ',6I11)
       END IF
C
       IF(ILA .GE. ILO)THEN       
C CORRECTING INVERTED ORDER OF LAT. AND LONG.
        I = IDLAT
        IDLAT = IDLON
        IDLON = I
        I = MLAT
        MLAT = MLON
        MLON = I
        A0 = SLAT
        SLAT = SLON
        SLON = A0
       END IF
      IF (NO.LT.0) RETURN
C
      CALL RAD(IDLAT,MLAT,SLAT,RLATP,IANG)
C CONVERSION TO EAST LONGITUDE.
      IF (LWLONG.AND.IANG.LE.2) IDLON = -IDLON
      IF (LWLONG.AND.IANG.GT.2) SLON = -SLON
      CALL RAD(IDLON,MLON,SLON,RLONGP,IANG)
C
      IF (LSATP.AND.(.NOT.(LSATP.AND.LGRID.AND.NO.GT.1))) THEN
C ATTITUDE ANGLES FOR LGRID=TRUE ARE DEFINED EARLIER.
C CHECK THIS !!!!!
       IF (ISATP.EQ.3) THEN
        AZP=90.0D0
        BETP=D0
        TAUP=D0
        IF (LFULLO.AND.(.NOT.LZETA)) WRITE(*,9282)AZP,BETP,TAUP
       ELSE 
        IF (ISATP.EQ.2) THEN
C 
C ------------------ INPUT (10AA) --------------------------
C 
C INPUT OF TILT, ROLL AND PITCH ANGLES IN DEC. DEGREES. 
C AZP IS TRACK AZIMUTH FROM DUE NORTH COUNTED EAST (CONVENTION), RELATIVE
C TO ROTATING SOLID EARTH; BETP IS PITCH ANGLE POSITIVE 
C FOR CLIMBING SATELLITE, TAUP IS POSITIVE FOR RIGHT ROLL.
         IF (LINTER.AND.(.NOT.LIN4))
     *   WRITE(6,*)' INPUT TILT,PITCH,ROLL (DEG.)' 
         READ(INZ,*,END=2040) AZP,BETP,TAUP
  282    FORMAT(3D17.9) 
         IF (LFULLO.AND.(.NOT.LZETA)) WRITE(*,9282)AZP,BETP,TAUP
 9282    FORMAT(' ATTITUDE ANGLES (DEG.) ',3F11.5,/,3F11.5) 
        END IF 
       END IF
       IF (ISATP.LT.4) THEN
C AT THIS POINT THE ROTATION MATRIX SATROT(3,3) 
C MUST BE ESTABLISHED.       
        SAZP = SIN(AZP*DEGRAD)
        CAZP = COS(AZP*DEGRAD)
        SINB = SIN(BETP*DEGRAD)
        COSB = COS(BETP*DEGRAD)
        SINT = SIN(TAUP*DEGRAD)
        COST = COS(TAUP*DEGRAD) 
C WE TREAT SATROT AS A MATHEMATICAL MATRIX. I.E. FIRST INDEX
C IS ROW NUMBER, SECOND INDEX IS COLUMN NUMBER.
C COR 2002-09-27
        SATROT(1,1) =  SAZP*COSB
        SATROT(1,2) =  CAZP*COST+SINT*SINB*SAZP 
        SATROT(1,3) = -CAZP*SINT+COST*SAZP*SINB
        SATROT(2,1) = -CAZP*COSB
        SATROT(2,2) =  SAZP*COST-SINT*SINB*CAZP 
        SATROT(2,3) = -SAZP*SINT-COST*SINB*CAZP
        SATROT(3,1) = -SINB
        SATROT(3,2) =  SINT*COSB                
        SATROT(3,3) =  COSB*COST
C CHECK OF CONSISTENCY.
        AZCH=ATAN2(SATROT(1,1),-SATROT(2,1))
        BETCH=ATAN2(-SATROT(3,1),SATROT(1,1)/SIN(AZCH))/DEGRAD
        TAUCH=ATAN2(SATROT(3,2),SATROT(3,3))/DEGRAD
        AZCH=AZCH/DEGRAD
        IF (LFULLO) WRITE(*,9282)AZCH,AZP,BETP,BETCH,TAUP,TAUCH
       ELSE   
C CHANGE 2004-08-31 AND 2004-10-20.
        IF (ISATP.EQ.4) THEN
         READ(13,*)TRTIME,((SATROT(J,I),I=1,3),J=1,3) 
         IF (ABS(NO-TRTIME).GT.2) THEN
          WRITE(*,*)' INCONSISTENCY TRAROT ',NO,TRTIME
          STOP
         END IF
        ELSE
         WRITE(*,*)' NOT FULLY IMPLEMENTED *** WARNING *** '
         READ(13,*)QUAT
C THE SUBROUTINE CONVERTS QUARTERNIONS TO A ROTATION MATRIX.
C ADDED 2005-02-10.
         CALL QUATMAT(QUAT)
C QUATMAT RETURNS THE EULER MATRIX ELEMENTS IN THE COMMON BLOCK
C 'ROT', IN THE MATRIX SATROT.
        END IF
        AZCH=ATAN2(SATROT(1,1),-SATROT(2,1))
        BETCH=ATAN2(-SATROT(3,1),SATROT(1,1)/SIN(AZCH))/DEGRAD
        TAUCH=ATAN2(SATROT(3,2),SATROT(3,3))/DEGRAD
        AZCH=AZCH/DEGRAD
        IF (LTEST.AND.LF) WRITE(*,*)' EULER ANG: ',AZCH,BETCH,TAUCH
C ADDED 2005-03-09 IN ORDER TO BE USED IN COLLOCATION.
        SAZP = SIN(AZCH*DEGRAD)
        CAZP = COS(AZCH*DEGRAD)
        SINB = SIN(BETCH*DEGRAD)
        COSB = COS(BETCH*DEGRAD)
        SINT = SIN(TAUCH*DEGRAD)
        COST = COS(TAUCH*DEGRAD) 
       END IF
       IF (LFULLO.AND.(.NOT.LZETA)) WRITE(*,8282)SATROT
 8282  FORMAT(' SATROT ',3D16.9,/,'        ',3D16.9,/,
     * '        ',3D16.9) 
C IF BETP OR TAUP ARE LARGER THAN 1 DEG., THEN FULL ROTATION IS NEEDED. 
       IF ((ABS(BETP).GT.D1.OR.ABS(TAUP).GT.D1).AND.ISATP.EQ.1)
     * WRITE(*,*)' *** WARNING *** 3-D ROTATION NEEDED' 
      END IF
C
      IF (LMEAN1) THEN 
C MODIFIED 2002.10.08
       IF (LINTER.AND.(.NOT.LIN4)) THEN
        WRITE(6,*)' INPUT AZIMUTH IN DEGREES ' 
        IF (LLCOER.AND.ITMODE.EQ.1)
     *   WRITE(*,*)' FOLLOWED BY TRACK NUMBER '
       END IF
       IF (LLCOER.AND.ITMODE.EQ.1) THEN
        READ(INZ,*,END=2040) AZP, ITRACK
       ELSE
        READ(INZ,*,END=2040) AZP
        ITRACK = 0
       END IF
C CHANGE 1997-07-15: ITRACK(NO1+1) < 0 IS USED TO INDICATE ERROR-CORRELATION
C WITH DATA HAVING THE SAME ITIME-VALUE.
C THE USE OF NO1 IS INCORRECT.***********************************
       IF (LCOERR) ITRACE(NO1+1)=-ITRACK
       DEGRAD=PI/180.0D0 
       SAZP = SIN(AZP*DEGRAD)
       CAZP = COS(AZP*DEGRAD)
       COSSTE=CAZP
       SINSTE=SAZP
      END IF
C
C     IF (LINSOL)
C    *CALL INSOL(NFILE,NBLO,NBLP,SNAME,BOUNDS,LOUTS,LERNO)
C     IF (LINSOL.AND.LOUTS) GO TO 2324
      IF (LAREA.AND.(RLATP.GT.RLAMAX.OR.RLATP.LT.RLAMIN)
     *.AND.(.NOT.LGRID)) THEN
       LNOUSE=LT
       RETURN
      END IF
      IF (LAREA) THEN
       IF (RLOMIN.GT.D0.AND.RLOMAX.GT.D0.AND.RLONGP.LT.D0)
     * RLONGP=RLONGP+D2*PI  
       IF (RLOMIN.LE.D0.AND.RLOMAX.LE.D0.AND.RLONGP.GT.D0)
     * RLONGP=RLONGP-D2*PI   
       IF (RLOMIN.LE.D0.AND.RLOMAX.GE.D0.AND.RLONGP.GT.180.0D0)
     * RLONGP=RLONGP-D2*PI   
       IF (RLOMIN.GT.RLONGP.OR.RLOMAX.LT.RLONGP) THEN
        LNOUSE=LT
        RETURN
       END IF
      END IF
      IF (LLCOER) THEN
       IF (ITMODE.EQ.1)THEN
        IF (LINTER.AND.(.NOT.LIN4)) WRITE(*,*)
     *  ' INPUT TRACK NUMBER '
         READ(*,*)ITRACK
       ELSE
        IF (ITMODE.EQ.2) THEN
         ITRACK=(NO-ITM0)/ITMOD+1
         IF (ITRACK.NE.ITRAC0) THEN
          WRITE(*,*)' NEW TRACK ',ITRACK
          ITRAC0=ITRACK
         END IF
        ELSE
C CHANGE 2003-03-20.
         IF (ABS(NO+IKP*1000000-ITOLD).GT.ITRGAP) THEN
          ITRACK=NO+IKP*1000000
          WRITE(*,*)' NEW TRACK ',ITRACK
          ITOLD=NO+IKP*1000000
c         IF ((.NOT.LPRED).AND.
c    *    LAREA.AND.(RLATP.LT.RLAMAX.AND.RLATP.GT.RLAMIN.AND.
c    *    RLONGP.LT.RLOMAX.AND.RLONGP.GT.RLOMIN))
c    *    WRITE(*,*)' NEW TRACK ',ITRACK
         END IF
        END IF
       END IF
c      ITOLD=NO+IKP*1000000
C VARIABLE NAME  ITIME CHANGED TO ITRACE 2005-03-12 IN ORDER TO
C AVOID INFERFACE PROBLEM WITH PARAMETER ESTIATION.
c      ITRACE(NO1+1)=-ITRACK
      END IF
c
C THIS IS WRONG ==========================
c     IF (LAREA.AND.(RLATP.GT.RLAMAX.OR.RLATP.LT.RLAMIN)
c    *.AND.(.NOT.LGRID)) THEN
c      LNOUSE=LT
c      RETURN
c     END IF
c     IF (LAREA) THEN
c      IF (RLOMIN.GT.D0.AND.RLOMAX.GT.D0.AND.RLONGP.LT.D0)
c    * RLONGP=RLONGP+D2*PI  
c      IF (RLOMIN.LE.D0.AND.RLOMAX.LE.D0.AND.RLONGP.GT.D0)
c    * RLONGP=RLONGP-D2*PI   
c      IF (RLOMIN.LE.D0.AND.RLOMAX.GE.D0.AND.RLONGP.GT.180.0D0)
c    * RLONGP=RLONGP-D2*PI   
c      IF (RLOMIN.GT.RLONGP.OR.RLOMAX.LT.RLONGP) THEN
c       LNOUSE=LT
c       RETURN
c      END IF
c     END IF
C
C NO1 COUNTS POINTS (WITH ONE OR TWO OBSERVATIONS).
      NO1 = NO1  + 1
      RETURN
 2040 NO=-1
      RETURN
      END
C
      SUBROUTINE INPAR(IKP,NO,ITRACK,IC,N,NOX,NPOBS,NPAOLD,LNOUSE,
     *LINTER,LIN4,LPRED,LDPR,LWRSOL,LTEST,LONEQ,OBI,IOBS1,NPOINT)
C
C --------------- INPUT (10A) --------------------------------

C INPUT OF PARAMETER TYPES, IF PARAMETERS ARE GIVEN INDIVIDUALLY
C FOR EACH OBSERVATION. FOR DATA RELATED TO SATELLITE-ALTIMETRY
C WE USE THE REVOLUTION NUMBER(S) WHICH IS IMPLICITLY GIVEN BY THE
C OBSERVATION NUMBER, (CODES IKP=9 FOR CROSS-OVER DIFFERENCES AND
C IKP=11 FOR SEA-SURFACE HEIGHTS TREATED LIKE GEOID UNDULATIONS.)
C LAST CHANGE 2005-03-02.
      IMPLICIT NONE
C
      LOGICAL LMEAN,LSA,LADMU,LSTAT,LAREA,LZETA,LGRADI,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LNOUSE,
     *LT,LF,LIN4,LPRED,LDPR,LWRSOL,LTEST,LONEQ,LINTER,LTILT,LINERT
C
      INTEGER IKP,NSTEP,NSTEPE,NO,NPAOLD,ITRACK,IC,N,
     *NOX,NPNO,I,KK,NPOBS,ICODE,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,
     *IPAMAX,NGR,NGRE,ITROLD,
     *ICSYS,IPTYPE,IPACAT,NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS,
     *ITIME,ITIME0,ITCOUN,NIPT,NIPCAT,IOBS1,IDSAT,NPOINT
C
      PARAMETER (NIPT=1500,NIPCAT=100002)
C
      CHARACTER *128 ROTFIL,ERNAME,DNAME,FMT
C
      REAL*8 VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,
     *SGRE,D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,OBI(10),SFACT
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON /CDEFCA/VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,
     *SGRE(10),
     *ROTFIL,ERNAME,DNAME(2),FMT(9),NSTEP,NSTEPE,IDSAT,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,
     *IPAMAX,NGR,NGRE(10),ICSYS,
     *LMEAN,LSA,LADMU,LSTAT,LAREA,LZETA,LGRADI,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LTILT,LINERT
C
C TRANSFERS VARIABLES FROM DEFDAT.
C
      IF (IKP.EQ.9 .OR. IKP.EQ.11.OR. IKP.EQ.13.OR.
     *LGRADI) THEN
       IF (IKP.EQ.11.OR.LGRADI) THEN
        IF (PPA.GT.0.1D-10) THEN
         ITRACK=(NO-PPS)/PPA+IKP*100000  
C CHANGE 2002-02-04 AND 2003-03-05.
        ELSE
         ITRACK=NO/10000+IKP*100000  
        END IF
       END IF
C BIAS DET. FOR GRAVITY, ADDED 1997-07-17 BY CCT.
c      IF (IKP.EQ.13.AND.(.NOT.LLCOER)) THEN
       IF (IKP.EQ.13) THEN
        IF (LINTER.AND.(.NOT.LIN4)) WRITE(*,*)
     *  ' INPUT TRACK NO '
c       READ(INZ,*)ITRACK
C CHANGE 2005-09-23.
        ITRACK=IKP*100000+NO/10000000
       END IF
C CHANGE 2002-10-09 AND 2003-03-05.
       IF ((IKP.EQ.13.OR.IKP.EQ.15.).AND.PPA.GE.0.0001)
     * ITRACK=ITRACK+10
       IF (IKP.NE.9) THEN
        IF (ITRACK.EQ.ITROLD) THEN
C CHANGE 2004-07-02.
         IF (.NOT.LPRED) IPA=IPA-MP
        ELSE
         IF (ITROLD.GT.0) THEN
          IPACAT(ILAST) = IC
          IPACAT(ILAST+1)=ABS(MP)
          ILAST=IPA+1
          IPA=IPA+2
         END IF
         ITROLD=ITRACK
         IF (LTILT) THEN
          ITIME0(NPARM+1)=NO
          IF (LF) WRITE(*,*)' ITIME0 ',ITIME0(NPARM+1),NPARM+1
         END IF
        END IF
C
        DO I=1,MP
         IF (ICODE(I).EQ.1) THEN
          IPACAT(IPA+I)=ITRACK
         ELSE
          IF (ICODE(I).EQ.2) THEN
           IF (N.GE.NIPCAT) THEN
            WRITE(*,*)' DIMENSION OF ARRAY ITIME EXCEEDED: STOP '
            STOP
           END IF
C ITIME HOLDS THE 'TIME' DIFFERENCE WITH ITIME0 AS THE ZERO POINT. THIS
C IS USED FOR TILT-DETERMINATION.
           ITIME(N+1)=NO-ITIME0(NPARM+1)  
           IPACAT(IPA+I)=-ITRACK 
          ELSE
           IF (ICODE(I).EQ.3) THEN
            IPACAT(IPA+I)= (NO-PPS)/PPA+IKP*100  
c still to be changed
            SFACT(N+1)=OBI(IOBS1)
           END IF
          END IF
         END IF
        END DO
C
       END IF
       IF (LF) WRITE(*,*)' IPA ',IPA,MP,ITRACK,ITROLD,NPARM
       NPOBS=NPOBS+1 
C
       IF (IKP.EQ.9) THEN
C DIFFERENCES WHEN LDPR=TRUE.
        IF (LDPR) THEN
C WE ADD 1100000, IN ORDER TO AVOID CONFLICT WITH RESERVED PARAMETER
C IDENTIFICATION CODES.
         IPACAT(IPA+1)=NOX+1100000
         IPACAT(IPA+2)=NO+1100000
        ELSE
         IPACAT(IPA+1)=NO/100000+1100000
         IPACAT(IPA+2)=NO-(IPACAT(IPA+1)-10)*100000
     *   +1100000
        END IF
        CALL PARCAT(LT,NPNO)
C THE CALL PARAMETER IN PARCAT IS TRUE, BECAUSE WE DO NOT ACCEPT NEW
C PARAMETERS DEFINED ONLY FROM CROSS-OVER DIFFERENCES. CONSEQUENTLY
C CROSS-OVER DIFFERENCES MUST BE INPUT AFTER POINT OBSERVATIONS, IF
C LALLP IS TRUE.
        IF (IPACAT(IPA+1).EQ.0) IPACAT(IPA+2)=0
        IF (IPACAT(IPA+2).EQ.0) IPACAT(IPA+1)=0
        IF (IPACAT(IPA+1).NE.0) RETURN  
C NOUSE COUNTS CROSS-OVER DIFFERENCES NOT USED.
        NOUSE=NOUSE+1
        LNOUSE=LT
        RETURN    
c      ELSE
c       CALL PARCAT(LALLP,NPNO)
c       IF (NPAOLD.NE.NPARM.AND.LTEST.AND.IPA.GT.3)
c    *  WRITE(6,276)NPARM,IPA,(IPACAT(KK),KK=(IPA-3),IPA+4),
c    *  IPTYPE(NPARM) 
c       NPAOLD=NPARM 
c       ITIME0(NPARM+1)=NO 
c       NPOBS=0 
c       NPOBS0=NPOBS0+1
c       RETURN
       END IF
      ELSE
       IF (LINTER) WRITE(6,*)' INPUT PARAMETER CODES'
       READ(INZ,*)(IPACAT(IPA+1),I=1,MP)
       IF (LWRSOL) WRITE(17,150)(IPACAT(IPA+I),I=1,MP)
  150  FORMAT(12I6)
       IF (MP.LT.4) WRITE(6,170)MP,(IPACAT(I+IPA),I=1,MP)
       IF (MP.GT.3) WRITE(6,171)MP,(IPACAT(I+IPA),I=1,MP)
  170  FORMAT(/' OBSERVATIONS CONTRIBUTE TO/DEPEND ON ',I3,
     * ' PARAMETERS',3I6)
  171  FORMAT(/' OBSERVATIONS CONTRIBUTE TO/DEPEND ON ',I3,
     * ' PARAMETERS',3I6,(/,12I6))
      END IF
C
      CALL PARCAT(LALLP,NPNO) 
c this must be changed 2004-12-29.
      IF (LPRED.AND.MP.EQ.2) THEN
       ITIME(N+1)=NO-ITIME0(NPNO+1)
       IF (LF.AND.LONEQ)WRITE(6,9611)NO
     * ,ITIME0(NPNO+1),NPNO
 9611  FORMAT(' NO,ITIME,NPNO',3I10) 
      END IF
      IF (.NOT.(NPARM.EQ.NPAOLD.OR.(.NOT.(LGRADI.OR.IKP.EQ.11))
     *.OR.MP.GT.2.OR.LPRED)) THEN
C CHANGE N -> NPOINT 2005-03-02.
       IF (NPOINT.NE.0.AND.MP.EQ.1.AND.NPOBS.EQ.1) WRITE(6,244)
     * NPARM,NO  
C NPOINT COUNTS NUMBER OF OBSERVATIONS CONTRIBUTING TO PARAMETERS.
       NPOINT=NPOINT+1
       NPAOLD=NPARM 
       IF (LF) WRITE(*,*)' MP,IPA= ',MP,IPA
C
       IF (MP.NE.1) THEN
        ITIME0(NPARM+1)=NO        
        ITIME(N+1)=0 
        IF (N.NE.0.AND.NPOBS.EQ.MP) WRITE(6,244)NPARM,ITIME0(NPARM-1)
  244   FORMAT(' PARAMETER NO',I5,', LAST OBSNO ',I10, ' NOT WELL',
     *  ' DETERMINED. ******') 
C ERROR IF MORE THAN ONE DATASET, DETECTED 1995.10.28 BY CCT.
C        IF (N.EQ.0.OR.NPOBS.GE.MP) GO TO 2045 
        IF (NPOBS0.NE.0.AND.NPOBS.LT.MP) THEN
         WRITE(6,245)NPARM,ITIME0(NPARM-1) 
  245    FORMAT(' TOO FEW OBSERVATIONS FOR PARAMETER NO ',I4,
     *   ', OBSNO=',I9) 
         IPACAT(IPA+3)=IPACAT(IPA+1)
         IPACAT(IPA+4)=IPACAT(IPA+2) 
         IPACAT(IPA-1)=N+1 
         IPACAT(IPA)=0 
         IPACAT(ILAST)=N
         IPACAT(IPA+2)=IPACAT(ILAST+1)  
         ILAST=IPA+1
         IPA=IPA+2 
         NPARM=NPARM-4 
         CALL PARCAT(LALLP,NPNO)
         IF (NPAOLD.NE.NPARM.AND.LTEST.AND.IPA.GT.3)
     *   WRITE(6,276)NPARM,IPA,(IPACAT(KK),KK=(IPA-3),IPA+4),
     *   IPTYPE(NPARM) 
C CHANGE 2003-03-18, AND 2004-06-21.
C    *    (IPTYPE(KK),KK=(NPARM-4),NPARM) 
  276    FORMAT(8I9) 
         NPAOLD=NPARM 
         ITIME0(NPARM+1)=NO 
        END IF
        NPOBS=0 
        NPOBS0=NPOBS0+1
       END IF
      END IF
      RETURN
      END
C
      SUBROUTINE TRAPOT(LNPOT,LREPEC,LSPHER,LADDBP,LFULLO,
     *POT00,RB,REF,REF0,UREF0,OBI,H,HPP,RRE,SU,SU8,VREF)
C THE SUBROUTINE CALCULATES EFFECT OF DATUM-SHIFT AND THE
C CONTRIBUTION FROM A SHE. MOVED FROM MAIN PROGRAM 2004-11-27.
C REVISED 2005-12-06.
      IMPLICIT NONE
C
      LOGICAL LRESOL,LNEWD,LREPEC,LP,LNPOT,LSPHER
      LOGICAL LPUNCH,LTERMA,LTERMO,LSTNO,LMEAN,LSA,LADMU,LSTAT,
     *LAREA,LZETA,LGRADI,LFORM,LGRID,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LPOT,LKM,LTERRC,LPOTIN,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT,LIN4,LT,LF,
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,LTEST,
     *LDENOL,LMDD,LOPCOF,LCLU7,LOPEN4,LOPEN7,LFULLO,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART,LCTIME,LCOERR,LLCOER,
     *LSMAL,LADBPR,LADBTE,LNGR,LOCAL,LSUM
     *,LKSIP,LNCOL,LTNB,LTEB,LOE1,LOE2,LE,LADDBP,LTILT,LINERT
C
      INTEGER INUMR,NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,NSTEP,NSTEPE,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,I,NO,NNSU,ITRACK,
     *IPAMAX,NGR,NGRE,ITMODE,ITM0,ITMOD,ITRGAP,ITOLD,ITROLD,ICODE,
     *ICSYS,IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,IKP,
     *IDLAT,IDLON,MLAT,MLON,NOX,II,IOBS,IOBSR,N1,NIR,NMAX,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,MAXO,
     *NSAT,ITCOUN,IPTYPE,IPACAT,NPARM,NPARM1,J,
     *MAXPAR,MP,IPA,NCXLAS,NIPT,NIPCAT,ICZERO,NCZERO,
     *NI,NR,INDEX,ISAT,ISATP,NOBLK,NFILTE,ITIME,ITIME0,KP,KPP1,IPC,
     *ICSYSL,NAI,NLA,INL,IEM,INZOLD,IKA,MODEC0,IORDER,NROOT,
     *MB,MA,KCI,NC1,NC2,IDSAT,ITRACE,NERCOV
C
      PARAMETER (MAXO=16200,NSAT=16200,
C    *NIPT=1500,NIPCAT=100002,NROOT=4402,NNSU=18010)
     *NIPT=1500,NIPCAT=100002,NROOT=4402,NNSU=22010)

      REAL*8 VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,POT00,
     *SGRE,SLAT,SLON,OLDB,CNR,GMP,AX,OBI(22),
     *SR11,SR12,SR13,SR22,COSAZ,SINAZ,SATROT, 
     *SR11A,SR12A,SR13A,SR22A,COSAZA,SINAZA, 
     *D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,
     *GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,SFACT,
     *STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *B,HQ,RLAT,SINLAT,COSLAT,RLONG,SINLON,COSLON,WOBS,
     *SINLOP,COSLOP,BSIZE,BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,
     *CAZP,SAZP,HP,RLATP,PRETAP,PREDP,HCZERO,
     *COST2P,SINT2P,FILTER,GREFI,  
     *SHIFTS,PW2,BSIZEA,E21,AX1,F1,GM1,GREF,SM,UREF,
     *X,Y,Z,XY,XY2,DISTO,DIST2,OBS,H,SINLA0,COSLA0,RLONG0,
     *DX,DY,DZ,EPS3,EPS2,EPS1,DL,AX2,E22,EE0,DSHIF0,REF,REF1,REF2,
     *REF3,FG,FJ,OMEGA2,RGRAV,DZERO,ROOT,
     *C20IN,G1,G2,CM3,CMM2,CM1,RG(3,3),CU,SU8,POT,GPOTDR,
     *REF0,CY,SY,TANLAP,TAGLAP,UREF0,DUDY,DUDX,SINLO,COSLO,RLATS,
     *RLONGS,RJ,DGM,COSLA,SINLA,REFI,COSLO1,COSLA1,RB,
     *REFM,RLATP1,VREF(3),SU1,RRE,G2R(3,3),GLAP,GP,DGI,CLATD,RDI,
     *POTDIF,HPP,DLATP,CCI,CCR,SIGMA0,SIGMA,HCMAX,CCV,DC,CTIME
      REAL*16 SU
C
      CHARACTER*128 ROTFIL,ERNAME,DNAME,FMT,OLDN
C 
      COMMON /CMCOV/CCI(24),CCR(56),SIGMA0(2200),SIGMA(2200),HCMAX,
     *CCV(2,2),DC(36),KCI(37),NC1,NC2,LOCAL,LSUM
C
      COMMON/SQROOT/DZERO,ROOT(NROOT)
C SQUARE-ROOT TABLE USED IN GPOTDR.
      COMMON /GPOTC0/C20IN,G1(3),G2(3,3),CM3,CMM2,CM1
C C20IN HOLDS C20, G1 THE FIRST DERIVATIVES, G2 THE SECOND DERIVATIVES.
C 
C     COMMON/GPOTC1/OLDT,OLDR,CFA,IGP(12),LFIRST,HP9000

C COMMON VARIABLES USED IN GPOTDR, SETCM ,LOADCM, PRED AND CXPARM.
      COMMON /GRAVCC/FG(30),FJ(30),LP(2),OMEGA2,IORDER
C
      COMMON /ITRANC/SINLA0,COSLA0,RLONG0,
     *DX,DY,DZ,EPS3,EPS2,EPS1,DL,AX2,E22
C DATUM SHIFT PARAMETERS.
      COMMON /CCOSYS/EE0(3),DSHIF0(7),MODEC0
C
      COMMON/OBSER/OBS(22)
C
      COMMON /CINHEA/SHIFTS,PW2,BSIZEA,E21,AX1,F1,GM1,GREF,SM(2200),
     *UREF,KP,KPP1,IPC,
     *LSMAL,LADBPR,LADBTE,LNGR
     *,LKSIP,LNCOL,LTNB,LTEB,LOE1,LOE2,LE
C TRANSFER VARIABLES FROM INHEAD.
C
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON/CCTIME/CTIME(NIPCAT),ITRACE(NIPCAT),ITMODE,ITM0,ITMOD,
     *ITRGAP,ITRACK,ITOLD,NERCOV,LCTIME,LCOERR,LLCOER
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE  
C
      COMMON /CON1/OLDN(4)/CON2/GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,
     *ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
C THESE VARIABLES HAVE BEEN PLACED IN COMMON, SO THAT THEY MAY BE
C INITIALIZED BY THE BLOCK DATA MODULE.
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C COMMON CONSTANTS D0=0.0D0  ETC.
C
      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),SATROT(3,3) 
C THE COMMON BLOCKS CONTAINS THE ELEMENTS OF THE ROTATION MATRIX
C AND OF THE CURRENT ROTATION MATRIX (SATROT).
      COMMON /ROTA/SR11A(NSAT),SR12A(NSAT),SR13A(NSAT),SR22A(NSAT),
     *COSAZA(NSAT),SINAZA(NSAT) 
C ADDED 2003-10-05 FOR TRANSFER TO PRED WHEN LOBSST=F.
C
      COMMON /BIPAR/OLDB(4),CNR,GMP,AX,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT
C
      COMMON /COBS/CLATD,RDI,SLAT,SLON,IDLAT,IDLON,MLAT,MLON,NOX,LFORM
C
      COMMON /CDEFCA/VARNO,PPA,PPS,VG,HPK,DM,DA,WM,REJLEV,
     *SGRE(10),
     *ROTFIL,ERNAME,DNAME(2),FMT(9),NSTEP,NSTEPE,IDSAT,
     *ILA,ILO,IKPREF,INZ,IO2,NPOBS0,NOUSE,ILAST,
     *IPAMAX,NGR,NGRE(10),ICSYS,
     *LMEAN,LSA,LADMU,LSTAT,LAREA,LZETA,LGRADI,
     *LMENSI,LSIMH,LMEAN1,LINTRA,LGIGRS,LMEGR,LUSNGS,
     *LSATAC,LSATP,LGRERR,LCOD,LEQP,LALLP,LGRP,LDEN,LPOTSD,
     *LEQANG,LFILTE,LBIN,LSKIPL,LGRERS,LTILT,LINERT
C TRANSFERS VARIABLES FROM DEFDAT.
C
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
      COMMON/DAT/LNEWD,LRESOL,LGRID
C /DAT/ TRANSFERS LOGICAL VARIABLES TO THE SUBROUTINE ITRAN.
      COMMON /EUCL/X,Y,Z,XY,XY2,DISTO,DIST2
      DIMENSION SU(NNSU),SU8(NNSU)
C     EQUIVALENCE (VREF(1),REF1),(VREF(2),REF2),(VREF(3),REF3)
C
      REF1=VREF(1)
      REF2=VREF(2)
      REF3=VREF(2)
      IF (.NOT.LRESOL) THEN       
C LNEWD IS TRUE IF A NEW COORD.SYST. IS USED.
       IF (.NOT.LNEWD) THEN       
        CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,D0,E21,AX1)
C
        IKA=IKP
        CALL TRANS(SINLAP,COSLAP,RLATP,SINLOP,COSLOP,RLONGP,H,IKA,IT)
        IF (LINTRA)OBS(IT)=-OBS(IT)
        IF (LINTRA.AND.LREPEC)OBS(IT1)=-OBS(IT1)
C
        IF (.NOT.LMENSI) THEN        
C WE ARE JUMPING FROM OUTSIDE A BLOCK TO INSIDE. WARNING.
C MUST BE CORRECTED.
         REF = D0
         IF (.NOT.(LNGR.AND.(IORDER.NE.2.OR.LNKSIP).AND.
     *   (.NOT.LMDD))) THEN       
C LMDD IS TRUE IF SECOND ORDER MEASURED DERIVATIVES.
          CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,H,E22,AX2)
          REF= RGRAV(15,IKP,REF1,REF2,REF3,SINLAP,H,RG,CU,SU1,LSATP)
C CHANGE 1990.10.19 BY CCT CALL OF AXV ADDED . 
          VREF(1)=REF1
          VREF(2)=REF2
          VREF(3)=REF3
          IF (LSATP.AND.(.NOT.LGRADI)) THEN
           IF (LZETA) THEN
            IF (LFULLO) WRITE(*,*)' REF ',REF
           ELSE
            IF (LFULLO) WRITE(*,1151)VREF
            CALL AXV(SATROT,VREF) 
            IF (LFULLO) WRITE(*,1151)VREF
 1151       FORMAT(' VREF ',3D15.6)
           END IF
          END IF 
          IF (LGRP) THEN
           OBS(IT) = (REF0-REF)*1.0D5
           IF (H.GE.1.0D4) THEN
C IF H.GE. 10 KM, THEN IT MAY BE MEANINGLESS TO CHANGE FROM ONE
C GRAVITY FORMULA TO ANOTHER. ADDED 2000-07-05 BY CCT.
            WRITE(*,*)' ** WARNING *** DATUM SHIFT MAY BE ERRONEOUS '
            WRITE(*,*)
     *      ' IKA,IT,REF0,REF,OBS(IT) ',IKA,IT,REF0,REF,OBS(IT)
           END IF
          END IF
          IF (IORDER.EQ.2) OBS(IT)=(REF0-REF)*1.0D9
          IF (LPOTSD.AND.LGRP) OBS(IT) = OBS(IT)-13.7E0
         END IF
        END IF
       END IF
C
       IF (.NOT.(LNPOT.OR.LCOD)) THEN      
        IF (.NOT.LPOTIN.OR.NO1.EQ.1) THEN        
         IF (.NOT.LMENSI) THEN        
C
          IF (IKP.EQ.2) THEN      
           CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,D0,E22,AX2)
           POT=GPOTDR(-NMAX,0,SU,SU8)
           H=H+(POT-UREF0)/REF
          END IF
C
          IF ((IKP .NE. 13 .OR. LNEWD).AND.(.NOT.LDEN))
     *    CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,H,E22,AX2)
          IF (LDEN) CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,HP,D0,RRE)
C CORRECTION 1987.10.10. EARLIER RGRAV WAS NOT CALLED WHEN
C ONLY ETA (IKP=17 OR 4) WAS EVALUATED.
          IF (LZETA.OR.LDEFVP.OR.IKP.EQ.14.OR.IKP.EQ.15) THEN
           REF=RGRAV(15,IKP,REF1,REF2,REF3,SINLAP,H,RG,CU,SU1,LSATP)
C CHANGE 2002-06-25.
           VREF(1)=REF1
           VREF(2)=REF2
           VREF(3)=REF3
           IF (LSATP.AND.(.NOT.LGRADI)) THEN
            IF (LZETA) THEN
             IF (LFULLO) WRITE(*,*)' REF ',REF
            ELSE
             IF (LFULLO) WRITE(*,1151)VREF
             CALL AXV(SATROT,VREF) 
             IF (LFULLO) WRITE(*,1151)VREF
            END IF
           END IF
          END IF
          POT= GPOTDR(-NMAX,IORDER,SU,SU8)
          IF (LSATP.AND.LPOT) THEN
           IF (LZETA) THEN
            IF (LFULLO) WRITE(*,*)POT
           ELSE
            IF (LFULLO) WRITE(*,153)G1
  153       FORMAT(' G1 ',3D16.5)
            CALL AXV(SATROT,G1) 
            IF (LFULLO) WRITE(*,153)G1
           END IF
          END IF
C
          IF (IORDER.EQ.2) THEN       
           GREF= SQRT(REF3**2+REF2**2)
           CY = -REF3/GREF
           SY = -REF2/GREF
           IF (LFULLO.AND.LNCOL) THEN
            WRITE(*,*)' DDU '
            WRITE(6,358)RG              
           END IF
           IF (LSATP.AND.LGRADI)THEN
            CALL ATBA(SATROT,RG,RG)
            GO TO (7615,7626,7626,7626,7626,
     *      7620,7621,7622,7623,7624,7625),(IKP-14)
 7615       REF=RG(3,3)
            GO TO 7626
 7620       REF=RG(3,2)
            GO TO 7626
 7621       REF=RG(1,3)
            GO TO 7626
 7622       REF=RG(2,2)
            GO TO 7626
 7623       REF=RG(2,1)*D2
            GO TO 7626
 7624       REF=RG(1,1)
            GO TO 7626
C DATA CODE=25, DIFFERENCE DDU/DXX-DDU/DYY.
 7625       REF=RG(1,1)-RG(2,2)
 7626       CONTINUE
            IF (LFULLO) WRITE(*,*)' REF ',REF
C CONVERSION TO EU.
c           REF=REF*1.0D9
c           IF (LMEGR) OBS(2)=OBS(2)-REF
            IF (LMEGR) OBS(2)=(OBS(2)-REF)*1.0d9
           END IF
           IF (LFULLO.AND.LNCOL.AND.LSATP.AND.(.NOT.LZETA))
     *     WRITE(6,358)RG              
  358      FORMAT(3E19.11) 
           IF (LSATP.AND.LGRADI.AND.LPOT) THEN
            DO I=1,3
             DO J=1,3
              G2R(I,J)=G2(I,J)
             END DO
            END DO
            IF (LFULLO.AND.LNCOL.AND.LSATP.AND.(.NOT.LZETA)) THEN
             WRITE(6,359)POT00,(G1(I),I=1,3),((G2(I,J),I=1,3),J=1,3),
     *       SQRT(G1(1)**2+G1(2)**2+G1(3)**2)
            END IF
            CALL ATBA(SATROT,G2R,G2) 
            IF (LFULLO.AND.LNCOL.AND.LSATP.AND.(.NOT.LZETA)) THEN
             WRITE(*,*)' ROTATED '
             WRITE(6,359)POT00,(G1(I),I=1,3),((G2(I,J),I=1,3),J=1,3),
     *       SQRT(G1(1)**2+G1(2)**2+G1(3)**2)
  359        FORMAT(' V=',E19.11,' DV, DDV',/4(3E19.11/),' G ',F10.7)
            END IF
           END IF
          ELSE 
           IF (ABS(REF2).LT.0.1D-16) THEN
            CY=D1
            SY=D0
           ELSE
            CY = - REF1/REF2
            SY = - REF/REF2
           END IF 
          END IF 
C
          I=IKP
          IF (LSATP) THEN
           CY=D1
           SY=D0 
          END IF 
C CHANGE 1996.05.08 BY CCT.
          IF (LDEFVP.AND.LMEGR.AND.(.NOT.LGRADI)) THEN
C GLAP IS GEOCENTRIC LATITUDE AT H=0. CY,SY ARE NOW
C COS AND SIN OF DIFFERENCE GEOCENTRIC AND GEODETIC LATITUDE: 
           TANLAP=SINLAP/COSLAP
           TAGLAP=(D1-E22)*TANLAP
           GLAP=ATAN(TAGLAP)
           CY=COS(GLAP-RLATP)
           SY=SIN(GLAP-RLATP)  
          END IF 
C WHEN A SATELLITE ORIENTED FRAME IS USED, THE SPHERICAL COORDINATE
C SYSTEM IS USED. OTHERWISE THE COORDINATE SYSTEM IS ORIENTED WITH
C RESPECT TO THE NORMAL GRAVITY VECTOR. 
          IF (IKP.GT.25.AND.IKP.LT.36)I=IKP-10
          GO TO (7006,7007,7008,7009,7008,7010,7010,7010,7010,
     *    7016,7006,7007,7007,7011,7011,7008,7009,7012,7013,
     *    7012,7013,7023,7014,7024,7015),I
 7006     IF (.NOT.LSATP) THEN
           OBS(IP) = (POT-REF)/REF2
C       HEIGHT ANOMALY, ZETA.
          ELSE
           OBS(IP) = POT-REF
C ANOMALOUS POTENTIAL IN M**2/S**2. (ADDED 2002-09-23).
          END IF
          G1(1)=POT
          GO TO 7010
C
 7007     GP =  SQRT(G1(1)**2+G1(2)**2+G1(3)**2)
          IF (.NOT.LSATP) OBS(IP) = (GP-REF)*1.0D5
          IF (LSATP) THEN
           OBS(IP) = (G1(3)-VREF(3))*1.0D5  
          ELSE
           OBS(IP) = (GP-REF)*1.0D5
          END IF
C     GRAVITY DISTURBANCE OR ANOMALY (IN ELLIPSOIDAL APPROXIMATION).
C     WHEN LSATP IS TRUE, WE USE THE GRAVITY DISTURBANCE IN THE
C     DIRECTION OF THE 3. AXIS.(1990.11.27).  
          IF (IKP.EQ.13) OBS(IP)=OBS(IP)-2*(POT-REF1)/DISTO*1.0D5
C     GRAVITY ANOMALY IN SPHERICAL APPROXIMATION.
          GO TO 7010
C
C CORRECTION JULY 1989 SUBSCRIPTS 1 AND 2 IN G1 AND G2 INTERCHANGED. 
C CORRECTION AUG. 92, UNITS FOR LSAT ARE MGAL.
 7008     IF (.NOT.LSATP)  THEN 
           OBS(IP) = ((REF-G1(2))*CY-(REF1-G1(3))*SY)*RADSEC/REF2
           DUDY=G1(2)*CY-G1(3)*SY 
          ELSE 
C PREPARATION FOR LSAT, REF2 IS NOT THE CORRECT QUANTITY. 1990.11.30.  
C     OBS(IP)= -(G1(2)-VREF(2))*1.0D5   ERROR 2000.03.31
           OBS(IP) = (G1(2)-VREF(2))*1.0D5
C     KSI, SEE REF(D), EQ. (72) AND (75).
          END IF 
          IF (IKP.EQ.3 .OR. IKP.EQ.16) GO TO 7010
 7009     IF (.NOT.LSATP) OBS(IP1) = -G1(1)*RADSEC/REF2 
          DUDX=G1(1) 
C         IF (LSATP) OBS(IP1) = -(G1(1)-VREF(1))*1.0D5  ERROR 2000-03-31  
          IF (LSATP) OBS(IP1) = (G1(1)-VREF(1))*1.0D5
C     ETA.
          GO TO 7010
C
C SECOND ORDER DERIVATIVES MUST BE TRANSFORMED, CF. REF(D), EQ.
C (73) - (75). CY AND SY ARE COS AND SIN OF THE ANGLE BETWEEN THE
C NORMAL GRAVITY VECTOR AND THE RADIUS-VECTOR.
 7011     IF (LSATP) THEN
           OBS(IP) = (G2(3,3)-RG(3,3))*1.0D9
          ELSE 
           OBS(IP) = (G2(3,3)*CY*CY+2*CY*SY*G2(2,3)-REF)*1.0D9
C     D2T/DZ2, VERTICAL GRAVITY GRADIENT.
           IF (IKP.EQ.4) OBS(IP) = OBS(IP)-D2*((POT-REF1)/DIST2
     *     -(G1(3)-REF3)/DISTO)*1.0D9
C     VERTICAL GRAVITY ANOMALY GRADIENT.
          END IF 
          GO TO 7010
C
 7012     IF (.NOT.LSATP) THEN
           OBS(IP)= (-(G2(2,3)*CY*CY+(G2(2,2)-G2(3,3))*CY*SY)-REF)*1.0D9
          ELSE
           OBS(IP)= (G2(2,3)-RG(2,3))*1.0D9
          END IF 
C     D2T/DXDZ, GRAVITY GRADIENT IN NORTHERN DIRECTION.
          IF (IKP.EQ.18 .OR. IKP.EQ.28) OBS(IP) = OBS(IP)
     *    +D3*(REF2-G1(2))*1.0D9/DISTO
C      GRAVITY ANOMALY GRADIENT IN NORTHERN DIRECTION.
          IF (IKP.EQ.18 .OR. IKP.EQ.20) GO TO 7010
C
 7013     IF (LSATP) THEN
           OBS(IP1) = (G2(1,3)-RG(1,3))*1.0D9
          ELSE 
           OBS(IP1) = -(G2(1,3)*CY+G2(1,2)*SY)*1.0D9
C     D2T/DYDZ, GRAVITY GRADIENT IN EASTERN DIRECTION.
           IF (IKP.EQ.19 .OR. IKP.EQ.28) OBS(IP1) = OBS(IP1)
     *     -D3*G1(1)*1.0D9/DISTO
C     GRAVITY ANOMALY GRADIENT IN EASTERN DIRECTION.
          END IF 
          GO TO 7010
C
 7023     IF (.NOT.LSATP) THEN 
           OBS(IP) = (G2(2,2)*CY*CY-D2*G2(2,3)*CY*SY+G2(3,3)*SY*SY
     *         -REF)*1.0D9 
          ELSE
           OBS(IP) = (G2(2,2)-RG(2,2))*1.0D9 
C     D2T/DXDX 
          END IF 
          GO TO 7010 
C
 7015     IF (LSATP) THEN
           OBS(IP) = (G2(1,1)-G2(2,2))*1.0D9-REF
          ELSE
           OBS(IP) = (G2(1,1)-G2(2,2)*CY*CY+2*G2(2,3)*CY*SY-REF)*1.0D9
C     D2T/DY2-D2T/DX2.
          END IF
          IF (IKP.EQ.25) GO TO 7010
C 
 7014     IF (LSATP) THEN
           OBS(IP1)= 2*(G2(1,2)-RG(1,2))*1.0D9
          ELSE 
           OBS(IP1)= 2*(G2(1,2)*CY-G2(1,3)*SY)*1.0D9
C     2*D2T/DXDY.
          END IF 
          GO TO 7010
C
 7024     IF (.NOT.LSATP) THEN
           OBS(IP) = (G2(1,1)-REF)*1.0D9 
          ELSE
           OBS(IP) = (G2(1,1)-RG(1,1))*1.0D9
          END IF 
C     D2T/DYDY. 
          GO TO 7010 
C
 7016     OBS(IP)=POT*RP**(-KCI(32))
C DENSITY CONTRAST.
 7010     CONTINUE   
         ELSE
C
C MEAN VALUE COMPUTATION.
 7062     COSLA=COSLAP
          SINLA=SINLAP
          RLATS=RLATP
          RLONGS=RLONGP 
          REFM=D0
          DGM=D0
          RJ = D0
          DO MA=1,NSTEP
C CORRECTION 1996.12.19 BY CCT.
           IF ((.NOT.LMEAN1).OR.MA.EQ.1) THEN
            COSLO=COSLOP
            SINLO=SINLOP
           END IF
           CALL EUCLID(COSLA,SINLA,COSLO,SINLO,H,E22,AX2)
           REFI=RGRAV(15,IKP,REF1,REF2,REF3,SINLA,H,RG,CU,SU1,
     *            LSATP)
           VREF(1)=REF1
           VREF(2)=REF2
           VREF(3)=REF3
           REFM=REFM+REFI
           DO MB=1,NSTEPE 
            IF (MB.GT.1)
     *      CALL EUCLID(COSLA,SINLA,COSLO,SINLO,H,E22,AX2)
            POT=GPOTDR(-NMAX,1,SU,SU8)
            GREFI= SQRT(G1(1)**2+G1(2)**2+G1(3)**2)
            DGI=(GREFI-REFI-D2*(POT-REF1)/DISTO)*1.0D5
            IF (.NOT.LMEAN1) THEN 
C CORRECTION DEC. 1996 BY CCT.
             IF (LEQANG) THEN
              DGM=DGM+DGI*COSLA
              RJ=RJ+COSLA
             ELSE
              DGM=DGM+DGI
             END IF
              COSLO1=COSLO
              COSLO=COSLO*COSSTE-SINLO*SINSTE
              SINLO=SINLO*COSSTE+COSLO1*SINSTE
             ELSE 
              DGM=DGM+DGI*FILTER(MA) 
             END IF 
            END DO   
C
            IF (LMEAN1) THEN
             CALL PAZIM(RLATS,RLONGS,COSLA,SINLA,COSLO,SINLO,CAZP,SAZP,
     *       COSSTN,SINSTN,LTEST) 
            ELSE 
             COSLA1=COSLA
             COSLA=COSLA*COSSTN+SINLA*SINSTN
             SINLA=SINLA*COSSTN-COSLA1*SINSTN
            END IF 
           END DO   
C END MA LOOP.
C
           OBS(IT)=(REF0-REFM/5)*1.0D5
           IF (LPOTSD) OBS(IT)=OBS(IT)-13.7
C CORRECTION DEC. 1996 BY CCT.
           IF (LEQANG.AND.(.NOT.LMEAN1)) THEN
            OBS(IP)=DGM/RJ
           ELSE
            OBS(IP)=DGM/(NSTEP*NSTEPE)
           END IF
          END IF      
         END IF
C
         IF (LPOTIN.AND.NO1.NE.1) THEN
          OBS(IP)=OBI(IIP)+OBS(IT)
          IF (LREPEC) OBS(IP1)=OBI(IIP1)+OBS(IT1)
         ELSE
          IF (LPOTIN.AND.NO1.EQ.1) THEN       
           POTDIF= ABS(OBS(IP)-OBI(IIP)-OBS(IT))
           IF (LDEFVP.AND.(POTDIF.GT.0.1).OR.LGRP.AND.(POTDIF.GT.2.0)
     *     .OR.LZETA.AND.(POTDIF.GT.0.1)) WRITE(6,273)OBS(IP),OBI(IIP)
  273      FORMAT(' *** WARNING *** COMPUTED=',F8.2,', INPUT=',F8.2)
          END IF
         END IF
C
         IF (LADDBP) OBS(IB) = OBS(IB)+OBS(IP)
         IF (LADBPR) OBS(IB1) = OBS(IB1)+OBS(IP1)
         IF (LDEN.AND.IH.EQ.0) HP=OBS(1)
        END IF   
       END IF 
C CHANGE 2004-07-09.
       IF (.NOT.LSPHER) THEN
        CALL EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,HP,E22,AX2)
       END IF
C
C NO SPHERICAL APPROXIMATION, 2001-09-21.
      IF (.NOT.LSPHER) THEN
C CHANGE 2004-08-11.
       IF (.NOT.LSATP.AND.(.NOT.LZETA)) ISATP=3
C THIS ASSIGNMENT INDICATES FULL ROTATION, USING THE UNIT MATRIX.
       IF (DISTO.LT.RB) THEN
        WRITE(*,*)' POINT INSIDE BJERHAMMAR SPHERE, H::= 10000 M '
        WRITE(*,*)HP,DISTO,RB
        HPP=0.0D0
       ELSE
        HPP=DISTO-RE
C CHANGE 2003-06-02.
        IF (IH.NE.0) HP=HPP
       END IF
C
       COSLAP=XY/DISTO
       SINLAP=Z/DISTO
       RLATP1=ATAN2(Z,XY)
C DLATP IS GEOCENTRIC LATITUDE MINUS GEODETIC LATITUDE. MORE CORRECT
C IS THE ANGLE BETWEEN THE NORMAL GRAVITY FIELD VECTOR, SEE RGRAV.
       DLATP=RLATP1-RLATP
       IF (ABS(DLATP).GT.0.1) THEN
        WRITE(*,*)' ERROR, RLATP,P1 = ',RLATP,RLATP1
       ELSE
C CORRECTION 2003-04-06.
        RLATP=RLATP1
       END IF
      ELSE
       HPP=HP
      END IF
C
      RETURN
      END
C    
      SUBROUTINE COPRED(PW2,REJLEV,OBI,WM,SM,ERCOV,
     *KP,NPARM,NFILE,NPARM1,NERRM,NGRE,NGRERR,NO,NPRED,NPRED1,
     *LERNO,LINSOL,LREPEC,LTCOV,LSATAC,LADBA,LTNB,LTEB,LCOMP,
     *LFOUND,LCOD,LMENSI,LSATP,LNBL1,LGRERS,LGRERR,LSA,LERCOV,LEROUT,
     *LWAIT)
C THE SUBROUTINE COMPUTES PREDICTED VALUES FROM COLLOCATION
C AND LOOKS FOR GROSS ERRORS. MOVED FROM MAIN BODY 2004-12-01.
C LAST UPDATE 2005-10-01.
C
      IMPLICIT NONE
C
      LOGICAL LINSOL,LERNO,LF,LT,LPARAM,LPRED,LNEQ,LNEQ8,
     *LNEWSO,LINT,LTABLE,LTABLR,LCO1,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART,LPUNCH,
     *LTERMA,LTERMO,LSTNO,LEROUT,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT,
     *LFOUND,LCOD,LMENSI,LSATP,LNBL1,LGRERS,LGRERR,LTCOV,LERCOV,
     *LSATAC,LREPEC,LSA,LPOT,LKM,LTERRC,LPOTIN,LADBA,LTNB,LTEB,LCOMP,
     *LWAIT
C
      INTEGER ITCOUN,NCRW,IYX,NMAX,II,IOBS,IOBSR,N1,NIR,NO,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,NREAD,
     *NBOLD,IS,IPX,IMAX1,IMAX1R,ICZERO,NCZERO,MAXO,
     *NI,NR,INDEX,IKP,ISAT,ISATP,NOBLK,NSAT,NCAT,ISZE,NBL,
     *MAXBL,ISIZE,NNBL,NDIMC,NISIZE,INUMR,NO1,K2,K3,K2P3,K4,IU,K21,
     *IU1,IANG,NWRITE,NGRERR,INDG,
     *KP,NPARM,NFILE,NPARM1,NERRM,NGRE(10),J,
     *IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *NRCAT,IRSZE,NPRED,NPRED1,I61,I62 
C
      PARAMETER (MAXO=16200,NSAT=16200)
      PARAMETER (NDIMC=399120,NISIZE=880,NCRW=400000,NNBL=20000)
C     PARAMETER (NDIMC=99986000,NISIZE=14000,NCRW=100000000,NNBL=20000)
C
      REAL*8 OBS,D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,CC(NCRW),
     *CNR,GMP,AX,S,SR,AAI,AAR,PW2,VAR,OBI(22),WM,SM(2200),C,
     *B,HQ,RLAT,SINLAT,COSLAT,RLONG,SINLON,COSLON,WOBS,
     *SINLOP,COSLOP,BSIZE,BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,
     *CAZP,SAZP,HP,RLATP,PRETAP,PREDP,HCZERO,OLDB,
     *SR11,SR12,SR13,SR22,COSAZ,SINAZ,SATROT,REJLEV,CR,ERCOV(500), 
C USED IN ERROR COVARIANCE COMPUTATION. ADDED 200-08-09.
     *CPQ,COVPQ,PREDCO(13),PREDCP(13)
C
      CHARACTER*128 OLDCOV
C
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
      COMMON /NESOL/C(NDIMC),NCAT(NISIZE),ISZE(NISIZE),NBL(NNBL),
     *MAXBL,ISIZE 
      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),SATROT(3,3) 
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
      COMMON /BIPARC/OLDCOV(2),S,SR,AAI,AAR,NBOLD,IS,IPX,
     *IMAX1,IMAX1R,LTABLE,LTABLR,LCO1
      COMMON/OBSER/OBS(22)
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      COMMON /BIPAR/OLDB(4),CNR,GMP,AX,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT
      COMMON /CRW/CR(NDIMC),NRCAT(NISIZE),IRSZE(NISIZE) 
      EQUIVALENCE (C(1),CC(1))
C
       IF (LINSOL.AND.LERNO) IYX=NREAD(CC,MAXBLT,NT,IDIMCN)
C      WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
C WHEN LINSOL IS TRUE, WE HAVE TO READ THE LAST BLOCK IN ORDER
C THAT THE CALL OF PRED MAY STORE THE COVARIANCES AT THE RIGHT
C POSITIONS IN THE ARRAY CC.
C
C      WRITE(*,*)' PRED ',IS,IPX,ISO,II,IOBS,N1,IMAX1
       CALL PRED(S,AAI,IS,IPX,ISO,II,IOBS,N1,IMAX1,LT,LF,LERNO,
     * LTABLE,LTCOV,LSATAC)
C      WRITE(*,*)' PRED ',IS,IPX,ISO,II,IOBS,N1,IMAX1
       LFOUND=LF 
C
       IF (LERNO) THEN
        PW2 = D0
        IF (.NOT.LCOD) THEN
         PW2=VAR(SM,IS,KP,S,AAI,HP,IMAX1,LMENSI,COSLAP,SINLAP,LSATP,
     *      SATROT)
        END IF
        C(MAXC2) = PW2
C STORAGE OF COVARIANCES.
        NPRED=NPRED+1
        IF (NPARM.GT.0) C(MAXC2) = -C(MAXC2)
        IF (LWAIT) THEN 
C 2005-11-01 CHANGED SO THAT ALSO COMPUTATION OF ERCOV CAN BE DEFERRED.
         NPRED1=NPRED1+1
         WRITE(19,REC=NPRED1)(C(I61),I61=MAXC2-N,MAXC2)
        END IF
C
C STORING THE NEW RIGHT-HAND SIDE, SO THAT THE ERROR OF
C PREDICTION CAN BE COMPUTED.
        IYX=NWRITE(NFILE,CC,MAXBLT,NT,IDIMCN)
C COMPUTATION OF THE ERROR OF PREDICTION. THE CALL OF NES GIVES CSS-
C  CPT*(C**-1)*CP+APT*(C**-1)*A*EXX*AT*(C**-1)*AP.
C       IF (LTEST) 
C       WRITE(*,*)' NES,N1,N,NT,IDIMCN',N1,N,NT,IDIMCN,LERNO,NPARM1
        IF (LEROUT.OR.(.NOT.LWAIT)) THEN
        CALL NES(N1,N,0,N1-NPARM1,.FALSE.,OBS(K2),NT,IDIMCN,
     *  .NOT.LERNO,NERRM,NPRED1)
        END IF
        LNBL1=MAXBL.EQ.1
C       IF (LTEST) WRITE(*,1661)(C(I61),I61=1,120)
        IF (NPARM.GT.0) OBS(K2) = -OBS(K2)
        OBS(K2) = OBS(K2)+1.0D-7
        IF (OBS(K2) .GT. 1.0D-10) OBS(K2) =  SQRT(OBS(K2))
        IF (LERCOV) THEN
C COMPUTATION OF ERROR-COVARIANCES. 2005-03-02.
         IF (.NOT.LWAIT) THEN
C STORAGE OF REDUCED COVARIANCES.
          WRITE(19,REC=NPRED)(C(I61),I61=MAXC2-N,MAXC2-1)
         END IF
C STORAGE OF COORDINATES OF PREDICTION POINTS IN PREDCO, 2005-08-03.
         PREDCO(1)=RLATP
         PREDCO(2)=COSLAP
         PREDCO(3)=SINLAP
         PREDCO(4)=RLONGP
         PREDCO(5)=COSLOP
         PREDCO(6)=SINLOP
         PREDCO(7)=HP
         IF (LSATP) THEN
          DO I61=1,3
           DO I62=1,3
            PREDCO(7+I61*3+I62)=SATROT(I61,I62)
           END DO
          END DO
         END IF
         WRITE(20,REC=NPRED)PREDCO
         IF (.NOT.LWAIT) THEN
          DO I62=1,NPRED
C READING OF COVARIANCES.
           READ(19,REC=I62)(CR(I61),I61=1,N)
           READ(20,REC=I62)PREDCP
           CPQ=COVPQ(SM,IS,KP,S,AAI,IMAX1,LMENSI,LSATP,PREDCO,
     *     PREDCP)
           ERCOV(I62)=CPQ
           DO I61=1,N
            IF (NPARM.GT.0.AND.I61.GT.N-NPARM) THEN
             ERCOV(I62)=ERCOV(I62)+CR(I61)*C(I61+MAXC2-N1)
            ELSE
             ERCOV(I62)=ERCOV(I62)-CR(I61)*C(I61+MAXC2-N1)
            END IF
           END DO
          END DO
          WRITE(7,1662)(ERCOV(I62),I62=1,NPRED),PW2
          WRITE(*,1662)(ERCOV(I62),I62=1,NPRED),PW2
 1662     FORMAT(6D12.5)
         END IF
        END IF
       END IF
C
      IF (LREPEC) THEN
       IF (LERNO) THEN
C FIRST WE MOVE THE SECOND COLUMN OF THE RIGHT HAND SIDE INTO THE POSITION
C OF THE FIRST COLUMN.
        DO J = 1, N
         C(MAXC+J) = C(MAXC2+J)
        END DO
        C(MAXC2) = PW2
        IF (NPARM.GT.0) C(MAXC2) = -C(MAXC2)
        IYX=NWRITE(NFILE,CC,MAXBLT,NT,IDIMCN)
        CALL NES(N1,N,0,N1-NPARM1,.FALSE.,OBS(K21),NT,IDIMCN,
     *  .NOT.LERNO,NERRM,NPRED1)
        IF (NPARM.GT.0) OBS(K21) = -OBS(K21)
        OBS(K21) = OBS(K21)+1.0D-7
        IF (OBS(K21).GT.1.0D-10) OBS(K21) =  SQRT(OBS(K21))
       END IF
       OBS(IA1) = PRETAP
       IF (LADBA) OBS(IB1) = OBS(IB1)+OBS(IA1)
       IF (LTNB) OBS(IU1) = OBS(IB1)-OBS(IT1)
       IF (LTEB) OBS(IU1) = -OBS(IT1)
       IF (LCOMP) OBS(13) = OBS(12)-OBS(IU1)
C
       IF (LGRERS.OR.LGRERR) THEN
        IF (LSA) OBI(IIE1)=ABS(WM)                   
        OBS(14)= SQRT(OBS(14)**2+OBI(IIE1)**2) 
        IF (LGRERR) THEN
         LFOUND= ABS(OBS(13)).GT.REJLEV*OBS(14)  
        END IF
        INDG=ABS(OBS(13)*2)/OBS(14)+1
        IF (INDG.GT.8) INDG=8
        NGRE(INDG)=NGRE(INDG)+1
        NGRERR=NGRERR+1
       END IF
      END IF
C 
      OBS(IA) = PREDP
      IF (LADBA) OBS(IB) = OBS(IB)+OBS(IA)
      IF (LTNB) OBS(IU) = OBS(IB)-OBS(IT)
      IF (LTEB) OBS(IU) =-OBS(IT)
      IF (LCOMP) OBS(3) = OBS(2)-OBS(IU)
      IF (LGRERR.OR.LGRERS) THEN
C 
       IF (LSA) OBI(IIE)=WM                    
       OBS(4)= SQRT(OBS(4)**2+OBI(IIE)**2) 
       IF (LGRERR) THEN 
        LFOUND= ABS(OBS(3)).GT.REJLEV*OBS(4)  
       ELSE
C CORRECTION 2004-12-22.
        NGRERR=NGRERR+1 
       END IF
       INDG=ABS(OBS(3)*2)/OBS(4)+1
       IF (INDG.GT.8) INDG=8
       NGRE(INDG)=NGRE(INDG)+1
       IF (LFOUND) THEN
C OUTPUT OF DETECTED GROSS-ERRORS TO UNIT 24. 
        RLATP=RLATP*180.0/PI
        RLONGP=RLONGP*180.0/PI 
        IF (LONECO) WRITE(12,712)NO,RLATP,RLONGP,OBS(1),OBS(2),
     *  OBI(IIE),OBS(3),OBS(4) 
        IF (.NOT.LONECO)WRITE(12,713)NO,RLATP,RLONGP,OBS(1),OBS(2),
     *  OBS(12),OBI(IIE),OBI(IIE1),OBS(3),OBS(4),OBS(13),OBS(14)   
  712   FORMAT(I11,F10.5,F11.5,F8.1,4F10.4)   
  713   FORMAT(I11,F10.5,F11.5,F8.1,4F10.4,/,4F10.4)   
C FORMAT CHANGED 8.2 -> 10.4, 2005-10-01.
        NGRERR=NGRERR+1 
       END IF
      END IF
      RETURN
      END
C
      SUBROUTINE INCOV(LINTER,RB) 
C PROGRAMMED BY C.C.TSCHERNING, GEOPHYSICAL INSTITUTE, UNIVERSITY
C OF COPENHAGEN, DENMARK.
C LAST UPDATE: 2008-07-07 BY CCT.   
C THIS MODULE READS COVARIANCE FUNCTION PARAMETERS, CREATES NECESSARY
C TABELS FOR THE EVALUATION OF THE COVARIANCE FUNCTION.
C
      IMPLICIT NONE
      INTEGER MAXO,NSAT,NCTA,ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD
     *,ICZERO,NCZERO,KCI,NC1,NC2,NI,NR,INDEX,IKP,ISAT,ISATP,NOBLK,
     *MAXB,IX,ICX,ITX,ITX1,ISX,IS1,IZ,IZ1,IZ2,IZ3,IMX,IM1,
     *IM2,IM3,IM4,IM5,IM6,II0,IOLD,NBOLD,IS,IPX,
     *IMAX1,IMAX1R,KTYPE,IK,IK1,I,IMAX,IMIN,MODEL1,NTA,NT1,NT2,
     *NTMAX1,NTMAX,NHE,NINTH,NFU,KEYH,J,NTABH,IOBS2,NSTART,IT,
     *MAXC1,MODEL,IC,IIP1,K2P3,K3,K4,NUM,INN,ITCOUN,IDIMC,IA1,
     *MAXC,IU1,NIR,IOBSR,INV,NT,INUMR,K21,K2,IU,
     *IA,IB,IH,IP,IB1,IP1,IC1,IC11,K1,IOBS1,
     *ITE,ITE1,IITE,IITE1,IIP,IIE,IIE1,INO,NO1,IANG,N,IT1,MAXC2,N1,
     *IOBS,ISO,IDIMCN,MAXBLT,II,NMAX,NFILTE,JR
C
      REAL*8 GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,
     *B,HQ,RLAT,SINLAT,COSLAT,RLONG,SINLON,COSLON,WOBS,
     *SINLOP,COSLOP,BSIZE,BSIZEN,BSIZEE,COSLAP,
     *SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,CCI,CCR,SIGMA0,SIGMA,HCMAX,
     *CCV,DC,CTA,CTTF,CTSF,SZ,AZ,DXX,VARI,SCALE,SCALE2,
     *D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,
     *STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER,STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q,S,SR,AAI,AAR,SM,DRAPP,DGPM2,SATROT,CNR,
     *SUMSIG,R,VARDG2,DR,RB,RB2,CVV,VZERO,A0,SIZEI,HTA,AX,GMP,
     *VG,RTA,TMAX,OLDB,VAR

C
      PARAMETER (MAXO=16200,NSAT=16200,NCTA=1600)
C SMA PARAMETER (MAXO= 100,NSAT= 20,NCTA=100)
C 386 PARAMETER (MAXO= 250,NSAT= 20,NCTA=150)
      LOGICAL LTERRC,LNUOUT,LPOTIN,LINTER,LZERO,LMODEL,LTRAN,
     *LK31,LCLU7,LOPEN7,LTABLE,LTABLR,LOK,LF,LT,LOCAL,
     *LOPEN4,LTABH,LTIME,LTCOV,LOBSST,LMULTF,LCREF,LSUM,LWRSOL,
     *LSTOP,LIN4,LPUNCH,LKM,LC1,LC2,LDEFVP,
     *LONECO,LSTNO,LTERMA,LTERMO,LPARAM,
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LOPCOF,LBIPOT,LBICOV,LBISOL,LINSOL,LK30,
     *LNERNO,LOUTC,LNETAP,LNKSIP,LK2EQ4,LINT,LNEQ,
     *LNEWSO,LNEQ8,LCO1,LPRED,LPOT,LONEQ,LSTART
C
      CHARACTER*128 PNAME,OLDN,OLDCOV 
C
      COMMON /CON1/OLDN(4)/CON2/GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,
     *ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
C THESE VARIABLES HAVE BEEN PLACED IN COMMON, SO THAT THEY MAY BE
C INITIALIZED BY THE BLOCK DATA MODULE.
C
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK, 
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C IN /PR/ IS STORED: THE CONSTANTS B(I), THE CATALOGUE OF THE OBSER-
C VATIONS (INDEX), LATITUDE, COS AND SIN OF LATITUDE, LONGITUDE AND
C HEIGHT OF OBSERVATION POINTS, THE CORRESPONDING QUANTITIES FOR THE
C PREDICTION POINT. THE LOGICAL VARIABLES ARE USED TO DISTINGUISH
C BETWEEN THE DIFFERENT PREDICTION SITUATIONS. THE COMMON BLOCK IS ALSO
C FOUND IN BLOCK DATA, PRED, OUTSOL AND INSOL. 
C FOR A COMPLETE DESCRIPTION, SEE THE MAIN PROGRAM.
C
      COMMON /CMCOV/CCI(24),CCR(56),SIGMA0(2200),SIGMA(2200),HCMAX,
     *CCV(2,2),DC(36),KCI(37),NC1,NC2,LOCAL,LSUM
C COMMON VARIABLES USED IN COVAX.
C
      COMMON /TABELC/CTA(NCTA,16,2),CTTF(800),CTSF(20),SZ(30),AZ(18),
     *MAXB(20),IX(8),ICX,ITX,ITX1,ISX,IS1,IZ,IZ1,IZ2,IZ3,IMX,IM1,
     *IM2,IM3,IM4,IM5,IM6,II0,IOLD
C COMMON VARIABLES USED IN CTABEL AND COVCG.
C
      COMMON /CTABH/RTA(1200),HTA(5),TMAX,SIZEI,NFU(5),KEYH(5,5),
     *NINTH,NTABH(15,5,5),NHE,NSTART,LTABH
C COMMON VARIABLES USED IN INTABH AND TABH.
C
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
C IN OUTC ARE STORED SUBSCRIPTS OF VARIABLES TO BE OUTPUT AND LIMITS
C FOR DO-LOOPS IN OUTPUT. NOTE THAT OUTC OCCURS IN SUBROUTINES
C HEAD, COUT, CXPARM AND THE BLOCK DATA MODULE.
C
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
      COMMON /CHEAD1/LC1,LC2,LCREF
C IN /OUTC/ AND /CHEAD/ ARE STORED INFORMATION USED TO HANDLE THE DIF-
C FERENT I/O SITUATIONS.
      COMMON /COM2/DXX,NUM(70),VARI(32),SCALE,SCALE2,INN,INV
C USED BY COMPA, COMPARING OBSERVED AND PREDICTED QUANTITIES.
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE  
      COMMON /CMEAQ/STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q 
C STEPSIZES USED WHEN CALCULATING MEAN VALUES.
C
      COMMON /BIPAR/OLDB(4),CNR,GMP,AX,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT
      COMMON /BIPARC/OLDCOV(2),S,SR,AAI,AAR,NBOLD,IS,IPX,
     *IMAX1,IMAX1R,LTABLE,LTABLR,LCO1
C DATA USED WHEN STORING SOLUTIONS OR COVARIANCE FUNCTION ON
C BINARY FORM. (CHANGE MADE NOV 1986).
C
      DIMENSION SM(2200),DRAPP(181),DGPM2(201),SATROT(3,3)
      EQUIVALENCE (DRAPP(1),RTA(1)),(DGPM2(1),RTA(182))
C
        IF (LCREF) GO TO 1000 
C 
C *************** INPUT (6) **********************************
C
C INPUT OF THE INTEGER KTYPE DETERMINING TYPE OF DEGREE-VARIANCE
C MODEL USED FOR DEGREE-VARIANCES OF DEGREE GREATHER THAN IMAX
C (SEE BELOW). KTYPE MAY BE EQUAL TO 1, 2, OR 3, CORRESPONDING
C TO THE DEGREE-VARIANCE MODEL NUMBERS OF REF(A).
      IF (LINTER)WRITE(6,*)' INPUT DEGREE-VARIANCE MODEL NO. (1,2,3)' 
  102 FORMAT(I2)
      READ(5,*)KTYPE
      IF (LWRSOL) WRITE(17,102)KTYPE
      KCI(5)=KTYPE
      IK=0
      IK1=0
      IF (LINTER)WRITE(6,*)' INPUT DENOMINATOR(S) IN MODEL' 
      IF (KTYPE.LT.2) GO TO 1036
      IF (KTYPE.EQ.2) READ(5,*)IK
      IF (KTYPE.EQ.3) READ(5,*)IK,IK1
      IF (LWRSOL)WRITE(17,107)IK,IK1
  107 FORMAT(2I4)
      IF (KTYPE.LE.0 .OR. KTYPE.GE.4) STOP      
C
 1036 KCI(3)=IK
      KCI(4)=IK1
      WRITE(6,141)
  141 FORMAT(/' THE MODEL ANOMALY DEGREE-VARIANCES ARE EQUAL TO'/,
     *' A*(I-1)')
      GO TO (1038,1039,1037),KTYPE
 1038 WRITE(6,143)
  143 FORMAT('+',8X,'/(I-2).')
      GO TO 1000
 1039 WRITE(6,144)IK
  144 FORMAT('+',8X,'/((I-2)*(I+',I4,')).')
      GO TO 1000
 1037 WRITE(6,142)IK,IK1
  142 FORMAT('+',8X,'/((I-2)*(I-',I4,')*(I-',I4,')).')
C
C
C THIS IS THE RETURN POINT AFTER THE FIRST COLLOCATION STEP IF
C A SECOND STEP IS WANTED. NOTE THAT THE SAME DEGREE-VARIANCE
C MODEL MUST BE USED, BUT R,VARDG2 AND IMAX MAY BE CHANGED.
C
 1000 CNR = D0
      DO 1035 I = 1, 300
 1035 SIGMA(I) = D0
C
      SUMSIG = D0
      MAXC1 = 1
C
C *************** INPUT (7) **********************************
C
C INPUT OF CONSTANTS USED FOR THE FINAL SPECIFICATION OF THE DEGREE-VAR-
C IANCE MODEL:
C R      - RATIO BETWEEN THE BJERHAMMAR-SPHERE RADIUS AND THE
C          MEAN RADIUS OF THE EARTH (RE), IF POSITIVE. IF NEGATIVE IT
C          IS THE DEPTH TO THE BJERHAMMAR SPHERE IN KM.
C VARDG2 - VARIANCE OF GRAVITY ANOMALIES AT ZERO ALTITUDE.
C IMAX   - MAXIMAL DEGREE FOR EMPIRICAL DEGREE-VARIANCES.
C LZERO  - TRUE IF ALL EMPIRICAL DEGREE-VARIANCES ARE ZERO.
C LTABLE - TRUE IF TABLE OF COVARIANCES IS TO BE USED.
C LMODEL - TRUE IF THE DEGREE-VARIANCES ARE (SCALED) ERROR DEGREE
C          VARIANCES OBTAINED FROM A GEOPOTENTIAL MODEL. THE VALUES
C          ARE FOR TWO MODELS FOUND IN THE BLOCK DATA MODULE.
C LTABH  - TRUE, IF COVARIANCE TABLES ARE USED WITH FIXED HEIGHTS
C          AND FUNCTIONALS.
C NOTE THAT LTABH AND LTABLE CAN NOT BE USED SIMULTANEOUSLY.
C THIS IS THEN FOLLOWED BY FURTHER DETAILS:
C (A) IF LMODEL TRUE, SPECIFICATION OF MODEL FOR THE VARIANCES.
C (B) IF LMODEL OR LZERO FALSE, THE EMPERICAL DEGREE-VARIANCES.
C (C) IF LTABLE IS TRUE, THEN TABLE SPECIFICATIONS.
C (D) IF LTABH IS TRUE THE TABLE AND FUNCTIONAL SPECIFICATIONS.
 1111 IF (LINTER)WRITE(6,1110) 
 1110 FORMAT(' INPUT PARAMETERS DESCRIBING COV. FCT.',/
     *' R - NEG. DEPTH TO BJ.SPHERE IN KM OR RATIO RB/RE',/
     *' GRAVITY ANOMALY VARIANCE IN MGAL**2',/ 
     *' MAX. DEGREE OF LEGENDRE FCT. EXPANSION (E.G. 180, 360)',/
     *' LZERO - TRUE IF FIRST COEFF. ALL ARE ZERO',/
     *' LTABLE - TRUE IF COV.FCT. IS TABULATED IN 2D',/
     *' LMODEL - TRUE IF DEGREE-VAR. FROM PREDEFINED MODEL',/
     *' LTABH - TRUE IF 1D TABULATION') 
      READ(5,*,ERR=1111)R,VARDG2,IMAX,LZERO,LTABLE,LMODEL,LTABH
  101 FORMAT(F8.5,1X,F7.2,I4,4L2)
      IF (LWRSOL) WRITE(17,101)R,VARDG2,IMAX,LZERO,LTABLE,LMODEL,
     *LTABH
      IF (R.GT.D1.OR.VARDG2.LT.D0.OR.LTABLE.AND.LTABH) STOP      
      IMAX1=IMAX+1
C
      IF (R.GT.D0) S=RE*(R-D1)
      IF (R.LT.D0) S=R*1.0D3
      CCI(10)=S
      DR=S
      IF (R.LT.D0) R=(RE+S)/RE
      RB=S+RE
      RB2=(S+RE)**2
      AAI=RB2*1.0D-8
      CCI(8) = AAI
      LOCAL=LT
      LSUM=LF
C CHANGE 2002.10.01
      HCMAX = 1.0D6
C     HCMAX = 1.0D5
      WRITE(*,1911)HCMAX
 1911 FORMAT(' HCMAX = ',F10.1,' M. ')
C THIS IMPLIES, THAT THE POSSIBILITY FOR USING THE SUMMATION OF
C THE LEGENDRE SERIES IN COVAX CAN NOT BE USED. IF THIS IS NEEDED
C CHANGE LSUM,HCMAX AND THE DIMENSION OF SM (TO E.G. 2000).
      NC1=IMAX1
      NC2=3
      CALL COVAX(SM,IS)
C     CVV=VAR(SM,IS,3,S,AAI,D0,IMAX1,LF)
C ERROR DETECTED 1994.12.20 BY TK. 
      CVV=VAR(SM,IS,3,S,AAI,D0,IMAX1,LF,COSLAP,SINLAP,LF,
     *   SATROT)
C
      LOCAL = LZERO
      IF (LZERO) WRITE(6,112)IMAX
  112 FORMAT( I4,' ERROR DEGREE-VARIANCES EQUAL TO ZERO')
      IF (LOCAL) GO TO 1040
      IF (.NOT.LMODEL) GO TO 1041
C
C --------------- INPUT (7A) ---------------------------------
C INPUT OF MODEL NUMBER, FIRST DEGREE TO BE USED AND SCALE FACTOR.
      IF (LINTER) WRITE(6,*)
     *' INPUT MODEL NO., START DEGR. & SCALE FACT.' 
      READ(5,*)MODEL,IMIN,VG
C MODEL .LE. 0 INDICATES THAT THE DEGREE-VARIANCES ARE INPUT FROM A
C         FILE (PNAME), AND FILE NAME MUST BE INPUT SUBSEQUENTLY. 
C MODEL 1 IS A MODEL FOR THE ERROR IN RAPP'S 1978 SET
C MODEL 2 IS THE ERROR DEGREE-VARIANCES FOR RAPP'S 1981 SET,
C MODEL 3 IS THE ERROR DEGREE-VARIANCES FOR WENZELS GPM2 SET.
C MODEL 4 IS A LINEAR MODEL IN THE DEGREE, SO THAT FOR VG=1.0 THE
C    THE ERROR DEGREE VARIANCE IS EQUAL TO 1.0 FOR DEGREE 100.
C MODEL 5 IS A SIMILAR, BUT QUADRATIC MODEL.
C FOR MODEL 2 AND 3 THE INITIALIZATION TAKES PLACE IN THE
C BLOCK DATA MODULE. CONSEQUENTLY THESE MODES CAN ONLY BE USED
C WHEN THE VARIABLES, WITH WHICH THEY ARE EQUIVALENCED (RLAT),
C HAVE NOT BEEN USED FOR SOMETHING ELSE ALREADY.
      IF (MODEL.EQ.1.OR.IC.LT.1218) GO TO 1050
C
      WRITE(6,117)
  117 FORMAT(' **** ERROR DEGREE-VARIANCES DESTROYED IN',
     *' FIRST COLLOCATION STEP **** ')
      STOP       
C
 1050 IF (LWRSOL) WRITE(17,115)MODEL,IMIN,VG
  115 FORMAT(2I3,F9.6)
      WRITE(6,116)MODEL,IMIN,IMAX,VG
  116 FORMAT(' MODEL ',I3,' USED FROM DEGREE ',I3,' TO ',I3,
     *' WITH SCALE FACTOR= ',F9.6)
C ADDITION 1999-05-17 BY CCT.
      LMULTF=(MODEL.LT.0)
      IF (LMULTF) THEN
       MODEL=0
      END IF
C
      MODEL1=MODEL+1 
      DO 1043 I = 2, IMAX
       SIGMA(I+1) = D0
       IF (I.LE.IMIN) GO TO 1043
       GO TO (1043,1051,1052,1053,1054,9955),MODEL1 
 1051  SIGMA(I+1) = (2*I+1)*(VG*9.81)**2
       GO TO 1043
 1052  SIGMA(I+1) = VG*DRAPP(I+1)
       GO TO 1043
 1053  SIGMA(I+1) = VG*DGPM2(I+1)
       GO TO 1043
 1054  SIGMA(I+1) = I*1.0D-2*VG
       GO TO 1043
 9955  SIGMA(I+1) = I**2*1.0D-4*VG
C MODES 4 AND 5 ADDED 1988.11.30 BY CCT. MODEL 0, JAN. 1990. 
 1043 CONTINUE
C
      IF (MODEL.NE.0) GO TO 1042
      IF (LINTER) WRITE(6,*)' INPUT NAME OF FILE WITH DEGR.VAR.' 
      READ(*,'(A)')PNAME  
      WRITE(6,*)' DEGREE-VARIANCES INPUT FROM FILE ',PNAME 
      OPEN(9,FILE=PNAME,STATUS='OLD')
      READ(9,*)(SIGMA(I+1),I=IMIN,IMAX) 
      IF (LWRSOL)WRITE(17,2103)PNAME 
 2103 FORMAT(A128)
      CLOSE(9) 
C CHANGE 1999-05-17 BY CCT:
      IF (LMULTF) THEN
       WRITE(*,*)' MULTIPLICATIVE FACTOR USED '
       DO I=IMIN,IMAX
        SIGMA(I+1)=SIGMA(I+1)*VG 
       END DO
      ELSE
       WRITE(*,*)' INPUT VALUE FOR I=IMIN '
       READ(*,*)VZERO
       WRITE(*,1071)VZERO
 1071  FORMAT(' LINEAR FACTOR =',F8.4,' USED.')
       VZERO=VZERO/VG
       DO I=IMIN,IMAX
        SIGMA(I+1)=SIGMA(I+1)*VG*(VZERO+I/(IMAX-1))
       END DO
      END IF 
C
      GO TO 1042
C
C --------------- INPUT (7B) ---------------------------------
C INPUT OF EMPIRICAL DEGREE-VARIANCES. NOTE, THAT PROBLEM MAY OCCUR
C IF FREE FORMAT IS USED, AND INPUT-DATA IS LINE NUMBERED. IN THIS
C CASE CHANGE TO FORMATTED INPUT.
 1041 CONTINUE 
      IF (LINTER) WRITE(6,*)' INPUT DEGR. VARIANCES (MGAL**2)' 
      READ(5,*) (SIGMA(I), I = 3, IMAX1)
      IF (LWRSOL) WRITE(17,98) (SIGMA(I), I = 3, IMAX1)
   98 FORMAT(8F8.2)
C NOTE THAT THE DEGREE-VARIANCE OF ORDER I IS STORED IN SIGMA(I+1).
C
      WRITE(6,111)IMAX
  111 FORMAT(I4,' EMPIRICAL ANOMALY DEGREE-VARIANCES FOR DEGREE',
     *' > 1,'/,' IN UNITS OF MGAL**2 : ')
      WRITE(6,98) (SIGMA(I), I = 3, IMAX1)
C
 1042 CONTINUE
      DO 1001 I = 3, IMAX1
      SIGMA0(IS+I)=SIGMA(I)
 1001 SUMSIG = SUMSIG + SIGMA(I)
 1040 IF (IMAX1+IS.LT.2200) GO TO 1002
      WRITE(6,108)
  108 FORMAT(' SUBSCRIPTS OF ARRAY SIGMA EXCEEDS ARRAY LIMIT, STOP.')
      STOP       
C
 1002 AAI=(VARDG2-SUMSIG)*RB2*1.0D-8/CVV
      IF (AAI.LT.0.0D0) THEN
C ADDED 2006-01-20.
       WRITE(*,*)' VARDG2,SUMSIG,AAI ',VARDG2,SUMSIG,AAI
       WRITE(*,*)' WARNING AAI NEGATIVE '
       STOP
      END IF
      CCI(8)=AAI
      CALL COVAX(SM,IS)
      CALL COVBX(SM,LF,IS)
      CALL COVCX(SM,CVV,IS,LF)   
      IF ( ABS(CVV-VARDG2).GT.0.1) WRITE(6,7464)CVV,VARDG2
 7464 FORMAT(' ** WARNING ** CVV,VARGD2= ',2E15.8)
C
C THE DEG.VAR. OF THE COVARIANCE FUNCTION OF THE ANOMALOUS POTENTIAL
C ARE STORED IN THE FIRST PART OF SIGMA (SUBSCRIPT 1 TO IMAX1R) FOR
C COLLOCATION I AND IN THE LAST PART (SUBSCRIPT IS=IMAX1R+3 TO
C IS+IMAX1) FOR COLLOCATION II.
C
  110 FORMAT(/' RATIO R/RE                              =      ',F9.6,/
     *' DEPTH TO BJERHAMMAR SPHERE (R-RE)       = ',F10.2,' M'/
     *' VARIANCE OF POINT GRAVITY ANOMALIES     = ',F10.2,' MGAL**2'/
     *' THE FACTOR A, DIVEDED BY RE**2 IS       = ',F10.2,' MGAL**2')
      A0 = AAI*1.0D10/RE**2
      WRITE(6,110)R,DR,VARDG2,A0
      IF (LINTER) THEN
       WRITE(6,*)' ARE ALL PARAMETERS OK ?'
       READ(5,*)LOK
       IF (.NOT.LOK) GO TO 1111
      END IF 
      IF (.NOT.LTABLE) GO TO 1055
C
C INITIALIZATION OF POINTERS FOR COVARIANCE FUNCTION TABLES.
C IPX HAS BEEN INITIALIZED TO -1 IN THE BLOCK DATA MODULE.
      IPX=IPX+1
      IZ1=3*IPX+1
      IZ2=IZ1+1
      IZ3=IZ2+1
      IM1=IPX*6+1
      IM2=IM1+1
      IM6=IM1+5
C
C --------------- INPUT (7C) ---------------------------------
C
C INPUT OF PARAMETERS DEFINING THE TABLE USED FOR FAST COMPUTATION
C OF COVARIANCES. MAXB(1) NUMBER OF STEPS IN HEIGHT, SZ(1) MINIMUM
C HEIGHT (M), (GENERALLY ZERO), SZ(2) MAXIMAL HEIGHT (M),
C MAXB(2) NUMBER OF INTERVALS WITH EQUIDISTANT STEPSIZE IN PSI. SZ(3)
C IS ZERO AS STARTING INTERVAL END-POINT, SZ(I+3) IS RIGHTMOST END-
C POINT OF I'TH INTERVAL (ARCSEC). MAXB(I+6) IS NUMBER OF EQUIDISTANT
C INTERVALS IN I'TH INTERVAL.
C PSI IS THE SPHERICAL DISTANCE.
C A TABLE WILL BE GENERATED BY CTABEL, WHICH MAKES A FAST COMPUTATION
C OF COVARIANCES OF TYPE (1,1), (1,6), (1,7), (3,3), (3,6), (3,7)
C POSSIBLE.
      IF (LINTER) WRITE(6,1112) 
 1112 FORMAT(
     *' SPECIFY 2D TABULATION OF COVARIANCE FUNCTIONS:',/ 
     *' INPUT: NUMBER OF STEPS IN ALTITUDE, MIN. & MAX. HEIGHT (M)',/
     *'        NUMBER OF INTERVALS WITH EQUIDISTANT STEPSIZE IN PSI')
      READ(5,*)MAXB(IM1),SZ(IZ1),SZ(IZ2),NTA
      IF (LWRSOL) WRITE(17,50)MAXB(IM1),SZ(IZ1),SZ(IZ2),NTA
      MAXB(IM2)=NTA
C NTA+5 MUST BE LESS THAN 31, (DIMENSION OF SZ).
   50 FORMAT(I4,2F10.3,I4)
C
C INPUT OF RIGHT-MOST END POINT OF EACH INTERVAL IN UNITS OF ARC-
C SECONDS AND OF NUMBER OF EQUIDISTANT SUB-INTERVALS.
      IF (LINTER) WRITE(6,*)
     *' INPUT RIGHT-MOST ENDPOINTS OF EACH INTERVAL (ARCSEC)' 
      READ(5,*)(SZ(I+IZ3),I=1,NTA)
   51 FORMAT(6F10.3)
      IF (LWRSOL) WRITE(17,51)(SZ(I+IZ3),I=1,NTA)
      IF (LINTER) WRITE(6,*)
     *' INPUT NUMBER OF SUB-INTERVALS IN EACH INTERVAL' 
      READ(5,*)(MAXB(I+IM6),I=1,NTA)
   56 FORMAT(6I10)
      IF (LWRSOL) WRITE(17,56)(MAXB(I+IM6),I=1,NTA)
      SZ(IZ3)=D0
      NT1=1
      NT2=0
      NTMAX1=798
      NTMAX=NCTA 
C NTMAX IS CURRENT MAXIMUM OF POINTS IN TABEL, I.E. NTMAX*8 IS
C THE DIMENSION OF CT. NTMAX1 IS THE UPPER LIMIT FOR NUMBER OF
C ENTRIES RELATED TO SPHERICAL DISTANCE (PSI), I.E. THE DIMENSION
C OF CTTF (COMMON BLOCK TABELC).
C
      DO 57 I=1,NTA
   57 NT1=NT1+MAXB(I+IM6)
      NT2=ITX+NT1
      IF (NT2.GT.NTMAX1.OR.(NT2*MAXB(IM1)).GT.NCTA)
     *WRITE(6,53)NT1,NT2
   53 FORMAT(' *** TOO LARGE TABEL REQUIRED *** NT1=',I5,' NT2=',I5)
      WRITE(6,52)MAXB(IM1),SZ(IZ1),SZ(IZ2)
   52 FORMAT(/' TABEL OF COVARIANCES GENERATED USING',/,
     *' NS=',I4,', HMIN=',F10.3,', HMAX=',F10.3,
     */,'  MAX-PSI (ARCSEC)   N-INTERVALS.')
      DO 198 I=1,NTA
  198 WRITE(6,55)SZ(I+IZ3),MAXB(I+IM6)
   55 FORMAT(1X,F10.3,8X,I10)
C
      IX(4+IPX*4)=IS
C IX(4) POINTS AT THE ZERO'TH SUBSCRIPT OF SIGMA, WHICH HERE IS IS.
      CALL CTABEL(IPX,LTCOV)
C
 1055 IF (.NOT.LTABH) GO TO 1056
C
C ------------------------- INPUT (7D) ---------------------------
C
C INPUT OF PARAMETERS SPECIFYING COVARIANCE FUNCTION TABLE USING
C FIXED HEIGHTS AND FUNCTIONALS.
C NHE  - NUMBER OF HEIGHTS (MAX 5)
C NINTH- NUMBER OF INTERVALS
C SIZEI- SIZE OF INTERVALS IN ARCSECONDS.
      IF (LINTER) WRITE(6,1113)
 1113 FORMAT(' INPUT NUMBER OF HEIGHTS, INTERVALS & SIZE IN ARCSEC') 
      READ(5,*)NHE,NINTH,SIZEI
   41 FORMAT(2I4,F8.1)
      IF (LWRSOL) WRITE(17,41)NHE,NINTH,SIZEI
      WRITE(6,42)NINTH,SIZEI
   42 FORMAT(' NUMBER OF INTERVALS=',I4,', SIZE =',F9.1,' ARCSEC.',
     */,' HEIGHT (M)   FUNCTIONAL TYPES')
      IF (NINTH.GT.499) WRITE(6,43)
   43 FORMAT(' *** WARNING ***  NINTH DECREASED TO 499')
      IF (NINTH.GT.499) NINTH=499
      DO 44 I=1,NHE
C INPUT OF HEIGHT IN METERS AND NUMBER OF FIXED FUNCTIONALS.
      IF (LINTER) WRITE(6,1114)
 1114 FORMAT(' INPUT HEIGHTS (M) & NUMBER OF FUNCTIONALS')  
      READ(5,*)HTA(I),NFU(I)
   45 FORMAT(F9.1,I3)
      IF (LWRSOL) WRITE(17,45)HTA(I),NFU(I)
C INPUT OF FUNCTIONAL TYPES (AS USED IN COVAX, I.E. IN
C GENERAL MUST 10 BE SUBTRACTED FROM THE NUMBERS USED HERE).
      IF (LINTER) WRITE(6,*)' INPUT FUNCTIONALS CODES-10' 
      READ(5,*)(KEYH(J,I),J=1,NFU(I))
      IF (LWRSOL) WRITE(17,46)(KEYH(J,I),J=1,NFU(I))
      WRITE(6,47)HTA(I),(KEYH(J,I),J=1,NFU(I))
   47 FORMAT(F10.1,5I4)
   44 CONTINUE
   46 FORMAT(5I3)
C
      CALL INTABH(SM,IS,LTCOV)
C
 1056 RETURN
      END 
      SUBROUTINE IFORMAT(NO,IJ,IANG,IKP,IKPREF,INZ,OBI,FMT,LMEGR,
     *LSTOP,LOUTC)
C PROGRAMMED BY CCT, LAST CHANGE 2005-09-06.
      IMPLICIT NONE
      REAL*8 D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,SINLA0,COSLA0,
     *RLONG0,DSHIFT,AX2,SLAT,SLON,OBI,GRME,GRCR,X,Y,Z,XY2,XY,DISTO,
     *DIST2,S,DH,RLAT1,COSLA,RLAT,E22,TIMEP,RLATC,RLATCC,XC,YC,ZC,XYC,
     *DN,DC,SLATC,SINLAP,CLATD,RDI
C CLATD=GEOCENTRIC LATITUDE, RDI=DISTANCE FROM ORIGIN.
C
      INTEGER IDLAT,IDLON,MLAT,MLON,NOX,IA,IB,IH,IP,IT,IA1,IB1,IP1,
     *IT1,IC1,IC11,K1,IOBS1,IJ,I,INZ,NO,IKP,IHC,NSO,IKPREF,ITCOUN,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,IANG,NC
C
      LOGICAL LF,LT,LFORM,LPOT,LKM,LTERRC,LPOTIN,LMEGR,LSTOP,LNFORM,
     *LOUTC
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      COMMON /ITRANC/SINLA0,COSLA0,RLONG0,DSHIFT(7),AX2,E22
      COMMON /COBS/CLATD,RDI,SLAT,SLON,IDLAT,IDLON,MLAT,MLON,NOX,LFORM
C CLATD AND RDI ADDED TO ENABLE OUTPUT IN GEOCENTRIC COORDINATES 2005-09-06.
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
      CHARACTER*128 FMT
      DIMENSION OBI(22),FMT(9)
C
      LNFORM=.NOT.LFORM
      GO TO(2024,2025,2026,2027,2028,2029,2028,2029,2330,2322,2223,
     *2029,2339,2340,2399),IJ
 2024 IF (LNFORM.AND.K1.EQ.2)
     *READ(INZ,97)IDLAT,MLAT,SLAT,IDLON,MLON,SLON,OBI(1),OBI(2),LSTOP
   97 FORMAT(2(I4,I3,F5.2),2F8.2,L2)
      IF (LFORM) READ(INZ,FMT,END=2039)
     *IDLAT,MLAT,SLAT,IDLON,MLON,SLON,(OBI(I),I=1,K1),LSTOP
      GOTO 2030
 2025 IF (LNFORM) READ(INZ,61)
     *NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,(OBI(I),I=1,K1)
   61 FORMAT(I5,2(I4,I3,F6.2),5F8.2)
      IF (LFORM) READ(INZ,FMT,END=2039)
     *NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,(OBI(I),I=1,K1)
      GO TO 2030
 2026 IF(LNFORM) READ(INZ,95)
     *IDLAT,SLAT,IDLON,SLON,(OBI(I),I=1,K1),LSTOP
   95 FORMAT(2(I4,F5.2),2F8.2,L2)
      IF (LFORM)READ(INZ,FMT,END=2039)
     *IDLAT,SLAT,IDLON,SLON,(OBI(I),I=1,K1),LSTOP
      GOTO  2030
 2027 IF (LNFORM)
     *READ(INZ,71)NO,IDLAT,SLAT,IDLON,SLON,(OBI(I),I=1,K1)
   71 FORMAT(I10,2(I4,F6.2),8F8.2)
      IF (LFORM)READ(INZ,FMT,END=2039)
     *NO,IDLAT,SLAT,IDLON,SLON,(OBI(I),I=1,K1)
      GOTO  2030
 2028 IF (LNFORM) THEN
       READ(INZ,80)SLAT,SLON,(OBI(I),I=1,K1),LSTOP
      ELSE
       READ(INZ,FMT,END=2039)SLAT,SLON,(OBI(I),I=1,K1),LSTOP
      END IF
   80 FORMAT(2F10.5,2F8.2,L2)
      GO TO 2030
 2029 IF (LNFORM)
     *READ(INZ,81)NO,SLAT,SLON,(OBI(I),I=1,K1)
   81 FORMAT(I10,2(F12.6,1X),7F8.2)
      IF (LFORM.AND.(IKP.NE.9)) THEN
       READ(INZ,FMT,END=2039)NO,SLAT,SLON,(OBI(I),I=1,K1)
      END IF
      IF (LFORM.AND.IKP.EQ.9) THEN
       READ(INZ,FMT,END=2039)NOX,NO,SLAT,SLON,(OBI(I),I=1,K1)
      END IF
      GO TO 2030
C
 2330 IF (IKP.EQ.26.AND.(.NOT.LTERRC)) READ(INZ,92)
     *NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,(OBI(I),I=1,5)
   92 FORMAT(I7,20X,2(2I3,F6.2,4X),F7.2,/,26X,2F7.2,2F6.2)
C GI STANDARD FOR DEFLECTIONS OF THE VERTICAL.
      IF (IKP.EQ.26.AND.LTERRC) READ(INZ,29)
     *NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,(OBI(I),I=1,7)
   29 FORMAT(I6,I5,I3,F6.2,3X,I4,I3,F6.2,5X,F11.1,2X,/,8F8.2)
C
      IF (IKP.EQ.15.OR.IKP.EQ.16) READ(INZ,94)NO,IDLAT,MLAT,SLAT,IDLON,
     *MLON,SLON,(OBI(I),I=1,3)
   94 FORMAT(I7,20X,2(2I3,F6.2,4X),F7.2,/,26X,F7.2,F6.2)
C GI STANDARD FOR KSI OR ETA SEPARATLY.
C
      IF (IKP.EQ.5.AND.IH.NE.0)READ(INZ,66)NO,IDLAT,MLAT,SLAT,IDLON,
     *MLON,SLON,(OBI(I),I=1,3)
   66 FORMAT(I5,2I3,F6.2,3X,I6,I3,F6.2,3X,F7.0,3X,2F8.3)
C SSG 3.70 FORMAT FOR DEFLECTIONS OF THE VERTICAL, NEW MEXICO.
      IF (IKP.EQ.5.AND.IH.EQ.0)READ(INZ,69)NO,IDLAT,MLAT,SLAT,IDLON,
     *MLON,SLON,OBI(1),OBI(2)
   69 FORMAT(I2,2(I4,I3,F6.2,3X),2F7.2)
C SSG 3.90 FORMAT, DEFLECTIONS, OHIO.
      IF (IKP.EQ.30)READ(INZ,67)NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,
     *(OBI(I),I=1,2)
   67 FORMAT(I4,1X,2(I4,I3,F5.1,3X),2F7.2,14X)
      IF (IKP.EQ.35)READ(INZ,68)NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,
     *(OBI(I),I=1,2)
   68 FORMAT(I4,1X,2(I4,I3,F5.1,3X),14X,2F7.2)
C SSG 3.90 STANDARD FORMAT FOR TORSION BALANCE COMPONENTS.
C
      GO TO 2030
 2399 READ(INZ,7979)NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON
 7979 FORMAT(8X,I2,I5,I3,F9.5,1X,I5,I3,F9.5,1X)
      GO TO 2030
C
 2322 IF (LTERRC.OR.LPOTIN) GO TO 2398
      READ(INZ,96)IDLAT,SLAT,IDLON,SLON,IHC,OBI(1),GRME,OBI(2),NSO,
     *NO,OBI(3),GRCR,LSTOP
      IF (IHC.EQ.3) OBI(1)=0.0D0
C CHANGE 1989.02.15 BY CCT IN ORDER TO AVOID INTEGER OVERFLOW FOR
C 32 BIT INTEGERS.
      IF (NSO.GT.99) NSO=MOD(NSO,100) 
      NO=NSO*10000000+NO
      IF (LMEGR) OBI(2)=GRME+976000.0-GRCR
C INPUT OF GRAVITY DATA IN GI STANDARD FORMAT.
   96 FORMAT(1X,I2,F5.2,1X,I4,F5.2,1X,I1,F7.2,8X,F7.2,1X,F6.1,2X,
     *I3,5X,I8,F5.1,F6.2,1X,L1)
      GO TO 2030
C
 2398 IF (LOUTC)
     *READ(INZ,8999)NO,IDLAT,SLAT,IDLON,SLON,(OBI(I),I=1,K1)
 8999 FORMAT(I10,2(I4,F5.1,3X),F9.1,2X,/,2X,5F8.2)
      IF (.NOT.LOUTC)
     *READ(INZ,8997)NO,IDLAT,SLAT,IDLON,SLON,(OBI(I),I=1,K1)
 8997 FORMAT(I5,2(I4,F5.1,3X),F9.1,3X,6F8.2)
      GO TO 2030
C
 2223 IF(IKPREF.EQ.53)READ(INZ,87)NO,SLAT,SLON,OBI(1),OBI(2)
   87 FORMAT(I5,F10.6,1X,F10.6,1X,F6.1,1X,F5.1)
C GRAVITY DATA, NEW MEXICO FORMAT.
      IF (IKPREF.EQ.42)READ(INZ,88)NO,SLAT,SLON,OBI(1),OBI(2)
   88 FORMAT(I5,2(F9.4,1X),F7.1,1X,F6.1)
C SSG 3.90 FORMAT, GRAVITY DATA, OHIO.
      IF (IKPREF.EQ.45.AND.LTERRC)READ(INZ,28)NO,SLAT,SLON,(OBI(I),
     *I=1,K1)
   28 FORMAT(I6,1X,2(F11.6,3X),5X,F12.2,2X,/,8F8.2)
C FINNISH DEFLECTIONS OF THE VERTICAL.
      GO TO 2030
C
 2339 CONTINUE
C CHANGE 2004-05-12.
      IF (IANG.EQ.5) THEN
C INPUT OF CARTESIAN COORDINATES, INPUT MODE=5.
C CHANGE 2001-11-18 AND CORRECTION 2004-05-12 BY CCT.
       READ(INZ,*,END=2039)TIMEP,X,Y,(OBI(I),I=1,K1)
       Z=OBI(1)
       XY2= X*X+Y*Y
       XY =  SQRT(XY2)
       DIST2 = XY2+Z*Z
       DISTO =  SQRT(DIST2)
       SLON =  ATAN2(Y,X)*180.0D0/PI
       RLATC=ATAN2(Z,XY)
      ELSE
C INPUT OF  SPHERICAL GEOCENTRIC COORDINATES. ADDED 2004-01-06.
C CHANGED 2005-09-06.
       READ(INZ,*,END=2039)TIMEP,CLATD,SLON,(OBI(I),I=1,K1)
       RLATC=CLATD*PI/180.0D0
       RDI=OBI(1)
       Z=OBI(1)*SIN(RLATC)
       XY=OBI(1)*COS(RLATC)
      END IF
      NO=TIMEP
C
C  COMPUTATION OF THE NEW GEODETIC LATITUDE, CF REF(C) PAGE 183.
      SINLAP=SIN(RLATC)
      S = AX2/ SQRT(D1-E22*SINLAP**2)
C     S=AX2
      DH = DISTO-AX2
      RLAT1 = RLATC
      COSLA= COS(RLATC)
      NC=0
   70 RLAT = RLAT1
C
      NC=NC+1
      RLAT1 =  ATAN2(Z,XY-E22*S*COSLA)
      COSLA =  COS(RLAT1)
      S = AX2/ SQRT(D1-E22*(D1-COSLA**2))
      DH = XY/COSLA-S
C
      IF (ABS(RLAT1-RLAT).GT.1.0D-15.AND.NC.LT.30) GO TO 70
      SLATC=SLAT
      SLAT=RLAT1*180.0D0/PI
      DC=OBI(1)
      OBI(1)=DH
C
      DN=AX2/SQRT(1.0D0-E22*SIN(RLAT1)**2)
      ZC=((1.0D0-E22)*DN+DH)*SIN(RLAT1)
      XYC=(DN+DH)*COS(RLAT1)
      XC=XYC*COS(SLON*PI/180.0D0)
      YC=XYC*SIN(SLON*PI/180.0D0)
      IF (IANG.EQ.5) THEN
       IF (ABS(X-XC).GT.1.0D0.OR.ABS(Y-YC).GT.1.0D0.OR.
     * ABS(ZC-Z).GT.1.0D0) WRITE(*,*)' WARNING ',X,XC,Y,YC,Z,ZC
      ELSE
       DISTO=SQRT(XC**2+YC**2+ZC**2)
       RLATCC=ATAN2(ZC,XYC)*180.0D0/PI
       IF (ABS(RLATCC-RLATC*180.0D0/PI).GT.1.0D-6.OR.
     * ABS(DISTO-DC).GT.1.0)
     * WRITE(*,*)' WARNING ',RLATCC,RLATC,DISTO,DC,NC     
      END IF
C
      GO TO 2030
C
 2340 READ(INZ,93)NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,
     *(OBI(I),I=1,K1),LSTOP
   93 FORMAT(1X,I5,8X,2(I3,I2,F4.2,1X),F6.2,1X,4(F5.2,1X),11X)
      GO TO 2030
C
 2039 NO=-1
 2030 RETURN
      END
C
      SUBROUTINE GEOCOLH(LINTER,DNANE,TIMEARRAY,RCBASE,LNDAT,SSOBS,
     *LSATAC)
C GEOCOL SUBMODULE, PROGRAMMED 1991.08.30.  C.C.TSCHERNING,
C GEOPHYSICAL INSTITUTE, UNIVERSITY OF COPENHAGEN. HERE THE
C COLLOCATION NORMAL EQUATIONS ARE ESTABLISHED AND SOLVED.
C LAST UPDATE 2002-04-14. 
C
      IMPLICIT NONE
      INTEGER MAXO,NSAT,NCTA,NIPT,NIPCAT,JI,
     *MAXOD,NDIMC,NISIZE,NCRW,NNBL,NCOEFF,NROOT,NIICC,NNSU,
     *NEQFIM,NFILTE,MAXBNE,NEQFMA,NEQFI,MODEC0,NMAX,II,ICREL,NREL,
     *MAXPAR,NPARM1,NPARM,IPA,NCXLAS,IPTYPE,KCI,IYX,MAXBLT,NT,
     *IDIMCN,MAXC1,IS,IPX,ISO,IOBS,N1,IMAX1,MAXC2,IT1,NSTEPE,
     *MP,IPACAT,IOBS2,IH,IANG,IOBS1,INO,JR,IORDER,ICODE,
     *IB,IA,IC1,IP,ITE,IT,K1,IIE,IIE1,IIP,IIP1,IITE,IITE1,IU,
     *K2,K21,IP1,INUMR,ITIME,ITIME0,IB1,ITE1,
     *N,MMAX,NRE,NR,NCZERO,ICZERO,IOBSR,NIR,IMAX1R,IC11,
     *IC,IU1,MAXC,IEM,INL,NLA,NAI,ICSYSL,NO,NO1,
     *IA1,IKC,NBOLD,IKP,N19,N20,
     *IDIMC,NFILE,IGP,ITCOUN,INV,INN,NUM,K4,K3,ISIZE,MAXBL,
     *NBL,ISZE,NCAT,K2P3,NSTART,
     *NHE,NTABH,NINTH,KEYH,NFU,IOLD,II0,IM6,IM5,IM4,IM3,IM2,IM1,
     *IMX,IZ3,IZ2,IZ1,IS1,ISX,ITX1,ITX,IX,MAXB,NC2,IZ,ICX,NC1,
     *NWRITE,NREAD,NPMAX,IFC,NOBLK,IRECL,J,NB,NI,K,NC,JC,I1,IXY,
     *NBT,ICNEXT,ICC,NCREL,INDEX,ISATP,ISAT,NSTEPN,ND,NBTX,
     *KY,KYR,MAXBL1,I,JJR,JREL,NCC,KYREL,IOBSC,N1C,N11,NJ4,
     *N14,NNEQ,NOBL,JRR,JRR1,JRR2,MMIN,INZOLD,NERRM,ITRACE,
     *ITMODE,ITM0,ITMOD,ITROLD,ITRGAP,ITRACK,ITOLD,NERCOV
C
      LOGICAL LIBM66,LLCOER,LX,LSANEQ,LF,LSMAL,LCTIME,
     *LINTER,LRESOL,LT,LCDC,LUNIX,LIBM77,LICL,LSATP,LREPEC,LGRP,LNGR,
     *LBST,LTABLE,LWRSOL,LGRID,LNEQ,LKM,LCREF,LC2,LC1,LSTNO,
     *LTERMA,LTERMO,LK2EQ4,LINT,LPOTIN,LNUOUT,LTERRC,LNBL1,LSATAC
C
      REAL*8 RCBASE,D0,D1,D2,D3,D4,D5,EE0,AX2,
     *HCZERO,FG,FJ,DSHIF0,DX,DY,DZ,E22,RLONG0,SINLA0,COSLA0,
     *RADSEC,GMP,AX,CM3,CMM2,CM1,OMEGA2,C20IN,SIGMA0,GMC,RE,SSOBS,
     *CX,RLONGP,RLATP,SINLOP,COSLOP,HP,CC,S,AAI,SATROT,
     *C,PREDP,BSIZEE,BSIZEN,STEPE,RLAMIN,RLAMAX,RLOMIN,RLOMAX,
     *RP,FILTER,SAZP,CAZP,CCI,PI,PW,CY,
     *COSLAP,SINLAP,COSSTE,SINSTE,STEPN,COSSTN,SINSTN,SHIFTS,
     *COST2P,SINT2P,SINB,SINT,COST,COSB,G1,G2,SR,AAR,PRETAP,B,WOBS,
     *COSLAT,SINLAT,COSLON,SINLON,RLONG,RLAT,HQ,DOBS,
     *SR11,SR12,SR13,CNR,CCR,BSIZE,CPU2,SYTIME,OLDB,SR22,
     *SINT2Q,COST2Q,SINSQE,COSSQE,STEQE,SINSQN,COSSQN,STEQN,DL,
     *EPS1,EPS2,EPS3,CFA,OLDR,OLDT,SCALE,SCALE2,VARI,SFACT,
     *DXX,SIZEI,TMAX,HTA,RTA,AZ,SZ,CTSF,CTTF,CTA,COSAZ,SINAZ,
     *DC,CCV,HCMAX,SIGMA,GM,CPU3,CNRC,B4,PW0,BB,ROTSAT,CTIME
C
C     PARAMETER (MAXO=16200,NSAT=16200,NPMAX=23900,NCTA=1600,
      PARAMETER (MAXO=16200,NSAT=16200,NPMAX=28920,NCTA=1600,
     *NIPT=1500,NIPCAT=100002,MAXOD=9*MAXO) 
      PARAMETER (NDIMC=399120,NISIZE=880,NCRW=400000,NNBL=20000)
C     PARAMETER (NDIMC=99986000,NISIZE=14000,NCRW=100000000,NNBL=20000)
C MAXO IS USED IN THE COMMON BLOCKS PR AND CPARM AND IN THE DIMENSION
C STATEMENT. 
C
C PARAMETERS GIVING THE SIZE OF THE ARRAYS HOLDING POTENTIAL
C COEFFICIENTS.
C     PARAMETER (NCOEFF=3243602,NROOT=3602,NIICC=1621801,NNSU=18010)
      PARAMETER (NCOEFF=4844402,NROOT=4402,NIICC=2422201,NNSU=22010)
      PARAMETER (NEQFIM=60)
C
      REAL *4 COFF
      LOGICAL HP9000,LOBSST,LSTART,LEQANG,LMEAP1,LMAX1,LCOERR,LRESTA, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOCAL,LSUM ,LNCOL,LMENSI,
     *LNDAT,LTABH,LNEWSO,LNEQ8,LCO1,LTABLR,LK31,LPRED,LPOT,LPARAM,
     *LP,LFIRST,LTRAN,LSTOP,LK30,LNERNO,LOUTC,LPUNCH,LNEWD,LPARER
      CHARACTER*128 DNANE,OLDN,OLDCOV 
C
      COMMON /CON1/OLDN(4)/CON2/GM,RLAMAX,RLOMAX,RLAMIN,RLOMIN,
     *ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN4,LOPEN7,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
C THESE VARIABLES HAVE BEEN PLACED IN COMMON, SO THAT THEY MAY BE
C INITIALIZED BY THE BLOCK DATA MODULE.
C
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
C    *COSAZ(NSAT),SINAZ(NSAT),SINLOP,COSLOP,
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBL,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C IN /PR/ IS STORED: THE CONSTANTS B(I), THE CATALOGUE OF THE OBSER-
C VATIONS (INDEX), LATITUDE, COS AND SIN OF LATITUDE, LONGITUDE AND
C HEIGHT OF OBSERVATION POINTS, THE CORRESPONDING QUANTITIES FOR THE
C PREDICTION POINT. THE LOGICAL VARIABLES ARE USED TO DISTINGUISH
C BETWEEN THE DIFFERENT PREDICTION SITUATIONS. THE COMMON BLOCK IS ALSO
C FOUND IN BLOCK DATA, PRED, OUTSOL AND INSOL. 
C FOR A COMPLETE DESCRIPTION, SEE THE MAIN PROGRAM.
C
      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),SATROT(3,3) 
C 
      COMMON /CMCOV/CCI(24),CCR(56),SIGMA0(2200),SIGMA(2200),HCMAX,
     *CCV(2,2),DC(36),KCI(37),NC1,NC2,LOCAL,LSUM
C COMMON VARIABLES USED IN COVAX.
C
      COMMON /TABELC/CTA(NCTA,16,2),CTTF(800),CTSF(20),SZ(30),AZ(18),
     *MAXB(20),IX(8),ICX,ITX,ITX1,ISX,IS1,IZ,IZ1,IZ2,IZ3,IMX,IM1,
     *IM2,IM3,IM4,IM5,IM6,II0,IOLD
C COMMON VARIABLES USED IN CTABEL AND COVCG.
C
      COMMON /CTABH/RTA(1200),HTA(5),TMAX,SIZEI,NFU(5),KEYH(5,5),
     *NINTH,NTABH(15,5,5),NHE,NSTART,LTABH
C COMMON VARIABLES USED IN INTABH AND TABH.
C
      COMMON/DAT/LNEWD,LRESOL,LGRID
C /DAT/ TRANSFERS LOGICAL VARIABLES TO THE SUBROUTINE ITRAN.
C
      COMMON /NESOL/C(NDIMC),NCAT(NISIZE),ISZE(NISIZE),NBL(NNBL),
     *MAXBL,ISIZE 
C IN /NESOL/ ARE STORED: THE ARRAY C USED TO TRANSFER THE COEFFICIENTS
C OF THE NORMAL EQUATIONS AND THE SOLUTIONS TO AND FROM DISK-STORAGE,
C NCAT, ISZE AND NBL HOLDS INFORMATION ABOUT THE STORAGE SEQUENCE OF THE
C COLUMNS, MAXBL IS THE NUMBER OF BLOCKS OF SIZE C+NCAT+ISZE USED ON THE
C DISK. IQ POINTS ON THE TRACK ON THE DISK AREA IN WHICH DATA IS TO BE
C STORED AND RETRIEVED, IF THE PROGRAM IS RUN UNDER IBM FORTRAN IV,
C CF. THE DEFINE FILE STATEMENT BELOW.
C
      COMMON/NESOL1/NEQFI(NEQFIM,2),NEQFMA,MAXBNE,LNBL1
C
C
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
C IN OUTC ARE STORED SUBSCRIPTS OF VARIABLES TO BE OUTPUT AND LIMITS
C FOR DO-LOOPS IN OUTPUT. NOTE THAT OUTC OCCURS IN SUBROUTINES
C HEAD, COUT, CXPARM AND THE BLOCK DATA MODULE.
C
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
      COMMON /CHEAD1/LC1,LC2,LCREF
C IN /OUTC/ AND /CHEAD/ ARE STORED INFORMATION USED TO HANDLE THE DIF-
C FERENT I/O SITUATIONS.
      COMMON /COM2/DXX,NUM(70),VARI(32),SCALE,SCALE2,INN,INV
C USED BY COMPA, COMPARING OBSERVED AND PREDICTED QUANTITIES.
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C
      COMMON /GPOTC0/C20IN,G1(3),G2(3,3),CM3,CMM2,CM1
      COMMON /GPOTC3/COFF(NCOEFF)
      COMMON/GPOTC1/OLDT,OLDR,CFA,IGP(12),LFIRST,HP9000
C COMMON VARIABLES USED IN GPOTDR, SETCM ,LOADCM, PRED AND CXPARM.
C
      COMMON /GRAVCC/FG(30),FJ(30),LP(2),OMEGA2,IORDER
C COMMON VARIABLES USED IN GRAVC AND RGRAV, HOLDING I.E. COEFFICI-
C ENTS OF LEGENDRE SERIES OF NORMAL POTENTIAL AND NORMAL GRAVITY
C FORMULA.
      COMMON /ITRANC/SINLA0,COSLA0,RLONG0,
     *DX,DY,DZ,EPS3,EPS2,EPS1,DL,AX2,E22
      COMMON /CCOSYS/EE0(3),DSHIF0(7),MODEC0
C
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON/CCTIME/CTIME(NIPCAT),ITRACE(NIPCAT),ITMODE,ITM0,ITMOD,
     *ITRGAP,ITRACK,ITOLD,NERCOV,LCTIME,LCOERR,LLCOER
C SEE SUBROUTINE PARCAT FOR DESCRIPTION OF CPARM. THE COMMON BLOCK
C IS ALSO IN CXPARM AND PRED. ADDED 1997-07-15: ITIME IS ALSO USED
C TO IDENTIFY CORRELATED OBSERVATIONS. IF ITIME(N)=ITIME(M) AND < 0 THEN
C THE OBS N AND M HAVE CORRELATED ERRORS. THE GLOBAL VARIABLE LCOERR MUST
C BE TRUE. 
C
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE  
      COMMON /CMEAQ/STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q 
C STEPSIZES USED WHEN CALCULATING MEAN VALUES.
C
      COMMON /BIPAR/OLDB(4),CNR,GMP,AX,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *LPARAM,LPRED,LNEQ,LNEQ8,LNEWSO,LINT
      COMMON /BIPARC/OLDCOV(2),S,SR,AAI,AAR,NBOLD,IS,IPX,
     *IMAX1,IMAX1R,LTABLE,LTABLR,LCO1
      COMMON /CCOMP/LUNIX,LIBM66,LIBM77,LICL,LCDC 
C DATA USED WHEN STORING SOLUTIONS OR COVARIANCE FUNCTION ON
C BINARY FORM. (CHANGE MADE NOV 1986).
C
      REAL TIMEARRAY(2) 
      DIMENSION BB(MAXO),DNANE(2,NEQFIM),CX(NPMAX),DOBS(MAXOD),B4(4)
      DIMENSION CC(NCRW),ROTSAT(NSAT*6),CY(110) 
C CDC DIMENSION CC(NCRDC)
C
C     EQUIVALENCE (COFF(1),CX(1)),(C(1),CC(1)),(B(1),BB(1)),
      EQUIVALENCE (C(1),CC(1)),(B(1),BB(1)),(SR11(1),ROTSAT(1)),
     *(DOBS(1),B(1))
C 
      LSANEQ=LF
      LRESTA=LF
      IFC=0
      NOBLK=0
C
C *************** INPUT (12) *********************************
C
      IF (LINTER.AND.LRESOL)WRITE(6,*)
C THIS GIVES A POSSIBILITY FOR RESTART FROM ANY OBSERVATION EARLIER
C IN THE SEQUENCE OR FROM TLE LAST OBSERVATION TO BUILD A SOLUTION
C BASED ON MORE DATA.
     *' INPUT LSANEQ, TRUE IF NORMAL EQ. SAVED AND FIRST RED. COLUMN' 
      IF (LRESOL) READ(5,*)LSANEQ,IFC
  216 FORMAT(L2,I7)
      IF (LSANEQ)WRITE(*,*)' SAVED REDUCED COLUMNS = ',IFC
      IF (LRESOL.AND.(.NOT.LSANEQ).AND.N1.EQ.IFC) GO TO 3228
      IF (.NOT.LSANEQ.AND.LRESOL.AND.N1.NE.IFC) IFC=0
C
C ADDED 2000-07-25 BY CCT.
      IF (IFC.LT.0) THEN
       LRESTA=LT
       IFC=-IFC
       WRITE(*,*)' REDUCTION OF NEQ WILL START FROM COLUMN ',IFC
      END IF
C
C CORRECTION 2000.07.01
      LDEFF = LF
      IF (LDEFF) GO TO 2037
      LDEFF = LT
C
C WE NOW DEFINE CERTAIN CONSTANTS USED WHEN TRANSFERRING THE NOR-
C MAL EQUATIONS TO AND FROM DISK STORAGE.
      ISIZE=NISIZE 
C ISIZE IS THE DIMENSION OF THE COLUMN-CATALOGUE IN /NESOL/. 
C
C NT IS THE NUMBER OF RECORDS USED ON THE DISC CORRESPONDING TO
C THE SIZE OF THE BLOCKS HOLDING THE NORMAL EQUATION AND THEIR TWO
C CATALOGUES.
      IF (LCDC.OR.HP9000.OR.LUNIX) NT=1
C     IF (LCDC.OR.HP9000.OR.LUNIX) NT=5
      IF (LIBM66.OR.LIBM77)NT=3
      IF (LICL) NT=26
C NT=3 ON IBM-COMPUTERS IN ORDER TO GET BELOW THE MAXIMAL BUFFER
C SIZE WHICH MAY BE USED.
C IDIMC IS THE SIZE OF THE PART OF THE BLOCK HOLDING THE NORMAL EQ.
      IDIMC=NDIMC 
C     IF (LCDC) IDIMCN=IDIMC+200  
      IF (LICL.OR.HP9000.OR.LUNIX) IDIMCN=(IDIMC+ISIZE)/NT
      IF (LIBM66.OR.LIBM77) IDIMCN=1600
C ON IT IS POSSIBLE TO TRANSFER NT RECORDS TO A
C DIRECT-ACCESS DEVICE AT ONE TIME. THIS MAY BE USED TO SAVE CORE
C BECAUSE IT DECREASES THE SIZE OF THE BUFFER. USE IN THIS CASE
C IDIMCN/NT AS BUFFER-SIZE IN THE DEFINE FILE STATEMENT.
C IN THIS PROGRAM-VERSION, THE ARRAY C HAS DIMENSION IDIMC AND ITS
C VALUES ARE STORED OR RETRIVED FROM UNIT 8 BY NT READ OR WRITE OPERA-
C TIONS, TOGETHER WITH NCAT AND ISZE.
C ON IBM COMPUTERS, THE RECORD LENGTH IS MEASURED IN BYTES, ON MOST
C OTHERS IN WORDS (4 BYTES).
      IF (LIBM77.OR.LUNIX) IRECL=IDIMCN*8
      IF (HP9000) IRECL=IDIMCN*2
      DO 3574, J=1,NEQFMA
      OPEN(NEQFI(J,1),STATUS='UNKNOWN',FILE=DNANE(1,J),
     *ACCESS='DIRECT',FORM='UNFORMATTED',RECL=IRECL)
      WRITE(*,*)' FILE ',NEQFI(J,1),' OPENED FOR NEQ '
 3574 CONTINUE
      WRITE(*,*)NEQFMA,' FILE(S) OPENED FOR NEQ '
C
 2037 CONTINUE
      CALL SETCAT(IFC,NB,LT,LRESTA,LSATAC) 
C NEW VARIABLE LPARER, 2004-06-24. TRUE IF ERROR ESTIMATES
C OF PARAMETERS WILL BE OUTPUT.
      LPARER=LT
      IF (LRESOL.AND.IFC.EQ.N1) GO TO 3228
C
      LPARER=.NOT.(LRESOL.AND.IFC.EQ.(N1-1))
      IF (.NOT.LPARER.AND.LPARAM)
     *WRITE(*,*)' ERROR ESTIMATES OF PARAMETERS NOT OTPUT.'
      IF (MAXBLT.GT.1) WRITE(6,335)MAXBLT
  335 FORMAT(/'  ',I5,' RECORDS USED FOR NORMAL EQUATIONS.'/)
      IF (LONEQ.AND.NB.GT.1)WRITE(6,338)(NBL(J),J=1,NB)
  338 FORMAT(' BLOCK-CATALOGUE:',(10I5/))
C
      IF (LRESTA) GO TO 7475
C
C COMPUTATION OF ELEMENTS OF NORMAL EQUATIONS (EQUAL TO THE COVARIANCE
C BETWEEN THE OBSERVATIONS). THE COEFFICIENTS ARE STORED IN THE ONE-DI-
C MENSIONAL ARRAY C, COLLUMN AFTER COLLUMN,THE DIAGONAL ELEMENT
C HAVING THE HIGHEST SUBSCRIPT.
C
C INITIALIZING VARIABLES:
C NI IS HERE THE SUBSCRIPT OF THE FIRST ELEMENT OF COLUMN NC IN ARRAY
C C. IN THE SUBROUTINE PRED, NI IS THE SUBSCRIPT OF THE ELEMENTS OF THE
C COLUMN. NB  IS THE NUMBER OF THE BLOCK IN WHICH THE COVARIANCES ARE
C STORED AND I1 IS THE NUMBER OF THE LAST COLUMN STORED IN THE BLOCK.
C ICNEXT IS THE NUMBER OF THE FIRST COLUMN WITHIN A GROUP OF DATA WITH
C THE SAME CHARACTERISTICS. (THE CHARACTERISTICS ARE GIVEN BY THE ARRAY
C INDEX (SUBSCRIPTS JC AND JC+1)).
      NI = 1
      K = 1
      NC = 1
      JC = II
      NB=1
      I1=NBL(2)
      IXY=NREAD(CC,1,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
      NBT = 1
      ICNEXT = ISO+1
      ICREL=ISO
C
      DO 3100 IC = 1, IOBS
      LNCOL = NC.LE.IFC
      ICC = IC+ISO
      NCC = NC+ISO-1
      NCREL=MOD(NCC,MAXO)+1
      IF (LOBSST) THEN
       NOBLK=NCC/MAXO+1
       IF (NCREL.EQ.1.OR.IC.EQ.1) THEN 
C     WRITE(6,*)'BLK ',NOBLK,' 17 READ FOR TRANSFER B TO C.'
        READ(16,REC=NOBLK)DOBS
        IF (LSATAC) READ(14,REC=NOBLK)ROTSAT
        IF (NOBLK.LT.0)
     *  WRITE(6,*)'BLK ',NOBLK,' 18 READ FOR TRANSFER B TO C.'
        IF (IC.EQ.1.AND.ISO.NE.0) THEN
         ICREL=MOD(ISO,MAXO)
        ELSE
         ICREL=0
        END IF 
       END IF
      END IF
      ICREL=ICREL+1
C
      IF(ICC .NE. ICNEXT)GO TO 3003
      IKP = INDEX(JC+1)
C INITIALIZATION OF VARIABLES IN COMMON BLOCK /PR/.
      IF (IKP.LT.100) KCI(6)=IKC(IKP)
      ICNEXT = INDEX(JC)
      ISATP=ISAT(JC) 
      LSATP=ISATP.GT.0 
      BSIZEN=BSIZE(JC)
      LMENSI=ABS(BSIZEN).GT.1.0D-6
      LMEAP1=BSIZEN.LT.D0.AND.LMENSI 
C
      IF (LMENSI) THEN      
       IF (LMEAP1) THEN
        NSTEPN=NFILTE
        SHIFTS=ABS(BSIZEN)*(NSTEPN-1)/2
        COST2P=COS(SHIFTS) 
        SINT2P=SIN(SHIFTS) 
       ELSE
        NSTEPN=5
       END IF 
       NSTEPE=5
       BSIZEE=BSIZE(JC+1)
       LEQANG=BSIZEE.GT.1.0D-6
       STEPE=D0 
       CALL ICMEAN(
     * ABS(BSIZEN),STEPN,NSTEPN,COSSTN,SINSTN,D1,D0,LT,LF)
       IF (LEQANG)CALL ICMEAN(
     * BSIZEE,STEPE,NSTEPE,COSSTE,SINSTE,D1,D0,LT,LF)
      ELSE
       STEPE=D1
      END IF
C
      JC = JC+2
      LREPEC = IKP .EQ. 5 .OR.(IKP.GT.25.AND.IKP.LT.36)
      LONECO = .NOT.LREPEC
      LGRP = IKP.EQ.2.OR.IKP.EQ.13
      LNGR = .NOT.LGRP
      LNKSIP = LONECO.AND.IKP.NE.3.AND.IKP.NE.16.AND.IKP.NE.18
     *         .AND.IKP.NE.20.AND.IKP.NE.25.AND.IKP.NE.22 
      LNETAP = LONECO.AND.IKP.NE.4.AND.IKP.NE.17.AND.IKP.NE.19
     *         .AND.IKP.NE.21.AND.IKP.NE.23.AND.IKP.NE.24
      LDEFVP = .NOT.LNKSIP.OR.(.NOT.LNETAP)
C
 3003 LBST=LREPEC.AND.(NC.EQ.I1)
C
C IF LNCOL IS FALSE WILL PRED IN MOST CASES NOT BE CALLED. HENCE,
C WE MUST 'EXTERNALLY' UPDATE THE VALUE OF NI, WHICH OTHERWISE
C POINTS AT THE ELEMENT IN C, WHERE THE COVARIANCE IS STORED.
C
      IF (LNCOL) NI = NI+NC
      IF (IKP.GE.100) GO TO 3031
      IF (LNCOL.AND.LONECO) GO TO 3020
      IF (.NOT.LNCOL.OR.NC.NE.IFC) GO TO 3032
      LNCOL=LF
      NI=NI-NC
      IFC=IFC-1
      WRITE(6,337)IFC
  337 FORMAT(' **** WARNING ****  IFC DECREASED TO',I5)
 3032 IF (LNCOL) GO TO 3019
C
      COSLAP = COSLAT(ICREL)
      SINLAP = SINLAT(ICREL)
      COSLOP = COSLON(ICREL)
      SINLOP = SINLON(ICREL)
      RLONGP = RLONG(ICREL)
      RLATP  = RLAT(ICREL)
      HP = HQ(ICREL)
      IF (.NOT.LSATP) GO TO 3033
      IF (ISATP.EQ.1) THEN 
       CAZP=COSAZ(ICREL)
       SAZP=SINAZ(ICREL) 
      ELSE
C MODIF. 1991.06.08 TO ENABLE FULL ROTATION. 
       COSB=SR11(ICREL)
       SINB=SR12(ICREL)
       COST=SR13(ICREL)
       SINT=SR22(ICREL) 
       CAZP=COSAZ(ICREL)
       SAZP=SINAZ(ICREL) 
C ADDITION 2002-09-27.
       SATROT(1,1) =  SAZP*COSB 
       SATROT(1,2) =  CAZP*COST+SAZP*SINB*SINT 
       SATROT(1,3) = -CAZP*SINT+COST*SAZP*SINB 
       SATROT(2,1) = -CAZP*COSB 
       SATROT(2,2) =  SAZP*COST-SINT*CAZP*SINB 
       SATROT(2,3) = -SAZP*SINT-COST*CAZP*SINB 
       SATROT(3,1) = -SINB                     
       SATROT(3,2) =  COSB*SINT                   
       SATROT(3,3) =  COST*COSB 
      END IF 
 3033 IF (LMENSI.AND.(.NOT.LEQANG).AND.(.NOT.LMEAP1))CALL
     *ICMEAN(BSIZEN,STEPE,NSTEPE,COSSTE,SINSTE,COSLAP,SINLAP,LF,LF)
      IF (LMEAP1) THEN
       STEPE=-D1
       COSSTE=COSAZ(ICC)
       SINSTE=SINAZ(ICC) 
      END IF 
      GO TO 3001
 3031 IKP = 100+K
      K = K+1
      IF (LNCOL) GO TO 3020
C AS WE FOR LREPEC=TRUE ARE COMPUTING TWO COLUMNS AT THE SAME TIME, WE
C MUST, IN CASE THE SECOND COLUMN IS THE FIRST ONE IN THE NEXT RECORD
C STORE THIS ONE TEMPORARY IN ARRAY B. THE PROBLEM WILL ONLY OCCUR WHEN
C WE ARE SETTING UP THE NORMALEQUATIONS. LBST = B-STORE.
C
 3001 CALL PRED(S,AAI,IS,IPX,ISO,II,IC,NC,IMAX1,LF,LBST,LT,LTABLE,
     *LTCOV,LSATAC)
C
      ND = NI-1
C TRANSFER OF DIAGONAL ELEMENTSARE NOW IN PRED. 1992.07.21.
C     DIA = C(ND)
C     IF (LE.AND.IKP.LE.36) C(ND) = DIA+WOBS(NRREL)**2
      IF (LONECO) GO TO 3020
C     IF (LE.AND.IKP.LE.36) DIA = DIA+WOBS(NRREL)**2
C     IF (LBST) B(NCREL) = DIA
C     IF (.NOT.LBST) C(NI+NC) = DIA
C THE PRECEDING STATEMENT ASSURES, THAT THE DIAGONAL ELEMENT CORRESPON-
C DING TO ETAP BECOMES EQUAL TO THAT OF KSIP. CH 1992.07.19.
 3019 NC = NC+1
      NI = NI+NC
C
 3020 IF (NC.LT.I1.AND.NC.LT.N) GO TO 3100
C IN VERSIONS EARLIER THAN MAY 1, 1986, AN ERROR COULD OCCUR HERE,
C BECAUSE THE LAST COLUMN WAS NOT ASSIGNED TO C(KY) WHEN LBST WAS
C TRUE SIMULTANEOUSLY.
C
C STORING THE COEFFICIENTS OF THE NORMAL-EQ., RECORD NB.
 3261 IF (.NOT.LNCOL) THEN
       NBTX=NWRITE(NFILE,CC,NBT,NT,IDIMCN)
       IF (MOD(NBT,NT*100).EQ.0) WRITE(*,*)NBT,' BLOCKS WRITTEN '
      END IF
      NBT=NBT+NT
      IF ((.NOT.LONEQ).OR.LNCOL) GO TO 3200
C
C OUTPUT OF COEFFICIENTS OF NORMAL-EQUATIONS.
      WRITE(6,380)NB
  380 FORMAT(/' COEFFICIENTS OF NORMAL-EQUATIONS, BLOCK ',I4,/
     *' (FIRST 200 ELEMENTS AND LAST FULL BLOCK)')
      I1 = NI-1
      IF (LBST) I1 = ND
      I1=200
      IF (NB.EQ.MAXBL) I1 = MAXC2
C
      LMAX1=LF
      DO 1381, KY=1,I1
 1381 LMAX1=LMAX1.OR.(ABS(C(KY)).GT.1.0D0)
      IF (LMAX1) THEN 
       WRITE(6,381)(C(KY), KY = 1, I1)
  381  FORMAT(' ',4F15.7)
      ELSE
C NEW OUTPUT-FEATURE ADDED 1995.11.21 BY CCT.
       WRITE(6,1382)(C(KY), KY = 1, I1)
 1382  FORMAT(' ',10F7.5)
      END IF

 3200 NB=NB+1
      NI=1
      IF (NC.NE.N) I1 = NBL(NB+1)
      IF (NB.GT.MAXBL) GO TO 3201
      IXY=NREAD(CC,NBT,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
C WE HAVE TO READ THE WHOLE CONTENT OF BLOCK NB INTO ARRAY C, BECAUSE
C WE MUST BE SURE THAT THE RIGHT-HAND SIDE (WHICH ALREADY IS STORED)
C IS PLACED CORRECTLY.
C
 3201 IF (.NOT.LBST) GO TO 3100
C
      IF (LNCOL) GO TO 3203
      DO 3202 KY=1,NC
      KYR=KY+ISO-1
      KYREL=MOD(KYR,MAXO)+1 
      IF (LOBSST) THEN
       NOBLK=KYR/MAXO+1
C     WRITE(*,*)' KY,KYR,ISO,MAXO ',KY,KYR,ISO,MAXO
       IF (KYREL.EQ.1.OR.KY.EQ.1) THEN 
C     WRITE(6,*)'BLK ',NOBLK,' 1 READ FOR TRANSFER B TO C.'
        READ(16,REC=NOBLK)DOBS
        IF (LSATAC) READ(14,REC=NOBLK)ROTSAT
C     WRITE(6,*)'BLK ',NOBLK,' 2 READ FOR TRANSFER B TO C.'
       END IF
      END IF
 3202 C(KY) = B(KYREL)
C 
 3203 NI = NC+1
C ERROR CORRECTED 1987.10.03. NI WAS EARLIER NOT UPDATED FOR LNCOL=LT.
      IF (NC.NE.N) GO TO 3100
      LBST=LF
      WRITE(6,383) NB
  383 FORMAT(' LAST COLUMN IS FIRST LOGICAL COLUMN IN BLOCK ',I4)
      GO TO 3261
C
 3100 NC = NC+1
C END OF LOOP FORMING NORMAL-EQUATIONS.
C
 7475 IF (LTIME) THEN
       CPU3=SYTIME(RCBASE,TIMEARRAY) 
       WRITE(6,7470)TIMEARRAY(1),CPU3
      END IF 
 7470 FORMAT(' TIME USED=',F12.5,' SEC, ELAPSED TIME=',F12.5,' SEC')
C
      LNBL1=LF
      CALL NES(N1,IFC,0,N1-NPARM1,.TRUE.,PW,NT,IDIMCN,LT,NERRM,
     *1)
C
      IF (LWRSOL) THEN
C PUNCHING: NUMBER OF OBSERVATION POINTS, NUMBER OF OBSERVATIONS, DIF-
C FERENCE BETWEEN SQUARESUM OF OBSERVATIONS AND NORM OF APPROXIMATION,
C A CHECK-NUMBER (KEE) CNR, AND FINALLY THE SOLUTIONS AND THE SQUARE-SUM
C OF THE OBSERVATIONS. CHANGE 2000-10-03.
       WRITE(17,361)IOBS,N1,MAXC,MAXBL,MAXBLT,PW,CNR
  361  FORMAT(5I6,2D15.7)
       WRITE(17,364)(C(J+MAXC),J=1,N1)
       MAXBL1=MAXBL+1
       WRITE(17,363)(NBL(I),I=1,MAXBL1)
  363  FORMAT(10I7)
      END IF
C
      DO 3300 J = 1, N1
       JJR=J+ISO-1
       JREL=MOD(JJR,MAXO)+1
       IF (LOBSST) THEN
        NOBLK=JJR/MAXO+1
        IF (JREL.EQ.1.OR.J.EQ.1) THEN
C       WRITE(6,*)'BLK ',NOBLK,' 3 READ FOR TRANSFER B TO C.'
         READ(16,REC=NOBLK)DOBS
         IF (LSATAC) READ(14,REC=NOBLK)ROTSAT
C       WRITE(6,*)'BLK ',NOBLK,' 4 READ FOR TRANSFER B TO C.'
        END IF
       END IF 
       B(JREL) = C(J+MAXC)
C3300 CONTINUE ERROR 2000-06-25.
       IF (LOBSST.AND.(JREL.EQ.MAXO.OR.J.EQ.N1)) THEN
        WRITE(16,REC=NOBLK)DOBS
        IF (LSATAC) WRITE(14,REC=NOBLK)ROTSAT
        WRITE(*,*)' 1 BLOCK ',NOBLK,' WRITTEN '
       END IF
C TRANSFERRING THE SOLUTIONS TO THE ARRAY B.
 3300 CONTINUE
      LRESOL=LF
      LNCOL=LF
C
      GO TO 3229
C
C *************** INPUT (13) *********************************
C
C INPUT OF SOLUTIONS.
 3228 MAXC = 0
      IF (LINTER)WRITE(6,*)' INPUT SOLUTION' 
       READ(5,361)IOBSC,N1C,MAXC,MAXBL,MAXBLT,PW,CNRC
       N11=N1-1
C  NJ4 IS NUMBER OF ELEMENTS ON ONE LINE (RECORD), AND N14 IS
C NUMBER OF LINES IN ASCII_FILE USED TO HOLD SOLUTIONS (RESTART FILE).
       NJ4=4
       N14=N11/NJ4+1
       NREL=MOD(ISO,MAXO) 
C     WRITE(*,*)' N1,N14,NJ4 ',N1,N14,NJ4
       IF (LOBSST) NOBLK=ISO/MAXO+1
       DO 3364, J=1,N14
        IF (J.EQ.N14)NJ4=MOD(N11,NJ4)+1
        READ(5,364)(B4(I),I=1,NJ4)
  364   FORMAT(4D16.9)
        DO 3365, I=1,NJ4
         NREL=NREL+1
C CORRECTION 2000-10-06.
         IF (LOBSST.AND.NREL.EQ.1) THEN
C         WRITE(6,*)'BLK ',NOBLK,' 8 READ, J,NREL= ',J,NREL 
          READ(16,REC=NOBLK)DOBS
          IF (LSATAC) READ(14,REC=NOBLK)ROTSAT
C         WRITE(6,*)'BLK ',NOBLK,' 9 READ.'
C         NREL=1
         END IF
C
         B(NREL)=B4(I)
         IF (LOBSST.AND.(NREL.EQ.MAXO.OR.(J.EQ.N14.AND.NJ4.EQ.I))) THEN
          WRITE(16,REC=NOBLK)DOBS 
          IF (LSATAC) WRITE(14,REC=NOBLK)ROTSAT
C         WRITE(*,*)' 2 BLOCK ',NOBLK,' WRITTEN, J,NREL= ',J,NREL
          NREL=0
          NOBLK=NOBLK+1
         END IF
 3365   CONTINUE 
 3364  CONTINUE  
C
      MAXBL1=MAXBL+1
      READ(5,363)(NBL(J),J=1,MAXBL1)
      IF (.NOT.LSANEQ) GO TO 3227
      IYX=NREAD(CC,MAXBLT,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
C
C CHECK OF SOLUTIONS CORRESPOND TO OBSERVATIONS( CHANGED 1993.06.16 CCT).
 3227 IF (IOBS.EQ.IOBSC.AND.N1.EQ.N1C.AND.
     *ABS((CNRC-CNR)/CNRC).LT.0.1D-4) GO TO 3229
      WRITE(6,354)IOBS,I,N1,N1C,CNRC,CNR
  354 FORMAT(' SOLUTIONS DO NOT CORRESPOND TO INPUT DATA, STOP.',
     */,4I4,2E15.7)
      STOP       
 3229 WRITE(6,300)
  300 FORMAT(/' SOLUTIONS TO NORMAL EQUATIONS:'/)
      NNEQ=N
C     IF (LRESOL.AND.N.GT.20) THEN    - CHANGED 2000.01.14.
      IF (N.GT.NNEQ.AND.NPARM.EQ.0) THEN
       NOBL=MAXBL1
      END IF
      JRR=ISO
      IF (LOBSST) THEN
       NOBLK=JRR/MAXO+1
      ELSE
C CHANGE 2003-12-29.
       NOBLK=1
      END IF
      JRR1=MOD(JRR,MAXO)+1
      JRR2=MAXO
C CHANGE (+1) 2004-06-24.
 3239 IF (NOBLK.EQ.NOBL+1) JRR2=MOD(NNEQ+ISO,MAXO)
C     WRITE(*,*)' JRR2 ',JRR2,NNEQ,ISO,MAXO,NOBLK,NOBL
      IF (LOBSST) THEN
C LOBSST IS TRUE WHEN OBSERVATIONS HAVE BEEN STORED IN A FILE.
      WRITE(6,*)'BLK ',NOBLK,' 10 READ FOR TRANSFER B TO C.'
       READ(16,REC=NOBLK)DOBS
       IF (LSATAC) READ(14,REC=NOBLK)ROTSAT
       IF (NOBLK.LT.5)
     * WRITE(6,*)'BLK ',NOBLK,' 11 READ FOR TRANSFER B TO C.'
      END IF
      IF (LONEQ) THEN
C      WRITE(*,*)JRR1,JRR2
       WRITE(6,301)(B(J), J = JRR1, JRR2)
      ELSE
C CHANGE 2002-07-17.
       IF (NOBLK.EQ.1) THEN
        WRITE(*,305)20    
  305   FORMAT(' ONLY FIRST',I5,' SOLUTIONS OUTPUT.')
        NREL=MOD(ISO,MAXO) 
        WRITE(6,301)(B(J+NREL), J = 1,20)       
       END IF
      END IF
C CHANGE 2003-12-29.
      NOBLK=NOBLK+1
C      
      JRR1=1
  301 FORMAT(1X,4E16.9)
      IF (NOBLK.LE.NOBL.AND.NPARM.NE.0) GO TO 3239
C 
      IF (NPARM.GT.0.AND.LONEQ) WRITE(6,382)NPARM
  382 FORMAT(' LAST ',I3,' ELEMENTS OF SOLUTION VECTOR',/,
     *' ARE THE VALUES OF THE ESTIMATED PARAMETERS'/)
      IF (LRESOL) WRITE(6,362)
  362 FORMAT(/' THE SOLUTIONS HAVE BEEN COMPUTED IN A PREVIOUS RUN.')
C
      MAXC2 = MAXC+N1
      WRITE(6,353)N,SSOBS,PW
  353 FORMAT(/' NUMBER OF EQUATIONS =',I7,/
     *' NORMALIZED SQUARE-SUM OF OBSERVATIONS        =',E13.6,/,
     *' NORMALIZED DIFFERENCE BETWEEN SQUARE-SUM OF'/
     *' OBSERVATIONS AND NORM OF APPROXIMATION       =',E13.6,/)
C
      IF (LTIME) THEN
       CPU2=SYTIME(RCBASE,TIMEARRAY) 
       WRITE(6,7470)TIMEARRAY(1),CPU2
      END IF 
C
      IF (LNDAT.OR.LRESOL.OR.NPARM.EQ.0) GO TO 5230
C OUTPUT OF EXX = (AT*C**-1*A)**-1, OR PARTS, IF NPARM .GT. 6.
      LX = NPARM.LT.7 .OR. LONEQ
      IF (LX) WRITE(6,371)
      JI=0
  371 FORMAT(' ELEMENTS OF (AT*C**-1*A)**-1.')
      IF (LPARER) THEN
       IF (LIBM77.OR.LUNIX) THEN 
        N19=(N+1)*8
       ELSE
        N19=(N+1)*2
       END IF
       IF (.NOT.LX) OPEN(19,ACCESS='DIRECT',FORM='UNFORMATTED',
     * FILE='DCOVA.BIN',RECL=N19) 
       DO I = 1, NPARM
        DO J = 1, N1
        C(MAXC+J) = D0
        END DO
        C(MAXC2-NPARM1+I) = D1
        IF (.NOT.LX) THEN
         WRITE(19,REC=I)(C(J+MAXC),J=1,N1)
         N20=NPARM
        ELSE
         IXY=NWRITE(NFILE,CC,MAXBLT,NT,IDIMCN)
         N20=1
        END IF
        IF (I.EQ.NPARM.OR.LX) THEN
         CALL NES(N1,N,0,N1-NPARM1,LX,PW0,NT,IDIMCN,LF,NERRM,
     *   N20)
         MMIN=MAXC2-NPARM
         MMAX=MAXC2-1
C
         DO J=1,N20     
C WHEN LX IS FALSE, ALL ERROR ESTIMATES ARE COMPUTED IN ONE CALL OF NES:
          IF (.NOT.LX) THEN
           READ(19,REC=J)(C(N19+MAXC),N19=1,N1)
           CX(J) = -C(MAXC+N1)
          ELSE
           CX(I)=-PW0
          END IF
          IF (LX) THEN
           LSMAL=LF
           DO K=MMIN,MMAX
            LSMAL=LSMAL.OR.ABS(C(K)).LT.1.0D-3
            JI=JI+1
            CY(JI)=C(K)
           END DO
           IF (LSMAL) THEN
            WRITE(6,370)(C(K),K=MMIN,MMAX)
  370       FORMAT(6D12.5)
           ELSE
            WRITE(6,372)(C(K),K=MMIN,MMAX)
  372       FORMAT(6F10.4)
           END IF
          END IF
         END DO
C          
        END IF
       END DO
       IF (.NOT.LX) CLOSE(19)
      END IF
C END CALCULATION OF ERROR ESTIMATES OF PARAMETERS.
C OUTPUT OF CORRELATIONS.
      IF (LX) THEN
       WRITE(*,*)' CORRELATION MATRIX: '
       DO I=1,NPARM
C STANDARD DEVIATIONS.
        CY(100+I)=SQRT(CY(NPARM*(I-1)+I))
       END DO
       JI=0
       DO I=1,NPARM
        DO J=1,NPARM
C CORRELATIONS.
         JI=JI+1
         CY(JI)=CY(JI)/(CY(100+I)*CY(100+J))
        END DO
        WRITE(*,372)(CY(J),J=JI-NPARM+1,JI)
       END DO
      END IF

C
      IF (.NOT.LPARER) THEN
       WRITE(*,373) 
  373  FORMAT(' PARAMETER    TYPE     ESTIMATE ') 
      ELSE
       WRITE(6,374)
  374  FORMAT(' PARAMETER    TYPE    ',
     * ' ESTIMATE       ERROR ESTIMATE (FOR TILT: ZERO POINT ') 
      END IF
C CHANGES - LPARER - 2004-06-24.
      DO 5234 I=1,NPARM
      IF (CX(I).GT.D0.AND.LPARER) CX(I)= SQRT(CX(I)) 
C CORRECTION 1992.07.21. 
      NRE=I+ISO+NNEQ-NPARM-1 
      NREL=MOD(NRE,MAXO)+1
      IF (LOBSST) THEN
       NOBLK=NRE/MAXO+1
       IF (I.EQ.1.OR.NREL.EQ.1) THEN
C     WRITE(6,*)'BLK ',NOBLK,' 12 READ FOR TRANSFER B TO C.'
        READ(16,REC=NOBLK)DOBS
        IF (LSATAC) READ(14,REC=NOBLK)ROTSAT
C     WRITE(6,*)'BLK ',NOBLK,' 13 READ FOR TRANSFER B TO C.'
       END IF
      END IF
      IF (LPARER) THEN
       IF (IPTYPE(I).GT.0) THEN
        WRITE(6,375)I,IPTYPE(I),B(NREL),CX(I)
       ELSE
C CHANGE 2005-11-09. ITIME0(I+1) -> ITIME0(I-1).
        WRITE(6,375)I,IPTYPE(I),B(NREL),CX(I),ITIME0(I-1)
       END IF
      ELSE
       WRITE(6,375)I,IPTYPE(I),B(NREL)
      END IF
 5234 CONTINUE
C CHANGE 2004-09-16.
  375 FORMAT(2I12,2F15.9,I12)
C
 5230 WRITE(*,*)' NUMBER OF BLOCKS USED = ',MAXBL
      LNBL1=MAXBL.EQ.1.AND.(.NOT.LRESOL)
      RETURN
      END
      BLOCK DATA
C PROGRAMMED BY C.C.TSCHERNING, GEODETIC INSTITUTE, 1974.
C UPDATED: 2008-07-07 BY CCT. 
C THE SUBROUTINE INITIALIZES A NUMBER OF VARIABLES. IT MAY BE
C SUBSTITUTED BY A "BLOCK DATA" CALL ON OTHER COMPUTERS.
C ON ICL-COMPUTERS, IT MUST HAVE A NAME, AND BE DECLARED AS
C AN EXTERNAL.
C
      IMPLICIT NONE
      INTEGER MAXO,NSAT,NCTA,MXPAR,NIPT,NIPCAT,MAXOD
     *,KCI,NC1,NC2,NFU,KEYH,NINTH,NTABH,NHE,IOBS2,NSTART,KSAT,
     *NDX1,NDX2,I4,NDP,IPACAT,NDQ,IT,K3,K4,NUM,INN,ITCOUN,
     *IGP,NBOLD,NWAR,IA1,IKP,IU1,IC11,IMAX1,IMAX1R,INV,ITE1,
     *ITIME0,KK,ITIME,INUMR,IP1,K21,K2,IU,IITE1,IITE,IIP1,IIP,IIE,
     *IIE1,K2P3,IT1,ITE,IP,IC1,IA,IB,NNX,NTABX,IFQ,ISATP,ISAT,
     *IHQ,IHP,INDEX,NR,NI,ICZERO,J2,K8,INZOLD,IEM,K21X,INL,K17,NAI,
     *K15,ICSYSL,K11,NO1,K9,K7,NO,IOBS1,IANG,IH,MP,IPAR,IFP,
     *KFQ,JR,NOBLK,IXX,K13,K19,NCZERO,NLA,INO,IB1,ISO,IPX,IS,
     *JJORD,IIDEG,K1,IPTYPE,K23,I3,IPA,KFP,NPARM,NPARM1,MAXPAR,
     *II,NMAX,MAXB,IX,NCXLAS,ICODE,ITRACE,ITMODE,ITM0,ITMOD,ITROLD,
     *ITRGAP,ITRACK,ITOLD,NERCOV
C
      REAL*8 GM,RLOMAX,RLAMAX,RLOMIN,RLAMIN,B,HQ,RLAT,
     *SINLAT,COSLAT,RLONG,SINLON,COSLON,WOBS,SINLOP,SFACT,
     *COSLOP,BSIZE,BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP, 
     *CCI,CCR,SIGMA0,SIGMA,HCMAX,CCV,D,OBS,OLDR,SLOQ,CFX,
     *RE,BIPC,CRHT,PREDP,HP,RLATP,BIP,HQOLD,C11,CTA,CTTF,CTSF,
     *SZ,AZ,HTA,TMAX,SIZEI,COVX,CIX,SLOP,D2,CLOP,CLOQ,GMC,PI,DXX,HCZERO,
     *VARI,DGPM2,SCALE,SCALE2,DRAPP,OLDT,RADSEC,CFA,SIGMAP,HPOLD,
     *D5,D0,D1,D3,D4,PRETAP,CTIME

      PARAMETER (MAXO=16200,NSAT=16200,NCTA=1600,MXPAR=2500,NIPT=1500,
     *NIPCAT=100002,MAXOD=9*MAXO) 
C
      LOGICAL L,LN,LOPEN7,LONECO,LNKSIP,LNETAP,LDEFVP,LSTOP,LRESOL,
     *LC1,LC2,LCREF,LKM,LNEQ,LT,LPOSDA,LDEFF,LF,LGRID,LERNO,
     *LDENOL,LNEWD,LPUNCH,LOUTC,LNERNO,LK30,LK31,LIN4,LOPCOF,LCLU7,
     *LFIRST,LSUM,LOCAL,LWRSOL,LPOT,LMDD,LCOMP,LCOM,LWLONG,LPRED,
     *LPARAM,LTERRC,LPOTIN,LK2EQ4,LNUOUT,LTABLE,LTABLR,LNEQ8,LNEWSO,
     *LINT,LTERMA,LTERMO,LTERM,LCO1,LBIPOT,LBICOV,LBISOL,LINSOL,
     *HP9000,LOPEN4,LTABH,LTIME,LTCOV,LONEQ,LX,LNX,LTESTS,LOBSST 
     *,LCOERR,LSPOUT,LTRAN,LLCOER,LCTIME,LSTART
C
      CHARACTER*128 OLDN,OLDCOV 
      COMMON /CON1/OLDN(4)/CON2/GM,RLOMAX,RLAMAX,RLOMIN,RLAMIN,
     *ICSYSL,NO,NAI,NLA,INL,IEM,INZOLD, 
     *LPOSDA,LDEFF,LERNO,LCOMP,LCOM,LWLONG,
     *LDENOL,LMDD,LIN4,LOPCOF,LCLU7,LOPEN7,LOPEN4,
     *LBIPOT,LBICOV,LBISOL,LINSOL,LTIME,LTCOV,LONEQ
C
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),
     *SINLAT(MAXO),COSLAT(MAXO),RLONG(MAXO),
     *SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
C    *COSAZ(NSAT),SINAZ(NSAT),SINLOP,COSLOP,BSIZE(42),BSIZEN,BSIZEE,
     *SINLOP,COSLOP,BSIZE(42),BSIZEN,BSIZEE,
     *COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP, 
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART 
C FOR A COMPLETE DESCRIPTION, SEE THE MAIN PROGRAM.
C
      COMMON /CMCOV/CCI(24),CCR(56),SIGMA0(2200),SIGMA(2200),HCMAX,
     *CCV(2,2),D(36),KCI(37),NC1,NC2,LOCAL,LSUM
      COMMON /DDX/K7(17),K9(17),K11(17),K13(17),K15(17),K17(17),
     *K19(17),K21X(17),K23(17),K8(17),C11(17),J2(2),I3(2),I4(2),
     *LN(7),L(7)
C
      COMMON /TABELC/CTA(NCTA,16,2),CTTF(800),CTSF(20),SZ(30),AZ(18),
     *MAXB(20),IX(8),IXX(18)
      COMMON /CTABH/DRAPP(181),DGPM2(201),CRHT(818),HTA(5),TMAX,
     *SIZEI,NFU(5),KEYH(5,5),NINTH,NTABH(15,5,5),NHE,NSTART,LTABH
      COMMON /CTABH1/HPOLD,HQOLD,IHP,IHQ,KFP,KFQ,IFP,IFQ,NTABX,NNX
C
      COMMON/DAT/LNEWD,LRESOL,LGRID
C
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LTERM,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT,LKM,LTERRC,LPOTIN
      COMMON /CHEAD1/LC1,LC2,LCREF
      COMMON /COM2/DXX,NUM(70),VARI(32),SCALE,SCALE2,INN,INV
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C
      COMMON /GPOTC1/OLDT,OLDR,CFA,IGP(12),LFIRST,HP9000
      COMMON /OBSER/OBS(22)
C
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON/CCTIME/CTIME(NIPCAT),ITRACE(NIPCAT),ITMODE,ITM0,ITMOD,
     *ITRGAP,ITRACK,ITOLD,NERCOV,LCTIME,LCOERR,LLCOER
C
      COMMON /CCVCG/KK(24)
C
      COMMON /BIPAR/BIP(7),NMAX,II,IPAR(13),JR,ISO,LPARAM,LPRED,
     *LNEQ,LNEQ8,LNEWSO,LINT
      COMMON /BIPARC/OLDCOV(2),BIPC(4),NBOLD,IS,IPX,IMAX1,IMAX1R,LTABLE,
     *LTABLR,LCO1
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFX,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP,NDQ,NWAR,LX(7,5),LNX(7,5),LTESTS 
      COMMON /PDEGV/SIGMAP(2200),SLOP,SLOQ,CLOP,CLOQ,
     *IIDEG,JJORD,LSPOUT
C
C ADDED 2005-03-23.
      DATA ITRACE/NIPCAT*1/
C KSAT HOLDS THE MAPPING BETWEEN THE DATA CODES AND THE POSITIONS
C IN THE ARRAY COVCX HOLDING THE COVARIANCES. SEE SUBROUTINE COVCX.
      DATA KSAT/
     *1,3,3,3,3,2,1,2,1,2,1,2,1,1,1,1,1,
     *1,1,1,3,3,1,1,1,1,3,3,2,2,1,1,1,1/
      DATA KK,KFP,HPOLD,HQOLD/1,5,2,5,5,3,4,9*5,1,3,9,11,0,1,4,5,
     *-1,2*-1.0D5/,KCI(26),KCI(27),KCI(28),KCI(29),KCI(30),KCI(31),
     *KCI(32),KCI(33),CCI(14)/1,0,1,0,2,0,-1,1,0.5/
     *,KCI(35),KCI(36),KCI(37)/3*0/
C INITIALIZING FOR DENSITY CONTRAST COMPUTATION.
C
      DATA
     *K7/5*0,6*1,4*2,2*0/,K9/5*1,2,3,2,3,2,3,2,2,3,4,2*0
     */,K11/11*0,2,3,3,6,2*0/,
     *K13/11*1,2,3,3,6,2*0/,K15/0,1,-1,-1,1,0,0,-1,-1,2,2,6*0/,
     *K17/3*0,2,2,12*0/,K19/1,4*0,1,1,10*0/,K21X/0,1,1,2,2,1,1,10*2/,
     *K23/5*1,2,1,2,1,2,1,1,1,2,2,0,0/,
     *K8/0,1,1,2,2,0,0,4*1,6*0/,C11,
     *HCMAX/1.0D0,2*1.0D5,2*1.0D9,2*-206264.806D0,5*1.0D9,2.0D9,
     *2*1.0D9,2*1.0D0,1.0D9
     */,D,BIP,BIPC/47*0.0D0/,J2/3,2/,I3/6,3/,I4/4,2/
C
      DATA RE,GMC,D1,D2,D3,D4,D5,
     *D0,BSIZE,SIGMA,SIGMA0,OLDT,OLDR,PREDP,PRETAP,OBS,
     *RADSEC,PI/6371.0D3,3.98D14,1.0D0,2.0D0,3.0D0,4.0D0,
     *5.0D0,4469*0.0D0,206264.806D0,3.1415926535D0/,LT,LNEQ,LSPOUT,
     *LCO1,LNERNO,LWRSOL,LBIPOT,LBICOV,LBISOL,LINSOL,LTABH,
     *LDENOL,LPOSDA,LFIRST,LCREF,LC1,LC2,LDEFF,LMDD,LIN4,LOPCOF,
     *LF,LGRID,LERNO,LCOMP,LCOM,LWLONG,LPRED,LCLU7,LOPEN7,LRESOL
     *,LTIME,LTCOV,LONEQ 
     *,LTERRC,LTABLE,LTABLR,LNEQ8,LOPEN4/5*.TRUE.,34*.FALSE./,RLAMAX,
     *RLOMAX,RLAMIN,RLOMIN,HCZERO,ICSYSL,NCZERO/4*0.0D0,-3.0D8,-2,-1/,
     *ITCOUN,IPAR,NBOLD,ITE,ITE1,INZOLD, 
     *IX,NPARM,NO,NAI,NLA,IS,ISO,IGP,IT,IP,INDEX(1),INDEX(2),
     *IA,IA1,INL,IEM,II,JR,NPARM1/48*0,2*9,10,25,2*2,1/
     *,IXX,IPX,NWAR/0,0,1,0,1,0,1,2,3,0,1,2,3,4,5,6,0,-2,-1,0/
C THE FACTOR MUST BE 2*NIPT.
C CHANGE 2002-02-05. DIMENSION OF ITIME NOW NIPCAT.
      DATA IPTYPE,ITIME0/NIPT*0,NIPT*0/ITIME/NIPCAT*0/
     *LCOERR,LLCOER/2*.FALSE./
C
C INITIALIZING VARIABLES IN /PR/ TO HOLD ERROR DEGREE-VARIANCES FOR
C POTENTIAL COEFFICIENT SOLUTIONS RAPP 1981 AND WENZELS GPM2.
      DATA DRAPP/
     *0.0,0.0,0.000006,0.0002455,0.0007523,0.005981,
     *0.007083,0.0264,0.03313,0.07616,0.06944,
     *0.128,0.095,0.135,0.135,0.140,0.177,0.168,0.185,0.203,0.195,
     *0.194,0.222,0.226,0.254,0.277,0.289,0.263,0.301,0.298,0.286,
     *0.280,0.293,0.274,0.283,0.292,0.304,0.183,0.188,0.193,0.198,
     *0.203,0.208,0.213,0.218,0.223,0.228,0.234,0.238,0.243,0.250,
     *0.254,0.259,0.266,0.271,0.276,0.282,0.287,0.291,0.297,0.303,
     *0.307,0.314,0.319,0.323,0.327,0.337,0.341,0.346,0.355,0.357,
     *0.362,0.371,0.376,0.385,0.387,0.392,0.398,0.406,0.410,0.418,
     *0.427,0.440,0.441,0.444,0.448,0.465,0.470,0.471,0.477,0.482,
     *0.496,0.495,0.510,0.511,0.514,0.521,0.532,0.545,0.541,0.555,
     *0.547,0.574,0.595,0.584,0.595,0.603,0.613,0.618,0.634,0.642,
     *0.641,0.650,0.652,0.657,0.702,0.681,0.692,0.694,0.710,0.730,
     *0.711,0.719,0.741,0.768,0.776,0.762,0.802,0.760,0.790,0.811,
     *0.776,0.835,0.844,0.824,0.859,0.869,0.864,0.907,0.884,0.914,
     *0.899,0.887,0.942,0.956,0.943,0.935,0.951,0.981,0.972,0.986,
     *1.009,1.015,1.018,1.021,1.049,1.095,1.060,1.072,1.104,1.117,
     *1.118,1.143,1.134,1.228,1.280,1.184,1.164,1.241,1.234,1.233,
     *1.270,1.230,1.268,1.361,1.320,1.297,1.323,1.352,1.450,1.363/
C
      DATA DGPM2/0.0,0.00,0.000030,0.000139,0.000208,0.000262,
     *0.000307,0.000338,0.000386,0.000422,0.000457,
     *0.000,13*0.001,0.002,0.002,0.002,0.002,0.002,0.003,
     *0.003,0.003,0.003,0.004,0.004,0.004,0.005,0.005,0.005,0.006,
     *0.006,0.007,0.007,0.008,0.008,0.009,0.009,0.010,0.010,0.011,
     *0.012,0.012,0.013,0.014,0.015,0.015,0.016,0.017,0.018,0.019,
     *0.020,0.020,0.021,0.022,0.023,0.024,0.026,0.027,0.028,0.029,
     *0.030,0.031,0.033,0.034,0.035,0.037,0.038,0.039,0.041,0.042,
     *0.044,0.045,0.047,0.049,0.050,0.052,0.054,0.056,0.057,0.059,
     *0.061,0.063,0.065,0.067,0.069,0.071,0.074,0.076,0.078,0.080,
     *0.083,0.085,0.087,0.090,0.092,0.095,0.097,0.100,0.103,0.105,
     *0.108,0.111,0.114,0.117,0.120,0.123,0.126,0.129,0.132,0.136,
     *0.139,0.142,0.146,0.149,0.153,0.156,0.160,0.164,0.168,0.171,
     *0.175,0.179,0.183,0.187,0.192,0.196,0.200,0.205,0.209,0.213,
     *0.218,0.223,0.227,0.232,0.237,0.242,0.247,0.252,0.258,0.263,
     *0.268,0.274,0.279,0.285,0.291,0.297,0.302,0.308,0.315,0.321,
     *0.327,0.334,0.340,0.347,0.353,0.360,0.367,0.374,0.381,0.389,
     *0.396,0.404,0.411,0.419,0.427,0.435,0.444,0.457,0.465,0.601,
     *0.659,0.549,0.523,0.521,0.526,0.533,0.541,0.549,0.558,0.567,
     *0.577,0.587,0.597,0.607,0.618,0.629,0.640,0.652,0.663,0.675/
C
      END
      FUNCTION SYTIME(BASE,RTIME)
      IMPLICIT NONE
      REAL*8 BASE,SYTIME
      REAL RTIME(2),DTIME  
C SYTIME RETURNS THE USED PROCESSING TIME, AND RTIME RETURNS
C CPU TIME AND SYSTEM TIME.
C IN A NON-UNIX ENVIRONMENT RE-ACTIVATE SYTIME=1.0 AND DELETE REST.
C     SYTIME=1.0
C APP SYTIME=ETIME(A)
C APP CALL STIME(TM)
C DTIME IS SUN UNIX EXTENSION, 3F. 
      SYTIME=DTIME(RTIME)  
      BASE=BASE+RTIME(1) 
C     WRITE(*,*)' CPUS,T1,T2 ',SYTIME,RTIME(1),RTIME(2) ,' TOTAL ',BASE        
      RETURN
      END
      SUBROUTINE RAD(IDEG,MIN,SEC,RA,IANG)
C LAST CHANGE 2004-02-07.
C THE SUBROUTINE CONVERTS FOR IANG = 1,2,3,4 ANGLES IN (1) DEGREES, MI-
C NUTES, SECONDS, (2) DEGREES, MINUTES, (3) DEGREES AND (4) 400-DEGREES
C TO RADIANS.
      IMPLICIT NONE
      REAL*8 PHI,SEC,RA,SE
      INTEGER I,MIN,IDEG,J,IANG
C
      PHI = 3.1415926536D0
      I = 1
      IF (IDEG .LT. 0 .AND. IANG .LT. 3) I = -1
      GO TO (1,2,3,4,3,3),IANG
    1 J = 1
      IF (MIN.LT.0) J = -1
      SE =I*IDEG*3600+J*MIN*60+SEC
      I = J*I
      GO TO 5
    2 SE=I*IDEG*3600+SEC*60
      GO TO 5
    3 SE = SEC*3600
      GO TO 5
    4 SE = SEC*3240
    5 RA= I*SE/206264.806D0
      IF (RA.GT.PHI) RA = RA-PHI*2.0D0
      IF (RA.LT.-PHI) RA = RA+PHI*2.0D0
      RETURN
      END
C CDC FUNCTION FE(E2)
      DOUBLE PRECISION FUNCTION FE(E2)
      DOUBLE PRECISION E2
      FE=E2*(0.5+E2*(0.125+E2*(1.0/16+E2*5.0/128)))
      RETURN
      END
      SUBROUTINE QCOMP(E2,XM,Q0,QDASH,DE2)
C PROGRAMMED MAY 1976 BY C.C.TSCHERNING, GID.LAST CH. FEB 1989. 
C THE SUBROUTINE COMPUTES Q0/(EM**3*2) AND QDASH/(EM**2*6),
C USING PG EQ.(2-101).
      IMPLICIT NONE
      REAL *8 E1,E2,XM,Q0,QDASH,DE2,EMP,EM2,DQ,D2
      INTEGER I
C
      E1=1.0D0-E2
      EM2=E2/E1
C     EM= SQRT(EM2)
      E1=E1* SQRT(E1)
      EMP=1.0D0 
      QDASH=1.0D0/15.0D0
      Q0=QDASH
      DQ=Q0
      I=1
   10 I=I+1
      EMP=-EMP*EM2
      D2=2.0D0*I
      DQ=EMP/((D2+1.0D0)*(D2+3.0D0))
      QDASH=QDASH+DQ
      Q0=Q0+DQ*I
      IF (( ABS(DQ)*I).GT.(1.0D-11*Q0)) GO TO 10
      DE2=XM*E1/Q0
      RETURN
      END
      SUBROUTINE GRAVC(EE,MODE,I,UREF,GAMMA)
C PROGRAMMED NOV 1973 BY C.C.TSCHERNING, GEODETIC INSTITUTE OF
C DENMARK. LAST UPDATE FEB 1989 BY CCT.
C
C THE SUBROUTINE COMPUTES BY THE CONSTANTS TO BE USED IN
C THE FORMULA FOR THE NORMAL GRAVITY, THE FORMULA FOR THE NORMAL
C POTENTIAL AND THE CHANGE IN LATITUDE WITH HEIGHT. CONSTANTS RELATED TO
C TWO DIFFERENT REFERENCE FIELDS MAY BE USED. THEY ARE STORED IN THE
C ARRAY FG IN THE VARIABLES SUBSCRIPTED FROM 1 TO 15 FOR THE FIRST
C FIELD AND FROM 16 TO 30 FOR THE SECOND ONE. THE ARRAY FJ CONTAINS THE
C ZONAL HARMONICS, WITH SIGN OPPOSITE TO THE USUAL CONVENTIONS, CF
C REF(C), EQ. (2-92).
C
C THE SUBROUTINE MAY CALCULATE THE CONSTANTS IN 5 DIFFERENT WAYS
C BASED ON 3 VALUES STORED AT CALL IN EE(1), EE(2), EE(3):
C MODE=1: FROM GM, AX, J2 AND OMEGA,
C MODE=2: FROM GM, AX, E2 AND OMEGA,
C MODE=3: FROM GM, AX,1/F AND OMEGA,
C MODE=4: FROM GAMMA, 1/F, AX AND OMEGA, WHERE GAMMA IS THE NORMAL
C         GRAVITY AT EQUATOR.
C MODE=5: AS MODE=4, BUT WITH 1928 GRAVITY FORMULA.
C AX IS THE SEMI-MAJOR AXIS, F THE FLATTENING, E2 THE SQUARE OF THE
C EXCENTRICITY, OMEGA THE SPEED OF ROTATION, GAMMA THE EQUATORIAL
C GRAVITY AND GM THE PRODUCT OF THE GRAVITY CONSTANT AND THE MASS
C OF THE EARTH.
C
C IF IT IS NECESSARY TO USE DOUBLE PRECISION, ACTIVATE:
C
      IMPLICIT NONE
C
      REAL*8 EE,D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,
     *FG,FJ,OMEGA2,GM,AX,XM,GAMMA,DE2,EX,XJ2,E2,F,BX,QDASH,
     *Q0,E1,EM2,EM,Q00,YM,AX2,E,F2,FM,TA,GAMMAP,XK,ZM,UREF,FE
      INTEGER IORDER,MODE,I,J,K,K2,ITCOUN
      DIMENSION EE(6)
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      COMMON /GRAVCC/FG(30),FJ(30),LP(2),OMEGA2,IORDER
      LOGICAL LPOTSD,LF,LT,LP
C
      LPOTSD=MODE.EQ.5
      IF (MODE.LT.4) GM=EE(1)
      IF (MODE.LT.5) AX=EE(2)
      OMEGA2 = EE(6)
      FG(I+9)=OMEGA2
      IF (MODE.LT.4) XM=OMEGA2*AX**3/(GM*15)
      LP(1+I/15) = .NOT.LPOTSD
      IF (MODE.EQ.4)GAMMA=EE(1)
      IF (MODE.LT.5)GO TO 1549
      AX=6378388.0
      EE(3)=297.0D0
      EE(2)=AX
      GAMMA=9.78049
C
 1549 GO TO (1541,1542,1543,1544,1544),MODE
C MODE=1:
 1541 DE2=D0
      EX=D0
      XJ2=EE(3)
      E2=D3*XJ2
 1530 EX=E2
      CALL QCOMP(E2,XM,Q0,QDASH,DE2)
      E2=D3*XJ2+DE2
      IF ( ABS(E2-EX).GT.(1.0D-10*EX)) GO TO 1530
      EE(3)=E2
      F=FE(E2)
      GO TO 1545
C
C MODE=2:
 1542 E2=EE(3)
      F=FE(E2)
      CALL QCOMP(E2,XM,Q0,QDASH,DE2)
      GO TO 1545
C
C MODE=3:
 1543 F=D1/EE(3)
      E2=F*(D2-F)
      EE(3)=E2
      CALL QCOMP(E2,XM,Q0,QDASH,DE2)
      GO TO 1545
C MODE 4 AND 5:
 1544 F=D1/EE(3)
      E2=F*(D2-F)
      EE(3)=E2
      CALL QCOMP(E2,0.0D0,Q0,QDASH,DE2)
      BX=AX*(D1-F)
C CF. PG, EQ.(2-73) USED TO COMPUTE GM.
      GM=(GAMMA+OMEGA2*AX*(D1+QDASH/(Q0*D2)))*(AX*BX)
      EE(1)=GM
      XM=OMEGA2*AX**3/(GM*15)
C
 1545 E1= SQRT(E2)
      EM2=E2/(D1-E2)
      EE(4)=EM2
      EE(5)=F
      EM= SQRT(EM2)
      Q00=Q0 
      Q0=Q0*EM2*EM*D2
      YM=XM*D5*E1/Q0
      AX2=AX*AX
      IF (MODE.LT.4) BX=AX*(D1-F)
C
      FG(I+14) = AX
      FG(I+15) = GM
C
      IF (LPOTSD) GO TO 1501
      DO 1550 J = 1, 15
 1550 FJ(J+I) = D0
      FJ(I+1) = D1
      E =  E1*AX
      XM = OMEGA2*AX2*BX/GM
      F2 = F*F
      FM = F*XM
      TA =   ATAN(E/BX)
C     E3 = E2*AX2
C
      DO 1551 K = 1, 5
      K2 = 2*K
 1551 FJ(I+K2+1)=(-E2)**K*(D1-K2*YM/(K2+3))/(K2+1)
      IF (MODE.EQ.1) FJ(I+3)=-XJ2
C
C GAMMA IS THE NORMAL GRAVITY AT EQUATOR, CF. REF(C), EQ. (2-105A) AND
C (2-70). THE FIVE FOLLOWING COEFFICIENTS ARE FOUND IN REF(C) EQ.
C (2-115) AND (2-124).
C CORRECTION FEB 1989: THE FORMULAS FOR NORMAL GRAVITY AT THE ELLIPSOID
C HAVE BEEN TAKEN FROM MORITZ PAPER ON GRS80 IN THE GEODESISTS HANDBOOK.
C THE FORMULAS FOR THE TERMS DEPENDENT ON THE HEIGHT ARE FROM:
C HIRVONEN,R.A.: NEW THEORY OF GRAVIMETRIC GEODESY, ANN AC. SC. FENN, 
C SER. A, III, NO. 56, 1960, EQ. (92).  
      IF (MODE.LT.4)
     *GAMMA =(GM/(AX*BX)-(D1+QDASH/(D2*Q00))*OMEGA2*AX)
      FG(I+1) = GAMMA
      GAMMAP= (GM/AX2+QDASH/Q00*OMEGA2*BX) 
C     FG(I+2) = -F+D5*XM/D2+F2/D2-26*FM/7+15*XM*XM/D4
      XK = BX*GAMMAP/(AX*GAMMA)-D1 
      FG(I+2) = E2/D2+XK 
C     FG(I+4) = (-F2+D5*FM)/D2
      FG(I+4) = (D3*E2/D4+XK)*E2/D2
C     FG(I+3) = -D2*GAMMA*(D1+F+XM)/AX
      ZM = GM/(AX2*BX) 
      FG(I+3) = -ZM*(D2-XM+(D1-27*XM/14+E2)*E2) 
C     FG(I+5) = D2*GAMMA*(D3*F-D5*XM/D2)/AX
      FG(I+5) = ZM*(-5*XM+(D3-23*XM/7+D2*E2)*E2)
C     FG(I+6) = D3*GAMMA/AX2
      FG(I+6) = ZM*(D3-5*XM+D2*E2)/BX
C CF. REF(C), EQ. (2-118),(2-119).
      FG(I+11) = (D2*F-XM-F2)/D3+D2*FM/21.0D0
      FG(I+12) = -D4*F2/D5+D4*FM/7.0D0
C CF. REF(C), EQ. (2.61).
      UREF = GM*TA/E+OMEGA2*AX2/D3
      GO TO 1502
C
 1501 UREF = 62639787.0D0
      FG(1) = GAMMA
C
C CONSTANTS USED IN INTERNATIONAL GRAVITY FORMULA, CF.REF(C),(2-126),
C (2-131) AND (2-128).
      FG(4) = 4*0.0000059E0
      FG(2) = 0.0052884-FG(4)
      FG(3) = -0.30877724E-5
      FG(5) = 0.00045206E-5
      FG(6) = 7.265D-13
C
 1502 FG(I+13) = (FG(I+2)+FG(I+4))*6.47512D-2
      FG(I+7) = UREF
C FG(I+8) CONTAINS THE THIRD DERIVATIVE OF THE NORMAL GRAVITY.
      FG(I+8) = D4*FG(I+6)/(AX*D3)
      RETURN
      END
C ----------------------------------------------
      DOUBLE PRECISION FUNCTION RGRAV(I,IKP,REF1,REF2,
     *REF3,SINLAP,H,RG,CU,SU,LSAT)
C PROGRAMMED BY C.C.TSCHERNING, GEODETIC INSTITUTE OF DENMARK,
C NOW GEOPHYSICAL INSTITUTE, UNIVERSITY OF COPENHAGEN. 
C IN ALGOL MAY 1976 AND IN FORTRAN APRIL 1985, LAST CHANGE
C MAR 18, 2003 BY CCT.
C THE FUNCTION COMPUTES NORMAL GRAVITY FIELD REFERENCE VALUES.
C ALL UNITS S.I. IF LSAT IS TRUE, THE VALUES OF THE DERIVATIVES
C WILL BE GIVEN IN A SPHERICAL COORDINATE SYSTEM. OTHERWISE IT
C IS REFERENCED TO THE NORMAL GRAVITY VECTOR. (CH: JULY 1989).  
C
      IMPLICIT NONE
      REAL*8 X,Y,Z,XY,XY2,DISTO,DIST2,OM2,SUM,RG,D,C,
     *D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,FG,FJ,OMX2,
     *H,SIN2,SINLAP,GREF,REF1,REF2,T,U,AX,GM,S,S2,C0,C1,GI,GJ,B,
     *UREF,U2,UT,U3,U1,CU,SU,U33,URT,UTT,U22,U11,U13,RLAPLA,REF3
      INTEGER ITCOUN,IORDER,M,I,KPP,N,N1,M1,M2,II,K,K1,K2,K0,IJ,J,
     *M22,IJ4,M2II,IKC,IKP
      LOGICAL LP,LF,LT,LSAT 
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      COMMON /EUCL/X,Y,Z,XY,XY2,DISTO,DIST2
      COMMON /GRAVCC/FG(30),FJ(30),LP(2),OMX2,IORDER
C
      DIMENSION C(4),D(10),SUM(6),RG(3,3) 
C
      OM2=FG(I+9)
C CHANGE DEC 88: OMEGA**2 IS NOW TRANSFERRED THROUGH FG(I+9).
      IF (H.GT.1.0D4) OM2=D0
C CHANGE 2000-02-14 BY CCT.
      M = IORDER
      IF (M.EQ.0) M = 1
C WE INCREASE THE ORDER OF DERIVATIVES TO BE COMPUTED TO 1, IF
C IORDER=0, BECAUSE WE IN THIS CASE ALSO NEED NORMAL GRAVITY, GREF.
C
      KPP= IKC(IKP) 
C     KP = (KPP+2)/2
C     LZETA=LF
      SIN2 = SINLAP*SINLAP
      IF (LP(1+I/15).OR.KPP.NE.3) GO TO 1503
C  COMPUTATION OF THE REFERENCE GRAVITY IN UNITS OF MGAL, CF. REF.(C),
C  PAGE 77 AND 79. H MUST BE IN UNITS OF METERS.
      GREF = FG(I+1)*(D1+FG(I+2)*SIN2+FG(I+4)*SIN2*SIN2)
     * +(FG(I+3)+FG(I+5)*SIN2+(FG(I+6)-FG(I+8)*H)*H)*H
C     LZETA=LT
      REF1 = FG(I+7)
      REF2=GREF
      RGRAV=GREF
      RETURN
 1503 T = Z/DISTO
      U = XY/DISTO
      AX = FG(I+14)
      GM = FG(I+15)
      S = AX/DISTO
      S2 = S*S
C
C SUMMATION OF LEGENDRE-SERIES REPRESENTING THE NORMAL POTENTIAL,
C CF. REF(D).
      N = 10
      N1 = N+1
      M1 = M+1
      M2 = M+2
C     MM = (M1*M2)/2-1
C MM IS EQUAL TO THE TOTAL NUMBER OF DERIVATIVES COMPUTED.
      DO 11 II = 1, 10
   11 D(II) = D0
      DO 12 II = 1, 6
   12 SUM(II) = D0
      K = N
      K1 = N1
      K2 = N+2
      C1 = 12.0D0
      C0 = 11.0D0
      DO 13 K0 = 1, N1
      GI = (D2-D1/C0)*S
      GJ = -C0*S2/C1
      K2 = K1
      K1 = K
      C1 = C0
      C0 = C0-D1
      C(1) = FJ(K2+I)
      IJ = 1
      DO 14 J = 1, M
   14 C(J+1) = -C(J)*(K+J)
C
      DO 15 II = 1, M1
      M22 = M2-II
      DO 16 J = 1, M22
      IJ4 = IJ + 4
      B = D(IJ4)
      D(IJ4) = SUM(IJ)
      SUM(IJ) = GI*(D(IJ4)*T+(II-1)*D(IJ-M+II+1))+GJ*B+C(J)
      IJ = IJ+1
      C(J) = D0
   16 CONTINUE
   15 CONTINUE
      K = K-1
   13 CONTINUE
      IJ = 1
      DO 17 II = 1, M1
      B = GM
      M2II = M2-II
      DO 18 J = 1, M2II
      B = B/DISTO
      SUM(IJ) = SUM(IJ)*B
      IJ = IJ+1
   18 CONTINUE
   17 CONTINUE
C
C UREF IS THE NORMAL POTENTIAL, U1, U3 THE DERIVATIVES IN THE DIRECT-
C ION OF THE 1. AND 3. AXIS (NORTH AND UP, RESPECTIVELY), U11, U22,
C U33 AND U13 ARE THE CORRESPONDING SECOND ORDER DERIVATIVES. UT IS
C THE DERIVATIVES WITH RESPECT TO T = COS(GEOCENTRIC LATITUDE).
      UREF = SUM(1)+OM2*XY2/D2
      IF (M.EQ.0) GO TO 20
      U2 = U*U
      UT = SUM(M+2)/DISTO-Z*OM2
      U3 = SUM(2)+OM2*U*XY
      U1 = UT*U
      GREF =  SQRT(U3**2+U1**2)
C CU AND SU ARE COS AND SIN OF THE ANGLE BETWEEN THE NORMAL GRAVITY
C VECTOR AND THE RADIUS VECTOR IN THE MERIDIAN PLANE.
      IF (LSAT) THEN
       CU = D1
       SU = D0 
      ELSE
       CU = -U3/GREF
       SU = -U1/GREF
      END IF
C
      REF2=GREF
      REF1=UREF
      IF (M.EQ.1) GO TO 20
      U33 = SUM(3)+OM2*U2
      URT = SUM(5)-2*OM2*Z
      UTT = SUM(6)-OM2*DIST2
      U22 = (U3-T*UT)/DISTO
      U11 = U22+U2*UTT/DIST2
      U13 = U*(URT-UT)/DISTO
      RLAPLA=U33+U22+U11-D2*OM2
      IF ( ABS(RLAPLA).GT.1.0D-12) WRITE(6,100)RLAPLA
  100 FORMAT(' *** WARNING *** LAPLACE OPERATOR =',E16.8) 
      REF2=U1
      REF3=U3
      RG(1,1)=U22
      RG(2,2)=U11
      RG(3,3)=U33
      RG(2,3)=U13
      RG(3,2)=RG(2,3)
      RG(1,3)=D0
      RG(3,1)=D0
      RG(1,2)=D0
      RG(2,1)=D0 
C
C CHANGE 2002-06-28.
   20 GO TO (1521,1522,1522,1523,1523,1524,1524,1525,1525,1525,1527,
     *1537,1527,1538,1528),KPP
 1521 RGRAV = UREF
      RETURN
 1522 RGRAV = GREF
C CHANGE 1990.11.02 TO TRANSFER GRAVITY VECTOR IN SPHERICAL FRAME. 
      IF (LSAT) REF1=D0 
      REF2=U1 
      REF3=U3 
      RETURN
 1523 RGRAV = U33*CU*CU+2*CU*SU*U13+SU*SU*U11
      RETURN
 1524 IF (LSAT) GO TO 1522
      RGRAV = U1
      REF1=U3
      REF2=GREF
      RETURN
 1525 IF (LSAT) THEN
       RGRAV=U13
      ELSE
       RGRAV = -(U13*CU*CU+(U11-U33)*CU*SU)
      END IF
      RETURN
 1537 RGRAV=U11*CU*CU-U13*D2*CU*SU+U33*SU*SU 
      RETURN 
 1527 RGRAV = D0  
      RETURN
 1538 RGRAV= U22 
      RETURN 
 1528 RGRAV=(U22-U11*CU*CU+D2*U13*CU*SU-U33*SU*SU)
C     DDU/DDX-DDU/DDY. 
C
      RETURN
      END
      SUBROUTINE EUCLID(COSLAP,SINLAP,COSLOP,SINLOP,H,E2,AX)
C PROGRAMMED BY C.C.TSCHERNING, GEODETIC INSTITUTE OF DENMARK, 1974.
C UPDATES: NONE.
C COMPUTATION OF EUCLIDIAN COORDINATES X,Y,Z , DISTANCE AND SQUARE OF
C DISTANCE FROM Z-AXIS XY, XY2 AND DISTANCE AND SQUARE OF DISTANCE FROM
C THE ORIGIN DISTO AND DIST2 FROM GEODETIC COORDINATES REFERING TO AN
C ELLIPSOID HAVING SEMI-MAJOR AXIS EQUAL TO AX AND SECOND EXCENTRICITY
C E2.
C IF DOUBLE PRECISION IS NEEDED ACTIVATE:
      IMPLICIT NONE
      REAL*8 X,Y,Z,XY,XY2,DISTO,DIST2,DN,COSLOP,SINLOP,
     *COSLAP,SINLAP,H,E2,AX
C AND USE DSQRT, DCOS AND DSIN IN THE FOLLOWING.
      COMMON /EUCL/X,Y,Z,XY,XY2,DISTO,DIST2
      DN = AX/ SQRT(1.0D0-E2*SINLAP**2)
      Z = ((1.0D0-E2)*DN+H)*SINLAP
      XY = (DN+H)*COSLAP
      XY2 = XY*XY
      DIST2 = XY2+Z*Z
      DISTO =  SQRT(DIST2)
      X = XY* COSLOP
      Y = XY* SINLOP
      RETURN
      END
      SUBROUTINE ICOSYS(I,IP,GM,AX,E2,F,UREF,GAMMA)
C PROGRAMMED BY C.C.TSCHERNING, GEODETIC INSTITUTE OF DENMARK, 1986.
C LAST MODIFICATION: 2008-05-16  BY CCT.
      IMPLICIT NONE
      REAL*8 D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,SINLA0,COSLA0,RLONG0,
     *DSHIFT,AX2,E22,EE0,DSHIF0,EE,UREF,GAMMA,GM,AX,E2,F
      INTEGER ITCOUN,MODEC,MODEC0,I1,I,J,IP
      LOGICAL LT,LF
C THE PROGRAM INITIALIZES COORDINATE SYSTEM PARAMETERS ACCORDING TO
C THE VALUE OF THE PARAMETER I.
C I = 0: PARAMETERS IN CCOSYS, I=1: ED1950 WITH NORTH-SEA DATUM
C SHIFT AND ADDITIONAL DELTA(LAMBDA)=-0.5 ARCSEC,
C I = 2: COMMON ED1950 DATUM SHIFT FROM EDOC2 WITH DZ CORRECTION,
C I = 3: NAD1927 WITH NEW MEXICO DATUM-SHIFT, I = 4: GRS1967,
C I = 5: GRS1980, I = 6: NWL9D, I = 7: BEST CURRENT SYSTEM.
C I = 8: BEST CURRENT FOR FAROE ISLAND REGION,
C I = 9: ED1950 ADOPTED FOR FINLAND (LONGITUDE CHANGED).
C I =10: IAG-75, I = 11: KRASSOWSKI S. 42/57 (DDR),
C I =12: GERMAN DHDN SYSTEM ON BESSEL ELLIPSOID.
C I =13: ENGLAND/WALES SHIFT
C I= 14: REP. IRELAND SHIFT OF GPS/LEV  (2002-03-20).
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      COMMON /ITRANC/SINLA0,COSLA0,RLONG0,DSHIFT(7),AX2,E22
      COMMON /CCOSYS/EE0(3),DSHIF0(7),MODEC0
      DIMENSION EE(6)
      EE(6)=(0.729211515D-4)**2
      I1=I+1
      DO 10 J=1,7
   10 DSHIFT(J)=D0
C
      GO TO (20,21,22,23,24,25,26,27,28,30,31,32,33,34,35),I1
C
  100 FORMAT('+',18X,' USER DEFINED SYSTEM.')
   20 DO 11 J=1,7
      IF (J.LT.4) EE(J)=EE0(J)
   11 DSHIFT(J)=DSHIF0(J)
      MODEC=MODEC0
      WRITE(6,100)
      GO TO 29
C
  101 FORMAT('+',18X,' ED1950, NORTH-SEA.')
   21 MODEC=5
      DSHIFT(1)=-89.5
      DSHIFT(2)=-93.8
      DSHIFT(3)=-124.6
      DSHIFT(6)=0.17
      DSHIFT(7)=1.4D-6
      WRITE(6,101)
      GO TO 29
C
  102 FORMAT('+',18X,' ED1950 WITH DATUM SHIFT FROM EDOC2.')
   22 MODEC=5
      DSHIFT(1)=-81.0
      DSHIFT(2)=-113.3
      DSHIFT(3)=-118.8+2.5
      WRITE(6,102)
      GO TO 29
C
  103 FORMAT('+',18X,' NAD1927, NEW MEXICO VALUES, DLON=-0.7".')
   23 EE(1)=3.9860094D14
      EE(2)=6378206.4
      EE(3)=294.98
      DSHIFT(1)=-22.0
      DSHIFT(2)=157.0
      DSHIFT(3)=176.0
      DSHIFT(6)=-0.7
      MODEC=3
      WRITE(6,103)
      GO TO 29
C
  104 FORMAT('+',18X,' GRS1967.')
   24 MODEC=1
      EE(1)=3.98603D14
      EE(2)=6378160.0
      EE(3)=0.0010827
      WRITE(6,104)
      GO TO 29
C
  105 FORMAT('+',18X,' GRS1980.')
   25 MODEC=1
      EE(1)=3.986005D14 
      EE(2)=6378137.0D0 
      EE(3)=0.00108263
      EE(6)=(7.292115D-5)**2  
      WRITE(6,105)
      GO TO 29
C
  106 FORMAT('+',18X,' NWL9D=NWSC9Z2.')
   26 MODEC=3
      EE(1)=3.986008D14
      EE(2)=6378145.0
      EE(3)=298.25
      DSHIFT(3)=2.5
      DSHIFT(6)=-0.5
      DSHIFT(7)=-0.4D-6 
      WRITE(6,106)
      GO TO 29
C
  107 FORMAT('+',18X,' BEST CURRENT 2008.')
   27 MODEC=1
C CORRECTED 2008-05-16 BY CCT. FROM EGM2008 ZERO TIDE SYSTEM.
      EE(1)=3.986004415D14
      EE(2)=6378136.3D0
      EE(3)= 0.484165143790815D-03*SQRT(5.0D0)
      WRITE(6,107)
      GO TO 29
C
  108 FORMAT('+',18X,' BEST CURRENT FOR FAEROE ISLAND REGION.')
   28 MODEC=3
      EE(1)=3.986005D14
      EE(2)=6378135.2
      EE(3)=298.2572D0 
      WRITE(6,108)
      GO TO 29
C
  109 FORMAT('+',18X,' ED1950, ADOPTED FOR FINLAND.')
   30 MODEC=5
      DSHIFT(1)=-89.5
      DSHIFT(2)=-93.8
      DSHIFT(3)=-124.6
      DSHIFT(6)=-2.23
      DSHIFT(7)=1.4D-6
      WRITE(6,109)
      GO TO 29
C
  110 FORMAT('+',18X,' IAG-75.')
   31 MODEC=3
      EE(1)=3.986005D14
      EE(2)= 6378140.
      EE(3)= 298.257
      WRITE(6,110)
      GO TO 29
C
  111 FORMAT('+',18X,' KRASSOWSKY ELL. WITH SHIFT FOR DDR.')
   32 MODEC=3
      EE(1)=3.986005D14
      EE(2)=6378245.0D0
      EE(3)=298.30D0
      DSHIFT(1)=  45.5D0
      DSHIFT(2)=-126.6D0
      DSHIFT(3)= -70.2D0
      WRITE(6,111)
      GO TO 29
C
  112 FORMAT('+',18X,' BESSEL ELL. WITH DHDN SHIFT FOR W-GERMANY.')
   33 MODEC=2
      EE(1)=3.986005D14
      EE(2)=6377397.155D0
      EE(3)=0.006674372D0
      DSHIFT(1)=-580.00D0
      DSHIFT(2)= -80.90D0
      DSHIFT(3)=-395.30D0
C ORDER MAY BE WRONG - HERE ROT X,Y,Z. 
      DSHIFT(4)=-0.35D0
      DSHIFT(5)= 0.10D0
      DSHIFT(6)=-3.58D0
      DSHIFT(7)=-11.1D-6
      WRITE(6,112)
      GO TO 29
C
  113 FORMAT('+',18X,' ENGLAND/WALES GPS DATUM SHIFT. ')
   34 MODEC=1
      EE(1)=3.986005D14 
      EE(2)=6378137.0D0 
      EE(3)=0.00108263
      EE(6)=(7.292115D-5)**2  
      DSHIFT(1)=-2.92D0
      DSHIFT(2)=-6.17D0
      DSHIFT(3)= 2.46D0
      WRITE(*,113)
      GO TO 29
C
  114 FORMAT('+',18X,' REP. IRELAND GPS DATUM SHIFT. ')
   35 MODEC=1
      EE(1)=3.986005D14 
      EE(2)=6378137.0D0 
      EE(3)=0.00108263
      EE(6)=(7.292115D-5)**2  
      DSHIFT(1)= 1.498D0
      DSHIFT(2)=15.872D0
      DSHIFT(3)= 0.374D0
C     DSHIFT(1)= 3.642D0
C     DSHIFT(2)=17.461D0
C     DSHIFT(3)=-1.152D0
      WRITE(*,114)
C
   29 CALL GRAVC(EE,MODEC,IP,UREF,GAMMA)
      GM=EE(1)
      AX=EE(2)
      E2=EE(3)
      F=1/EE(5)
      DSHIFT(7)=DSHIFT(7)+D1
      DSHIFT(4)=DSHIFT(4)/RADSEC
      DSHIFT(5)=DSHIFT(5)/RADSEC
      DSHIFT(6)=DSHIFT(6)/RADSEC
      RETURN
      END
C--------------------------------
      SUBROUTINE COUT(NO,LONC,LSMAL,LFULLO,IORDER)
C PROGRAMMED 1974 BY C.C.TSCHERNING, UPDATED: 2005-09-06..
C THE SUBROUTINE WRITES ON UNIT 6 (1) STATION NUMBER,(2) COORDINATES,
C (3) OBSERVED VALUE (IN ORIG.REF.SYSTEM),(4) DIFFERENCE BETWEEN OBSER-
C VED AND PREDICTED VALUE, (5) ERROR OF PREDICTION, (6) TRANSFORMATION
C VALUE, (7) SPHERICAL HARMONIC SERIES CONTRIBUTION, (8) RESULT OF COLL
C I AND (9) COLL.II, (10) SUM OF QUANTITIES (7)-(9) AND (11) SUM OF (6)-
C (9) - ALL IF MEANINGFULL. IN CASE WE ARE DEALING WITH A PAIR OF DE-
C FLECTIONS, (LONC = FALSE), THE CORRESPONDING QUANTITES FOR ETA ARE
C WRITTEN A LINE BELOW.
C WHEN LPUNCH IS TRUE, THE FOLLOWING OF THE ABOVE MENTIONED QUANTITIES
C ARE WRITTEN ON UNIT 17: (1) AND (2), AND WHEN LOUTC IS TRUE (3) - (5)
C AND ELSE (11), (10) AND (5).
C WHEN LSMAL IS TRUE, A 4-DIGIT LAYOUT IS IN USE.
C WHEN LNUOUT IN COMMON /OUTC/ IS TRUE, ONLY OUTPUT OF STATION NUMBER.
C
      IMPLICIT NONE
      LOGICAL LPUNCH,LONC,LOUTC,LTRAN,LNTRAN,LNERNO,LK30,LK31,LWRSOL,
     *LTERMA,LSTOP,LTERMO,LSTNO,LK2EQ4,LNUOUT,LSMAL,LFULLO,LFORM
C WHEN LFULLO IS TRUE WILL ALL VALUES COMPUTED FROM A SPHERICAL
C HARMONIC EXPANSION BE OUTPUT, I.E. 6 FOR SECOND DERIVATIVES.
C CHANGE 2005-01-25.
      INTEGER INUMR,NO1,I,I1,K2P3,I2,I4,I21,I31,IANG,II,I0,M,NO2,NO,
     *IU,IDLAT,IDLON,MLAT,MLON,J,I9,IORDER,NOX
      REAL*8 OBN,OBS,SLAT,SLON,C20IN,G1,G2,CM3,CMM2,CM1,D9,CLATD,RDI
C CLATD=GEOCENTRIC LATITUDE, RDI=DISTANCE FROM ORIGIN.
C
      COMMON/OUTC/INUMR(12),NO1,I,I1,K2P3,I2,I4,I21,I31,IANG,LPUNCH,
     *LTERMA,LTERMO,LSTNO,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
      COMMON/OBSER/OBS(22)
      COMMON /GPOTC0/C20IN,G1(3),G2(3,3),CM3,CMM2,CM1
C THE VARIABLES ARE ONLY USED IF LFULLO IS TRUE, AND CONTAINS THE
C DERIVATIVES OF THE SPHERICAL HARMONIC EXPANSION.
      COMMON /COBS/CLATD,RDI,SLAT,SLON,IDLAT,IDLON,MLAT,MLON,NOX,LFORM
C BLOCK ADDED 2005-09-05 TO ENABLE OUTPUT IN GEOCENTRIC COORDINATES.
      DIMENSION OBN(10)
      D9=1.0D9
C VARIABLE LNTRAN NOT ASSIGNED VALUE BEFORE 2005-09-07.
      LNTRAN=.NOT.LTRAN
C
      IF ( ABS(SLAT) .LT. 0.1D-6) SLAT = 0.0D0
      IF ( ABS(SLON) .LT. 0.1D-6) SLON = 0.0D0
C THIS IS DONE IN ORDER TO AVOID PRINTING OF SIGN, WHEN THE ARC-SECOND
C PART IS NEAR TO ZERO,(OR ZERO IS REPRESENTED BY A SMALL NEGATIVE NUM-
C BER).
      II = 2
      IF (LK30) II = 3
      IF (LWRSOL.OR.(.NOT.LPUNCH)) GO TO 8010
      IF (LOUTC) GO TO 8007
      OBN(1) = OBS(1)
      I0 = 2
      OBN(2) = OBS(I4)
      IF (LNTRAN) GO TO 8031
      OBN(3) = OBS(I4-1)
      I0 = I0+1
 8031 IF (LNERNO) GO TO 8032
      I0 = I0+1
      OBN(I0) = OBS(I)
 8032 IF (LONC) GO TO 8034
      I0 = I0+1
      OBN(I0) = OBS(I31)
      IF (LNTRAN) GO TO 8033
      I0 = I0+1
      OBN(I0) = OBS(I4+9)
 8033 IF (LNERNO) GO TO 8034
      I0 = I0+1
      OBN(I0) = OBS(I21)
 8034 I2 = I0
      GO TO 8010
C
 8007 DO 8008 M = 1, I
 8008 OBN(M) = OBS(M)
      IF (LONC) GO TO 8010
      DO 8009 M = 2, I
 8009 OBN(M+I-1) = OBS(M+10)
C
 8010 IF (.NOT.LNUOUT) GO TO 8035
      NO2=NO1-1
      NO2=MOD(NO2,6)+1
      INUMR(NO2)=NO
      IF (NO2.EQ.6.OR.LSTOP) WRITE(6,278)(INUMR(IU),IU=1,NO2)
  278 FORMAT(' ',6I11)
C
 8035 IF (IANG.NE.3.AND.IANG.NE.6)LSMAL=.FALSE.
C CHANGE 2004-02-06. AND 2005-09-06.
      GO TO (8000,8001,8002,8002,8002,9002),IANG
 8000 IF (LK31.AND.(.NOT.LNUOUT))WRITE(6,800)
     *NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,(OBS(J),J=1,K2P3)
      IF (.NOT.(LK31.OR.LNUOUT))WRITE(6,810)
     *NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,(OBS(J),J=1,K2P3)
  800 FORMAT(' ',I7,2(I5,I3,F6.2),F9.1,/,2F7.2,F6.2,7F7.2)
      IF (LPUNCH) WRITE(17,810)NO,IDLAT,MLAT,SLAT,IDLON,MLON,SLON,
     *(OBN(J), J = 1, I2)
  810 FORMAT(I5,2(I4,I3,F6.2),F9.1,7F9.3)
      IF (LONC.AND.LWRSOL) WRITE(17,820)NO,IDLAT,MLAT,SLAT,
     *IDLON,MLON,SLON,OBS(1),OBS(II),OBS(II+1),LSTOP
  820 FORMAT(I5,2(I4,I3,F6.2),3F9.3,L2)
      IF ((.NOT.LONC).AND.LWRSOL) WRITE(17,821)NO,IDLAT,MLAT,SLAT,
     *IDLON,MLON,SLON,OBS(1),OBS(II),OBS(II+10),OBS(II+1),
     *OBS(II+11),LSTOP
  821 FORMAT(I5,2(I4,I3,F6.2),5F9.3,L2)
      GO TO 8004
C
 8001 IF (LK31.AND.(.NOT.LNUOUT))
     *WRITE(6,801)NO,IDLAT,SLAT,IDLON,SLON,(OBS(J),J=1,K2P3)
      IF (.NOT.(LK31.OR.LNUOUT))
     *WRITE(6,811)NO,IDLAT,SLAT,IDLON,SLON,(OBS(J),J=1,K2P3)
  801 FORMAT(I11,I5,F6.2,I8,F6.2,F9.1,/,2F7.2,F6.2,7F7.2)
      IF (LPUNCH)
     *WRITE(17,811)NO,IDLAT,SLAT,IDLON,SLON,(OBN(J),J=1,I2)
  811 FORMAT(I10,I5,F6.2,I8,F6.2,F9.1,7F9.3)
      IF (LONC.AND.LWRSOL) WRITE(17,822)NO,IDLAT,SLAT,IDLON,SLON,
     *OBS(1),OBS(II),OBS(II+1),LSTOP
  822 FORMAT(I10,2(I4,F6.2),3F9.3,L2)
      IF ((.NOT.LONC).AND.LWRSOL) WRITE(17,823)NO,IDLAT,SLAT,IDLON,
     *SLON,OBS(1),OBS(II),OBS(II+10),OBS(II+1),OBS(II+11),LSTOP
  823 FORMAT(I6,2(I4,F6.2),5F9.3,L2)
      GO TO 8004
C
 8002 IF (LSMAL) THEN
       IF (LK31.AND.(.NOT.LNUOUT))
     * WRITE(6,1802)NO,SLAT,SLON,(OBS(J),J=1,K2P3)
       IF (.NOT.(LK31.OR.LNUOUT))
     * WRITE(6,1806)NO,SLAT,SLON,(OBS(J),J=1,K2P3)
 1802  FORMAT(' ',I10,2(F12.6,' '),F9.1,/,10F7.4)
 1806  FORMAT(' ',I10,2(F12.6,' '),F9.1,5F7.4)
       IF (LPUNCH) THEN
        IF (LFULLO) THEN
         IF (IORDER.EQ.0) THEN
          WRITE(17,1815)NO,SLAT,SLON,OBN(1),G1(1)
 1815      FORMAT(I10,2(F12.6,' '),F9.1,F12.2)
         ELSE
          IF (IORDER.EQ.1) THEN
C OUTPUT OF FULL GRAVITY VECTOR.
           WRITE(17,1814)NO,SLAT,SLON,OBN(1),G1(1),G1(2),G1(3)
 1814      FORMAT(I10,2(F12.6,' '),F9.1,3F12.8)
          ELSE
           WRITE(17,1813)NO,SLAT,SLON,OBN(1),G2(1,1)*D9,G2(2,2)*D9,
     *     G2(3,3)*D9,G2(1,2)*D9,G2(1,3)*D9,G2(2,3)*D9
C OUTPUT OF 6 GRAVITY GRADIENTS.
 1813      FORMAT(I10,2(F12.6,' '),F9.1,6F12.4)
          END IF
         END IF
        ELSE
         WRITE(17,1812)NO,SLAT,SLON,(OBN(J), J = 1, I2)
        END IF
       END IF
 1812  FORMAT(I10,2(F12.6,' '),F9.1,7F13.4)
       IF (LONC.AND.LWRSOL) WRITE(17,1824)NO,SLAT,SLON,OBS(1),
     * OBS(II),OBS(II+1),LSTOP
 1824  FORMAT(I10,2(F12.6,' '),F8.2,2F11.4,L2)
       IF ((.NOT.LONC).AND.LWRSOL) WRITE(17,1825)NO,SLAT,SLON,
     * OBS(1),OBS(II),OBS(II+10),OBS(II+1),OBS(II+11),LSTOP
 1825  FORMAT(I10,2(F12.6,' '),F8.2,4F10.6,L2)
      ELSE
       IF (LK31.AND.(.NOT.LNUOUT))
     * WRITE(6,802)NO,SLAT,SLON,(OBS(J),J=1,K2P3)
       IF (.NOT.(LK31.OR.LNUOUT))
     * WRITE(6,806)NO,SLAT,SLON,(OBS(J),J=1,K2P3)
  802  FORMAT(' ',I10,2(F12.6,' '),F9.1,/,2F7.2,F6.2,7F7.2)
  806  FORMAT(' ',I10,2(F12.6,' '),F9.1,5F7.2)
       IF (LPUNCH) THEN
        IF (LFULLO) THEN
         IF (IORDER.EQ.0) THEN
          WRITE(17,1815)NO,SLAT,SLON,OBN(1),G1(1)
         ELSE
          IF (IORDER.EQ.1) THEN
C OUTPUT OF FULL GRAVITY VECTOR.
           WRITE(17,1814)NO,SLAT,SLON,OBN(1),G1(1),G1(2),G1(3)
          ELSE
           WRITE(17,1813)NO,SLAT,SLON,OBN(1),G2(1,1)*D9,G2(2,2)*D9,
     *     G2(3,3)*D9,G2(1,2)*D9,G2(1,3)*D9,G2(2,3)*D9
C OUTPUT OF 6 GRAVITY GRADIENTS.
          END IF
         END IF
        ELSE
         WRITE(17,812)NO,SLAT,SLON,(OBN(J), J = 1, I2)
        END IF
       END IF
C OUTPUT FORMAT CHANGED 9.3 -> 10.4 2005-07-27.
  812  FORMAT(I10,2(F12.6,' '),F9.1,7F10.4)
       IF (LONC.AND.LWRSOL) WRITE(17,824)NO,SLAT,SLON,OBS(1),
     * OBS(II),OBS(II+1),LSTOP
  824  FORMAT(I10,2(F12.6,' '),3F9.3,L2)
       IF ((.NOT.LONC).AND.LWRSOL) WRITE(17,825)NO,SLAT,SLON,
     * OBS(1),OBS(II),OBS(II+10),OBS(II+1),OBS(II+11),LSTOP
  825  FORMAT(I10,2(F12.6,' '),5F9.3,L2)
      END IF
      GO TO 8004
C GEOCENTRIC COORDINATES.
 9002 OBS(1)=RDI
      OBN(1)=RDI
      IF (LSMAL) THEN
       IF (LK31.AND.(.NOT.LNUOUT))
     * WRITE(6,9802)NO,CLATD,SLON,(OBS(J),J=1,K2P3)
       IF (.NOT.(LK31.OR.LNUOUT))
     * WRITE(6,9806)NO,SLAT,SLON,(OBS(J),J=1,K2P3)
 9802  FORMAT(' ',I10,2(F12.6,' '),F10.1,/,10F7.4)
 9806  FORMAT(' ',I10,2(F12.6,' '),F10.1,5F7.4)
       IF (LPUNCH) THEN
        IF (LFULLO) THEN
         IF (IORDER.EQ.0) THEN
          WRITE(17,9815)NO,CLATD,SLON,OBN(1),G1(1)
 9815      FORMAT(I10,2(F12.6,' '),F10.1,F12.2)
         ELSE
          IF (IORDER.EQ.1) THEN
C OUTPUT OF FULL GRAVITY VECTOR.
           WRITE(17,9814)NO,CLATD,SLON,OBN(1),G1(1),G1(2),G1(3)
 9814      FORMAT(I10,2(F12.6,' '),F10.1,3F12.8)
          ELSE
           WRITE(17,9813)NO,CLATD,SLON,OBN(1),G2(1,1)*D9,G2(2,2)*D9,
     *     G2(3,3)*D9,G2(1,2)*D9,G2(1,3)*D9,G2(2,3)*D9
C OUTPUT OF 6 GRAVITY GRADIENTS.
 9813      FORMAT(I10,2(F12.6,' '),F10.1,6F12.4)
          END IF
         END IF
        ELSE
         WRITE(17,9812)NO,CLATD,SLON,(OBN(J), J = 1, I2)
        END IF
       END IF
 9812  FORMAT(I10,2(F12.6,' '),F10.1,7F13.4)
       IF (LONC.AND.LWRSOL) WRITE(17,9824)NO,CLATD,SLON,OBS(1),
     * OBS(II),OBS(II+1),LSTOP
 9824  FORMAT(I10,2(F12.6,' '),F10.1,2F11.4,L2)
       IF ((.NOT.LONC).AND.LWRSOL) WRITE(17,9825)NO,CLATD,SLON,
     * OBS(1),OBS(II),OBS(II+10),OBS(II+1),OBS(II+11),LSTOP
 9825  FORMAT(I10,2(F12.6,' '),F10.1,4F10.6,L2)
      ELSE
       IF (LK31.AND.(.NOT.LNUOUT))
     * WRITE(6,902)NO,CLATD,SLON,(OBS(J),J=1,K2P3)
       IF (.NOT.(LK31.OR.LNUOUT))
     * WRITE(6,906)NO,CLATD,SLON,(OBS(J),J=1,K2P3)
  902  FORMAT(' ',I10,2(F12.6,' '),F10.1,/,2F7.2,F6.2,7F7.2)
  906  FORMAT(' ',I10,2(F12.6,' '),F10.1,5F7.2)
       IF (LPUNCH) THEN
        IF (LFULLO) THEN
         IF (IORDER.EQ.0) THEN
          WRITE(17,9815)NO,CLATD,SLON,OBN(1),G1(1)
         ELSE
          IF (IORDER.EQ.1) THEN
C OUTPUT OF FULL GRAVITY VECTOR.
           WRITE(17,9814)NO,CLATD,SLON,OBN(1),G1(1),G1(2),G1(3)
          ELSE
           WRITE(17,9813)NO,CLATD,SLON,OBN(1),G2(1,1)*D9,G2(2,2)*D9,
     *     G2(3,3)*D9,G2(1,2)*D9,G2(1,3)*D9,G2(2,3)*D9
C OUTPUT OF 6 GRAVITY GRADIENTS.
          END IF
         END IF
        ELSE
         WRITE(17,912)NO,CLATD,SLON,(OBN(J), J = 1, I2)
        END IF
       END IF
  912  FORMAT(I10,2(F12.6,' '),F10.1,7F10.4)
       IF (LONC.AND.LWRSOL) WRITE(17,924)NO,CLATD,SLON,OBS(1),
     * OBS(II),OBS(II+1),LSTOP
  924  FORMAT(I10,2(F12.6,' '),F10.1,2F9.3,L2)
       IF ((.NOT.LONC).AND.LWRSOL) WRITE(17,925)NO,CLATD,SLON,
     * OBS(1),OBS(II),OBS(II+10),OBS(II+1),OBS(II+11),LSTOP
  925  FORMAT(I10,2(F12.6,' '),F10.1,4F9.3,L2)
      END IF
      GO TO 8004
C
C WARNING: IT LOOKS LIKE THERE IS NO CONNECTION TO THIS LABLE.
 8011 IF (LNUOUT) GO TO 8012
      IF (.NOT.LSTNO) WRITE(6,850)NO
  850 FORMAT(' ',I10)
      IF (LSTNO)WRITE(6,856)
  856 FORMAT(' ')
      IF ( ABS(OBS(1)).GE.9.0D3) WRITE(6,858)OBS(1)
      IF ( ABS(OBS(1)).LT.9.0D3) WRITE(6,857)OBS(1)
  858 FORMAT(F9.1,'M')
  857 FORMAT(F8.2,'M')
C     I9=I6+I7+20
      I9=20
      IF (LSMAL) THEN
       IF (LK31.AND.(.NOT.LNUOUT))WRITE(6,1852)(OBS(J),J=2,K2P3)
       IF (.NOT.(LK31.OR.LNUOUT).AND.I9.LE.44) WRITE(6,1853)(OBS(J),
     * J=2,K2P3)
       IF (.NOT.(LK31.OR.LNUOUT).AND.I9.GT.44) WRITE(6,1851)(OBS(J),
     * J=2,K2P3)
 1852  FORMAT(/,2F7.4,F6.4,7F7.4)
 1853  FORMAT(6F8.4)
 1851  FORMAT(/,45X,6F8.4)
      ELSE
       IF (LK31.AND.(.NOT.LNUOUT))WRITE(6,852)(OBS(J),J=2,K2P3)
       IF (.NOT.(LK31.OR.LNUOUT).AND.I9.LE.44) WRITE(6,853)(OBS(J),
     * J=2,K2P3)
       IF (.NOT.(LK31.OR.LNUOUT).AND.I9.GT.44) WRITE(6,851)(OBS(J),
     * J=2,K2P3)
  852  FORMAT(/,2F7.2,F6.2,7F7.2)
  853  FORMAT(6F8.2)
  851  FORMAT(/,45X,6F8.2)
      END IF
C
 8012 IF (.NOT.(LPUNCH.OR.LWRSOL)) GO TO 8004
C
      IF (.NOT.LSTNO) WRITE(17,850)NO
      IF ( ABS(OBS(1)).GE.1.0D4) WRITE(17,858)OBS(1)
      IF ( ABS(OBS(1)).LT.1.0D4) WRITE(17,857)OBS(1)
C
      IF (LSMAL) THEN
       IF (LPUNCH.AND.I9.LE.44) WRITE(17,1853)(OBN(J),J=2,I2)
       IF (LPUNCH.AND.I9.GT.44) WRITE(17,1851)(OBN(J),J=2,I2)
       IF (LWRSOL.AND.LONC) WRITE(17,1854)OBS(II),OBS(II+1)
       IF (LWRSOL.AND.(.NOT.LONC)) WRITE(17,1855)OBS(II),OBS(II+1),
     * OBS(II+10),OBS(II+11)
 1854  FORMAT(2F8.4)
 1855  FORMAT(4F8.4)
      ELSE
       IF (LPUNCH.AND.I9.LE.44) WRITE(17,853)(OBN(J),J=2,I2)
       IF (LPUNCH.AND.I9.GT.44) WRITE(17,851)(OBN(J),J=2,I2)
       IF (LWRSOL.AND.LONC) WRITE(17,854)OBS(II),OBS(II+1)
       IF (LWRSOL.AND.(.NOT.LONC)) WRITE(17,855)OBS(II),OBS(II+1),
     * OBS(II+10),OBS(II+11)
  854  FORMAT(2F8.2)
  855  FORMAT(4F8.2)
      END IF
C
 8004 IF (LNUOUT) RETURN
      IF (LK2EQ4) GO TO 8005
      IF (LSMAL) THEN
      IF (LK31.AND.IANG.NE.5) WRITE(6,1803)(OBS(J+4), J = 1, I1)
      IF (LK31.AND.IANG.EQ.5) WRITE(6,1805)(OBS(J+4), J = 1, I1)
      IF (LK30.AND.(.NOT.LK31)) WRITE(6,1833)OBS(5)
      ELSE
      IF (LK31.AND.IANG.NE.5) WRITE(6,803)(OBS(J+4), J = 1, I1)
      IF (LK31.AND.IANG.EQ.5) WRITE(6,805)(OBS(J+4), J = 1, I1)
      IF (LK30.AND.(.NOT.LK31)) WRITE(6,833)OBS(5)
      END IF
C OUTPUT OF TRA,POT,COLL1,COLL2,PRED,OR PRED+TRA
 8005 IF (LONC) RETURN
C OUTPUT OF OBS,DIFR OR ERR FOR ETA
      IF(I.GT.1.AND.LK31) THEN
       IF (LSMAL) THEN
        WRITE(6,1804)(OBS(J+10),J=2,K2P3)
       ELSE
        WRITE(6,804)(OBS(J+10),J=2,K2P3)
       END IF
      END IF
      IF (LK2EQ4) RETURN
      IF (LSMAL) THEN
       IF (LK31.AND.I.GT.1) WRITE(6,1803)(OBS(J+14), J = 1, I1)
       IF (I.LE.1.AND.LK31) WRITE(6,1805)(OBS(J+14), J = 1, I1)
      ELSE
       IF (LK31.AND.I.GT.1) WRITE(6,803)(OBS(J+14), J = 1, I1)
       IF (I.LE.1.AND.LK31) WRITE(6,805)(OBS(J+14), J = 1, I1)
      END IF
  804 FORMAT(2F7.2,F6.2,8F7.2)
  803 FORMAT('+ ',18X,8F7.2)
  805 FORMAT('  ',18X,8F7.2)
 1804 FORMAT(2F7.4,F6.4,8F7.4)
 1803 FORMAT('+ ',18X,8F7.4)
 1805 FORMAT('  ',18X,8F7.4)
      IF (LSMAL) THEN
      IF (I.GT.1.AND.(.NOT.LK31)) WRITE(6,1834)(OBS(J+10),J=2,I)
      IF (I.LE.1.AND.I1.EQ.1) WRITE(6,1835)OBS(15)
      IF(I.GT.1.AND.I1.EQ.1) WRITE(6,1833) OBS(15)
 1834 FORMAT(' ',45X,2F7.4,F6.4)
 1833 FORMAT('+',66X,F7.4)
 1835 FORMAT(67X,F7.4)
      ELSE
      IF (I.GT.1.AND.(.NOT.LK31)) WRITE(6,834)(OBS(J+10),J=2,I)
      IF (I.LE.1.AND.I1.EQ.1) WRITE(6,835)OBS(15)
      IF(I.GT.1.AND.I1.EQ.1) WRITE(6,833) OBS(15)
  834 FORMAT(' ',45X,2F7.2,F6.2)
  833 FORMAT('+',66X,F7.2)
  835 FORMAT(67X,F7.2)
      END IF
      RETURN
      END
      SUBROUTINE COMPA(VG,IKP,LONECO,IU,MODE)
C PROGRAMMED FEB 1974 BY C.C.TSCHERNING, LAST CHANGE APR 2003.
C THE SUBROUTINE IS USED TO COMPARE OBSERVED AND PREDICTED QUANTI-
C TIES. MODE=1, INITIALISATION, =2: UPDATES SUM AND SQUARESUM,
C =3: OUTPUT MEAN AND VARIANCE.
C IF DOUBLE PRECISION, ACTIVATE:
      IMPLICIT NONE
      LOGICAL LONECO, LSMAL,LLARGE,LPUNCH,LTERMA,LTERMO,LTERM,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
      INTEGER I,J,NUM,INN,INV,INUMR,NO1,K2,K3,K2P3,K4,IU,IANG,
     *MODE,IKP,K23,IUX,I0,IND,K21,IJ,NC,INW,IKP1,INV0,INW0,IU1
      REAL*8 OBS,VARI,D0,SCALE2,OB1,OB2,OB3,SCALE,VG
      COMMON /OBSER/OBS(22)
      COMMON /COM2/ D0, NUM(70),VARI(32),SCALE,SCALE2,INN,INV
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IUX,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LTERM,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
      COMMON /COMCC/I
C
      GO TO (4031,4032,4033), MODE
 4031 D0=0.0D0
      DO 2041 I = 1, 70
 2041 NUM(I) = 0
      DO 2042 I = 1, 20
 2042 VARI(I) = D0
      DO I=1,4
      VARI(I+20)=1.0D10
      VARI(I+16)=-1.0D10
      VARI(I+24)=-1.0D10
      VARI(I+28)=1.0D10
      END DO
C
      SCALE = VG
      SCALE2 = SCALE/2
C
      I = 1
      INN = 1
      INV = 1
      RETURN
C
 4032 J = 0
      I0=4
      K23=K2
      IF (LNERNO) I0=3
 3028 OB3 = OBS(J+2)-OBS(J+IU)
      DO 3035  I=1,I0
      GO TO (3040,3041,3042,3044),I
 3040 OB1 = OBS(J+2)
      GO TO 3043
 3041 OB1 = OBS(J+IU)
      GO TO 3043
 3042 OB1 = OB3
      OB2=OB1
      GO TO 3043
 3044 OB1  = OBS(K23)
C OB1 IS NOW EQUAL TO THE DIFFERENCE BETWEEN MEASURED AND PREDICTED
C QUANTITIES.
C COMPUTATION OF SUM AND SQUARESUM FOR PREDICTION STATISTICS.
 3043 VARI(INV+I-1) = VARI(INV+I-1)+OB1
C UPDATING MIN, MAX.
      IF (VARI(INV+I+15).LT.OB1) VARI(INV+I+15)=OB1
      IF (VARI(INV+I+19).GT.OB1) VARI(INV+I+19)=OB1
 3035 VARI(INV+I+3) = VARI(INV+I+3)+OB1**2
C COUNTING NUMBER OF OBS OF TYPE IKP.
      NUM(INN) = NUM(INN)+1
C
      IND = ( ABS(OB2)+SCALE2)/SCALE
C CORRECTION 2003-06-02.
      IF (OB2 .LT. D0) IND = -IND
      IND = IND+11
      IF(IND.GT.21.OR.IND.LT.1)IND=22
      IND=IND+INN
      NUM(IND) = NUM(IND)+1
      IF (LONECO) GO TO 3029
      IF (INN .EQ. 24) GO TO 3036
      INN = 24
      INV = 9
      J = 10
      K23=K21
      GO TO 3028
 3036 INN = 1
      INV = 1
 3029 RETURN
C
C OUTPUT OF PREDICTION STATISTICS.
 4033 J = 0
      LSMAL=.FALSE.
  401 FORMAT('0COMPARISON OF PREDICTIONS AND OBSERVATIONS')
      WRITE(6,401)
      DO 4020 IJ = 1,2
      INN = J*23+1
      NC = NUM(INN)
      IF(NC.EQ.0) GO TO 4020
      INV = J*8+1
      INW = INV+3
      DO 4002 I = INV,INW
 4002 VARI(I) = VARI(I)/NC
      IF (IKP.GT.5) GO TO 4011
      GO TO (4011,4003,4004,4005,4004),IKP
 4003 WRITE(6,402)
  402 FORMAT('0GRAVITY ANOMALIES')
      GO TO 4006
 4004 IF (IJ.EQ.2) GO TO 4005
      WRITE(6,403)
  403 FORMAT('0LATITUDE COMPONENT OF DEFLECTION OF THE VERTICAL ',
     *'(KSI)')
      GO TO 4006
 4005 WRITE(6,404)
  404 FORMAT('0LONGITUDE COMPONENT OF DEFLECTION OF THE VERTICAL ',
     *'(ETA)')
      GO TO 4006
 4011 IF (IJ.EQ.2) GO TO 4012
      WRITE(6,411)IKP
      GO TO 4006
 4012 IKP1=IKP+1
      WRITE(6,411)IKP1
  411 FORMAT('0DATA TYPE =',I3)
C
 4006 IF(NC.EQ.1) GO TO 4007
      INV0=INV
      INW0=INW
      INV = INV+4
      INW = INW+4
      DO 4015 I = INV,INW
      VARI(I) =(VARI(I)-VARI(I-4)**2*NC)/(NC-1)
      LSMAL=LSMAL.OR.(VARI(I).LT.0.1D0)
 4015 IF (VARI(I).GT.D0) VARI(I) =  SQRT(VARI(I))
C ADDED 2000-03-21 BY CCT.
      IF (LSMAL) THEN
       IF (LNERNO) THEN
        WRITE(6,9405)NC,(VARI(I),I=INV0,INW0-1)
       ELSE
        WRITE(6,9405)NC,(VARI(I),I=INV0,INW0)
       END IF
 9405  FORMAT(' NUMBER:',I8/
     * '0         OBSERVATIONS     PREDICTIONS     DIFFERENCE'/
     * ' MEAND     ',4F16.6)
 9406  FORMAT(' ST.DEVI.  ',4F16.6,/,' MAX      ',4F16.6,/,
     * ' MIN      ',4F16.6)
 9408  FORMAT(' ST.DEVI.  ',3F16.6,/,' MAX      ',3F16.6,/,
     * ' MIN      ',4F16.6)
       IF (LNERNO) THEN
        WRITE(6,9408)(VARI(I),I = INV,INW-1),(VARI(I),I= INV+12,INW+11),
     *  (VARI(I),I= INV+16,INW+15)
       ELSE
        WRITE(6,9406)(VARI(I),I = INV,INW),(VARI(I),I= INV+12,INW+12),
     *  (VARI(I),I= INV+16,INW+16)
       END IF
       WRITE(6,9407)VG
      ELSE
       IF (LNERNO) THEN
        WRITE(6,405)NC,(VARI(I),I=INV0,INW0-1)
       ELSE
        WRITE(6,405)NC,(VARI(I),I=INV0,INW0)
       END IF
  405  FORMAT(' NUMBER:',I6/
     * '0         OBSERVATIONS PREDICTIONS DIFFERENCE'/
     * ' MEAND     ',4F12.2)
  406  FORMAT(' ST.DEVI.  ',4F12.2,/,' MAX      ',4F12.2,/,
     * ' MIN      ',4F12.2)
  409  FORMAT(' ST.DEVI.  ',3F12.2,/,' MAX      ',3F12.2,/,
     * ' MIN      ',3F12.2)
C
       IF (LNERNO) THEN
C CORRECTION 2003-12-19.
        WRITE(6,409)(VARI(I),I = INV,INW-1),(VARI(I),I= INV+12,INW+11),
     * (VARI(I),I= INV+16,INW+15)
       ELSE
        WRITE(6,406)(VARI(I),I = INV,INW),(VARI(I),I= INV+12,INW+12),
     * (VARI(I),I= INV+16,INW+16)
       END IF
       WRITE(6,407)VG
      END IF
  407 FORMAT('0DISTRIBUTION OF DIFFERENCES, UNITS:',F6.2)
 9407 FORMAT('0DISTRIBUTION OF DIFFERENCES, UNITS:',F10.6)
C
 4007 INN = INN+1
      NC = INN+20
      WRITE(6,410)(NUM(I),I=INN,NC),NUM(NC+1)
  410 FORMAT(' ',21I3,3X,I5/
     *' -10 -9 -8 -7 -6 -5 -4 -3 -2 -1  0  1  2  3  4  5  6  7  8  9',
     *' 10 OUTSIDE',//)
C 2001-07-17 CHANGE BY CCT.
      LLARGE=.FALSE.
      DO I=INN,NC
       LLARGE=LLARGE.OR.(NUM(I).GT.999)
      END DO
      IF (LLARGE) THEN
       WRITE(6,419)(NUM(I),I=INN,NC),NUM(NC+1)
  419  FORMAT(' NUMBER OF DIFF. REPEATED ',/,3(8I8),/)
      END IF
 4020 J = J+1
      RETURN
      END
      SUBROUTINE TRANS(SINLAP,COSLAP,RLATP,SINLOP,COSLOP,RLONGP,HP,
     *IKA,IT)
C ORIGINAL VERSION PROGRAMMED IN 1974 BY C.C.TSCHERNING, GEODAETISK
C INSTITUT. LATEST UPDATE 2003-12-14. 
C
C THE SUBROUTINE TRANSFORMS THE COORDINATES FROM ONE DATUM TO ANOTHER
C USING THE 7-PARAMETER DATUM-SHIFT GIVEN BY DX,DY,DZ,DL,EPS1,EPS2,
C EPS3 AND COMPUTES THE CORRESPONDING CHANGE OF DEFLECTIONS OF THE
C VERTICAL AND HEIGHT-ANOMALIES (GEOID UNDULATIONS).
C
C INPUT OF COS AND SIN TO LATITUDE, LATITUDE, LONGITUDE (RADIANS),
C IKA SIGNIFYING WHICH KIND OF CHANGE IN THE OBSERVATIONS WE WANT TO
C COMPUTE AND IT EQUAL TO THE SUBSCRIPT IN THE ARRAY OBS IN WHICH THE
C RESULT IS RETURNED.
C
C CHANGE MADE 1987.10.07: IF LGRID IS TRUE, THE COORDINATES ARE
C NOT UPDATED. THIS ASSURES, THAT THE USE OF GPOTDR IS FASTER
C WHEN A GRID IS USED, SINCE THE LATITUDE IS NOT CHANGED WHEN
C THE DATUM IS NON-GEOCENTRIC.
C
      IMPLICIT NONE
      LOGICAL LNEWD,LREPEC,LONECO,LF,LT,LRESOL,LGRID
      REAL*8 SINLAP,COSLAP,RLATP,SINLOP,COSLOP,RLONGP,HP,
     *OBS,X,Y,Z,XY,XY2,DISTO,DIST2,SINLA0,COSLA0,RLONG0,DELON,
     *DX,DY,DZ,EPS3,EPS2,EPS1,S1,AX2,E22,X0,Y0,Z0,X1,Y1,DELAT,
     *XY20,XY0,DIST20,DISTO0,RLONG,S,DH,RLAT1,COSLA,RLAT,DLO,DLA,
     *D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,DX1,DY1,DZ1
C    *,DLAT,DLON
      INTEGER IKA,IT,ITCOUN,IKP,IT1
      COMMON /OBSER/OBS(22)
      COMMON /DAT/LNEWD,LRESOL,LGRID
      COMMON /EUCL/X,Y,Z,XY,XY2,DISTO,DIST2
      COMMON /ITRANC/SINLA0,COSLA0,RLONG0,
     *DX,DY,DZ,EPS3,EPS2,EPS1,S1,AX2,E22
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      IKP = IKA
      IT1 = IT
      LREPEC = IKP.EQ.5.OR.IKP.EQ.7.OR.IKP.GT.25.AND.(.NOT.LNEWD)
      LONECO = .NOT.LREPEC
      IF (LREPEC) IT1 = IT+10
      IF (IKP.GT.25) IKP=IKP-10
      IF (LRESOL) IKP = 8
C WHEN A RESTART FILE IS INPUT, THE COORDINATES MAY BE IN THE
C LOCAL DATUM, BUT THE OBSERVATIONS IN THE GEOCENTRIC ONE.
      DX1=DX
      DY1=DY
      DZ1=DZ
      X1 = X
      Y1 = Y
      DELAT=RLATP*180.0/PI
      DELON=RLONGP*180.0/PI
C RC  IF (DELON.LT.0) DELON=DELON+360.0
C RC  IF (DELON.LT.280.0 .AND. DELON.GT.261.0
C RC * .AND.DELAT.LT.33.0 .AND. DELAT.GT.29.0)
C RC *CALL NADTRA(RLATP,RLONGP,DX1,DY1,DZ1)
      X0 = DX1+S1*(X+EPS1*Y-EPS2*Z)
      Y0 = DY1+S1*(Y-EPS1*X1+EPS3*Z)
      Z0 = DZ1+S1*(Z+EPS2*X1-EPS3*Y1)
      XY20= X0*X0+Y0*Y0
      XY0 =  SQRT(XY20)
      DIST20 = XY20+Z0*Z0
      DISTO0 =  SQRT(DIST20)
      RLONG =  ATAN2(Y0,X0)
      IF ( ABS(RLONG-RLONGP).GT.PI) RLONG=RLONG-2*PI
C
C  COMPUTATION OF THE NEW GEODETIC LATITUDE, CF REF(C) PAGE 183.
      S = AX2/ SQRT(D1-E22*SINLAP**2)
      DH = D0
      RLAT1 = RLATP
      COSLA=COSLAP
   70 RLAT = RLAT1
C
      RLAT1 =  ATAN2(Z0,XY0-E22*S*COSLA)
      COSLA =  COS(RLAT1)
      S = AX2/ SQRT(D1-E22*(D1-COSLA**2))
      DH = XY0/COSLA-S
      IF ( ABS(RLAT1-RLAT).GT.1.0D-10) GO TO 70
C
      DLO = (RLONG-RLONGP)*RADSEC
      DLA = (RLAT1-RLATP)*RADSEC
      IF ( ABS(DLA).GT.30.0 .OR.  ABS(DLO).GT.30.0) WRITE(6,96)
     * DLA,DLO
   96 FORMAT(' ** WARNING ** DLA=',F10.1,', DLO =',F10.1)
      IF (LGRID) GO TO 95
C
      RLONGP = RLONG
      RLATP = RLAT1
      SINLOP= SIN(RLONG)
      COSLOP= COS(RLONG)
      COSLAP=COSLA
      SINLAP= SIN(RLATP)
      X=X0
      Y=Y0
      Z=Z0
      XY=XY0
      XY2=XY20
      DISTO=DISTO0
      DIST2=DIST20
C
   95 IF (.NOT.LRESOL) GO TO 69
C IF WE READ A SOLUTION, THEN THE OBSERVATIONS HAVE ALREADY BEEN
C CORRECTED FOR CHANGES DUE TO A DATUM-SHIFT, I.E. DH=DLO=DLA=0.0.
      DH=D0
      DLO=D0
      DLA=D0
C
   69 IF (IKP.GT.17) GO TO 75
      GO TO (71,75,72,73,72,71,72,76,76,76,71,75,75,75,75,72,73),IKP
   71 OBS(IT) = DH
      IF (.FALSE.) WRITE(*,7771)HP,DH
 7771 FORMAT(' HP,DH= ',2F14.1)
      GO TO 75
   72 OBS(IT) = -DLA
      IF (LONECO) GO TO 75
   73 OBS(IT1) = -DLO*COSLA
      GO TO 75
   76 OBS(IT) = D0
      OBS(IT1) = D0
   75 RETURN
      END
      INTEGER FUNCTION IKC(IKP)
C PROGRAMMED MAY 1984 BY C.C.TSCHERNING. UPDATE: 1999-05-20 BY CCT.
C THE SUBROUTINE CONVERT THE IDENTIFICATION NUMBERS TO THESE
C USED BY COVAX.
      IMPLICIT NONE
      INTEGER IKP
      IF (IKP.LT.10) GO  TO 6
      IKC=IKP-10
      IF (IKC.GT.17) IKC = IKC-10
      IF (IKC .GT. 17) WRITE(6,10)IKP
   10 FORMAT(' ** WARNING ** IKP=',I5)
      RETURN
    6 GO TO (1,2,3,4,5),IKP
    1 IKC=1
      RETURN
    2 IKC=3
      RETURN
    3 IKC=6
      RETURN
    4 IKC=7
      RETURN
    5 IKC=6
      RETURN
      END
      SUBROUTINE PRED(SS,AAI,IS,ISP,ISO,II,IC,NC,IMAX1,LPRED,LBST,
     *LCST,LTABLE,LTCOV,LSATAC)
C PROGRAMMED 1974 BY C.C.TSCHERNING. UPDATED 2005-04-15 BY CCT. 
C THE SUBROUTINE COMPUTES THE COVARIANCES BETWEEN A QUANTITY OF TYPE IKP
C (HAVING COORDINATES RLONGP,RLATP) AND IC OTHER QUANTITIES HAVING COOR-
C DINATES STORED IN THE ARRAYS RLAT,RLONG. INFORMATION ABOUT THE KIND OF
C QUANTITIES IS FOUND IN THE ARRAY INDEX.
C WHEN ONLY ONE OF THE QUANTITIES DEALT WITH IS A PARAMETER (IKP OR
C IKQ GE 100) THE PARTIAL WITH RESPECT TO THE PARAMETER IS COMPUTED
C BY 'APARM'. IF BOTH ARE PARAMETERS, THEN THE FUNCTION OF THE SUB-
C ROUTINE IS TO ASSIGN THE CONTRIBUTION FROM QUANTITIES ONLY DEPEN-
C DEPENDENT ON PARAMETERS TO THE APPROPRIATE ELEMENTS OF THE NORMAL-
C EQUATION MATRIX, C. THE ELEMENTS ARE TRANSFERRED BY CX AND COM-
C PUTED BY "CXPARM".
C BECAUSE THE SUBROUTINE MAY BE CALLED SEVERAL TIMES FOR THE SAME TYPE
C OF QUANTITY SOME COMMON VARIABLES ARE TRANSFERRED THROUGH /PR/. THE
C INTEGERS II AND IS GIVES INFORMATION ABOUT FROM WHICH PLACE IN THE
C DIFFERENT ARRAYS THE COORDINATES AND DEGREE-VARIANCES ARE TO BE PICKED
C UP (ACCORDING TO COLL.I OR II). THE COMPUTED COVARIANCES ARE STORED IN
C THE ARRAY C. THUS WHEN LBST IS TRUE, THEY ARE FIRST STORED IN ARRAY B
C AND LATER TRANSFERRED TO C.
C WHEN LCST IS TRUE, THE PROCEDURE IS USED TO COMPUTE EITHER THE COEF-
C FICIENTS OF THE NORMAL EQ. OR THE VECTOR OF COVARIANCES USED IN THE
C COMPUTATION OF THE ERROR OF PREDICTION.
C WHEN LPRED IS TRUE (COMP. OF PREDICTIONS), THE PRODUCT OF THE COVARI-
C ANCES AND THE SOLUTIONS TO THE NORMAL-EQ.(FOUND IN B) ARE ACCUMULATED
C IN THE VARIABLE PREDP (RESP. PRETAP).
C IF DOUBLE PRECISION IS NEEDED THEN ACTIVATE THE FOLLOWING STATEMENT:
      IMPLICIT NONE
C AND CHANGE ALL SIN AND COS TO DSIN AND DCOS, RESPECTIVELY.
C
      LOGICAL LPRED,LBST,LCST,LONECO,LNKSIP,LNETAP,LSUM,LOCAL,LCOD,
     *LSAME,LEQP,LREPER,LREROW,LDEFVP,LDEFVQ,LKSIQ,LETAQ,LNBC,LOBSST,
     *LMEANP,LMEANQ,LEQANP,LEQANQ,LSATP,LSATQ,LTESTS,LX,LNX, 
     *LTCOV,LTCOVN,LTABLE,LNTABL,LPARMP,LPARMQ,LNPARQ,LF,LT,LROT,
     *LMEAP1,LMEAQ1,LCOERR,LLCOER,LSPHAR,LSPOUT,LTSPH,LFOURI,LSATAC,
     *LSATPQ,LLCOEE,LCZERO,LCHECK,CHECKC,LSTART,LFOUR,LCTIME
      REAL*4 COFF
      INTEGER MAXO,NSAT,NPMAX,NIPT,NIPCAT,MAXOD,NCOEF,NDIMC,
     *NISIZE,NCRW,NNBL,ICODE,ITRGAP,ITRACK,ITOLD,NSPHAR
C
      PARAMETER (MAXO=16200,NSAT=16200,NPMAX=28920,NIPT=1500,
     *NIPCAT=100002,MAXOD=9*MAXO) 
      PARAMETER (NDIMC=399120,NISIZE=880,NCRW=400000,NNBL=20000)
C     PARAMETER (NDIMC=99986000,NISIZE=14000,NCRW=100000000,NNBL=20000)
C
C PARAMETERS GIVING THE SIZE OF THE ARRAYS HOLDING POTENTIAL
C COEFFICIENTS FOR MAX=360 (REALS), 360 (INTEGERS) AND 180. 
C     PARAMETER (NCOEF=3243602,NSPHAR=180)
      PARAMETER (NCOEF=4844402,NSPHAR=180)
C360  PARAMETER (NCOEF=130322)
C360I PARAMETER (NCOEF= 65165)
C 386 PARAMETER (NCOEF= 2560) 
C
      REAL*8 C
      INTEGER NCAT,ISZE,NBL,MAXBL,IQ
      REAL*8 CCI,CCR,SIGMA0,SIGMA,HCMAX,CCV,DC
      INTEGER KVI,NC1,NC2,ITRACE
      REAL*8 B,HQ,RLAT,SINLAT,COSLAT,RLONG,SINLON,COSLON,WOBS,
     *SINLOP,COSLOP,BSIZE,BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,
     *CAZP,SAZP,HP,RLATP,PRETAP,PREDP,HCZERO
      INTEGER ICZERO,NCZERO,NI,NR,INDEX,IKP,ISAT,ISATP,NOBLK
      REAL*8 SR11,SR12,SR13,SR22,COSAZ,SINAZ,SATROT,SR11A,
     *SR12A,SR13A,SR22A,SINAZA,COSAZA,COVX,CIX,CFA,ROTSUM,ROTSUA
      INTEGER KSAT,NDX1,NDX2,NDP,NDQ,NWAR
      REAL*8 STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,COST2P,
     *SINT2P,FILTER
      INTEGER NFILTE,ITCOUN,IPTYPE,IPACAT,NPARM,NPARM1,MAXPAR,
     *NCXLAS,ITMODE,ITM0,ITMOD,ITROLD 
      REAL*8 STEPQN,COSSQN,SINSQN,STEPQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q,DUMMY
      REAL*8 D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,SFACT
      INTEGER ITIME,ITIME0,KP,KQ,NFOURI,NFOUR,
     *IIDEG,JJORD,IIOLD,JOLD,II,IKB,IETA,JR,ICREL,JRNEXT,IMAX1,
     *NSTEPP,IT,IPT,IPA,ILAST,IR,IC,NR1,NRREL,ICBL,NSTEPQ,IKQ,KT,
     *IFIRST,MP,IA,I,IKA,ISO,IIR,KPSI,KPP,KQQ,IAA,IBB,ICC,IDD,NC,
     *INDX,NEWCX,IGG,IHH,IKC,ISP,IS,NERCOV
      REAL*8 SCFRDD,SCFACT,RDD,FOUCOF,COSB,SINB,SINT,ERRCOV,
     *COMEAN,COZERO,COVCG,FINDR,APARM,SIGMAP,SLOP,SLOQ,CLOP,CLOQ
      REAL*8 SUMIJ,CCCIJ,SQ2,YS,YC,VV,V1,GS,GC,DDS,DDC
      REAL*8 PII,PIM0,PIM1,PIM2,DLP,DLP0,DLP1,DLP2,DAP,DAP0,
     *DAP1,DAP2,DDAP,DDAP0,DDAP1,DDAP2,DDAL0,DDAL1,VI
      REAL*8 SM,SROTQ,CX,DOBS,SS,AAI,ROTSAT,BSIZQN,BSIZQE,
     *COV,COSLAQ,SINLAQ,SINLOQ,COSLOQ,DLAT,DLONG,CAZQ,SAZQ,
     *COSDLO,T,T1,SIDLO2,SINDLA,RQ,C0,PSI,C1,DPSI,TEST3,TEST2,
     *TEST1,C2,C3,PSI1,COST,CTIME
C
      COMMON /NESOL/C(NDIMC),NCAT(NISIZE),ISZE(NISIZE),NBL(NNBL),
     *MAXBL,IQ 
      COMMON /CMCOV/CCI(24),CCR(56),SIGMA0(2200),SIGMA(2200),HCMAX,
     *CCV(2,2),DC(36),KVI(37),NC1,NC2,LOCAL,LSUM
      COMMON /PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
C    *COSAZ(NSAT),SINAZ(NSAT),SINLOP,COSLOP,
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP, 
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C FOR A COMPLETE DESCRIPTION, SEE THE MAIN PROGRAM.
C 
      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),SATROT(3,3) 
      COMMON /ROTA/SR11A(NSAT),SR12A(NSAT),SR13A(NSAT),SR22A(NSAT),
     *COSAZA(NSAT),SINAZA(NSAT) 
C
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFA,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP,NDQ,NWAR,LX(7,5),LNX(7,5),LTESTS 
C 
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,COST2P,
     *SINT2P,FILTER(11),NFILTE 
      COMMON /CMEAQ/STEPQN,COSSQN,SINSQN,STEPQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q 
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C MP AND IPA ARE LOCAL PARAMETERS HERE. 
C COMMON BLOCK ADDED 1997-07-15 TO INDICATE CORRELATED ERRORS.
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON/CCTIME/CTIME(NIPCAT),ITRACE(NIPCAT),ITMODE,ITM0,ITMOD,
     *ITRGAP,ITRACK,ITOLD,NERCOV,LCTIME,LCOERR,LLCOER
      COMMON /GPOTC0/DUMMY(16)
      COMMON /GPOTC3/COFF(NCOEF)
C THIS HAS BEEN ADDED 1995.01.20 IN ORDER TO AVOID A STRANGE ERROR.
      COMMON /CLPARM/SCFRDD(42),SCFACT,RDD,FOUCOF(0:21),NFOURI(42),
     *NFOUR,LFOURI(42),LLCOEE(42),LFOUR
      COMMON /CLPAR1/KP,KQ,LPARMP,LPARMQ
C
C HOLDS VARIABLES USED IN SPHAR CALC. 1999-05-17.
      COMMON /PDEGV/SIGMAP(2200),SLOP,SLOQ,CLOP,CLOQ,
     *IIDEG,JJORD,LSPOUT
C     COMMON /CON3/SUMIJ(32761),CCCIJ(32761),
      COMMON /CON3/SUMIJ((NSPHAR+1)**2),CCCIJ((NSPHAR+1)**2),
     *SQ2,YS,YC,VV,V1,GS(3),GC(3),DDS(3,3),
     *DDC(3,3),IIOLD,JOLD,LSPHAR,LTSPH
      COMMON /SPHOLD/PII,PIM0,PIM1,PIM2,DLP,DLP0,DLP1,DLP2,DAP,DAP0,
     *DAP1,DAP2,DDAP,DDAP0,DDAP1,DDAP2,DDAL0,DDAL1,VI
C
      DIMENSION SM(2200),SROTQ(3,3),CX(NPMAX),DOBS(MAXOD),ROTSAT(6*NSAT)
C ERROR CORRECTED 2003-07-28. (EARLIER ROTSAT WAS NOT EQUIVALENCED).
      EQUIVALENCE (ROTSAT(1),SR11A(1)),(B(1),DOBS(1))
C
      IF (LSPHAR.AND.LTCOV) THEN
       WRITE(*,*)' SPHAR. PRED, IKP, NR II=', IKP,NR,II
      END IF
C
      LSATP=ISATP.GE.1 
      LTESTS=LTCOV
      LNTABL=.NOT.LTABLE
      LNBC = .NOT.LBST.AND.LCST
      LCOD = IKP.GE.6 .AND. IKP .LT.10
      LPARMP = IKP.GE.100
      IKB = IKP
      IF (IKP.GE.26) IKB = IKP-10
      IF (IKP.EQ.5) IKB = 3
      IETA = IKB+1
      JR = II
      NR = ISO+1
      ICREL=ISO 
      JRNEXT = NR
      PRETAP = D0
      PREDP = D0
      NC1=IMAX1
      IF (LPARMP .OR. LCOD) GO TO 3050
      LMEANP=ABS(BSIZEN).GT.1.0D-6 
      LEQANP=LMEANP.AND.BSIZEE.GT.1.0D-6
      LMEAP1=LMEANP.AND.BSIZEN.LT.D0 
      NSTEPP=1
      IF (LMEANP)NSTEPP=NFILTE
      CCI(10)=SS
      CCI(9)=(RE+SS)**2
      CCI(8)=AAI
      CCR(4)=SINLAP
      CCR(6)=COSLAP
      RP=RE+HP
      CCR(2)=HP
      IF (LSATP) THEN        
       CCR(10)=D1
      ELSE
       CCR(10)=GMC/RP**2
      END IF
      GO TO 3002
 3050 IT = IKP-100
C IT IS THE PARAMETER NUMBER (1 - NPARM).
      IF(IT.GT.0) IPT = IPTYPE(IT)
      IPA = 0
      ILAST = ISO
C
C COMPUTATION OF THE COVARIANCE CORRESPONDING TO OBSERVATION IN P
C AND OBSERVATIONS NUMBER 1 TO IC.
 3002 DO 3019 IR = 1, IC
      IIR = IR+ISO
C     IF (LPRED.AND.LSPHAR) WRITE(*,*)' PRED, IR NR ', IR,NR
      NR1=NR-1
      NRREL=MOD(NR1,MAXO)+1
      IF (LOBSST) THEN
       ICBL=NR1/MAXO+1     
C CHANGE 2004-07-09. LSTART INTRODUCED TO ASSURE CORRECT STARTING POINT
C FOR OBSERVATION RECORD.
       IF (NRREL.EQ.1.OR.IR.EQ.1.OR.LSTART) THEN
        LSTART=LF
C       WRITE(6,*)'BLK ',NOBLK,' 13 READ FOR TRANSFER B TO C.'
        READ(16,REC=ICBL)DOBS
        IF (LSATAC) THEN
         READ(14,REC=ICBL)ROTSAT
         IF (NI.LT.0) WRITE(*,*)' ROTSAT1, SR11A1 ',ROTSAT(1),SR11A(1)
        END IF
C       WRITE(6,*)'BLK ',ICBL,' UNIT 14 READ .'
        IF (IR.EQ.1.AND.ISO.NE.0) THEN
         ICREL=MOD(ISO,MAXO)
        ELSE 
         ICREL=0
        END IF 
       END IF
      END IF 
      ICREL=ICREL+1
      LTCOVN=LTCOV.AND.(IIR.EQ.JRNEXT.OR.(MOD(IR,25).EQ.24).OR.IR.EQ.IC)
C
      IF (IIR.NE.JRNEXT) GO TO 3005
C GETTING INFORMATION ABOUT NEXT DATA-SET FROM CATALOGUE
      JRNEXT = INDEX(JR)
      LSATQ=ISAT(JR).GE.1  
      LSATPQ=ISATP.GE.2.OR.ISAT(JR).GE.2 
C ERROR 2005-04-10.
      LROT=ISATP.GE.2.OR.ISAT(JR).GE.2 
      BSIZQN = BSIZE(JR)
      BSIZQE = BSIZE(JR+1)
C ADDITION 1998.03.20
      IF (LLCOEE(JR)) THEN
       LFOUR=LFOURI(JR)
       LCTIME=LFOURI(JR+1)
       IF (LFOUR) THEN
        WRITE(*,*)' NOT IMPLEMENTED '
        STOP
       ELSE
        SCFACT=SCFRDD(JR)
        RDD=SCFRDD(JR+1)
       END IF
      END IF
      LMEANQ = ABS(BSIZQN).GT.1.0D-7 
      LEQANQ = LMEANQ.AND.BSIZQE.GT.1.0D-6
      LMEAQ1 = LMEANQ.AND.BSIZQN.LT.D0 
      NSTEPQ=1
      IF (LMEANQ) THEN 
      IF (LMEAQ1) THEN
      NSTEPQ=NFILTE
      ELSE
      NSTEPQ=5
      END IF
      CALL ICMEAN
     *(ABS(BSIZQN),STEPQN,NSTEPQ,COSSQN,SINSQN,D1,D0,LT,LF)
      IF (LEQANQ)
     *CALL ICMEAN(BSIZQE,STEPQE,5,COSSQE,SINSQE,D1,D0,LT,LF)
      END IF 
      IKQ = INDEX(JR+1)
      JR = JR+2
C
      LREPER = IKQ.EQ.5 .OR. (IKQ.GT.25.AND.IKQ.LT.36)
      LDEFVQ=(IKQ.GE.3.AND.IKQ.LE.5).OR.(IKQ.GE.16.AND.IKQ.LT.36)
      LPARMQ = IKQ.GE.100
      LNPARQ = .NOT.LPARMQ
      IF (LPARMQ.OR.LCOD) GO TO 3151
      KVI(7)=IKC(IKQ)
      CALL COVBX(SM,LSATPQ,IS)
C     IF (LSPHAR) WRITE(*,*)' COVBX CALLED, IKP,IKQ= ',IKP,IKQ
      GO TO 3005
 3151 KT = 0
      IPA = 0
      ILAST = IIR-1
C
 3005 LREROW =LREPER
C
      IF ((.NOT.LPARMP).AND.LNPARQ.AND.(.NOT.LCOD))
     *GO TO 3152
C
      COV = D0
      IF (LNPARQ.AND.LCOD) GO TO 3018
C PARTIALS WITH RESPECT TO PARAMETERS.
      IF (IIR.EQ.(ILAST+1)) THEN       
       IFIRST = IIR
       ILAST = IPACAT(IPA+1)
       MP = IPACAT(IPA+2)
       IPA = IPA+2
       LEQP = MP.GE.0
       MP = IABS(MP)
      END IF
C
      IF (LPARMQ.OR.IIR.EQ.IFIRST.OR.(.NOT.LEQP).OR.LCOD) THEN
       IF (LPARMQ) IPT = IPTYPE(KT+1)
       LSAME = LF
       IF (MP.NE.0) THEN
        IA = 1 
        I = 0
 3003   I = I+1
        LSAME = LSAME .OR. (IPT.EQ.IPACAT(IPA+I))
        IF ((.NOT.LSAME).AND.I.LT.MP) GO TO 3003
        IF (IKP.EQ.9.AND.LSAME.AND.I.EQ.2) IA=-1 
        IF (IA.EQ.-1)WRITE(6,*)IA 
C WE PUT IA=-1, BECAUSE IKP=9 INDICATES A SATELLITE ALTIMETRY
C CROSS-OVER DIFFERENCE, WITH THE SECOND PART ASSOCIATED WITH THE
C MINUS PART. 
       END IF
       IF (LPARMP) IPA = IPA+MP
      END IF
C
      KQ = 2
C IF WE HAVE TWO OBSERVATIONS IN ONE POINT, A JUMP BACK TO THIS
C LABEL WILL BE MADE, WITH KQ NOW EQUAL TO 1.
 3014 IKA = IKQ
      IF (IKQ.GE.26) IKA=IKQ-8
      IF (LREPER) IKA = IKA-KQ
      COV = D0
      IF (LPARMP.AND.LNPARQ.AND.LSAME) THEN
       COV = APARM(COSLAT(ICREL),
     * SINLAT(ICREL),RLONG(ICREL),HQ(ICREL),IKA,IPT,IIR) 
       IF (LTCOVN) WRITE(*,*)' IKAIPTIIRCOV ',IKA,IPT,IIR,COV
      END IF
      KT = KT+1
      IF (LPARMQ.OR.LCOD) GO TO 3015
      GO TO 3020
C
 3152 COSLAQ = COSLAT(ICREL)
      SINLAQ = SINLAT(ICREL)
      SINLOQ = SINLON(ICREL)
      COSLOQ = COSLON(ICREL)
C CHANGE 1999-05-17 BY CCT.
      SLOP=SINLOP
      CLOP=COSLOP
      SLOQ=SINLOQ
      CLOQ=COSLOQ
      DLAT = -(RLATP-RLAT(ICREL))
      DLONG = RLONGP-RLONG(ICREL)
      IF (LSATQ) THEN
       CAZQ=COSAZ(ICREL)
       SAZQ=SINAZ(ICREL)
       CCR(11)=D1
      END IF 
      IF (LMEANQ.AND.(.NOT.LEQANQ).AND.(.NOT.LMEAQ1))CALL
     *ICMEAN(BSIZQN,STEPQE,5,COSSQE,SINSQE,COSLAQ,SINLAQ,LF,LF)
      IF (LMEAQ1) THEN
      COSSQE=COSAZ(ICREL)
      SINSQE=SINAZ(ICREL) 
      STEPQE=-D1 
      ELSE
C 2001-07-15.
       STEPQE=D1
      END IF 
C
      CCI(20)=D1
      CCI(17)= SIN(DLAT/D2)
      COSDLO=COS(DLONG)
      IF (( ABS(DLAT).LT.1.0D-2).OR.( ABS(DLONG*COSLAQ).LT.1.0D-2))
     *GO TO 3153
C     COSDLO=COSLOP*COSLOQ+SINLOP*SINLOQ
C ERROR 2002-09-30.
C     IF (LDEFVP.OR.LDEFVQ) CCR(8)=-SINLOP*COSLOQ+COSLOP*SINLOQ
      T=SINLAQ*SINLAP+COSLAP*COSLAQ*COSDLO
      T1=D1-T
      IF (T.LT.-1.0D0) THEN
C     WRITE(*,*)' WARNING, T < -1 ',T 
      T=-1.0D0
      END IF 
      IF (T.GT.1.0D0) THEN
C     WRITE(*,*)' WARNING, T >  1 ',T 
      T=1.0D0
      END IF 
      GO TO 3154
C
 3153 SIDLO2 =  SIN(DLONG/D2)**2
      CCI(20)=D0
      CCI(16)=  SIDLO2
      CCI(17)= SIN(DLAT/D2)
      SINDLA=CCI(17)**2
C     IF(.NOT.(LDEFVP.OR.LDEFVQ.OR.LSATPQ)) GO TO 3200
      CCI(18)= COS(DLAT)
      CCI(19)= COS(DLAT/D2)
C
C T IS COSINE TO THE SPHERICAL DISTANCE BETWEEN P AND Q, CF.REF(B),
C EQ.(57).
C3200 T1 = D2*(SINDLA+COSLAP*COSLAQ*SIDLO2)
      T1 = D2*(SINDLA+COSLAP*COSLAQ*SIDLO2)
      T = D1-T1
      IF (LPRED.OR.(IKP.NE.IKQ).OR.IC.EQ.IR) GO TO 3154
C THE VARIABLE CCI(20) IS USED TO INDICATE WHETHER THE PRECISE
C FORMULAE MAY BE USED IN COVAX.
      IF (( ABS(T1).LT.1.0D-9).AND.( ABS(HP-HQ(ICREL)).LT.1.0))
     *WRITE(6,300)IC,IR
  300 FORMAT(' ** WARNING ** CURRENT OBS ',I7,' MAY BE IDENTI',
     *'CAL TO OBS NO',I7)
C
 3154 CCR(1) = T
      CCR(5) = SINLAQ
      CCR(7) = COSLAQ
      CCR(8) = -D1*SIN(DLONG)
      CCR(9) = COSDLO
C
      LKSIQ=LREPER.OR.IKQ.EQ.3.OR.IKQ.EQ.16.OR.IKQ.EQ.18
     *      .OR.IKQ.EQ.20.OR.IKQ.EQ.25.OR.IKQ.EQ.22 
      LETAQ=IKQ.EQ.4.OR.IKQ.EQ.17.OR.IKQ.EQ.19.OR.IKQ.EQ.21
     *      .OR.IKQ.EQ.23.OR.IKQ.EQ.24
C     IF (LSPHAR) WRITE(*,*)' LKSIQ,LETAQ= ',LKSIQ,LETAQ
C
      CCR(3)=HQ(ICREL)
      RQ=RE+HQ(ICREL)
      IF (LSATQ) THEN
       CCR(11)=D1
      ELSE
       CCR(11)=GMC/RQ**2
      END IF
      KQ = 1
      IF (LKSIQ) KQ = 2
      KP = 1
      IF (.NOT.LNKSIP) KP = 2
C
      LCZERO=IKP.EQ.ICZERO.AND.IKQ.EQ.ICZERO.AND.
     *(ABS(HP-HCZERO).LT.D1).AND.(ABS(HQ(ICREL)-HCZERO).LT.D1)
C LCZERO IS TRUE WHEN A FINITE COVARIANCE FUNCTION MUST BE USED.
      IF (LCZERO.AND.NCZERO.EQ.-1) THEN
C WE MUST DETERMINE COVARIANCE FUNCTION PARAMETERS
C WE NOW DETERMINE THE VALUE OF THE CORRELATION DISTANCE. 
      WRITE(*,*)' FINITE COVARIANCE FUNCTION IN USE ! '
      CCR(1)=D1
      CALL COVCX(SM,COV,IS,LSATPQ)
      C0=COV
      PSI=D0
      C1=C0
      DPSI=5.0D-4
      TEST3=D1
 3120 PSI= PSI+DPSI
      C2=C1
      CCR(1)=COS(PSI)
      CALL COVCX(SM,COV,IS,LSATPQ)
      C1=COV
      TEST1=TEST3
      TEST3=C1/C0
      IF (TEST3.GT.1.0D0.OR.TEST3.LT.D0)
     *WRITE(*,*)' WARNING ',C0,C2,C1
      IF (TEST3.GT.0.5D0) GO TO 3120
      DPSI=DPSI/D2
      PSI=PSI-DPSI
      KPSI=0
 3121 CCR(1)=COS(PSI)
      CALL COVCX(SM,COV,IS,LSATPQ)
      C3=COV
      KPSI=KPSI+1
      TEST2=C3/C0
      DPSI=DPSI/D2
      IF (TEST2.GT.0.5D0.AND.TEST3.LT.0.5D0) THEN
      TEST1=TEST2
      PSI=PSI+DPSI
      ELSE
      TEST3=TEST2
      PSI=PSI-DPSI
      END IF
      IF (KPSI.LT.115.AND.ABS(0.5D0-TEST2).GT.1.0D-8) GO TO 3121
      PSI1=PSI
      RDD= FINDR(PSI1,1)
      WRITE(*,3122)C0,PSI1,RDD
 3122 FORMAT(' C0= ',F12.4,' CORREL.DIST.',F10.5,' R ',F10.5)
      SCFACT=C0/COZERO(D0,RDD,1)
      NCZERO=0
      END IF
C
      IF (LMEANP.OR.LMEANQ) GO TO 3040
C
      IF (LCZERO) THEN
       PSI=ACOS(T)
       CCV(1,1)=SCFACT*COZERO(PSI,RDD,1)
       COV=CCV(1,1)
       IF (ABS(CCV(1,1)).LT.1.0D-10) NCZERO=NCZERO+1
      ELSE
       IF (LNTABL) CALL COVCX(SM,COV,IS,LSATPQ)
       IF (LTABLE) THEN
        COV=COVCG(SM,ISP,LTCOVN)
       END IF
      END IF
C IF WE USE A SATELLITE ORIENTED FRAME, THE COVARIANCE MATRIX MUST
C BE ROTATED TO THIS FRAME. CHANGE AUG 89 BY CCT. CORRECTED MAR 95. 
      IF (LSATP.AND.LDEFVP) CALL SROT(CCV,SAZP,CAZP,1,LF)
      IF (LSATQ.AND.LDEFVQ) CALL SROT(CCV,SAZQ,CAZQ,1,LT) 
      IF (LSATPQ) THEN
       KPP=KVI(6)
       KQQ=KVI(7) 
       IF (LROT) THEN 
C CHANGE 2003-03-11.
        IF (ISAT(JR-2).NE.0) THEN
        COSB=SR11A(ICREL)
        SINB=SR12A(ICREL)
        COST=SR13A(ICREL)
        SINT=SR22A(ICREL)
        CAZQ=COSAZA(ICREL)
        SAZQ=SINAZA(ICREL) 
        SROTQ(1,1) =  SAZQ*COSB 
        SROTQ(1,2) =  CAZQ*COST+SAZQ*SINB*SINT 
        SROTQ(1,3) = -CAZQ*SINT+COST*SAZQ*SINB 
        SROTQ(2,1) = -CAZQ*COSB 
        SROTQ(2,2) =  SAZQ*COST-SINT*CAZQ*SINB 
        SROTQ(2,3) = -SAZQ*SINT-COST*CAZQ*SINB 
        SROTQ(3,1) = -SINB                     
        SROTQ(3,2) =  COSB*SINT                   
        SROTQ(3,3) =  COST*COSB 
C       SROTQ(1,1) =  SAZQ*COSB
C     SROTQ(1,2) = -CAZQ*COST-SINT*SINB*SAZQ 
C     SROTQ(1,3) =  CAZQ*SINT-COST*SAZQ*SINB
C     SROTQ(2,1) =  CAZQ*COSB
C     SROTQ(2,2) =  SAZQ*COST-SINT*SINB*CAZQ 
C     SROTQ(2,3) = -SAZQ*SINT-COST*SINB*CAZQ
C     SROTQ(3,1) =  SINB
C     SROTQ(3,2) =  SINT*COSB                
C     SROTQ(3,3) =  COSB*COST
        ELSE
C CORRECTION 2003-03-05.
         SROTQ(1,1)=D1
         SROTQ(2,2)=D1
         SROTQ(3,3)=D1
         SROTQ(1,2)=D0
         SROTQ(1,3)=D0
         SROTQ(2,1)=D0
         SROTQ(2,3)=D0
         SROTQ(3,1)=D0
         SROTQ(3,2)=D0
        END IF
        IF (LTCOV) THEN
          WRITE(*,150)SATROT,SROTQ,((((COVX(IAA,IBB,ICC,IDD)
     *    ,IAA=1,3),IBB=1,3),ICC=1,3),IDD=1,3)
  150     FORMAT(' SATROT,SROTQ,COVX ',/,9F8.4,/,9F8.4/21(5D14.5/))
C 150     FORMAT(' SATROT,SROTQ,COVX ',/,9F8.4,/,9F8.4/9(9F8.4/))
        END IF
C
        LCHECK=CHECKC(1)
        CALL COVROT(SATROT,SROTQ) 
        LCHECK=LCHECK.AND.CHECKC(2)
        IF ((.NOT.LCHECK).AND.NWAR.LT.25) THEN
         WRITE(*,153)IR,SATROT,SROTQ
 153     FORMAT(' CHECKC,IR ',I6,/,2(9F8.5,/))
C CHECK OF ORTHOGONALITY OF ROTATION MATRICES.
         DO IAA=1,3
          ROTSUM=D0
          ROTSUA=D0
          DO IBB=1,3
           ROTSUM=ROTSUM+SATROT(IBB,IAA)*SATROT(IBB,IAA)
           ROTSUA=ROTSUA+SROTQ(IBB,IAA)*SROTQ(IBB,IAA)
          END DO
          IF (ABS(ROTSUM-D1).GT.1.0D-8) WRITE(*,*)' ROTSUM ',ROTSUM,IAA
          IF (ABS(ROTSUA-D1).GT.1.0D-8) WRITE(*,*)' ROTSUA ',ROTSUM,IAA
         END DO
        END IF
        IF (LTCOV) THEN
         WRITE(*,151)((COVX(IAA,IBB,KSAT(KQQ,1),KSAT(KQQ,2)),IAA=1,3),
     *   IBB=1,3)
 151     FORMAT(9E8.2)
        END IF
       END IF  
C    
       IF (KPP.NE.15.AND.KQQ.NE.15) THEN
        COV=COVX(KSAT(KPP,1),KSAT(KPP,2),KSAT(KQQ,1),KSAT(KQQ,2))*CFA 
        IF (ITCOUN.LT.25.AND.LTCOV) THEN
         WRITE(*,*)' 3040',KSAT(KPP,1),KSAT(KPP,2),KSAT(KQQ,1),
     *   KSAT(KQQ,2),KPP,KQQ,CFA,COV
         WRITE(*,151)((COVX(IAA,IBB,KSAT(KQQ,1),KSAT(KQQ,2)),IAA=1,3),
     *   IBB=1,3)
         ITCOUN=ITCOUN+1
        END IF
C CHANGE 2002-10-23.
       ELSE
        IF (KPP.EQ.15.AND.KQQ.NE.15) THEN
C DDT/DXX-DDT/DYY IN P.
         COV=(COVX(KSAT(14,1),KSAT(14,2),KSAT(KQQ,1),KSAT(KQQ,2))
     *     -COVX(KSAT(12,1),KSAT(12,2),KSAT(KQQ,1),KSAT(KQQ,2)))*CFA 
        ELSE
         IF (KPP.NE.15.AND.KQQ.EQ.15) THEN
C DDT/DXX-DDT/DYY IN Q.
          COV=
     *    (COVX(KSAT(KPP,1),KSAT(KPP,2),KSAT(14,1),KSAT(14,2))
     *    -COVX(KSAT(KPP,1),KSAT(KPP,2),KSAT(12,1),KSAT(12,2)))*CFA 
         ELSE
C DDT/DXX-DDT/DYY IN BOTH P AND Q.
          COV=
     *    (COVX(KSAT(14,1),KSAT(14,2),KSAT(14,1),KSAT(14,2)) 
     *   -COVX(KSAT(12,1),KSAT(12,2),KSAT(14,1),KSAT(14,2)) 
     *   -COVX(KSAT(14,1),KSAT(14,2),KSAT(12,1),KSAT(12,2))
     *   +COVX(KSAT(12,1),KSAT(12,2),KSAT(12,1),KSAT(12,2)))*CFA 
C OBS IN P AND Q ARE BOTH DDT/DXX-DDT/DYY.
         END IF
        END IF
C CHANGE 1992.08.26. 
       END IF 
        GO TO 3020 
       END IF
       GO TO 3011
C
 3040  COV=COMEAN(SM,IS,ISP,COSLAP,SINLAP,COSLOP,SINLOP,COSLAQ,
     *    SINLAQ,COSLOQ,SINLOQ,NSTEPP,NSTEPQ,LTABLE,LCZERO,LTCOV)
      IF (ABS(COV).LT.1.0D-10.AND.LCZERO) NCZERO=NCZERO+1
C
 3011 IF (LNETAP) GO TO 3012
C  COVARIANCE BETWEEN ETAP AND OTHER FUNCTIONALS IN Q.
      KP=1
      IF (LNPARQ) COV=CCV(KP,KQ)
 3015 IF (LONECO) GO TO 3012
      IF (LPARMQ.AND.LSAME) THEN
       COV = APARM(COSLAP,SINLAP,
     * RLONGP,HP,IETA,IPT,IIR)*IA 
       IF (LTCOV) WRITE(*,*)' IETAIPTIIRIACOV ',IETA,IPT,IIR,IA,COV
      END IF
C
      IF (LNBC) C(NI+NC) = COV
      IF (LBST) B(NRREL) = COV
      IF(LPRED) PRETAP = PRETAP+B(NRREL)*COV 
      IF (LTCOVN) WRITE(6,3961)KP,KQ,IKP,IKQ,T,COV,PRETAP
 3961 FORMAT(' KPKQIKPIKQTVCOVPRETAP ',4I2,F6.3,2D16.6)
C
 3012 IF(LNKSIP)GO TO 3013
C  COVARIANCE BETWEEN KSIP AND OTHER FUNCTIONALS IN Q.
      KP=2
C
 3013 IF (LNPARQ.AND.(.NOT.LCOD))THEN
       COV=CCV(KP,KQ)
      END IF
      IF (LPARMQ.AND.LPARMP) THEN
C BLOCKING OF CX IMPLEMENTED 1992.12.18 BY CCT. 
      INDX=IT*(IT-1)/2+KT-1 
      NEWCX = INDX/NPMAX+1
      INDX = MOD(INDX,NPMAX)+1 
      IF (INDX.EQ.1) THEN
       READ(2,REC=NEWCX)CX 
       IF (LTESTS) THEN
       WRITE(*,*)' CUNIT 2 READ, BLOCK', NEWCX
       WRITE(*,*)(CX(IGG),IGG=1,6)
       END IF
      END IF
      COV = CX(INDX)
      IF (LTCOVN) WRITE(*,*)' INDXCOV ',INDX,COV
      END IF 
C THE VALUES OF CX ARE COMPUTED IN THE SUBROUTINE TRANS.
      IF (LPARMQ.AND.(.NOT.LPARMP.OR.LCOD).AND.LSAME) THEN
       COV=APARM(COSLAP,SINLAP,RLONGP,HP,IKB,IPT,IC+1)*IA 
       IF (LTCOVN) WRITE(*,*)' IKBIPTICIACOV ',IKB,IPT,IC,IA,COV
      END IF
      LTCOVN=LF
C CHANGE 1989.11.29 BY CCT. 
C    *APARM(COSLAP,SINLAP,RLONGP,HP,IKB,IPT,IIR)*IA 
 3020 IF (LCST) THEN
C WE ADD NOISE TO THE DIAGONAL ELEMENT, CHANGE 1992.07.19. AND 1997-07-15. 
      C(NI) = COV
      IF (LF) WRITE(*,*)' NI, C(NI) ',NI,C(NI)
      LLCOER = ITRACE(IC).EQ.ITRACE(IR).AND.ITRACE(IC).LT.0.
     *AND.LCOERR
      IF (IC.GT.MAXO.OR.IR.GT.MAXO) THEN
       LLCOER=LF
      ELSE
c      IF (LNPARQ.AND.(.NOT.LPRED).AND.LLCOER) THEN
       IF ((.NOT.LPRED).AND.LLCOER) THEN
        IF (LFOUR) THEN
         ERRCOV=D0
C NOT YET IMPLEMENTED 2002-10-10.
        ELSE
C  2005-04-04 IMPLEMENTED THAT TIME DIFFERENCES AND NOT SPHERICAL 
C DISTANCE  MAY BE AN ARGUMENT IN COZERO.
         IF (LCTIME) THEN
          PSI=ABS(CTIME(IC)-CTIME(IR))
         ELSE
          PSI=ACOS(T)
         END IF
         ERRCOV = SCFACT*COZERO(PSI,RDD,1)
         NERCOV=NERCOV+1
        END IF
        IF (LTCOV) WRITE(*,3049)ERRCOV,IC,IR,ITRACE(IC),C(NI)
 3049   FORMAT(' ERROR-CORR.',F12.5,' FOR OBS ',2I5,
     *  ' ADDED TO COV. ON ',/,' TRACK ',I9,' COV= ',F13.6)
        C(NI) = C(NI)+ERRCOV
       END IF
      END IF
      IF (LNPARQ.AND.(IC.EQ.IR).AND.(.NOT.LPRED).AND.(.NOT.LLCOER))
     *THEN
       C(NI)=COV+WOBS(NRREL)**2
      END IF
      END IF
      IF (LSPHAR.AND.LPRED.AND.LTESTS) WRITE(*,*)' PREDP,COV,B,N ',
     * PREDP,COV,B(NRREL),NRREL
      IF(LPRED)PREDP = PREDP+COV*B(NRREL)
C
C ACCUMULATING COEFFICIENT PREDICTIONS. 2000-01-13.
      IF (LSPHAR) THEN
       DO IHH=1,(IIDEG+1)**2
        SUMIJ(IHH)=SUMIJ(IHH)+CCCIJ(IHH)*B(NRREL)
       END DO
      END IF
C
      IF (LTCOVN) WRITE(6,1)KP,KQ,IKP,IKQ,T,COV,PREDP
    1 FORMAT(' KPKQIKPIKQTCOVPRE=',4I3,F13.10,2F12.7)
C
 3018 NI = NI+1
      NR1 = NR
      NR = NR+1
      IF (.NOT.LREROW) GO TO 3019
C READ OBS-BLOCK, CHANGE 1992.07.19.
      NRREL=MOD(NR1,MAXO)+1
      IF (LOBSST) THEN
       ICBL=NR1/MAXO+1     
       IF (NRREL.EQ.1.OR.IR.EQ.1) THEN
C     WRITE(6,*)'BLK ',NOBLK,' 15 READ FOR TRANSFER B TO C.'
        READ(16,REC=ICBL)DOBS
        IF (LSATAC) READ(14,REC=ICBL)ROTSAT
C       WRITE(6,*)'BLK ',NOBLK,' 16 READ FOR TRANSFER B TO C.'
        ICREL=0
       END IF
      END IF 
C WE ADD NOISE TO THE DIAGONAL ELEMENT, CHANGE 1992.07.19. 
      IF (LNPARQ.AND.(IC.EQ.IR).AND.(.NOT.LPRED)) THEN
       COV=COV+WOBS(NRREL)**2
       IF (LBST) THEN
        B(NRREL) = COV
       ELSE
        C(NI+NC)= COV
       END IF
      END IF 
C 
      IF (IC.EQ.IR.AND.(.NOT.LPRED)) GO TO 3019
      LKSIQ = .FALSE.
      LETAQ = .TRUE.
      KQ=1
      LREROW = .FALSE.
      IF (LPARMP) GO TO 3014
      GO TO 3011
 3019 CONTINUE
C END OF LOOP COMPUTING A NR-1 VECTOR OF COVARIANCES.
      RETURN
      END
      SUBROUTINE SETCAT(IFC,NB,LFULL,LRESTA,LSATAC)
C PROGRAMMED 1989.07.10 BY EXTRACTION FROM GEOCOL MAIN, BY
C C.C.TSCHERNING., LAST UPDATE 2000-07-27 BY CCT.  
      IMPLICIT NONE
      INTEGER NDIMC,NCAT,ISZE,NISIZE,NBL,NNBL,
     *MAXBL,ISIZE,NEQFI,NEQFIM,NEQFMA,MAXBNE,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *ICZERO,NCZERO,NCRW,MAXO,NSAT,MAXO9,MAXBNO,MAXCOL,M,NBT,NB,I,I1,
     *IFC,IXY,I2,NFILE,J,JJR,JREL,NOBLK,NGTX,ISATP,ISAT,IKP,
     *INDEX,NR,NI,NREAD,NWRITE
      REAL*8 C,OLDB,CNR,GMP,B,HQ,RLAT,SINLAT,COSLAT,
     *RLONG,SINLON,COSLON,WOBS,SINLOP,COSLOP,
     *BSIZE,BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,CC,DOBS,AX,ROTSAT
      LOGICAL LNCOL,LPARAM,LFULL,LOBSST,LRESTA,LL,LNKSIP,LONECO,
     *LNETAP,LDEFVP,LNBL1,LSATAC,LSTART 
C LFULL IS TRUE IF A FULL MATRI IS USED. LRESTA IS TRUE IF THE
C NORMAL EQUATIONS ALREADY HAVE BEEN ESTABLISHED AND REDUCED PARTIALLY.
C
      PARAMETER (NDIMC=399120,NISIZE=880,NCRW=400000,NNBL=20000)
C     PARAMETER (NDIMC=99986000,NISIZE=14000,NCRW=100000000,NNBL=20000)
      PARAMETER (MAXO=16200,NSAT=16200,MAXO9=50400)
      PARAMETER (NEQFIM=60)
C
      COMMON /NESOL/C(NDIMC),NCAT(NISIZE),ISZE(NISIZE),NBL(NNBL),
     *MAXBL,ISIZE 
      COMMON/NESOL1/NEQFI(NEQFIM,2),NEQFMA,MAXBNE,LNBL1
      COMMON /BIPAR/OLDB(4),CNR,GMP,AX,NMAX,II,IOBS,IOBSR,N1,NIR,
     *MAXC,MAXC1,MAXC2,N,IC,NT,IDIMC,IDIMCN,MAXBLT,JR,ISO,
     *LPARAM,LL(5) 
      COMMON/PR/B(MAXO),HQ(MAXO),RLAT(MAXO),SINLAT(MAXO),COSLAT(MAXO),
     *RLONG(MAXO),SINLON(MAXO),COSLON(MAXO),WOBS(MAXO),
     *SINLOP,COSLOP,
     *BSIZE(42),BSIZEN,BSIZEE,COSLAP,SINLAP,RLONGP,RP,CAZP,SAZP,
     *HP,RLATP,PRETAP,PREDP,HCZERO,ICZERO,NCZERO,
     *NI,NR,INDEX(42),IKP,ISAT(42),ISATP,NOBLK,
     *LONECO,LNKSIP,LNETAP,LDEFVP,LOBSST,LSTART
C IN /PR/ IS STORED: THE CONSTANTS B(I), THE CATALOGUE OF THE OBSER-
C VATIONS (INDEX), LATITUDE, COS AND SIN OF LATITUDE, LONGITUDE AND
C HEIGHT OF OBSERVATION POINTS, THE CORRESPONDING QUANTITIES FOR THE
C PREDICTION POINT. THE LOGICAL VARIABLES ARE USED TO DISTINGUISH
C BETWEEN THE DIFFERENT PREDICTION SITUATIONS. THE COMMON BLOCK IS ALSO
C FOUND IN BLOCK DATA, PRED, OUTSOL AND INSOL. 
      DIMENSION CC(NCRW)
      DIMENSION DOBS(MAXO9),ROTSAT(NSAT*6) 
      EQUIVALENCE (C(1),CC(1))
      EQUIVALENCE (B(1),DOBS(1))  
C  
C SETTING UP A CATALOGUE OF THE NORMAL EQUATIONS
C NB IS THE RECORD NUMBER, IC COUNTS THE NUMBER OF COLUMNS WITHIN A
C RECORD, AND THIS NUMBER IS STORED IN NCAT(ISIZE). NCAT (I) WILL CONTAIN
C THE SUBSCRIPT OF THE DIAGONAL ELEMENT OF COLUMN I-1, AND ALL THE
C ELEMENTS OF ISZE WILL BE ZERO BECAUSE WE WORK WITH A FULL MATRIX.
C NBL(I) CONTAINS THE NUMBER OF THE LAST COLUMN IN RECORD I-1.  NOTE
C THAT MAXIMALLY MAXCOL COLUMNS MAY BE STORED IN ONE RECORD.
C 
      MAXBNE=-1
      MAXBNO=-1
      MAXCOL=ISIZE-2 
C     WRITE(*,*)' MAXCOL ',MAXCOL
 2199 M=(MAXCOL*(MAXCOL+1))/2
      IF (M.LE.IDIMC) GO TO 2200
      MAXCOL=MAXCOL-1 
      WRITE(6,330)M,IDIMC,MAXCOL 
  330 FORMAT(I6,' SPACE NEEDED, BUT ',I10,' AVAILABLE',/,
     *' MAXCOL SET EQUAL TO', I10) 
      GO TO 2199 
 2200 NBT = 1
      NBL(1)=0
      NB = 1
      IC=0
      I1=0
C
      DO 2304 I = 1, N1
      LNCOL = I.LE.IFC
      IF (I.EQ.(IFC+1).AND.I.NE.1) THEN
      IXY=NREAD(CC,NBT,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
      WRITE(6,336)IFC,NB,IC
      END IF
  336 FORMAT(I5,' FIRST COLUMNS HAVE ALREADY BEEN REDUCED.',/,
     *' STORED IN ',I5,' LOGICAL BLOCKS, WITH ',I4,
     *' COLUMNS IN LAST BLOCK')
C
      IC=IC+1
      IF (LFULL) ISZE(IC)=0
      NCAT(IC)=I1-ISZE(IC) 
C     WRITE(*,*)' 1 ',IC,I1
      I1 = I1+I
      I2=I1+I+1
C
C ERROR DETECTED 2000-07-03, BY CCT.
      IF((I2.LE.IDIMC).AND.(I.NE.N1).AND.(IC.LT.MAXCOL))
C     IF((I2.LE.IDIMC).AND.(I.NE.N1).AND.(IC.LE.MAXCOL))
     *GO TO 2304
      NCAT(IC+1) = I1
C     WRITE(*,*)' 2 ',IC+1,I1
      IF(I.NE.N1) GO TO 2303
      I2=I2+N1+1
      IF(I2.LE.IDIMC) GO TO 2301
C SECURING THAT THE LAST COLLUMN + ONE MORE CAN BE STORED IN THE SAME
C RECORD.
      NCAT(ISIZE)=IC-1
C     WRITE(*,*)' 3 ',IC-1
      IF ((.NOT.LNCOL).AND.(.NOT.LRESTA))
     *IXY=NWRITE(NFILE,CC,NBT,NT,IDIMCN)
C     IF (MAXBNE.NE.MAXBNO) THEN
      MAXBNO=MAXBNE
      WRITE(*,*)' STORAGE ON UNIT ',NFILE,' BLOCK ',NEQFI(MAXBNE,1)
C     END IF
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
  338 FORMAT(10I7)     
      NBT = NBT+NT
      NB=NB+1
      IF (MOD(NB,50).EQ.0) WRITE(*,*)' BLOCK ',NB,' WRITTEN '
      IF (NB.GE.NNBL) WRITE(*,*)' *** TOO MANY BLOCKS *** '
      NBL(NB)=I-1
      NCAT(2)=N1
      I1=N1
      IC=1
C MAXC IS THE SUBSCRIPT OF THE DIAGONAL ELEMENT OF THE LAST COLUMN,  AND
C MAXC2 IS THE SUBSCRIPT OF THE FICTICIOUS DIAGONAL ELEMENT OF THE RIGHT
C HAND SIDE (IN WHICH THE SQUARE-SUM OF THE NORMALIZED OBSERVATIONS IS
C STORED).
 2301 MAXC = I1-N1
      MAXC2 = I1
C
C STORING THE RIGHT-HAND SIDE.
      DO 2302 J=1,N1
      JJR=J+ISO
      JREL=MOD(JJR,MAXO)
      IF (LOBSST) THEN
      NOBLK=JJR/MAXO+1
C     WRITE(*,*)' J, JJR,JREL,ISO ',J,JJR,JREL,ISO,MAXO
      IF (J.EQ.1.OR.JREL.EQ.1) THEN
C     WRITE(6,*)'BLK ',NOBLK,' 17 READ FOR TRANSFER B TO C.'
      READ(16,REC=NOBLK)DOBS 
      IF (LSATAC) READ(14,REC=NOBLK)ROTSAT
C     WRITE(6,*)'BLK ',NOBLK,' 18 READ FOR TRANSFER B TO C.'
      END IF
      END IF 
C CORRECTION 1999-11-24 BY CCT.
      IF (JREL.EQ.0) JREL=MAXO
 2302 C(MAXC+J) = B(JREL)
C
 2303 I1=0
      NCAT(ISIZE)=IC
C     WRITE(*,*)' 4 ',IC
      IF ((.NOT.LNCOL).AND.(.NOT.LRESTA))
     *NGTX=NWRITE(NFILE,CC,NBT,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
      NBT=NBT+NT
C CORRECTION MADE HERE 1987.09.28. EARLIER NBT WAS NOT UPDATED
C WHEN LNCOL WAS TRUE.
      IC=0 
      NB=NB+1
      NBL(NB)=I
C
 2304 MAXBL=NB-1
      MAXBLT= (MAXBL-1)*NT+1 
      RETURN
      END 
      SUBROUTINE NES(NN,IIFC,IIFR,KLIM,LBS,PW,NT,IDIMCN,LOREC,NERRM,
     *NPRED)
C PROGRAMMED BY C.C.TSCHERNING, GEODETIC INSTITUTE, DENMARK, 1972.
C UPDATED FOR RC-FORTRAN 1984. LATEST UPDATE OCT 11 2005 BY CCT.
C
C THE SUBROUTINE WILL, USING THE (MODIFIED) CHOLESKYS METHOD:
C (1) COMPUTE THE REDUCED MATRIX L CORRESPONDING TO A SYMMETRIC
C     (NN-1)*(NN-1) MATRIX B, WHEN THE IIFC COLUMNS AND IIFR
C     ROWS OF L ARE KNOWN, (L*LT = B, LT THE TRANSPOSED OF L).
C     B IS FORMED BY A NUMBER OF SUB-MATRICES, C, A, AT AND P,
C                C   A
C        B =
C               AT   P
C     WHERE C IS POSITIVE DEFINITE AND HAS DIMENSION KLIM.
C (2) COMPUTE THE REDUCED NN-1 VECTOR (L**-1)*Y.
C (3) COMPUTE THE DIFFERENCE PW = YN-YT*(B**-1)*Y.
C     IF KLIM.LT.NN, THEN -PW = -YN+YT*(B**-1)*Y IS COMPUTED.
C (4) SOLVE THE EQUATIONS LT*X = (L**-1)*Y,(THE SO CALLED BACK-SOLUTION)
C
C THE REDUCED ROWS AND COLUMNS OF L (THERE MAY BE NONE), THE CORRES-
C PONDING UNREDUCED UPPER TRIANGULAR PART OF B, THE NN-VECTOR FORMED
C BY Y AND YN FORMS AN UPPER TRIANGULAR NN*NN-MATRIX.
C THE MATRIX IS STORED COLUMNVIZE IN NT*MAXBL RECORDS OF A DIRECT ACCESS
C FILE. THE NT RECORDS (NT*NCRW REALS) CONTAINS AS MANY
C COLUMNS AS POSSIBLE IN THE FIRST (NT*NCRW - NISIZE) REALS CORRESPON-
C DING TO THE DIMENSION OF THE ARRAYS C AND CR. THE LAST ISIZE REALS
C OF THE NT RECORDS HOLDS TWO CATALOGES (INTEGER ARRAYS) NCAT AND ISZE
C (NRCAT, IRSZE RESPECTIVELY). WE WILL CALL THE NT RECORDS A BLOCK.
C WHEN THE CONTENT OF A BLOCK HAS BEEN TRANSFERRED E.G. TO C, NCAT,
C ISZE, WE HAVE THE FOLLOWING SITUATION. THE COLUMNS ARE STORED IN C
C FROM THE FIRST ELEMENT DIFFERENT FROM ZERO TO THE DIAGONAL ELEMENT.
C NCAT(I) IS THE SUBSCRIPT OF THE DIAGONAL ELEMENT OF COLUMN I-1 AND
C ISZE(I) IS THE NUMBER OF IGNORED (SAVED) ZEROES IN COLUMN I. NCAT(ISIZE)
C IS THE NUMBER OF COLUMNS STORED IN THE RECORD.
C NBL(I) IS EQUAL TO THE NUMBER OF THE LAST COLUMN STORED IN RECORD I-1.
C (1) TO (3) ABOWE WILL ALWAYS BE EXECUTED, BUT (4) WILL ONLY BE EXE-
C CUTED WHEN THE LOGICAL LBS IS TRUE. THE EXECUTION OF (1), (2) AND (4)
C IS EQUIVALENT TO THE SOLUTION OF THE EQUATIONS B*X=Y, WHEN KLIM .GE.
C NN. OTHERWISE LAGRAGNIAN FACTORS ARE FOUND. THE SOLUTIONS
C WILL BE STORED IN THE ARRAY C IN THE POSITIONS ORIGINALLY OCCUPIED BY
C Y AND WILL BE TRANSFERRED TO MAIN THROUGH THE COMMON BLOCK.
C IN CASE A NUMERICAL SINGULARITY OCCURS IN COLUMN NUMBER JD, THE COLUMN
C IS DELETED BY CHANGING THE CATALOGUE ISZE AND THE ELEMENTS IN ROW JD
C AND THE JD'TH ELEMENT OF THE SOLUTION VECTOR IS PUT EQUAL TO ZERO.
C
C A PART OF THE MATRIX ASSOCIATED WITH LAGRANGIAN FACTORS IS FOUND
C FOLLOWING COLUMN NUMBER KLIM. IN THIS CASE WILL NEGATIVE ACCUMU-
C LATION BE CHANGED TO POSITIVE ACCUMULATION, FOR ROWS AND COLUMNS
C WITH SUBSCRIPT LARGER THAN KLIM. LOGICAL VARIABLES LPOS, LNEG AND
C LMIX ARE TRUE AND FALSE IN THE VARIOUS SITUATIONS.
C
C THE CALL PARAMETERS NT AND IDIMCN ARE THE NUMBER OF BLOCKS IN
C A LOGICAL BLOCK IS DIVIDEN INTO, WHEN TRANSFERRED TO BACKING
C STORAGE BY THE SUBROUTINES NREAD AND NWRITE, AND IDIMCN IS THE
C BLOCKSIZE MEASURED IN REALS. LOREC IS TRUE WHEN
C A MESSAGE IS OUTPUT AFTER EACH REDUCED COLUMN.
C
C CHANGE 2005-10-06. IT IS NOW POSSIBLE TO CALCULATE SEVERAL
C (NPRED) ERROR-ESTIMATES SIMULTANEOUSLY.
C
      IMPLICIT NONE
      INTEGER NDIMC,NISIZE,NCRW,NNBL,NCAT,ISZE,NBL,MAXBL,ISIZE,
     *IDIMCN,NREAD,NWRITE,KLIM,KTL,KB,IC,IR,MP,NKK,NFILE,
     *N,NN,IFR,IIFR,IFC,IIFC,JBF,IL,JF,JTF,NT,JTL,ID,NERRM,
     *KBF,KL0,KF,KF0,KTF,JBL,IYX,NC,J0,KL,KBL,NR,NRCAT,K0,MR,J,
     *ISZ,IC0,JD,NR0,KFS,K,KD,K1,I,IRSZ,IRSZE,IR0,KF1,KX,M,KKI,
     *NPRED,NPRED1,I61,IP
      REAL*8  C,CR,PW,QCI2,QCI,QSUM,CCR,CC,CI,DCOVA
C
      LOGICAL LBS,LREC,LPOS,LNEG,LMIX,LOREC,LPRERR
      CHARACTER *72 UDATE
C     REAL *16 QSUM
C
      PARAMETER (NDIMC=399120,NISIZE=880,NCRW=400000,NNBL=20000)
C     PARAMETER (NDIMC=99986000,NISIZE=14000,NCRW=100000000,NNBL=20000)
C
      COMMON /NESOL/C(NDIMC),NCAT(NISIZE),ISZE(NISIZE),NBL(NNBL),
     *MAXBL,ISIZE 
      COMMON /CRW/CR(NDIMC),NRCAT(NISIZE),IRSZE(NISIZE) 
C
      DIMENSION CC(NCRW),CCR(NCRW),DCOVA(100002) 
C THE DIMENSION OF DCOVA SHOULD BE .LE. NIPCAT IN THE MAIN PROGRAM.
      EQUIVALENCE (C(1),CC(1)),(CR(1),CCR(1))
C
C LPRERR IS TRUE IF SEVERAL ERROR ESTIMATES ARE TO BE COMPUTED
C SIMULTANEOUSLY. 2005-10-04.
      LPRERR=(.NOT.LBS).AND.NPRED.GT.1
      IF (LPRERR) THEN
       NPRED1=NPRED
      ELSE
       NPRED1=1
      END IF
      N = NN
C FR = FIRST ROW, FC = FIRST COLUMN.
      IFR=IIFR+1
      IFC=IIFC+1
      IF (IFR.GT.IFC) WRITE(6,10)
   10 FORMAT(' ERROR IN CALL, IFR.GT.IFC .')
C
C REDUCTION OF COLUMNS IFC TO N. ELEMENTS, WHICH ARE ALREADY REDUCED,
C ARE STORED IN CR (EXCEPT FOR JBL=KBL). ELEMENTS, WHICH ARE GOING TO BE
C REDUCED, ARE STORED IN C.            
C
C FIND FIRST ACTUAL RECORD AND ROW/COLUMN.
      JBF=0
  200 JBF=JBF+1
      IF(NBL(JBF+1).LT.IFC) GO TO 200
      IL = NBL(JBF)
      JF = IFC-IL
      JTF = JBF*NT-NT+1
      JTL = JTF
      ID = JTF
C
      KBF = 0
  201 KBF = KBF+1
      IF (NBL(KBF+1).LT.IFR) GO TO 201
      KL0 = NBL(KBF)
      KF = IFR-KL0
      KF0 = KF
      KTF = (KBF-1)*NT+1
C
C READ RECORD JBL FROM FILE. THE ARRAY C WILL CONTAIN AT LEAST ONE UNRE-
C DUCED COLUMN.
      DO 280 JBL=JBF,MAXBL
      IYX=NREAD(CC,ID,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
C NC = NUMBER OF COLUMS IN BLOCK.
      NC=NCAT(ISIZE)
      J0=NBL(JBL)
      KL = KL0
      ID = KTF
C
      DO 270 KBL = KBF, JBL
      LREC=KBL.EQ.JBL
      ID=NREAD(CCR,ID,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
C NR = NUMBER OF COLUMNS IN BLOCK.
      NR=NRCAT(ISIZE)
      K0=KL
      KL=KL+NR
      MR=MAX0(K0,IIFR)
C
C IN ORDER TO MINIMIZE THE NUMBER OF TRANSPORTS TO AND FROM FILE, WE
C DO NOT (GENERALLY) COMPUTE ALL THE REDUCED ELEMENTS OF ONE COLUMN, BUT
C ONLY THE ELEMENTS IN ROW K0+1 TO KL. (K0 IS THE NUMBER OF THE LAST
C COLUMN IN THE PREVIOUS RECORD, KL THE NUMBER OF THE LAST IN THE ACTUAL
C RECORD.)
C
      DO 260 J=JF,NC
       ISZ=ISZE(J)
C WE CHECH THAT THERE ARE ELEMENTS (UNREDUCED) DIFFERENT FROM ZERO IN
C COLUMN J WITH SUBSCRIPT GREATHER THAN OR EQUAL TO KL.
       IF (KL.LE.ISZ) GO TO 260
C THE SUBSCRIPT OF THE ELEMENT IN COLUMN J,ROW K IS NCAT(J)+K-ISZE(J).
C THE DIFFERENCE NCAT(J)-ISZE(J) IS STORED IN THE VARIABLE IC0.
C THE SAME DIFFERENCE FOR COLUMN (ROW) K IS STORED IN IR0. THE ELEMENT
C JUST BEFORE THE FIRST ELEMENT TO BE REDUCED WILL HENCE HAVE SUBSCRIPT
C I=IC0+MAX(K0,IIFR,ISZ). KD IS THE ABSOLUTE ROW NUMBER.
       IC0 = NCAT(J)-ISZ
       JD=J0+J
       NR0=MIN0(JD,KL)-K0
       IF (MR.GE.ISZ) KFS = KF
       IF (MR.LT.ISZ) KFS = ISZ-K0+1
C
       DO IP=1,NPRED1
        IF (LPRERR) THEN
         READ(19,REC=IP)(DCOVA(I61),I61=1,N)
        END IF
        DO 250 K = KFS, NR0
         KD = K0+K
         K1 = KD-1
         I = IC0+KD
C I IS THE SUBSCRIPT OF THE COEFFICIENT TO BE REDUCED.
         QSUM = 0.0D0
         IRSZ=IRSZE(K)
         IR0 = NRCAT(K)-IRSZ
         IF (LPRERR) THEN
          QCI=DCOVA(KD)
         ELSE
          QCI=C(I)
         END IF
         IF (ABS(QCI).GT.1.0D20) THEN 
          IF (NERRM.LT.20) WRITE(*,*)' I,IC0,QCI',I,IC0,QCI
          NERRM=NERRM+1
         END IF
         KF1=MAX0(IIFR,ISZ,IRSZ)+1
C IRSZ = KD INDICATES THAT COLUMN KD CONTAINS A NUMERICAL SINGULARITY.
C THE ELEMENTS OF ROW KD IS PUT EQUAL TO ZERO.
         IF (IRSZ .EQ. KD) QCI = QSUM
C
         LNEG = KD .LE. KLIM
         LPOS = KLIM .LT. KF1
         LMIX = KF1 .LE. KLIM .AND. KLIM .LT. KD
         IF (KF1.GT.K1) GO TO 245
         IF (.NOT.LMIX) GO TO 210
         KX = K1
         K1 = KLIM
         LPOS = .TRUE.
         LNEG = .FALSE.
  210    IF (LREC) GO TO 235
C REDUCTION OF ONE COEFFICIENT.
C     IF (JD.EQ.5000.OR.JD.EQ.5001) WRITE(*,299)(C(IC0+M),M=1,JD)
C 299 FORMAT(6D12.5)
         DO M = KF1, K1
          IF (LPRERR) THEN
           QSUM = QSUM+DCOVA(M)*CR(IR0+M)
          ELSE
           QSUM = QSUM+C(IC0+M)*CR(IR0+M)
          END IF
         END DO
         GO TO 245
  235    DO M = KF1, K1
          IF (LPRERR) THEN
           IF (JD.NE.KD) THEN
            QSUM = QSUM+C(IR0+M)*DCOVA(M)
           ELSE
            QSUM = QSUM+DCOVA(M)**2
           END IF
          ELSE
           QSUM = QSUM+C(IR0+M)*C(IC0+M)
          END IF
         END DO
  245    IF (LNEG) QCI = QCI - QSUM
         IF (LPOS) QCI = QCI + QSUM
         IF (LMIX) THEN      
          LMIX = .FALSE.
          LNEG = .TRUE.
          LPOS = .FALSE.
          K1 = KX
          KF1 = KLIM+1
          QSUM = 0.0D0
          IF (KF1.LE.K1) GO TO 210
         END IF
C
         IF(LREC) GO TO 246
         IF (IR0+KD.EQ.NDIMC)WRITE(*,*)' WARNING IR0,KD ',IR0,KD,NDIMC
         IF (LPRERR) THEN
          DCOVA(KD) = QCI/CR(IR0+KD)
         ELSE
          C(I) = QCI/CR(IR0+KD)
         END IF
         GO TO 250
  246    IF (I.EQ.0.OR.(IR0+KD).EQ.0) WRITE(*,*)' I,IR0 ',I,IR0,KD
         IF (JD.NE.KD) THEN
          IF (LPRERR) THEN
           DCOVA(KD) = QCI/C(IR0+KD)
          ELSE
           C(I) = QCI/C(IR0+KD)
          END IF
         END IF
  250   CONTINUE
        IF (LPRERR) THEN
C STORING THE REDUCED COVARIANCES ON UNIT 19.
         IF (KD.EQ.N) DCOVA(N)=QCI
         WRITE(19,REC=IP)(DCOVA(I61),I61=1,N)
        END IF
       END DO
       IF (ABS(C(I)).GT.1.0D20) THEN
        IF (NERRM.LT.20) WRITE(*,*)' NEQ: MIQCICI ',M,I,QCI,C(I)
        NERRM=NERRM+1
       END IF
C
       IF(.NOT.LREC.OR.(JD.NE.KD).OR.JD.EQ.N) GO TO 260
C
C  TEST OF NUMERICAL STABILITY
       QCI2 =QCI
      IF ( ABS(C(I)).GT.1.0D-10) QCI2 = QCI/C(I)**2
      IF (QCI2 .GT. 1.0D-16) GO TO 251
      IF (NERRM.LT.25) THEN
       WRITE(6,20)JD,QCI2
   20  FORMAT(' NUMERICAL SINGULARITY IN ROW NO.',I5,', TEST QUANTITY ='
     * ,E16.9)
      END IF
      NERRM=NERRM+1
      IF (NERRM.GT.50) THEN
       WRITE(*,*)' MORE THAN 50 ERRORS, STOP '
       STOP
      END IF
      ISZE(J)=JD
C THE COLUMN IS DELETED.
      GO TO 260
C
  251 C(I) =  SQRT(QCI)
  260 KF = 1
c
  270 CONTINUE
C
C REDUCED ARRAY C BACK TO FILE. FIRST COLUMN IN NEXT RECORD IS NOW THE
C FIRST STORED, BUT FIRST REDUCED COLUMN IS AGAIN COLUMN KF0 IN REC. JBF
      JTL=NWRITE(NFILE,CC,JTL,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
      IF (MOD(JTL,NT).EQ.0) THEN
C THIS IS TO MAKE A RESTART POSSIBLE. 2000-07-25.
C IN A NEW JOB USE LSANEQ=T AND IFC = -LAST COLUMN.
      IF (LOREC)
     *WRITE(*,*)' REDUCED BLOCK ',JTL-1,' WRITTEN, LAST CO. ',NBL(JTL)
C
      IF (MOD(JTL,NT).EQ.50) THEN
      CALL FDATE(UDATE)        
      WRITE(6,*)UDATE 
      END IF
C
      IF (.FALSE.) THEN
       WRITE(*,*)' REDUCED EQ. '
       WRITE(*,3851)(C(KKI),KKI=1,120)
 3851  FORMAT(6D12.4)
      END IF
      END IF
      JF=1
      KF=KF0
C
      IF(JBL.NE.MAXBL) GO TO 280
      PW = QCI
      IF(.NOT.LBS) GO TO 280
C
C BACK-SOLUTION. NOTE THAT THE VARIABLE I AT THIS MOMENT IS THE SUB-
C SCRIPT OF THE DIAGONAL ELEMENT OF THE COLUMN CONTAINING THE RIGHT-HAND
C SIDE.  I WILL SUCCESSIVELY TAKE THE VALUE OF THE SUBSCRIPT OF THE ELE-
C MENT IN ROW M OF THIS COLUMN, AND THE SOLUTION WILL BE STORED IN C(I).
      M = N
      KTL = (MAXBL-1)*NT+1
C
      DO 277 KB= 1,MAXBL
      IYX=NREAD(CCR,KTL,NT,IDIMCN)
C     WRITE(*,338)(NCAT(IIK),IIK=1,IC+1),NCAT(ISIZE),ISIZE
C 338 FORMAT('N ',10I7)
      KTL = KTL-NT
      NR=NRCAT(ISIZE)
C THE COLUMN CONTAINING THE RIGHT-HAND SIDE IS SKIPPED.
      IF(KB.EQ.1)NR=NR-1
      K1=NR+1
      IF(NR.EQ.0) GO TO 277
      DO 276 K=1,NR
C WE STEP BACKWARD (M) FROM COLUMN N-1, TAKING THE NR COLUMNS FROM EACH
C RECORD SUCCESSIVELY.
      I=I-1
      IC=I
      M=M-1
      IR=NRCAT(K1)
      K1=K1-1
      IRSZ=IRSZE(K1)
      MR=M-IRSZ
      IF (MR.GT.0) GO TO 273
C IN CASE A COLUMN HAS BEEN DELETED, THE UNKNOWN IS PUT EQUAL TO ZERO.
      C(I) = 0.0D0
      GO TO 276
C THE (UN)KNOWN C(I) IS COMPUTED (ONE EQUATION WITH ONE UNKNOWN).
  273 CI = C(I)/CR(IR)
      C(I) = CI
      IF (ABS(CI).GT. 1.0D20) THEN
       IF (NERRM.GT.20) WRITE(*,339)KB,K,I,IR,NR,K1,CI,CR(IR) 
       NERRM=NERRM+1
      END IF
  339 FORMAT(' WARNING ** KB,K,I,IR,NR,K1,CI,CR(IR)= ',
     *6I8,2D16.6)
C
      IF(MR.EQ.1) GO TO 276
      DO 274 MP=2,MR
C IR IS THE SUBSCRIPT OF THE ELEMENTS OF COLUMN M, RUNNING FROM THE
C DIAGONAL-1 UP TO THE SUBSCRIPT OF THE FIRST ELEMENT DIFFERENT FROM
C ZERO. IC IS THE SUBSCRIPT OF THE ELEMENTS ON THE RIGHT-HAND SIDE IN
C THE SAME ROW AS CR(IR).
      IR=IR-1
      IC=IC-1
      IF (IC.EQ.0.OR.IR.EQ.0) WRITE(6,8001)IC,IR,KB,MAXBL,NR,K,MR
 8001 FORMAT(' *** ERROR *** IC,IR,KB,MAXBL,NR,K,MR=',/,7I5)
C THE CONTRIBUTION FROM THE (UN)KNOWN C(I) IS SUBTRACTED FROM THE QUAN-
C TITIES ON THE RIGHT-HAND SIDE.
  274 C(IC) = C(IC)-CI*CR(IR)
C
  276 CONTINUE
  277 CONTINUE
      IF (.FALSE.) THEN
      WRITE(*,*)' SOLUTIONS, COLUMN',NC,
     *' STORED IN C, INDEX ',NCAT(NC)+1,NCAT(NC+1)
      WRITE(*,3851)(C(NKK),NKK=NCAT(NC)+1,NCAT(NC+1))
      END IF
C THE SOLUTIONS ARE NOW ALL STORED IN C FROM C(NCAT(N)+1) TO C(NCAT(N+1)
C -1). THEY ARE TRANSFERRED TO 'MAIN' THROUGH THE COMMON BLOCK NESOL.
  280 CONTINUE
      RETURN
      END
C
      FUNCTION NREAD(C,IR,NT,IDIMC)
C PROGRAMMED BY C.C.TSCHERNING, NOV 1985, UPDATED APR 2002. 
      IMPLICIT NONE
      INTEGER IR,NT,IDIMC,NIDIMC,NEQFIM,NEQFI,IQ,KP,
     *NEQFMA,IQR,MAXBNE,K1,K2,I,K,NREAD 
      REAL*8 SUMBL,SUMBLO,C
      LOGICAL LNBL1
      PARAMETER (NIDIMC=400000) 
C     PARAMETER (NIDIMC=100000000)
      PARAMETER (NEQFIM=60)
C
      COMMON/NESOL1/NEQFI(NEQFIM,2),NEQFMA,MAXBNE,LNBL1
C
      DIMENSION C(NIDIMC)  
      IQ=IR
C     KP=IQ/(MAXBNE*NT)
C     IQR=IR-KP*MAXBNE
      KP=0
      SUMBL=0
 1005 SUMBLO=SUMBL
      SUMBL=SUMBLO+NEQFI(KP+1,2)
      KP=KP+1
      IF (KP.GT.NEQFMA) WRITE(*,*)' ERROR, KP = ',KP,SUMBL,SUMBLO,
     *NEQFI(KP,2)  
      IF (SUMBL.LT.IQ) GO TO 1005
      IQR=IR-SUMBLO
C
      IF (NT.EQ.1) GO TO 1000
C
      K1=1
      K2=IDIMC
      DO 1010 I=1,NT
C     WRITE(*,*)KP,IQR,IQ
      READ(NEQFI(KP,1),REC=IQR)(C(K),K=K1,K2)
C IBM READ(8'IQ)(C(K),K=K1,K2)
      IQ=IQ+1
      IQR=IQR+1
      K1=K1+IDIMC
 1010 K2=K2+IDIMC
      GO TO 1020
C
 1000 CONTINUE
      IF (.NOT.LNBL1) READ(NEQFI(KP,1),REC=IQR)C
 1020 NREAD=IR+NT
      RETURN
      END
      FUNCTION NWRITE(IUNIT,C,IR,NT,IDIMC)
C PROGRAMMED BY C.C.TSCHERNING, NOV 1985, UPDATE JULY 1989.
C CHANGED 2002-11-24 SO THAT NO WRITE IS DINE WHEN LNBL1 IS TRUE.
C THIS MAY BE THE CASE IF ALL COEFFICIENTS OF THE EQUATIONS MAY BE
C STORED IN ONE BLOCK.
      IMPLICIT NONE
      INTEGER IUNIT,IR,NT,IDIMC,NIDIMC,NEQFIM,NEQFI,IQ,KP,
     *NEQFMA,IQR,MAXBNE,K1,K2,I,K,NWRITE
      REAL*8 SUMBL,SUMBLO,C
      LOGICAL LNBL1
      PARAMETER (NIDIMC=400000) 
C     PARAMETER (NIDIMC=100000000)
      PARAMETER (NEQFIM=60)
C
      COMMON/NESOL1/NEQFI(NEQFIM,2),NEQFMA,MAXBNE,LNBL1
C
      DIMENSION C(NIDIMC)  
      IQ=IR
C     KP=IQ/(MAXBNE*NT)
C     IQR=IR-KP*MAXBNE
      KP=0
      SUMBL=0
 1005 SUMBLO=SUMBL
      SUMBL=SUMBLO+NEQFI(KP+1,2)
      KP=KP+1
      IF (KP.GT.NEQFMA) WRITE(*,*)' WERROR, KP = ',KP,SUMBL,SUMBLO,
     *NEQFI(KP,2),IR  
      IF (SUMBL.LT.IQ) GO TO 1005
      IQR=IR-SUMBLO
      IF (MAXBNE.LT.KP) MAXBNE=KP
      IUNIT=NEQFI(KP,1)
      IF (NT.EQ.1) GO TO 1000
C
      K1=1
      K2=IDIMC
      DO 1010 I=1,NT
C     WRITE(*,*)KP,IQR,IQ
      WRITE(NEQFI(KP,1),REC=IQR)(C(K),K=K1,K2)
C IBM WRITE(8'IQ)(C(K),K=K1,K2)
      IQ=IQ+1
      IQR=IQR+1
      K2=K2+IDIMC
 1010 K1=K1+IDIMC
      GO TO 1020
C
 1000 CONTINUE
      IF (.NOT.LNBL1) WRITE(NEQFI(KP,1),REC=IQR)C
 1020 NWRITE=IR+NT
      RETURN
      END
      FUNCTION APARM(CLAT,SLAT,RLON,HP,IKP,IT,IIR)
C PROGRAMMED SEPT. 1984 BY C.C.TSCHERNING, GEODAETISK INSTITUT, DANMARK.
C LATEST UPDATE 12 MAR 2005.
C THE SUBROUTINE COMPUTES THE CONTRIBUTION FROM PARAMETERS TO
C OBSERVATIONS OF TYPE IKP.
C THE INTEGER IIR IS THE OBSERVATION NUMBER, WHICH IS USED WHEN
C E.G. A TIME DEPENDENT TILT IS USED. THE TIME IS STORED IN THE
C ARRAY ITIME IN CTIME.
C SCALE FACTOR VARIABLES ARE STORE IN SFACT.
C REF(A): TSCHERNING, C.C.: DETERMINATION OF DATUM-SHIFT PARAMETERS
C         USING LEAST SQUARES COLLOCATION. BOLL.GEODESIA SC. AFF.,
C         AN. XXXV, NO.2, 1976.
C    (B): SOLER,T.: ON DIFFERENTIAL TRANSFORMATIONS BETWEEN CARTESIAN
C         AND CURVELINEAR (GEODETIC) COORDINATES. REP. OF THE DEP. OF
C         GEODETIC SCIENCE, NO. 236, THE OHIO STATE UNIVERSITY, 1976.
C *** WARNING *** NOT ALL MODES HAVE BEEN TESTED.
      IMPLICIT NONE
      INTEGER NIPT,MAXO,NIPCAT,IKP,IT,IIR,ITIME,ITIME0,IKA,ITA,ITCOUN,
     *ICODE,ITMODE,ITM0,ITMOD,IPTYPE,IPACAT,ITROLD,NPARM1,
     *MAXPAR,MP,IPA,NCXLAS,ITRACE,NPARM,ITRGAP,ITRACK,ITOLD,NERCOV
      REAL*8 CLAT,SLAT,RLON,SINLA0,COSLA0,RLONG0,
     *DX,DY,DZ,EPS1,EPS2,EPS3,S1,AX2,E22,D0,D1,D2,D3,D4,D5,RE,
     *RADSEC,PI,GMC,CLON,SLON,COSDLO,SINDLO,W2,W,RN,RNH,HP,RM,RMH,
     *APARM,SFACT,CTIME
      PARAMETER (NIPT=1500,MAXO=16200,NIPCAT=100002)
      LOGICAL LF,LT,LCOERR,LLCOER,LCTIME
      COMMON /ITRANC/SINLA0,COSLA0,RLONG0,
     *DX,DY,DZ,EPS1,EPS2,EPS3,S1,AX2,E22
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      COMMON/CCTIME/CTIME(NIPCAT),ITRACE(NIPCAT),ITMODE,ITM0,ITMOD,
     *ITRGAP,ITRACK,ITOLD,NERCOV,LCTIME,LCOERR,LLCOER
C
      IKA = IKP
      IF (IKP.GT.25) IKA = IKA-10
      IF (IT.EQ.0) GO TO 3799
      IF (IT.GT.7.AND.IT.LT.11) GO TO 11
C     IF (IABS(IT).GT.10) GO TO 3797
      IF (IABS(IT).GT.1000) GO TO 3797
      ITA=MOD(IT,50)
      CLON =  COS(RLON)
      SLON =  SIN(RLON)
      GO TO 12
C
   11 COSDLO = COS(RLON-RLONG0)
      SINDLO = SIN(RLON-RLONG0)
C
   12 W2 = D1-E22*SLAT**2
      W =  SQRT(W2)
      RN = AX2/W
      RNH= RN+HP
      RM = AX2*(D1-E22)/(W*W2)
      RMH= RM+HP
C
      IF (IKA.EQ.2.OR.IKA.EQ.13.OR.(IKA.GT.17.AND.IKA.LT.26))
     *GO TO 3797
C
      GO TO (3701,3799,3703,3704,3703,3701,3703,3704,3799,3799,
     *3701,3799,3799,3799,3797,3703,3704),IKA
C
 3701 GO TO (21,22,23,24,25,26,27,28,29,30),ITA
C DERIVATIVES RELATED TO THE HEIGHT ANOMALY (ZETA) OR TO HEIGHT
C DIFFERENCES, CF. PG EQ.(5-55).
   21 APARM = -CLAT*CLON
      GO TO 3798
   22 APARM = -CLAT*SLON
      GO TO 3798
   23 APARM = -SLAT
      GO TO 3798
   24 APARM = -AX2*W+HP
      GO TO 3798
   25 APARM = -RN*E22*SLAT*CLAT*SLON
      GO TO 3798
   26 APARM = RN*E22*SLAT*CLAT*CLON
      GO TO 3798
   27 APARM = D0
      GO TO 3798
C NEXT THREE CASES CF. PG, EQ. (5-59).
   28 APARM = -(COSLA0*SLAT-SINLA0*CLAT*COSDLO)*RMH/RADSEC
      GO TO 3798
   29 APARM = -CLAT*SINDLO*RNH/RADSEC
      GO TO 3798
   30 APARM = SINLA0*SLAT+COSLA0*CLAT*COSDLO
      GO TO 3798
C
 3703 GO TO (41,42,43,44,45,46,47,48,49,50),ITA
C DERIVATIVES RELATED TO LATITUDE/KSI.
   41 APARM = -SLAT*CLON*RADSEC/RMH
      GO TO 3798
   42 APARM = -SLON*SLAT*RADSEC/RMH
      GO TO 3798
   43 APARM = CLAT*RADSEC/RMH
      GO TO 3798
   44 APARM = -RN*E22*SLAT*CLAT/RMH
      GO TO 3798
   45 APARM = -SLON*(AX2*W+HP)/RMH
      GO TO 3798
   46 APARM = CLON*(AX2*W+HP)/RMH
      GO TO 3798
   47 APARM = D0
      GO TO 3798
C CF. PG EQ.(5-59).
   48 APARM = CLAT*COSLA0+SLAT*SINLA0*COSDLO
      GO TO 3798
   49 APARM = -SLAT*SINDLO
      GO TO 3798
   50 APARM = -(SINLA0*CLAT-COSLA0*SLAT*COSDLO)*RADSEC/RMH
      GO TO 3798
C
 3704 GO TO (61,62,63,63,65,66,67,68,69,70),ITA
C DERIVATIVES RELATED TO CLAT*LONGITUDE/ETA, CF. PG EQ.(5-55).
   61 APARM = -SLON*RADSEC/RNH
      GO TO 3798
   62 APARM = CLON*RADSEC/RNH
      GO TO 3798
   63 APARM = D0
      GO TO 3798
   65 APARM = SLAT*CLON*(D1-E22*RN/RNH)
      GO TO 3798
   66 APARM = SLAT*CLON*(D1-E22*RN/RNH)
      GO TO 3798
   67 APARM = -CLAT
      GO TO 3798
   68 APARM = SINLA0*SINDLO
      GO TO 3798
   69 APARM = COSDLO
      GO TO 3798
   70 APARM = COSLA0*SINDLO*RADSEC/RNH
      GO TO 3798
C
 3797 IF (IT.GT.10000)APARM = D1
C IT NEGATIVE IDENTIFIES THE SECOND PARAMETER ASSOCIATED WITH A
C TILT PARAMETER. 
      IF (IT.GT.10.AND.IT.LT.10000) APARM=SFACT(IIR)
C SCALE FACTOR ADDED 2004-12-19.
      IF (IT.LT.0)APARM=FLOAT(ITIME(IIR)) 
      GO TO 3798
 3799 APARM=D0
 3798 RETURN
      END
      SUBROUTINE PARCAT(LALLP,NPNO)
C PROGRAMMED FEB. 1985 BY C.C.TSCHERNING. LATEST UPDATE:
C AUG. 1993 BY CCT. 
C THE SUBROUTINE INITIALIZES THE PARAMETER CATALOGUES IPACAT AND
C IPTYPE. WHEN THE LOGICAL VARIABLE LALLP IS FALSE, IT IS CHECKED
C WHETHER THE PARAMETERS STORED IN IPACAT(IPA+1),...,IPACAT(IPA+MP)
C ARE NEW PARAMETERS, AND THE CATALOGUE IPTYPE AND THE COUNTER
C NPARM ARE UPDATED. WHEN LALLP IS TRUE, IT IS CHECKED WHETHER
C THE PARAMETER CODES STORED IN IPACAT ARE ACCEPTABLE PARAMETERS,
C I.E. FOUND IN IPTYPE. IF NOT FOUND, THEY ARE PUT EQUAL TO ZERO.
C
C PARAMETERS IN CALL AND COMMON BLOCK CPARM:
C  IPACAT (CALL AND RETURN, INTEGER ARRAY OF DIMENSION 3*NIPT) HOLDS
C                 PARAMETER CODES TO BE CHECKED IN VARIABLES WITH
C                 SUBSCRIPTS IPA+1 TO IPA+MP.
C  IPTYPE (CALL AND RETURN, INTEGER ARRAY OF DIMENSION NIPT) HOLDS
C                 FOR LALLP TRUE ALL ACCEPTABLE PARAMETER CODES AND
C                 FOR LALLP FALSE ALL EARLIER ACCEPTED CODES
C                 AND AT RETURN ALL CURRENTLY ACCEPTED CODES.
C  IPA    (CALL, INTEGER) IPA+1 POINTS AT CALL AT FIRST NEW PARAMETER
C                 CODE IN IPACAT.
C  NPARM  (CALL AND RETURN) ACTUAL NUMBER OF ACCEPTED PARAMETERS.
C  MP     (CALL, INTEGER) IPA+MP POINTS AT LAST ACCEPTED PARAMETER.
C  NPNO   (RETURN,INTEGER) RETURNS THE PARAMETER NUMBER OF THE
C                 PARAMETER ASSOCIATED WITH IPACAT(IPA+MP).
C
      IMPLICIT NONE 
      INTEGER NIPT,NIPCAT,IPTYPE,NPARM,NPARM1,MAXPAR,MP,IPA,
     *NCXLAS,I,J,NPNO,IPACAT,ICODE,ITROLD,ITIME,ITIME0
      REAL*8 SFACT
      PARAMETER(NIPT=1500,NIPCAT=100002)
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      LOGICAL LALLP, LSAME
C
      DO 10 I = 1, MP
      LSAME = .FALSE.
      DO 20 J = 1, NPARM
      IF (.NOT.LSAME)NPNO=J 
   20 LSAME = LSAME .OR. (IPACAT(IPA+I).EQ.IPTYPE(J))
      IF (LSAME) GO TO 10
      IF (LALLP) GO TO 50
C
      NPARM = NPARM+1
      IF (NPARM.EQ.MAXPAR) THEN
C CORRECTION 2003-12-28.
       WRITE(6,99)MAXPAR
   99  FORMAT(' *** WARNING *** TOO MANY PARAMETERS, MAXPAR = ',I6)
       STOP
      END IF
      IPTYPE(NPARM) = IPACAT(IPA+I)
C THE PARAMETER TYPE CATALOGUE IS UPDATED.
      GO TO 10
C
   50 IPACAT(IPA+I) = 0
C PARAMETER CODE = 0 MEANS INDEPENDENT OF PARAMETERS.
   10 CONTINUE
      RETURN
      END
      SUBROUTINE WRPAR
C PROGRAMMED FEB. 1985 BY C.C.TSCHERNING, LATEST UPDATE: MAR, 10, 2005 BY CCT.
C PARAMETER TYPE 11, SCALE FACTOR ADDED.
C THE SUBROUTINE LISTS THE PARAMETERS.
      IMPLICIT NONE
      INTEGER IB,IBT,IBS,NIPT,NPARM,IBA,IPTYPE,IPACAT,ITIME,
     *ITIME0,ITROLD,ICODE,NCXLAS,IPA,MP,MAXPAR,IPKIND,JI,I,NPARM1,
     *NIPCAT
      REAL*8 SFACT
      PARAMETER (NIPT=1500,NIPCAT=100002)
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
      DIMENSION IPKIND(NIPT)
      WRITE(6,149)NPARM
  149 FORMAT('0NUMBER OF PARAMETERS=',I4)
      NPARM1 = NPARM+1
C IB COUNTS BIAS PARAMETERS, IBT TILT-PARAMETERS AND IBS SCALE FACTORS.
      IB = 0
      IBT=0 
      IBS=0
      IBA=0
      DO 1302 I = 1, NPARM
C     WRITE(*,*)' IPTYPE(I),I ',IPTYPE(I),I
      JI = IABS(IPTYPE(I)) 
      IF (JI.GT.10) GO TO 1312
C PARAMETERS OF TYPE BETWEEN 11 AND 999 ARE SCALE FACTORS.
      JI=MOD(JI,50)
      GO TO (1303,1304,1305,1306,1307,1307,1307,1309,1310,1311),JI
 1303 WRITE(6,151)
  151 FORMAT('  DELTA X')
      GO TO 1302
 1304 WRITE(6,152)
  152 FORMAT('  DELTA Y')
      GO TO 1302
 1305 WRITE(6,153)
  153 FORMAT('  DELTA Z')
      GO TO 1302
 1306 WRITE(6,154)
  154 FORMAT('  DELTA L')
      GO TO 1302
 1307 JI = 8-IPTYPE(I)
      WRITE(6,155)JI
  155 FORMAT('  EPS',I1)
      GO TO 1302
 1309 WRITE(6,156)
  156 FORMAT(' DKSI0')
      GO TO 1302
 1310 WRITE(6,157)
  157 FORMAT(' DETA0')
      GO TO 1302
 1311 WRITE(6,158)
  158 FORMAT(' DH ')
      GO TO 1302
 1312 JI = IABS(IPTYPE(I))
      IF (IPTYPE(I).LT.10000.AND.IPTYPE(I).GT.10) IBS=IBS+1
      IF (IPTYPE(I).GT.10000) IB = IB+1
      IF (IPTYPE(I).LT.0) IBT=IBT+1 
      IBA=IBA+1
      IPKIND(IBA) = JI
 1302 CONTINUE
C
      IF (IB.GT.0.AND.IBT.EQ.0) WRITE(6,160)(IPKIND(I),I=1,IB)
      IF (IBS.GT.0.AND.IBT.EQ.0) WRITE(6,159)(IPKIND(I),I=1,IB)
      IF (IB.GT.0.AND.IBT.GT.0.AND.IBS.EQ.0)
     * WRITE(6,161)(IPKIND(I),I=1,IB+IBT)
      IF (IB.GT.0.AND.IBT.GT.0.AND.IBS.GT.0)
     * WRITE(6,162)(IPKIND(I),I=1,IB+IBT+IBS)
  159 FORMAT(' SCALE FACTOR ')
  160 FORMAT(' BIAS-PARAMETERS',/,(9I8))
  161 FORMAT(' BIAS AND TILT PARAMETERS',/,(9I8))
  162 FORMAT(' BIAS,TILT AND SCALE PARAMETERS',/,5(9I8,/))
C
      RETURN
      END
      SUBROUTINE CXPARM(SINLAP,COSLAP,RLONGP,HP,IKA)
C PROGRAMMED FEB. 1985 BY C.C.TSCHERNING, LATEST UPDATE: 02 APR 1998.
C THE SUBROUTINE COMPUTES THE CONTRIBUTIONS FROM OBSERVATIONS WHICH
C ONLY DEPEND ON PARAMETERS. THE CONTRIBUTIONS ARE ACCUMULATED IN CX.
C
C CURRENTLY 3 DATATYPES ARE ACCEPTED WITH DATA KIND CODES 6, 7 AND 9.
C   ELLIPSOIDAL HEIGHT DIFFERENCE (6)
C   DIFFERENCE BETWEEN LATITUDE AND LONGITUDE (*COS(LATITUDE)) (7)
C   SATELLITE ALTIMETRY CROSS-OVER DIFFERENCES (9).
C THE OCCURRENCE OF THE LAST DATA TYPE IS THE REASON THAT THE FACTOR
C II CHANGES FROM PLUS TO MINUS 1, WHEN THE SECOND PARAMETER IS FOUND.
C
      IMPLICIT NONE
      INTEGER  NCX,NEQIV,NIPT,NIPCAT,NCOFF,NROOT,NIICC,NNSU
C THE ARRAY CX IS USED TO HOLD CONTRIBUTION FROM PARAMETERS
C AND AN ARRAY WITH THE CONTRIBUTIONS DIM 320, ALL IN DOUBLE
C PRECISION.
C     PARAMETER (NCOFF=3243602,NROOT=3602,NIICC=1621801,NNSU=18010)
      PARAMETER (NCOFF=4844402,NROOT=4402,NIICC=2422201,NNSU=22010)
C     PARAMETER (NCX=126000,NEQIV=130001,NIPT=1500,
      PARAMETER (NCX=28920,NEQIV=130001,NIPT=1500,
     *NIPCAT=100002)
      REAL *4 COFF
      REAL*8 OBS,D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,
     *DUMMY,PW,CX,TU,U,HP,SINLAP,COSLAP,RLONGP,APARM,SFACT
      INTEGER ITCOUN,INUMR,NO1,K2,K3,K3P2,K4,IU,K21,IU1,IANG,
     *IPTYPE,IPACAT,NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS ,
     *IB,IER,IKP,IKA,IKK,I,ITP,II,J,IK,IGG,NEWCX,K,
     *IK1,ITIME,ITIME0,ITROLD,ICODE
      LOGICAL LSAME,LREPEC,LONECO,LF,LT,
     *LTERMA,LTERMO,LTERM,LTEST,
     *LPUNCH,LOUTC,LNTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
C
      COMMON /OBSER/OBS(22)
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      COMMON /OUTC/INUMR(12),NO1,K2,K3,K3P2,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LTERM,
     *LOUTC,LNTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
      COMMON/CPARM/SFACT(NIPCAT),IPTYPE(NIPT),
     *IPACAT(3*NIPT),ITIME(NIPCAT),
     *ITIME0(NIPT),ITROLD,ICODE(10),NPARM,NPARM1,MAXPAR,MP,IPA,NCXLAS
C NCXLAS POINTS AT THE LAST BLOCK OF UNIT 2 IN CORE (CX).1992.12.18. 
      COMMON /GPOTC0/DUMMY(16)
      COMMON /GPOTC3/COFF(NCOFF)    
      DIMENSION U(320),CX(NCX)
C     EQUIVALENCE (COFF(2),CX(1)),(COFF(NEQIV),U(1)) CH. 1998.07.06 CCT.
C     EQUIVALENCE (COFF(1),CX(1))
C
      IB = 2
      IER = K2
      LTEST=.FALSE.
      IF (LK30) IB = 3
      NPARM1 = NPARM+1
      IKP = IKA
      LREPEC = IKP.EQ.5.OR.IKP.EQ.7.OR.IKP.GT.25
      LONECO = .NOT.LREPEC
      IF (IKP.GT.25) IKP=IKP-10
C IKK POINTS AT A FICTIVE LAST COLUMN WITH LENGTH MAXPAR. THE
C CONTRIBUTION TO THE RIGHT HAND SIDE IS STORED IN THE LAST BLOCK
C OF UNIT 2, BECAUSE WE DO NOT YET KNOW THE NUMBER OF PARAMETERS. 
      IKK = MAXPAR*(MAXPAR+1)/2
C
   10 DO 21 I = 1, NPARM
      ITP = IPTYPE(I)
      II = 1
      LSAME=LF
      J = 0
   12 J = J+1
      LSAME=LSAME.OR.IPACAT(IPA+J).EQ.ITP
      IF ((.NOT.LSAME).AND.J.LT.MP) GO TO 12
C FOR CROSS-OVER DIFFERENCES THE CONTRIBITION IS NEGATIVE. 
      IF (IKP.EQ.9 .AND. J.EQ.2) II = -1
      U(I)=D0
   21 IF (LSAME) U(I) = APARM(COSLAP,SINLAP,RLONGP,HP,IKP,ITP,0)*II
C
      U(NPARM1) = OBS(IB)
      PW = OBS(IER)**(-2)
C
      IK = -1 
      READ(2,REC=1)CX
      IF (LTEST) THEN
       WRITE(*,*)' READH 2 ',(CX(IGG),IGG=1,6)
      END IF
      NCXLAS=1
      DO 41 I = 1, NPARM1
       IF (I.EQ.NPARM1) IK=IKK-1 
       DO 41 K = 1, I
        IK = IK+1
        TU = U(I)*U(K)*PW
        IF (ABS(TU).GT.-1.0D-10) THEN
C BLOCKING OF CX IMPLEMENTED 1992.12.18 BY CCT. 
         NEWCX = IK/NCX+1 
         IK1 = MOD(IK,NCX)+1 
         IF (NEWCX.NE.NCXLAS) THEN
          IF (NCXLAS.GT.0) THEN
           WRITE(2,REC=NCXLAS)CX
           IF (LTEST) THEN
           WRITE(6,*)' DUNIT 2, BLOCK ',NCXLAS,' WRITTEN' 
           WRITE(*,*)(CX(IGG),IGG=1,6)
           END IF
          END IF 
          READ(2,REC=NEWCX)CX 
          IF (LTEST) THEN
          WRITE(*,*)' EUNIT 2,READ BLOCK ',NEWCX
          WRITE(*,*)(CX(IGG),IGG=1,6)
          END IF
          NCXLAS=NEWCX
         END IF 
        END IF
        CX(IK1) = CX(IK1)+U(I)*U(K)*PW
   41  CONTINUE 
       WRITE(2,REC=NEWCX)CX
       IF (LTEST) THEN
       WRITE(6,*)' FUNIT 2, BLOCK ',NEWCX,' WRITTEN' 
       WRITE(*,*)(CX(IGG),IGG=IK1-3,IK1)
       END IF
C
      IF (LONECO) GO TO 69
C
      IB = IB+10
      IER = IER+10
      IKP = 4
      LONECO = LT
      GO TO 10
C
   69 RETURN
      END
      SUBROUTINE MEAN1(FILTER,NFILTE,SAZP,CAZP,LFILTE,LGRID,LINTER) 
C PROGRAMMED 1992.12.11 BY CCT. LAST UPDATE:  1995.01.16 BY CCT.
C IF DOUBLE PRECISION IS NEEDED, ACTIVATE THE FOLLOWING STATEMENT:
      IMPLICIT NONE
      REAL*8 FILTER,SAZP,CAZP,SFILT,AZP,DEGRAD
      LOGICAL LFILTE,LGRID,LINTER
      INTEGER NFILTE,I
C
      DIMENSION FILTER(11)
      IF (.NOT.LFILTE) THEN
C IF 1-D MEANS ARE USED, IT IS HERE POSSIBLE TO INPUT UP TO 5 WEIGHTS
C WITH SUM EQUAL TO NUMBER OF WEIGHTS (NFILTE). ONLY ONE SET OF WEIGHTS
C MUST BE USED.
C CHANGE 1992.11.26 BY C.C.TSCHERNING. 
      IF (LGRID) 
     *WRITE(6,*)' 1-D MEANS NOT TO BE USED WITHOUT CAUTION' 
      IF (LINTER) WRITE(*,*)' INPUT NUMBER OF FILTER FACTORS '
      READ(*,*)NFILTE 
      IF (LINTER) WRITE(*,*)' INPUT ',NFILTE,' FILTER FACTORS '
      READ(*,*)(FILTER(I),I=1,NFILTE) 
      DO 2073, I=1,NFILTE
 2073 SFILT=SFILT+ABS(FILTER(I)) 
      IF (ABS(SFILT-NFILTE).GT.1.0D-5) WRITE(6,*)
     *' *** WARNING *** FILTER MUST SUM TO NFILTE.' 
      LFILTE=.TRUE. 
      END IF 
      IF (LGRID)  THEN 
      IF (LINTER)WRITE(6,*)' INPUT AZIMUTH IN DEGREES ' 
      READ(*,*) AZP
      DEGRAD=3.1415926535D0/180.0D0 
      SAZP = SIN(AZP*DEGRAD)
      CAZP = COS(AZP*DEGRAD)
      END IF 
C
      RETURN
      END 
C ---------------------------------------------------
      SUBROUTINE HEAD(IKP,LONECO,PWO,LSATP)
C PROGRAMMED APR 1974 BY C.C.TSCHERNING, LAST UPDATE JAN 2005 BY CCT.
C OUTPUT OF HEADINGS AND INITIALIZATION OF THE FOLLOWING VARIABLES:
C IA,IB,IP,IT,I1,IA1,IB1,IP1,IT1,I21,I31,ICI,IC11 (ALL SUBSCRIPTS OF
C DIFFERENT  QUANTITIES), K2 - K4 (SUBSCRIPT BOUNDARIES FOR OUTPUT
C QUANTITIES), K1 = UPPER LIMIT FOR QUANTITIES READ INTO OBS.
C IF DOUBLE PRECISION, ACTIVATE:
      IMPLICIT NONE
      LOGICAL LONECO,LPUNCH,LOUTC,LNERNO,LK30,LPOT0,LC10,LNUOUT,
     *LCREF0,LKM,LPOT,LC20,LF,LC1,LC2,LCREF,LTRAN,LERNO,LWRSOL,LSATP,
     *LTERMA,LTERMO,LTERM,LK31,LSTOP,LCOD,LTERRC,LPOTIN,LSWI,LK2EQ4
      INTEGER INUMR,NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,
     *IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,IKP,KADD,IREL,
     *KM10,KMR,IC2
      REAL*8 PWO
C
      COMMON/OUTC/INUMR(12),NO1,K2,K3,K2P3,K4,IU,K21,IU1,IANG,LPUNCH,
     *LTERMA,LTERMO,LTERM,
     *LOUTC,LTRAN,LNERNO,LK30,LK31,LWRSOL,LSTOP,LK2EQ4,LNUOUT
      COMMON /CHEAD/IA,IB,IH,IP,IT,IA1,IB1,IP1,IT1,IC1,IC11,K1,IOBS1,
     *IOBS2,ITE,ITE1,IITE,IITE1,IIP,IIP1,IIE,IIE1,INO,
     *LPOT0,LKM,LTERRC,LPOTIN
      COMMON /CHEAD1/LC10,LC20,LCREF0
C
      LF = .FALSE.
      LPOT = LPOT0
      LC1 = LC10
      LC2 = LC20
      LCREF = LCREF0
      LCOD = IKP.GT.5 .AND. IKP.LT.10
      IF (LCOD) LPOT = LF
      LERNO = .NOT.LNERNO
      LSWI=IOBS2.GT.0.AND.(IABS(IOBS2-IOBS1).EQ.1)
      IT=11
      K1 = 0
      IIE=0
      IIE1=0
      IIP=0
      IIP1=0
      IITE=0
      IITE1=0
      LPOTIN=LF
      LTERRC=LF
      IF (IH.NE.0) K1=1
      KADD=1
      IREL=2
      IF (INO.NE.0)IREL=IREL+1
C
      IF (IOBS2.EQ.0) GO TO 2303
      KADD=2
      KM10=MOD(IOBS2,10)
      KMR=(IOBS2-KM10)/10
      IF (KM10.EQ.0.AND.IH.EQ.0) KM10=IREL
      IF (KM10.EQ.0.AND.IH.NE.0) KM10=IH
      IOBS2=KM10-IREL
      IF (LERNO) IIE1=IOBS2+1
      IF (LSWI.AND.LERNO)IIE1=IOBS2+2
      IIP1=MOD(KMR,10)
      IITE1=(KMR-IIP1)/10
      IF (IITE1.NE.0) IITE1=IITE1+IOBS2
      IF (KM10.EQ.IH.OR.KM10.EQ.IREL) IOBS2=0
C
 2303 IF (IOBS1.EQ.0) GO TO 2304
      KM10=MOD(IOBS1,10)
      IF (KM10.EQ.0.AND.IH.EQ.0) KM10=IREL+1
      IF (KM10.EQ.0.AND.IH.NE.0) KM10=IH
C IF THERE IS NO OBSERVATION IN THE INPUT RECORD, WE SUPPOSE THAT
C THE POSITION OF ALL OTHER DATA ELEMENTS IS COUNTED RELATIVE TO
C THE HEIGHT OR THE LONGITUDE.
      KMR=(IOBS1-KM10)/10
      IOBS1=KM10-IREL
      IIP=MOD(KMR,10)
      IITE=(KMR-IIP)/10
      IF (IITE.NE.0) IITE=IITE+IOBS1
      IF (LERNO) IIE=IOBS1+1
      IF (LSWI)IIE=IOBS2+1
      IF (IIP.NE.0) IIP=IIP+IOBS1
      IF (KM10.EQ.IH.OR.KM10.EQ.IREL) IOBS1=0
C
C LTERRC AND LPOTIN ARE TRUE, IF TERRAIN CONTRIBUTION, POTENTIAL-
C COEFFICIENT CONTRIBUTION ARE INPUT AND NOT COMPUTED BY GEOCOL.
C IITE, IIP ARE THE SUBSCRIPTS IN THE INPUT ARRAY OBS.
      LTERRC=IITE.NE.0
      LPOTIN=IIP.NE.0
      IF ((IH.NE.0.AND.KM10.NE.IH).OR.(IH.EQ.0.AND.KM10.NE.IREL))
     *K1=K1+KADD
C CHANGE DEC 1986 TO PERMIT NO OBSERVATION IN INPUT RECORD.
      IF (LTERRC)K1=K1+KADD
      IF (LPOTIN)K1=K1+KADD
C
 2304 IF (IKP.GT.26) GO TO 2003
      GO TO (2008,2009,2010,2011,2012,2301,2302,2003,2003,2003,2008,
     *2312,2009,2314,2315,2010,2011,2318,2319,2320,2321,2322,2323,
     *2324,2325,2003),IKP
 2008 IF (LSATP) THEN
       WRITE(6,2204)
 2204 FORMAT('0   NO      LATITUDE     LONGITUDE     H  T M**2/S**2 ')
      ELSE
       WRITE(6,204)
  204 FORMAT('0   NO      LATITUDE     LONGITUDE     H    ZETA (M)')
      END IF
      GO TO 2013
 2009 WRITE(6,205)
  205 FORMAT('0   NO      LATITUDE     LONGITUDE     H   DELTA G (',
     *'MGAL)')
      GO TO 2013
 2010 IF (LSATP) WRITE(6,306)
      IF (.NOT.LSATP) WRITE(6,206)
  206 FORMAT(/,'  NO      LATITUDE     LONGITUDE     H   KSI (ARCSEC)')
  306 FORMAT(/,'  NO      LATITUDE     LONGITUDE     H    TY  MGAL  ')
      GO TO 2013
 2011 IF (LSATP) WRITE(6,307)
      IF (.NOT.LSATP) WRITE(6,207)
  207 FORMAT('0   NO      LATITUDE     LONGITUDE     H   ETA (ARCSEC)')
  307 FORMAT(/,'  NO      LATITUDE     LONGITUDE     H   TX  MGAL    ')
      GO TO 2013
 2012 WRITE(6,208)
  208 FORMAT('0   NO      LATITUDE     LONGITUDE     H    KSI/ETA (',
     *'ARCSEC)')
      GOTO 2013
 2003 WRITE(6,200)IKP
  200 FORMAT('0   NO      LATITUDE     LONGITUDE     H KIND=',I3)
      GO TO 2013
 2301 WRITE(6,201)
  201 FORMAT('0   NO      LATITUDE     LONGITUDE     H    HEIGHT DIF.')
      GO TO 2013
 2302 WRITE(6,202)
  202 FORMAT('0   NO      LATITUDE     LONGITUDE     H    LAT.,LONG*',
     *'COS(LAT) DIFF.')
      GO TO 2013
 2312 WRITE(6,312)
  312 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    GRA.DIST.',
     *' MGAL') 
      GO TO 2013
 2314 WRITE(6,314)
  314 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    D(DELG)/DZ',
     *' EU')    
      GO TO 2013
 2315 WRITE(6,315)
  315 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    TZZ   EU  ')    
      GO TO 2013
C COORDINATE SYSTEM: X - EAST, Y-NORTH, Z-UP. 
 2318 WRITE(6,318)
  318 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    D(DELG)/DX',
     *' EU')    
      GO TO 2013
 2319 WRITE(6,319)
  319 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    D(DELG)/DY',
     *' EU')    
      GO TO 2013
 2320 WRITE(6,320)
  320 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    TYZ   EU  ')    
      GO TO 2013
 2321 WRITE(6,321)
  321 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    TXZ   EU  ')    
      GO TO 2013
 2322 WRITE(6,322)
  322 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    TYY   EU  ')    
      GO TO 2013
 2323 WRITE(6,323)
  323 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    TXY (*2)',
     *' EU')    
      GO TO 2013
 2324 WRITE(6,324)
  324 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    TXX  EU ')    
      GO TO 2013
 2325 WRITE(6,325)
  325 FORMAT(//'   NO      LATITUDE     LONGITUDE     H    TYY-TXX ',
     *' EU')    
C
 2013 GO TO (2018,2019,2020,2021,2020,2020),IANG
 2018 WRITE(6,209)
  209 FORMAT('             D  M  S       D  M  S     M')
      GO TO 2022
 2019 WRITE(6,210)
  210 FORMAT('                D  M          D  M     M')
      GO TO 2022
 2020 WRITE(6,211)
  211 FORMAT('            DEGREES       DEGREES      M')
      GO TO 2022
 2021 WRITE(6,212)
  212 FORMAT('            GRADES        GRADES       M')
C
 2022 IF (LKM) WRITE(6,213)
  213 FORMAT('+',37X,'K')
C
C     WRITE(*,*)' LCOD, PWO= ',LCOD,PWO
      IF ((.NOT.LCOD).AND. ABS(PWO).GT.1.0D-6) WRITE(6,267)PWO
  267 FORMAT('+',45X,' STAN.DEV.= ',F11.6)
C
C WE NOW COMPUTE THE SUBSCRIPT OF THE DIFFERENT QUANTITIES, WHICH WILL
C BE STORED FOR LATER OUTPUT IN THE ARRAY OBS. THE DIFFERENCE BETWEEN
C THE OBSERVATION GIVEN IN THE ORIGINAL AND THE NEW REF.SYSTEM IN
C OBS(IT), THE CONTRIBUTION TO THE REF.POT. FROM THE HARMONIC EXPANSION
C IN OBS(IP), THE CONTRIBUTION FROM COLL.I IN OBS(IC1) AND FROM COLL.II
C IN OBS(IC2).
      IC1 = 11
      IF (LTRAN) GO TO 2105
      IF (LTERRC) GO TO 2401
      IF(LPOT) GO TO 2102
      IF (LC1) GO TO 2201
      IB = 4
      GO TO 2104
C
 2401 ITE=5
      IF (LPOT) GO TO 2402
      IF (LC1) GO TO 2403
      IB=5
      WRITE(6,280)
  280 FORMAT(66X,' TERR')
      GO TO 2104
C
 2402 IP=6
      IF (LC1) GO TO 2404
      IB=7
      WRITE(6,281)
  281 FORMAT(22X,' TERR    POT    PRED')
      GO TO 2104
C
 2404 IC1=7
      IF (LC2) GO TO 2405
      IB=8
      WRITE(6,282)
  282 FORMAT(22X,' TERR    POT   COLL1   PRED')
      GO TO 2104
C
 2405 IC2=9
      IB=10
      WRITE(6,283)
  283 FORMAT(22X,' TERR    POT   COLL1  COLL2  PRED')
      GO TO 2104
C
 2403 IC1=6
      IF (LC2) GO TO 2406
      IB=7
      WRITE(6,284)
  284 FORMAT(22X,' TERR   COLL1  PRED')
      GO TO 2104
C
 2406 IC2=7
      IB=8
      WRITE(6,285)
  285 FORMAT(22X,' TERR   COLL1  COLL2  PRED')
      GO TO 2104
C
 2201 IC1 = 5
      IF (LC2) GO TO 2101
      IB=5
      WRITE(6,250)
  250 FORMAT(66X,' PRED')
      GO TO 2104
C
 2101 IB=7
      IC2=6
      WRITE(6,251)
  251 FORMAT(21X,' COLL1  COLL2   PRED')
      GO TO 2104
C
 2102 IP=5
      IF (LC1) GO TO 2202
      IB = 5
      WRITE(6,245)
  245 FORMAT(66X,' POT')
      GO TO 2104
C
 2202 IC1 = 6
      IF (LC2) GO TO 2103
      IB=7
      WRITE(6,252)
  252 FORMAT(22X,' POT    COLL   PRED')
      GO TO 2104
C
 2103 IC2=7
      IB=8
      WRITE(6,253)
  253 FORMAT(22X,' POT   COLL1  COLL2  PRED')
      GO TO 2104
C
 2105 IT=5
      IF(LTERRC)GO TO 2411
      IF(LPOT) GO TO 2107
      IF (LC1) GO TO 2205
      IB = 5
      WRITE(6,246)
  246 FORMAT(66X,' TRA')
 2104 K3 = IB-4
      IU = IB
      GO TO 2110
C
 2411 ITE=6
      IF (LPOT)GO TO 2412
      IF (LC1) GO TO 2413
      IB=6
      WRITE(6,290)
  290 FORMAT(21X,'   TRA   TERR  TERR-TRA')
      GO TO 2109
C
 2412 IP=7
      IF (LC1) GO TO 2414
      IB=8
      WRITE(6,291)
  291 FORMAT(21X,'   TRA   TERR    POT   PRED  PRED-TRA')
      GO TO 2109
C
 2414 IC1=8
      IF (LC2) GO TO 2415
      IB=9
      WRITE(6,292)
  292 FORMAT(21X,'   TRA   TERR    POT   COLL1   PRED  PRED-TRA')
      GO TO 2109
C
 2415 IC2=9
      IB=10
      WRITE(6,293)
  293 FORMAT(21X,'   TRA   TERR    POT   COLL1  COLL2  PRED',
     *'  PRED-TRA')
      GO TO 2109
C
 2413 IC1=7
      IF (LC2) GO TO 2416
      IB=8
      WRITE(6,294)
  294 FORMAT(21X,'   TRA   TERR  COLL1  PRED  PRED-TRA')
      GO TO 2109
C
 2416 IC2=8
      IB=9
      WRITE(6,295)
  295 FORMAT(21X,'   TRA   TERR  COLL1  COLL2  PRED   PRED-TRA')
      GO TO 2109
C
 2205 IC1 = 6
      IF (LC2) GO TO 2106
      IB=6
      WRITE(6,254)
  254 FORMAT(21X,'  TRA    PRED PRED-TRA')
      GO TO 2109
C
 2106 IC2=7
      IB=8
      WRITE(6,255)
  255 FORMAT(21X,'  TRA   COLL1   COLL2  PRED  PRED-TRA')
      GO TO 2109
C
 2107 IP=6
      IF (LC1) GO TO 2208
      IB = 6
      WRITE(6,247)
  247 FORMAT(21X,'  TRA   POT   POT-TRA')
      GO TO 2109
C
 2208 IC1 = 7
      IF (LC2) GO TO 2108
      IB=8
      WRITE(6,256)
  256 FORMAT(21X,'  TRA    POT    COLL   PRED  PRED-TRA')
      GO TO 2109
C
 2108 IC2=8
      IB=9
      WRITE(6,257)
  257 FORMAT(21X,'  TRA    POT   COLL1  COLL2  PRED PRED-TRA')
 2109 K3=IB-3
      IU = IB+1
C
 2110 LK30 = K3.GT.0
      LK31 = K3.GT.1
C K3 IS THE NUMBER OF QUANTITIES IN THE SECOND OUTPUT SEQUENCE. IF
C IT IS LESS THAN OR EQUAL TO 1, THEN ONLY ONE LINE IS USED FOR
C OUTPUT. THIS IS REGISTERED BY LK31.
C
      IF (LC2) IA = IC2
      IF (.NOT.LCREF) IA = IC1
C
      IF (LOUTC) GO TO 2125
      IF(LERNO) GO TO 2112
      K2=1
      GO TO 2135
C
 2112 K2=2
      IF (LK31) WRITE(6,260)
  260 FORMAT('+  ERR')
      IF (.NOT.LK31) WRITE(6,270)
  270 FORMAT('+',44X,'  ERR')
      GO TO 2135
 2125 IF (LK30.OR.LERNO) GO TO 2127
      K2=2
      WRITE(6,271)
  271 FORMAT(44X,'  OBS')
      GO TO 2135
C
 2127 IF (LERNO) GO TO 2128
      K2=3
      IF (LK31) WRITE(6,262)
  262 FORMAT('+  OBS    DIF')
      IF (.NOT.LK31) WRITE(6,272)
  272 FORMAT('+',44X,'  OBS    DIF')
      GO TO 2135
C
 2128 IF (LK30) GO TO 2111
      K2 = 3
      IF (LK30) WRITE(6,258)
  258 FORMAT(1X,'  OBS     ERR')
      IF (.NOT.LK30) WRITE(6,278)
  278 FORMAT(44X,'  OBS     ERR')
      GO TO 2135
C
 2111 K2 = 4
      IF (LK31) WRITE(6,263)
  263 FORMAT('+  OBS    DIF    ERR')
      IF (.NOT.LK31) WRITE(6,273)
  273 FORMAT('+',44X,'  OBS    DIF    ERR')
C
 2135 K4 = K2
      K2P3=K2
      LK2EQ4=K2.EQ.4
      IF (LK2EQ4) K2P3=K2+K3
C LK2EQ4 IS TRUE, IF ONE OUTPUT SEQUENCE CAN BE WRITTEN AS AN
C UNBROKEN LINE. OTHERWISE IT IS WRITTEN IN TWO PARTS, SEE THE
C SUBROUTINE OUT.
C
      IT1 = IT
      IP1 = IP
      IF (LONECO) GO TO 2313
      IB1 = IB+10
      IU1 = IU+10
      IA1 = IA+10
      IT1 = IT+10
      ITE1=ITE+10
      IP1 = IP+10
      IC11 = IC1+10
      K4 = 2*K2-1
 2313 K21 = K2+10
C
      RETURN
      END
      FUNCTION GPOTDR(NMAX,ORDER,SU,SU8)
C
C  MODIFICATION OF JULY 1984 FOR INCLUSION IN GEOCOL-PROGRAM OF
C  GI REG.NO. 81013 AUTHOR -C.C.TSCHERNING, DANISH GEODETIC INSTITUTE
C                                      JULY 1981 IN ALGOL REF.(2)
C                          -C.C.GOAD, NOAA/NOS/NATIONAL GEODETIC SURVEY
C                                      MAY 1982 TRANSLATED TO FORTRAN
C LATEST MODIFICATION DEC 2008 BY CCT.
C
C REFERENCES:
C (1) TSCHERNING, C.C.:ON THE CHAIN-RULE METHOD FOR COMPUTING
C     POTENTIAL DERIVATIVES. MANUSCRIPTA GEODAETICA, VOL.1,
C     PP. 125-141, 1976
C
C (2) TSCHERNING, C.C., AND PODER, K.: SOME APPLICATIONS OF CLENSHAW
C     SUMMATION, PRESENTED AT VIII SYMPOSIUM ON MATHEMATICAL GEODESY,
C     COMO, ITALY, SEPT 7-9, 1981
C
C  THE PROCEDURE COMPUTES THE VALUE AND UP TO THE SECOND-ORDER
C DERIVATIVES OF THE POTENTIAL OF THE EARTH (W) OR OF ITS
C CORRESPONDING ANOMALOUS POTENTIAL(T).
C
C  THE POTENTIAL IS REPRESENTED BY A SERIES OF SOLID SPHERICAL
C HARMONICS, WITH UN-NORMALIZED OR QUASI-NORMALIZED COEFFICIENTS.
C THE CHAIN-RULE IS USED ALONG WITH THE CLENSHAW ALGORITHM.
C THE ARRAY C MUST HOLD THE COEFFICIENTS C(1)=C(1,0),C(2)=C(1,1),
C C(3)=S(1,1), ETC. UP TO C((N+1)**2-1=S(N,N).  C(0,0) IS STORED IN C0
C WHICH IMPLICITLY ACTS AS C(0) (SEE THE COMMON BLOCK CM).
C
C
C PARAMETERS:
C
C (A) INPUT VALUES:
C
C NMAX
C    THE ABSOLUTE VALUE OF NMAX IS EQUAL TO THE MAXIMAL DEGREE AND
C    ORDER OF THE SERIES. NEGATIVE NMAX INDICATES THAT THE COEFFICIENTS
C    ARE QUASI-NORMALIZED. IN THIS VERSION NMAX MUST NOT EXCEED 2190
C
C ORDER
C    ORDER OF DERIVATIVES
C    0 FOR POTENTIAL ONLY
C    1 FOR POTENTIAL AND FIRST DERIVATIVES
C    2 FOR POTENTIAL, FIRST DERIVATIVES, AND SECOND DERIVATIVES
C
C EUCL
C    COMMON BLOCK HOLDING EUCLIDIAN RECTANGULAR COORDINATES (X,Y,Z),
C    DISTANCE AND SQUARE OF DISTANCE TO Z-AXIS AND ORIGIN XY, XY2,
C    DISTO AND DIST2.
C
C C
C    C((ABS(NMAX)+1)**2)    ARRAY OF C'S AND S'S DESCRIBED ABOVE
C    CM3=GM
C    CM2=A THE SEMI-MAJOR AXIS OF THE REFERENCE ELLIPSOID
C    CM1=THE SQUARE OF THE ANGULAR VELOCITY (=0,WHEN DEALING WITH T)
C    C(1)=1.0D0 FOR W AND =0.0D0 FOR T
C
C C20IN
C    HOLDS C(2,0) AS A REAL.
C
C
C    ROOT(K)=SQRT(K), 0.LE.K.LE.2(ABS(N)+1)-1  WHEN NMAX.LT.0
C
C
C (B) RETURN VALUES:
C
C G1 AND G2
C    THE RESULT IS STORED IN G1 AND G2 AS FOLLOWS (CH, JULY 1989):
C
C    G1(1)=DW/DY, G1(2)=DW/DX, G1(3)=DW/DZ
C    G2(1,1)=DDW/DYY, G2(1,2)=G2(2,1)=DDW/DXDY,
C    G2(1,3)=G2(3,1)=DDW/DYDZ, G2(2,2)=DDW/DXX,
C    G2(2,3)=G2(3,2)=DDW/DXDZ AND G2(3,3)=DDW/DZZ
C    WHERE W MAY BE INTERCHANGED WITH T AND
C    VARIABLES X, Y, Z ARE THE CARTESIAN COORDINATES
C    IN A LOCAL (FIXED) FRAME WITH ORIGIN IN THE POINT
C    OF EVALUATION, X POSITIVE NORTH, Y POSITIVE EAST,
C    AND Z POSITIVE IN THE DIRECTION OF THE RADIUS
C    VECTOR, (CF. REF.(1),EQ (4) AND (5)).
C    THE VALUES OF W OR T WILL BE RETURNED IN GPOTDR.
C
C (C)  PASSED AND RETURNED VALUES:
C
C SU AND SU8
C    ARRAYS OF DIMENSION K*(N+1), WHERE K=2 FOR NO DERIVATIVES,
C    =6 FOR 0-TH AND FIRST DERIVATIVES, =10 FOR 0-TH, FIRST AND
C    SECOND DERIVATIVES.  HERE ARE STORED THE PARTIAL SUMS, CF.
C    REF.(2), EQ. (29), OF P(N,M)*(A/R)**(N+1-M)/P(M,M)*(C(N,M) OR
C    S(N,M))  FROM N=M TO N=N, AND THE DERIVATIVES OF THESE SUMS.
C    THIS MAKES IT UNNECESSARY TO RECALCULATE THESE QUANTITIES, IF
C    THE PROCEDURE IS CALLED SUBSEQUENTLY WITH THE SAME VALUE OF T
C    AND R, AND THE SAME ORDER.
C
C
C GPOTC1
C    VARIABLES IN COMMON BLOCK GPOTC1 KEEPS CERTAIN CONSTANTS
C    WHICH REPEATEDLY ARE USED, AND KEEPS TRACK OF WHETHER ALREADY
C    STORED VALUES (IN SU OR SU8) CAN BE USED. 
C
      IMPLICIT NONE
      REAL*4 C
      INTEGER NCOEFF,NROOT,NNSU,NIICC,J,NLAST,NBMAX,NRE,I,NB,KB,
     *NMAXSV,NMAX,I5,I6,I7,I8,I9
C
C PARAMETERS GIVING THE SIZE OF THE ARRAYS HOLDING POTENTIAL
C COEFFICIENTS FOR MAX=360 (REALS), 360 (INTEGERS) AND 180. 
C360  PARAMETER (NCOEFF=130322,NROOT=722,NIICC=260642,NNSU=3610)
      PARAMETER (NCOEFF=4844402,NROOT=4402,NIICC=2422201,NNSU=22010)
C     PARAMETER (NCOEFF=3243602,NROOT=3602,NIICC=1621801,NNSU=18010)
C360I PARAMETER (NCOEFF= 65165,NROOT=722,NIICC=130321,NNSU=3610)
C180  PARAMETER (NCOEFF= 32761,NROOT=508,NIICC=65522,NNSU=2540) 
C 386 PARAMETER (NCOEFF= 2560,NROOT=722,NIICC=2560,NNSU=3610) 
C ON HP-9000 WE USE SINGLE-PRECISION VARIABLES TO STORE POTENTIAL
C COEFFICIENTS.
      INTEGER CAPN,ORDER,CAPN21,OLDORD,M2,M1,M0,M,KM,MAX2,ITWO,IM,
     *MPLUS1,K,N21
      LOGICAL QUASI,DERIV1,DERIV2,POLE
      LOGICAL FIRST,NEW,OLD,NPOLE,LINT,HP9000,L386
      REAL*8 G1,G2,GPOTDR,X,Y,Z,XY,XY2,DISTO,DIST2,ROOT,DZERO8,
     *CM1,CM2,CM3,C20IN,CFA,OLDT,OLDR
      REAL*8 SML8,CML8,SMLP18,CMLP18,SU8,P8,R8,S8,T8,U8,
     *SL8,CL8,T28,S28,CL28,SQNM18,SQNPM18,VC8,VS8,
     *VS18,VC18,VXS18,VXC18,VZC8,VZS8,
     *VXXC18,VXXS18,CKZ8,CK1Z8,OM28,S2C28,P208,
     *VZS18,VZC18,VXC8,VXS8,VXXC8,VXXS8,VZZC8,VZZS8,
     *VZZC18,VZZS18,VXZC8,VXZS8,
     *VXZC18,VXZS18,CM8,SM8,SQNM28,SQNPM28,SQ18,A18,B28,
     *A1T8,A1U8,CK8,CK18,V28
      REAL*8 U08,AUX8,M218,M21U8,M21T8,M21U08,VZZM8,VXYM8,
     *VXZM8,VYZM8,VXXM8,VYYM8,VXM8,VYM8,VZM8,VM8
      REAL*16 DZERO,SML,CML,SMLP1,CMLP1,SU,P,R,S,T,U,
     *SL,CL,T2,S2,CL2,SQNM1,SQNPM1,VC,VS,VS1,VC1,VXS1,VXC1,VZC,VZS,
     *VXXC1,VXXS1,CKZ,CK1Z,OM2,S2C2,P20,
     *VZS1,VZC1,VXC,VXS,VXXC,VXXS,VZZC,VZZS,VZZC1,VZZS1,VXZC,VXZS,
     *VXZC1,VXZS1,CM,SM,SQNM2,SQNPM2,SQ1,A1,B2,A1T,A1U,CK,CK1,V2
      REAL*16 U0,AUX,M21,M21U,M21T,M21U0,VZZM,VXYM,VXZM,VYZM,VXXM,VYYM,
     *VXM,VYM,VZM,VM
      INTEGER IZ,I1,I2,I3,I4,NM1,N1,NPM1,N,IN,NM2,NLEFT,N2
C
      DIMENSION SML(NROOT),CML(NROOT),SMLP1(NROOT),CMLP1(NROOT)
      DIMENSION SML8(NROOT),CML8(NROOT),SMLP18(NROOT),CMLP18(NROOT)
      DIMENSION SU(NNSU),SU8(NNSU)  
C IF HP9000 IS TRUE CHANGE DIMENSION OF IC TO THE HALF..
C
      COMMON/EUCL/X,Y,Z,XY,XY2,DISTO,DIST2
      COMMON/SQROOT/DZERO8,ROOT(NROOT)
C
      COMMON/GPOTC1/OLDT,OLDR,CFA,IZ,OLDORD,I1,I2,I3,I4,
     .  I5,I6,I7,I8,I9,NMAXSV,FIRST,HP9000
      COMMON/GPOTC0/C20IN,G1(3),G2(3,3),CM3,CM2,CM1
      COMMON /GPOTC3/C(NCOEFF)
      EQUIVALENCE(SML(1),SMLP1(2)),(CML(1),CMLP1(2))
      EQUIVALENCE(SML8(1),SMLP18(2)),(CML8(1),CMLP18(2))
C 
      J=IABS(NMAX)
      NLAST=(J+1)**2+1
      L386=NLAST.GT.NCOEFF
C WE SWITCH TO QUADRUPLE PRECISION IF NMAX .GT. 512.
      DZERO=0.0D0
      IF (L386) THEN
C IF THE ARRAY TO HOLD COEFFICIENTS IS TOO SMALL THEN IT WILL
C BE SUPPOSED THAT THE COEFFICIENTS ARE STORED ON DISK IN INVERTED
C ORDER. THEY ARE THEN READ BLOCKWISE FROM UNIT 9. C(0,0) AND
C C(2,0) ARE SUPPOOSED TO BE ZERO, AND THE VALUE OF C(2,0) IS STORED
C IN DOUBLE PRECISION IN C20IN. 
       NBMAX=NLAST/NCOEFF
       IF (NBMAX*NCOEFF.NE.NLAST) NBMAX=NBMAX+1
       NLAST=NLAST-1
       CFA=1.0D0
       NRE=NCOEFF
       IF (NRE.GT.NLAST)NRE=NLAST
       REWIND(9)
       READ(9)(C(I),I=1,NRE)
       NB=1
       KB=1
      END IF
      IF(NMAXSV.NE.NMAX)FIRST=.FALSE.
      NMAXSV=NMAX
      IF(FIRST)GO TO 100
      FIRST=.TRUE.
      OLDT=2.0D0
      I=J+1
      I1=I+1
      I2=I1+I
      I3=I2+I
      I4=I3+I
      I5=I4+I
      I6=I5+I
      I7=I6+I
      I8=I7+I
      I9=I8+I
  100 CAPN=NMAX
C DISTANCE FROM ROTATION AXIS
      P=XY
      P8=XY
C DISTANCE FROM ORIGIN
      R=DISTO
      R8=DISTO
C COSINE OF COLATITUDE
      T=Z/DISTO
      T8=Z/DISTO
C SINE OF COLATITUDE
      U=XY/DISTO
      U8=XY/DISTO
C SINE OF LONGITUDE
      SL=Y/XY
      SL8=Y/XY
C COSINE OF LONGITUDE
      CL=X/XY
      CL8=X/XY
      T2=T+T
      T28=T8+T8
C WE CHANGE FROM DOUBLE TO QUADRUPLE PRECISION IF ABS(LATITUDE) >
c 56 DEGREES AND ABS(NMAX) > 520. CHANGE 2008-07-01.
      LINT=ABS(NMAX).LT.520.OR.ABS(U).GT.0.559193D0
      POLE= ABS(U).LE.1.0D-9
      NEW= ABS(OLDR-R).GT.1.0D-3 .OR.  ABS(OLDT-T).GT.1.0D-9 .OR.
     .  OLDORD.NE.ORDER .OR. POLE
      OLD=.NOT.NEW
      NPOLE=.NOT.POLE
      IF(OLD)GO TO 200
      OLDR=R
      OLDT=T
      OLDORD=ORDER
  200 QUASI=.FALSE.
      IF(CAPN.LT.0)QUASI=.TRUE.
      IF(QUASI)CAPN=-CAPN
C COMPUTE AE/R
      S=CM2/R
      S8=CM2/R8
      S2=S**2
      S28=S8**2
      CMLP1(1)=1.0D0
      CMLP18(1)=1.0D0
C     CML(0)=1.0D0
      SMLP1(1)=0.0D0
      SMLP18(1)=0.0D0
C     SML(0)=0.0D0
      DERIV1=.FALSE.
      IF(ORDER.GT.0)DERIV1=.TRUE.
      DERIV2=.FALSE.
      IF(ORDER.GT.1) DERIV2=.TRUE.
C
C  SML(M) AND CML(M) ARE THE SINE AN COSINE OF M*LONGITUDE.
C  MODIFIED JAN 1989 AS PROPOSED BY C.GOAD.
C
C     SML(1)=SL
C     CML(1)=CL
      SMLP1(2)=SL
      CMLP1(2)=CL
      SMLP18(2)=SL8
      CMLP18(2)=CL8
      CL2=CL*2.0D0
      CL28=CL8*2.0D0
C
      M2=2
      M1=1
      M0=0
      DO 300 M=2,CAPN
C     SML(M)=SML(M1)*CL2-SML(M0)
C     CML(M)=CML(M1)*CL2-CML(M0)
      SMLP1(M+1)=SMLP1(M1+1)*CL2-SMLP1(M0+1)
      CMLP1(M+1)=CMLP1(M1+1)*CL2-CMLP1(M0+1)
      SMLP18(M+1)=SMLP18(M1+1)*CL28-SMLP18(M0+1)
      CMLP18(M+1)=CMLP18(M1+1)*CL28-CMLP18(M0+1)
      M0=M1
  300 M1=M
C
      CAPN21=CAPN+CAPN+1
      VM=0.0D0
      VXM=0.0D0
      VYM=0.0D0
      VZM=0.0D0
      SQNM1=1.0D0
      SQNPM1=1.0D0
      VM8=0.0D0
      VXM8=0.0D0
      VYM8=0.0D0
      VZM8=0.0D0
      SQNM18=1.0D0
      SQNPM18=1.0D0
      IF(.NOT.DERIV2) GO TO 400
      VXXM=0.0D0
      VYYM=0.0D0
      VZZM=0.0D0
      VXYM=0.0D0
      VXZM=0.0D0
      VYZM=0.0D0
      VXXM8=0.0D0
      VYYM8=0.0D0
      VZZM8=0.0D0
      VXYM8=0.0D0
      VXZM8=0.0D0
      VYZM8=0.0D0
  400 KM=(CAPN+1)**2+1
      MAX2=CAPN21
C
C WE NOW USE THE CLENSHAW ALGORITHM, CF. REF.(2), EQ(8-13),
C MODIFIED IN AN OBVIOUS WAY FOLLOWING REF.(1).
C
      ITWO=2
      DO IM=IZ,CAPN
      M=CAPN-IM
      MPLUS1=M+1
      IF(M.EQ.0)ITWO=1
      KM=KM-ITWO
      K=KM
      N21=CAPN21
      VS=0.0D0
      VC=0.0D0
      VS1=0.0D0
      VC1=0.0D0
      VXS1=0.0D0
      VXC1=0.0D0
      VZS=0.0D0
      VZC=0.0D0
      VZS1=0.0D0
      VZC1=0.0D0
      VXC=0.0D0
      VXS=0.0D0
      VS8=0.0D0
      VC8=0.0D0
      VS18=0.0D0
      VC18=0.0D0
      VXS18=0.0D0
      VXC18=0.0D0
      VZS8=0.0D0
      VZC8=0.0D0
      VZS18=0.0D0
      VZC18=0.0D0
      VXC8=0.0D0
      VXS8=0.0D0
      IF(.NOT.DERIV2)GO TO 500
      VXXC=0.0D0
      VXXS=0.0D0
      VXXC1=0.0D0
      VXXS1=0.0D0
      VZZC=0.0D0
      VZZS=0.0D0
      VZZC1=0.0D0
      VZZS1=0.0D0
      VXZC=0.0D0
      VXZS=0.0D0
      VXZC1=0.0D0
      VXZS1=0.0D0
      VXXC8=0.0D0
      VXXS8=0.0D0
      VXXC18=0.0D0
      VXXS18=0.0D0
      VZZC8=0.0D0
      VZZS8=0.0D0
      VZZC18=0.0D0
      VZZS18=0.0D0
      VXZC8=0.0D0
      VXZS8=0.0D0
      VXZC18=0.0D0
      VXZS18=0.0D0
  500 CM=CMLP1(MPLUS1)
      SM=SMLP1(MPLUS1)
      CM8=CMLP18(MPLUS1)
      SM8=SMLP18(MPLUS1)
      NM1=CAPN-M+2
      N1=CAPN+1
      NPM1=CAPN+M+2
      IF(DERIV2)M2=M*M
      IF(OLD)GO TO 1300
      N=CAPN+1
      IF (LINT) GO TO 1002
C
      DO 1000 IN=M,CAPN
      N=N-1
      NM2=NM1
      NM1=NM1-1
      NPM1=NPM1-1
C REF.(2) EQ.(40)
      IF(.NOT.QUASI) GO TO 600
C REF.(2) EQ(30B)
      SQNM2=SQNM1
      SQNM1=ROOT(NM1)
      SQNPM2=SQNPM1
      SQNPM1=ROOT(NPM1)
      SQ1=SQNM1*SQNPM1
      A1=S*N21/SQ1
      B2=-S2*SQ1/(SQNM2*SQNPM2)
      GO TO 700
C REF.(2), EQ.(30)
  600 A1=(S*N21)/NM1
      B2=-(S2*NPM1)/NM2
  700 A1T=A1*T
      A1U=A1*U
      N21=N21-2
      IF (L386) THEN
      CK=C(KB)
      CK1=C(KB+1)
      KB=KB+ITWO
      IF (KB.GE.NCOEFF) THEN
      KB=1
      NLEFT=NCOEFF
      IF (NB.EQ.NBMAX)NLEFT=NLAST-(NB-1)*NCOEFF
      NB=NB+1 
      READ(9)(C(I),I=1,NLEFT)
      END IF
      ELSE
      CK=C(K)
      CK1=C(K+1)
      END IF
      K=K-N21
C REF.(2), EQ(33)
      V2=VC1
      VC1=VC
      VC=VC1*A1T+V2*B2+CK
      V2=VS1
      VS1=VS
      VS=VS1*A1T+V2*B2+CK1
      IF(.NOT.DERIV1) GO TO 1000
      CKZ=CK*N1
      CK1Z=CK1*N1
C REF.(2),  EQ(10)
      V2=VXC1
      VXC1=VXC
      VXC=VXC1*A1T+VC1*A1U+V2*B2
      V2=VXS1
      VXS1=VXS
      VXS=VXS1*A1T+VS1*A1U+V2*B2
      V2=VZC1
      VZC1=VZC
      VZC=VZC1*A1T+V2*B2-CKZ
      V2=VZS1
      VZS1=VZS
      VZS=VZS1*A1T+V2*B2-CK1Z
      N1=N
      IF(.NOT.DERIV2) GO TO 1000
      N2=N+2
C REF.(2), EQ(41)
      V2=VZZC1
      VZZC1=VZZC
      VZZC=VZZC1*A1T+V2*B2+N2*CKZ
      V2=VZZS1
      VZZS1=VZZS
      VZZS=VZZS1*A1T+V2*B2+N2*CK1Z
      IF(NPOLE) GO TO 800
C REF.(2), EQ(12)      SECOND-ORDER DERIVATIVE WRT LATITUDE
      V2=VXXC1
      VXXC1=VXXC
      VXXC=A1T*(VXXC1-VC1)+(A1U+A1U)*VXC1+V2*B2
      V2=VXXS1
      VXXS1=VXXS
      VXXS=A1T*(VXXS1-VS1)+(A1U+A1U)*VXS1+V2*B2
C REF.(2) EQ(10,40) DERIVATIVE WRT R AND LATITUDE
  800 V2=VXZC1
      VXZC1=VXZC
      VXZC=VXZC1*A1T+VZC1*A1U+V2*B2
      V2=VXZS1
      VXZS1=VXZS
      VXZS=VXZS1*A1T+VZS1*A1U+V2*B2
 1000 CONTINUE
C
      GO TO 1003
 1002 DO 1001 IN=M,CAPN
      N=N-1
      NM2=NM1
      NM1=NM1-1
      NPM1=NPM1-1
C REF.(2) EQ.(40)
C REF.(2) EQ(30B)
      SQNM28=SQNM18
      SQNM18=ROOT(NM1)
      SQNPM28=SQNPM18
      SQNPM18=ROOT(NPM1)
      SQ18=SQNM18*SQNPM18
      A18=S8*N21/SQ18
      B28=-S28*SQ18/(SQNM28*SQNPM28)
      A1T8=A18*T8
      A1U8=A18*U8
      N21=N21-2
      CK8=C(K)
      CK18=C(K+1)
      K=K-N21
C REF.(2), EQ(33)
      V28=VC18
      VC18=VC8
      VC8=VC18*A1T8+V28*B28+CK8
      V28=VS18
      VS18=VS8
      VS8=VS18*A1T8+V28*B28+CK18
      IF(.NOT.DERIV1) GO TO 1001
      CKZ8=CK8*N1
      CK1Z8=CK18*N1
C REF.(2),  EQ(10)
      V28=VXC18
      VXC18=VXC8
      VXC8=VXC18*A1T8+VC18*A1U8+V28*B28
      V28=VXS18
      VXS18=VXS8
      VXS8=VXS18*A1T8+VS18*A1U8+V28*B28
      V28=VZC18
      VZC18=VZC8
      VZC8=VZC18*A1T8+V28*B28-CKZ8
      V28=VZS18
      VZS18=VZS8
      VZS8=VZS18*A1T8+V28*B28-CK1Z8
      N1=N
      IF(.NOT.DERIV2) GO TO 1001
      N2=N+2
C REF.(2), EQ(41)
      V28=VZZC18
      VZZC18=VZZC8
      VZZC8=VZZC18*A1T8+V28*B28+N2*CKZ8
      V28=VZZS18
      VZZS18=VZZS8
      VZZS8=VZZS18*A1T8+V28*B28+N2*CK1Z8
      IF(NPOLE) GO TO 801
C REF.(2), EQ(12)      SECOND-ORDER DERIVATIVE WRT LATITUDE
      V28=VXXC18
      VXXC18=VXXC8
      VXXC8=A1T8*(VXXC18-VC18)+(A1U8+A1U8)*VXC18+V28*B28
      V28=VXXS18
      VXXS18=VXXS8
      VXXS8=A1T8*(VXXS18-VS18)+(A1U8+A1U8)*VXS18+V28*B28
C REF.(2) EQ(10,40) DERIVATIVE WRT R AND LATITUDE
  801 V28=VXZC18
      VXZC18=VXZC8
      VXZC8=VXZC18*A1T8+VZC18*A1U8+V28*B28
      V28=VXZS18
      VXZS18=VXZS8
      VXZS8=VXZS18*A1T8+VZS18*A1U8+V28*B28
 1001 CONTINUE
C
 1003 IF (LINT) THEN
       SU8(M+1)=VC8
       SU8(M+I1)=VS8
      ELSE
       SU(M+1)=VC
       SU(M+I1)=VS
      END IF
      IF(.NOT.DERIV1) GO TO 1500
      IF (LINT) THEN
       SU8(M+I2)=VXC8
       SU8(M+I3)=VXS8
       SU8(M+I4)=VZC8
       SU8(M+I5)=VZS8
      ELSE
       SU(M+I2)=VXC
       SU(M+I3)=VXS
       SU(M+I4)=VZC
       SU(M+I5)=VZS
      END IF
      IF(.NOT.DERIV2) GO TO 1500
      IF (LINT) THEN
       SU8(M+I6)=VZZC8
       SU8(M+I7)=VZZS8
       SU8(M+I8)=VXZC8
       SU8(M+I9)=VXZS8
      ELSE
       SU(M+I6)=VZZC
       SU(M+I7)=VZZS
       SU(M+I8)=VXZC
       SU(M+I9)=VXZS
      END IF
      GO TO 1500
 1300 IF (LINT) THEN
       VC8=SU8(M+1)
       VS8=SU8(M+I1)
      ELSE
       VC=SU(M+1)
       VS=SU(M+I1)
      END IF
      IF(.NOT.QUASI) GO TO 1400
      IF (LINT) THEN
       SQNPM18=ROOT(MAX2)
       SQNPM28=ROOT(MAX2+1)
      ELSE
       SQNPM1=ROOT(MAX2)
       SQNPM2=ROOT(MAX2+1)
      END IF
 1400 NPM1=MAX2
      MAX2=MAX2-2
      IF(.NOT.DERIV1) GO TO 1500
      IF (LINT) THEN
       VXC8=SU8(M+I2)
       VXS8=SU8(M+I3)
       VZC8=SU8(M+I4)
       VZS8=SU8(M+I5)
      ELSE
       VXC=SU(M+I2)
       VXS=SU(M+I3)
       VZC=SU(M+I4)
       VZS=SU(M+I5)
      END IF
      IF(.NOT.DERIV2)GO TO 1500
      IF (LINT) THEN
       VZZC8=SU8(M+I6)
       VZZS8=SU8(M+I7)
       VXZC8=SU8(M+I8)
       VXZS8=SU8(M+I9)
      ELSE
       VZZC=SU(M+I6)
       VZZS=SU(M+I7)
       VXZC=SU(M+I8)
       VXZS=SU(M+I9)
      END IF
C
C THE COMPUTATION OF DERIVATIVES IN DIRECTION OF POS LONGITUDE,Y,
C INVOLVES THE DIVISION BY U=COS(LATITUDE).  THIS DIVISION IS
C PERFORMED IMPLICITLY, BY STOPPING THE CLENSHAW SUMMATION AT M=1.
C THIS IS DONE BY PUTTING U0=1.0.  THIS TRICK PERMITS THE USE OF THE
C PROCEDURE AT POLES, EXCEPT FOR THE SECOND-ORDER DERIVATIVE WRT
C LONGITUDE.  BUT HERE WE USE THE VALIDITY OF THE LAPLACE EQUATION
C AND COMPUTE THE SECOND-ORDER DERIVATIVES WRT X AND Z
C
 1500 IF (LINT) THEN
       U08=U8
       IF(M.EQ.0)U08=1.0D0
C REF.(2) EQ.(35)
       AUX8=NPM1
       IF(QUASI)AUX8=SQNPM18/SQNPM28
       M218=S8*AUX8
       M21U8=M218*U8
       IF(DERIV1) THEN       
        M21T8=M218*T8
        M21U08=M218*U08
        IF (DERIV2) THEN      
         VZZM8=VZZC8*CM8+VZZS8*SM8+M21U8*VZZM8
         IF(M.GT.0)VXYM8=M*(VXS8*CM8-VXC8*SM8)+M21U8*VXYM8-M21T8*VYM8
         VXZM8=VXZC8*CM8+VXZS8*SM8-M21T8*VZM8+M21U8*VXZM8
         VYZM8=(VZS8*CM8-VZC8*SM8)*M+M21U08*VYZM8
         IF(POLE) VXXM8=VXXC8*CM8+VXXS8*SM8+
     *   M218*(U8*(VXXM8-VM8)-T28*VXM8)
         IF(NPOLE)VYYM8=-(VC8*CM8+VS8*SM8)*M2+M21U08*VYYM8
        END IF
        VXM8=VXC8*CM8+VXS8*SM8-M21T8*VM8+M21U8*VXM8
        VYM8=M*(VS8*CM8-VC8*SM8)+M21U08*VYM8
        VZM8=VZC8*CM8+VZS8*SM8+M21U8*VZM8
       END IF
       VM8=VC8*CM8+VS8*SM8+M21U8*VM8
      ELSE
       U0=U
       IF(M.EQ.0)U0=1.0D0
C REF.(2) EQ.(35)
       AUX=NPM1
       IF(QUASI)AUX=SQNPM1/SQNPM2
       M21=S*AUX
       M21U=M21*U
       IF(DERIV1) THEN       
        M21T=M21*T
        M21U0=M21*U0
        IF (DERIV2) THEN      
         VZZM=VZZC*CM+VZZS*SM+M21U*VZZM
         IF(M.GT.0)VXYM=M*(VXS*CM-VXC*SM)+M21U*VXYM-M21T*VYM
         VXZM=VXZC*CM+VXZS*SM-M21T*VZM+M21U*VXZM
         VYZM=(VZS*CM-VZC*SM)*M+M21U0*VYZM
         IF(POLE) VXXM=VXXC*CM+VXXS*SM+M21*(U*(VXXM-VM)-T2*VXM)
         IF(NPOLE)VYYM=-(VC*CM+VS*SM)*M2+M21U0*VYYM
        END IF
        VXM=VXC*CM+VXS*SM-M21T*VM+M21U*VXM
        VYM=M*(VS*CM-VC*SM)+M21U0*VYM
        VZM=VZC*CM+VZS*SM+M21U*VZM
       END IF
       VM=VC*CM+VS*SM+M21U*VM
      END IF
      END DO
      IF (LINT) THEN
       VM=VM8
       IF (DERIV1) THEN
        VXM=VXM8
        VYM=VYM8
        VZM=VZM8
        IF (DERIV2) THEN
         VXXM=VXXM8
         VYYM=VYYM8
         VZZM=VZZM8
         VXZM=VXZM8
        END IF
       END IF
      END IF
C
C NOW THE CONTRIBUTIONS FROM THE ROTATIONAL POTENTIAL ARE ADDED
C
C COMPUTE OMEGA**2
      IF (R.GT.6400000.0D0) THEN
C     IF (R.GT.6388000.0D0) THEN - CHANGE 2008-12-28.
      OM2=0.0D0
      ELSE
      OM2=CM1
      END IF
C MODIFICATION JULY, 1984.
C COMPUTE GM/R
      S=CM3/R
      S8=CM3/R8
C
      IF (.NOT.L386) GO TO 1701
      S=S/CFA
      S2C2=S2*C20IN*CFA
      P20=(1.5*T*T-0.5D0)
      VM=(VM+S2C2*P20)+CFA
      IF (.NOT.DERIV1) GO TO 1701
      VXM=VXM+S2C2*U*T*3.0D0
      VZM=-CFA+(VZM-3.0D0*S2C2*P20)
      IF (.NOT.DERIV2) GO TO 1701
      IF (.NOT.NPOLE) VXXM=VXXM+3.0D0*(T*T-U*U)*S2C2
      VZZM=VZZM+2.0D0*CFA+12.0D0*S2C2*P20
      VXZM=VXZM-S2C2*9.0D0*U*T
C
 1701 IF (LINT) THEN
       GPOTDR=S8*VM8+OM2*P**2*0.5E0
      ELSE
       GPOTDR=S*VM+OM2*P**2*0.5E0
      END IF
      IF(.NOT.DERIV1) RETURN
C COMPUTE GM/R**2
      S=S/R
C CORRECTION JULY 1989: SUBSCRIPTS 1,2 IN G1 AND G2 INTERCHANGED. 
      G1(2)=S*VXM-T*P*OM2
      G1(1)=S*VYM
      G1(3)=VZM*S+U**2*OM2*R
      IF(.NOT.DERIV2) RETURN
C COMPUTE GM/R**3
      S=S/R
C HERE THE LAPLACE EQUATION IS USED
      IF(NPOLE) GO TO 1900
      VXXM=VXXM+VZM
      VYYM=-(VXXM+VZZM)
      GO TO 2000
 1900 VYYM=VZM+(VYYM-T*VXM)/U
      VXXM=-(VZZM+VYYM)
 2000 G2(2,2)=VXXM*S+OM2*T**2
      G2(1,2)=S*VXYM*M21
C CORRECTION 1988.08.23. BEFORE THIS THE M21 FACTOR WAS MISSING.
      G2(2,1)=G2(1,2)
      G2(2,3)=S*(VXZM-VXM)-U*T*OM2
      G2(3,2)=G2(2,3)
      G2(1,1)=VYYM*S+OM2
      G2(1,3)=S*(VYZM-VYM)
      G2(3,1)=G2(1,3)
      G2(3,3)=S*VZZM+U**2*OM2
  199 FORMAT(3E16.9)
      RETURN
      END
      SUBROUTINE LOADCS(DNAME,FMT,NMAX,LFMT,LBIN,LINT,LSKIPL)
C PROGRAMMED BY C.C.GOAD, NGS, 1981. MODIFIED JULY 2005 BY CCT.
      IMPLICIT NONE
      INTEGER NCOFF,NICC,NROOT,NNSU,IC,IZ,IOLDOR,IPO,
     *NLAST,NMAX,NSLINE,I,N21,NMT,NB,NC,NB0,NB1,N,M,ITWO,NMC,
     *J,K,NMAXSV,NBMAX
C360  PARAMETER (NCOFF=130322,NIICC=260642,NROOT=722)
C     PARAMETER (NCOFF=3243602,NROOT=3602,NICC=1621801,NNSU=18010)
      PARAMETER (NCOFF=4844402,NROOT=4402,NICC=2422201,NNSU=22010)
C360I PARAMETER (NCOFF= 65165,NICC=130321)
C180  PARAMETER (NCOFF= 32761,NICC= 65522)
C 386 PARAMETER (NCOFF= 2560,NICC= 2560,NROOT=722)
      LOGICAL LBIN,LFMT,LINT,FIRST,HP9000,L386,LNZERO,LSKIPL 
      REAL*4 C,C0,CNM,SNM
      REAL*8 DZERO,ROOT,C20IN,G1,G2,CM3,CM2,CM1,CFA,SQ2,C00,CNMD,
     *SNMD,S21,SQ2N1,OLDT,OLDR
      CHARACTER*128 DNAME
      CHARACTER*128 FMT,ALINE
C
      DIMENSION DNAME(2),FMT(9)
      COMMON/GPOTC0/C20IN,G1(3),G2(3,3),CM3,CM2,CM1
      COMMON /GPOTC3/C(NCOFF)
      COMMON /GPOTC1/OLDT,OLDR,CFA,IZ,IOLDOR,IPO(9),NMAXSV,FIRST
     *,HP9000
      COMMON /SQROOT/DZERO,ROOT(NROOT) 
C GPOTC1 IS ONLY USED HERE TO TRANSFER THE VALUE OF CFA TO GPOTDR.
      DIMENSION IC(NICC)
C IF HP9000 IS TRUE, CHANGE DIMENSION TO 37761.
      EQUIVALENCE (C(1),IC(1))
C
      NLAST=(NMAX+1)**2
      L386=NLAST.GT.NCOFF
      write(*,*)' nlast,ncoeff ',nlast,ncoff
      HP9000=.FALSE.
      CFA=1.0D0
      SQ2= SQRT(2.0D0)
      IF (LINT) CFA=1.0D12
      IF (LBIN.AND.(.NOT.L386)) OPEN(9,FILE=DNAME(1),STATUS='OLD',
     *FORM='UNFORMATTED')
C    *FORM='UNFORMATTED',RECL=8)
      IF (LBIN.AND.L386) OPEN(9,FILE=DNAME(1),STATUS='OLD',
     *FORM='UNFORMATTED')
      IF (LBIN.AND.L386) RETURN
C 
      IF (L386) THEN
C WHEN THERE IS TOO LITTLE SPACE FOR  THE COEFFICIENTS, AND THEY
C ARE NOT YET ON BINARY FORM, THEN THEY ARE HERE REFORMATTED TO
C A BINARY FORMAT. CHANGE 1992,12.15 BY CCT. 
      OPEN(39,FILE=DNAME(1),STATUS='OLD',FORM='FORMATTED')
C COEFF FILE MAY CONTAIN HEADING, WHICH MUST BE SKIPPED.
      IF (LSKIPL) THEN
       WRITE(*,*)' INPUT NUMBER OF LINES TO BE SKIPPED '
       READ(*,*)NSLINE
       IF (NSLINE.GT.0) THEN
        DO 386, I=1,NSLINE
 386    READ(39,'(A)')ALINE
       END IF
      END IF
C
      WRITE(6,*)' INPUT NAME OF OUTPUT FILE WITH BINARY COEFF. '
      READ(5,'(A)')DNAME(2)
      OPEN(9,FILE=DNAME(2),FORM='UNFORMATTED')
C
      LNZERO=.TRUE.
      DZERO=0.0D0
      N21=2*(NMAX+1)
      DO 50 I=1, N21
  50  ROOT(I)= SQRT(DFLOAT(I))

      NLAST=(NMAX+1)**2+1
C
      WRITE(6,102)
  102 FORMAT('  COEFFICIENTS UP TO N=5 ')
      NBMAX=NLAST/NCOFF
      IF (NBMAX*NCOFF.LT.NLAST) NBMAX=NBMAX+1
      NLAST=NLAST-1
      NMT=0
      NB=1
      NC=0
      NB0=0
      NB1=NCOFF
      WRITE(6,*)' BLOCKS USED FOR COEFF =',NBMAX
      C00=1.0D0
      DO 90 I=1,NCOFF
   90 C(I)=0.0E0
C
 1100 CONTINUE
      IF ((.NOT.LFMT).AND.NMAX.LT.201) READ(39,101)N,M,
     *CNMD,SNMD
      IF ((.NOT.LFMT).AND.NMAX.GT.200) READ(39,3601)
     *N,M,CNMD,SNMD
      IF (LFMT) READ(39,FMT)N,M,CNMD,SNMD
C
      IF (N .LT.5.AND.NB.EQ.1)
     *WRITE(6,103)N,M,CNMD,SNMD
      IF (MOD(N,101).EQ.0.AND.M.EQ.N.AND.M.GT.5)
     * WRITE(6,*)N,' DEG FINISHED READING '
      IF (N.GT.0) GO TO 1105
      LNZERO=.FALSE.
      C00 = CNMD
      C0 = C00
      IF (C00.LT.1.0D-8)THEN
      C00=1.0D0 
      CNMD=C00 
      END IF
 1105 CNMD=CNMD/C00
      SNMD=SNMD/C00
      IF (N.GT.NMAX .OR. M.GT.NMAX) GO TO 1100
      ITWO=2
      IF (M.EQ.0)ITWO=1
      NMC= (NMAX-M)*(NMAX-M+1)+(NMAX-N)*ITWO+1
      IF (NMC.LE.NB0.OR.NMC.GT.NB1) GO TO 300
      NMC=NMC-NB0
      S21= ROOT(2*N+1)
      IF (M.EQ.0) THEN
C STORE C20 IN DOUBLE PRECISION FOR LATER USE
      IF (N.EQ.2) THEN
      C20IN=CNMD*S21
      CNMD=0.0D0
      END IF
      CNM=CNMD*S21
      NC=NC+1
      ELSE
      CNM=CNMD*S21*SQ2
      SNM=SNMD*S21*SQ2
      NC=NC+2
      END IF
      C(NMC)=CNM
      NMT=NMT+1
      IF (M.NE.0) THEN
       NMT=NMT+1
       C(NMC+1)=SNM
C      WRITE(6,*)NMT,NMC,NC,N,M
      END IF
 300  IF ((N.EQ.NMAX.AND.M.EQ.NMAX).OR.NMT.GE.NCOFF) THEN
       IF (NMT.NE.NCOFF) WRITE(6,*)' ONLY ',NMT,' COEFF IN BLOCK ',NB
       IF (NB.EQ.NBMAX) C(NLAST-NB0)=0.0D0
       WRITE(9)(C(I),I=1,NCOFF)
       IF (NB.EQ.NBMAX) WRITE(9)C20IN
       NB0=NB1
       NB1=NB1+NCOFF
C      WRITE(6,*)' BLOCK ',NB,NB0,NB1
       REWIND(39)
       NB=NB+1
       NMT=0
       NC=0
C IF SOME COEFFICIENTS ARE MISSING, THEY ARE PUT TO ZERO HEREBY:
       DO I=1,NCOFF
        C(I)=0.0E0
       END DO
      END IF
      IF (NB.GT.NBMAX) GO TO 93
      IF (NB.EQ.NBMAX.AND.N .EQ. NMAX 
     *.AND. M .EQ. NMAX) GO TO 1200
      GO TO 1100
 1200 IF (NB.EQ.NBMAX) C(NLAST-NB0)=1.0D0
      WRITE(9)(C(I),I=1,NMT),C20IN
   93 IF (NC.LT.NLAST) WRITE(6,*)' ONLY ',NC,' COEFFICIENTS READ'
      CLOSE(39)
      LBIN=.TRUE. 
      REWIND(9) 
      RETURN 
      END IF 
C 
      IF (.NOT.LBIN) OPEN(9,FILE=DNAME(1),STATUS='OLD',FORM='FORMATTED')
      IF (HP9000.OR.(.NOT.LBIN)) GO TO 106
C FOR A BINARY FILE NOT ON HP9000 WE SKIP THE FIRST 8 REALS.
      NLAST=(NMAX+1)**2
      IF (LINT) GO TO 9040
C     READ(9)(C(I),I=1,8) CHANGE 1998.07.06 CCT.
      DO I=1,NLAST
       READ(9)C(I)
      END DO
      C20IN=C(5) 
      GO TO 200
 9040 READ(9)C20IN
      DO I=1,NLAST
       READ(9)IC(I)
      END DO
      GO TO 200
C
  106 WRITE(6,102)
      C00=1.0D0
      IF (LINT) IC(1)=0
      IF (.NOT.LINT) C(1)=C00
C COEFF FILE MAY CONTAIN HEADING, WHICH MUST BE SKIPPED.
      IF (LSKIPL) THEN 
      WRITE(*,*)' INPUT NUMBER OF LINES TO BE SKIPPED '
      READ(*,*)NSLINE
      IF (NSLINE.GT.0) THEN
      DO 387, I=1,NSLINE
 387  READ(9,'(A)')ALINE
      END IF
      WRITE(*,*)NSLINE,' SKIPPED '
      END IF 
C
  100 CONTINUE
      IF (LBIN.AND.HP9000) READ(9)N,M,CNMD,SNMD
c change 2005-07-26. Free format introduced.
c     IF ((.NOT.LBIN).AND.(.NOT.LFMT).AND.NMAX.LT.201) READ(9,101)N,M,
c    *CNMD,SNMD
c     IF ((.NOT.LBIN).AND.(.NOT.LFMT).AND.NMAX.GT.200) READ(9,3601)
c    *N,M,CNMD,SNMD
      IF ((.NOT.LBIN).AND.(.NOT.LFMT)) READ(9,*)N,M,CNMD,SNMD
      IF ((.NOT.LBIN).AND.LFMT) READ(9,FMT)N,M,CNMD,SNMD
  101 FORMAT(2I4,2E16.9)
      CNM=CNMD
      SNM=SNMD
 3601 FORMAT(I3,1X,I3,2(1X,E19.12))
      IF (N .LT.5)
     *WRITE(6,103)N,M,CNM,SNM
  103 FORMAT(I5,I4,2E17.9)
      IF (MOD(N,101).EQ.0.AND.M.EQ.N.AND.M.GT.5)
     * WRITE(6,*)N,' DEG FINISHED READING '
      IF (N.GT.0) GO TO 105
      C00 = CNM
      C0 = C00
      IF (C00.EQ.0.0D0) C00=1.0D0 
      IF (.NOT.LINT) C(1)=C0
      IF (LINT) IC(1)=0
      GO TO 100
  105 CNM=CNM/C00
      SNM=SNM/C00
      IF (N.GT.NMAX .OR. M.GT.NMAX) GO TO 100
      J=N*N
      SQ2N1= SQRT(2*N+1.0D0)
      IF (M.EQ.0) GO TO 104
      K =M+M
      IF (LINT) IC(J+K)=CNM*CFA*SQ2N1*SQ2
      IF (LINT) IC(J+K+1)=SNM*CFA*SQ2N1*SQ2
      IF (.NOT.LINT) C(J+K)=CNM
      IF (.NOT.LINT) C(J+K+1)=SNM
      IF (N .EQ. NMAX .AND. M .EQ. NMAX) GO TO 200
      GO TO 100
  104 IF (.NOT.LINT) C(J+1)=CNM
      IF (N.EQ.2.AND.LINT) IC(J+1)=0
C STORE C20 IN DOUBLE PRECISION FOR LATER USE
      IF (N.EQ.2) C20IN=CNMD*SQ2N1
      IF (LINT.AND.N.NE.2) IC(J+1)=CNM*CFA*SQ2N1
      GO TO 100
  200 CONTINUE
      IF (.NOT.L386) CLOSE(9)
      RETURN
      END
      SUBROUTINE SETCM(CAPN,LINT,LBIN )
C PROGRAMMED BY C.C.GOAD, 1981. LAST MODIFIED SEP 1992 BY CCT.
      IMPLICIT NONE
      INTEGER NCOFF,NROOT,CAPN,NIICC,NNSU,NLAST,N1,N21,I,MAXBL,NC20,NC,
     *NB0,NB1,NB,N,NNB0,N2,K,J,KJ2
C 386 PARAMETER (NCOFF=2560,NROOT=722)
C 360 PARAMETER (NCOFF=130322,NROOT=722)
C     PARAMETER (NCOFF=3243602,NROOT=3602,NIICC=1621801,NNSU=18010)
      PARAMETER (NCOFF=4844402,NROOT=4402,NIICC=2422201,NNSU=22010)
C360I PARAMETER (NCOFF=65165,NROOT=722)
      LOGICAL LINT,L386,LBIN 
      REAL*4 C,C0
      REAL*8 DZERO,ROOT,C20IN,G1,G2,CM3,CM2,CM1,GG,D,S21,SQ2,SMALLC,C5
C
      COMMON/SQROOT/DZERO,ROOT(NROOT)
      COMMON/GPOTC0/C20IN,G1(3),G2(3,3),CM3,CM2,CM1
      COMMON /GPOTC3/C(NCOFF)
C
C THIS ROUTINE SETS THE SQUARE ROOT TABLE IN COMMON
C SQROOT AND CREATES QUASI-NORMALIZED COEFFICIENTS FROM NORMALIZED
C COEFFICIENTS IN COMMON GPOTC0. (QUASI-NORMALIZED COEFFICIENTS MAY
C BE INPUT. THIS IS CHECKED USING C(2,0)).
C
C IF MORE SPACE IS NEEDED FOR THE COEFFICIENTS THAN AVAILABLE, THEN
C THEY MUST BE STORED ON DISK QUASI-NORMALIZED, BINARY, WITH C(0,0)
C AND C(2,0) ZERO AND C(2,0) IN DOUBLE PRECISION AS THE LAST COEFF.
      NLAST=(CAPN+1)**2+1
      L386=NLAST.GT.NCOFF
      N1=CAPN+1
      DZERO=0.0D0
      N21 = 2*(CAPN+1)
      DO 50 I=1, N21
   50 ROOT(I)= SQRT( FLOAT(I))
      G1(1)=0.0D0
      G1(2)=0.0D0
      G1(3)=0.0D0
C
      IF (LINT) RETURN
      IF (L386)THEN
      MAXBL=NLAST/NCOFF
      IF (MAXBL*NCOFF.NE.NLAST) MAXBL=MAXBL+1
      NLAST=NLAST-1
      NC20=NLAST-2-((MAXBL-1)*NCOFF)
      NC=0
      NB0=0
      NB1=NCOFF
      NB=0
      DO 151 N=1,NLAST
      NNB0=N-NB0
      IF (NNB0.EQ.NCOFF.OR.N.EQ.NLAST) THEN
      NB=NB+1
      READ(9)(C(I),I=1,NNB0)
      IF (N.EQ.NLAST) THEN
      READ(9)C20IN 
      C5=C(NC20)
      IF (ABS(C5).GT.1.0D-8) WRITE(6,*)' C20, C5=',C20IN, C5
      END IF
      NB0=NB1
      NB1=NB1+NCOFF
      END IF
  151 CONTINUE
      RETURN
      END IF
      IF (ABS(C20IN+1.0827E-3).LT.1.0D-6.AND.LBIN) THEN
      WRITE(6,10)
   10 FORMAT(' QUASI-NORMALIZED COEFFICIENTS INPUT.')
      RETURN
      END IF 
C
   90 SMALLC=1.0D0
      C0=C(1)
      C(1)=1.0D0
      IF(C0.NE.0.0D0)SMALLC=1.0D0/C0
      SQ2= SQRT(2.0D0)
C
      DO 200 N=1,CAPN
      N2=N+N
      S21 = ROOT(N2+1)
      K=N**2+1
C D IS THE QUASI-NORMALIZATION FACTOR FOR ZONAL TERMS
      D=SMALLC*S21
      C(K)=C(K)*D
C GG IS THE QUASI-NORMALIZATION FACTOR FOR NON-ZONAL TERMS
      GG=D*SQ2
      DO 100 J=1,N
      KJ2=J+J+K
      C(KJ2-1)=C(KJ2-1)*GG
      C(KJ2)=C(KJ2)*GG
  100 CONTINUE
  200 CONTINUE
      RETURN
      END
C ------------------------------------------------------------
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                  C
C                      I F R A C                                   C
C                                                                  C
C  SUBROUTINE GIVING TRUE INTEGER PART OF REAL REAL    C
C                                                                  C
C  RF, JUNE 1983                                                   C
C                                                                  C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      INTEGER FUNCTION IFRAC(R)
C
      IMPLICIT NONE
      REAL*8 R
      IF (R.LT.0.0D0) GO TO 1
        IFRAC = R
      RETURN
 1      IFRAC = R - 0.999999999D0
      RETURN
      END
C -------------------------------------------------------
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                  C
C                      I S P C O V                                 C
C                                                                  C
C  INITIALIZATION PROCEDURE FOR FAST 1-DIMENSIONAL EQUIDISTANT     C
C  SPLINE INTERPOLATION, WITH FREE BOUNDARY END CONDITIONS         C
C  REFERENCE: JOSEF STOER: EINFUHRUNG IN DIE NUMERISCHE MATHEMATIK C
C  I, SPRINGER 1972. MODIFIED FOR COVARIANCE INTERPOLATION.        C
C                                                                  C
C  PARAMETERS (REAL):                                  C
C                                                                  C
C  Y  GIVEN VALUES, Y(1), ..., Y(N)                                C
C                                                                  C
C  R  SPLINE MOMENTS (1 ... N), TO BE USED BY FUNCTION 'SPLINE'    C
C                                                                  C
C  Q  WORK-ARRAY, DECLARED AT LEAST 1:N                            C
C                                                                  C
C  RENE FORSBERG, JULY 1983, MODIFIED BY C.C.TSCHERNING OCT 87.    C
C                                                                  C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE ISPCOV(NTAB,NN)
C
      IMPLICIT NONE
      INTEGER NCTA,MAXB,IX,IIX,IOLD,NFU,KEYH,NINTH,NTABH,NHE,NSTART,
     *N,KY0,NTAB,NN,KSTART,KK,K,KY
      REAL*8 Y,CTTF,CTSF,SZ,AX,R,HTA,TMAX,SIZEI,Q,P
      PARAMETER (NCTA=51200)
      LOGICAL LTABH
C
      COMMON /TABELC/Y(NCTA),CTTF(800),CTSF(20),SZ(30),AX(18),
     *MAXB(20),IX(8),IIX(17),IOLD
      COMMON /CTABH/R(1200),HTA(5),TMAX,SIZEI,NFU(5),KEYH(5,5),
     *NINTH,NTABH(15,5,5),NHE,NSTART,LTABH
      DIMENSION Q(1200)
C
      N=NINTH+2
      KY0=(NTAB+NN-1)*N
      KSTART=N*(NN-1)
      Q(1) = 0.0D0
      R(1+KSTART) = 0.0D0
      DO 11 KK = 2, N-1
        K=KK+KSTART
        KY=KK+KY0
        P = Q(K-1)/2+2
        Q(K) = -0.5E0/P
        R(K) = (3*(Y(KY+1)-2*Y(KY)+Y(KY-1)) - R(K-1)/2)/P
   11 CONTINUE
      R(N+KSTART) = 0.0D0
      DO 12 KK = N-1, 2, -1
        K=KK+KSTART
        R(K) = Q(K)*R(K+1)+R(K)
   12 CONTINUE
      RETURN
      END
C ---------------------------------------------------------
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                  C
C                          S P L C O V                             C
C                                                                  C
C  FAST ONE-DIMENSIONAL EQUIDISTANT SPLINE INTERPOLATION FUNCTION. C
C                                                                  C
C  PARAMETERS:                                                     C
C                                                                  C
C  X   INTERPOLATION ARGUMENT (REAL), X = 1 FIRST DATA-POINT,      C
C      X = N LAST DATA-POINT. OUTSIDE THE RANGE LINEAR EXTRA-      C
C      POLATION IS USED.                                           C
C                                                                  C
C  Y   REAL*8 ARRAY, 1 .. N : DATA VALUES                          C
C                                                                  C
C  R   DO: SPLINE MOMENTS CALCULATED BY SUBROUTINE 'ISPCOV'        C
C                                                                  C
C  PROGRAMMER:                                                     C
C  RENE FORSBERG, JUNE 1983, MODIFIED OCT 87 BY C.C.TSCHERNING     C
C                                                                  C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      FUNCTION SPLCOV(X, NTAB, NN)
C
      IMPLICIT NONE
      REAL*8 X,Y,CTTF,CTSF,SZ,AX,R,HTA,TMAX,SIZEI,XX,SPLCOV
      INTEGER NTAB,NN,NINTH,NTABH,NHE,NSTART,MAXB,IX,IIX,IOLD,
     *NFU,KEYH,NCTA,N,KY0,KY1,KSTART,J,IFRAC
      LOGICAL LTABH
      PARAMETER (NCTA=51200)
C
      COMMON /TABELC/Y(NCTA),CTTF(800),CTSF(20),SZ(30),AX(18),
     *MAXB(20),IX(8),IIX(17),IOLD
      COMMON /CTABH/R(1200),HTA(5),TMAX,SIZEI,NFU(5),KEYH(5,5),
     *NINTH, NTABH(15,5,5),NHE,NSTART,LTABH
C
      N=NINTH+2
      KY0=(NTAB+NN-1)*N
      KY1=KY0+1
      KSTART=N*(NN-1)
      IF(X.GE.1.0D0) GO TO 1
        SPLCOV = Y(KY1) + (X-1)*(Y(2+KY0)-Y(KY1)-R(2+KSTART)/6)
      RETURN
    1 IF(X.LE.FLOAT(N)) GO TO 2
        SPLCOV = Y(N+KY0)+(X-N)*(Y(N+KY0)-Y(KY0+N-1)+R(KSTART+N-1)/6)
      RETURN
    2   J = IFRAC(X)
        XX = X - J
        SPLCOV = Y(J+KY0) +
     .   XX * ((Y(J+KY1)-Y(J+KY0)-R(J+KSTART)/3-R(J+1+KSTART)/6) +
     .     XX * (R(J+KSTART)/2 +
     .     XX * (R(J+KSTART+1)-R(J+KSTART))/6))
      RETURN
      END
      SUBROUTINE ICMEAN
     *(BSIZE,STEP,NSTEP,COSST,SINST,COSLAT,SINLAT,LEQANG,LMEA1)
C PROGRAMMED BY C.C.TSCHERNING, GEODETIC INSTITUTE, NOV 1985.
C THE SUBROUTINE INITIALIZES STEP VARIABLES FOR MEAN VALUE
C COMPUTATION. CHANGED 1996.10.08 BY CCT. 
C LEQANG IS TRUE, WHEN WE DEAL WITH EQUAL-ANGULAR BLOCK AVERAGES.
C LMEA1 IS TRUE WHEN WE HAVE 1-D MEANS.
C IF DOUBLE PRECISION IS NEEDED, ACTIVATE THE FOLLOWING STATEMENT:
      IMPLICIT NONE
      LOGICAL LEQANG,LMEA1,LTEST
      REAL*8 BSIZE,STEP,COSST,SINST,COSLAT,SINLAT,BSIZEA 
      INTEGER NSTEP,NSTEP1
C
      LTEST=.FALSE.
      NSTEP1=NSTEP-1
      BSIZEA=ABS(BSIZE) 
      IF (LEQANG) GO TO 10
      STEP=2*BSIZE/4.0
      BSIZEA=BSIZEA/(COSLAT* COS(STEP)+SINLAT* SIN(STEP))
C CORRECTION 1995.11.21 BY CCT.
   10 IF (LMEA1) THEN
C FOR 1-D MEANS, THE POINTS ARE SUPPOSED TO BE DISTRIBUTED EQUIDISTANTLY
C ON THE INTERVAL OF SIZE BSIZE. FOR 2-D MEANS THEY ARE DISTRIBUTED
C WITH NSTEP POINTS INSIDE THE INTERVAL.
      STEP=BSIZEA/NSTEP1 
      ELSE
      STEP=BSIZEA/NSTEP 
      END IF
      COSST= COS(ABS(STEP))
      SINST= SIN(ABS(STEP))
      IF (LTEST) WRITE(*,*)' ICMEAN: STEP= ',STEP
      RETURN
      END
      FUNCTION COMEAN(SM,IS,ISP,COSLAP,SINLAP,COSLOP,SINLOP,
     *COSLAQ,SINLAQ,COSLOQ,SINLOQ,NSTEPP,NSTEPQ,LTABLE,
     *LCZERO,LTCOV)
C PROGRAMMED NOV 1985 BY C.C.TSCHERNING, GEODETIC INSTITUTE.
C THE SUBROUTINE COMPUTES MEAN VALUES OF COVARIANCES.
C CHANGED 2002-09-12. 
      IMPLICIT NONE
      LOGICAL LOCAL,LSUM,LTABLE,LMEAP1,LMEAQ1,LTEST,LCZERO,LTCOV,
     *LFOURI,LFOUR,LLCOEE,LPARMP,LPARMQ  
C
      REAL*8 STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER,STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q,CCI,CCR,SI,HCMAX,CCV,DC,SCFRDD,SCFACT,RDD,
     *FOUCOF,SM,COVME,RADEG,RLAT,RJ,SINLAP,SINLAQ,COVM,COLAP,
     *COSLAP,SILAP,COLOP,COSLOP,SILOP,RLAY,COLOQ,COSLOQ,SILOQ,RLAX,
     *COSDLO,T,RLOX,PSI,COV,COLOQ1,COLAQ1,COLOP1,COLAP1,COMEAN,COVCG,
     *COZERO,RLONG,SINLOP,SINLOQ,COLAQ,SILAQ,RLOY,COSLAQ
      INTEGER KVI,KP,KQ,NFOURI,NFOUR,I,NSTEPE,NSTEQE,NSTEPP,NSTEPQ,MLAP,
     *MLOP,J,IS,ISP,MLAQ,MLOQ,NFILTE 
C
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE  
      COMMON /CMEAQ/STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q 
      COMMON /CMCOV/CCI(24),CCR(56),SI(4400),HCMAX,CCV(4),
     *DC(36),KVI(39),LOCAL,LSUM 
      COMMON /CLPARM/SCFRDD(42),SCFACT,RDD,FOUCOF(0:21),NFOURI(42),
     *NFOUR,LFOURI(42),LLCOEE(42),LFOUR
      COMMON /CLPAR1/KP,KQ,LPARMP,LPARMQ
      DIMENSION SM(2200),COVME(4)
C
      LTEST=LTCOV   
      RADEG=180.0/3.1415926535D0 
C CCI(20)=1 INDICATES THAT NOT-SO PRECISE EQUATIONS WILL BE USED IN
C COVCX. 2002.10-30.
      CCI(20)=1.0D0
      RLAT=0.0D0 
      RJ = 0.0D0
C     STEQE=5.0D0
      LMEAP1=STEPE.LT.1.0D-8 
      LMEAQ1=STEQE.LT.1.0D-8 
      IF (LTEST) WRITE(*,*)' STEPE,STEQE ',STEPE,STEQE
      NSTEPE=NSTEPP
      NSTEQE=NSTEPQ 
      IF (LMEAP1) NSTEPE=1 
      IF (LMEAQ1) NSTEQE=1 
      IF (LTEST) WRITE(*,*)'STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE',
     *STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE
      IF ( ABS(SINLAP-SINLAQ).GT.1.0D-8.OR. ABS(SINLOP-SINLOQ)
     *.GT.1.0D-8.OR.NSTEPP.EQ.1) GO TO 2999
      COSSQN=COSSTN
      COSSQE=COSSTE
      SINSQN=SINSTN
      SINSQE=SINSTE
C
 2999 COVM=0.0D0
      IF (LTEST) WRITE(*,*)' LMP,Q,SPEN,SQEN ',LMEAP1,LMEAQ1,
     *STEPE,STEPN,STEQE,STEQN  
      DO 3000 I=1,4
 3000 COVME(I)=0.0D0
C
      COLAP=COSLAP
      SILAP=SINLAP
C
      DO 3043 MLAP=1,NSTEPP
      CCR(4)=SILAP
      CCR(6)=COLAP
      IF (MLAP.EQ.1.OR.(.NOT.LMEAP1)) THEN 
      COLOP=COSLOP
      SILOP=SINLOP
      END IF 
C     IF (MLAP.EQ.1.AND.LMEAP1) THEN 
C     CALL PAZIM(RLAT,RLONG,COLAP,SILAP,COLOP,SILOP,
C    *-COSSTE,-SINSTE,COST2P,SINT2P,LTEST) 
C     END IF 
      IF (LTEST) RLAY=ATAN2(SILAP,COLAP)*RADEG 
C
      DO 3044 MLOP=1,NSTEPE
      COLAQ=COSLAQ
      SILAQ=SINLAQ
      IF (LTEST) THEN 
      RLOY=ATAN2(SILOP,COLOP)*RADEG 
      WRITE(*,*)' LAP,LOP',RLAY,RLOY 
      END IF 
C
      DO 3045 MLAQ=1,NSTEPQ
      IF (MLAQ.EQ.1.OR.(.NOT.LMEAQ1)) THEN 
      COLOQ=COSLOQ
      SILOQ=SINLOQ
      END IF 
C     IF (MLAQ.EQ.1.AND.LMEAQ1) THEN 
C     CALL PAZIM(RLAT,RLONG,COLAQ,SILAQ,COLOQ,SILOQ,
C    *-COSSQE,-SINSQE,COST2Q,SINT2Q,LTEST) 
C     END IF 
      CCR(5)=SILAQ
      CCR(7)=COLAQ
      IF (LTEST) RLAX=ATAN2(SILAQ,COLAQ)*RADEG 
C
      DO 3046 MLOQ=1,NSTEQE 
      COSDLO=COLOP*COLOQ+SILOP*SILOQ
      T=SILAQ*SILAP+COLAP*COLAQ*COSDLO
      IF (T.GT.1.0D0) T=1.0D0
      CCR(9)=COSDLO
      CCR(8)=-SILOP*COLOQ+COLOP*SILOQ
      CCR(1)=T
      IF (LTEST) THEN 
      RLOX=ATAN2(SILOQ,COLOQ)*RADEG 
      WRITE(*,*)' LAQ,LOQ, T' ,RLAX,RLOX,T 
      END IF 
      IF (LCZERO) THEN
C FINITE COVARIANCE FUNCTIONS INTRODUCED MAY, 1996 BY CCT.
      PSI=ACOS(T)
      COV=SCFACT*COZERO(PSI,RDD,1)
      CCV(1)=COV
      ELSE
      IF (LTABLE) THEN
      COV=COVCG(SM,ISP,.FALSE.)
      ELSE
      CALL COVCX(SM,COV,IS,.FALSE.)
      IF (LTEST) WRITE(*,*)' COV= ',COV
      END IF
      END IF
C CORRECTION FOR LATITUDE FACTOR MADE DEC. 1996. 
      IF (.NOT.LMEAP1.AND.(.NOT.LMEAQ1)) THEN 
      DO 3001 I=1,4
 3001 COVME(I)=COVME(I)+CCV(I)*COLAP*COLAQ
      COVM=COVM+COV*COLAP*COLAQ
      RJ=RJ+COLAP*COLAQ
      ELSE
      IF (LMEAP1.AND.LMEAQ1) THEN
      COVM=COVM+COV*FILTER(MLAQ)*FILTER(MLAP)
      ELSE
      IF (LMEAQ1.AND.(.NOT.LMEAP1)) THEN
      COVM=COVM+COV*FILTER(MLAQ)*COLAP
      RJ=RJ+COLAP
      END IF
      IF (LMEAP1.AND.(.NOT.LMEAQ1)) THEN
      COVM=COVM+COV*FILTER(MLAP)*COLAQ
      RJ=RJ+COLAQ
      END IF
      END IF
      END IF 
C
      IF (.NOT.LMEAQ1) THEN 
      COLOQ1=COLOQ
      COLOQ=COLOQ*COSSQE-SILOQ*SINSQE
      SILOQ=SILOQ*COSSQE+COLOQ1*SINSQE
      END IF 
 3046 CONTINUE 
C
      IF (LMEAQ1) THEN
      CALL PAZIM(RLAT,RLONG,COLAQ,SILAQ,COLOQ,SILOQ,
     *COSSQE,SINSQE,COSSQN,SINSQN,.FALSE.) 
      ELSE 
      COLAQ1=COLAQ
      COLAQ=COLAQ*COSSQN+SILAQ*SINSQN
      SILAQ=SILAQ*COSSQN-COLAQ1*SINSQN
      END IF 
 3045 CONTINUE 
C
      IF (.NOT.LMEAP1) THEN 
      COLOP1=COLOP
      COLOP=COLOP*COSSTE-SILOP*SINSTE
      SILOP=SILOP*COSSTE+COLOP1*SINSTE
      END IF                            
 3044 CONTINUE 
C
      IF (LMEAP1) THEN 
      CALL PAZIM(RLAT,RLONG,COLAP,SILAP,COLOP,SILOP,
     *COSSTE,SINSTE,COSSTN,SINSTN,.FALSE.)
      ELSE 
      COLAP1=COLAP
      COLAP=COLAP*COSSTN+SILAP*SINSTN
      SILAP=SILAP*COSSTN-COLAP1*SINSTN
      END IF 
 3043 CONTINUE 
C
      J=(NSTEPP*NSTEPQ*NSTEPE*NSTEQE) 
      IF (LMEAP1.AND.LMEAQ1) RJ = J
      COMEAN=COVM/RJ
      IF (.NOT.LMEAP1.AND.(.NOT.LMEAQ1)) THEN 
      DO 3003 I=1,4
 3003 CCV(I)=COVME(I)/RJ
      ELSE
      CCV(1)=COVM/RJ
      END IF
      IF (LTEST) WRITE(*,*)' COMEAN, J, RJ ',COMEAN,J,RJ   
C
      RETURN
      END
      SUBROUTINE BILDEC(DS,DT,C,A)
COMMENT GI REG.NO. 81020, PROGRAMMED SEPT. 1981 BY C.C.TSCHERNING.
C
C REFERENCE: SUENKEL, HANS: A COVARIANCE APPROXIMATION PROCE-
C DURE, OSU REP. 286, 1979, P. 32.
C
C FUNCTION:
C THE VALUES OF A FUNCTION OF TWO VARIABLES, F(S, T) AND ITS DERI-
C VATIVES FS=DF/DS, FT=DF/DT, FTS=D(2)F/DSDT GIVEN IN THE FOUR
C CORNERS OF A RECTANGLE WITH SIDE LENGTH DS, DT ARE USED TO COM-
C PUTE THE COEFFICIENTS OF A POLYNOMIAL, WHICH MAY BE USED TO
C REPRESENT THE FUNCTION OVER THE RECTANGLE, SEE REF. SECTION 4.
C
C  DS  (CALL VALUE, REAL)   SIDE LENGTH IN S,
C  DT  (  -    -  ,  -  )    -      -      T,
C  C   (  -    -  , DIMENSION) BOUNDS (1:16) HOLDS THE DERIVATIVES:
C    IF K IS RELATED TO THE 4 CORNERS IN THE SEQUENCE (0, 0),
C    (DS, 0), (0, DT), (DS, DT), THEN C(J)=F, C(J+1)=FS, C(J+4)=
C    FT, C(J+5)=FTS, AND J=CASE K OF (1, 3, 9, 11).
C  A  (RETURN VALUES, DIMENSION) THE COEFFICIENTS OF THE POLYNOMIAL
C     IN A(1) - A(16). A(17) = DS, A(18) = DT
C
C IF DOUBLE PRECISION IS NEEDED, ACTIVATE:
      IMPLICIT NONE
      REAL*8 B,A,C,DS,DT,E
      INTEGER I,J
      DIMENSION B(16),A(18),C(16)
C
      A(17)= DS
      A(18)= DT
C
      I=0
      DO 100 J=1,4
      IF (J.EQ.3)I=8
      I=I+2
      C(I)= C(I)*DS
      C(I+3)= C(I+3)*DT
  100 C(I+4)= C(I+4)*DS*DT
C
      DO 101 I=1,4
      B(2*I-1)= 2.0*(C(I+8)-C(I))
      B(2*I)= 1.5*B(2*I-1)
      E= C(I+4)
      B(2*I+7)= C(I+12)+E
  101 B(2*I+8)= B(2*I+7)+E
C
      A(1)=C(1)
      A(2)=C(2)
      A(5)=C(5)
      A(6)=C(6)
      A(9)= B(2)-B(10)
      A(13)= B(9)-B(1)
      A(10)= B(4)-B(12)
      A(14)= B(11)-B(3)
      A(4)= C(4)+C(2)-2.0*(C(3)-C(1))
      A(3)= C(3)-C(2)-C(1)-A(4)
      A(8)= C(8)+C(6)-2.0*(C(7)-C(5))
      A(7)= C(7)-C(6)-C(5)-A(8)
      E= B(6)-B(14)-A(9)
      A(12)= B(8)-B(16)+A(10)-2.0*E
      A(11)= E-A(10)-A(12)
      E= B(5)-B(13)+A(13)
      A(16)= 2.0*E-B(7)+B(15)+A(14)
      A(15)= -E-A(14)-A(16)
      RETURN
      END
      FUNCTION POL(I,A,T)
C IF DOUBLE PRECISION IS NEEDED, ACTIVATE:
      IMPLICIT NONE
      INTEGER I,J,K
      REAL*8 A,T,P,POL
      DIMENSION A(18)
      P=A(I+12)
      K=2
      DO 10 J=1,3
      P=P*T+A(I+4*K)
   10 K=K-1
      POL=P
      RETURN
      END
      FUNCTION DPOL(I,A,T2,T32)
C PROGRAMMED JUNE 1985 BY C.C.TSCHERNING. COMPUTES FIRST ORDER
C DERIVATIVE OF POLYNOMIAL USED IN BSFC.
C IF DOUBLE PRECISION IS NEEDED, ACTIVATE:
      IMPLICIT NONE
      REAL*8 A,T2,T32,DPOL
      INTEGER I
C
      DIMENSION A(18)
      DPOL=A(I)+T2*(A(I+4)+T32*A(I+8))
      RETURN
      END
      FUNCTION BSFC(A,IS,IT,S,T)
C
COMMENT GI REG.NO.81021, PROGRAMMED BY C.C.TSCHERNING, SEP. 1981.
C FORTRAN VERSION JUNE 1985.
C
C REF.: SUENKEL, HANS: A COVARIANCE APPROXIMATION PROCEDURE,
C OSU REP. NO. 286, 1979, P. 42.
C
C FUNCTION:
C CALCULATION OF ZERO TO SECOND ORDER DERIVATIVES OF A
C BICUBIC POLYNOMIAL.
C
C PARAMETERS:
C  IS   (CALL VALUE, INTEGER) ORDER OF DERIVATIVE IN S,
C  IT   ( -     -  ,    -   )   -           -        T,
C  S    ( -     -  , REAL) NORMALIZED COORDINATE OF THE POINT,
C  T    ( -     -  ,   - )     -         -                -  ,
C  A    ( -     -  , DIMENSION) COEFFICIENTS OF THE POLYNOMIAL, E.G.
C                  AS PRODUCED BY BILDEC IN A(1) - A(16).
C                  A(17), A(18) HOLDS GRID SIZE IN S AND T.
C
C IF DOUBLE PRECISION IS NEEDED, ACTIVATE:
      IMPLICIT NONE
      INTEGER IS,IT,IT1,IS1,I,I1
      REAL*8 S,T,A,T2,T32,DS,DT,B,B1,B2,BSFC,POL,DPOL
C
      DIMENSION A(18)
      T2= 2.0D0*T
      T32= T*1.5D0
      DS= A(17)
      DT= A(18)
C
      IT1=IT+1
      IS1=IS+1
      GO TO (10,11,12),IT1
   10 B= POL(4,A,T)
C
      GO TO (20,21,22),IS1
C
   20 I = 3
      DO 30 I1 = 1,3
      B = POL(I,A,T)+B*S
   30 I = I-1
      GO TO 99
C
   21 B= POL(3,A,T)+B*S*1.5E0
      B= (POL(2,A,T)+B*S*2.0D0)/DS
      GO TO 99
C
   22 B= (POL(3,A,T)+B*S*3.0D0)*2.0D0/(DS*DT)
      GO TO 99
C
   11 B= DPOL(8,A,T2,T32)
C
      GO TO (31,32,33),IS1
C
   31 I = 7
      DO 34 I1 = 1, 3
      B = DPOL(I,A,T2,T32)+B*S
   34 I = I-1
      B= B/DT
      GO TO 99
C
   32 B1= DPOL(7,A,T2,T32)+B*S*1.5E0
      B2= DPOL(6,A,T2,T32)+B1*S*2.0D0
      B= B2/(DT*DS)
      GO TO 99
C
   33 B= DPOL(7,A,T2,T32)+B*S*3.0D0
      B= B*2.0D0/(DS*DS*DT)
      GO TO 99
C
   12 B= A(13)+S*(A(14)+S*(A(15)+S*A(16)))
      B= A(9)+S*(A(10)+S*(A(11)+S*A(12)))+B*T*3.0D0
      B= B*2.0D0/(DS*DT)
C
   99 BSFC= B
      RETURN
      END
C ---------------------------------------------------------
      SUBROUTINE CTABEL(IP,LTEST)
C
COMMENT GI REG.NO. 81024, PROGRAMMED BY C.C.TSCHERNING, SEP. 1981.
C UPDATED JAN. 1983 BY CCT, FORTRAN VERSION JUNE 1985, LATEST UPDATE
C NOV 1991 BY CCT.
C
C FUNCTION:
C THE PROCEDURE WILL GENERATE A TABLE OF COVARIANCE VALUES
C IN A GRID WITH (NT+1)*(NS+1) POINTS. EACH KNOT IS ASSOCIATED WITH
C A VALUE OF T1=1-COS(SPHERICAL DISTANCE) AND S1=1-RB2/(RP*RQ),
C WHERE RB2 IS THE SQUARE OF THE RADIUS OF THE BJERHAMMAR-SPHERE
C AND RP, RQ ARE THE RADIAL DISTANCES OF THE POINTS P, Q FROM THE
C ORIGIN. THE TABLE IS USED TO GENERATE THE COEFFICIENTS OF BICUBIC
C POLYNOMIAL WITH 16 COEFFICIENTS, WHICH ARE STORED IN CTA.
C
C IN ORDER TO MAKE IT POSSIBLE TO HAVE SEVERAL TABELS STORED IN THE SAME
C COMMON AREA (FOR STEPVISE COLLOCATION, FOR EXAMPLE), POINTERS ARE USED
C TO POINT AT THE ZERO'TH ELEMENTS IN THE TABELS: CT - IC, CTSF - IS,
C CTTF - IT, SS - IZ, MAXB - IM, SIGMA AND SIGMA0 - II. THE POINTER
C VARIABLES WITH 1 - 6 ADDED POINTS AT THE 1 - 6 ELEMENTS. THE VALUES OF
C THESE POINTERS ARE KEPT IN COMMON, AND CHANGED IF IOLD IS DIFFERENT
C FROM IP. POINTERS FOR A NEW TABLE ARE RETURNED IN IX(IP*4+K), K=1,2,3
C OR 4.
C
C PARAMETERS:
C CALL VALUES:
C CI, KI, SIGMA0, AS SPECIFIED IN COVBX, SEE GI REG.NO. 76083.
C MAXB (INTEGER DIMENSION, BOUNDS (IM1:AT LEAST 12) WITH MAXB(1)=NS, THE
C NUMBER OF POINTS IN S, MAXB(IM2) THE NUMBER OF EQUIDISTANT INTERVALS
C IN PSI, MAXB(IM6+I) THE NUMBER OF SUBINTERVALS IN THE I'TH INTERVAL.
C SS   (DIMENSION, BOUNDS (1:MIN 6). THE VALUES OF SS DESCRIBES IN
C _     A CONDENSED FORM THE GRID. WE MUST HAVE:
C _     SS(IZ1) = MINIMUM HEIGHT (M), SS(IZ2) MAXIMAL HEIGHT (M),
C _     SS(IZ3) = 0.0, SS(IZ3+I) THE RIGHT-MOST INTERVAL BOUNDARY OF THE
C _     I'TH INTERVAL. A TYPICAL EXAMPLE IS (WITH IS=IM=0):
C _     SS(1)=0.0, SS(2)=2000.0, SS(4)=60.0, SS(5)= 360.0, SS(6)=1200.0.
C _     MAXB(1)=4, MAXB(2)=3, MAXB(7)=3, MAXB(8)=3, MAXB(9)=10.
C
C RETURN VALUES, (IN COMMON TABELC):
C MAXB(IM3)= NT1= TOTAL NUMBER OF T1 INTERVALS +1.
C CTA  (DIMENSION, BOUND ((NS+1)*NT1),16,2) THE COEFFICIENTS.
C CTSF (DIMENSION, BOUND .GE. NS), S1 VALUES.
C CTTF (DIMENSION, BOUND .GE. MAXB(3)), T1 VALUES.
C IX   (DIMENSION, BOUND .GE.6), NEW POINTERS.
C
      IMPLICIT NONE
      INTEGER NCTA
      PARAMETER (NCTA=1600)
C SMA PARAMETER (NCTA=100)
C 386 PARAMETER (NCTA=150)
      LOGICAL LOCAL,LSUM,LTEST,LF,LT
      REAL*8 CT,SM,RR,U,RS,CX,CTA,CTTF,CTSF,SS,A,CI,CR,SIGMA0,
     *SIGMA,HMAX,CV,D,D0,D1,D2,D3,D4,D5,RE,RG,PI,GM,R5,R9,DB,R,PMIN,
     *TE,P,DP,SN,S0,T0,S1,T1,S,R2,G,G2,COV,RB2,HMIN,DH,H
      INTEGER KK,MAXB,IX,IC,IT,IT1,IS,IS1,IZ,IZ1,IZ2,IZ3,IM,IM1,IM2,IM3,
     *IM4,IM5,IM6,II,IOLD,KI,N1,N,ITCOUN,IP4,IP,NS,NS1,NT,I,K2,
     *J,K,NT1,KA,K0,K1,I1,J1,I0,J0,M,NN,J3,I5,NS2,N2
C
      DIMENSION CT(3200),SM(2200),RR(200),U(200),RS(8),CX(18)
      COMMON /CCVCG/KK(24)
      COMMON /TABELC/CTA(NCTA,16,2),CTTF(800),CTSF(20),SS(30),A(18),
     *MAXB(20),IX(8),IC,IT,IT1,IS,IS1,IZ,IZ1,IZ2,IZ3,IM,IM1,IM2,IM3,
     *IM4,IM5,IM6,II,IOLD
      COMMON /CMCOV/CI(24),CR(56),SIGMA0(2200),SIGMA(2200),HMAX,
     *CV(2,2),D(36),KI(37),N1,N2,LOCAL,LSUM
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RG,PI,GM,ITCOUN,LF,LT
C
      IP4=IP*4
      IC=IX(1+IP4)
      IT=IX(2+IP4)
      IT1=IT+1
      IS=IX(3+IP4)
      IS1=IS+1
      IZ=IP*3
      IZ1=IZ+1
      IZ2=IZ+2
      IZ3=IZ+3
      IM=IP*6
      IM1=IM+1
      IM2=IM+2
      IM3=IM+3
      IM4=IM+4
      IM5=IM+5
      IM6=IM+6
      II=IX(4+IP4)
      IOLD=IP
C
      MAXB(IM4)=-1
      MAXB(IM5)=-1
      MAXB(IM6)=-1
      KI(37)=0
      KI(35)=0
      KI(36)=0
C KI(35) - (37) ARE USED TO KEEP TRACK OF HOW MANY TIMES COVCG IS
C CALLED WITH (37) AND WITHOUT (36) HAVING TO CALL BILDEC, AND WHEN IT
C WAS NECESSARY TO CALL COVCX (35).
      R9=1.0D9
      R5=1.0D5
      NS=IABS(MAXB(IM1))
      NS1=NS+1
      NT= MAXB(IM2)
C
C DB IS THE DIFFERENCE BETWEEN THE EARTH MEAN RADIUS (RE) AND THE RADIUS
C OF THE BJERHAMMAR SPHERE.
      DB=-CI(10)
      RB2=CI(9)
      HMIN= SS(IZ1)
      DH=(SS(IZ2)-HMIN)/NS
      DO 10 I=1,NS1
      H=DH*(I-1)+HMIN
      R=RE+H
      RR(I)=R
   10 CTSF(I+IS)= (D2*RE-DB+H)*(DB+H)/(R*R)
C
      PMIN=D0
      TE=D0
      K2=1
      CTTF(IT1)=D0
      U(1)=D0
      DO 20 J=1,NT
      K=MAXB(J+IM6)
C CONVERSION OF SPHERICAL DISTANCE TO UNITS OF RADIANS.
      P=SS(J+IZ3)/RG
      DP=(P-PMIN)/K
      PMIN=P
C
      DO 21 I=1,K
      K2=K2+1
      TE=TE+DP
      CTTF(K2+IT)=D2* SIN(TE/D2)**2
   21 U(K2)= SIN(TE)
   20 CONTINUE
      NT1=K2
      MAXB(IM3)=NT1
C
      DO 25 KA=1,4
      KI(6)=6
      IF (KA.GT.2) KI(6)=8
      KI(7)= KA
      N= (-1)**(KA+1)
C
      CALL COVBX(SM,.FALSE.,II)
      CR(6)=D1
      CR(11)=D1
      CR(10)=D1
      CR(4)=D0
      CR(8)=D0
      K0=KA
      IF (KA.GT.2)K0=K0+2
      K1= K0+2
      DO 26 I=1,NS1
      CR(2)= RR(I)-RE
      CR(3)= CR(2)
      SN=N
      IF (KA.EQ.2.OR.KA.EQ.4) SN=N/(D1-CTSF(I))
C
      DO 26 J=1,NT1
      CR(9)= D1
      CR(7)= D1-CTTF(J)
      CR(1)= CR(7)
C CR(1) AND CR(7) HOLDS COSINE OF THE SPHERICAL DISTANCE,
C HERE EQUAL TO COSINE OF THE LATITUDE.
      CR(5)= U(J)
C
      CALL COVCX(SM,COV,II,.FALSE.)
C
      CT(K0+8*(NT1*(I-1)+J-1))= CR(52)*SN
      CT(K1+8*(NT1*(I-1)+J-1))= -CR(53)*SN
C
   26 CONTINUE
   25 CONTINUE
C
C SET POINTERS FOR NEW COVARIANCE FUNCTION TABLES:
      IP4=IP4+4
      IX(IP4+1)=NT1*NS1+IC
      IX(IP4+2)=NT1+IT
      IX(IP4+3)=NS1+IS
C
      NT=NT1-1
      DO 50 KA=1,2
      K=0
      IF (KA.EQ.2)K=4
C
      DO 51 I=1,NS
      DO 51 J=1,NT
      S0=CTSF(I+IS)
      T0=CTTF(J+IT)
      I1=I+1
      J1=J+1
C
      DO 53 I0=I,I1
      DO 53 J0=J,J1
      M=((J0-J)*2+I0-I)+1
      K0=KK(M+16)
C
      DO 54 N=1,4
      NN=N+K+8*((I0-1)*NT1+J0-1)
   54 CX(K0+KK(N+20))=CT(NN)
   53 CONTINUE
C
      S1=CTSF(I+IS1)-S0
      T1=CTTF(J+IT1)-T0
C
      CALL BILDEC(S1,T1,CX,A)
C
      J3=IC+(I-1)*NT1+J
      DO 55 I5=1,16
   55 CTA(J3,I5,KA)=A(I5)
C
   51 CONTINUE
   50 CONTINUE
C
      IF (.NOT.LTEST) GO TO 99
C
      WRITE(6,100)(CTSF(I+IS),I=1,NS1)
  100 FORMAT('0 1-S=',8F7.4,/,6X,8F7.4)
      WRITE(6,101)(CTTF(I+IT),I=1,K2)
  101 FORMAT('0 1-T=',5(1X,F10.9),10(/,6X,5(1X,F10.9)))
      WRITE(6,102)
  102 FORMAT('   (1,1)    (1,2)    (1,6)    (2,6)    (3,3)    (3,4)',
     *'    (3,8)    (4,8) ')
C
      NS2=NS1
      IF (MAXB(IM1).LT.0) NS2=1
      K=1
      DO 30 I=1,NS2
      DO 30 J=1,K2
      S= D1-CTSF(I+IS)
      R= RR(I)
      R2= R*R
      G= R2/GM
      G2= G*G
C
      RS(1)=CT(K)*G2
      RS(2)=CT(K+1)*S*R9*G/R2
      RS(3)=CT(K+2)*RG*G2/R*U(J)
      RS(4)=CT(K+3)*S*R9*RG*G/(R2*R)*U(J)
      RS(5)=CT(K+4)*R5*R5/R2
      RS(6)=CT(K+5)*S*R5*R9/(R2*R)
      RS(7)=CT(K+6)*R9*R5/(R2*R)*U(J)
      RS(8)=CT(K+7)*S*R9*R9/(R2*R2)*U(J)
      K=K+8
      WRITE(6,105)RS
  105 FORMAT(1X,8F9.3)
   30 CONTINUE
   99 RETURN
      END
      FUNCTION COVCG(SM,IP,LTEST)
C
COMMENT GI REG.NO.81025, PROGRAMMED BY C.C.TSCHERNING, SEPT. 81.
C FORTRAN VERSION JUNE 1985, LATES UPDATE NOV 1991 BY CCT, WHERE
C LINEAR INTERPOLATION IS USED INSTEAD OF BICUBIC FOR THE
C CALCULATION OF CROS-COVARIANCE GRAVITY - DEFLECTIONS.
C
C FUNCTION:
C THE PROCEDURE WILL FIND IN CTA (1) THE COEFFICIENTS OF A BICUBIC
C POLYNOMIUM REPRESENTING A COVARIANCE FUNCTION IN A RECTANGLE
C WITH CORNER COORDINATES (CTSF(I), CTTF(J)) (LOWER, LEFTMOST)
C (CTSF(I+1), CTTF(J+1)) (UPPER, RIGHTMOST), IN A COORDINATE
C SYSTEM WITH S1 AS ABSCISSA AND T1 AS ORDINATE, (2) COMPUTE
C THE COVARIANCE FOR A POINT WITHIN THE RECTANGLE.
C
C HERE S1=1-S, S=RB**2/(RP*RQ), T1=1-T=1-COS(SPHERICAL DIST.),
C WHERE RB IS THE RADIUS OF THE BJERHAMMAR-SPHERE, RP, RQ ARE
C THE RADIAL DISTANCES OF TWO POINTS P AND Q, SEE THE PROCEDURE
C COVCX.
C
C THE COEFFICIENTS ARE STORED IN THE ARRAY A. IN MAXB ARE
C CURRENT VALUES OF I AND J STORED, TOGETHER WITH AN INTEGER K
C INDICATING WHICH TYPE OF COVARIANCE FUNCTION IS STORED (COVA-
C RIANCE(T, T) FOR K=0 AND COV(DELTA G, DELTA G) FOR K=3).
C THIS MAKES THE RECOLLECTION OF THE ELEMENTS OF A UNNECESSARY
C IF THE PROCEDURE IS CALLED IN ORDER TO COMPUTE VALUES WITHIN
C THE SAME RECTANGLE ANOTHER TIME.
C
C IF THE COVARIANCES NEEDED FOR THE INTERPOLATION HAVE NOT BEEN
C TABULATED (IN THE ARRAY CT), THEN COVCX WILL BE CALLED.
C
C PARAMETERS:
C SEE COVCX, COVBX, CTABLE FOR KI, CI, SIGMA, CR, CT AND D.
C A  (DIMENSION, BOUNDS (18)), HOLDS THE COEFFICIENTS (1-16),
C _   AND SIDE LENGTHS IN A(17), A(18).
C
C EXTNAL PROCEDURES USED: COVCX, BSFC.
C
      IMPLICIT NONE  
      INTEGER NCTA
      PARAMETER (NCTA=1600)
C SMA PARAMETER (NCTA=100)
C 386 PARAMETER (NCTA=150)
      LOGICAL LFAST,LTEST,LT,LSUM,LOCAL,LF
      INTEGER KI,N1,N2,ITCOUN,KK,MAXB,IX,IC,IT,IT1,IS,IS1,IZ,IZ1,IZ2,
     *IZ3,IM,IM1,IM2,IM3,IM4,IM5,IM6,II,IOLD,IP,IP4,NS,NT,NT1,NS1,
     *J,JJ,JD,NDT,NDS,K,KA,I2,J0,I,KP,KQ,NT0,I0 
C
      REAL*8 CI,CR,SIGMA0,SIGMA,HMAX,CVV,D,D0,D1,D2,D3,D4,D5,RE,RG,
     *PI,GM,CTA,CTTF,CTSF,SZ,A,SM,R5,DB,SP,SQ,CP,CQ,CD,T,T1,HP,HQ,
     *RP,RQ,S,S1,S0,T0,DS,DT,C,DCT,DCS,DCSTY,DD00,DD01,DD10,DD11,DCST,
     *SD,SS,DCTX,CS,SC,SCC,CSC,CF,COV,COVCG,BSFC
C
      COMMON /CMCOV/CI(24),CR(56),SIGMA0(2200),SIGMA(2200),HMAX,
     *CVV(2,2),D(36),KI(37),N1,N2,LOCAL,LSUM
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RG,PI,GM,ITCOUN,LF,LT
      COMMON /CCVCG/KK(24)
C ELEMENTS OF KK ARE INITIALIZED BY BLOCK DATA ROUTINE.
      COMMON /TABELC/CTA(NCTA,16,2),CTTF(800),CTSF(20),SZ(30),A(18),
     *MAXB(20),IX(8),IC,IT,IT1,IS,IS1,IZ,IZ1,IZ2,IZ3,IM,IM1,IM2,IM3,
     *IM4,IM5,IM6,II,IOLD
      DIMENSION SM(2200)
C
      IF (IOLD.EQ.IP) GO TO 10
      IP4=IP*4
      IC=IX(1+IP4)
      IT=IX(2+IP4)
      IT1=IT+1
      IS=IX(3+IP4)
      IS1=IS+1
      IZ=IP*3
      IZ1=IZ+1
      IZ2=IZ+2
      IZ3=IZ+3
      IM=IP*6
      IM1=IM+1
      IM2=IM+2
      IM3=IM+3
      IM4=IM+4
      IM5=IM+5
      IM6=IM+6
      II=IX(4+IP4)
      IOLD=IP
      MAXB(IM6)=-1
C THIS ASSIGNMENT OF -1 IS DONE TO ASSURE THAT BILDEC IS CALLED WHEN A
C A NEW COVARIANCE FUNCTION TABEL IS USED.
C
   10 R5=1.0D5
      DB=-CI(10)
      NS=IABS(MAXB(IM1))
      NT=MAXB(IM2)
      NT1=MAXB(IM3)
      NS1=NS+1
C
      SP= CR(4)
      SQ= CR(5)
      CP= CR(6)
      CQ= CR(7)
C
      SS= SP*SQ
      CD=CR(9)
      T= CR(1)
      T1=D1-T
      HP= CR(2)
      HQ= CR(3)
C
      RP= RE+HP
      RQ= RE+HQ
      S= CI(9)/(RP*RQ)
      S1= D1-S
C
      IF (KI(6).EQ.0.OR.KI(7).EQ.0) GO TO 90
      KP=KK(KI(6))
      KQ=KK(KI(7))
      LFAST=(T1.LE.CTTF(NT1+IT)).AND.(S1.GE.CTSF(IS1)).AND.(S1.LE.
     *CTSF(NS1+IS)).AND.(KP.LT.5).AND.(KQ.LT.5).AND.KI(8).LT.2
      IF (.NOT.LFAST) GO TO 90
C
      IF ( ABS(HP-HQ) .GE. 1.0D-5) GO TO 11
      IF ( ABS(HP) .LT. 1.0D-5) S1=DB*(D2-DB/RE)/RE
      IF ( ABS(HP).GT.1.0D-5) S1= (HP+DB)*(2*RE+HP-DB)/RP**2
      GO TO 12
   11 S1= (RE*(2*DB+HP+HQ)+HP*HQ-DB*DB)/(RP*RQ)
   12 S= D1-S1
C
COMMENT FIND INDEX FOR LOWER LEFT CORNER
      I=0
   14 I=I+1
      IF (CTSF(I+IS1) .LT. S1) GO TO 14
      J=0
      IF (.NOT.LTEST) GO TO 19
   13 J=J+1
      IF (CTTF(J+IT1) .LT. T1) GO TO 13
   19 NT0=NT1-1
      JJ=J
      J=1
      IF (T1.LE.D0) GO TO 22
      IF (T1.LT.CTTF(NT0+IT)) GO TO 23
      J=NT0
      GO TO 22
   23 J=NT0/2+1
      JD=NT0
   24 JD=JD/2
      IF (JD.LT.1) JD=1
      IF (T1.GE.CTTF(J+IT)) GO TO 25
      J=J-JD
      GO TO 24
   25 IF (T1.LT.CTTF(J+IT1)) GO TO 22
      J=J+JD
      GO TO 24
   22 IF (J.NE.JJ.AND.LTEST) WRITE(6,98)J,JJ
   98 FORMAT(' J,JJ=',2I4)
      S0= CTSF(I+IS)
      T0= CTTF(J+IT)
C
      DS= S1-S0
      DT=T1-T0
C
      IF (LTEST) WRITE(6,100)I,J,T1,S1,DT,DS
  100 FORMAT(' I,J,T1,S1,DT,DS=',2I4,4F12.9)
      NDT=0
      IF (KP.GT.2) NDT=1
      IF (KQ.GT.2) NDT=NDT+1
      NDS=0
      IF (KP.EQ.2)NDS=1
      IF (KQ.EQ.2)NDS=NDS+1
      IF (NDS.NE.2) GO TO 15
      NDS= 0
      K= 3
      GO TO 16
   15 K=-1
C
   16 IF (I.EQ.MAXB(IM4).AND.J.EQ.MAXB(IM5).AND.K.EQ.MAXB(IM6)) GO TO 18
      MAXB(IM4)=I
      MAXB(IM5)=J
      MAXB(IM6)=K
      KA=1
      IF (K.EQ.3)KA=2
      I2=IC+(I-1)*NT1+J
      DO 20 J0=1,16
   20 A(J0)=CTA(I2,J0,KA)
C
      S1=CTSF(I+IS1)-S0
      T1=CTTF(J+IT1)-T0
      A(17)=S1
      A(18)=T1
      IF (LTEST) WRITE(6,102)(A(I0),I0=1,16)
  102 FORMAT(' A=',4E15.6,3(/,3X,4E15.5))
      KI(37)= KI(37)+1
      GO TO 21
C
   18 KI(36)= KI(36)+1
C
   21 S1=A(17)
      T1=A(18)
      DS=DS/S1
      DT= DT/T1
C
      C=D0
      DCT=D0
      IF (NDS.EQ.0) GO TO 29
      IF (NDT.GT.0) GO TO 28
C
C COVARIANCE GRAVITY AND HEIGHT ANOMALY.
      C=BSFC(A,0,0,DS,DT)
      DCS= S*BSFC(A, 1, 0, DS, DT)
      C= -(DCS+D2*C)
      CR(52)=C
      GO TO 31
C
C COVARIANCE GRAVITY ANOMALY WITH DEFLECTIONS.
   28 DCTX= BSFC(A, 0, 1, DS, DT)
      IF (LTEST) DCSTY= BSFC(A, 1, 1, DS, DT)
C CHANGE HERE MADE MAY 1988, USING LINEAR INTERPOLATION INSTEAD
C OF BICUBIC INTERPOLATION. THIS MAY NOT BE NECESSARY ON COMPUTERS
C USING DOUBLE PRECISION ARTIHMETIC. DDXY HOLDS THE CORNER VALUES
C OF THE MIXED FIRST ORDER DERIVATIVES IN THE SQUARE WITH SIDE-
C LENGTHS EQUAL TO 1.0 .
      DD00= A(6)/(A(17)*A(18))
      DD01= BSFC(A,1,1,D0,D1)
      DD10= BSFC(A,1,1,D1,D0)
      DD11= BSFC(A,1,1,D1,D1)
      DCST= (DD00*(D1-DS)+DD10*DS)*(D1-DT)+(DD01*(D1-DS)+DD11*DS)*DT
      IF (LTEST) WRITE(6,9765)DD00,DD01,DD10,DD11,DS,DT,DCST,DCSTY
 9765 FORMAT(' DD00011011 ',4E15.7,/,' DSDTSTSTY ',4E15.7)
      DCT= DCST*S+2*DCTX
      CR(53)=DCT
      GO TO 31
C
   29 IF (NDT.GT.0) GO TO 30
C AUTOCOVARIANCE OF GRAVITY OR OF HEIGHT ANOMALY.
      C=BSFC(A,0,0,DS,DT)
      CR(52)=C
      GO TO 31
C
C CROSS-COVARIANCE HEIGHT ANOMALY WITH DEFLECTIONS.
   30 DCT=-BSFC(A,0,1,DS,DT)
      CR(53)=DCT
   31 CONTINUE
C
      IF (NDT.EQ.0) GO TO 40
      SD= CR(8)
      CS= CP*SQ
      SC= SP*CQ
      SCC= SC*CD
      CSC= CS*CD
      D(3)=CQ*SD
      D(13)= -CP*SD
      D(2)= CS-SCC
      D(7)= SC-CSC
C
   40 IF (LTEST) WRITE(6,110)C,RP,RQ,CI(11),CR(10),CR(11)
  110 FORMAT(' C,RP,RQ,CI11,GP,GQ=',/,
     *E13.6,2F9.1,E13.6,2F9.6)
C
      CF=CI(11)/(RP**KI(22)*RQ**KI(23)*CR(10)**KI(20)
     **CR(11)**KI(21))
      CI(12)=CF
      C=C*CF
      DCT=DCT*CF
      IF (NDT.GT.0) GO TO 71
      CVV(1,1)=C
      GO TO 72
   71 IF (KP.GT.2) GO TO 73
C COVARIANCE WITH DEFLECTION IN Q AND HEIGHT OR GRAVITY ANOMALY IN P.
      CVV(1,1)= DCT*D(13)
      CVV(1,2)= DCT*D(7)
      GO TO 72
C COVARIANCE WITH DEFLECTION IN P AND HEIGHT OR GRAVITY ANOMALY IN Q.
   73 CVV(1,1)=DCT*D(3)
      CVV(2,1)=DCT*D(2)
   72 COVCG=CVV(KI(24),KI(25))
C
      GO TO 99
   90 CALL COVCX(SM,COV,II,.FALSE.)
      COVCG=COV
      KI(35)= KI(35)+1
C
   99 RETURN
      END
C -----------------------------------------------------------------
      SUBROUTINE INTABH(SM,IS,LTEST)
C PROGRAMMED SEPT 1987 BY C.C.TSCHERNING. LATEST CHANGE 4 DEC 87.
C
C THE SUBROUTINE INITIALIZES TABELS FOR COVARIANCE-FUNCTION
C INTERPOLATION FOR FIXED HEIGHTS AND FUNCTIONALS.
C
C CALL VALUES:
C SM, IS PARAMETERS USED BY COVBX AND COVCX. SM IS A DUMMY
C REAL ARRAY WITH AT LEAST 3 ELEMENTS AND IS IS THE SUBSCRIPT
C OF THE FIRST ELEMENT USED IN SIGMA0 AND SIGMA, WHICH HOLDS
C THE DEGREE-VARIANCE CORRECTIONS. (SEE COVAX).
C
C OTHER CALL VALUES ARE STORED IN COMMON BLOCK CTABH:
C HTA  - HOLD THE UP TO 5 FIXED HEIGHTS IN METERS,
C SIZEI- THE INTERVAL SIZE IN ARCSECONDS (AT CALL),
C NFU  - THE NUNBER OF FIXED FUNCTIONALS FOR EACH FIXED HEIGHT,
C KEYH - THE FUNCTIONAL TYPES (0 - 15), SEE COVAX,
C NINTH- NUMBER OF INTERVALS IN TABLE,
C NHE  - NUMBER OF FIXED HEIGHTS.
C
C RETURN VALUES:
C IN CHTA THE COVARIANCE TABLES,
C TMAX  - THE MAXIMAL VALUE OF T=COS(SPHERICAL DISTANCE)
C NTABH - THE LOGICAL TABLE NUMBER FOR EACH HEIGHT AND
C         AND FUNCTIONAL. THERE WILL NORMALLY BE SEVERAL
C         TABLES FOR EACH FUNCTIONAL, SUCH AS BOTH THE FIRST,
C         SECOND AND THIRD DERIVATIVE WITH RESPECT TO T.
C SIZEI - NOW IN UNITS OF RADIANS.
C
      IMPLICIT NONE 
      INTEGER NCTA
      PARAMETER (NCTA=51200)
C SMA PARAMETER (NCTA= 3200)
C 386 PARAMETER (NCTA= 4800)
C IF DOUBLE PRECISION IS NEEDED, ACTIVATE THE FOLLOWING:
      REAL*8 CCI,CR,SIGMA0,SIGMA,HMAX,CCV,D,
     *CHTA,CTTF,CTSF,SZ,AX,RC,HTA,TMAX,SIZEI,A,S,RB2,T,B,
     *D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,SM,TT,COV,HP,HQ,CR50
C
      INTEGER KI,NC1,N2,MAXB,IX,IIX,IOLD,NFU,KEYH,NINTH,NTABH,
     *NHE,NSTART,KT,KT1,K,I1,JJD,N3,KK,KQ,KP,ND,NR,ND1,ND2,ITCOUN,
     *NTAB,NINTH1,NINTH2,I,JI,J,II,JJ,II1,NTT,IK,NN,IS
C
      LOGICAL LTABH,LOCAL,LSUM,LOLDFU,LTEST,LT,LF
C
      COMMON /CMCOV/CCI(24),CR(56),SIGMA0(2200),SIGMA(2200),HMAX,
     *CCV(2,2),D(36),KI(37),NC1,N2,LOCAL,LSUM
C CMCOV CONTAINS VARIABLES USED BY COVAX, COVBX AND COVCX.
      COMMON /TABELC/CHTA(NCTA),CTTF(800),CTSF(20),SZ(30),AX(18),
     *MAXB(20),IX(8),IIX(17),IOLD
C TABELC CONTAINS VARIABLES USED BY CTABLE AND COVCG.
      COMMON /CTABH/RC(1200),HTA(5),TMAX,SIZEI,NFU(5),KEYH(5,5),
     *NINTH,NTABH(15,5,5),NHE,NSTART,LTABH
      COMMON /DDY/A,S,RB2,T,B,KT,KT1,K,I1,JJD,N3,KK,KQ,KP,ND,NR,ND1,
     *ND2
C DDY CONTAINS VARIABLES USED BY COVBX AND COVCX. HERE ONLY ND2
C EQUAL TO THE NUMBER OF DERIVATIVES WITH RESPECT TO T IS USED.
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
      DIMENSION SM(2200),TT(500)
C
      LTABH=LF
C CREATION OF TABLES. NTAB COUNTS NUMBER OF TABLES.
      NTAB=0
      SIZEI=SIZEI/RADSEC
      TMAX= COS(NINTH*SIZEI)
      NINTH1=NINTH+1
      NINTH2=NINTH1+1
      DO 210 I=1,NINTH1
  210 TT(I)= COS((I-1)*SIZEI)
C
      DO 300 I=1,NHE
      HP=HTA(I)
      CR(2)=HP
      JI=((I-1)*I)/2
C
      DO 301 J=1, I
      HQ=HTA(J)
      CR(3)=HQ
      DO 301 II=1,NFU(I)
      KI(6)=KEYH(II,I)
C IF THE FUNCTIONAL IS ONE OF A PAIR (LIKE A PAIR OF
C OF DEFLECTIONS) THE TABLE FOR ONLY ONE OF THE TWO IS MADE.
      IF (KI(6).GT.16) KI(6)=KI(6)-10
      IF (KI(6).EQ.13)KEYH(JJ,I)=15
      IF (KI(6).EQ.11)KEYH(JJ,I)=10
      IF (KI(6).EQ.7)KEYH(JJ,I)=6
C
      II1=II
      IF (I.NE.J) II1=NFU(J)
      DO 302 JJ=1,II1
      KI(7)=KEYH(JJ,J)
      IF (KI(7).GT.16) KI(7)=KI(7)-10
      CALL COVBX(SM,.FALSE.,IS)
C
C DEPENDING OF FUNCTIONAL TYPE, THE DERIVATIVES WITH RESPECT TO
C T FROM NSTART-2 TO ND2-2 MYST BE STORED, SEE COVCX.
      NSTART=2
      IF (ND1.EQ.1) GO TO 305
      LOLDFU=KP.EQ.12.OR.KP.EQ.14.OR.KQ.EQ.12.OR.KQ.EQ.14
      NSTART=3
      IF (LOLDFU) GO TO 305
      NSTART=4
      IF (KI(10).GT.1.AND.KI(11).GT.1.OR.ND2.EQ.3) NSTART=3
  305 CONTINUE
      NTABH(JI+J,II,JJ)=NTAB
      NTT=ND2-NSTART+1
C NTT IS TOTAL NUMBER OF DERIVATIVES WRT T, WHICH MUST BE STORED.
C
      DO 303 IK=1, NINTH1
      CR(1)=TT(IK)
      CALL COVCX(SM,COV,IS,.FALSE.)
      IF (LTEST)WRITE(6,11)IK,CR(1),COV,(CR(NN+50+NSTART-1),NN=1,NTT)
   11 FORMAT(' IK,T,COV=',I3,F10.7,F9.3,/,5E14.7)
C
C THE CALL OF COVCX GIVES ALL DERIVATIVES, BUT NOT ALL NEED TO
C BE STORED.
      DO 304 NN=1,NTT
      CR50=CR(50+NN+NSTART-1)
      IF (IK.EQ.2) CHTA((NTAB+NN-1)*NINTH2+1)=CR50
  304 CHTA((NTAB+NN-1)*NINTH2+IK+1)= CR50
  303 CONTINUE
      IF (LTEST) WRITE(6,50)NTAB,ND2,NSTART,II,JJ,KI(6),KI(7)
   50 FORMAT(' NTAB,ND2,NSTART,II,JJ,KP,KQ=',7I4)
      NTAB=NTAB+ND2-NSTART+1
  302 CONTINUE
  301 CONTINUE
  300 CONTINUE
      LTABH=.TRUE.
      RETURN
      END
C ----------------------------------------------------------------
      SUBROUTINE TABH(C,LTA)
C PROGRAMMED BY C.C.TSCHERNING, SEPT 1987.
C UPDATE 2002-10-25 (IMPLICIT NONE).
C
C THE SUBROUTINE INTERPOLATES IN A COVARIANCE FUNCTION TABLE
C USING SPLINES, AFTER FIRST HAVING CHECKED WHETHER THE NECESSARY
C TABLES ARE THE ONES CREATED. OTHERWISE COVCX IS CALLED.
C
C CALL VALUES:
C THE TABLE VALUES ARE STORED IN CHTA OF COMMON TABELC.
C THE VARIABLES OF COMMON CTABH AS INITIALIZED BY INTABH.
C
C CALL AND RETURN VARIABLES:
C IF THE SAME FIXED FUNCTIONALS AND HEIGHT AS IN LAST CALL
C ARE USED, THEN TABEL VALUES IN RC ARE USED FOR THE
C THE SPLINE INTERPOLATION. OTHERWISE THEY ARE COMPUTED BY
C ISPCOV.
C THE VARIABLES IN CTABH1 KEEPS TRACK OF THE LAST HEIGHT AND
C FUNCTIONAL TYPES USED.
C
C RETURN VARIABLES:
C C   - ARRAY CONTAINING THE DERIVATIVES WITH RESPECT TO T.
C LTA - LOGICAL, TRUE IF IT WAS POSSIBLE TO USE THE TABLES.
C       OTHERWISE COVCX WILL COMPUTE THE NEEDED QUANTITIES.
C
      IMPLICIT NONE
      INTEGER NCTA,NFU,KEYH,NINTH,NTABH,NHE,NSTART,N,
     *NC1,N2,KI,MAXB,IX,IIX,IOLD,KT,KT1,K,II,JJ,N3,NINTH1,NINTH2,JI,
     *NR,ND1,ND2,KK,KQ,KP,ND,IHP,IHQ,KFP,KFQ,IFP,IFQ,NTAB,NN,ITCOUN
      PARAMETER (NCTA=51200)
C SMA PARAMETER (NCTA= 3200)
C 386 PARAMETER (NCTA= 4800)
      REAL*8 RC,HTA,TMAX,SIZEI,CCI,CR,SIGMAO,SIGMA,HMAX,
     *CCV,D,CHTA,CTTF,CTSF,SZ,AX,A,S,RB2,T,B,HPOLD,HQOLD,
     *D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,C,HP,HQ,T1,PSI,X1,COVS,
     *SPLCOV
C
      LOGICAL LTA,LTABH,LOCAL,LSUM,LSAHP,LSAHQ,LSAFP,LSAFQ,LSWI,
     *LOLDFU,LTEST,LF,LT
C
      COMMON /CTABH/RC(1200),HTA(5),TMAX,SIZEI,NFU(5),KEYH(5,5),
     *NINTH,NTABH(15,5,5),NHE,NSTART,LTABH
C SEE INTABH FOR DESCRIPTION OF VARIABLES.
      COMMON /CMCOV/CCI(24),CR(56),SIGMAO(2200),SIGMA(2200),HMAX,
     *CCV(2,2),D(36),KI(37),NC1,N2,LOCAL,LSUM
C SEE COVAX, COVBX AND COVCX FOR DESCRIPTION OF VARIABLES.
      COMMON /TABELC/CHTA(NCTA),CTTF(800),CTSF(20),SZ(30),AX(18),
     *MAXB(20),IX(8),IIX(17),IOLD
C CHTA CONTAINS THE TABLES.
      COMMON /DDY/A,S,RB2,T,B,KT,KT1,K,II,JJ,N3,KK,KQ,KP,ND,
     *NR,ND1,ND2
C VARIABLES USED IN COVBX AND COVCX.
      COMMON /CTABH1/HPOLD,HQOLD,IHP,IHQ,KFP,KFQ,IFP,IFQ,NTAB,NN
C VARIABLES KEEPS TRACK OF LAST HEIGHTS AND FUNCTIONALS USED.
      COMMON /DCON/ D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C CONSTANTS INITIALIZED BY BLOCK DATA.
      DIMENSION C(6)
C
      LTEST=LF
      IF (T.LT.TMAX) GO TO 600
      NINTH1=NINTH+1
      NINTH2=NINTH1+1
      HP= CR(2)
      HQ= CR(3)
      KP=KI(6)
      IF (KP.EQ.7.OR.KP.EQ.11)KP=KP-1
      IF (KP.EQ.13)KP=15
      KQ=KI(7)
      IF (KQ.EQ.7.OR.KQ.EQ.11)KQ=KQ-1
      IF (KQ.EQ.13)KQ=15
      LSAHP =  ABS(HP-HPOLD).LT. 0.1
      LSAHQ =  ABS(HQ-HQOLD).LT. 0.1
      LSAFP=KP.EQ.KFP
      LSAFQ=KQ.EQ.KFQ
C
C CHECK, WHETHER WE STILL HAVE THE SAME HEIGHT AND FUNCTIONALS
C AS DURING THE LAST CALL.
      IF (LSAHP.AND.LSAHQ.AND.LSAFP.AND.LSAFQ) GO TO 500
C
C THEN FIND POINTERS TO ACTUAL HEIGHTS AND FUNCTIONALS.
      IF (LSAHP) GO TO 100
      IHP=0
  101 IHP=IHP+1
      IF (IHP.GT.NHE) GO TO 600
      IF ( ABS(HP-HTA(IHP)).GT.0.1) GO TO 101
      HPOLD=HP
C
  100 IF (LSAHQ) GO TO 102
      IHQ=0
  103 IHQ=IHQ+1
      IF (IHQ.GT.NHE) GO TO 600
      IF ( ABS(HQ-HTA(IHQ)).GT. 0.1) GO TO 103
      HQOLD=HQ
C
  102 LSWI=IHQ.GT.IHP
      IF (LSWI) JI=((IHQ-1)*IHQ)/2+IHP
      IF (.NOT.LSWI) JI= ((IHP-1)*IHP)/2+IHQ
C JI POINTS AT TABLE INDEXES.
C
      IFP=0
  104 IFP=IFP+1
      IF (IFP.GT.NFU(IHP)) GO TO 600
      IF (KP.NE.KEYH(IFP,IHP)) GO TO 104
      KFP=KP
      IFQ=0
  105 IFQ=IFQ+1
      IF (IFQ.GT.NFU(IHQ)) GO TO 600
      IF (KQ.NE.KEYH(IFQ,IHQ)) GO TO 105
      KFQ=KQ
C
      IF (LSWI.OR.IHP.EQ.IHQ.AND.IFP.LE.IFQ) NTAB=NTABH(JI,IFQ,IFP)
      IF (.NOT.(LSWI.OR.IHP.EQ.IHQ.AND.IFP.LE.IFQ)) NTAB=
     *                                           NTABH(JI,IFP,IFQ)
C
C FIND WHICH DERIVATIVES WRT T ARE STORED.
      NSTART=2
      IF (ND1.EQ.1) GO TO 110
      LOLDFU=KP.EQ.12.OR.KP.EQ.14.OR.KQ.EQ.12.OR.KQ.EQ.14
      NSTART=3
      IF (LOLDFU) GO TO 110
      NSTART=4
      IF (KI(10).GT.1.AND.KI(11).GT.1.OR.ND2.EQ.3) NSTART=3
  110 CONTINUE
C
      NN=ND2-NSTART+1
C CREATE TABLES NECESSARY FOR THE SPLINE INTERPOLATION.
      IF (LTEST)
     *WRITE(6,10)IHP,IHQ,IFP,IFQ,KFP,KFQ,NTAB,NSTART,ND2
   10 FORMAT(' IHP,IHQ,IFP,IFQ,KFP,KFQ,NTAB,NSTART,ND2=',9I3)
      DO 130 N=1,NN
  130 CALL ISPCOV(NTAB,N)
      KI(37)=KI(37)+1
      GO TO 502
C
  500 KI(36)=KI(36)+1
C
  502 T1= ABS(D1-T)
      IF (T1.LT.2.0D-10) PSI=0.0D0
      IF (T1.GE.2.0D-10) PSI=PI/2.0D0-ASIN(T)
      IF (PSI.LT.D0) PSI=D0
      X1=PSI/SIZEI+D2
C SPLINE INTERPOLATION OF ALL NEEDED DERIVATIVES WRT T.
      DO 501 N=1,NN
      COVS=SPLCOV(X1,NTAB,N)
  501 C(N+NSTART-1)=COVS
      IF (LTEST) WRITE(6,15)PSI*RADSEC,T,C(NSTART)*CCI(12)
   15 FORMAT(' PSI,T,COV=',F10.1,F13.10,E15.5)
      LTA=.TRUE.
      RETURN
C
  600 LTA=.FALSE.
      KI(35)=KI(35)+1
      RETURN
      END
C------------------------------------------------------------------
      SUBROUTINE COVAX(SM,IS)
C ORIGINAL VERSION PROGRAMMED JULY 1975 BY C.C.TSCHERNING. LATEST
C MODIFICATION 1999-02-14. 
C
C THIS SUBROUTINE PREPARES CONSTANTS USED FOR COVARIANCE FUNCTION EVALU-
C ATION, WHICH IS EXECUTED USING THE SUBROUTINES COVBX AND COVCX.
C
C THE COVARIANCE FUNCTION USED IS DEFINED ACCORDING TO A DEGREE-VARIANCE
C MODEL AND A SET OF EMPIRICAL (POTENTIAL) DEGREE-VARIANCES. THE DEGREE-
C VARIANCE MODEL IS SPECIFIED THROUGH THE VALUES OF KI(1)-KI(5),CI(8)-
C CI(10) AND THE PARAMETERS N1 AND LOCAL OCCURRING IN THE COMMON BLOCK
C /CMCOV/. EMPIRICAL ANOMALY DEGREE-VARIANCES WILL HAVE TO BE STORED IN
C SIGMA0 WHEN LOCAL IS FALSE, AND ARE USED FOR THE COMPUTATION OF RESI-
C DUAL POTENTIAL DEGREE-VARIANCES, (SEE REF(A), EQ.(16)).
C
C BY THE CALL OF COVAX, THE KIND OF COVARIANCE FUNCTION TO BE USED IS
C DETERMINED. THE VALUE OF KI(5) WILL DETERMINE THE DEGREE-VARI-
C ANCE MODEL (1,2 OR 3, CF.REF(A),EQ.(17)) THAT WILL BE USED. THE QUAN-
C TITIES K(2),K(3) MUST BE STORED IN KI(3),KI(4), AND BE EQUAL TO ZERO
C WHEN NOT USED (EG.,KI(3),KI(4) BOTH ZERO WHEN KI(5)=1). THE QUANTITY
C A(I) MUST BE STORED IN CI(8) IN UNITS OF (M/SEC)**4, AND THE SQUARE OF
C THE RATIO BETWEEN THE RADIUS OF THE BJERHAMMAR-SPHERE (RB) AND THE
C MEAN RADIUS OF THE EARTH (RE) MUST BE STORED IN CI(10).
C
C THERE ARE THEN THREE POSSIBILITIES:
C (1) ONE OF THE DEGREE-VARIANCE MODELS IS USED WITHOUT MODIFICATIONS.
C     THE SUMMATION LIMIT P OF REF.(A),EQ.(20) IS THEN FIXED TO 3.
C     BECAUSE THIS IS EQUIVALENT TO REQUIRING THE FIRST 3 DEGREE-VARIAN-
C     AREA /CMCOV/ MUST BE EQUAL TO 3 AND .TRUE., RESPECTIVELY.
C     CES TO BE ZERO, THE VARIABLES N1 AND LOCAL STORED IN THE COMMON
C (2) A NUMBER (N1) OF THE ANOMALY DEGREE-VARIANCES (DEGREE ZERO TO
C     N1-1) ARE PUT EQUAL TO EMPIRICAL DETERMINED QUANTITIES. THE ANO-
C     MALY DEGREE-VARIANCE OF DEGREE K WILL HAVE TO BE STORED IN
C     SIGMA0(IS+K+1) IN UNITS OF MGAL**2 WHEN CALLING COVAX. LOCAL MUST
C     BE EQUAL TO FALSE. COVAX WILL CONVERT THE ANOMALY DEGRE5-VARIANCES
C     INTO POTENTIAL DEGREE-VARIANCES. THE POINTER IS MUST BE POSITIVE.
C (3) THE N1 FIRST DEGREE-VARIANCES (DEGREE 0 - N1-1) ARE EQUAL TO ZERO.
C     THIS MEANS, THAT THE VALUES OF A (N1-1)-ORDER LOCAL COVARIANCE
C     FUNCTION WILL BE COMPUTED. LOCAL MUST HAVE THE VALUE .TRUE..
C IN ALL CASES N1 MUST BE LESS THAN 300.
C
C THE COVARIANCES WILL GENERALLY BE COMPUTED BY CLOSED EXPRESSIONS, BUT
C THEY MAY IN CERTAIN CASES BE USELESS IN BIG ALTITUDES OF NUMERICAL
C REASONS, CF. REF(A), SECTION 4. IN THEESE CASES MUST THE LOGICAL VARI-
C ABLE LSUM BE TRUE AND THE VARIABLE HMAX MUST HAVE ASSIGNED A VALUE
C EQUAL TO THE CRITICAL ALTITUDE. WHEN LSUM IS TRUE AND THE HEIGHT OF
C P OR Q IS GREATHER THAN HMAX, WILL THE SERIES REF(A), EQ.(16), ABBRE-
C VIATED TO DEGREE N2-1 BE USED FOR THE COMPUTATION OF THE COVARIANCES.
C THE VALUES OF LSUM, N2 AND HMAX WILL (IN THE SAME WAY AS FOR THE PARA-
C METERS SPECIFYING THE DEGREE-VARIANCE MODEL) BE TRANSFERRED TO COVAX
C THROUGH THE COMMON AREA /CMCOV/, BUT AN ARRAY SM IS TRANSFERRED AS A
C PARAMETER IN THE CALL IN ORDER TO ENABLE VARIABLE DIMENSIONING (SPECI-
C FIED BY THE VARIABLE N2 IN /CMCOV/).
C
C THE CALL OF COVAX WILL ALSO INITIALIZE CERTAIN VARIABLES USED IN
C SUBSEQUENT COMPUTATIONS.
C
C REFERENCES:
C (A) TSCHERNING,C.C.: COVARIANCE EXPRESSIONS FOR SECOND AND LOWER ORDER
C     DERIVATIVES OF THE ANOMALOUS POTENTIAL, REPORTS OF THE DEP. OF
C     GEODETIC SCIENCE NO. 225,1976.
C (B) TSCHERNING,C.C. AND R.H.RAPP: CLOSED COVARIANCE EXPRESSIONS
C     FOR GRAVITY ANOMALIES, GEOID UNDULATIONS, AND DEFLECTIONS OF
C     THE VERTICAL IMPLIED BY ANOMALY DEGREE-VARIANCE MODELS. DEP-
C     ARTMENT OF GEODETIC SCIENCE, THE OHIO STATE UNIVERSITY,
C     REPORT NO. 208, 1974.
C (C) KRARUP, T. AND C.C.TSCHERNING: EVALUATION OF ISOTROPIC COVARIANCE
C     FUNCTIONS OF TORSION BALANCE OBSERVATIONS. BULLETIN GEOD-
C     DESIQUE, VOL. 58, NO. 2, PP. 180-192, 1984.
C (D) TSCHERNING,C.C.: IMPLEMENTATION OF ALGOL-PROCEDURES FOR COV-
C     ARIANCE COMPUTATION ON THE RC 4000-COMPUTER. THE DANISH
C     GEODETIC INSTITUTE INTERNAL REPORT NO. 12, 1976.
C (H) TSCHERNING, C.C.: PREDICTION OF SPHERICAL HARMONIC
C     COEFFICIENTS USING LEAST-SQUARES COLLOCATION. SEPT. 1999.
C (I) TSCHERNING, C.C.: COMPUTATION OF COVARIANCES OF DERIVATIVES OF THE
C     ANOMALOUS GRAVITY POTENTIAL IN A ROTATED REFERENCE FRAME.
C     MANUSCRIPTA GEODAETICA, VOL. 18, NO. 3, PP. 115-123, 1993. 
C
      IMPLICIT NONE
C
      REAL*8 CI,CR,SIGMA0,SIGMA,HMAX,CV,D,D0,D1,D2,D3,D4,D5,RE,
     *RADSEC,PI,GM,A,S,RB2,T,B,SIGMAP,SLOP,SLOQ,CLOP,CLOQ,RB,RE2,SM
      INTEGER KI,N1,N2,ITCOUN,KT,KT1,K,II,JJ,N3,KK,KQ,KP,ND,NR,ND1,
     *ND2,IIDEG,JJORD,IS
      LOGICAL LOCAL,LSUM,LF,LT,LSPOUT
C
      COMMON /CMCOV/CI(24),CR(56),SIGMA0(2200),SIGMA(2200),HMAX,
     *CV(2,2),D(36),KI(37),N1,N2,LOCAL,LSUM
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,ITCOUN,LF,LT
      COMMON /DDY/A,S,RB2,T,B,KT,KT1,K,II,JJ,N3,KK,KQ,KP,ND,NR,ND1,ND2
      COMMON /PDEGV/SIGMAP(2200),SLOP,SLOQ,CLOP,CLOQ,IIDEG,JJORD,LSPOUT
C THE COMMON BLOCK CONTAINS THE VALUES OF PARAMETERS USED FOR THE COM-
C PUTATIONS AND RETURN VALUES OF FUNCTIONS AND CONSTANTS, WHICH HAVE
C BEEN USED IN THE COMPUTATIONS.
C PARAMETERS USED FOR THE COMPUTATIONS:
C   CI(8) = THE CONSTANT A(I) OF REF.(A), EQ.(17) IN UNITS OF (M/SEC)**4
C   CI(10) THE SQUARE OF THE RATIO BETWEEN THE BJERHAMMAR-SPHERE RADIUS
C   (RB) AND THE MEAN RADIUS OF THE EARTH (RE), OR IF NEGATIVE RB-RE,
C   (CHANGE MADE 3 JULY 1985).
C   SIGMA0(IS+1)-SIGMA0(IS+N1) MUST CONTAIN THE EMPIRICAL ANOMALY
C   DEGREE VARIANCES IN UNITS OF MGAL**2.
C   KI(3) = K(2) OF DEG.VAR. MODEL 2 OR 3,
C   KI(4) = K(3) OF DEG.VAR. MODEL 3, CF. REF.(A), EQ.(17).
C   KI(5) = THE DEG.VAR. MODEL NUMBER, (EQUAL TO 1, 2 OR 3),
C   N1 = THE NUMBER OF EMPIRICAL DEGREE-VARIANCES USED (LOCAL =.FALSE.)
C   OR (ORDER+1) OF THE LOCAL COVARIANCE FUNCTION USED (LOCAL=.TRUE.).
C   HMAX, N2, LSUM. HMAX IS THE HEIGHT ABOVE WHICH THE LEGENDRE SERIES
C   OF MAXIMAL DEGREE N2-1 WILL BE USED FOR THE COMPUTATION OF THE CO-
C   VARIANCES WHEN LSUM IS TRUE. N2 MUST BE GREATHER THAN 2 AS WELL AS
C   GREATHER THAN N1.
C RETURN VALUES:
C   CI(10) RB-RE, A NEGATIVE VALUE (MODIFICATION 3 JULY 1985).
C   CI(9) = RB**2.
C
      DIMENSION SM(2200)
C THE ARRAY SM IS USED TO STORE THE DEGREE-VARIANCES WHEN THE LOGICAL
C VARIABLE LSUM IS TRUE. IN CASE THE SUBSCRIPT LIMIT IS CHANGED IS IT
C NECESSARY TO CHANGE THE VALUE OF THE VARIABLE N2 ACCORDINGLY.
C
      KT = KI(5)
      KT1 = KT+1
      IF (KT.GE.3) GO TO 15
      DO 16 K = KT, 2
   16 KI(K+2) = D0
   15 KI(1) = -2
      KI(2) = -1
C
      IF ((KT.LT.3).OR.(KT.EQ.3.AND.KI(4).GT.KI(3))) GO TO 17
C ASSURING, THAT KI(4).GT.KI(3), BECAUSE THIS FACT IS USED IN SUB-
C SEQUENT COMPUTATIONS.
      K = KI(3)
      KI(3) = KI(4)
      KI(4) = K
   17 II = KI(3)
      JJ = KI(4)
      SM(1) = D0
      SM(2) = D0
C     N3 = N1
      A = CI(8)
      S = CI(10)
      IF (S.GT.D0) GO TO 40
C S IS HERE RB-RE, A NEGATIVE VALUE. (MODIFICATION 3 JULY 1985).
      RB=RE+S
      RB2=RB*RB
      RE2=RE*RE
      S=RB2/RE2
      GO TO 41
   40 RB2 = S*RE2
      CI(10)=RE*( SQRT(S)-D1)
   41 CI(9) = RB2
      RB2 = RB2*1.0D-10
      T = D0
C
      SIGMA0(IS+1) = D0
      SIGMA0(IS+2) = D0
      IF (LOCAL) THEN
      SIGMA0(IS+3) = D0
      ELSE
      SIGMA0(IS+3) = SIGMA0(IS+3)*RB2/S**4
      END IF
      DO 13 K = 4, N1
      GO TO (10,11,12),KT
   10 KK = 1
      GO TO 14
   11 KK = K+II-1
      GO TO 14
   12 KK = (K+II-1)*(K+JJ-1)
   14 IF (K.LE.N1) THEN
C CONVERSION FROM MGAL**2 TO M**2/SEC**2.
      IF (.NOT.LOCAL) T = SIGMA0(IS+K)*S**(-K-1)*RB2
      SIGMA0(IS+K) = (T-A*(K-2)/((K-3)*KK))/(K-2)**2
      END IF
   13 CONTINUE
      RETURN
      END
C ------------------------------------------------------------------
      SUBROUTINE COVBX(SM,LSAT,IS)
C ORIGINAL VERSION PROGRAMMED JULY 1975 BY C.C.TSCHERNING AS A SUB-
C ENTRY OF COVAX. NEW VERSION CREATED SEP 1987 BY CCT.
C NEW VERSION JUNE 4, 1991. LAST UPDATE 2008-10-24 BY CCT.  
C
C THE CALL OF COVBX WILL FIX CERTAIN CONSTANTS USED FOR THE COMPUTA-
C TIONS, WHICH ARE INDEPENDENT OF THE POINTS P AND Q. WHEN COVBX IS CAL-
C LED, THE KIND OF QUANTITIES BETWEEN WHICH THE COVARIANCE IS TO BE
C COMPUTED MUST BE SPECIFIED.  THIS IS DONE BY STORING IN KI(6) AND
C KI(7) INTEGERS EQUAL TO THE EQUATION NUMBERS OF REF.A, EQ.(1) - (9)
C (12) AND (14), AND 10, 11, 13, 15 CORRESPONDING TO REF.(C), EQ.
C (3) - (6). HOWEVER, THE QUANTITY OF KIND 2 IS NOW THE GRAVITY
C DISTURBANCE (CHANGED FROM THE SAME QUANTITY DIVIDED BY R).
C ADDED 1999.02.12 IS (17), FOR COEFFICIENTS OF SPHERICAL HARMONICS.
C
C REFERENCES (A) - (I): SEE COVAX.
C
      IMPLICIT NONE
      REAL*8 CI,CR,SIGMA0,SIGMA,HMAX,CV,D,D0,D1,D2,D3,D4,D5,RE,
     *RADSEC,PI,GM,A,S,RB2,T,B,SIGMAP,SLOP,SLOQ,CLOP,CLOQ,
     *COVX,CIX,CFA,SM,SIGMAX,RE2,SNN,BB0,RKP,REM,C11
      INTEGER KT,KT1,K,II,JJ,N3,KK,KQ,KP,ND,NR,ND1,ND2,IIDEG,JJORD,
     *KSAT,NDX1,NDX2,NDP,NDQ,NWAR,KI,N1,N2,ITCOUN,K7,K9,K11,K13,
     *K15,K17,K19,K21,K23,K8,J2,I3,I4,M,MK,IS,I,NDT,NDTOT,NDY,KU
C
      LOGICAL LOCAL,LSUM,LN,L,LF,LT,LSAT,LNX,LTEST,LTESTS,LSPOUT,LX,
     *LSPHAR
C
      COMMON /CMCOV/CI(24),CR(56),SIGMA0(2200),SIGMA(2200),HMAX,
     *CV(2,2),D(36),KI(37),N1,N2,LOCAL,LSUM
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,ITCOUN,LF,LT
      COMMON /DDX/K7(17),K9(17),K11(17),K13(17),K15(17),K17(17),
     *K19(17),K21(17),K23(17),K8(17),C11(17),J2(2),I3(2),I4(2),
     *LN(7),L(7)
      COMMON /DDY/A,S,RB2,T,B,KT,KT1,K,II,JJ,N3,KK,KQ,KP,ND,NR,ND1,ND2
      COMMON /PDEGV/SIGMAP(2200),SLOP,SLOQ,CLOP,CLOQ,IIDEG,JJORD,LSPOUT
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFA,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP,NDQ,NWAR,LX(7,5),LNX(7,5),LTESTS 
C THE COMMON BLOCK CONTAINS THE VALUES OF PARAMETERS USED FOR THE COM-
C PUTATIONS AND RETURN VALUES OF FUNCTIONS AND CONSTANTS, WHICH HAVE
C BEEN USED IN THE COMPUTATIONS.
C PARAMETERS USED FOR THE COMPUTATIONS:
C   CI(8) = THE CONSTANT A(I) OF REF.(A), EQ.(17) IN UNITS OF (M/SEC)**4
C   CI(10) THE SQUARE OF THE RATIO BETWEEN THE BJERHAMMAR-SPHERE RADIUS
C   (RB) AND THE MEAN RADIUS OF THE EARTH (RE), OR IF NEGATIVE RB-RE,
C   (CHANGE MADE 3 JULY 1985).
C   CI(13) USER DEFINED VALUE OF CI(11). CI(14), CI(15) USER DEFINED
C   VALUES OF CI(21) - CI(24).
C   SIGMA0(IS+1)-SIGMA0(IS+N1) MUST CONTAIN THE POTENTIAL ANOMALY
C   DEGREE-VARIANCE CORRECTIONS, CF. REF.(A), EQ.16.
C   KI(3) = K(2) OF DEG.VAR. MODEL 2 OR 3,
C   KI(4) = K(3) OF DEG.VAR. MODEL 3, CF. REF.(A), EQ.(17).
C   KI(5) = THE DEG.VAR. MODEL NUMBER, (EQUAL TO 1, 2 OR 3),
C   KI(6),KI(7) THE INTEGER SPECIFYING THE KIND OF QUANTITY WHICH IS
C   ASSOCIATED WITH P, Q, RESPECTIVELY,
C   KI(26) - KI(34) USER SPECIFIED VALUES FOR KI(10) - KI(23).
C   KI(35) - KI(37) USED BY SUBROUTINE COVCG FOR STATISTICAL PURPOSES.
C   N1 = THE NUMBER OF EMPIRICAL DEGREE-VARIANCES USED (LOCAL =.FALSE.)
C   OR (ORDER+1) OF THE LOCAL COVARIANCE FUNCTION USED (LOCAL=.TRUE.).
C   HMAX, N2, LSUM. HMAX IS THE HEIGHT ABOVE WHICH THE LEGENDRE SERIES
C   OF MAXIMAL DEGREE N2-1 WILL BE USED FOR THE COMPUTATION OF THE CO-
C   GREATHER THAN N1.
C RETURN VALUES:
C   CI(1)-CI(7), THE QUANTITIES C(J,Q) OF REF.(A), EQ.(47), WITH
C   CI(1) - CI(KI(5)+1) = C(J,Q), CI(5) = C(KI(5)+2,Q),
C   CI(6) = C(KI(5)+3,Q), CI(7) = C(KI(5)+4,Q),
C   CI(11),CI(12) QUANTITIES USED TO GIVE THE COMPUTED
C   COVARIANCES THE PROPER UNITS.
C   CI(21) - CI(24) THE QUANTITIES M(1) - M(4) OF REF.(A) EQ. (26) -
C   (29). (CHANGE MADE 1986.10.20).
C   SIGMA(IS+4) - SIGMA(IS+N1), THE POTENTIAL DEGREE-VARIANCES MULTI-
C   PLIED BY THE FACTORS GIVEN IN REF.(A), TABLE 1.
C   SIGMA(IS+1) - SIGMA(IS+3), THE DEGREE-VARIANCES OF DEGREE 0,1,2
C   MINUS TERMS OF THE SAME DEGREES ACQUIRED FROM REF.(A), EQ.(34),(35),
C   (41) AND (42).
C   KI(8),KI(9) THE NUMBER OF DIFFERENTIATIONS IN RADIAL DIRECTION AND
C   WITH RESPECT TO T = COS(SPHERICAL DIST.) TO BE PERFORMED.
C   KI(10) - KI(15) THE CONSTANTS I,K,J,M,J1,M1 OF REF.(A), SECTION 2.
C   KI(16) - KI(19) THE QUANTITIES M(1) - M(4) OF REF.(A), EQ.(26)-(29).
C   KI(20),KI(21) THE EXPONENT OF THE REFERENCE GRAVITY,
C   KI(22),KI(23) THE EXPONENT OF THE RADIAL DISTANCE AND
C   KI(24),KI(25) SUBSCRIPTS OF THE RESULT STORED IN CV (COMMON CMCOV).
C
      DIMENSION SM(2200),SIGMAX(2200,5)
C THE ARRAY SM IS USED TO STORE THE DEGREE-VARIANCES WHEN THE LOGICAL
C VARIABLE LSUM IS TRUE. IN CASE THE SUBSCRIPT LIMIT IS CHANGED IS IT
C NECESSARY TO CHANGE THE VALUE OF THE VARIABLE N2 ACCORDINGLY.
C     EQUIVALENCE (SIGMAX(1,1),SIGMA0(401))
C SIGMAX IS USED TO HOLD DEGREE-VARIANCES OF RADIAL DERIVATIVES
C UP TO ORDER 2 IN P AND Q. (CHANGE MAY 1991).
C
C THE ARRAYS K7 - K23 CONTAINS TABLES OF QUANTITIES RELATED TO THE KIND
C OF COVARIANCES (1 - 14) WHICH MAY BE COMPUTED. THEIR ACTUAL VA-
C LUES WILL AFTER CALL OF COVBX BE STORED IN THE ELEMENTS OF THE ARRAY
C KI HAVING SUBSCRIPTS 8 - 25.
C K7 CONTAINS THE ORDER OF DIFFERENTIATION WITH RESPECT TO T,K8 THE
C ORDER OF DIFFERENTIATION WITH RESPECT TO THE RADIUS, CF.REF(A),TABLE
C 1. K9,K11,K13 THE KIND OF DIFFERENTIATIONS TO BE COMPUTED WITH RESPECT
C TO THE LATITUDE (2) AND THE LONGITUDE (3), CF.REF(A),SECTION 3. K15
C AND K17 CONTAINS AN INTEGER, WHICH WILL BE ADDED TO THE DEGREE. THE
C SUM WILL THEN BE MULTIPLIED WITH THE DEGREE-VARIANCE OF THE CORRESPON-
C DING DEGREE WHEN A FIRST AND/OR SECOND DIFFERENTIATION WITH RESPECT
C TO THE RADIAL DISTANCE HAS TAKEN PLACE.
C C11 CONTAIN QUANTITIES USED TO GIVE THE COVARIANCES THE PROPER UNITS.
C
C     LTEST=LTESTS
      LTEST=.FALSE. 
      LSPHAR=.FALSE.
      RB2 = CI(9)
      RE2=RE**2
      S=RB2/RE2
      A = CI(8)
      II=KI(3)
      JJ=KI(4)
      KT=KI(5)
      KT1=KT+1
      N3=N1
      CI(11) = D1
      KI(8)=0
      KI(9)=0
      IF (KI(6).GT.17.OR.KI(7).GT.17) GO TO 19
C
      DO 20 M = 1, 2
      K = KI(M+5)
C FOR M = 1, K IS EQUAL TO THE KIND EVALUATED IN P AND FOR M = 2 EQUAL
C TO THE KIND EVALUATED IN Q.
C
      IF (K.EQ.0.OR.K.GE.16) GO TO 42
      KI(M+9) = K9(K)
      KI(M+11) = K11(K)
      KI(M+13) = K13(K)
      CI(M+20) = K15(K)
      CI(M+22) = K17(K)
      KI(M+19) = K19(K)
      KI(M+21) = K21(K)
      KI(M+23) = K23(K)
C
      CI(11) = CI(11)*C11(K)
C     WRITE(*,*)' K ',K,CI(21),CI(22),CI(23),CI(24)
      KI(8)=KI(8)+K7(K)
      KI(9)=KI(9)+K8(K)
      GO TO 20
C
C USER DEFINED VALUES OF KI AND CI. MAY BE USER FOR DENSITY CONTRAST
C COVARIANCES, CF. REF.(D), SECTION 3.
   42 IF (K.NE.17) THEN
      DO 43 MK=1,8
   43 KI(M+MK*2+7)=KI(MK+25)
      CI(11) = CI(11)*CI(13)
      CI(M+20) = CI(14)
      CI(M+22) = CI(15)
      KI(8)=KI(8)+KI(29)
      KI(9)=KI(9)+KI(30)
C     LSPHAR=.FALSE.
C     WRITE(*,*)' LSPHAR=F '
      ELSE
      LSPHAR=.TRUE.
      CI(21)=D0
      CI(22)=D0
      CI(23)=D0
      CI(24)=D0
C     WRITE(*,*)' LSPHAR=T '
C     WRITE(*,*)' N1,N3 ',N1,N3
      END IF
   20 CONTINUE
C
      KQ = K
      KP = KI(6)
   19 ND = KI(8)
C     WRITE(*,*)' COVBX: ND= ',ND
      NR = KI(9)
C              
      NDP=K7(KP)+K8(KP)
      NDQ=K7(KQ)+K8(KQ)
C     WRITE(*,*)' COVBX: ND,NDP,NDQ= ',ND,NDP,NDQ
C ND AND NR ARE THE NUMBER OF DIFFERENTIATIONS WITH RESPECT TO T AND
C THE RADIAL DISTANCES, RESPECTIVELY. NDP, NDQ ARE THE TOTAL NMBER OF
C DERIVATIVES IN P, Q, REPECTIVELY.
C
      IF (LSAT.AND.(.NOT.LSPHAR)) GO TO 100 
C UPDATING THE DEGREE-VARIANCES, CF. REF(A), TABLE 1.
      SIGMA(IS+1) = D0
      SIGMA(IS+2) = D0
      SIGMAP(IS+1)= D0
      SIGMAP(IS+2)= D0
      IF (LSUM) N1 = N2
      IF (N1.GE.2200) WRITE(*,*)' WARNING N1.GT.2200 '
C correction here.
      SNN=S**3
C CHANGE 2008-10-24.
      DO 21 M = 3, 2200
      B = D1
      DO 22 I = 1, 4
   22 IF ( ABS(CI(I+20)).GT.0.0) B = B*(M+CI(I+20)-1)
      BB0=B
      IF (M.LE.N3) SIGMA(IS+M) = SIGMA0(IS+M)*B
      IF (.NOT.(LSUM.OR.LSPHAR).OR.M.EQ.3) GO TO 21
      DO 48 K = 1, KT1
   48 B = B/(M+KI(K)-1)
C STORING THE MODIFIED DEGREE-VARIANCES OF DEGREE M-1 IN SM(M) AND AD-
C DING THE DEGREE-VARIANCE CORRECTIONS FOR M .LE. N3.
      SM(M) = B*A
      SNN=SNN*S
      IF (M.LE.N3) THEN
      SM(M) = SM(M)+SIGMA(IS+M)
C     SIGMAP(M)=SM(M)*SNN
      SIGMAP(M)=SM(M)*SNN/BB0
      ELSE
C     SIGMAP(M)=B*A*SNN
      SIGMAP(M)=A*SNN*B/BB0
      END IF
C
C CF. REF(H), EQ. (4).
      SIGMAP(M)=SIGMAP(M)/(D2*M-D1)
   21 CONTINUE
      IF (N1.GT.2) THEN
      SM(3) = SIGMA(IS+3)
C     SIGMAP(3)=SM(3)*(S**3)/5.0D0
      SIGMAP(3)=SM(3)*(S**3)/(BB0*5.0D0)
      ELSE
      SIGMAP(3)=0.0D0
      END IF
C
C     WRITE(*,*)' SIGMA0, K=1,200 '
C     WRITE(*,249)(SIGMA0(K),K=1,200)
C     WRITE(*,*)' SIGMA, K=1,200 '
C     WRITE(*,249)(SIGMA(K),K=1,200)
      IF (LSPHAR.AND.LSPOUT) THEN
      LSPOUT=.FALSE.
      WRITE(*,*)' GRAVITY ANOMALY AND POTENTIAL DEG.VAR. DEG 3-200 '
      WRITE(*,249)
     *(SIGMAP(K)*(2*K-1)*(K-2)**2*1.0D10/RE2,K=3+IS,200+IS)
      WRITE(*,249)(SIGMAP(K),K=3+IS,200+IS)
  249 FORMAT(8F9.4)
      END IF
      IF (LSUM) N1 = N3
C
C EVALUATION OF THE QUANTITIES C(J,NR), CF.REF(A), TABLE 2.
      DO 23 K = 1, 7
   23 CI(K) = D0
C
      DO 25 K = 1, KT1
      CI(K) = D1
      DO 25 KQ = 1, KT1
   25 IF (K.NE.KQ) CI(K) = CI(K)/(KI(KQ)-KI(K))
C CF.,EQ.(19). WE WILL THEN COMPUTE THE QUANTITIES GIVEN IN REF(A)
C REF(A), TABLE 2.
      IF (NR.LT.2) GO TO 29
      RKP = CI(21)+CI(22)+CI(23)+CI(24)
      IF (NR.EQ.4) REM = CI(21)*(CI(22)+CI(23)+CI(24))+CI(22)
     *                 *(CI(23)+CI(24))+CI(23)*CI(24)
C
      GO TO (26,27,28),KT
   26 CI(NR+3) = D1
      IF (NR.GT.2) CI(NR+2) = RKP+3
      IF (NR.EQ.4) CI(NR+1) = REM+3*RKP+7
      GO TO 29
   27 IF (NR.GT.2) CI(NR+2) = D1
      IF (NR.EQ.4) CI(NR+1) =-KI(3)+3+RKP
      GO TO 29
   28 IF (NR.EQ.4) CI(NR+1) = D1
   29 IF (NR.EQ.0) GO TO 31
C
      DO 30 KP = 1, 4
      DO 30 K  = 1, KT1
   30 IF ( ABS(CI(KP+20)).NE.0.0) CI(K) = CI(K)*(CI(KP+20)-KI(K))
C
C THE LOGICAL ARRAYS L AND LN REGISTER WHICH TERMS THAT WILL HAVE TO
C BE EVALUATED , RESPECTIVELY NOT EVALUATED IN REF.(A), EQ. (47).
   31 DO 38 K = 1, 7
      L(K) =  ABS(CI(K)).GT.1.0E-15
   38 LN(K) = .NOT.(L(K))
C
      DO 32  K = 3, 7
      DO 32  M = 1, 3
      IF (M.EQ.1.AND.K.GT.5.OR.(M+KI(K)-1).EQ.0.AND.K.LT.5.OR.LN(K))
     *GO TO 32
      GO TO (34,34,35,35,34,36,37),K
   34 B = D1
      GO TO 33
   35 B = D1/(M+KI(K) -1)
      GO TO 33
   36 B = (M-1)
      GO TO 33
   37 B = (M-1)*(M-1)
   33 SIGMA(IS+M) = SIGMA(IS+M)-A*CI(K)*B
   32 CONTINUE
      SIGMA(IS+3) = SIGMA(IS+3)-A*CI(2)
      IF (LTEST) WRITE(*,2)(SIGMA(I),I=1,6)
    2 FORMAT(6E12.6,I3)
C
      ND1 = ND+1
      ND2 = ND1+1
      RETURN 
C              
  100 DO 109 M=1,7
      DO 109 NDT=1,5
  109 LNX(M,NDT)=LT
      NDTOT=NDP+NDQ+1
      ND=NDTOT-1
      ND1=ND+1
      ND2=ND1+1
C
      DO 101 NDT=1,NDTOT
      DO 110 M=1,4
  110 CI(M+20)=D0
      M=1
      IF (NDT.GT.1) THEN
       CI(21)=D1
       M=2
      END IF
      IF (NDT.GT.2) THEN
      IF (NDP.EQ.1.AND.NDQ.EQ.1.AND.NDTOT.EQ.3) THEN
      CI(22)=D1
      ELSE 
      CI(22)=D2
      END IF
      M=3
      END IF
      IF (NDT.GT.3) THEN
      CI(23)=D1
      M=M+1
      IF (NDT.EQ.5)THEN
      CI(24)=D2
      M=M+1
      END IF
      END IF
      NR=M-1
      NDY=NDTOT-M
      IF (LTEST)WRITE(6,*)NDT,CI(21),CI(22),CI(23),CI(24)
C UPDATING THE DEGREE-VARIANCES, CF. REF(A), TABLE 1.
      SIGMAX(1,NDT) = D0
      SIGMAX(2,NDT) = D0
      DO 121 M = 3, N1
      B = D1
      DO 122 I = 2, NDT
  122 B = B*(M+CI(I+19)-1)
C NOGET GALT HER.
  121 IF (M.LE.N3) SIGMAX(M,NDT) = SIGMA0(IS+M)*B
C
C EVALUATION OF THE QUANTITIES C(J,NR), CF.REF(A), TABLE 2.
      DO 123 K = 1, 7
  123 CI(K) = D0
C
      DO 125 K = 1, KT1
      CI(K) = D1
      DO 125 KU = 1, KT1
  125 IF (K.NE.KU) CI(K) = CI(K)/(KI(KU)-KI(K))
C CF.,EQ.(19). WE WILL THEN COMPUTE THE QUANTITIES GIVEN IN REF(A)
C REF(A), TABLE 2.
      IF (NR.LT.2) GO TO 129
      RKP = CI(21)+CI(22)+CI(23)+CI(24)
      IF (NR.EQ.4) REM = CI(21)*(CI(22)+CI(23)+CI(24))+CI(22)
     *                 *(CI(23)+CI(24))+CI(23)*CI(24)
C
      GO TO (126,127,128),KT
  126 CI(NR+3) = D1
      IF (NR.GT.2) CI(NR+2) = RKP+3
      IF (NR.EQ.4) CI(NR+1) = REM+3*RKP+7
      GO TO 129
  127 IF (NR.GT.2) CI(NR+2) = D1
      IF (NR.EQ.4) CI(NR+1) =-KI(3)+3+RKP
      GO TO 129
  128 IF (NR.EQ.4) CI(NR+1) = D1
  129 IF (NR.EQ.0) GO TO 131
C
      DO 130 KU = 1, 4
      DO 130 K  = 1, KT1
  130 IF ( ABS(CI(KU+20)).NE.0.0) CI(K) = CI(K)*(CI(KU+20)-KI(K))
  131 DO 106 K=1,7
  106 CIX(K,NDT)=CI(K) 
C
C THE LOGICAL ARRAYS L AND LN REGISTER WHICH TERMS THAT WILL HAVE TO
C BE EVALUATED , RESPECTIVELY NOT EVALUATED IN REF.(A), EQ. (47).
      DO 138 K = 1, 7
      IF (NDT.EQ.1) L(K)=LF 
      LNX(K,NDT)= ABS(CI(K)).LE.1.0D-10
      L(K) =  ABS(CI(K)).GT.1.0E-10.OR.L(K) 
  138 LN(K)=.NOT.(L(K))
      IF (LTEST) WRITE(6,*)'NDT,LN',NDT,(LNX(K,NDT),K=1,7)
C
      DO 132  K = 3, 7
      DO 132  M = 1, 3
      IF (M.EQ.1.AND.K.GT.5.OR.(M+KI(K)-1).EQ.0.AND.K.LT.5.OR.
     *LNX(K,NDT)) GO TO 132
      GO TO (134,134,135,135,134,136,137),K
  134 B = D1
      GO TO 133
  135 B = D1/(M+KI(K) -1)
      GO TO 133
  136 B = (M-1)
      GO TO 133
  137 B = (M-1)*(M-1)
  133 SIGMAX(M,NDT) = SIGMAX(M,NDT)-A*CI(K)*B
  132 CONTINUE
      SIGMAX(3,NDT) = SIGMAX(3,NDT)-A*CI(2)
      IF (LTEST) WRITE(*,2)(SIGMAX(I,NDT),I=1,6),NDT
C
      NDX1(NDT) = NDY+1
      NDX2(NDT) = NDY+2
  101 CONTINUE 
      RETURN
      END
C ------------------------------------------------------------------
      SUBROUTINE COVCX(SM,COV,IS,LSAT)
C ORIGINALLY PROGRAMMED JULY 1975 BY C.C.TSCHERNING AS A SUB-
C ENTRY TO COVAX. SEPARATE SUBROUTINE CREATED SEPT 1987 BY CCT.
C LATEST MODIFICATION MAY 05, 2008 BY CCT. 
C
C COMPUTATION OF THE COVARIANCE IN A SPECIFIC PAIR OF POINTS, OR
C BETWEEN A FUNCTIONAL ASSOCIATED WITH A POINT AND A SPHERICAL-HARMONIC
C COEFFICIENT. THE  VALUE IS RETURNED THROUGH THE PARAMETER COV.
C THE COVARIANCES COMPUTED WILL BE IN UNITS CORRESPONDING TO THE KIND
C OF QUANTITIES, I.E. FOR KIND (1) METERS, (2) EOTVOS (E), (3) MGAL,
C (4),(5) E, (6),(7) ARCSECONDS, (8) - (14) E, (17) UNITLESS.
C THE FOLLOWING QUANTITIES MUST BE STORED IN THE ELEMENTS OF THE ARRAY
C CR WHEN COVCX IS CALLED: (1) COSINE TO THE SPHERICAL DISTANCE BET-
C WEEN P AND Q, (2),(3) THE HEIGHT OF P, Q RESPECTIVELY, (4),(5) SINE
C OF THE LATITUDE THE  OF P, Q, RESPECTIVELY, (6),(7) COSINE OF THE
C LATITUDE OF P, Q, RESPECTIVELY, (8),(9) SINE AND COSINE OF THE
C LONGITUDE DIFFERENCE. THE REFERENCE GRAVITY WILL HAVE TO BE STORED
C IN CR(10),CR(11) FOR P, Q RESPECTIVELY (WHEN USED, OTHERWISE STORE
C 1.0). FOR KIND 17, COS AND SIN OF LONGITUDES MUST BE STORED IN THE
C COMMON BLOCK /PDEGV/.
C
C THE CALL OF COVCX WILL RESULT IN THE COMPUTATION OF THE COVARIANCE ,
C WHICH IS TRANSFERRED TO THE CALLING PROGRAM THROUGH THE VARIABLE COV.
C THE RESULT WILL ALSO BE TRANSFERRED IN THE COMMON CMCOV, BY THE ARRAY
C CV(2,2). IN CASE IT IS POSSIBLE TO COMPUTE MORE THAN ONE QUANTITY AT
C A TIME (I.E. WHEN DERIVATIVES WITH RESPECT TO T=COS(SPHERICAL DIST-
C TANCE) ARE COMPUTED, KINDS 6 - 11, 13 AND 15), THE COVARIANCE
C OF TYPE 6, 8, 10 AND 23 WILL BE STORED IN THE ELEMENT WITH SUBSCRIPT
C 2 AND OTHERWISE IN THE ELEMENT WITH SUBSCRIPT 1. THE KIND OF THE
C FUNCTIONALS IN P WILL DETERMINE THE VALUE OF THE FIRST SUBSCRIPT
C WHILE THE KIND OF THE FUNCTIONALS IN Q WILL DETERMINE THE SECOND C SUBSCRIPT. EXAMPLE: KIND 6 IN P AND KIND 1 IN Q WILL DELIVER
C THE COVARIANCE BETWEEN THE PRIME-VERTICAL VERTICAL DEFLECTION AND
C AND THE HEIGHT ANOMALY IN CV(1,1), BETWEEN THE MERIDIAN VERTICAL
C DEFLECTIAN AND THE HEIGHT ANOMALY IN CV(2,1).
C
C WHEN LSAT IS TRUE, THE 4D ARRAY COVX HOLDS THE VECTORS OR MATRICES
C OF COVARIANCES BETWEEN ALL 0, 1 OR 2 DERIVATIVES.
C
      IMPLICIT NONE
      REAL*8 CI,CR,SIGMA0,SIGMA,HMAX,CV,D
      INTEGER KI,N1,N2,ITCOUN,IIMAX,IMAX1,I21,I,ILAST,JMAX1,J,JKK,IKK,
     *NCASE,KPQ,IDIF,KKC,KKD,M,K1,K2,I1,I2,NDTOT,NDT,IS,J1,M1,IJ,KM,IX,
     *IIX,IIY,JX,IX1,JX1,K6,M6 ,KZ
C    *,ID,JD
      REAL*8 D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,C11,CN,CY,R2PQ,
     *A,S,RB2,T,B,HP,HQ,SP,SQ,CP,CQ,SD,CD,RP,RQ,RE2,CLAT,SLAT,CLON,SLON,
     *RH,GAMM,COV,CJLO,SJLO,WWC,GGC,WWS,GGS,COVC,WW,DDDC,DDDS,
     *GG,DDD,SJL1,SC,CS,SCC,CC,CCS,COVS,CSC,CPSD,CQSD,CPCD,CQCD,SS,C,
     *S2,ST,T2,P2,P3,CX,GI,GJ,SI,SM,DC,SIGMAX,DCN,RL,RL2,R,RL1,RN,
     *RNL,P,RL3,RL5,S3,RL4,RL7,S4,S5,RL6,U,RM,V,Q,G,SS1,SS2,RP2,
     *RQ2,RPQ,FAK5,RP2Q,CNX,DD,RPQ2,D3132,D313,CN23,CN33,D37,D27,
     *CF,CZ,C11P,C11Q
      INTEGER KT,KT1,K,II,JJ,N3,KK,KQ,KP,ND,NR,ND1,ND2,
     *KSAT,NDX1,NDX2,NDP,NDQ,NWAR,IIOLD,JOLD
     *,NFU,KEYH,NINTH,NTABH,NHE,NSTART,IIDEG,JJORD,NSPHAR
      REAL*8 COVX,CIX,CFA,RRC,HTA,TMAX,SIZEI,SIGMAP,SLOP,SLOQ,
     *CLOP,CLOQ,ROOT0,SUMIJ,CCCIJ,
     *SQ2,YS,YC,VV,V1,GS,GC,DDS,DDC,PII,PIM0,PIM1,PIM2,DLP,
     *DLP0,DLP1,DLP2,DAP,DAP0,
     *DAP1,DAP2,DDAP,DDAP0,DDAP1,DDAP2,DDAL0,DDAL1,VI
      INTEGER K7,K9,K11,K13,K15,K17,K19,K21X,K23,K8,J2,I3,I4

      PARAMETER (IIMAX=20000,NSPHAR=180)
C
      LOGICAL LOCAL,LSUM,LSUMC,LOLDP,LOLDQ,LN,L,LF,LT,LTEST,LTABH
     *,LTA,LSAT,LTESTS,LDGP,LDGQ,LSPHAR,LSPOUT,LTSPH,LCOS  
     *,LSPHP,LSPHQ,LX,LNX
C
      COMMON /CMCOV/CI(24),CR(56),SIGMA0(2200),SIGMA(2200),HMAX,
     *CV(2,2),D(36),KI(37),N1,N2,LOCAL,LSUM
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,ITCOUN,LF,LT
      COMMON /DDX/K7(17),K9(17),K11(17),K13(17),K15(17),K17(17),
     *K19(17),K21X(17),K23(17),K8(17),C11(17),J2(2),I3(2),I4(2),
     *LN(7),L(7)
C     COMMON /DDX/K7(15),K9(15),K11(15),K13(15),K15(15),K17(15),K19(15),
C    *K21(15),K23(15),K8(15),C11(15),J2(2),I3(2),I4(2),LN(7),L(7)
      COMMON /DDY/A,S,RB2,T,B,KT,KT1,K,II,JJ,N3,KK,KQ,KP,ND,NR,ND1,ND2
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFA,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP,NDQ,NWAR,LX(7,5),LNX(7,5),LTESTS 
      COMMON /CTABH/RRC(1200),HTA(5),TMAX,SIZEI,NFU(5),KEYH(5,5),
     *NINTH,NTABH(15,5,5),NHE,NSTART,LTABH
      COMMON /PDEGV/SIGMAP(2200),SLOP,SLOQ,CLOP,CLOQ,IIDEG,JJORD,LSPOUT
      COMMON  /RRSPH/ROOT0(IIMAX)
C     COMMON /CON3/SUMIJ(32761),CCCIJ(32761),
      COMMON /CON3/SUMIJ((NSPHAR+1)**2),CCCIJ((NSPHAR+1)**2),
     *SQ2,YS,YC,VV,V1,GS(3),GC(3),DDS(3,3),
     *DDC(3,3),IIOLD,JOLD,LSPHAR,LTSPH
      COMMON /SPHOLD/PII,PIM0,PIM1,PIM2,DLP,DLP0,DLP1,DLP2,DAP,DAP0,
     *DAP1,DAP2,DDAP,DDAP0,DDAP1,DDAP2,DDAL0,DDAL1,VI
C THE COMMON BLOCK CONTAINS THE VALUES OF PARAMETERS USED FOR THE COM-
C PUTATIONS AND RETURN VALUES OF FUNCTIONS AND CONSTANTS, WHICH HAVE
C BEEN USED IN THE COMPUTATIONS.
C PARAMETERS USED FOR THE COMPUTATIONS:
C   CI(8) = THE CONSTANT A(I) OF REF.(A), EQ.(17) IN UNITS OF (M/SEC)**4
C   CI(10) THE SQUARE OF THE RATIO BETWEEN THE BJERHAMMAR-SPHERE RADIUS
C   (RB) AND THE MEAN RADIUS OF THE EARTH (RE), OR IF NEGATIVE RB-RE,
C   (CHANGE MADE 3 JULY 1985).
C   CI(13) USER DEFINED VALUE OF CI(11). CI(14), CI(15) USER DEFINED
C   VALUES OF CI(21) - CI(24).
C   NEW VARIABLES ADDED MAY 1, 1986 AND NOV 1986:
C   CI(16) - CI(24), WHERE CI(20)=0.0 IF PRECISE FORMULAE FOR DERIVATIVES
C   MAY BE USED. IN THIS CASE IS CI(16)=SIN(LONGITUDE DIFFERENCE/2)**2,
C   CI(17)=SIN(LATITUDE DIFFERENCE/2), CI(18)=COS(LATITUDE DIFFERENCE),
C   CI(19)=COS(LATITUDE DIFFERENCE/2). OTHERWISE CI(20)=1.0.
C   CR(2),CR(3) THE HEIGHT OF P, Q, RESPECTIVELY, (UNITS METERS),
C   CR(4),CR(5) SINE OF THE LATITUDE OF P, Q, RESPECTIVELY,
C   CR(6),CR(7) COSINE OF THE LATITUDE OF P, Q, RESPECTIVELY,
C   CR(8),CR(9) SINE AND COSINE OF THE LONGITUDE DIFFERENCE,
C   CR(10),CR(11) THE REFERENCE GRAVITY IN P, Q, RESPECTIVELY (WHEN
C   USED, OTHERWISE STORE 1.0E0), (UNITS M/SEC**2).
C   KI(3) = K(2) OF DEG.VAR. MODEL 2 OR 3,
C   KI(4) = K(3) OF DEG.VAR. MODEL 3, CF. REF.(A), EQ.(17).
C   KI(5) = THE DEG.VAR. MODEL NUMBER, (EQUAL TO 1, 2 OR 3),
C   KI(6),KI(7) THE INTEGER SPECIFYING THE KIND OF QUANTITY WHICH IS
C   ASSOCIATED WITH P, Q, RESPECTIVELY,
C   KI(26) - KI(34) USER SPECIFIED VALUES FOR KI(10) - KI(23).
C   KI(35) - KI(37) USED BY SUBROUTINE COVCG FOR STATISTICAL PURPOSES.
C   N1 = THE NUMBER OF EMPIRICAL DEGREE-VARIANCES USED (LOCAL =.FALSE.)
C   OR (ORDER+1) OF THE LOCAL COVARIANCE FUNCTION USED (LOCAL=.TRUE.).
C   HMAX, N2, LSUM. HMAX IS THE HEIGHT ABOVE WHICH THE LEGENDRE SERIES
C   OF MAXIMAL DEGREE N2-1 WILL BE USED FOR THE COMPUTATION OF THE CO-
C   VARIANCES WHEN LSUM IS TRUE. N2 MUST BE GREATHER THAN 2 AS WELL AS
C   GREATHER THAN N1.
C RETURN VALUES:
C   CR(ND*8+12), THE VALUES OF THE ND'TH DERIVATIVE OF THE SUM OF THE
C   FINITE LEGENDRE-SERIES, CF.REF.(A), EQ.(20),(48) AND (52).
C   CR(ND*8+13) - CR(ND*8+19), THE VALUES OF THE ND'TH DERIVATIVES OF
C   THE FUNCTIONS F(-2), F(-1), F(KI(3)), F(KI(4)), S0, S1, S2, CF. REF.
C   (A), EQ. (42), (41), (39), (39), (30), (34) AND (35).
C   SIGMA0(IS+1) - SIGMA0(IS+N1) THE POTENTIAL DEGREE-VARIANCE
C   CORRECTIONS, CF. REF.(A), EQ.(16), (AFTER THE CALL OF COVAX).
C   SIGMA(IS+4) - SIGMA(IS+N1), THE POTENTIAL DEGREE-VARIANCES MULTI-
C   PLIED BY THE FACTORS GIVEN IN REF.(A), TABLE 1.
C   SIGMA(IS+1) - SIGMA(IS+3), THE DEGREE-VARIANCES OF DEGREE 0,1,2
C   MINUS TERMS OF THE SAME DEGREES ACQUIRED FROM REF.(A), EQ.(34),(35),
C   (41) AND (42).
C   KI(8),KI(9) THE NUMBER OF DIFFERENTIATIONS IN RADIAL DIRECTION AND
C   WITH RESPECT TO T = COS(SPHERICAL DIST.) TO BE PERFORMED.
C   KI(10) - KI(15) THE CONSTANTS I,K,J,M,J1,M1 OF REF.(A), SECTION 2.
C   KI(16) - KI(19) THE QUANTITIES M(1) - M(4) OF REF.(A), EQ.(26)-(29).
C   KI(20),KI(21) THE EXPONENT OF THE REFERENCE GRAVITY,
C   KI(22),KI(23) THE EXPONENT OF THE RADIAL DISTANCE AND
C   KI(24),KI(25) SUBSCRIPTS OF THE RESULT STORED IN CV (COMMON CMCOV).
C
C ARRAYS CN, DCN, SIGMAX, DD ADDED MAY 1991. 
C
C REFERENCES (A)-(I) SEE COVAX.
C
      DIMENSION SM(2200),CX(6,8),DC(6),SIGMAX(400,5),CN(8,5),DCN(8,5),
     *C(6),V(6),U(6),G(6),P(6),R(6),SS1(4),CZ(5),RM(6),Q(6),DD(6,6)
C THE ARRAY SM IS USED TO STORE THE DEGREE-VARIANCES WHEN THE LOGICAL
C VARIABLE LSUM IS TRUE. IN CASE THE SUBSCRIPT LIMIT IS CHANGED IS IT
C NECESSARY TO CHANGE THE VALUE OF THE VARIABLE N2 ACCORDINGLY.
      DIMENSION GG(3),DDD(3,3),GGC(3),GGS(3),DDDC(3,3),DDDS(3,3)
C
      EQUIVALENCE (CX(1,1),C(1)),(CX(1,2),V(1)),(CX(1,3),U(1)),
     *(CX(1,4),G(1)),(CX(1,5),P(1)),(CX(1,6),R(1)),(CX(1,7),SS1(1)),
     *(CX(2,8),SS2),(SIGMAX(1,1),SIGMA0(401)),(D(1),DD(1,1))
C K7 CONTAINS THE ORDER OF DIFFERENTIATION WITH RESPECT TO T,K8 THE
C ORDER OF DIFFERENTIATION WITH RESPECT TO THE RADIUS, CF.REF(A),TABLE
C 1. K9,K11,K13 THE KIND OF DIFFERENTIATIONS TO BE COMPUTED WITH RESPECT
C TO THE LATITUDE (2) AND THE LONGITUDE (3), CF.REF(A),SECTION 3. K15
C AND K17 CONTAINS AN INTEGER, WHICH WILL BE ADDED TO THE DEGREE. THE
C SUM WILL THEN BE MULTIPLIED WITH THE DEGREE-VARIANCE OF THE CORRESPON-
C DING DEGREE WHEN A FIRST AND/OR SECOND DIFFERENTIATION WITH RESPECT
C TO THE RADIAL DISTANCE HAS TAKEN PLACE.
C C11 CONTAIN QUANTITIES USED TO GIVE THE COVARIANCES THE PROPER UNITS.
C
      LTEST=LSPHAR.AND.ITCOUN.LT.5.AND.LTESTS 
      IF (LTEST) THEN
      KI(35)=KI(35)+1 
      ITCOUN=ITCOUN+1
      END IF
      LSPHP=LF
      LSPHQ=LF
      T = CR(1)
      HP = CR(2)
      HQ = CR(3)
      SP = CR(4)
      SQ = CR(5)
      CP = CR(6)
      CQ = CR(7)
      SD = CR(8)
      CD = CR(9)
      RP = RE+HP
      RQ = RE+HQ
      RE2= RE**2
C
      KP=KI(6)
      KQ=KI(7)
C
C CHANGE 2003-03-22.
      LDGP=KP.EQ.3
      LDGQ=KQ.EQ.3 
      IF (KP.EQ.17.OR.KQ.EQ.17) THEN
C     WRITE(*,*)'10385 CX, KP,KQ,LSAT= ',KP,KQ,LSAT
C
      IF (KP.NE.17.AND.KQ.EQ.17) THEN
      LSPHQ=LT
      KPQ=KP
      CLAT=CP
      SLAT=SP
      SLON=SLOP
      CLON=CLOP
      RH=RE+HP
c     GAMM=CR(11)
      GAMM=CR(10)
      IF (ITCOUN.LT.4.AND.LF)
     *WRITE(*,*)' LSAT ',LSAT,' KPQ=KP= ',KPQ,GAMM
      CLAT=CP
      END IF
C
      IF (KQ.NE.17.AND.KP.EQ.17) THEN
      LSPHP=LT
      KPQ=KQ
      CLAT=CQ
      SLAT=SQ
      SLON=SLOQ
      CLON=CLOQ
      RH=RE+HQ
c     GAMM=CR(10)
      GAMM=CR(11)
c     IF (ITCOUN.LT.4.AND.LTEST)
      IF (ITCOUN.LT.4.AND.LF)
     * WRITE(*,*)' LSAT ',LSAT,' KPQ=KQ= ',KPQ,GAMM
      END IF
C
      SQ2=SQRT(D2)
      IMAX1=IIDEG+1
      I21=2*(IIDEG+1)
      IF (IIMAX.LT.I21) WRITE(*,*) ' IMAX TOO LARGE '
C
      DO 501 I=1, I21
       ROOT0(I)= SQRT(DFLOAT(I-1))
  501 CONTINUE
C
      ILAST=(IMAX1)**2+1
C    
      IF (KP.EQ.17.AND.KQ.EQ.17) THEN
C COV IS THE VARIANCE OF THE (I,J)'TH COEFFICIENT.
       COV=SIGMAP(IIDEG+1)
C      IF (LT.AND.(IIDEG.GT.5.AND.IIDEG.LT.33))
       IF (LTSPH.AND.(IIDEG.GT.25.AND.IIDEG.LT.33))
     * WRITE(*,*)' IIDEG+1, COV= ',IIDEG+1,COV
      ELSE
C
C SETTING ORDER OF DIFFERENTIATION. 
C     IF  (KPQ.GE.1.OR.KPQ.LE.5) THEN   **  ERRONEOUS  **
C ERROR DETECTED 2000-03-27 BY CCT.
       IF  (KPQ.GE.1.AND.KPQ.LE.5) THEN
        IF (LSAT) THEN
         IDIF=1
         IF (KPQ.EQ.5) IDIF=2
        ELSE
         IDIF=0
        END IF
       ELSE
C      IF  (KPQ.GE.6.OR.KPQ.LE.11) THEN   ** ERRONEOUS  **
C ERROR DETECTED 2000-03-27 BY CCT.
        IF  (KPQ.GE.6.AND.KPQ.LE.9) THEN
         IDIF=1
        ELSE
         IDIF=2
        END IF
       END IF
C
       CFA=D1
       IIOLD=-1
       JOLD=-1
       PIM0=D1
       CJLO=D1
       SJLO=D0
       JMAX1=ABS(JJORD)+1
       LCOS=JJORD.GE.0
C
C SEE REF(H) EQ. (6).
       DO 1002, J=1, JMAX1
        DO 1001, I=J, IMAX1
         CALL SPHARM(SLAT,CLAT,SJLO,CJLO,RH,I-1,J-1,IDIF,.TRUE.)
C
         IF (I.GT.8.AND.I.LT.13.AND.J.EQ.1.AND.LTSPH.AND.I.EQ.IMAX1) 
     *   THEN
         WRITE(*,*)'I, SIGMAP, YC, KPQ ',I, SIGMAP(I),YC,KPQ
        END IF
C       WRITE(*,*)' DDC/S11 ',DDC(1,1),DDS(1,1)
C
        WWC=SIGMAP(I)*YC
C UNITS OF M.
        IF (IDIF.GT.0) THEN
         GGC(1)=SIGMAP(I)*GC(1)/RE
         GGC(2)=SIGMAP(I)*GC(2)/RE
         GGC(3)=SIGMAP(I)*GC(3)/RE
          IF (.NOT.LSAT) THEN
           GGC(1)=-GGC(1)*RADSEC/GAMM
           GGC(2)=-GGC(2)*RADSEC/GAMM
C UNITS OF ARCSEC.
C GRAVITY DISTURBANCE:
           GGC(3)=-GGC(3)*1.0D5
C UNITS OF MGAL USED.
C GRAVITY ANOMALY MISSING !!
          END IF
          IF (IDIF.GT.1) THEN
           DO 990,KKC=1,3
           DO 990,KKD=1,3
  990      DDDC(KKC,KKD)=SIGMAP(I)*DDC(KKC,KKD)*1.0D9/RE2
C EU USED.
          END IF
C
         END IF
C    
         WWS=SIGMAP(I)*YS
         IF (IDIF.GT.0) THEN
          GGS(1)=SIGMAP(I)*GS(1)/RE
          GGS(2)=SIGMAP(I)*GS(2)/RE
          GGS(3)=SIGMAP(I)*GS(3)/RE
          IF (.NOT.LSAT) THEN
C GRAVITY ANOMALY MISSING !! (SEE BELOW AT LABEL 1013).
           GGS(1)=-GGS(1)*RADSEC/GAMM
           GGS(2)=-GGS(2)*RADSEC/GAMM
C UNITS OF ARCSEC.
           GGS(3)=GGS(3)*1.0D5
C UNITS OF MGAL USED.
          END IF
          IF (IDIF.GT.1) THEN
           DO 991,KKC=1,3
           DO 991,KKD=1,3
  991      DDDS(KKC,KKD)=SIGMAP(I)*DDS(KKC,KKD)*1.0D9/RE2
C          WRITE(*,*)' DDDC/S11 ',DDDC(1,1),DDDS(1,1)
C EU USED.
          END IF
C
         END IF
C
         IF (.NOT.LSAT) THEN
          GO TO (1011,1012,1013,1014,1015,1016,1017,1018,1019,1020
     *    ,1021,1024,1023,1022,1025),KPQ
C HEIGHT ANOMALY (M).
 1011     IF (ITCOUN.LT.5.AND.J.EQ.25.AND.I.EQ.25.AND.LTEST)
     *    WRITE(*,*)' 1011 ',WWC,WWS,GAMM
          COVC=WWC/GAMM
          COVS=WWS/GAMM
          GO TO 1126
C GRAVITY DISTURBANCE (MGAL).
 1012     COVC= WWC*I/RH*1.0D5 
          COVS= WWS*I/RH*1.0D5
          GO TO 1126
C GRAVITY ANOMALY (MGAL).
 1013     COVC= WWC*(I-2)/RH*1.0D5
          COVS= WWS*(I-2)/RH*1.0D5
C
          IF (I.GT.8.AND.I.LT.13.AND.J.EQ.JMAX1.AND.LTSPH
     *    .AND.I.EQ.IMAX1) THEN
           WRITE(*,1092) I,J,COVC,WW,YC
 1092      FORMAT(' I,J,COVC,WW,YC= ',2I3,3D14.6)
           LTSPH=LF
          END IF
C
          GO TO 1126
C RADIAL DER. OF GRAVITY ANOMALY (EU).
 1014     COVC=WWC*(I-2)*(I+1)/(RH*RH)*1.0D9
          COVS=WWS*(I-2)*(I+1)/(RH*RH)*1.0D9
          GO TO 1126
C VERTICAL GRAVITY GRADIENT.
 1015     COVC=WWC*I*(I+1)/(RH*RH)*1.0D9
          COVS=WWS*I*(I+1)/(RH*RH)*1.0D9
C
          IF (I.GT.8.AND.I.LT.13.AND.J.EQ.JMAX1.AND.LTSPH
     *    .AND.I.EQ.IMAX1) THEN
           WRITE(*,1091) I,I*(I+1),J,WW,COVC
 1091      FORMAT(' I,I*(I+1),J,WW,COVC= ',2I3,I4,2D14.6)
           LTSPH=LF
          END IF
C
          GO TO 1126
C DEFLECTION, MERIDIAN COMP.
 1016     COVC= GGC(2)
          COVS= GGS(2)
          IF (LTEST) THEN
           WRITE(*,*)' GGC,GGS1 ', COVC,COVS
           ITCOUN=ITCOUN+1
          END IF
          GO TO 1126
C DEFLECTION, PRIME VERTICAL COMP.
 1017     COVC= GGC(1)
          COVS= GGS(1)
          IF (LTEST) THEN
           WRITE(*,*)' GGC,GGS1 ', COVC,COVS
           ITCOUN=ITCOUN+1
          END IF
          GO TO 1126
C PRIME VERTICAL DER. OF GRAVITY ANOMALY
C ERROR HERE !!!!!
 1019     COVC=-GGC(2)*I/RH
          COVS=-GGS(2)*I/RH
          GO TO 1126
C MERIDIAN DER. OF GRAVITY ANOMALY
 1018     COVC=-GGC(1)*I/RH
          COVS=-GGS(1)*I/RH
          GO TO 1126
C MERIDIAN DER. OF GRAVITY DISTURBANCE. CORR. 2000-03-27 BY CCT.
 1020     COVC=-DDDC(3,2)
          COVS=-DDDS(3,2)
          GO TO 1126
C PRIME VERTICAL DER. OF GRAVITY DISTURBANCE.
 1021     COVC=-DDDC(3,1)
          COVS=-DDDS(3,1)
          GO TO 1126
C 2. ORDER PRIME VERTICAL DER.
 1022     COVC=DDDC(1,1)
          COVS=DDDS(1,1)
          GO TO 1126
C MIXED PRIME VERTICAL & MERIDIAN DER. * 2. (TORSION BALANCE).
 1023     COVC= DDDC(1,2)*D2
          COVS= DDDS(1,2)*D2
          GO TO 1126
C 2. ORDER MERIDIAN COMP.
 1024     COVC=DDDC(2,2)
          COVS=DDDS(2,2)
          GO TO 1126
C DIFFERENCE 2. ORDER HORIZONTAL DER. (TORSION BALANCE).
 1025     COVC=(DDDC(1,1)-DDDC(2,2))
          COVS=(DDDS(1,1)-DDDS(2,2))
C
 1126     CONTINUE
          IF (LCOS) THEN
           COVX(1,1,1,1)=COVC
           COV=COVC
          ELSE
           COVX(1,1,1,1)=COVS
           COV=COVS
          END IF
C
         ELSE
          IF (LCOS) THEN
           WW=WWC
           DO 1875,IKK=1,3
            GG(IKK)=GGC(IKK)*1.0D5
            DO 1876,JKK=1,3
             DDD(IKK,JKK)=DDDC(IKK,JKK)
 1876       CONTINUE
 1875      CONTINUE
          ELSE
           WW=WWS
           DO 1877,IKK=1,3
            GG(IKK)=GGS(IKK)*1.0D5
            DO 1878,JKK=1,3
             DDD(IKK,JKK)=DDDS(IKK,JKK)
 1878       CONTINUE
 1877      CONTINUE
          END IF
C
          NCASE=NDP+1+NDQ*3
C         WRITE(*,*)NDP,NDQ,NCASE
          GO TO (1801,1802,1803,1804,1810,1810,1807,
     *    1810,1810),NCASE
C NO DERIVATIVES IN P OR Q.
1801      COVX(1,1,1,1)=WW/GAMM 
          GO TO 1810
C 1 DERIVATIVE IN P, NONE IN Q.
1802      COVX(1,1,1,1)=GG(1)          
          COVX(2,1,1,1)=GG(2)
          COVX(3,1,1,1)=GG(3)
C GRAVITY ANOMALY WITH GEOID. ADDED 1992.09.07.
       IF (LDGP) COVX(3,1,1,1)=GG(3)-1.0D5*D2*WW/RP
C ERROR DETECTED 2003-07-24.
C      IF (LDGP) COVX(3,1,1,1)=GG(3)-D2*WW/RP
       GO TO 1810
C 2 DERIVATIVES IN P, NONE IN Q.
1803   COVX(1,1,1,1)= DDD(1,1)
       COVX(2,1,1,1)= DDD(2,1)
       COVX(1,2,1,1)=COVX(2,1,1,1)
       COVX(3,1,1,1)= DDD(3,1)
       COVX(1,3,1,1)=COVX(3,1,1,1)
       COVX(2,2,1,1)=DDD(2,2)
      COVX(2,3,1,1)= DDD(2,3)
      COVX(3,2,1,1)=COVX(2,3,1,1)
      COVX(3,3,1,1)= DDD(3,3)
       GO TO 1810
C NO DERIVATIVE IN P, 1 IN Q.
 1804  COVX(1,1,1,1)=GG(1)
       COVX(1,1,2,1)=GG(2)
      COVX(1,1,3,1)=GG(3)
C GRAVITY ANOMALY WITH GEOID. ADDED 1999.09.07, CORR 000.04.28.  
      IF (LDGQ) COVX(1,1,3,1)=GG(3)-1.0D5*D2*WW/RQ
C ERROR DETECTED 2003-07-24.
       GO TO 1810
C NO DERIVATIVE IN P, TWO IN Q.
 1807  COVX(1,1,1,1)= DDD(1,1)
      COVX(1,1,2,1)= DDD(2,1)
      COVX(1,1,1,2)=COVX(1,1,2,1)
      COVX(1,1,3,1)= DDD(3,1)
      COVX(1,1,1,3)=COVX(1,1,3,1)
      COVX(1,1,2,2)= DDD(2,2)
      COVX(1,1,3,2)= DDD(3,2)
      COVX(1,1,2,3)=COVX(1,1,3,2)
      COVX(1,1,3,3)= DDD(3,3)
C
 1810  CONTINUE
       COV=COVX(KSAT(KP,1),KSAT(KP,2),KSAT(KQ,1),KSAT(KQ,2))
       IF (LTEST.AND.ITCOUN.LT.200) THEN
        WRITE(*,*)' KSAT ',KSAT(KP,1),KSAT(KP,2),KSAT(KQ,1),
     *  KSAT(KQ,2),' COV ',COV,'NDP,NDQ ',NDP,NDQ,' IDIF ',IDIF
       END IF
       ITCOUN=ITCOUN+1
C
C THIS PERMITS TEST OF LSAT PREDICTION OF COEFFICIENTS FOR
C LGRID = F. 2000-04-17.
       IF (J.EQ.1) THEN
        IF (IDIF.EQ.0) THEN
         COVC=WWC
        ELSE
        IF (IDIF.EQ.1) THEN
         COVC=GGC(KSAT(KQ,1))*1.0D5
        ELSE
         COVC=DDDC(KSAT(KQ,1),KSAT(KQ,2))
        END IF
       END IF
C
      ELSE
      IF (IDIF.EQ.0) THEN
      COVC=WWC
      COVS=WWS
      ELSE
      IF (IDIF.EQ.1) THEN
      COVC=GGC(KSAT(KQ,1))*1.0D5
      COVS=GGS(KSAT(KQ,1))*1.0D5
      ELSE
      COVC=DDDC(KSAT(KQ,1),KSAT(KQ,2))
      COVS=DDDS(KSAT(KQ,1),KSAT(KQ,2))
      END IF
      END IF
      END IF
C
      END IF
C
      IF (J.EQ.1) THEN
       CCCIJ((I-1)**2+1)=COVC
      ELSE
       CCCIJ((I-1)**2+2*(J-1)+1)=COVS
       CCCIJ((I-1)**2+2*(J-1))=COVC
      END IF
 1001 IF (SIGMAP(I).GT.1.0D-10.AND.LTEST.AND.ITCOUN.LT.10)
     *WRITE(*,511)I,J,COVC,COVC/SIGMAP(I),CLAT,CJLO,KP,KQ,IDIF
  511 FORMAT(' I,J,COVC,LLY,CLAT,CJLO,KP,KQ= ',2I3,2D15.5,2F6.3,3I3)
C FOR EACH ORDER OF DIFFERENTIATION A DIFFERENT STORAGE !
C
      SJL1=SJLO
      SJLO=SJLO*CLON+CJLO*SLON
      CJLO=CJLO*CLON-SJL1*SLON 
 1002 CONTINUE
C
      END IF
C
C CHANGE HERE TO TAKE CARE OF KSI, ETA 2000-05-02
      GO TO (2011,2011,2011,2011,2011,2016,2016,2018,2018,2020
     *,2020,2022,2024,2022,2024),KPQ
C EV, DERIVATIVES  Z, DGZ, ZZ.
 2011 IF (LCOS) THEN
      CV(1,1)=COVC
      ELSE
      CV(1,1)=COVS  
      END IF
      GO TO 2026
C
C KSI, ETA.
 2016 IF (LCOS) THEN
      CV(1,1)=GGC(1)
      IF (LSPHP) THEN
      CV(1,2)=GGC(2)
      ELSE
      CV(2,1)=GGC(2)
      END IF
      ELSE
      CV(1,1)=GGS(1)
      IF (LSPHP) THEN
      CV(1,2)=GGS(2)
      ELSE
      CV(2,1)=GGS(2)
      END IF
      END IF
      GO TO 2026
C
C DELTAG, X, Y.
 2018 IF (LCOS) THEN
      CV(1,1)=-GGC(1)*I/RH
      IF (LSPHP) THEN
      CV(1,2)=-GGC(2)*I/RH
      ELSE
      CV(2,1)=-GGC(2)*I/RH
      END IF
      ELSE
      CV(1,1)=-GGS(1)*I/RH
      IF (LSPHP) THEN
      CV(1,2)=-GGS(2)*I/RH
      ELSE
      CV(2,1)=-GGS(2)*I/RH
      END IF
      END IF
      GO TO 2026
C
C XZ AND YZ.
 2020 IF (LCOS) THEN
      CV(1,1)=-DDDC(3,1)
      IF (LSPHP) THEN
      CV(1,2)=-DDDC(3,2)
      ELSE
      CV(2,1)=-DDDC(3,2)
      END IF
      ELSE
      CV(1,1)=-DDDS(3,1)
      IF (LSPHP) THEN
      CV(1,2)=-DDDS(3,2)
      ELSE
      CV(2,1)=-DDDS(3,2)
      END IF
      END IF
      GO TO 2026
C
C XX AND YY
 2022 IF (LCOS) THEN
      CV(1,1)=DDDC(1,1)
      IF (LSPHP) THEN
      CV(1,2)=DDDC(2,2)
      ELSE
      CV(2,1)=DDDC(2,2)
      END IF
      ELSE
      CV(1,1)=DDDS(1,1)
      IF (LSPHP) THEN
      CV(1,2)=DDDS(2,2)
      ELSE
      CV(2,1)=DDDS(2,2)
      END IF
      END IF
      GO TO 2026
C
C 2*XY AND YY-XX.
 2024 IF (LCOS) THEN
       CV(1,1)=DDDC(2,1)*D2
       IF (LSPHP) THEN
        CV(1,2)=DDDC(2,2)-DDDC(1,1)
       ELSE
        CV(2,1)=DDDC(2,2)-DDDC(1,1)
       END IF
      ELSE
       CV(1,1)=DDDS(2,1)*D2
       IF (LSPHP) THEN
        CV(1,2)=DDDS(2,2)-DDDS(1,1)
       ELSE
        CV(2,1)=DDDS(2,2)-DDDS(1,1)
       END IF
      END IF
C
 2026 ITCOUN=ITCOUN+1
      RETURN
      END IF
C
C IN HEIGH ALTITUDES AND WHEN LSUM IS TRUE WILL THE COVARIANCE BE COM-
C PUTED BY A SUMMATION OF THE LEGENDRE-SERIES ABBREVIATED TO DEGREE
C N2-1.
      LSUMC = LSUM .AND. (HP.GT.HMAX .OR. HQ.GT.HMAX)
C COMPUTATION OF THE CONSTANT USED TO CONVERT THE COVARIANCE INTO
C PROPER UNITS.
      CI(12) = CI(11)/(RP**KI(22)*RQ**KI(23)
     **CR(11)**KI(21)*CR(10)**KI(20))
C
      S = RB2/(RP*RQ)
C     IF(CI(10).LT.D0) S=D1-(RE*(HP+HQ+D2*(RE-CI(10)))+HP*HQ
C    *- (RE-CI(10))**2)/(RP*RQ)
      LOLDP = (KI(6).EQ.12) .OR. (KI(6).EQ.14) .OR. LSAT
      LOLDQ = (KI(7).EQ.12) .OR. (KI(7).EQ.14) .OR. LSAT 
      IF (LSUMC) N1 = N3
C
C COMPUTATION OF THE QUANTITIES D(1)-D(36),CF.REF(A),SECTION 3.
C (MODIFIED ACCORDING TO REF.(C)).
C     IF (.TRUE.)WRITE(*,*)' COVCX ND=',ND
      DO I=1,36
       D(I)=D0
      END DO
      IF (ND.EQ.0) GO TO 55
C
      D(1) = D1
      CS = CP*SQ
      SC = SP*CQ
      SCC = SC*CD
      CC = CP*CQ
      CCS = CC*SD
      CSC = CS*CD
      IF (CI(20).GT.0.5) GO TO 201
C CF. REF.(D), EQ. (7) AND (8).
C ERROR 2002-10-06. CHANGE OF SIGN ON CI(17)*CI(19).
      D(2)= D2*(CI(17)*CI(19)+SP*CQ*CI(16))
      D(7)= D2*(-CI(17)*CI(19)+SQ*CP*CI(16))
      IF (ABS(D(2)-CS+SCC).GT.1.0D-6 .OR.
     * ABS(D(7)-SC+CSC).GT.1.0D-6) THEN
       WRITE(*,*)
     *' WARNING D(2) ',D(2),(CS-SCC)
       WRITE(*,*)
     *' WARNING D(7) ',D(7),(SC-CSC)
       WRITE(*,*)CI(16),CI(17),CI(19)
      END IF
      GO TO 202
 201  D(2) = CS-SCC
      D(7) = SC-CSC
 202  CPSD = CP*SD
      CPCD = CP*CD
      CQSD = CQ*SD
      CQCD = CQ*CD
      D(3) = CQSD
      D(13)=-CPSD
C
      IF (ND.EQ.1) GO TO 55
      SS = SP*SQ
      D(8) = CC+SS*CD
C CF. REF.(D). EQ.(9).
      IF(CI(20).LT.0.5) THEN
       D(8)=CI(18)-D2*SP*SQ*CI(16)
       IF (ABS(D(8)-(CC+SS*CD)).GT.1.0D-6) THEN
        WRITE(*,*)' D(8) ',D(8),(CC+SS*CD)
        D(8)=-D(8)
       END IF
      END IF
      D(9) = -SQ*SD
      D(14)= SP*SD
      D(15)= CD
      IF (LOLDP) GO TO 91
      D(4) = D(2)+D(3)
      D(6) = D(3)-D(2)
      GO TO 92
   91 D(4) = -T
      D(6) = -CQCD/CP
   92 IF (LOLDQ) GO TO 93
      D(19)= D(13)+D(7)
      D(31)= D(13)-D(7)
      GO TO 94
   93 D(19)= -T
      D(31)= -CPCD/CQ
C
   94 IF (ND.EQ.2) GO TO 55
      IF (LOLDP) GO TO 95
      D(10) = D(9)+D(8)
      D(12) = D(9)-D(8)
      D(16) = D(15)+D(14)
      D(18) = D(15)-D(14)
      GO TO 96
   95 D(10) = -D(7)
      D(12) = SQ*CD/CP
      D(16) = CPSD
      D(18) = SD/CP
   96 IF (LOLDQ) GO TO 97
      D(20) = D(14)+D(8)
      D(32) = D(14)-D(8)
      D(21) = D(15)+D(9)
      D(33) = D(15)-D(9)
      GO TO 98
   97 D(20) = -D(2)
      D(21) = -CQSD
      D(32) = SP*CD/CQ
      D(33) = -SD/CQ
C
   98 IF (ND.EQ.3) GO TO 55
      IF (.NOT.(LOLDP.AND.LOLDQ)) GO TO 99
      D(22) = T
      D(24) = CQCD/CP
      D(34) = CPCD/CQ
      D(36) = CD/CC
      GO TO 55
   99 IF (.NOT.LOLDQ) GO TO 100
      D(22) = D(21)+D(20)
      D(24) = D(21)-D(20)
      D(34) = D(33)+D(32)
      D(36) = D(33)-D(32)
      GO TO 55
  100 D(22) = D(16)+D(10)
      D(34) = D(16)-D(10)
      D(24) = D(18)+D(12)
      D(36) = D(18)-D(12)
   55 CONTINUE
      IF (.FALSE.) WRITE(*,1555)(D1-T),CI(20),CI(17),CR(8)
 1555 FORMAT(' T1,CI20,17,CR8',4D14.5)
C
      IF (LTABH) CALL TABH(C,LTA)
      IF (LTA.AND.LTABH) GO TO 204
      S2 = S*S
      ST = S*T
      T2 = T*T
      P2 = (D3*T2-D1)/D2
      P3 = (D3*ST+D1)/D2
C
C INITIALIZING ARRAY ELEMENTS. NOTE THE USE OF THE EQUIVALENCING.
      DO 50  K = 1, 8
      DO 50 M = 1, ND2
   50 CX(M,K) = D0
      DO 51 K = 1, ND2
      C(K) = D0
   51 DC(K) = D0
      DO 52 K = 1, 40
   52 CR(K+11) = D0
      Q(1)=D0
      RM(1)=D0
C
      IF (.NOT.LSAT) THEN
C
C SUMMATION AND DIFFERENTIATION OF THE LEGENDRE SERIES, CF.REF(A),EQ.
C (49) AND (51).
      IF (LSUMC) N1 = N2
      K1 = N1
      K2 = N1+1
      K = N1-1
      DO 54 M = 1, N1
      GI = (D2*K+D1)*S/K1
      GJ = -K1*S2/K2
      K2 = K1
      K1 = K
      K = K-1
      IF (.NOT.LSUMC) SI = SIGMA(IS+K2)
      IF (LSUMC) SI = SM(K2)
      I2 = 0
      I1 = 1
      DO 53 I = 2, ND2
      B = DC(I)
      DC(I) = C(I)
      C(I) = GI*(DC(I)*T+I2*DC(I1))+GJ*B+SI
      SI = D0
      I2 = I1
   53 I1 = I
   54 CONTINUE
      IF (LSUMC) N1 = N3
C
C     IF (LSUMC) GO TO 75
      ELSE
       KP=KI(6)
       KQ=KI(7)
       LDGP=KP.EQ.3
       LDGQ=KQ.EQ.3 
C 
C INITIALIZING ARRAY ELEMENTS. NOTE THE USE OF THE EQUIVALENCING.
       DO 150  K = 1, 8
       DO 150 M = 1, 6
  150  CX(M,K) = D0
       NDTOT=NDP+NDQ+1
       DO 151 K = 1, 8
       DO 151 NDT=1,NDTOT 
        CN(K,NDT) = D0
  151  DCN(K,NDT) = D0
C
C SUMMATION AND DIFFERENTIATION OF THE LEGENDRE SERIES, CF.REF(A),EQ.
C (49) AND (51).
       K1 = N1
       K2 = N1+1
       K = N1-1
       DO 154 M = 1, N1
        GI = (D2*K+D1)*S/K1
        GJ = -K1*S2/K2
        K2 = K1
        K1 = K
        K = K-1
        DO 154 NDT=1,5
         SI = SIGMAX(K2,NDT)
         I2 = 0
         I1 = 1
         DO 153 I = 2, NDX2(NDT)
          B = DCN(I,NDT)
          DCN(I,NDT) = CN(I,NDT)
          CN(I,NDT) = GI*(DCN(I,NDT)*T+I2*DCN(I1,NDT))+GJ*B+SI
          SI = D0
          I2 = I1
  153    I1 = I
  154   CONTINUE
C
       END IF
       IF (LSUMC) GO TO 75 
C COMPUTATION OF THE FUNCTIONS L=R(1), N=1/RN, M=RM(2), F0=P(2), CF.
C REF.(A), EQ. (31)-(33),(40) AND (77A).
       RL2 = D1-D2*ST+S2
       RL =  SQRT(RL2)
       R(1) = RL
       RL1 = D1/RL
       RN = D1/(D1+RL-ST)
       RL2 = D1/RL2
       RNL = RN*RL1
       RM(2) = D1-RL-ST
       P(2) = S*LOG(D2*RN)
C CHANGE 2008-05-05.
C      P(2) = S*LOG(D2*RN)
       RL3 = RL2*RL1
       RL5 = RL3*RL2
       S3 = S2*S
       R(2) = -S*RL1
       IF (ND.EQ.0) GO TO 56
C
C COMPUTATION OF THE DERIVATIVES WITH RESPECT TO T.
C CF. REF.(A), EQ. (77B),(69A),(57).
       R(3) = -S2*RL3
       RM(3) = -R(2)-S
       P(3) = S2*(RNL+RN)
       IF (ND.EQ.1) GO TO 56
C
C CF. REF.(A), EQ. (77C),(69B),(58).
       R(4) = -D3*S3*RL5
       RM(4) = -R(3)
       P(4) = S3*(RL3+(D1+(D2+RL1)*RL1)*RN)*RN
       IF (ND.EQ.2) GO TO 56
C
C CF. REF.(A), EQ. (77D),(69C),(59).
       RL4 = RL2*RL2
       RL7 = RL5*RL2
       S4 = S2*S2
       R(5) = -15.0E0*S4*RL7
       RM(5) = -R(4)
       P(5) = S4*(D3*RL5+((D3+D3*RL1)*RL3+D2*(D1+(D3+(D3+RL1)*RL1)*RL1)
     * *RN)*RN)*RN
       IF (ND.EQ.3) GO TO 56
C
C CF. REF.(A), EQ. (69D),(60).
       S5 = S4*S
       RL6 = RL4*RL2
       RM(6) = -R(5)
       P(6) = D3*S5*((D5*RL7+((D4+D5*RL1)*RL5+((D4+(8.0E0
     * +D4*RL1)*RL1)*RL3+(D2+(8.0E0+(12.0E0+(8.0E0+D2*RL1)*RL1)
     * *RL1)*RL1)*RN)*RN)*RN)*RN)
C
   56  IF (LN(2)) GO TO 58
C COMPUTATION OF THE FUNCTION F-1 AND ITS DERIVATIVES, CF. REF.(A),
C EQ. (41) AND (61) - (65).
       U(2) = S*(RM(2)+T*P(2))
       IF (ND2.LT.3) GO TO 58
       DO 57 K = 3, ND2
   57  U(K) = S*(RM(K)+T*P(K)+(K-2)*P(K-1))
C
   58  IF (LN(1)) GO TO 60
C COMPUTATION OF THE FUNCTION F-2 AND ITS DERIVATIVES, CF. REF.(A) EQ.
C (42), AND (65)- (68).
       DO 59 K = 2, ND2
        GO TO (61,61,62,63,64,65),K
   61   CY = S*(D1-T2)/4.0E0
        GO TO 59
   62   CY = -ST/D2
        GO TO 59
   63   CY = D3*P(2)-S/D2
        GO TO 59
   64   CY = 9.0E0*P(3)
        GO TO 59
   65   CY = 18.0E0*P(4)
   59  V(K) = S*(RM(K)*P3+S*((K-2)*D3*RM(K-1)/D2+P2*P(K)+D3*T*P(K-1)*
     * (K-2)+CY))
C
   60  IF (LN(3)) GO TO 73
C COMPUTATION OF THE FUNCTION F1 AND ITS DERIVATIVES, CF. REF.(A) EQ.
C (36), REF.(B), EQ.(101) AND REF.(A), EQ.(70),(71).
       Q(2) = LOG(D1+D2*S/(D1-S+RL))
       IF (ND.EQ.0) GO TO 66
       Q(3) = S2*RNL
       IF (ND.EQ.1) GO TO 66
       Q(4) = S3*((RL1+D1)*RN+RL2)*RNL
       IF (ND.EQ.2) GO TO 66
       Q(5) = S4*(D3*RL4+((D2+D3*RL1)*RL2+(D2 +(D4+D2*RL1)*RL1)*RN)
     * *RN)*RNL
       IF (ND.EQ.3) GO TO 66
       Q(6) = D3*S5*(D5*RL6+((D3+D5*RL1)*RL4+((D2+(6.0E0+D4*RL1)
     * *RL1)*RL2+(D2+(6.0E0+(6.0E0+D2*RL1)*RL1)*RL1)*RN)*RN)*RN)*RNL
C
C COMPUTATION OF THE FUNCTION F2 AND ITS DERIVATIVES, CF. REF.(A), EQ.
C (3),(72)-(75).
   66  P(2) = (RL-D1+T*Q(2))/S
       IF (ND.EQ.0) GO TO 68
       DO 67  K = 3, ND2
   67  P(K) = (R(K-1)+T*Q(K)+(K-2)*Q(K-1))/S
   68  I1 = II-1
       K1 = 1
       J1 = I1
       IF (I1.GE.2) GO TO 149
       DO 49 M = 2, ND2
        IF (I1.EQ.0) G(M) = Q(M)
        IF (I1.EQ.1) G(M) = P(M)
   49  CONTINUE
  149  IF (L(4)) J1 = JJ-1
       IF (J1.LE.1) GO TO 73
C
C CF. REF.(A), EQ. (38),(76).
       DO 71  K = 2, J1
        DO 69  M = 2, ND2
         B = Q(M)
         Q(M) = P(M)
   69   P(M) = (R(M-1)+(2*K-1)*((M-2)*Q(M-1)+T*Q(M))-K1/S*B)/(K*S)
        IF (K.NE.I1) GO TO 71
        DO 70 M = 2, ND2
   70   G(M) = P(M)
   71  K1 = K
C
   73  IF (LN(6)) GO TO 72
C CF. REF.(A), EQ. (34),(55).
       SS1(2) = S2*(T-S)*RL3
       IF (ND.GT.0) SS1(3) = S2*(RL3+D3*(T-S)*S*RL5)
C
C CF. REF.(A), EQ. (35).
   72  IF (L(7)) SS2= S2*((T+S)*RL3+D3*S*(T2-D1)*RL5)
C
   75  IF (.NOT.LSAT) THEN
C ADDING THE DIFFERENT TERMS, CF. REF.(A), EQ. (22),(47).
C TIPLIED BY RB**2 IN UNITS OF MGAL**2, THE INTEGERS K(2),K(3) OF EQ.
      DO 79 M = 2, ND2
C CF. REF.(A), EQ. (50),(52).
      C(M) = S*C(M)
      IF (LTEST)WRITE(*,*)' CM',C(M),M
      CR(M*8 -4) = C(M)
      DO 78 K = 1, 7
      IF (LN(K)) GO TO 78
C STORING THE TERMS FOR TRANSFER TO THE CALLING PROGRAM USING THE COMMON
C AREA /CMCOV/.
      CR(M*8+K -4) = A*CX(M,K+1)*CI(K)
      IF (K.EQ.5) CR(M*8+K-4) = -CR(M*8+K-4)
      C(M) = C(M)+CR(M*8+K -4)
      IF (LTEST)WRITE(*,1)CX(M,K+1),CI(K),C(M),K
    1 FORMAT(' CX,CI,C,K,NDT ',3E15.7,3I2)
   78 CONTINUE
   79 CR(M+50)=C(M)
C
      ELSE
C 
C FOR THIS SECTION SEE REF.(I) FOR ALL EQUATIONS.
       RP2=RP*RP
       RQ2=RQ*RQ
       RPQ=RQ*RP
       DO 178 NDT=1,5
       DO 178 M = 2, NDX2(NDT)
        CN(M,NDT)=CN(M,NDT)*S
        IF (LTEST)WRITE(*,*)' CM',CN(M,NDT),M,NDT,S,LSAT
        DO 179 K = 1, 7
         IF (LNX(K,NDT))GO TO 179
         FAK5=D1
         IF (K.EQ.5) FAK5=-D1             
         CN(M,NDT)=CN(M,NDT)+A*CX(M,K+1)*CIX(K,NDT)*FAK5
         IF (LTEST)WRITE(*,1)CX(M,K+1),CIX(K,NDT),CN(M,NDT),K,NDT
  179   CONTINUE
        CN(M-1,NDT)=CN(M,NDT)*(-1)**(NDT+1)
  178  CONTINUE 
       IF (LTEST)WRITE(*,*)' NDP,NDQ,KP,KQ=',NDP,NDQ,KP,KQ
C
C WE NOW CALCULATE THE CROSS-COVARIANCES BETWEEN ALL QUANTI-
C TIES OF THE GIVEN ORDERS.
       NCASE=NDP+1+NDQ*3
       GO TO (801,802,803,804,805,806,807,808,809),NCASE
C NO DERIVATIVES IN P OR Q.  CHANGED 2005-02-18, SO THAT
C HEIGHT ANOMALIES CAN BE USED.
 801  COVX(1,1,1,1)=CN(1,1)/(CR(10)*CR(11))
      GO TO 810
C 1 DERIVATIVE IN P, NONE IN Q. REF(I), EQ. (16) AND (17).
 802  COVX(1,1,1,1)=D(3)*CN(2,1)/RP
      COVX(2,1,1,1)=D(2)*CN(2,1)/RP
      COVX(3,1,1,1)=CN(1,2)/RP
C GRAVITY ANOMALY WITH GEOID. ADDED 1992.09.07.  
      IF (LDGP) COVX(3,1,1,1)=(-CN(1,2)-D2*CN(1,1))/RP
      GO TO 810
C 2 DERIVATIVES IN P, NONE IN Q. REF(I), EQ. (24)-(28).
 803  COVX(1,1,1,1)=(D(3)*D(3)*CN(3,1)+CN(1,2)-T*CN(2,1))/RP2
      COVX(2,1,1,1)=D(2)*D(3)*CN(3,1)/RP2
      COVX(1,2,1,1)=COVX(2,1,1,1)
      COVX(3,1,1,1)=D(3)*(CN(2,2)-CN(2,1))/RP2
      COVX(1,3,1,1)=COVX(3,1,1,1)
      COVX(2,2,1,1)=(D(2)*D(2)*CN(3,1)-T*CN(2,1)+CN(1,2))/RP2
      COVX(2,3,1,1)=(D(2)*(CN(2,2)-CN(2,1)))/RP2
      COVX(3,2,1,1)=COVX(2,3,1,1)
      COVX(3,3,1,1)=CN(1,3)/RP2
      GO TO 810
C NO DERIVATIVE IN P, 1 IN Q. REF(I), EQ. (18), (19).
  804 COVX(1,1,1,1)=D(13)*CN(2,1)/RQ
      COVX(1,1,2,1)=D(7)*CN(2,1)/RQ
      COVX(1,1,3,1)=CN(1,2)/RQ
C GRAVITY ANOMALY WITH GEOID. ADDED 1992.09.07.  
      IF (LDGQ) COVX(3,1,1,1)=(-CN(1,2)-D2*CN(1,1))/RQ
      GO TO 810
C 1 DERIVATIVE IN BOTH P AND Q. REF(I), EQ. (20)-(23).
  805 COVX(1,1,1,1)=(D(3)*D(13)*CN(3,1)+D(15)*CN(2,1))/RPQ
      COVX(2,1,1,1)=(D(2)*D(13)*CN(3,1)+D(14)*CN(2,1))/RPQ
      COVX(3,1,1,1)=D(13)*CN(2,2)/RPQ
      COVX(1,1,2,1)=(D(3)*D(7)*CN(3,1)+D(9)*CN(2,1))/RPQ
      COVX(2,1,2,1)=(D(2)*D(7)*CN(3,1)+D(8)*CN(2,1))/RPQ
      COVX(3,1,2,1)=D(7)*CN(2,2)/RPQ
      COVX(1,1,3,1)=D(3)*CN(2,2)/RPQ
      COVX(2,1,3,1)=D(2)*CN(2,2)/RPQ
      COVX(3,1,3,1)=CN(1,3)/RPQ
C GRAVITY ANOMALY WITH GRAVITY VECTOR AND GRAVITY. ADDED 1992.09.30. 
      IF (LDGP.AND.(.NOT.LDGQ)) THEN 
      COVX(3,1,1,1)=D(13)*(-CN(2,2)-D2*CN(2,1))/RPQ
      COVX(3,1,2,1)=D(7)*(-CN(2,2)-D2*CN(2,1))/RPQ
      COVX(3,1,3,1)=(-CN(1,3)-D2*CN(1,2))/RPQ
      END IF 
      IF ((.NOT.LDGP.AND.LDGQ)) THEN
      COVX(1,1,3,1)=D(3)*(-CN(2,2)-D2*CN(2,1))/RPQ
      COVX(2,1,3,1)=D(2)*(-CN(2,2)-D2*CN(2,1))/RPQ
      COVX(3,1,3,1)=(-CN(1,3)-D2*CN(1,2))/RPQ
      END IF 
      IF (LDGP.AND.LDGQ)
     *COVX(3,1,3,1)=(CN(1,3)+D4*(CN(1,2)+CN(1,1)))/RPQ
      GO TO 810
C 2 DERIVATIVES IN P, ONE IN Q. REF(I), EQ. (29)-(33).
  806 RP2Q=RP2*RQ
      CNX=CN(2,2)-T*CN(3,1)+D(3)*D(3)*CN(4,1)-CN(2,1)
      COVX(1,1,1,1)=(D(13)*CNX+D2*DD(3,3)*D(3)*CN(3,1))/RP2Q
      COVX(1,1,2,1)=(D(7)*CNX+D2*DD(3,2)*D(3)*CN(3,1))/RP2Q
      COVX(1,1,3,1)=(CN(1,3)+CN(1,2)+D(3)*D(3)*CN(3,2)-T*CN(2,2))/RP2Q
C     COVX(2,1,1,1)=(D(2)*D(3)*D(13)*CN(4,1)+D(17)*CN(2,1)
C    *     +(D(2)*D(15)+D(3)*D(14)+D(13)*D(7))*CN(3,1))/RP2Q
      COVX(2,1,1,1)=(D(2)*D(3)*D(13)*CN(4,1)
     *     +(D(2)*D(15)+D(3)*D(14))*CN(3,1))/RP2Q
C POSSIBLE ERROR 2002-10-29
      COVX(2,1,2,1)=(DD(2,2)*DD(3,1)*CN(3,1)+DD(2,1)*(DD(3,2)*CN(3,1)
     *     +DD(1,2)*DD(3,1)*CN(4,1)))/RP2Q
      COVX(2,1,3,1)=D(2)*D(3)*CN(3,2)/RP2Q
      COVX(3,1,1,1)=(DD(1,3)*DD(3,1)*(CN(3,2)-CN(3,1))+DD(3,3)
     *     *(CN(2,2)-CN(2,1)))/RP2Q
      COVX(3,1,2,1)=(DD(1,2)*DD(3,1)*(CN(3,2)-CN(3,1))+DD(3,2)
     *     *(CN(2,2)-CN(1,2)))/RP2Q
      COVX(3,1,3,1)=DD(3,1)*CN(2,3)/RP2Q
C     COVX(3,1,3,1)=DD(1,3)*CN(2,3)/RP2Q
      COVX(1,2,1,1)=COVX(2,1,1,1)
      COVX(1,2,2,1)=COVX(2,1,2,1)
      COVX(1,2,3,1)=COVX(2,1,3,1)
      CNX=CN(2,2)-T*CN(3,1)+D(2)*D(2)*CN(4,1)-CN(2,1)
      COVX(2,2,1,1)=(DD(1,3)*CNX+D2*D(2)*DD(2,3)*CN(3,1))/RP2Q
      COVX(2,2,2,1)=(DD(1,2)*CNX+D2*D(2)*DD(2,2)*CN(3,1))/RP2Q
      COVX(2,2,3,1)=(CN(1,3)+CN(1,2)+D(2)*D(2)*CN(3,2)-T*CN(2,2))/RP2Q
      CNX=DD(2,1)*(CN(3,2)-CN(3,1))
      COVX(2,3,1,1)=(DD(1,3)*CNX+DD(2,3)*(CN(2,2)-CN(2,1)))/RP2Q
      COVX(2,3,2,1)=(DD(1,2)*CNX+DD(2,2)*(CN(2,2)-CN(2,1)))/RP2Q
      COVX(2,3,3,1)=DD(2,1)*CN(2,3)/RP2Q
      COVX(1,3,1,1)=COVX(3,1,1,1)
      COVX(1,3,2,1)=COVX(3,1,2,1)
      COVX(1,3,3,1)=COVX(3,1,3,1)
      COVX(3,2,1,1)=COVX(2,3,1,1)
      COVX(3,2,2,1)=COVX(2,3,2,1)
      COVX(3,2,3,1)=COVX(2,3,3,1)
      COVX(3,3,1,1)=DD(1,3)*CN(2,3)/RP2Q
      COVX(3,3,2,1)=DD(1,2)*CN(2,3)/RP2Q
      COVX(3,3,3,1)=CN(1,4)/RP2Q
C GRAVITY ANOMALY ADDED 1992.09.30. 
      IF (LDGQ) THEN 
      COVX(1,1,3,1)=-(CN(1,3)+D3*CN(1,2)+D(3)*D(3)*(CN(3,2)+D2*CN(3,1))
     *-T*(CN(2,2)+D2*CN(2,1)))/RP2Q
      COVX(2,1,3,1)=-D(2)*D(3)*(CN(3,2)+D2*CN(3,1))/RP2Q
      COVX(3,1,3,1)=-DD(3,1)*(CN(2,3)+D2*CN(2,2))/RP2Q
C     COVX(3,1,3,1)=-DD(1,3)*(CN(2,3)+D2*CN(2,2))/RP2Q
      IF (LTEST) WRITE(*,*)' COVX(3,1,3,1)= ',COVX(3,1,3,1)
      COVX(1,2,3,1)=COVX(2,1,3,1)
      COVX(2,2,3,1)=-(CN(1,3)+D3*CN(1,2)+D(2)*D(2)*(CN(3,2)+D2*CN(3,1))
     *-T*(CN(2,2)+D2*CN(2,1)))/RP2Q
      COVX(2,3,3,1)=-DD(2,1)*(CN(2,3)+D2*CN(2,2))/RP2Q
      COVX(1,3,3,1)=COVX(3,1,3,1)
      COVX(3,2,3,1)=COVX(2,3,3,1)
      COVX(3,3,3,1)=-(CN(1,4)+D2*CN(1,3))/RP2Q
      END IF 
      GO TO 810
C NO DERIVATIVE IN P, TWO IN Q. REF(I), EQ. (24)-(28).
  807 COVX(1,1,1,1)=(CN(1,2)+D(13)*D(13)*CN(3,1)-T*CN(2,1))/RQ2 
      COVX(1,1,2,1)=D(13)*D(7)*CN(3,1)/RQ2
      COVX(1,1,1,2)=COVX(1,1,2,1)
      COVX(1,1,3,1)=(D(13)*(CN(2,2)-CN(2,1)))/RQ2
C ERROR 2002-11-26.
C     COVX(1,1,3,1)=(D(3)*(CN(2,2)-CN(2,1)))/RQ2
      COVX(1,1,1,3)=COVX(1,1,3,1)
      COVX(1,1,2,2)=(CN(1,2)+D(7)*D(7)*CN(3,1)-T*CN(2,1))/RQ2
      COVX(1,1,3,2)=(D(7)*(CN(2,2)-CN(2,1)))/RQ2
      COVX(1,1,2,3)=COVX(1,1,3,2)
      COVX(1,1,3,3)=CN(1,3)/RQ2
      GO TO 810
C ONE DERIVATIVE IN P, TWO IN Q.  REF(I), EQ. (29)-(33).
  808 RPQ2=RP*RQ2
      CNX=CN(2,2)-T*CN(3,1)+D(13)*D(13)*CN(4,1)-CN(2,1)
      COVX(1,1,1,1)=(D(3)*CNX+D2*DD(3,3)*D(13)*CN(3,1))/RPQ2
      COVX(2,1,1,1)=(D(2)*CNX+D2*DD(2,3)*D(13)*CN(3,1))/RPQ2 
      COVX(3,1,1,1)=(CN(1,3)+CN(1,2)+D(13)*D(13)*CN(3,2)
     *    -T*CN(2,2))/RPQ2
C ERROR CORRECTED 1992.09.04 BY CCT. 
      COVX(1,1,2,1)=(D(7)*D(13)*D(3)*CN(4,1)+(D(7)*DD(3,3)+D(13)
     *    *DD(3,2))*CN(3,1))/RPQ2
C     COVX(2,1,2,1)=(DD(2,2)*DD(1,3)*CN(3,1)+DD(1,2)*(DD(3,2)*CN(3,1)
C CHANGE 2002-11-01.
      COVX(2,1,2,1)=(DD(2,2)*DD(1,3)*CN(3,1)+DD(1,2)*(DD(2,3)*CN(3,1)
     *    +DD(2,1)*DD(1,3)*CN(4,1)))/RPQ2
      COVX(3,1,2,1)=DD(1,2)*DD(1,3)*CN(3,2)/RPQ2
      COVX(1,1,3,1)=(DD(3,1)*DD(1,3)*(CN(3,2)-CN(3,1))+DD(3,3)
     *    *(CN(2,2)-CN(2,1)))/RPQ2
      COVX(2,1,3,1)=(DD(2,1)*DD(1,3)*(CN(3,2)-CN(3,1))+DD(2,3)
     *    *(CN(2,2)-CN(1,2)))/RPQ2
      COVX(3,1,3,1)=DD(1,3)*CN(2,3)/RPQ2
      COVX(1,1,1,2)=COVX(1,1,2,1)
      COVX(2,1,1,2)=COVX(2,1,2,1)
      COVX(3,1,1,2)=COVX(3,1,2,1)
      CNX=CN(2,2)-T*CN(3,1)+D(7)**2*CN(4,1)-CN(2,1)
      COVX(1,1,2,2)=(D(3)*CNX+D2*D(7)*DD(3,2)*CN(3,1))/RPQ2
      COVX(2,1,2,2)=(D(2)*CNX+D2*D(7)*DD(2,2)*CN(3,1))/RPQ2
      COVX(3,1,2,2)=(CN(1,3)+CN(1,2)+D(7)**2*CN(3,2)
     *    -T*CN(2,2))/RPQ2
      CNX=D(7)*(CN(3,2)-CN(3,1))
      COVX(1,1,3,2)=(D(3)*CNX+DD(3,2)*(CN(2,2)-CN(2,1)))/RPQ2
      COVX(2,1,3,2)=(D(2)*CNX+DD(2,2)*(CN(2,2)-CN(2,1)))/RPQ2
C POSSIBLE ERROR 1992.09.08.
      COVX(3,1,3,2)=D(7)*CN(2,3)/RPQ2
      COVX(1,1,1,3)=COVX(1,1,3,1)
      COVX(2,1,1,3)=COVX(2,1,3,1)
      COVX(3,1,1,3)=COVX(3,1,3,1)
      COVX(1,1,2,3)=COVX(1,1,3,2)
      COVX(2,1,2,3)=COVX(2,1,3,2)
      COVX(3,1,2,3)=COVX(3,1,3,2)
      COVX(1,1,3,3)=D(3)*CN(2,3)/RPQ2
      COVX(2,1,3,3)=D(2)*CN(2,3)/RPQ2
      COVX(3,1,3,3)=CN(1,4)/RPQ2
C GRAVITY ANOMALY ADDED 1992.09.30. 
      IF (LDGP) THEN
      COVX(3,1,1,1)=-(CN(1,3)+D3*CN(1,2)+D(13)*D(13)*(CN(3,2)
     *   +D2*CN(3,1))-T*(CN(2,2)+D2*CN(2,1)))/RPQ2
C 2000-04-03
      COVX(3,1,2,1)=-DD(1,2)*DD(1,3)*(CN(3,2)+D2*CN(3,1))/RPQ2
C     COVX(3,1,3,1)=-DD(3,1)*(CN(2,3)+D2*CN(2,2))/RPQ2
      COVX(3,1,3,1)=-DD(1,3)*(CN(2,3)+D2*CN(2,2))/RPQ2
      IF (LTEST) WRITE(*,*)' COVX(3,1,3,1) ', COVX(3,1,3,1)
      COVX(3,1,1,2)=COVX(3,1,2,1)
      COVX(3,1,2,2)=-(CN(1,3)+D3*CN(1,2)+D(7)**2*(CN(3,2)
     *   +D2*CN(3,1))-T*(CN(2,2)+D2*CN(2,1)))/RPQ2
      COVX(3,1,3,2)=-D(7)*(CN(2,3)+D2*CN(2,2))/RPQ2
C     COVX(3,1,3,2)=-D(2)*(CN(2,3)+D2*CN(2,2))/RPQ2 CC 2000-04-05
      COVX(3,1,1,3)=COVX(3,1,3,1)
      COVX(3,1,2,3)=COVX(3,1,3,2)
      COVX(3,1,3,3)=-(CN(1,4)+D2*CN(1,3))/RPQ2
      END IF 
      GO TO 810
C TWO DERIVATIVES IN BOTH P AND Q. REF(I), EQ. (34)-(46).
  809 R2PQ=RPQ**2
      D3132=D(3)**2+D(13)**2
      D313=D(3)*D(13) 
      COVX(1,1,1,1)=(CN(1,3)+CN(1,2)-D2*T*CN(2,2)+D3132*CN(3,2) 
     *  +T*CN(2,1)+CN(3,1)*(D2*(CD**2-D3132)+T2)
     *  -CN(4,1)*(D4*CD*SD**2*CP*CQ+T*D3132)
     *  +CN(5,1)*D313**2)/R2PQ
      COVX(2,1,1,1)=(D(2)*D(3)*(CN(3,2)+D(13)**2*CN(5,1)-T*CN(4,1))
     *  +CN(3,1)*D2*(-D(2)*D(3)+DD(2,3)*DD(3,3))
     *  +CN(4,1)*D2*(D313*DD(2,3)+D(2)*D(13)*DD(3,3)))/R2PQ 
      CN23=CN(2,3)-CN(2,2)+CN(2,1)
      COVX(3,1,1,1)=(D(3)*(CN23+D(13)**2*(CN(4,2)-CN(4,1))
     *  +T*(CN(3,1)-CN(3,2)))+D2*D(13)*DD(3,3)*(CN(3,2)-CN(3,1)))/R2PQ 
      COVX(1,2,1,1)=COVX(2,1,1,1)
      COVX(2,2,1,1)=(CN(1,3)+CN(1,2)-CN(2,2)*D2*T
     *  +CN(3,2)*(D(13)**2+D(2)**2)+CN(2,1)*T
     *  +CN(3,1)*(D2*(DD(2,3)**2-D(13)**2
     *  -D(2)**2)+T2)+CN(4,1)*(D4*D(2)*D(13)*DD(2,3)-T      
     *  *(D(13)**2+D(2)**2))+D(13)**2*D(2)**2*CN(5,1))/R2PQ 
      COVX(3,2,1,1)=(D(2)*(CN23
     *  +T*(CN(3,1)-CN(3,2))+D(13)**2*(CN(4,2)-CN(4,1)))
     *  +D2*D(13)*DD(2,3)*(CN(3,2)-CN(3,1)))/R2PQ 
C SUSPECTED ERROR 2002-10-07
C    *  +T*(CN(3,1)-CN(3,2))+D(13)**2*(CN(4,2)-CN(4,1))
C    *  +D2*D(13)*DD(2,3)*(CN(3,2)-CN(3,1)))/R2PQ 
      COVX(1,3,1,1)=COVX(3,1,1,1)
      COVX(2,3,1,1)=COVX(3,2,1,1)
      COVX(3,3,1,1)=(CN(1,4)-T*CN(2,3)+D(13)**2*CN(3,3))/R2PQ
C 
      COVX(1,1,2,1)=(D(7)*D(13)*(CN(3,2)+D(3)**2*CN(5,1)-T*CN(4,1))
     *  +CN(3,1)*D2*(-D(7)*D(13)+DD(3,2)*DD(3,3))
     *  +CN(4,1)*D2*(D313*DD(3,2)+D(7)*D(3)*DD(3,3)))/R2PQ 
      COVX(2,1,2,1)=(CN(3,1)*(DD(2,3)*DD(3,2)+DD(2,2)*DD(3,3))
     *  +CN(4,1)*(DD(2,3)*D(3)*D(7)+DD(3,3)*D(2)*D(7)
     *  +DD(2,2)*D(3)*D(13)+DD(3,2)*D(2)*D(13))
     *  +CN(5,1)*D(2)*D(3)*D(7)*D(13))/R2PQ
C ERROR 2000-04-05.
      COVX(3,1,2,1)=(D(3)*D(13)*D(7)*(CN(4,2)-CN(4,1))
     *  +(D(13)*DD(3,2)+DD(3,3)*D(7))*(CN(3,2)-CN(3,1)))/R2PQ
C     COVX(3,1,2,1)=(D(3)*D(13)*D(7)*(CN(3,2)-CN(3,1))
C    *  +(D(13)*DD(3,2)+DD(3,3)*D(7))*(CN(2,2)-CN(2,1)))/R2PQ
      COVX(1,2,2,1)=COVX(2,1,2,1)
      COVX(2,2,2,1)=(D(7)*D(13)*(CN(3,2)+D(2)**2*CN(5,1))
     *  +CN(3,1)*D2*(DD(2,3)*DD(2,2)+D(13)
     *  *DD(4,2))+CN(4,1)*(D2*(D(7)*D(2)*DD(2,3)+D(2)*D(13)*DD(2,2))
     *  -D(7)*D(13)*T))/R2PQ 
      COVX(3,2,2,1)=((D(8)*D(13)+D(7)*DD(2,3))*(CN(3,2)-CN(3,1))
     *  +D(7)*D(2)*D(13)*(CN(4,2)-CN(4,1)))/R2PQ
      COVX(1,3,2,1)=COVX(3,1,2,1)
      COVX(2,3,2,1)=COVX(3,2,2,1)
      COVX(3,3,2,1)=D(7)*D(13)*CN(3,3)/R2PQ
C 
      COVX(1,1,3,1)= (D(13)*(CN23+D(3)**2*(CN(4,2)-CN(4,1))
     *  +T*(CN(3,1)-CN(3,2)))+D2*D(3)*DD(3,3)*(CN(3,2)-CN(3,1)))/R2PQ 
      COVX(2,1,3,1)=((DD(3,3)*D(2)+DD(2,3)*D(3))*(CN(3,2)-CN(3,1))
     *  +D(3)*D(13)*D(2)*(CN(4,2)-CN(4,1)))/R2PQ
C     CN33=CN(3,3)-D2*CN(3,2)+CN(3,1)
      CN33=CN(3,3)-CN(3,2)+CN(3,1)
      COVX(3,1,3,1)=(D(3)*D(13)*CN33+DD(3,3)*CN23)/R2PQ
      COVX(1,2,3,1)=COVX(2,1,3,1) 
      COVX(2,2,3,1)=(D(13)*(CN23
     *  +D(2)**2*(CN(4,2)-CN(4,1))
     *  +DD(4,1)*(CN(3,2)-CN(3,1)))
     *  +D2*D(2)*DD(2,3)*(CN(3,2)-CN(3,1)))/R2PQ 
      COVX(3,2,3,1)=(DD(2,3)*CN23+D(2)*D(13)*CN33)/R2PQ
      COVX(1,3,3,1)=COVX(3,1,3,1)
      COVX(2,3,3,1)=COVX(3,2,3,1)
      COVX(3,3,3,1)=D(13)*(CN(2,4)-CN(2,3))/R2PQ
C 
      COVX(1,1,1,2)=COVX(1,1,2,1)
      COVX(2,1,1,2)=COVX(2,1,2,1)
      COVX(3,1,1,2)=COVX(3,1,2,1)
      COVX(1,2,1,2)=COVX(1,2,2,1)
      COVX(2,2,1,2)=COVX(2,2,2,1)
      COVX(3,2,1,2)=COVX(3,2,2,1)
      COVX(1,3,1,2)=COVX(1,3,2,1)
      COVX(2,3,1,2)=COVX(2,3,2,1)
      COVX(3,3,1,2)=COVX(3,3,2,1)
C 
      D37=D(3)**2+D(7)**2 
      COVX(1,1,2,2)=(CN(1,3)+CN(1,2)+CN(2,2)*(-D2*T)
     *  +CN(3,2)*D37+CN(2,1)*T
     *  +CN(3,1)*(D2*(DD(3,2)**2-D37)
     *  +T2)+CN(4,1)*(D4*D(7)*D(3)*DD(3,2)-T
     *  *D37)+D(3)**2*D(7)**2*CN(5,1))/R2PQ 
      COVX(2,1,2,2)=(D(2)*D(3)*(CN(3,2)+D(7)**2*CN(5,1))
     *  +CN(3,1)*D2*(DD(3,2)*DD(2,2)-D(3)*D(2))
     *  +CN(4,1)*(D2*(D(2)*D(7)*DD(3,2)+D(7)*DD(2,2)*D(3))
     *  +D(2)*D(3)*D(19)))/R2PQ 
      COVX(3,1,2,2)=(D(3)*(CN23+D(7)**2*(CN(4,2)-CN(4,1))
     *  +DD(1,4)*(CN(3,2)-CN(3,1)))
     *  +D2*DD(3,2)*D(7)*(CN(3,2)-CN(3,1)))/R2PQ 
      COVX(1,2,2,2)=COVX(2,1,2,2)
      D27=D(2)**2+D(7)**2 
      COVX(2,2,2,2)=(CN(1,3)+CN(1,2)-D2*T*CN(2,2)+D27*CN(3,2)
     *  +T*CN(2,1)+(T2-D2*(D27-DD(2,2)**2))*CN(3,1)
     *  +(D4*D(8)*D(2)*D(7)-T*D27)*CN(4,1)
     *  +(D(2)*D(7))**2*CN(5,1))/R2PQ 
      COVX(3,2,2,2)=(D(2)*(CN23+D(7)**2
     *  *(CN(4,2)-CN(4,1))-T*(CN(3,2)-CN(3,1)))
     *  +D2*D(7)*D(8)*(CN(3,2)-CN(3,1)))/R2PQ
      COVX(1,3,2,2)=COVX(3,1,2,2)
      COVX(2,3,2,2)=COVX(3,2,2,2)
      COVX(3,3,2,2)=(CN(1,4)+D(7)**2*CN(3,3)-T*CN(2,3))/R2PQ
C 
      COVX(1,1,3,2)=(D(7)*(CN23
     *  +T*(CN(3,1)-CN(3,2))+D(3)**2*(CN(4,2)-CN(4,1)))
     *  +D2*D(3)*DD(3,2)*(CN(3,2)-CN(3,1)))/R2PQ 
      COVX(2,1,3,2)=((D(8)*D(3)+D(2)*DD(3,2))*(CN(3,2)-CN(3,1))
     *  +D(7)*D(2)*D(3)*(CN(4,2)-CN(4,1)))/R2PQ
      COVX(3,1,3,2)=(DD(3,2)*CN23+D(3)*D(7)*CN33)/R2PQ
      COVX(1,2,3,2)=COVX(2,1,3,2)
      COVX(2,2,3,2)=(D(7)*(CN23+D(2)**2
     *  *(CN(4,2)-CN(4,1))-T*(CN(3,2)-CN(3,1)))
     *  +D2*D(2)*D(8)*(CN(3,2)-CN(3,1)))/R2PQ
      COVX(3,2,3,2)=(DD(2,2)*CN23+D(2)*D(7)*CN33)/R2PQ
      COVX(1,3,3,2)=COVX(3,1,3,2)
      COVX(2,3,3,2)=COVX(3,2,3,2)
      COVX(3,3,3,2)=D(7)*(CN(2,4)-CN(2,3))/R2PQ
C 
      COVX(1,1,1,3)=COVX(1,1,3,1)
      COVX(2,1,1,3)=COVX(2,1,3,1)
      COVX(3,1,1,3)=COVX(3,1,3,1)
      COVX(1,2,1,3)=COVX(2,1,3,1)
      COVX(2,2,1,3)=COVX(2,2,3,1)
      COVX(3,2,1,3)=COVX(3,2,3,1)
      COVX(1,3,1,3)=COVX(1,3,3,1)
      COVX(2,3,1,3)=COVX(2,3,3,1)
      COVX(3,3,1,3)=COVX(3,3,3,1)
C 
      COVX(1,1,2,3)=COVX(1,1,3,2)
      COVX(2,1,2,3)=COVX(2,1,3,2)
      COVX(3,1,2,3)=COVX(3,1,3,2)
      COVX(1,2,2,3)=COVX(1,2,3,2)
      COVX(2,2,2,3)=COVX(2,2,3,2)
      COVX(3,2,2,3)=COVX(2,3,3,2)
      COVX(1,3,2,3)=COVX(3,1,3,2)
      COVX(2,3,2,3)=COVX(3,2,3,2)
      COVX(3,3,2,3)=COVX(3,3,3,2)
C 
      COVX(1,1,3,3)=(CN(1,4)-T*CN(2,3)+D(3)**2*CN(3,3))/R2PQ
      COVX(2,1,3,3)=D(2)*D(3)*CN(3,3)/R2PQ
      COVX(3,1,3,3)=D(3)*(CN(2,4)-CN(2,3))/R2PQ 
      COVX(1,2,3,3)=COVX(2,1,3,3)
      COVX(2,2,3,3)=(CN(1,4)+D(2)**2*CN(3,3)-T*CN(2,3))/R2PQ
      COVX(3,2,3,3)=D(2)*(CN(2,4)-CN(2,3))/R2PQ
      COVX(1,3,3,3)=COVX(3,1,3,3)
      COVX(2,3,3,3)=COVX(3,2,3,3)
      COVX(3,3,3,3)=CN(1,5)/R2PQ 
  810 END IF 
C
  204 IF (.NOT.LSAT) THEN 
C INTEGERS SPECIFYING THE KINDS OF DIFFERENTIATION WITH RESPECT TO THE
C LATITUDES AND/OR THE LONGITUDES, CF. REF.(A), SECTION 3.
      I = KI(10)
      J = KI(12)
      K = KI(11)
      M = KI(13)
      J1 = KI(14)
      M1 = KI(15)
      IF (.NOT.(LOLDP.OR.LOLDQ)) GO TO 110
C
      IJ = I+J
      IF (I.GT.3) IJ = 5
      KM = K+M
      IF (K.GT.3) KM = 5
C
C COMPUTATION OF THE DERIVATIVES OF ORDER ND WITH RESPECT TO THE LATI-
C TUDES AND THE LONGITUDES, CF. REF.(A), EQ. (43) - (46).
      GO TO (80,81,82,83,84),ND1
   80 COV = C(2)
      GO TO 85
   81 COV = -C(3)*D(I+6*(K-1))
      GO TO 85
   82 COV = D(I)*D(J1)*D(6*(K-1)+1)*D(6*(M1-1)+1)*C(4)+D(IJ+6*(KM-1))
     **C(3)
      GO TO 85
   83 COV = (-D(IJ+6*(KM-1))*C(3)+(D(IJ)*D(6*(KM-1)+1)+D(I+6*(K-1))
     **D(J1+6*(M1-1))+D(I+6*(M1-1))*D(J1+6*(K-1)))*C(4)
     *+D(I)*D(J1)*D(6*(K-1)+1)*D(6*(M1-1)+1)*C(5))
      GO TO 85
   84 COV  = D(IJ+6*(KM-1))*C(3)+(D(IJ+6*(K-1))*D(6*(M-1)+1)
     *+D(I+6*(KM-1))*D(J)+D(J+6*(KM-1))*D(I)+D(IJ+6*(M-1))
     **D((K-1)*6+1)+D(IJ)*D(6*(KM-1)+1)+D(I+6*(K-1))*D(J+6*(M-1))
     *+D(I+6*(M-1))*D(J+6*(K-1)))*C(4)+(D(IJ)*D(6*(K-1)+1)*D(6*(M-1)+1)
     *+D(I+6*(K-1))*D(J)*D(6*(M-1)+1)+D(I+6*(M-1))*D(J)*D(6*(K-1)+1)
     *+D(J+6*(K-1))*D(I)*D(6*(M-1)+1)+D(J+6*(M-1))*D(I)*D(6*(K-1)+1)
     *+D(6*(KM-1)+1)*D(I)*D(J))*C(5)+D(I)*D(J)*D(6*(K-1)+1)*D(6*(M-1)
     *+1)*C(6)
C
C GIVING THE COVARIANCE THE PROPER UNITS.
   85 COV = COV*CI(12)
C
      GO TO 199
  110 CF=CI(12)
      IF (KI(6).EQ.13) CF=CF/D2
      IF (KI(7).EQ.13) CF=CF/D2
      DO 111 IX = 2, ND2
  111 CZ(IX-1) = C(IX)*CF
      CV(1,2) = D0
      CV(2,1) = D0
      CV(2,2) = D0
      GO TO (112, 113, 114, 115, 115), ND1
  112 CV(1,1) = CZ(1)
C  ================================================================
       KZ=1
      GO TO 198
  113 IF (I.EQ.1) GO TO 116
      CV(1,1) = CZ(2)*D(3)
      CV(2,1) = CZ(2)*D(2)
C  ================================================================
       KZ=2
      GO TO 198
  116 CV(1,1) = CZ(2)*D(13)
      CV(1,2) = CZ(2)*D(7)
C  ================================================================
       KZ=3
      GO TO 198
  114 IF (I.GT.1) GO TO 117
      CV(1,2) = CZ(3)*D(19)*D(31)
      CV(1,1) = CZ(3)*D(7)*D(13)*D2
C  =================================================================
      KZ=4
      GO TO 198
  117 IF (K.GT.1) GO TO 118
      CV(2,1) = CZ(3)*D(4)*D(6)
      CV(1,1) = CZ(3)*D(2)*D(3)*D2
C  =================================================================
      KZ=5
      GO TO 198
  118 CV(1,1) = CZ(2)*D(15)+CZ(3)*D(13)*D(3)
      CV(2,2) = CZ(2)*D(8) +CZ(3)*D(2)*D(7)
      CV(1,2) = CZ(2)*D(9) +CZ(3)*D(3)*D(7)
      CV(2,1) = CZ(2)*D(14)+CZ(3)*D(13)*D(2)
C  =================================================================
      KZ=6
C FIRST ORDER HORIZONTAL DERIVATIVES IN BOTH P AND Q.
      GO TO 198
  115 CONTINUE
C
      IIX=2
      DO 119 IX = 1, 2
      IIY=2
      DO 120 JX = 1, 2
      IF (ND.EQ.4) GO TO 121
C SECOND ORDER HORIZONTAL DERIVATIVE IN P OR Q.
      IX1=IX
      JX1=JX
      IF (KI(6) .GE. 12) GO TO 122
      CF = JX
      JX1=IIY
      I = J2(IX)
      J1 = 1
      K = I4(JX)
      M1 = I3(JX)
      GO TO 123
  122 CF = IX
      IX1=IIX
      I = I4(IX)
      J1 = I3(IX)
      K = J2(JX)
      M1 = 1
  123 K6 = 6*(K-1)
      M6 = 6*(M1-1)
      CV(IX1,JX1) = (CZ(3)*(D(I+K6)*D(J1+M6)+D(J1+K6)*D(I+M6))
     * +CZ(4)*D(I)*D(J1)*D(K6+1)*D(M6+1))*CF
C  =================================================================
      KZ=7
      GO TO 120
  121 I = I4(IX)
      J = I3(IX)
      K = I4(JX)
      M = I3(JX)
      K6 = 6*(K-1)
      M6 = 6*(M-1)
      CV(IIX,IIY) = (CZ(3)*(D(I+K6)*D(J+M6)+D(I+M6)*D(J+K6))
     *  +CZ(4)*(D(J)*(D(I+K6)*D(M6+1)+D(I+M6)*D(K6+1))
     *        +D(I)*(D(J+K6)*D(M6+1)+D(J+M6)*D(K6+1)))
     *  +CZ(5)*D(I)*D(J)*D(K6+1)*D(M6+1))*IX*JX
C ==================================================================
      KZ=8
  120 IIY=1
  119 IIX=1
  198 COV = CV(KI(24),KI(25))
C ==================================================================
      IF (LTEST)WRITE(6,7788) KZ,I,J,K,M,CV(1,1),CV(1,2),CV(2,1),
     *CV(2,2)
 7788 FORMAT(/'  KZ,   I,   J,   K,   M,   CV(1,1),   CV(1,2), ',
     *' CV(2,1)   CV(2,2)'/1X,5I4,4F10.4)
  199 RETURN
      ELSE
       COV=COVX(KSAT(KP,1),KSAT(KP,2),KSAT(KQ,1),KSAT(KQ,2))
       IF (KP.EQ.15.AND.KQ.NE.15) 
     * COV=COV-COVX(2,2,KSAT(KQ,1),KSAT(KQ,2)) 
C CHANGE, SO THAT UNITS ARE M, MGAL OR EU. 1992.08.26.
       IF (KP.EQ.6.OR.KP.EQ.7) THEN
        C11P=1.0D5
       ELSE
C CHANGE 2003-04-01.
C     C11P=C11(KP)/(CR(10)**K19(KP))
        C11P=C11(KP)
       END IF  
       IF (KQ.EQ.6.OR.KQ.EQ.7) THEN
        C11Q=1.0D5
       ELSE
C     C11Q=C11(KQ)/(CR(11)**K19(KQ)) 
        C11Q=C11(KQ) 
       END IF  
       CFA=C11P*C11Q
       IF (KP.NE.15.AND.KQ.EQ.15) 
     * COV=COV-COVX(KSAT(KP,1),KSAT(KP,2),2,2) 
       IF (KP.EQ.15.AND.KQ.EQ.15) 
     * COV=COV-COVX(1,1,2,2)-COVX(2,2,1,1)+COVX(2,2,2,2) 
       COV=COV*CFA 
C 2000-04-04.
       IF (LTEST)WRITE(*,*)' KSAT ',KSAT(KP,1),KSAT(KP,2),KSAT(KQ,1),
     * KSAT(KQ,2),' COV ',COV,' CFA ',CFA 
      END IF 
      RETURN 
      END
      FUNCTION VAR(SM,IS,KP,DRM,AAI,HP,IMAX1,LMEAN,CP,SP,LSAT,SROT)
C PROGRAMMED FEB 1985 BY C.C.TSCHERNING. UPDATE: JAN 18, 2005.
C THE FUNCTION COMPUTES THE VARIANCE OF A SIGNAL QUANTITY OF TYPE
C KP USING COVBX AND COVCX.
C IF DOUBLE PRECISION IS NEEDED, ACTIVATE THE FOLLOWING STATEMENT:
      IMPLICIT NONE
      LOGICAL LT,LF,LSUM,LOCAL,LMEAN,LSAT,LTESTS,LX,LNX
      REAL*8 CI,CR,SIGMA0,SIGMA,HMAX,D,D0,D1,D2,D3,D4,D5,RE,RADSEC,
     *PI,GM,STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER,STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q,COVX,CIX,CFA,SM,SROT,AAI,DRM,RP,HP,CVV,STEQQN,
     *VAR,COMEAN,CP,SP
      INTEGER KSAT,KI,N1,N2,NFILTE,NDX1,NDX2,NDP,NDQ,NWAR,IMAX1,
     *KP,IS,ITCOUN
C
      COMMON /CMCOV/CI(24),CR(56),SIGMA0(2200),SIGMA(2200),HMAX,
     *D(40),KI(37),N1,N2,LOCAL,LSUM
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,ITCOUN,LF,LT
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE
      COMMON /CMEAQ/STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFA,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP,NDQ,NWAR,LX(7,5),LNX(7,5),LTESTS 
      DIMENSION SM(2200),SROT(3,3)
C
      CI(8) = AAI
      CI(9) = (RE+DRM)**2
      CI(10)= DRM
      CI(20)= D1
      N1 = IMAX1
      KI(6) = KP
      KI(7) = KP
      RP = RE+HP
      CALL COVBX(SM,LSAT,IS)
      CR(1) = D1
      CR(2) = HP
      CR(3) = HP
      CR(4) = D0
      CR(5) = D0
      CR(6) = D1
      CR(7) = D1
      CR(8) = D0
      CR(9) = D1
C CHANGE 2005-01-18.
      IF (LSAT) THEN
       CR(10)=D1
       CR(11)=D1
      ELSE
       CR(10)= GM/(RP*RP)
       CR(11) = CR(10)
      END IF
      IF (.NOT.LMEAN) THEN
      CALL COVCX(SM,CVV,IS,LSAT)
      IF (LSAT) THEN
       CALL COVROT(SROT,SROT)
       IF (LTESTS) WRITE(*,101)COVX
 101   FORMAT(6D12.4)
C      CVV=COVX(KSAT(KP,1),KSAT(KP,2),KSAT(KP,1),KSAT(KP,2))
       IF (KP.NE.25) THEN
        CVV=COVX(KSAT(KP,1),KSAT(KP,2),KSAT(KP,1),KSAT(KP,2))
C CHANGE 2002-10-23.
       ELSE
C DDT/DXX-DDT/DYY IN P.
        CVV=
     *  (COVX(KSAT(14,1),KSAT(14,2),KSAT(14,1),KSAT(14,2)) 
     *  -COVX(KSAT(12,1),KSAT(12,2),KSAT(14,1),KSAT(14,2)) 
     *  +COVX(KSAT(14,1),KSAT(14,2),KSAT(12,1),KSAT(12,2))
     *  -COVX(KSAT(12,1),KSAT(12,2),KSAT(12,1),KSAT(12,2)))
       END IF
       IF (LTESTS) WRITE(*,100)CVV,KSAT(KP,1),KSAT(KP,2),KP
 100   FORMAT(' CVV, KP ',D14.6,3I3)
      END IF
      ELSE
C CHANGE 2001-07-15.
      STEQQN=STEQN
      STEQN=STEPN
      COSSQN=COSSTN
      SINSQN=SINSTN
      STEQE=STEPE
      COSSQE=COSSTE
      SINSQE=SINSTE 
      COST2Q=COST2P
      SINT2Q=SINT2P 
      CVV=COMEAN(SM,IS,0,CP,SP,D1,D0,CP,SP,D1,D0,5,5,LF,LF,LF)    
      END IF 
C CHANGE 2000-04-11 AND 2002-09-30 BY CCT.
      IF (LSAT) THEN
       IF (KP.EQ.6.OR.KP.EQ.7.OR.KP.EQ.2) THEN
       CVV=CVV*1.0D10
C CONVERSION TO MGAL.
C      CVV=CVV*(CR(10)*1.0D5/RADSEC)**2
       ELSE
        IF (KP.GT.7.OR.KP.EQ.5) THEN
C SCALING FOR 2-ORDER DERIVATIVES (TO EU**2).
         CVV=CVV*1.0D18
C SCALING FOR 2*TXY. 2002-11-26.
         IF (KP.EQ.13)CVV=CVV*4.0D0
         IF (LTESTS) WRITE(*,*)' KP, CVV ',KP,CVV
        END IF
       END IF
      END IF
      VAR = CVV
C CHANGE 2001-07-15.
      STEQN=STEQQN
      RETURN
      END
      SUBROUTINE ATBA(A,B,C)
C PROGRAMMED AUG 89 BY C.C.TSCHERNING.
C THE SUBROUTINE WILL COMPUTE THE PRODUCT OF THE 3*3 MATRICES A TRANS-
C POSED, B AND A AND STORE THE RESULT IN C. 
      IMPLICIT NONE
      REAL*8 A,B,C,D,E   
      INTEGER J,K,N
      DIMENSION A(3,3),B(3,3),C(3,3),D(3,3),E(3,3)   
C A TRANSPOSED TIMES B STORED IN D: : 
      DO 30 K=1,3 
      DO 30 J=1,3
      D(K,J)=0.0D0 
      DO 30 N=1,3 
C  30 D(K,J)= A(K,N)*B(N,J)+D(K,J) 
   30 D(K,J)= A(N,K)*B(N,J)+D(K,J) 
C
C D TIMES A STORED IN E: 
      DO 40 K=1,3
      DO 40 J=1,3
      E(K,J)=0.0D0
      DO 40 N=1,3
C  40 E(K,J)=E(K,J)+D(K,N)*A(J,N)
   40 E(K,J)=E(K,J)+D(K,N)*A(N,J)
C
      DO 50 K=1,3
      DO 50 J=1,3
   50 C(K,J)=E(K,J)
      RETURN
      END  
      SUBROUTINE SROT(CV,SA,CA,IDIM,LTP)
C PROGRAMMED AUG 89 BY C.C.TSCHERNING. CHANGED 1995.03.16 BY CCT.
C THE SUBROUTINE WILL FOR IDIM=1 COMPUTE THE PRODUCT OF THE ROTATION
C MATRIX AND THE 2 X 2 MATRIX CV AND FOR IDIM=2 THE MATRIX CV,
C ROTATED CLOCKWISE THE ANGLE A. SA=SIN(A), CA=COS(A), GIVEN.
C LTP IS TRUE IF CV MUST BE TRANSPOSED BEFORE MULTIPLICATION.
      IMPLICIT NONE
      REAL*8 CV,SA,CA,CV21,CV11,CV12,SA2,CA2,CS
      INTEGER IDIM
      LOGICAL LTP
      DIMENSION CV(2,2)
C
      IF (LTP) THEN
      CV21=CV(2,1)
      CV(2,1)=CV(1,2)
      CV(1,2)=CV21
      END IF
      IF (IDIM.EQ.1) THEN
      CV11=CA*CV(1,1)-SA*CV(2,1)
      CV12=-SA*CV(2,2)+CA*CV(1,2)
      CV21=CA*CV(2,1)+SA*CV(1,1)
      CV(2,2)=SA*CV(1,2)+CA*CV(2,2)
      CV(1,1)=CV11
      CV(2,1)=CV21
      CV(1,2)=CV12
      ELSE
      SA2=SA*SA
      CA2=CA*CA
      CS=CA*SA
      CV11=CA2*CV(1,1)-CS*(CV(2,1)+CV(1,2))+SA2*CV(2,2)
      CV12=(CA2-SA2)*CV(1,2)+CS*(CV(1,1)-CV(2,2))
      CV(2,2)=SA2*CV(1,1)+CS*(CV(1,2)+CV(2,1))+CA2*CV(2,2)
      CV(1,2)=CV12 
      CV(2,1)=CV(1,2)
      CV(1,1)=CV11
      END IF 
      IF (LTP) THEN
      CV21=CV(2,1)
      CV(2,1)=CV(1,2)
      CV(1,2)=CV21
      END IF
      RETURN
      END  
      SUBROUTINE AXV(A,V)
C THE SUBRIUTINE WILL COMPUTE THE PRODUCT OF THE MATRIX A AND THE
C VECTOR V AND RETURN IT IN V. PROGRAMMED 1990.11.03 BY CCT.  
      IMPLICIT NONE
      REAL*8 A,V,Y
      INTEGER I,J
      DIMENSION A(3,3),V(3),Y(3) 
      DO 10 I=1,3
      Y(I)=V(I)
   10 V(I)=0.0D0 
      DO 20 I=1,3
      DO 20 J=1,3
   20 V(I)=A(I,J)*Y(J)+V(I)  
      RETURN
      END 
      SUBROUTINE COVROT(SROTP,SROTQ)
C THE SUBROUTINE WILL COMPUTE THE ROTATED COVARIANCE MATRIV OR VECTOR
C USING THE ROTATION MATRICES SRORP, SROTQ ASSOCIATED WITH THE POINTS
C P, Q, RESPECTIVELY. SEE REF(I), SECTION 3.
C PROGRAMMED BY C.C.TSCHERNING, GEOPHYSICAL INSTITUTE, UNIVERSITY OF
C COPENHAGEN, JUNE, 1991.
C (I) TSCHERNING, C.C.: COMPUTATION OF COVARIANCES OF DERIVATIVES OF THE
C     ANOMALOUS GRAVITY POTENTIAL IN A ROTATED REFERENCE FRAME.
C     MANUSCRIPTA GEODAETICA, VOL. 18, NO. 3, PP. 115-123, 1993. 
C LAST UPDATE 2002-10-24.  
C
      IMPLICIT NONE
      REAL*8 COVX,CIX,CFA,SROTP,SROTQ,V,A
      INTEGER KSAT,NDX1,NDX2,NDP,NDQ,NWAR,NCASE,IM,JM,I,J
      LOGICAL LSATS,LNX,LX
C
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFA,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP, NDQ,NWAR,LX(7,5),LNX(7,5),LSATS
      DIMENSION SROTP(3,3),SROTQ(3,3),V(3),A(3,3)
      NCASE=NDP+1+NDQ*3
C
      GO TO (801,802,803,804,805,806,807,808,809),NCASE
C 1 DERIV. IN P, NONE IN Q. 
  802 DO 831 IM=1,3
  831 V(IM)=COVX(IM,1,1,1)
      CALL AXV(SROTP,V)
      DO 812 IM=1,3
  812 COVX(IM,1,1,1)=V(IM) 
      GO TO 801
C 
C 2 DERIV. IN P, NONE IN Q.
  803 DO 823 IM=1,3
      DO 823 JM=1,3
  823 A(IM,JM)=COVX(IM,JM,1,1)
      CALL ATBA(SROTP,A,A) 
      DO 824 IM=1,3
      DO 824 JM=1,3
  824 COVX(IM,JM,1,1)=A(IM,JM) 
      GO TO 801
C 
C NO DERIV. IN P, 1 IN Q.
  804 DO 832 IM=1,3 
  832 V(IM)=COVX(1,1,IM,1)
      CALL AXV(SROTQ,V)
      DO 833 IM=1,3
  833 COVX(1,1,IM,1)=V(IM) 
      GO TO 801
C 
C 1 DERIV. IN BOTH P AND Q.
  805 DO 834 IM=1,3
      DO 835 JM=1,3
  835 V(JM)=COVX(JM,1,IM,1)
      CALL AXV(SROTP,V)
      DO 836 JM=1,3
  836 COVX(JM,1,IM,1)=V(JM)
  834 CONTINUE
      DO 844 IM=1,3
      DO 845 JM=1,3
  845 V(JM)=COVX(IM,1,JM,1)
      CALL AXV(SROTQ,V)
      DO 846 JM=1,3
  846 COVX(IM,1,JM,1)=V(JM)
  844 CONTINUE
      GO TO 801
C
C 2 DERIV. IN P, 1 IN Q. 
  806 DO 854 I=1,3
      DO 855 IM=1,3
      DO 855 JM=1,3
  855 A(IM,JM)=COVX(IM,JM,I,1)
      CALL ATBA(SROTP,A,A)
      DO 856 IM=1,3
      DO 856 JM=1,3
  856 COVX(IM,JM,I,1)=A(IM,JM)
  854 CONTINUE
      DO 955 IM=1,3
      DO 955 JM=1,3
      DO 954 I=1,3
  954 V(I)=COVX(IM,JM,I,1)
      CALL AXV(SROTQ,V)  
      DO 956 I=1,3
  956 COVX(IM,JM,I,1)=V(I)     
  955 CONTINUE
      GO TO 801
C 
C NO DERIV. IN P, 2 IN Q. 
  807 DO 923 IM=1,3
      DO 923 JM=1,3
  923 A(IM,JM)=COVX(1,1,IM,JM)
      CALL ATBA(SROTQ,A,A) 
      DO 924 IM=1,3
      DO 924 JM=1,3
  924 COVX(1,1,IM,JM)=A(IM,JM) 
      GO TO 801
C
C ONE DERIV. IN P, 2 IN Q. 
  808 DO 754 I=1,3
      DO 755 IM=1,3
      DO 755 JM=1,3
  755 A(IM,JM)=COVX(I,1,IM,JM)
      CALL ATBA(SROTQ,A,A)
      DO 756 IM=1,3
      DO 756 JM=1,3
  756 COVX(I,1,IM,JM)=A(IM,JM)
  754 CONTINUE
      DO 975 IM=1,3
      DO 975 JM=1,3
      DO 974 I=1,3
  974 V(I)=COVX(I,1,IM,JM)
      CALL AXV(SROTP,V)  
      DO 976 I=1,3
  976 COVX(I,1,IM,JM)=V(I)     
  975 CONTINUE
      GO TO 801
C 
C 2 DERIV. IN P AND Q. 
  809 DO 540 I=1,3
      DO 540 J=1,3
      DO 555 IM=1,3
      DO 555 JM=1,3
  555 A(IM,JM)=COVX(IM,JM,I,J)
      CALL ATBA(SROTP,A,A) 
      DO 556 IM=1,3
      DO 556 JM=1,3
  556 COVX(IM,JM,I,J)=A(IM,JM) 
  540 CONTINUE
      DO 541 I=1,3
      DO 541 J=1,3 
      DO 565 IM=1,3
      DO 565 JM=1,3
  565 A(IM,JM)=COVX(I,J,IM,JM)
      CALL ATBA(SROTQ,A,A) 
      DO 456 IM=1,3
      DO 456 JM=1,3
  456 COVX(I,J,IM,JM)=A(IM,JM) 
  541 CONTINUE
C 
  801 RETURN
      END 
      SUBROUTINE PAZIM(RLATP,RLONGP,COSLAP,SINLAP,COSLOP,SINLOP,
     *CAZP,SAZP,COSDT,SINDT,LTEST)
C THE SUBROUTINE WILL FROM A POINT WITH LATITUDE AND LONGITUDE
C SPECIFIED IN THE CALL PRODUCE THE CORRESPONDING VALUES IN A
C NEW POINT IN DISTANCE DT  AND AZIMUTH GIVEN BY
C COS AND SIN - CAZP, SAZP.
C PROGRAMMED BY C.C.TSCHERNING, OCT. 92. LAST CHANGE: 2002-10-24. 
      IMPLICIT NONE
      REAL*8 RLATP,RLONGP,COSLAP,SINLAP,COSLOP,SINLOP,CAZP,SAZP,
     *COSDT,SINDT,SIDLON,CODLON,DLONG,RADDEG,DLATP,DLONGP
      LOGICAL LTEST 
      RLONGP=ATAN2(SINLOP,COSLOP)
      SINLAP=COSLAP*SINDT*CAZP+SINLAP*COSDT
      COSLAP=SQRT(1.0D0-SINLAP**2)
      SIDLON=SINDT*SAZP/COSLAP
      CODLON=SQRT(1.0D0-SIDLON**2)
      DLONG=ATAN2(SIDLON,CODLON)
      RLONGP=RLONGP+DLONG
      RLATP=ATAN2(SINLAP,COSLAP)
      COSLOP=COS(RLONGP)
      SINLOP=SIN(RLONGP) 
      RADDEG=180.0D0/3.1415926535D0
      DLATP=RADDEG*RLATP
      DLONGP=RADDEG*RLONGP 
      IF (LTEST) WRITE(*,*)' PAZIM - LAT,LONG=',DLATP,DLONGP 
C
      RETURN
      END 
      DOUBLE PRECISION FUNCTION COZERO(PSI,R,MODEL)
C THE SUBROUTINE WILL EVALUATE A COVARIANCE FUNCTION WHICH 
C IS ZERO AFTER THE DISTANCE (PSI) IS LARGER THAN OR EQUAL TO 2*R.  
C PROGRAMMED APRIL 1996 BY C.C.TSCHERNING, GEOPHYSICAL 
C DEPARTMENT. LAST CHANGE 2002-10-24.  
C     PSI -  SPHERICAL DISTANCE IN RADIANS 
C     R   -  2*R DISTANCE IN RADIANS FOR WHICH FUNCTION IS ZERO.  
C     MODEL - PARAMETER TO DISTINGUISH BETWEEN DIFFERENT MODELS.
C
      IMPLICIT NONE
      REAL*8 D0,D2,D3,PI,PSI2,PSI,PSI3,R2,R,R4
      INTEGER MODEL
C
      PI = 3.1415926535D0
      D0=0.0D0
      D2=2.0D0
      D3=3.0D0
      PSI2=PSI**2
      PSI3=PSI**3
      GO TO (10,20,30) MODEL
  10  R2=R*R
      R4=R2*R2
      IF (PSI.LT.D2*R) THEN
      COZERO= R4*PI*(R2/D3-PSI2/D2)
     *+(R2*(R2*PSI+4.0D0/D3*PSI3)-PSI3*PSI2/12.0D0)/D3
     **SQRT(R2-PSI2/4.0D0)
     *+(R2*R2*(PSI2-D2/D3*R2))*ASIN(PSI/(D2*R))
      ELSE
      COZERO=D0
      END IF
      GO TO 30
  20  COZERO=D0
  30  CONTINUE
      RETURN
      END
      SUBROUTINE FINDC1(PSI1,R,MODEL)
C PROGRAMMED BY CCT, LAST CHANGE 2003-03-18.
      IMPLICIT NONE
      REAL*8 D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,PSI1,R,C0,C1,DPSI,
     *TEST1,TEST2,TEST3,PSI,C2,C3,COZERO
      INTEGER ITCOUN,MODEL,K
      LOGICAL LF,LT
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,ITCOUN,LF,LT
C
      C0= COZERO(D0,R,MODEL)
      PSI=D0
      C1=C0
      DPSI=5.0D-4
      TEST3=D1
  10  PSI= PSI+DPSI
      C2=C1
      C1=COZERO(PSI,R,MODEL)
      TEST1=TEST3
      TEST3=C1/C0
      IF (TEST3.GT.1.0D0.OR.TEST3.LT.D0)
     *WRITE(*,*)' WARNING ',C0,C2,C1
      IF (TEST3.GT.0.5D0) GO TO 10
      DPSI=DPSI/D2
      PSI=PSI-DPSI
      K=0
  50  C3=COZERO(PSI,R,MODEL)
      K=K+1
      TEST2=C3/C0
      DPSI=DPSI/D2
      IF (TEST2.GT.0.5D0.AND.TEST3.LT.0.5D0) THEN
      TEST1=TEST2
      PSI=PSI+DPSI
      ELSE
      TEST3=TEST2
      PSI=PSI-DPSI
      END IF
      IF (K.LT.115.AND.ABS(0.5D0-TEST2).GT.1.0D-8) GO TO 50
      PSI1=PSI
      RETURN
      END
      DOUBLE PRECISION FUNCTION FINDR(PSI1,MODEL)
C THE SUBROUTINE DETERMINES THE VALUE OF A PARAMETER R IN
C A FINITE COVARAINCE FUNCTION.
C PROGRAMMED APRIL 1996 BY C.C.TSCHERNING, DEPARTMENT OF GEOPHYSICS,
C UNIVERSITY OF COPENHAGEN. LAST CHANGE 2002-10-24.
      IMPLICIT NONE
      REAL*8 PI,R0,PSI1,RSTEP,C0,C1,C2,C3,C4,C5,TEST2,TEST3,TEST1,
     *RD0,COZERO
C
      INTEGER MODEL,K
C
      PI=3.1415926535D0
      R0=PSI1*1.2
      RSTEP=0.5*PSI1
      K=0
  40  C0=COZERO(0.0D0,R0,MODEL)
      C1=COZERO(PSI1,R0,MODEL)
C     WRITE(*,30)R0,C0,C1,C1/C0
  30  FORMAT(4D16.9)
      C2=COZERO(0.0D0,R0+RSTEP,MODEL)
      C3=COZERO(PSI1,R0+RSTEP,MODEL)
C     WRITE(*,30)R0+RSTEP,C2,C3,C3/C2
      C4=COZERO(0.0D0,R0-RSTEP,MODEL)
      C5=COZERO(PSI1,R0-RSTEP,MODEL)
C     WRITE(*,30)R0-RSTEP,C4,C5,C5/C4
      TEST2=C1/C0
      TEST3=C3/C2
      TEST1=C5/C4
      RSTEP=RSTEP/2.0D0
      IF (TEST2.LT.0.5.AND.TEST3.GT.0.5) THEN
      R0=R0+RSTEP
      ELSE
      R0=R0-RSTEP
      END IF
      K=K+1
      IF (K.LT.115.AND.ABS(0.5-TEST2).GT.1.0D-8) GO TO 40 
      RD0=R0*180.0/PI
C     WRITE(*,60)K,R0,RD0,TEST2
  60  FORMAT(I5,2F10.6,D15.7)
      FINDR=R0   
      RETURN
      END
      SUBROUTINE SPHARM(SLAT,CLAT,SJLO,CJLO,R,I0,J0,IDIF,LFULL)
C CALCULATION OF THE VALUES AND THE UP TO 2. ORDER DERIVATIVES 
C OF SOLID SPHERICAL HARMONIC FUNCTIONS  Y(I0,J0)(LAT,LON,R) USING
C RECURSION BASED ON Y(I0-1,J0), Y(I0-2,J0)  WHEN J0 .NE. J0.
C OTHERWISE THE RECURSION IS BASED ON Y(I0-1,J0-1) AND
C Y(I0-2,J0-1). THE CALCULATION OF FIRST ORDER DERIVATIVES AT THE
C POLES IS DONE USING A RECURSION FORMULAE, WHERE THE COS(LAT) THE IS 
C ELIMINATED. THE SECOND ORDER DERIVATIVE WITH RESPECT TO X IS AT
C THE POLES CALCULATED USING THE LAPLACE EQUATION.
C PROGRAMMED FEBRUARY 1999  BY C.C.TSCHERNING. LAST CHANGE 2002-10-24.
C REFERENCES:
C TSCHERNING, C.C.: ON THE CHAIN-RULE METHOD FOR COMPUTING POTENTIAL
C DERIVATIVES. MANUSCRIPTA GEODAETICA, VOL. 1, PP. 125-141, 1976.
C TSCHERNING, C.C. AND K.PODER: SOME GEODETIC APPLICATIONS OF CLENSHAW
C SUMMATION. BOLLETINO DI GEODESIA E SCIENZE AFFINI, VOL. XLI, NO. 4,
C PP. 349-375, 1982.
C                 
C VARIABLES AT CALL: SLAT, CLAT: SINE AND COSINE OF LATITUDE, R THE
C SIZE OF THE RADIUS VECTOR, IDIF THE MAXIMAL ORDER OF DIFFERENTIATION
C (UP TO 2),  CJLO, CJLO: COS AND SIN OF J*LONGITUDE,
C LFULL A LOGICAL VARIABLE TRUE IF FULLY NORMALIZED FUNCTIONS 
C ARE USED.
C LAST CHANGE 2000-04-24 BY CCT.
C
      IMPLICIT NONE
      REAL*8 D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,SUMIJ,CCCIJ,
     *SQ2,YS,YC,VV,V1,GS,GC,DDS,
     *DDC,ROOT0,PII,PIM0,PIM1,PIM2,DLP,DLP0,DLP1,DLP2,DAP,DAP0,
     *DAP1,DAP2,DDAP,DDAP0,DDAP1,DDAP2,DDAL0,DDAL1,VI,R,Q,DDAL,
     *RQ,CLAT,SLAT,A,DDAL2,B,PM,Q2,Q3,V,CJLO,SJLO,DDC0,FACT
C
      INTEGER I,I0,IIMAX,J,J0,J1,JOLD,IDIF,IIOLD,K,N,ITCOUN,NSPHAR
C
      PARAMETER (IIMAX=20000,NSPHAR=180)
      LOGICAL LFULL,LSPHAR,LTSPH,LF,LT
C
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,ITCOUN,LF,LT
C     COMMON /CON3/SUMIJ(32761),CCCIJ(32761),
      COMMON /CON3/SUMIJ((NSPHAR+1)**2),CCCIJ((NSPHAR+1)**2),
     *SQ2,YS,YC,VV,V1,GS(3),GC(3),DDS(3,3),
     *DDC(3,3),IIOLD,JOLD,LSPHAR,LTSPH
      COMMON /RRSPH/ROOT0(IIMAX)
C ROOT IS A PRECOMPUTED SQUARE ROOT-TABLE (ROOT0(1)=0 !).
      COMMON /SPHOLD/PII,PIM0,PIM1,PIM2,DLP,DLP0,DLP1,DLP2,DAP,DAP0,
     *DAP1,DAP2,DDAP,DDAP0,DDAP1,DDAP2,DDAL0,DDAL1,VI
      Q=RE/R
      J=J0
      I=I0
      J1=J+1
      IF (I.EQ.J) THEN
      IF (J.NE.(JOLD+1)) WRITE(*,*)' WARNING J '
      PIM2=D0
      PIM1=D0
C     WRITE(*,*)R,SLAT,CLAT,SJLO,CJLO
      IF (IDIF.GT.0) THEN
      DLP0=D0
      DLP1=D0
      DLP2=D0
      DAP0=D0
      DAP1=D0
      IF (IDIF.GT.1) THEN
      DDAL0=D0
      DDAL1=D0
      DDAP1=D0
      DDAP2=D0
      END IF
      END IF
      IF (I.EQ.0) THEN
      PII=Q
      PIM0=PII
      IF (IDIF.GT.0) THEN
      DLP=D0
      DLP0=DLP
      DAP=D0
      DAP0=DAP
      IF (IDIF.GT.1) THEN
      DDAP=D0
      DDAP0=DAP
      DDAL=D0
      DDAL0=DDAL
      END IF
      END IF
      ELSE
      RQ=ROOT0(2*I)/ROOT0(2*I+1)*Q
      IF (IDIF.GT.1) THEN
      DDAP=(CLAT*DDAP-D2*SLAT*DAP-CLAT*PII)*RQ
      DDAP0=DDAP
      DDAL=DAP*RQ
      DDAL0=DDAL
      END IF
      IF (IDIF.GT.0) THEN
      DAP=(-SLAT*PII+CLAT*DAP)*RQ
      DAP0=DAP
      DLP=PII*RQ
      DLP0=DLP
      END IF
      PIM0=PII*CLAT*RQ
      PII=PIM0
      END IF
      ELSE
      IF (J.NE.JOLD.OR.I.NE.(IIOLD+1)) WRITE(*,*)' WARNING I,J '
      A=(2*I-1)/(ROOT0(I+J+1)*ROOT0(I-J+1))*Q
      IF (IDIF.GT.1) THEN
      DDAP2=DDAP1
      DDAP1=DDAP0
      DDAP0=(SLAT*DDAP0+D2*CLAT*DAP0-SLAT*PIM0)*A
      DDAL2=DDAL1
      DDAL1=DDAL0
C CORRECTION 1999-02-28 BY CCT - FORGOTTEM UNTIL 2000-04-25.
C     DDAL0=A*(CLAT*DLP0+SLAT*DDAP0)
      DDAL0=A*(CLAT*DLP0+SLAT*DDAL0)
      END IF
      IF (IDIF.GT.0) THEN
      DAP2=DAP1
      DAP1=DAP0
      DAP0=A*(CLAT*PIM0+SLAT*DAP0)
      DLP2=DLP1
      DLP1=DLP0
      DLP0=A*SLAT*DLP0
      END IF
      PIM2=PIM1
      PIM1=PIM0
      PIM0=A*SLAT*PIM1
      IF (I.GT.J) THEN
      B=-Q**2*ROOT0(I-J)*ROOT0(I+J)/(ROOT0(I-J+1)*ROOT0(I+J+1))
      IF (IDIF.GT.1) THEN
      DDAP0=DDAP0+B*DDAP2
      DDAL0=DDAL0+B*DDAL2
      END IF
      IF (IDIF.GT.0) THEN
      DAP0=DAP0+B*DAP2
      DLP0=DLP0+B*DLP2
      END IF
      PM= B*PIM2
      PIM0=PIM0+PM
      END IF
      END IF
      Q2=Q*Q
      Q3=Q2*Q
      V=PIM0
C     YC=V*Q*CJLO
C     YS=V*Q*SJLO
      YC=V*CJLO
      YS=V*SJLO
      IF (IDIF.GT.0) THEN
      GS(3)=(-I-1)*Q*YS
      GC(3)=(-I-1)*Q*YC
      GC(1)=DLP0*Q*(-SJLO)*J
      GS(1)=DLP0*Q*( CJLO)*J
      GC(2)=DAP0*Q*CJLO
      GS(2)=DAP0*Q*SJLO
      IF (IDIF.GT.1) THEN
      DDC(1,2)=DDAL0*Q2*(-SJLO)*J
      DDS(1,2)=DDAL0*Q2*( CJLO)*J
      DDC(2,1)=DDC(1,2)
      DDS(2,1)=DDS(1,2)
      DDC(1,3)=(-I-2)*Q2*DLP0*(-SJLO)*J
      DDS(1,3)=(-I-2)*Q2*DLP0*( CJLO)*J
      DDC(3,1)=DDC(1,3)
      DDS(3,1)=DDS(1,3)
      DDC(2,2)=(DDAP0+(-I-1)*V)*Q2*CJLO
      DDS(2,2)=(DDAP0+(-I-1)*V)*Q2*SJLO
      DDC(2,3)=(-I-2)*Q2*DAP0*CJLO
      DDS(2,3)=(-I-2)*Q2*DAP0*SJLO
      DDC(3,2)=DDC(2,3)
      DDS(3,2)=DDS(2,3)
      DDC(3,3)=GC(3)*(-I-2)*Q
      DDS(3,3)=GS(3)*(-I-2)*Q
      IF (ABS(CLAT).GT.1.0D-10) THEN
      DDC0=Q2*((-I-1)*V-(SLAT*DAP0+V*J**2/CLAT)/CLAT)
      DDC(1,1)=DDC0*CJLO
      DDS(1,1)=DDC0*SJLO
      ELSE
      DDC(1,1)=-DDC(2,2)-DDC(3,3)
      DDS(1,1)=-DDS(2,2)-DDS(3,3)
      END IF
      END IF
      END IF
      IIOLD=I
      JOLD=J
      IF (LFULL) THEN
C NORMALISATION.
      IF (J.EQ.0) THEN
      FACT= ROOT0(2*I+2)
      ELSE
      FACT= ROOT0(2*I+2)*SQ2
      END IF
      V=V*FACT
      YC=YC*FACT
      YS=YS*FACT
      DO 25, K=1,3
C ERROR 2000-05-02 DETECTED.
      GC(K)=GC(K)*FACT
      GS(K)=GS(K)*FACT
      DO 25, N=1,3
      DDC(K,N)=DDC(K,N)*FACT
      DDS(K,N)=DDS(K,N)*FACT
  25  CONTINUE
C
      END IF
      RETURN
      END
      LOGICAL FUNCTION CHECKC(NPOS)
C USING THE LAPLACE EQUATION TO CHECK TO COVARIANCES.
C PROGRAMMED 2002-10-07 BY C.C.TSCHERNING, LATEST UPDATE: 2005-04-16.
C INPUT:
C  NPOS - CALL - USED TO INDICATE FROM WHERE THE SUBROUTINE IS CALLED.
C  COVX - CSAT - HOLDS COVARIANCES. TWO FIRST SUBSCRIPTS REALTED
C                TO ONE POINT (P) AND THE LAST TWO TO A SECOND POINT (Q).
C                INDEX 1: EAST DERIVATIVE, 2: NORTH DERIVATIVE,
C                3: UP DERIVATIVE (RADIUS VECTOR).
C NDP,NDQ CSAT - NUMBER OF DERIVATIVES IN P, Q, RESPECTIVELY.
C
C OUTPUT
C NWAR - CSAT - NUMBER OF WARNINGS
C IF LOUT IS TRUE, OUTPUT OF LAPLACE EQUATION, SUM OF ABSOLUTE VALUE OF
C    THE 3 TERMS, THE 3 TERMS.
C
      IMPLICIT NONE
      INTEGER I,J,NPOS,NDP,NDQ,NWAR,KSAT,NDX1,NDX2,NCASE,
     *KP,KPP1,IPC
      REAL*8 TEST1,TEST2,TEST4,TEST5,COVX,CIX,CFX,ATEST1,ATEST2,
     *SHIFTS,PW2,BSIZEA,E21,AX1,F1,GM1,GREF,SM,UREF
      LOGICAL LOUT,LTESTS,LX,LNX,CHECK,LF,
     *LSMAL,LADBPR,LADBTE,LNGR
     *,LKSIP,LNCOL,LTNB,LTEB,LOE1,LOE2,LE
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFX,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP,NDQ,NWAR,LX(7,5),LNX(7,5),LTESTS 
C
      COMMON /CINHEA/SHIFTS,PW2,BSIZEA,E21,AX1,F1,GM1,GREF,SM(2200),
     *UREF,KP,KPP1,IPC,
     *LSMAL,LADBPR,LADBTE,LNGR
     *,LKSIP,LNCOL,LTNB,LTEB,LOE1,LOE2,LE
C TRANSFER VARIABLES FROM INHEAD. HERE ONLY PW2 USED.
C
      LOUT=.TRUE.
C     LOUT=NWAR.LT.25
      LF=.FALSE.
      CHECKC=.TRUE.  
      CHECK=.TRUE.
      J=1
      NCASE=NDP+1+NDQ*3
      GO TO (810,810,803,810,810,806,807,808,809),NCASE
C ZERO IN P, 2 IN Q.
 807  TEST1=COVX(1,1,1,1)+COVX(1,1,2,2)+COVX(1,1,3,3)
      ATEST1=ABS(TEST1)
      TEST4=ABS(COVX(1,1,1,1))+ABS(COVX(1,1,2,2))+ABS(COVX(1,1,3,3))
      IF (ATEST1.GT.TEST4*1.0D-4.AND.ATEST1.GT.1.0D-10) THEN
       CHECK=LF
       IF (LOUT)
     * WRITE(*,10)NPOS,I,J,TEST1,TEST4,COVX(1,1,1,1),COVX(1,1,2,2),
     * COVX(1,1,3,3)
       NWAR=NWAR+1
      END IF
      GO TO 810
C
C TWO IN P, ONE IN Q.
 806  DO I=1,3
       TEST2=COVX(1,1,I,1)+COVX(2,2,I,1)+COVX(3,3,I,1)
       ATEST2=ABS(TEST2)
       TEST5=ABS(COVX(1,1,I,1))+ABS(COVX(2,2,I,1))+ABS(COVX(3,3,I,1))
       IF (ATEST2.GT.TEST5*1.0D-4.AND.ATEST2.GT.1.0D-20) THEN
        CHECK=LF
        IF (LOUT)
     *  WRITE(*,10)NPOS,I,J,TEST1,TEST4,COVX(I,J,1,1),COVX(I,J,2,2),
     *  COVX(I,J,3,3)
        NWAR=NWAR+1
       END IF
      END DO
      GO TO 810
C
 803  TEST1=COVX(1,1,1,1)+COVX(2,2,1,1)+COVX(3,3,1,1)
      ATEST1=ABS(TEST1)
      TEST4=ABS(COVX(1,1,1,1))+ABS(COVX(2,2,1,1))+ABS(COVX(3,3,1,1))
      IF (ATEST1.GT.TEST4*1.0D-4.AND.ATEST1.GT.1.0D-10) THEN
       CHECK=LF
       IF (LOUT)
     * WRITE(*,10)NPOS,I,J,TEST1,TEST4,COVX(1,1,1,1),COVX(2,2,1,1),
     * COVX(3,3,1,1)
       NWAR=NWAR+1
      END IF
      GO TO 810
C
C 1 IN P 2 IN Q.
 808  DO I=1,3
      TEST1=COVX(I,1,1,1)+COVX(I,1,2,2)+COVX(I,1,3,3)
      ATEST1=ABS(TEST1)
      TEST4=ABS(COVX(I,1,1,1))+ABS(COVX(I,1,2,2))+ABS(COVX(I,1,3,3))
       IF (ATEST1.GT.TEST4*1.0D-4.AND.ATEST1.GT.1.0D-20) THEN
        CHECK=LF
        IF (LOUT)
     *  WRITE(*,10)NPOS,I,J,TEST1,TEST4,COVX(I,1,1,1),COVX(I,1,2,2),
     *  COVX(I,1,3,3)
        NWAR=NWAR+1
      END IF
      END DO
      GO TO 810
C
C TWO IN BOTH P AND Q.
 809  DO I=1,3
      DO J=1,3
       TEST1=COVX(I,J,1,1)+COVX(I,J,2,2)+COVX(I,J,3,3)
       ATEST1=ABS(TEST1)
       TEST2=COVX(1,1,I,J)+COVX(2,2,I,J)+COVX(3,3,I,J)
       ATEST2=ABS(TEST2)
       TEST4=ABS(COVX(I,J,1,1))+ABS(COVX(I,J,2,2))+ABS(COVX(I,J,3,3))
       TEST5=ABS(COVX(1,1,I,J))+ABS(COVX(2,2,I,J))+ABS(COVX(3,3,I,J))
       IF (ATEST1.GT.TEST4*1.0D-4.AND.ATEST1.GT.PW2*1.0D-3) THEN
        CHECK=LF
        IF (LOUT)
     *  WRITE(*,10)NPOS,I,J,TEST1,TEST4,COVX(I,J,1,1),COVX(I,J,2,2),
     *  COVX(I,J,3,3)
   10   FORMAT(' WARNING  ',I2,2I3,5D12.5)
        NWAR=NWAR+1
       END IF
       IF (ATEST2.GT.TEST5*1.0D-4.AND.ATEST2.GT.PW2*1.0D-3) THEN
        CHECK=LF
        IF (LOUT)
     *  WRITE(*,11)NPOS,I,J,TEST2,TEST5,COVX(1,1,I,J),COVX(2,2,I,J),
     *  COVX(3,3,I,J),CHECK
   11   FORMAT(' WARNING5 ',I2,2I3,5D12.5,L2)
        NWAR=NWAR+1
       END IF
      END DO
      END DO
  810 CHECKC=CHECK
      RETURN
      END
      SUBROUTINE DENDEF(NMAX,LINTER,LWRSOL,LPARAM,
     *LPOT,LBIPOT,LBIN,LINSOL,LDENOL,LSKIPL,RRE)
C THE SUBROUTINE WILL INPUT PARAMETERS FOR AND DEFINE
C A DENSITY MODEL. MOVED FROM MAIN PROGRAM 2004-11-10.
C
C INPUT OF EXPONENT OF WEIGHT FACTOR ON HARMONIC DENSITY,
C RADIUS OF SPHERE WITHIN WICH MASSES ARE LOCATED IN M. CF. REF(F),
C SECTION 3,SALE FACTOR AND VALUE OF LOGICAL VARIABLE LNPOT
C TRUE, IF NEW SET OF COEFFICIENTS ARE TO BE USED FOR THE DENSITY
C COMPUTATIONS, (DIFFERENCES BETWEEN THE ORIGINAL COEFFICIENTS AND
C COEFFICIENTS OF A TOPOGRAPHIC-ISOSTATIC REDUCTION POTENTIAL).
C IF POTENTIAL COEFFICIENTS NOT ALREADY STORED ON BINARY FORM
C (NOT HP9000) ALSO THE NAME OF THE FILE TO BE CONNECTED TO UNIT 3.
C THIS ONLY APPLIES IF LPOT IS TRUE.
      IMPLICIT NONE
      LOGICAL LINTER,LWRSOL,LNCOF,HP9000,LBIN,LFORM,LOCAL,
     *LSUM,LFIRST,LF,LT,LPARAM,LPOT,LBIPOT,LINSOL,LP,LINT,
     *LDENOL,LSKIPL
      CHARACTER*128 FMT(9),PNAME(2)

      INTEGER I,IEHD,ICHAR,IJ1,IJ,MIJ,NCOEFF,ITCOUN,NMAX
C     PARAMETER (NCOEFF=3243602)
      PARAMETER (NCOEFF=4844402)
      REAL*4 COFF
      REAL*8 RRE,DSCALE,CCI,CCR,SIGMA0,SIGMA,HCMAX,
     *CCV,DC,C20IN,G1,G2,CM3,CMM2,CM1,
     *OLDT,OLDR,CFA,D0,D1,D2,D3,D4,D5,RE,RADSEC,
     *PI,GMC,FG,FJ,OMEGA2,FACT
      INTEGER KCI,NC1,NC2,IGP,IORDER
C
      COMMON /CMCOV/CCI(24),CCR(56),SIGMA0(2200),SIGMA(2200),HCMAX,
     *CCV(2,2),DC(36),KCI(37),NC1,NC2,LOCAL,LSUM
      COMMON /GPOTC0/C20IN,G1(3),G2(3,3),CM3,CMM2,CM1
C C20IN HOLDS C20, G1 THE FIRST DERIVATIVES, G2 THE SECOND DERIVATIVES.
C COMMON VARIABLES USED IN COVAX. SEE THIS SUBROUTINE FOR VARIABLES.
      COMMON/GPOTC1/OLDT,OLDR,CFA,IGP(12),LFIRST,HP9000
C COMMON VARIABLES USED IN GPOTDR, SETCM ,LOADCM, PRED AND CXPARM.
      COMMON /GPOTC3/COFF(NCOEFF)
C QUASI NORMALIZED SPHERICAL HARMONIC COEFFICIENTS, UNITLESS.
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GMC,ITCOUN,LF,LT
C COMMON CONSTANTS D0=0.0D0  ETC.
      COMMON /GRAVCC/FG(30),FJ(30),LP(2),OMEGA2,IORDER
C COMMON VARIABLES USED IN GRAVC AND RGRAV, HOLDING I.E. COEFFICI-
C ENTS OF LEGENDRE SERIES OF NORMAL POTENTIAL AND NORMAL GRAVITY
C FORMULA.
C
      ICHAR=1
      IF (LINTER) WRITE(6,*)' INPUT DENSITY SPECIF.' 
  239 FORMAT(I3,2F10.1,L2)
      READ(5,*)IEHD,RRE,DSCALE,LNCOF
      IF (LWRSOL) WRITE(17,239)IEHD,RRE,DSCALE,LNCOF
      KCI(32)=IEHD-1
C THE USED POWER OF R IS ONE SMALLER, BECAUSE R GENERALLY IS RAISED
C TO THE POWER OF I+1.
      CCI(15)=1.5+IEHD/2.0
      CCI(13)=DSCALE/(6.67E-8*PI*RRE**(3-IEHD))
      IF (LPOT) THEN
       IF (.NOT.((LBIN.AND.(.NOT.HP9000)).OR.LBIPOT.OR.
     * LINSOL.OR.LPARAM.OR.LDENOL)) THEN
C
        IF (LINTER) WRITE(6,*)' INPUT NAME OF FILE WITH COEFF.' 
        READ(5,2103)PNAME(1)
        IF (LWRSOL) WRITE(17,2103)(PNAME(I),I=1,ICHAR)
       END IF
       IF (.NOT.LDENOL) THEN
        IF ((.NOT.LPARAM).AND.(.NOT.LBIPOT)) OPEN(3,FILE=PNAME(1),
     *  STATUS='UNKNOWN',FORM='UNFORMATTED')
        IF (.NOT.((LBIN.AND.(.NOT.HP9000).OR.LBIPOT.OR.LINSOL
     *  .OR.LPARAM))) THEN
         WRITE(3)COFF
        END IF
       END IF
       LDENOL=LT
C
       IF (LNCOF)  THEN
C INPUT OF LBIN, TRUE IF THE COEFFICIENTS ARE ON BINARY FORM, LFORM,
C TRUE IF THE FORMAT OF THE COEFFICIENTS ARE INPUT, THE NAME OF THE
C OF THE FILE HOLDING THE COEFFICIENTS AND IF LFORM IS TRUE THE FORMAT.
C
        IF (LINTER) WRITE(6,*)' INPUT BIN, FORM' 
        READ(5,*)LBIN,LFORM
        IF (LWRSOL) WRITE(17,105)LBIN,LFORM 
  105   FORMAT(8L2)
        IF (LINTER) WRITE(6,*)' INPUT NAME OF FILE' 
        READ(5,2103)PNAME(1)
        WRITE(6,241)(PNAME(I),I=1,ICHAR)
  241   FORMAT(' NEW COEFFICIENTS INPUT FROM FILE ',2A128)
        IF (LWRSOL) WRITE(17,2103)(PNAME(I),I=1,ICHAR)
 2103   FORMAT(A128)
        IF (LINTER.AND.LFORM) WRITE(6,*)' INPUT FORMAT' 
        IF (LFORM) READ(5,103)FMT(1) 
  103   FORMAT(I5,I4,2E17.9)
        IF (LWRSOL.AND.LFORM) WRITE(17,103)FMT(1) 
        CALL LOADCS(PNAME,FMT,NMAX,LFORM,LBIN,LINT,LSKIPL)
        IF (.NOT.LBIN) CALL SETCM(NMAX,LINT,LBIN)
       END IF
C
C WE NOW MODIFY THE GM, AX AND OMEGA,  C(0,0), C(2,0), C(4,0) AND C(6,0)
C SO THAT WE WORK IN SPHERICAL APPROXIMATION WITH A DENSITY CONTRAST
C FUNCTION. SEE ALSO REF.(F) SECTION 3. NOTE THET WE USE THE MEAN EARTH
C RADIUS AND NOT THE RADIUS RRE. THIS IS BECAUSE THE ORIGINAL COEF-
C FICIENTS ARE MULTIPLIED WITH THIS.
       CM3=CM3*CCI(13)
       CMM2=RE
       CM1=D0
       COFF(1)=D0
       COFF(5)=COFF(5)-FJ(18)
       COFF(17)=COFF(17)-FJ(20)
       COFF(37)=COFF(37)-FJ(22)
       IJ1=4
       DO IJ=2,NMAX
        IJ1=IJ1+1
        FACT=(IJ+0.5E0)*(IJ+CCI(15))
        COFF(IJ1)=COFF(IJ1)*FACT
        DO MIJ=1,IJ
         COFF(IJ1+1)=COFF(IJ1+1)*FACT
         COFF(IJ1+2)=COFF(IJ1+2)*FACT
         IJ1=IJ1+2
        END DO
       END DO
C
      END IF
      WRITE(6,9776)IEHD,DSCALE,RRE
 9776 FORMAT(' WEIGHT FACTOR ON HARMONIC DENSITIES IS R**(',I3,
     *')*',F10.1,/,' DENSITY DISTRIBUTION IS WITHIN SPHERE WITH ',
     *'RADIUS ',F10.2,' M',/)
      IF (LPOT) WRITE(6,9777)(COFF(IJ),IJ=1,17)
 9777 FORMAT(' HARMONIC COEFFICIENTS FROM C(0,0) TO C(4,0)',/,
     *5(4E15.7,/))
C
      RETURN
      END
c***************************************************
      subroutine QUATMAT(quat)

!     Programmed sept. 2004 by M.L.Veicherts
!      Creates the DCM called ROTMAT from quaternion array input:
!     q = (xi,yj,zk,scalar)

      implicit none
      INTEGER NSAT
      PARAMETER (NSAT=16200)
      real*8 quat(4), ROTMAT,d0,d2
      real*8 q11,q12,q13,q14,q22,q23,q24,q33,q34,q44
      real*8 SR11,SR12,SR13,SR22,COSAZ,SINAZ

      COMMON /ROT/SR11(NSAT),SR12(NSAT),SR13(NSAT),SR22(NSAT),
     *COSAZ(NSAT),SINAZ(NSAT),ROTMAT(3,3) 
C THE COMMON BLOCKS CONTAINS THE ELEMENTS OF THE ROTATION MATRIX
C AND OF THE CURRENT ROTATION MATRIX (SATROT).
      d0 = 0.0d0
      d2 = 2.0d0

      q11 = quat(1) * quat(1)
      q12 = quat(1) * quat(2)
      q13 = quat(1) * quat(3)
      q14 = quat(1) * quat(4)

      q22 = quat(2) * quat(2)
      q23 = quat(2) * quat(3)
      q24 = quat(2) * quat(4)

      q33 = quat(3) * quat(3)
      q34 = quat(3) * quat(4)

      q44 = quat(4) * quat(4)
c   !   From Alenia note: IRF to GRF:

      rotmat(1,1) =  q11 - q22 - q33 + q44
      rotmat(1,2) =  d2 * (q12 + q34)
      rotmat(1,3) =  d2 * (q13 - q24)
      rotmat(2,1) =  d2 * (q12 - q34)
      rotmat(2,2) =  - q11 + q22 - q33 + q44
      rotmat(2,3) =  d2 * (q23 + q14)
      rotmat(3,1) =  d2 * (q13 + q24)
      rotmat(3,2) =  d2 * (q23 - q14)
      rotmat(3,3) =  - q11 - q22 + q33 + q44

      return
      end
c     
      FUNCTION COVPQ(SM,IS,KP,DRM,AAI,IMAX1,LMEAN,LSAT,PREDCO,
     *PREDCP)
C PROGRAMMED  AUG 2005 BY C.C.TSCHERNING. UPDATE: AUG 09, 2005.
C THE FUNCTION COMPUTES THE COVARIANCE OF  TWO SIGNAL QUANTITES OF TYPE
C KP USING COVBX AND COVCX.
      IMPLICIT NONE
      LOGICAL LT,LF,LSUM,LOCAL,LMEAN,LSAT,LTESTS,LX,LNX
      REAL*8 CI,CR,SIGMA0,SIGMA,HMAX,D,D0,D1,D2,D3,D4,D5,RE,RADSEC,
     *PI,GM,STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER,STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q,COVX,CIX,CFA,SM,AAI,DRM,RP,HP,CVV,STEQQN,
     *COMEAN,CP,SP
      REAL*8 PREDCO(13),PREDCP(13),COVPQ,RQ,HQ,SROTP(3,3),SROTQ(3,3),
     *RLATP,RLATQ,SINLOP,SINLOQ,COSLOP,COSLOQ,RLONGQ,RLONGP,CQ,SQ,
     *SD,CD,T
      INTEGER KSAT,KI,N1,N2,NFILTE,NDX1,NDX2,NDP,NDQ,NWAR,IMAX1,
     *KP,IS,ITCOUN,I61,I62
C
      COMMON /CMCOV/CI(24),CR(56),SIGMA0(2200),SIGMA(2200),HMAX,
     *D(40),KI(37),N1,N2,LOCAL,LSUM
      COMMON /DCON/D0,D1,D2,D3,D4,D5,RE,RADSEC,PI,GM,ITCOUN,LF,LT
      COMMON /CMEAN/STEPN,COSSTN,SINSTN,STEPE,COSSTE,SINSTE,
     *COST2P,SINT2P,FILTER(11),NFILTE
      COMMON /CMEAQ/STEQN,COSSQN,SINSQN,STEQE,COSSQE,SINSQE,
     *COST2Q,SINT2Q
      COMMON /CSAT/COVX(3,3,3,3),CIX(7,5),CFA,KSAT(17,2),
     *NDX1(5),NDX2(5),NDP,NDQ,NWAR,LX(7,5),LNX(7,5),LTESTS 
      DIMENSION SM(2200)
C
      CI(8) = AAI
      CI(9) = (RE+DRM)**2
      CI(10)= DRM
      CI(20)= D1
      N1 = IMAX1
      KI(6) = KP
      KI(7) = KP
      HP=PREDCP(7)
      HQ=PREDCO(7)
      RP = RE+HP
      RQ = RE+HQ
      RLATP=PREDCP(1)
      CP=PREDCP(2)
      SP=PREDCP(3)
      RLONGP=PREDCP(4)
      COSLOP=PREDCO(5)
      SINLOP=PREDCP(6)
      RLATQ=PREDCO(1)
      CQ=PREDCO(2)
      SQ=PREDCO(3)
      RLONGQ=PREDCO(4)
      COSLOQ=PREDCO(5)
      SINLOQ=PREDCO(6)
      CD=COS(RLONGP-RLONGQ)
      SD=SIN(RLONGP-RLONGQ)
      T=SP*SQ+CP*CQ*CD
      CALL COVBX(SM,LSAT,IS)
      CR(1) = T 
      CR(2) = HP
      CR(3) = HP
      CR(4) = SP
      CR(5) = SQ
      CR(6) = CP
      CR(7) = CQ
      CR(8) = SD
      CR(9) = CD 
      IF (LSAT) THEN
       CR(10)=D1
       CR(11)=D1
      ELSE
       CR(10)= GM/(RP*RQ)
       CR(11) = CR(10)
      END IF
      IF (.NOT.LMEAN) THEN
       CALL COVCX(SM,CVV,IS,LSAT)
       IF (LSAT) THEN
        DO I61=1,3
         DO I62=1,3
          SROTQ(I61,I62)=PREDCO(7+I61*3+I62)
          SROTP(I61,I62)=PREDCP(7+I61*3+I62)
         END DO
        END DO
        CALL COVROT(SROTP,SROTQ)
        IF (LTESTS) WRITE(*,101)COVX
 101    FORMAT(6D12.4)
        IF (KP.NE.25) THEN
         CVV=COVX(KSAT(KP,1),KSAT(KP,2),KSAT(KP,1),KSAT(KP,2))
        ELSE
C DDT/DXX-DDT/DYY IN P.
         CVV=
     *   (COVX(KSAT(14,1),KSAT(14,2),KSAT(14,1),KSAT(14,2)) 
     *   -COVX(KSAT(12,1),KSAT(12,2),KSAT(14,1),KSAT(14,2)) 
     *   +COVX(KSAT(14,1),KSAT(14,2),KSAT(12,1),KSAT(12,2))
     *    -COVX(KSAT(12,1),KSAT(12,2),KSAT(12,1),KSAT(12,2)))
        END IF
        IF (LTESTS) WRITE(*,100)CVV,KSAT(KP,1),KSAT(KP,2),KP
 100    FORMAT(' CVV, KP ',D14.6,3I3)
       END IF
      ELSE
C NOT FULLY IMPLEMENTED.
       WRITE(*,*)' WARNING: MEAN VALUES NOT IMPLEMENTED '
       STEQQN=STEQN
       STEQN=STEPN
       COSSQN=COSSTN
       SINSQN=SINSTN
       STEQE=STEPE
       COSSQE=COSSTE
       SINSQE=SINSTE 
       COST2Q=COST2P
       SINT2Q=SINT2P 
c     FUNCTION COMEAN(SM,IS,ISP,COSLAP,SINLAP,COSLOP,SINLOP,
c    *COSLAQ,SINLAQ,COSLOQ,SINLOQ,NSTEPP,NSTEPQ,LTABLE,
c    *LCZERO,LTCOV)
       CVV=COMEAN(SM,IS,0,CP,SP,COSLOP,SINLOP,CQ,SQ,
     * COSLOQ,SINLOQ,5,5,LF,LF,LF)    
      END IF 
C CHANGE 2000-04-11 AND 2002-09-30 BY CCT.
      IF (LSAT) THEN
       IF (KP.EQ.6.OR.KP.EQ.7.OR.KP.EQ.2) THEN
       CVV=CVV*1.0D10
C CONVERSION TO MGAL.
C      CVV=CVV*(CR(10)*1.0D5/RADSEC)**2
       ELSE
        IF (KP.GT.7.OR.KP.EQ.5) THEN
C SCALING FOR 2-ORDER DERIVATIVES (TO EU**2).
         CVV=CVV*1.0D18
C SCALING FOR 2*TXY. 2002-11-26.
         IF (KP.EQ.13)CVV=CVV*4.0D0
         IF (LTESTS) WRITE(*,*)' KP, CVV ',KP,CVV
        END IF
       END IF
      END IF
      COVPQ = CVV
C CHANGE 2001-07-15.
      STEQN=STEQQN
      RETURN
      END
