      program g2sur
c
c  program to convert gravsoft grids to surfer ascii format (.grd)
c  
c  (c) Rene Forsberg KMS, Denmark
c  Rio sep 11, 1997
c  updated for UTM july 1999
c
      implicit real*8 (a-h,o-z)
      character*36 ifile,ofile
      parameter (nmax=26000000)
      real*4 c(nmax)
      logical lutm,l9999
      l9999 = .false.
c
      write(*,*) 
     .'input name of inputfile (gravsoft) and outputfile (.grd):'
      write(*,*)
      read(*,'(a)') ifile
      read(*,'(a)') ofile
      open(10,file=ifile)
      open(20,file=ofile,status='unknown')
c
      read(10,*) rfi1,rfi2,rla1,rla2,dfi,dla
      if (abs(rfi1).gt.100.or.abs(rfi2).gt.100) then
        read(10,*) iell,izone
        if (iell.gt.0) write(*,*) '- utm grid assumed ',iell,izone
        if (iell.lt.0) write(*,*) '- polar stereographic assumed'
        lutm = .true.
      else
        lutm = .false.
      endif
      nn = (rfi2-rfi1)/dfi + 1.5
      ne = (rla2-rla1)/dla + 1.5
      write(*,*) nn,ne
      if (nn*ne.gt.nmax) stop '** array too small'
      k = 0
      zmin = 9999.d9
      zmax = -9999.d9
      do 10 i = 1, nn
        read(10,*) (c(j),j=k+1,k+ne)
        do 11 j=k+1,k+ne
          if (j.gt.nmax) stop '*** too small grid, increase nmax ***'
          if (abs(c(j)).ge.9999) then
c            c(j) = 9999
            c(j) = 1.70141e38
            l9999 = .true.
          else
            if (c(j).lt.zmin) zmin = c(j)
            if (c(j).gt.zmax) zmax = c(j)
          endif
11      continue
        k = k+ne
10    continue
c 
      write(*,20) nn,ne,zmin,zmax
20    format(' grid points n e:',2i5,', zmin,zmax =',2f10.2)      
      if (l9999) write(*,*) '- 9999 unknown valuea in file'
c
      if (lutm) then
        write(20,21) ne,nn,nint(rla1),nint(rla2),
     .  nint(rfi1),nint(rfi2),zmin,zmax
21      format('DSAA'/' ',2i4/' ',2i8/' ',2i8.0/' ',2f11.2) 
      else
        write(20,22) ne,nn,rla1,rla2,rfi1,rfi2,zmin,zmax
22      format('DSAA'/' ',2i5/' ',2f11.5/' ',2f11.5/' ',2f11.2) 
      endif
      k = ne*(nn-1)
      do 30 i = 1, nn
        if (l9999) then 
          write(20,26) (c(j),j=k+1,k+ne)
        else
          write(20,25) (c(j),j=k+1,k+ne)
        endif
25      format(/,50(/' ',6f10.3))
26      format(/,50(/' ',5e13.6))
        k = k-ne
30    continue
      end


